import{s as Oe,n as et,o as tt}from"../chunks/scheduler.9039eef2.js";import{S as it,i as lt,g as n,s,r as p,A as st,h as o,f as i,c as a,j as Fe,u as d,x as r,k as Ke,y as at,a as l,v as h,d as m,t as c,w as f}from"../chunks/index.ded8f90d.js";import{C as ke}from"../chunks/CodeBlock.8580f3e8.js";import{H as g}from"../chunks/Heading.f027f30d.js";function nt(Ie){let u,P,V,F,w,K,M,O,y,Ze='<thead><tr><th>Before</th> <th>After DDPO finetuning</th></tr></thead> <tbody><tr><td><div style="text-align: center"><img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/pre_squirrel.png"/></div></td> <td><div style="text-align: center"><img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/post_squirrel.png"/></div></td></tr> <tr><td><div style="text-align: center"><img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/pre_crab.png"/></div></td> <td><div style="text-align: center"><img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/post_crab.png"/></div></td></tr> <tr><td><div style="text-align: center"><img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/pre_starfish.png"/></div></td> <td><div style="text-align: center"><img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/post_starfish.png"/></div></td></tr></tbody>',ee,b,te,T,Ae=`The machinery for finetuning of Stable Diffusion models with reinforcement learning makes heavy use of HuggingFace’s <code>diffusers</code>
library. A reason for  stating this is that getting started requires a bit of familiarity with the <code>diffusers</code> library concepts, mainly two of them - pipelines and schedulers.
Right out of the box (<code>diffusers</code> library), there isn’t a <code>Pipeline</code> nor a <code>Scheduler</code> instance that is suitable for finetuning with reinforcement learning. Some adjustments need to made.`,ie,J,Be=`There is a pipeline interface that is provided by this library that is required to be implemented to be used with the <code>DDPOTrainer</code>, which is the main machinery for fine-tuning Stable Diffusion with reinforcement learning. <strong>Note: Only the StableDiffusion architecture is supported at this point.</strong>
There is a default implementation of this interface that you can use out of the box. Assuming the default implementation is sufficient and/or to get things moving, refer to the training example alongside this guide.`,le,j,Ge="The point of the interface is to fuse the pipeline and the scheduler into one object which allows for minimalness in terms of having the constraints all in one place. The interface was designed in hopes of catering to pipelines and schedulers beyond the examples in this repository and elsewhere at this time of writing. Also the scheduler step is a method of this pipeline interface and this may seem redundant given that the raw scheduler is accessible via the interface but this is the only way to constrain the scheduler step output to an output type befitting of the algorithm at hand (DDPO).",se,v,He='For a more detailed look into the interface and the associated default implementation, go <a href="https://github.com/lvwerra/trl/tree/main/trl/models/modeling_sd_base.py" rel="nofollow">here</a>',ae,U,Se="Note that the default implementation has a LoRA implementation path and a non-LoRA based implementation path. The LoRA flag enabled by default and this can be turned off by passing in the flag to do so. LORA based training is faster and the LORA associated model hyperparameters responsible for model convergence aren’t as finicky as non-LORA based training.",ne,$,Le="Also in addition, there is the expectation of providing a reward function and a prompt function. The reward function is used to evaluate the generated images  and the prompt function is used to generate the prompts that are used to generate the images.",oe,_,re,C,Xe="The <code>ddpo.py</code> script is a working example of using the <code>DDPO</code> trainer to finetune a Stable Diffusion model. This example explicitly configures a small subset of the overall parameters associated with the config object (<code>DDPOConfig</code>).",pe,x,Re="<strong>Note:</strong> one A100 GPU is recommended to get this running. Anything below a A100 will not be able to run this example script and even if it does via relatively smaller sized parameters, the results will most likely be poor.",de,k,Ee='Almost every configuration parameter has a default. There is only one commandline flag argument that is required of the user to get things up and running. The user is expected to have a <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">huggingface user access token</a> that will be used to upload the model post finetuning to HuggingFace hub. The following bash command is to be entered to get things running',he,I,me,Z,Ye="To obtain the documentation of <code>stable_diffusion_tuning.py</code>, please run <code>python stable_diffusion_tuning.py --help</code>",ce,A,Qe="The following are things to keep in mind (The code checks this for you as well) in general while configuring the trainer (beyond the use case of using the example script)",fe,B,ze="<li>The configurable sample batch size (<code>--ddpo_config.sample_batch_size=6</code>) should be greater than or equal to the configurable training batch size (<code>--ddpo_config.train_batch_size=3</code>)</li> <li>The configurable sample batch size (<code>--ddpo_config.sample_batch_size=6</code>) must be divisible by the configurable train batch size (<code>--ddpo_config.train_batch_size=3</code>)</li> <li>The configurable sample batch size (<code>--ddpo_config.sample_batch_size=6</code>) must be divisible by both the configurable gradient accumulation steps (<code>--ddpo_config.train_gradient_accumulation_steps=1</code>) and the configurable accelerator processes count</li>",ue,G,ge,H,Ne="Expect the function to be given a list of lists of the form",we,S,Me,L,We=`and <code>image</code>, <code>prompt</code>, <code>prompt_metadata</code>, <code>rewards</code>, <code>reward_metadata</code> are batched.
The last list in the lists of lists represents the last sample batch. You are likely to want to log this one
While you are free to log however you want the use of <code>wandb</code> or <code>tensorboard</code> is recommended.`,ye,X,be,R,De='<li><code>rewards</code> : The rewards/score is a numerical associated with the generated image and is key to steering the RL process</li> <li><code>reward_metadata</code> : The reward metadata is the metadata associated with the reward. Think of this as extra information payload delivered alongside the reward</li> <li><code>prompt</code> : The prompt is the text that is used to generate the image</li> <li><code>prompt_metadata</code> : The prompt metadata is the metadata associated with the prompt. A situation where this will not be empty is when the reward model comprises of a <a href="https://huggingface.co/docs/transformers/model_doc/flava" rel="nofollow"><code>FLAVA</code></a> setup where questions and ground answers (linked to the generated image) are expected with the generated image (See here: <a href="https://github.com/kvablack/ddpo-pytorch/blob/main/ddpo_pytorch/rewards.py#L45" rel="nofollow">https://github.com/kvablack/ddpo-pytorch/blob/main/ddpo_pytorch/rewards.py#L45</a>)</li> <li><code>image</code> : The image generated by the Stable Diffusion model</li>',Te,E,Ve="Example code for logging sampled images with <code>wandb</code> is given below.",Je,Y,je,Q,ve,z,qe="Assuming you’ve done with all the epochs and have pushed up your model to the hub, you can use the finetuned model as follows",Ue,N,$e,W,_e,D,Pe=`This work is heavily influenced by the repo <a href="https://github.com/kvablack/ddpo-pytorch" rel="nofollow">here</a> and the associated paper <a href="https://arxiv.org/abs/2305.13301" rel="nofollow">Training Diffusion Models
with Reinforcement Learning by Kevin Black, Michael Janner, Yilan Du, Ilya Kostrikov, Sergey Levine</a>.`,Ce,q,xe;return w=new g({props:{title:"Denoising Diffusion Policy Optimization",local:"denoising-diffusion-policy-optimization",headingTag:"h1"}}),M=new g({props:{title:"The why",local:"the-why",headingTag:"h2"}}),b=new g({props:{title:"Getting started with Stable Diffusion finetuning with reinforcement learning",local:"getting-started-with-stable-diffusion-finetuning-with-reinforcement-learning",headingTag:"h2"}}),_=new g({props:{title:"Getting started with examples/scripts/ddpo.py",local:"getting-started-with-examplesscriptsddpopy",headingTag:"h2"}}),I=new ke({props:{code:"cHl0aG9uJTIwZGRwby5weSUyMC0taGZfdXNlcl9hY2Nlc3NfdG9rZW4lMjAlM0N0b2tlbiUzRQ==",highlighted:'<span class="hljs-keyword">python</span> ddpo.<span class="hljs-keyword">py</span> --hf_user_access_token <span class="hljs-symbol">&lt;token&gt;</span>',wrap:!1}}),G=new g({props:{title:"Setting up the image logging hook function",local:"setting-up-the-image-logging-hook-function",headingTag:"h2"}}),S=new ke({props:{code:"JTVCJTVCaW1hZ2UlMkMlMjBwcm9tcHQlMkMlMjBwcm9tcHRfbWV0YWRhdGElMkMlMjByZXdhcmRzJTJDJTIwcmV3YXJkX21ldGFkYXRhJTVEJTJDJTIwLi4uJTVEJTBB",highlighted:`[[image, prompt, prompt_metadata, rewards, reward_metadata], ...]
`,wrap:!1}}),X=new g({props:{title:"Key terms",local:"key-terms",headingTag:"h3"}}),Y=new ke({props:{code:"JTIzJTIwZm9yJTIwbG9nZ2luZyUyMHRoZXNlJTIwaW1hZ2VzJTIwdG8lMjB3YW5kYiUwQSUwQWRlZiUyMGltYWdlX291dHB1dHNfaG9vayhpbWFnZV9kYXRhJTJDJTIwZ2xvYmFsX3N0ZXAlMkMlMjBhY2NlbGVyYXRlX2xvZ2dlciklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBGb3IlMjB0aGUlMjBzYWtlJTIwb2YlMjB0aGlzJTIwZXhhbXBsZSUyQyUyMHdlJTIwb25seSUyMGNhcmUlMjBhYm91dCUyMHRoZSUyMGxhc3QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMCUyMyUyMGhlbmNlJTIwd2UlMjBleHRyYWN0JTIwdGhlJTIwbGFzdCUyMGVsZW1lbnQlMjBvZiUyMHRoZSUyMGxpc3QlMEElMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjAlN0IlN0QlMEElMjAlMjAlMjAlMjBpbWFnZXMlMkMlMjBwcm9tcHRzJTJDJTIwXyUyQyUyMHJld2FyZHMlMkMlMjBfJTIwJTNEJTIwaW1hZ2VfZGF0YSU1Qi0xJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyQyUyMGltYWdlJTIwaW4lMjBlbnVtZXJhdGUoaW1hZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBpbCUyMCUzRCUyMEltYWdlLmZyb21hcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoaW1hZ2UuY3B1KCkubnVtcHkoKS50cmFuc3Bvc2UoMSUyQyUyMDIlMkMlMjAwKSUyMColMjAyNTUpLmFzdHlwZShucC51aW50OCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlsJTIwJTNEJTIwcGlsLnJlc2l6ZSgoMjU2JTJDJTIwMjU2KSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXN1bHQlNUJmJTIyJTdCcHJvbXB0cyU1QmklNUQlM0EuMjUlN0QlMjAlN0MlMjAlN0JyZXdhcmRzJTVCaSU1RCUzQS4yZiU3RCUyMiU1RCUyMCUzRCUyMCU1QnBpbCU1RCUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdGVfbG9nZ2VyLmxvZ19pbWFnZXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlcCUzRGdsb2JhbF9zdGVwJTJDJTBBJTIwJTIwJTIwJTIwKSUwQQ==",highlighted:`<span class="hljs-comment"># for logging these images to wandb</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">image_outputs_hook</span>(<span class="hljs-params">image_data, global_step, accelerate_logger</span>):
    <span class="hljs-comment"># For the sake of this example, we only care about the last batch</span>
    <span class="hljs-comment"># hence we extract the last element of the list</span>
    result = {}
    images, prompts, _, rewards, _ = image_data[-<span class="hljs-number">1</span>]
    <span class="hljs-keyword">for</span> i, image <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(images):
        pil = Image.fromarray(
            (image.cpu().numpy().transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>) * <span class="hljs-number">255</span>).astype(np.uint8)
        )
        pil = pil.resize((<span class="hljs-number">256</span>, <span class="hljs-number">256</span>))
        result[<span class="hljs-string">f&quot;<span class="hljs-subst">{prompts[i]:<span class="hljs-number">.25</span>}</span> | <span class="hljs-subst">{rewards[i]:<span class="hljs-number">.2</span>f}</span>&quot;</span>] = [pil]
    accelerate_logger.log_images(
        result,
        step=global_step,
    )
`,wrap:!1}}),Q=new g({props:{title:"Using the finetuned model",local:"using-the-finetuned-model",headingTag:"h3"}}),N=new ke({props:{code:"JTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwRGVmYXVsdEREUE9TdGFibGVEaWZmdXNpb25QaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGVmYXVsdEREUE9TdGFibGVEaWZmdXNpb25QaXBlbGluZSglMjJtZXRyaWMtc3BhY2UlMkZkZHBvLWZpbmV0dW5lZC1zZC1tb2RlbCUyMiklMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEElMEElMjMlMjBtZW1vcnklMjBvcHRpbWl6YXRpb24lMEFwaXBlbGluZS52YWUudG8oZGV2aWNlJTJDJTIwdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZS50ZXh0X2VuY29kZXIudG8oZGV2aWNlJTJDJTIwdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZS51bmV0LnRvKGRldmljZSUyQyUyMHRvcmNoLmZsb2F0MTYpJTBBJTBBcHJvbXB0cyUyMCUzRCUyMCU1QiUyMnNxdWlycmVsJTIyJTJDJTIwJTIyY3JhYiUyMiUyQyUyMCUyMnN0YXJmaXNoJTIyJTJDJTIwJTIyd2hhbGUlMjIlMkMlMjJzcG9uZ2UlMjIlMkMlMjAlMjJwbGFua3RvbiUyMiU1RCUwQXJlc3VsdHMlMjAlM0QlMjBwaXBlbGluZShwcm9tcHRzKSUwQSUwQWZvciUyMHByb21wdCUyQyUyMGltYWdlJTIwaW4lMjB6aXAocHJvbXB0cyUyQ3Jlc3VsdHMuaW1hZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlLnNhdmUoZiUyMiU3QnByb21wdCU3RC5wbmclMjIpJTBB",highlighted:`
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DefaultDDPOStableDiffusionPipeline

pipeline = DefaultDDPOStableDiffusionPipeline(<span class="hljs-string">&quot;metric-space/ddpo-finetuned-sd-model&quot;</span>)

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)

<span class="hljs-comment"># memory optimization</span>
pipeline.vae.to(device, torch.float16)
pipeline.text_encoder.to(device, torch.float16)
pipeline.unet.to(device, torch.float16)

prompts = [<span class="hljs-string">&quot;squirrel&quot;</span>, <span class="hljs-string">&quot;crab&quot;</span>, <span class="hljs-string">&quot;starfish&quot;</span>, <span class="hljs-string">&quot;whale&quot;</span>,<span class="hljs-string">&quot;sponge&quot;</span>, <span class="hljs-string">&quot;plankton&quot;</span>]
results = pipeline(prompts)

<span class="hljs-keyword">for</span> prompt, image <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(prompts,results.images):
    image.save(<span class="hljs-string">f&quot;<span class="hljs-subst">{prompt}</span>.png&quot;</span>)
`,wrap:!1}}),W=new g({props:{title:"Credits",local:"credits",headingTag:"h2"}}),{c(){u=n("meta"),P=s(),V=n("p"),F=s(),p(w.$$.fragment),K=s(),p(M.$$.fragment),O=s(),y=n("table"),y.innerHTML=Ze,ee=s(),p(b.$$.fragment),te=s(),T=n("p"),T.innerHTML=Ae,ie=s(),J=n("p"),J.innerHTML=Be,le=s(),j=n("p"),j.textContent=Ge,se=s(),v=n("p"),v.innerHTML=He,ae=s(),U=n("p"),U.textContent=Se,ne=s(),$=n("p"),$.textContent=Le,oe=s(),p(_.$$.fragment),re=s(),C=n("p"),C.innerHTML=Xe,pe=s(),x=n("p"),x.innerHTML=Re,de=s(),k=n("p"),k.innerHTML=Ee,he=s(),p(I.$$.fragment),me=s(),Z=n("p"),Z.innerHTML=Ye,ce=s(),A=n("p"),A.textContent=Qe,fe=s(),B=n("ul"),B.innerHTML=ze,ue=s(),p(G.$$.fragment),ge=s(),H=n("p"),H.textContent=Ne,we=s(),p(S.$$.fragment),Me=s(),L=n("p"),L.innerHTML=We,ye=s(),p(X.$$.fragment),be=s(),R=n("ul"),R.innerHTML=De,Te=s(),E=n("p"),E.innerHTML=Ve,Je=s(),p(Y.$$.fragment),je=s(),p(Q.$$.fragment),ve=s(),z=n("p"),z.textContent=qe,Ue=s(),p(N.$$.fragment),$e=s(),p(W.$$.fragment),_e=s(),D=n("p"),D.innerHTML=Pe,Ce=s(),q=n("p"),this.h()},l(e){const t=st("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(i),P=a(e),V=o(e,"P",{}),Fe(V).forEach(i),F=a(e),d(w.$$.fragment,e),K=a(e),d(M.$$.fragment,e),O=a(e),y=o(e,"TABLE",{"data-svelte-h":!0}),r(y)!=="svelte-k42nnq"&&(y.innerHTML=Ze),ee=a(e),d(b.$$.fragment,e),te=a(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1ut0u9"&&(T.innerHTML=Ae),ie=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-xp6gwm"&&(J.innerHTML=Be),le=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-a4w6o0"&&(j.textContent=Ge),se=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-t0ve8a"&&(v.innerHTML=He),ae=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1s71aap"&&(U.textContent=Se),ne=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1e16bv7"&&($.textContent=Le),oe=a(e),d(_.$$.fragment,e),re=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1cfw9tr"&&(C.innerHTML=Xe),pe=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-xqnbvi"&&(x.innerHTML=Re),de=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1iay88v"&&(k.innerHTML=Ee),he=a(e),d(I.$$.fragment,e),me=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-mmabua"&&(Z.innerHTML=Ye),ce=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-gn7d4"&&(A.textContent=Qe),fe=a(e),B=o(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-1wxt0fz"&&(B.innerHTML=ze),ue=a(e),d(G.$$.fragment,e),ge=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-171n2tq"&&(H.textContent=Ne),we=a(e),d(S.$$.fragment,e),Me=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-qc0duo"&&(L.innerHTML=We),ye=a(e),d(X.$$.fragment,e),be=a(e),R=o(e,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-hf6txl"&&(R.innerHTML=De),Te=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1r6a60u"&&(E.innerHTML=Ve),Je=a(e),d(Y.$$.fragment,e),je=a(e),d(Q.$$.fragment,e),ve=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-eqxomu"&&(z.textContent=qe),Ue=a(e),d(N.$$.fragment,e),$e=a(e),d(W.$$.fragment,e),_e=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-13vwnt7"&&(D.innerHTML=Pe),Ce=a(e),q=o(e,"P",{}),Fe(q).forEach(i),this.h()},h(){Ke(u,"name","hf:doc:metadata"),Ke(u,"content",ot)},m(e,t){at(document.head,u),l(e,P,t),l(e,V,t),l(e,F,t),h(w,e,t),l(e,K,t),h(M,e,t),l(e,O,t),l(e,y,t),l(e,ee,t),h(b,e,t),l(e,te,t),l(e,T,t),l(e,ie,t),l(e,J,t),l(e,le,t),l(e,j,t),l(e,se,t),l(e,v,t),l(e,ae,t),l(e,U,t),l(e,ne,t),l(e,$,t),l(e,oe,t),h(_,e,t),l(e,re,t),l(e,C,t),l(e,pe,t),l(e,x,t),l(e,de,t),l(e,k,t),l(e,he,t),h(I,e,t),l(e,me,t),l(e,Z,t),l(e,ce,t),l(e,A,t),l(e,fe,t),l(e,B,t),l(e,ue,t),h(G,e,t),l(e,ge,t),l(e,H,t),l(e,we,t),h(S,e,t),l(e,Me,t),l(e,L,t),l(e,ye,t),h(X,e,t),l(e,be,t),l(e,R,t),l(e,Te,t),l(e,E,t),l(e,Je,t),h(Y,e,t),l(e,je,t),h(Q,e,t),l(e,ve,t),l(e,z,t),l(e,Ue,t),h(N,e,t),l(e,$e,t),h(W,e,t),l(e,_e,t),l(e,D,t),l(e,Ce,t),l(e,q,t),xe=!0},p:et,i(e){xe||(m(w.$$.fragment,e),m(M.$$.fragment,e),m(b.$$.fragment,e),m(_.$$.fragment,e),m(I.$$.fragment,e),m(G.$$.fragment,e),m(S.$$.fragment,e),m(X.$$.fragment,e),m(Y.$$.fragment,e),m(Q.$$.fragment,e),m(N.$$.fragment,e),m(W.$$.fragment,e),xe=!0)},o(e){c(w.$$.fragment,e),c(M.$$.fragment,e),c(b.$$.fragment,e),c(_.$$.fragment,e),c(I.$$.fragment,e),c(G.$$.fragment,e),c(S.$$.fragment,e),c(X.$$.fragment,e),c(Y.$$.fragment,e),c(Q.$$.fragment,e),c(N.$$.fragment,e),c(W.$$.fragment,e),xe=!1},d(e){e&&(i(P),i(V),i(F),i(K),i(O),i(y),i(ee),i(te),i(T),i(ie),i(J),i(le),i(j),i(se),i(v),i(ae),i(U),i(ne),i($),i(oe),i(re),i(C),i(pe),i(x),i(de),i(k),i(he),i(me),i(Z),i(ce),i(A),i(fe),i(B),i(ue),i(ge),i(H),i(we),i(Me),i(L),i(ye),i(be),i(R),i(Te),i(E),i(Je),i(je),i(ve),i(z),i(Ue),i($e),i(_e),i(D),i(Ce),i(q)),i(u),f(w,e),f(M,e),f(b,e),f(_,e),f(I,e),f(G,e),f(S,e),f(X,e),f(Y,e),f(Q,e),f(N,e),f(W,e)}}}const ot='{"title":"Denoising Diffusion Policy Optimization","local":"denoising-diffusion-policy-optimization","sections":[{"title":"The why","local":"the-why","sections":[],"depth":2},{"title":"Getting started with Stable Diffusion finetuning with reinforcement learning","local":"getting-started-with-stable-diffusion-finetuning-with-reinforcement-learning","sections":[],"depth":2},{"title":"Getting started with examples/scripts/ddpo.py","local":"getting-started-with-examplesscriptsddpopy","sections":[],"depth":2},{"title":"Setting up the image logging hook function","local":"setting-up-the-image-logging-hook-function","sections":[{"title":"Key terms","local":"key-terms","sections":[],"depth":3},{"title":"Using the finetuned model","local":"using-the-finetuned-model","sections":[],"depth":3}],"depth":2},{"title":"Credits","local":"credits","sections":[],"depth":2}],"depth":1}';function rt(Ie){return tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ct extends it{constructor(u){super(),lt(this,u,rt,nt,Oe,{})}}export{ct as component};
