import{s as te,o as ne,n as Me}from"../chunks/scheduler.aec39e6a.js";import{S as ie,i as oe,e as M,s as t,c as r,h as pe,a as i,d as s,b as n,f as se,g as c,j as o,k as ae,l as re,m as a,n as J,t as w,o as j,p as h}from"../chunks/index.4ee0a2d0.js";import{T as ce}from"../chunks/Tip.e2132029.js";import{C as Je,H as zl,E as we}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.482b5b4f.js";import{C as D}from"../chunks/CodeBlock.2c0716f1.js";function je(O){let p,y='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/hub-docs/tree/main/notebooks/sagemaker-sdk/evaluate-llm-lighteval/sagemaker-notebook.ipynb" rel="nofollow">here</a>!';return{c(){p=M("p"),p.innerHTML=y},l(T){p=i(T,"P",{"data-svelte-h":!0}),o(p)!=="svelte-l9qsnl"&&(p.innerHTML=y)},m(T,P){a(T,p,P)},p:Me,d(T){T&&s(p)}}}function he(O){let p,y,T,P,d,ll,u,el,I,xl='In this sagemaker example, we are going to learn how to evaluate LLMs using Hugging Face <a href="https://github.com/huggingface/lighteval/tree/main" rel="nofollow">lighteval</a>.  LightEval is a lightweight LLM evaluation suite that powers <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Hugging Face Open LLM Leaderboard</a>.',sl,U,Xl="Evaluating LLMs is crucial for understanding their capabilities and limitations, yet it poses significant challenges due to their complex and opaque nature. LightEval facilitates this evaluation process by enabling LLMs to be assessed on acamedic benchmarks like MMLU or IFEval, providing a structured approach to gauge their performance across diverse tasks.",al,b,El="In Detail you will learn how to:",tl,g,_l="<li>Setup Development Environment</li> <li>Prepare the evaluation configuraiton</li> <li>Evaluate Zephyr 7B on TruthfulQA on Amazon SageMaker</li>",nl,f,Ml,A,Nl='If you are going to use Sagemaker in a local environment. You need access to an IAM Role with the required permissions for Sagemaker. You can find <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">here</a> more about it.',il,Z,ol,v,pl,B,Ql='<a href="https://github.com/huggingface/lighteval/tree/main" rel="nofollow">LightEval</a> includes script to evaluate LLMs on common benchmarks like MMLU, Truthfulqa, IFEval, and more. It is used to evaluate models on the <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Hugging Face Open LLM Leaderboard</a>. lighteval isy built on top of the great <a href="https://github.com/EleutherAI/lm-evaluation-harness" rel="nofollow">Eleuther AI Harness</a> with some additional features and improvements.',rl,C,Yl='You can find all available benchmarks <a href="https://github.com/huggingface/lighteval/blob/main/examples/tasks/all_tasks.txt" rel="nofollow">here</a>.',cl,k,Fl='We are going to use Amazon SageMaker Managed Training to evaluate the model. Therefore we will leverage the script available in <a href="https://github.com/huggingface/lighteval/blob/main/run_evals_accelerate.py" rel="nofollow">lighteval</a>. The Hugging Face DLC is not having lighteval installed. This means need to provide a <code>requirements.txt</code> file to install the required dependencies.',Jl,G,Rl="First lets load the <code>run_evals_accelerate.py</code> script and create a <code>requirements.txt</code> file with the required dependencies.",wl,W,jl,H,Vl="In lighteval, the evaluation is done by running the <code>run_evals_accelerate.py</code> script. The script takes a <code>task</code> argument which is defined as <code>suite|task|num_few_shot|{0 or 1 to automatically reduce num_few_shot if prompt is too long}</code>. Alternatively, you can also provide a path to a txt file with the tasks you want to evaluate the model on, which we are going to do. This makes it easier for you to extend the evaluation to other benchmarks.",hl,z,$l='We are going to evaluate the model on the Truthfulqa benchmark with 0 few-shot examples. <a href="https://paperswithcode.com/dataset/truthfulqa" rel="nofollow">TruthfulQA</a> is a benchmark designed to measure whether a language model generates truthful answers to questions, encompassing 817 questions across 38 categories including health, law, finance, and politics​​.',Tl,x,ml,X,Ll='To evaluate a model on all the benchmarks of the Open LLM Leaderboard you can copy this <a href="https://github.com/huggingface/lighteval/blob/v0.2.0/tasks_examples/open_llm_leaderboard_tasks.txt" rel="nofollow">file</a>',yl,E,dl,_,Sl='In this example we are going to evaluate the <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow">HuggingFaceH4/zephyr-7b-beta</a> on the MMLU benchmark, which is part of the Open LLM Leaderboard.',ul,N,ql="In addition to the <code>task</code> argument we need to define:",Il,Q,Dl="<li><code>model_args</code>: Hugging Face Model ID or path, defined as <code>pretrained=HuggingFaceH4/zephyr-7b-beta</code></li> <li><code>model_dtype</code>: The model data type, defined as <code>bfloat16</code>, <code>float16</code> or <code>float32</code></li> <li><code>output_dir</code>: The directory where the evaluation results will be saved, e.g. <code>/opt/ml/model</code></li>",Ul,Y,Pl='Lightevals can also evaluat peft models or use <code>chat_templates</code> you find more about it <a href="https://github.com/huggingface/lighteval/blob/v0.2.0/run_evals_accelerate.py" rel="nofollow">here</a>.',bl,F,gl,R,Kl="We can now start our evaluation job, with the <code>.fit()</code>.",fl,V,Al,$,Ol="After the evaluation job is finished, we can download the evaluation results from the S3 bucket. Lighteval will save the results and generations in the <code>output_dir</code>. The results are savedas json and include detailed information about each task and the model’s performance. The results are available in the <code>results</code> key.",Zl,L,vl,S,le=`In our test we achieved a <code>mc1</code> score of 40.6% and an <code>mc2</code> score of 57.47%. The <code>mc2</code> is the score used in the Open LLM Leaderboard. Zephyr 7B achieved a <code>mc2</code> score of 57.47% on the TruthfulQA benchmark, which is identical to the score on the Open LLM Leaderboard.
The evaluation on Truthfulqa took <code>999 seconds</code>. The ml.g5.4xlarge instance we used costs <code>$2.03 per hour</code> for on-demand usage. As a result, the total cost for evaluating Zephyr 7B on Truthfulqa was <code>$0.56</code>.`,Bl,Cl,kl,m,Gl,q,Wl,K,Hl;return d=new Je({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),u=new zl({props:{title:"Evaluate LLMs with Hugging Face Lighteval on Amazon SageMaker",local:"evaluate-llms-with-hugging-face-lighteval-on-amazon-sagemaker",headingTag:"h1"}}),f=new D({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzYWdlbWFrZXIlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0",highlighted:"!pip install sagemaker --upgrade --quiet",wrap:!1}}),Z=new D({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEFzZXNzJTIwJTNEJTIwc2FnZW1ha2VyLlNlc3Npb24oKSUwQSUyMyUyMHNhZ2VtYWtlciUyMHNlc3Npb24lMjBidWNrZXQlMjAtJTNFJTIwdXNlZCUyMGZvciUyMHVwbG9hZGluZyUyMGRhdGElMkMlMjBtb2RlbHMlMjBhbmQlMjBsb2dzJTBBJTIzJTIwc2FnZW1ha2VyJTIwd2lsbCUyMGF1dG9tYXRpY2FsbHklMjBjcmVhdGUlMjB0aGlzJTIwYnVja2V0JTIwaWYlMjBpdCUyMG5vdCUyMGV4aXN0cyUwQXNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUzRE5vbmUlMEFpZiUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMGlzJTIwTm9uZSUyMGFuZCUyMHNlc3MlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzZXQlMjB0byUyMGRlZmF1bHQlMjBidWNrZXQlMjBpZiUyMGElMjBidWNrZXQlMjBuYW1lJTIwaXMlMjBub3QlMjBnaXZlbiUwQSUyMCUyMCUyMCUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMCUzRCUyMHNlc3MuZGVmYXVsdF9idWNrZXQoKSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMHJvbGUlMjAlM0QlMjBzYWdlbWFrZXIuZ2V0X2V4ZWN1dGlvbl9yb2xlKCklMEFleGNlcHQlMjBWYWx1ZUVycm9yJTNBJTBBJTIwJTIwJTIwJTIwaWFtJTIwJTNEJTIwYm90bzMuY2xpZW50KCdpYW0nKSUwQSUyMCUyMCUyMCUyMHJvbGUlMjAlM0QlMjBpYW0uZ2V0X3JvbGUoUm9sZU5hbWUlM0Qnc2FnZW1ha2VyX2V4ZWN1dGlvbl9yb2xlJyklNUInUm9sZSclNUQlNUInQXJuJyU1RCUwQSUwQXNlc3MlMjAlM0QlMjBzYWdlbWFrZXIuU2Vzc2lvbihkZWZhdWx0X2J1Y2tldCUzRHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCklMEElMEFwcmludChmJTIyc2FnZW1ha2VyJTIwcm9sZSUyMGFybiUzQSUyMCU3QnJvbGUlN0QlMjIpJTBBcHJpbnQoZiUyMnNhZ2VtYWtlciUyMGJ1Y2tldCUzQSUyMCU3QnNlc3MuZGVmYXVsdF9idWNrZXQoKSU3RCUyMiklMEFwcmludChmJTIyc2FnZW1ha2VyJTIwc2Vzc2lvbiUyMHJlZ2lvbiUzQSUyMCU3QnNlc3MuYm90b19yZWdpb25fbmFtZSU3RCUyMik=",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3
sess = sagemaker.Session()
<span class="hljs-comment"># sagemaker session bucket -&gt; used for uploading data, models and logs</span>
<span class="hljs-comment"># sagemaker will automatically create this bucket if it not exists</span>
sagemaker_session_bucket=<span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> sagemaker_session_bucket <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sess <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    <span class="hljs-comment"># set to default bucket if a bucket name is not given</span>
    sagemaker_session_bucket = sess.default_bucket()

<span class="hljs-keyword">try</span>:
    role = sagemaker.get_execution_role()
<span class="hljs-keyword">except</span> ValueError:
    iam = boto3.client(<span class="hljs-string">&#x27;iam&#x27;</span>)
    role = iam.get_role(RoleName=<span class="hljs-string">&#x27;sagemaker_execution_role&#x27;</span>)[<span class="hljs-string">&#x27;Role&#x27;</span>][<span class="hljs-string">&#x27;Arn&#x27;</span>]

sess = sagemaker.Session(default_bucket=sagemaker_session_bucket)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker role arn: <span class="hljs-subst">{role}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker bucket: <span class="hljs-subst">{sess.default_bucket()}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker session region: <span class="hljs-subst">{sess.boto_region_name}</span>&quot;</span>)`,wrap:!1}}),v=new zl({props:{title:"2. Prepare the evaluation configuraiton",local:"2-prepare-the-evaluation-configuraiton",headingTag:"h2"}}),W=new D({props:{code:"aW1wb3J0JTIwb3MlMjAlMEFpbXBvcnQlMjByZXF1ZXN0cyUyMGFzJTIwciUwQSUwQWxpZ2h0ZXZhbF92ZXJzaW9uJTIwJTNEJTIwJTIyMC4yLjAlMjIlMEElMEElMjMlMjBjcmVhdGUlMjBzY3JpcHRzJTIwZGlyZWN0b3J5JTIwaWYlMjBub3QlMjBleGlzdHMlMEFvcy5tYWtlZGlycyglMjJzY3JpcHRzJTIyJTJDJTIwZXhpc3Rfb2slM0RUcnVlKSUwQSUwQSUyMyUyMGxvYWQlMjBjdXN0b20lMjBzY3JpcHRzJTIwZnJvbSUyMGdpdCUwQXJhd19naXRodWJfdXJsJTIwJTNEJTIwZiUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRmh1Z2dpbmdmYWNlJTJGbGlnaHRldmFsJTJGdiU3QmxpZ2h0ZXZhbF92ZXJzaW9uJTdEJTJGcnVuX2V2YWxzX2FjY2VsZXJhdGUucHklMjIlMEFyZXMlMjAlM0QlMjByLmdldChyYXdfZ2l0aHViX3VybCklMEF3aXRoJTIwb3BlbiglMjJzY3JpcHRzJTJGcnVuX2V2YWxzX2FjY2VsZXJhdGUucHklMjIlMkMlMjAlMjJ3JTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGYud3JpdGUocmVzLnRleHQpJTBBJTIwJTIwJTIwJTIwJTBBJTIzJTIwd3JpdGUlMjByZXF1aXJlbWVudHMudHh0JTIwJTIwJTIwJTIwJTBBd2l0aCUyMG9wZW4oJTIyc2NyaXB0cyUyRnJlcXVpcmVtZW50cy50eHQlMjIlMkMlMjAlMjJ3JTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGYud3JpdGUoZiUyMmxpZ2h0ZXZhbCUzRCUzRCU3QmxpZ2h0ZXZhbF92ZXJzaW9uJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> os 
<span class="hljs-keyword">import</span> requests <span class="hljs-keyword">as</span> r

lighteval_version = <span class="hljs-string">&quot;0.2.0&quot;</span>

<span class="hljs-comment"># create scripts directory if not exists</span>
os.makedirs(<span class="hljs-string">&quot;scripts&quot;</span>, exist_ok=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># load custom scripts from git</span>
raw_github_url = <span class="hljs-string">f&quot;https://raw.githubusercontent.com/huggingface/lighteval/v<span class="hljs-subst">{lighteval_version}</span>/run_evals_accelerate.py&quot;</span>
res = r.get(raw_github_url)
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;scripts/run_evals_accelerate.py&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
    f.write(res.text)
    
<span class="hljs-comment"># write requirements.txt    </span>
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;scripts/requirements.txt&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
    f.write(<span class="hljs-string">f&quot;lighteval==<span class="hljs-subst">{lighteval_version}</span>&quot;</span>)`,wrap:!1}}),x=new D({props:{code:"d2l0aCUyMG9wZW4oJTIyc2NyaXB0cyUyRnRhc2tzLnR4dCUyMiUyQyUyMCUyMnclMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwZi53cml0ZShmJTIybGlnaHRldmFsJTdDdHJ1dGhmdWxxYSUzQW1jJTdDMCU3QzAlMjIp",highlighted:`<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;scripts/tasks.txt&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
    f.write(<span class="hljs-string">f&quot;lighteval|truthfulqa:mc|0|0&quot;</span>)`,wrap:!1}}),E=new zl({props:{title:"3. Evaluate Zephyr 7B on TruthfulQA on Amazon SageMaker",local:"3-evaluate-zephyr-7b-on-truthfulqa-on-amazon-sagemaker",headingTag:"h2"}}),F=new D({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFace

<span class="hljs-comment"># hyperparameters, which are passed into the training job</span>
hyperparameters = {
  <span class="hljs-string">&#x27;model_args&#x27;</span>: <span class="hljs-string">&quot;pretrained=HuggingFaceH4/zephyr-7b-beta&quot;</span>, <span class="hljs-comment"># Hugging Face Model ID</span>
  <span class="hljs-string">&#x27;task&#x27;</span>: <span class="hljs-string">&#x27;tasks.txt&#x27;</span>,  <span class="hljs-comment"># &#x27;lighteval|truthfulqa:mc|0|0&#x27;, </span>
  <span class="hljs-string">&#x27;model_dtype&#x27;</span>: <span class="hljs-string">&#x27;bfloat16&#x27;</span>, <span class="hljs-comment"># Torch dtype to load model weights</span>
  <span class="hljs-string">&#x27;output_dir&#x27;</span>: <span class="hljs-string">&#x27;/opt/ml/model&#x27;</span> <span class="hljs-comment"># Directory, which sagemaker uploads to s3 after training</span>
}

<span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
    entry_point          = <span class="hljs-string">&#x27;run_evals_accelerate.py&#x27;</span>,      <span class="hljs-comment"># train script</span>
    source_dir           = <span class="hljs-string">&#x27;scripts&#x27;</span>,         <span class="hljs-comment"># directory which includes all the files needed for training</span>
    instance_type        = <span class="hljs-string">&#x27;ml.g5.4xlarge&#x27;</span>,   <span class="hljs-comment"># instances type used for the training job</span>
    instance_count       = <span class="hljs-number">1</span>,                 <span class="hljs-comment"># the number of instances used for training</span>
    base_job_name        = <span class="hljs-string">&quot;lighteval&quot;</span>,          <span class="hljs-comment"># the name of the training job</span>
    role                 = role,              <span class="hljs-comment"># Iam role used in training job to access AWS ressources, e.g. S3</span>
    volume_size          = <span class="hljs-number">300</span>,               <span class="hljs-comment"># the size of the EBS volume in GB</span>
    transformers_version = <span class="hljs-string">&#x27;4.36&#x27;</span>,            <span class="hljs-comment"># the transformers version used in the training job</span>
    pytorch_version      = <span class="hljs-string">&#x27;2.1&#x27;</span>,            <span class="hljs-comment"># the pytorch_version version used in the training job</span>
    py_version           = <span class="hljs-string">&#x27;py310&#x27;</span>,            <span class="hljs-comment"># the python version used in the training job</span>
    hyperparameters      =  hyperparameters,
    environment          = { 
                            <span class="hljs-string">&quot;HUGGINGFACE_HUB_CACHE&quot;</span>: <span class="hljs-string">&quot;/tmp/.cache&quot;</span>,
                            <span class="hljs-comment"># &quot;HF_TOKEN&quot;: &quot;REPALCE_WITH_YOUR_TOKEN&quot; # needed for private models</span>
                            }, <span class="hljs-comment"># set env variable to cache models in /tmp</span>
)`,wrap:!1}}),V=new D({props:{code:"JTIzJTIwc3RhcnRpbmclMjB0aGUlMjB0cmFpbiUyMGpvYiUyMHdpdGglMjBvdXIlMjB1cGxvYWRlZCUyMGRhdGFzZXRzJTIwYXMlMjBpbnB1dCUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvci5maXQoKQ==",highlighted:`<span class="hljs-comment"># starting the train job with our uploaded datasets as input</span>
huggingface_estimator.fit()`,wrap:!1}}),L=new D({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> tarfile
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> io
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> sagemaker.s3 <span class="hljs-keyword">import</span> S3Downloader


<span class="hljs-comment"># download results from s3</span>
results_tar = S3Downloader.read_bytes(huggingface_estimator.model_data)
model_id = hyperparameters[<span class="hljs-string">&quot;model_args&quot;</span>].split(<span class="hljs-string">&quot;=&quot;</span>)[<span class="hljs-number">1</span>]
result={}

<span class="hljs-comment"># Use tarfile to open the tar content directly from bytes</span>
<span class="hljs-keyword">with</span> tarfile.<span class="hljs-built_in">open</span>(fileobj=io.BytesIO(results_tar), mode=<span class="hljs-string">&quot;r:gz&quot;</span>) <span class="hljs-keyword">as</span> tar:
    <span class="hljs-comment"># Iterate over items in tar archive to find your json file by its path</span>
    <span class="hljs-keyword">for</span> member <span class="hljs-keyword">in</span> tar.getmembers():
        <span class="hljs-comment"># get path of results based on model id used to evaluate</span>
        <span class="hljs-keyword">if</span> os.path.join(<span class="hljs-string">&quot;details&quot;</span>, model_id) <span class="hljs-keyword">in</span> member.name <span class="hljs-keyword">and</span> member.name.endswith(<span class="hljs-string">&#x27;.json&#x27;</span>):
            <span class="hljs-comment"># Extract the file content</span>
            f = tar.extractfile(member)
            <span class="hljs-keyword">if</span> f <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
                content = f.read()
                result = json.loads(content)
                <span class="hljs-keyword">break</span>
            
<span class="hljs-comment"># print results</span>
<span class="hljs-built_in">print</span>(result[<span class="hljs-string">&quot;results&quot;</span>])
<span class="hljs-comment"># {&#x27;lighteval|truthfulqa:mc|0&#x27;: {&#x27;truthfulqa_mc1&#x27;: 0.40636474908200737, &#x27;truthfulqa_mc1_stderr&#x27;: 0.017193835812093897, &#x27;truthfulqa_mc2&#x27;: 0.5747003398184238, &#x27;truthfulqa_mc2_stderr&#x27;: 0.015742356478301463}}</span>`,wrap:!1}}),m=new ce({props:{$$slots:{default:[je]},$$scope:{ctx:O}}}),q=new we({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/examples/sagemaker-sdk-evaluate-llm-lighteval.mdx"}}),{c(){p=M("meta"),y=t(),T=M("p"),P=t(),r(d.$$.fragment),ll=t(),r(u.$$.fragment),el=t(),I=M("p"),I.innerHTML=xl,sl=t(),U=M("p"),U.textContent=Xl,al=t(),b=M("p"),b.textContent=El,tl=t(),g=M("ol"),g.innerHTML=_l,nl=t(),r(f.$$.fragment),Ml=t(),A=M("p"),A.innerHTML=Nl,il=t(),r(Z.$$.fragment),ol=t(),r(v.$$.fragment),pl=t(),B=M("p"),B.innerHTML=Ql,rl=t(),C=M("p"),C.innerHTML=Yl,cl=t(),k=M("p"),k.innerHTML=Fl,Jl=t(),G=M("p"),G.innerHTML=Rl,wl=t(),r(W.$$.fragment),jl=t(),H=M("p"),H.innerHTML=Vl,hl=t(),z=M("p"),z.innerHTML=$l,Tl=t(),r(x.$$.fragment),ml=t(),X=M("p"),X.innerHTML=Ll,yl=t(),r(E.$$.fragment),dl=t(),_=M("p"),_.innerHTML=Sl,ul=t(),N=M("p"),N.innerHTML=ql,Il=t(),Q=M("ul"),Q.innerHTML=Dl,Ul=t(),Y=M("p"),Y.innerHTML=Pl,bl=t(),r(F.$$.fragment),gl=t(),R=M("p"),R.innerHTML=Kl,fl=t(),r(V.$$.fragment),Al=t(),$=M("p"),$.innerHTML=Ol,Zl=t(),r(L.$$.fragment),vl=t(),S=M("p"),S.innerHTML=le,Bl=t(),Cl=M("hr"),kl=t(),r(m.$$.fragment),Gl=t(),r(q.$$.fragment),Wl=t(),K=M("p"),this.h()},l(l){const e=pe("svelte-u9bgzb",document.head);p=i(e,"META",{name:!0,content:!0}),e.forEach(s),y=n(l),T=i(l,"P",{}),se(T).forEach(s),P=n(l),c(d.$$.fragment,l),ll=n(l),c(u.$$.fragment,l),el=n(l),I=i(l,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1dytuw0"&&(I.innerHTML=xl),sl=n(l),U=i(l,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1tkejc9"&&(U.textContent=Xl),al=n(l),b=i(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1xbim1c"&&(b.textContent=El),tl=n(l),g=i(l,"OL",{"data-svelte-h":!0}),o(g)!=="svelte-iu956w"&&(g.innerHTML=_l),nl=n(l),c(f.$$.fragment,l),Ml=n(l),A=i(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-s0u97w"&&(A.innerHTML=Nl),il=n(l),c(Z.$$.fragment,l),ol=n(l),c(v.$$.fragment,l),pl=n(l),B=i(l,"P",{"data-svelte-h":!0}),o(B)!=="svelte-14s330d"&&(B.innerHTML=Ql),rl=n(l),C=i(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1yoz672"&&(C.innerHTML=Yl),cl=n(l),k=i(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-k8g2se"&&(k.innerHTML=Fl),Jl=n(l),G=i(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-i6nszn"&&(G.innerHTML=Rl),wl=n(l),c(W.$$.fragment,l),jl=n(l),H=i(l,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1709a7"&&(H.innerHTML=Vl),hl=n(l),z=i(l,"P",{"data-svelte-h":!0}),o(z)!=="svelte-8hjwst"&&(z.innerHTML=$l),Tl=n(l),c(x.$$.fragment,l),ml=n(l),X=i(l,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1kdp07x"&&(X.innerHTML=Ll),yl=n(l),c(E.$$.fragment,l),dl=n(l),_=i(l,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1nagj1d"&&(_.innerHTML=Sl),ul=n(l),N=i(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1ftyhj8"&&(N.innerHTML=ql),Il=n(l),Q=i(l,"UL",{"data-svelte-h":!0}),o(Q)!=="svelte-njlmgk"&&(Q.innerHTML=Dl),Ul=n(l),Y=i(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1h2b2yh"&&(Y.innerHTML=Pl),bl=n(l),c(F.$$.fragment,l),gl=n(l),R=i(l,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1alpixz"&&(R.innerHTML=Kl),fl=n(l),c(V.$$.fragment,l),Al=n(l),$=i(l,"P",{"data-svelte-h":!0}),o($)!=="svelte-1yn6w5d"&&($.innerHTML=Ol),Zl=n(l),c(L.$$.fragment,l),vl=n(l),S=i(l,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1d75i5s"&&(S.innerHTML=le),Bl=n(l),Cl=i(l,"HR",{}),kl=n(l),c(m.$$.fragment,l),Gl=n(l),c(q.$$.fragment,l),Wl=n(l),K=i(l,"P",{}),se(K).forEach(s),this.h()},h(){ae(p,"name","hf:doc:metadata"),ae(p,"content",Te)},m(l,e){re(document.head,p),a(l,y,e),a(l,T,e),a(l,P,e),J(d,l,e),a(l,ll,e),J(u,l,e),a(l,el,e),a(l,I,e),a(l,sl,e),a(l,U,e),a(l,al,e),a(l,b,e),a(l,tl,e),a(l,g,e),a(l,nl,e),J(f,l,e),a(l,Ml,e),a(l,A,e),a(l,il,e),J(Z,l,e),a(l,ol,e),J(v,l,e),a(l,pl,e),a(l,B,e),a(l,rl,e),a(l,C,e),a(l,cl,e),a(l,k,e),a(l,Jl,e),a(l,G,e),a(l,wl,e),J(W,l,e),a(l,jl,e),a(l,H,e),a(l,hl,e),a(l,z,e),a(l,Tl,e),J(x,l,e),a(l,ml,e),a(l,X,e),a(l,yl,e),J(E,l,e),a(l,dl,e),a(l,_,e),a(l,ul,e),a(l,N,e),a(l,Il,e),a(l,Q,e),a(l,Ul,e),a(l,Y,e),a(l,bl,e),J(F,l,e),a(l,gl,e),a(l,R,e),a(l,fl,e),J(V,l,e),a(l,Al,e),a(l,$,e),a(l,Zl,e),J(L,l,e),a(l,vl,e),a(l,S,e),a(l,Bl,e),a(l,Cl,e),a(l,kl,e),J(m,l,e),a(l,Gl,e),J(q,l,e),a(l,Wl,e),a(l,K,e),Hl=!0},p(l,[e]){const ee={};e&2&&(ee.$$scope={dirty:e,ctx:l}),m.$set(ee)},i(l){Hl||(w(d.$$.fragment,l),w(u.$$.fragment,l),w(f.$$.fragment,l),w(Z.$$.fragment,l),w(v.$$.fragment,l),w(W.$$.fragment,l),w(x.$$.fragment,l),w(E.$$.fragment,l),w(F.$$.fragment,l),w(V.$$.fragment,l),w(L.$$.fragment,l),w(m.$$.fragment,l),w(q.$$.fragment,l),Hl=!0)},o(l){j(d.$$.fragment,l),j(u.$$.fragment,l),j(f.$$.fragment,l),j(Z.$$.fragment,l),j(v.$$.fragment,l),j(W.$$.fragment,l),j(x.$$.fragment,l),j(E.$$.fragment,l),j(F.$$.fragment,l),j(V.$$.fragment,l),j(L.$$.fragment,l),j(m.$$.fragment,l),j(q.$$.fragment,l),Hl=!1},d(l){l&&(s(y),s(T),s(P),s(ll),s(el),s(I),s(sl),s(U),s(al),s(b),s(tl),s(g),s(nl),s(Ml),s(A),s(il),s(ol),s(pl),s(B),s(rl),s(C),s(cl),s(k),s(Jl),s(G),s(wl),s(jl),s(H),s(hl),s(z),s(Tl),s(ml),s(X),s(yl),s(dl),s(_),s(ul),s(N),s(Il),s(Q),s(Ul),s(Y),s(bl),s(gl),s(R),s(fl),s(Al),s($),s(Zl),s(vl),s(S),s(Bl),s(Cl),s(kl),s(Gl),s(Wl),s(K)),s(p),h(d,l),h(u,l),h(f,l),h(Z,l),h(v,l),h(W,l),h(x,l),h(E,l),h(F,l),h(V,l),h(L,l),h(m,l),h(q,l)}}}const Te='{"title":"Evaluate LLMs with Hugging Face Lighteval on Amazon SageMaker","local":"evaluate-llms-with-hugging-face-lighteval-on-amazon-sagemaker","sections":[{"title":"2. Prepare the evaluation configuraiton","local":"2-prepare-the-evaluation-configuraiton","sections":[],"depth":2},{"title":"3. Evaluate Zephyr 7B on TruthfulQA on Amazon SageMaker","local":"3-evaluate-zephyr-7b-on-truthfulqa-on-amazon-sagemaker","sections":[],"depth":2}],"depth":1}';function me(O){return ne(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class be extends ie{constructor(p){super(),oe(this,p,me,he,te,{})}}export{be as component};
