import{s as Xe,n as Ze,o as et}from"../chunks/scheduler.182ea377.js";import{S as tt,i as it,g as l,s as o,r as d,A as st,h as a,f as i,c as n,j as Qe,u as c,x as r,k as Ve,y as ot,a as s,v as h,d as p,t as u,w as m}from"../chunks/index.abf12888.js";import{H as g,E as nt}from"../chunks/EditOnGithub.9b8e78e4.js";function lt(Le){let f,K,Y,Q,b,V,y,Ce=`🧨 Diffusers provides <strong>state-of-the-art</strong> pretrained diffusion models across multiple modalities.
Its purpose is to serve as a <strong>modular toolbox</strong> for both inference and training.`,X,w,He="We aim at building a library that stands the test of time and therefore take API design very seriously.",Z,v,De='In a nutshell, Diffusers is built to be a natural extension of PyTorch. Therefore, most of our design choices are based on <a href="https://pytorch.org/docs/stable/community/design.html#pytorch-design-philosophy" rel="nofollow">PyTorch’s Design Principles</a>. Let’s go over the most important ones:',ee,x,te,_,Ie='<li>While Diffusers has many built-in performance-enhancing features (see <a href="https://huggingface.co/docs/diffusers/optimization/fp16" rel="nofollow">Memory and Speed</a>), models are always loaded with the highest precision and lowest optimization. Therefore, by default diffusion pipelines are always instantiated on CPU with float32 precision if not otherwise defined by the user. This ensures usability across different platforms and accelerators and means that no complex installations are required to run the library.</li> <li>Diffusers aims to be a <strong>light-weight</strong> package and therefore has very few required dependencies, but many soft dependencies that can improve performance (such as <code>accelerate</code>, <code>safetensors</code>, <code>onnx</code>, etc…). We strive to keep the library as lightweight as possible so that it can be added without much concern as a dependency on other packages.</li> <li>Diffusers prefers simple, self-explainable code over condensed, magic code. This means that short-hand code syntaxes such as lambda functions, and advanced PyTorch operators are often not desired.</li>',ie,T,se,$,Se="As PyTorch states, <strong>explicit is better than implicit</strong> and <strong>simple is better than complex</strong>. This design philosophy is reflected in multiple parts of the library:",oe,k,Ue=`<li>We follow PyTorch’s API with methods like <a href="https://huggingface.co/docs/diffusers/main/en/api/diffusion_pipeline#diffusers.DiffusionPipeline.to" rel="nofollow"><code>DiffusionPipeline.to</code></a> to let the user handle device management.</li> <li>Raising concise error messages is preferred to silently correct erroneous input. Diffusers aims at teaching the user, rather than making the library as easy to use as possible.</li> <li>Complex model vs. scheduler logic is exposed instead of magically handled inside. Schedulers/Samplers are separated from diffusion models with minimal dependencies on each other. This forces the user to write the unrolled denoising loop. However, the separation allows for easier debugging and gives the user more control over adapting the denoising process or switching out diffusion models or schedulers.</li> <li>Separately trained components of the diffusion pipeline, <em>e.g.</em> the text encoder, the unet, and the variational autoencoder, each have their own model class. This forces the user to handle the interaction between the different model components, and the serialization format separates the model components into different files. However, this allows for easier debugging and customization. DreamBooth or Textual Inversion training
is very simple thanks to Diffusers’ ability to separate single components of the diffusion pipeline.</li>`,ne,M,le,P,Ae=`For large parts of the library, Diffusers adopts an important design principle of the <a href="https://github.com/huggingface/transformers" rel="nofollow">Transformers library</a>, which is to prefer copy-pasted code over hasty abstractions. This design principle is very opinionated and stands in stark contrast to popular design principles such as <a href="https://en.wikipedia.org/wiki/Don%27t_repeat_yourself" rel="nofollow">Don’t repeat yourself (DRY)</a>.
In short, just like Transformers does for modeling files, Diffusers prefers to keep an extremely low level of abstraction and very self-contained code for pipelines and schedulers.
Functions, long code blocks, and even classes can be copied across multiple files which at first can look like a bad, sloppy design choice that makes the library unmaintainable.
<strong>However</strong>, this design has proven to be extremely successful for Transformers and makes a lot of sense for community-driven, open-source machine learning libraries because:`,ae,L,Ee="<li>Machine Learning is an extremely fast-moving field in which paradigms, model architectures, and algorithms are changing rapidly, which therefore makes it very difficult to define long-lasting code abstractions.</li> <li>Machine Learning practitioners like to be able to quickly tweak existing code for ideation and research and therefore prefer self-contained code over one that contains many abstractions.</li> <li>Open-source libraries rely on community contributions and therefore must build a library that is easy to contribute to. The more abstract the code, the more dependencies, the harder to read, and the harder to contribute to. Contributors simply stop contributing to very abstract libraries out of fear of breaking vital functionality. If contributing to a library cannot break other fundamental code, not only is it more inviting for potential new contributors, but it is also easier to review and contribute to multiple parts in parallel.</li>",re,C,je=`At Hugging Face, we call this design the <strong>single-file policy</strong> which means that almost all of the code of a certain class should be written in a single, self-contained file. To read more about the philosophy, you can have a look
at <a href="https://huggingface.co/blog/transformers-design-philosophy" rel="nofollow">this blog post</a>.`,fe,H,ze=`In Diffusers, we follow this philosophy for both pipelines and schedulers, but only partly for diffusion models. The reason we don’t follow this design fully for diffusion models is because almost all diffusion pipelines, such
as <a href="https://huggingface.co/docs/diffusers/api/pipelines/ddpm" rel="nofollow">DDPM</a>, <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/overview#stable-diffusion-pipelines" rel="nofollow">Stable Diffusion</a>, <a href="https://huggingface.co/docs/diffusers/api/pipelines/unclip" rel="nofollow">unCLIP (DALL·E 2)</a> and <a href="https://imagen.research.google/" rel="nofollow">Imagen</a> all rely on the same diffusion model, the <a href="https://huggingface.co/docs/diffusers/api/models/unet2d-cond" rel="nofollow">UNet</a>.`,de,D,qe=`Great, now you should have generally understood why 🧨 Diffusers is designed the way it is 🤗.
We try to apply these design principles consistently across the library. Nevertheless, there are some minor exceptions to the philosophy or some unlucky design choices. If you have feedback regarding the design, we would ❤️  to hear it <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=&amp;template=feedback.md&amp;title=" rel="nofollow">directly on GitHub</a>.`,ce,I,he,S,Ne=`Now, let’s look a bit into the nitty-gritty details of the design philosophy. Diffusers essentially consists of three major classes: <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/pipelines" rel="nofollow">pipelines</a>, <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/models" rel="nofollow">models</a>, and <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/schedulers" rel="nofollow">schedulers</a>.
Let’s walk through more in-detail design decisions for each class.`,pe,U,ue,A,Oe='Pipelines are designed to be easy to use (therefore do not follow <a href="#simple-over-easy"><em>Simple over easy</em></a> 100%), are not feature complete, and should loosely be seen as examples of how to use <a href="#models">models</a> and <a href="#schedulers">schedulers</a> for inference.',me,E,Fe="The following design principles are followed:",ge,j,We='<li>Pipelines follow the single-file policy. All pipelines can be found in individual directories under src/diffusers/pipelines. One pipeline folder corresponds to one diffusion paper/project/release. Multiple pipeline files can be gathered in one pipeline folder, as it’s done for <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/pipelines/stable_diffusion" rel="nofollow"><code>src/diffusers/pipelines/stable-diffusion</code></a>. If pipelines share similar functionality, one can make use of the <a href="https://github.com/huggingface/diffusers/blob/125d783076e5bd9785beb05367a2d2566843a271/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L251" rel="nofollow">#Copied from mechanism</a>.</li> <li>Pipelines all inherit from <a href="/docs/diffusers/v0.28.2/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>.</li> <li>Every pipeline consists of different model and scheduler components, that are documented in the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/model_index.json" rel="nofollow"><code>model_index.json</code> file</a>, are accessible under the same name as attributes of the pipeline and can be shared between pipelines with <a href="https://huggingface.co/docs/diffusers/main/en/api/diffusion_pipeline#diffusers.DiffusionPipeline.components" rel="nofollow"><code>DiffusionPipeline.components</code></a> function.</li> <li>Every pipeline should be loadable via the <a href="https://huggingface.co/docs/diffusers/main/en/api/diffusion_pipeline#diffusers.DiffusionPipeline.from_pretrained" rel="nofollow"><code>DiffusionPipeline.from_pretrained</code></a> function.</li> <li>Pipelines should be used <strong>only</strong> for inference.</li> <li>Pipelines should be very readable, self-explanatory, and easy to tweak.</li> <li>Pipelines should be designed to build on top of each other and be easy to integrate into higher-level APIs.</li> <li>Pipelines are <strong>not</strong> intended to be feature-complete user interfaces. For future complete user interfaces one should rather have a look at <a href="https://github.com/invoke-ai/InvokeAI" rel="nofollow">InvokeAI</a>, <a href="https://github.com/abhishekkrthakur/diffuzers" rel="nofollow">Diffuzers</a>, and <a href="https://github.com/Sanster/lama-cleaner" rel="nofollow">lama-cleaner</a>.</li> <li>Every pipeline should have one and only one way to run it via a <code>__call__</code> method. The naming of the <code>__call__</code> arguments should be shared across all pipelines.</li> <li>Pipelines should be named after the task they are intended to solve.</li> <li>In almost all cases, novel diffusion pipelines shall be implemented in a new pipeline folder/file.</li>',be,z,ye,q,Ge='Models are designed as configurable toolboxes that are natural extensions of <a href="https://pytorch.org/docs/stable/generated/torch.nn.Module.html" rel="nofollow">PyTorch’s Module class</a>. They only partly follow the <strong>single-file policy</strong>.',we,N,Re="The following design principles are followed:",ve,O,Be=`<li>Models correspond to <strong>a type of model architecture</strong>. <em>E.g.</em> the <a href="/docs/diffusers/v0.28.2/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> class is used for all UNet variations that expect 2D image inputs and are conditioned on some context.</li> <li>All models can be found in <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/models" rel="nofollow"><code>src/diffusers/models</code></a> and every model architecture shall be defined in its file, e.g. <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/unet_2d_condition.py" rel="nofollow"><code>unet_2d_condition.py</code></a>, <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/transformer_2d.py" rel="nofollow"><code>transformer_2d.py</code></a>, etc…</li> <li>Models <strong>do not</strong> follow the single-file policy and should make use of smaller model building blocks, such as <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention.py" rel="nofollow"><code>attention.py</code></a>, <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/resnet.py" rel="nofollow"><code>resnet.py</code></a>, <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/embeddings.py" rel="nofollow"><code>embeddings.py</code></a>, etc… <strong>Note</strong>: This is in stark contrast to Transformers’ modeling files and shows that models do not really follow the single-file policy.</li> <li>Models intend to expose complexity, just like PyTorch’s <code>Module</code> class, and give clear error messages.</li> <li>Models all inherit from <code>ModelMixin</code> and <code>ConfigMixin</code>.</li> <li>Models can be optimized for performance when it doesn’t demand major code changes, keeps backward compatibility, and gives significant memory or compute gain.</li> <li>Models should by default have the highest precision and lowest performance setting.</li> <li>To integrate new model checkpoints whose general architecture can be classified as an architecture that already exists in Diffusers, the existing model architecture shall be adapted to make it work with the new checkpoint. One should only create a new file if the model architecture is fundamentally different.</li> <li>Models should be designed to be easily extendable to future changes. This can be achieved by limiting public function arguments, configuration arguments, and “foreseeing” future changes, <em>e.g.</em> it is usually better to add <code>string</code> “…type” arguments that can easily be extended to new future types instead of boolean <code>is_..._type</code> arguments. Only the minimum amount of changes shall be made to existing architectures to make a new model checkpoint work.</li> <li>The model design is a difficult trade-off between keeping code readable and concise and supporting many model checkpoints. For most parts of the modeling code, classes shall be adapted for new model checkpoints, while there are some exceptions where it is preferred to add new classes to make sure the code is kept concise and
readable long-term, such as <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/unet_2d_blocks.py" rel="nofollow">UNet blocks</a> and <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">Attention processors</a>.</li>`,xe,F,_e,W,Ye="Schedulers are responsible to guide the denoising process for inference as well as to define a noise schedule for training. They are designed as individual classes with loadable configuration files and strongly follow the <strong>single-file policy</strong>.",Te,G,Je="The following design principles are followed:",$e,R,Ke='<li>All schedulers are found in <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/schedulers" rel="nofollow"><code>src/diffusers/schedulers</code></a>.</li> <li>Schedulers are <strong>not</strong> allowed to import from large utils files and shall be kept very self-contained.</li> <li>One scheduler Python file corresponds to one scheduler algorithm (as might be defined in a paper).</li> <li>If schedulers share similar functionalities, we can make use of the <code>#Copied from</code> mechanism.</li> <li>Schedulers all inherit from <code>SchedulerMixin</code> and <code>ConfigMixin</code>.</li> <li>Schedulers can be easily swapped out with the <a href="https://huggingface.co/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin.from_config" rel="nofollow"><code>ConfigMixin.from_config</code></a> method as explained in detail <a href="../using-diffusers/schedulers.md">here</a>.</li> <li>Every scheduler has to have a <code>set_num_inference_steps</code>, and a <code>step</code> function. <code>set_num_inference_steps(...)</code> has to be called before every denoising process, <em>i.e.</em> before <code>step(...)</code> is called.</li> <li>Every scheduler exposes the timesteps to be “looped over” via a <code>timesteps</code> attribute, which is an array of timesteps the model will be called upon.</li> <li>The <code>step(...)</code> function takes a predicted model output and the “current” sample (x_t) and returns the “previous”, slightly more denoised sample (x_t-1).</li> <li>Given the complexity of diffusion schedulers, the <code>step</code> function does not expose all the complexity and can be a bit of a “black box”.</li> <li>In almost all cases, novel schedulers shall be implemented in a new scheduling file.</li>',ke,B,Me,J,Pe;return b=new g({props:{title:"Philosophy",local:"philosophy",headingTag:"h1"}}),x=new g({props:{title:"Usability over Performance",local:"usability-over-performance",headingTag:"h2"}}),T=new g({props:{title:"Simple over easy",local:"simple-over-easy",headingTag:"h2"}}),M=new g({props:{title:"Tweakable, contributor-friendly over abstraction",local:"tweakable-contributor-friendly-over-abstraction",headingTag:"h2"}}),I=new g({props:{title:"Design Philosophy in Details",local:"design-philosophy-in-details",headingTag:"h2"}}),U=new g({props:{title:"Pipelines",local:"pipelines",headingTag:"h3"}}),z=new g({props:{title:"Models",local:"models",headingTag:"h3"}}),F=new g({props:{title:"Schedulers",local:"schedulers",headingTag:"h3"}}),B=new nt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/conceptual/philosophy.md"}}),{c(){f=l("meta"),K=o(),Y=l("p"),Q=o(),d(b.$$.fragment),V=o(),y=l("p"),y.innerHTML=Ce,X=o(),w=l("p"),w.textContent=He,Z=o(),v=l("p"),v.innerHTML=De,ee=o(),d(x.$$.fragment),te=o(),_=l("ul"),_.innerHTML=Ie,ie=o(),d(T.$$.fragment),se=o(),$=l("p"),$.innerHTML=Se,oe=o(),k=l("ul"),k.innerHTML=Ue,ne=o(),d(M.$$.fragment),le=o(),P=l("p"),P.innerHTML=Ae,ae=o(),L=l("ul"),L.innerHTML=Ee,re=o(),C=l("p"),C.innerHTML=je,fe=o(),H=l("p"),H.innerHTML=ze,de=o(),D=l("p"),D.innerHTML=qe,ce=o(),d(I.$$.fragment),he=o(),S=l("p"),S.innerHTML=Ne,pe=o(),d(U.$$.fragment),ue=o(),A=l("p"),A.innerHTML=Oe,me=o(),E=l("p"),E.textContent=Fe,ge=o(),j=l("ul"),j.innerHTML=We,be=o(),d(z.$$.fragment),ye=o(),q=l("p"),q.innerHTML=Ge,we=o(),N=l("p"),N.textContent=Re,ve=o(),O=l("ul"),O.innerHTML=Be,xe=o(),d(F.$$.fragment),_e=o(),W=l("p"),W.innerHTML=Ye,Te=o(),G=l("p"),G.textContent=Je,$e=o(),R=l("ul"),R.innerHTML=Ke,ke=o(),d(B.$$.fragment),Me=o(),J=l("p"),this.h()},l(e){const t=st("svelte-u9bgzb",document.head);f=a(t,"META",{name:!0,content:!0}),t.forEach(i),K=n(e),Y=a(e,"P",{}),Qe(Y).forEach(i),Q=n(e),c(b.$$.fragment,e),V=n(e),y=a(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-7afmi5"&&(y.innerHTML=Ce),X=n(e),w=a(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-ymjbvo"&&(w.textContent=He),Z=n(e),v=a(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1qf3v7v"&&(v.innerHTML=De),ee=n(e),c(x.$$.fragment,e),te=n(e),_=a(e,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-wzmc8i"&&(_.innerHTML=Ie),ie=n(e),c(T.$$.fragment,e),se=n(e),$=a(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-rwqz34"&&($.innerHTML=Se),oe=n(e),k=a(e,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-10zm1ge"&&(k.innerHTML=Ue),ne=n(e),c(M.$$.fragment,e),le=n(e),P=a(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1maatxx"&&(P.innerHTML=Ae),ae=n(e),L=a(e,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-8d4xn1"&&(L.innerHTML=Ee),re=n(e),C=a(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-cg0ywv"&&(C.innerHTML=je),fe=n(e),H=a(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-s9oxaw"&&(H.innerHTML=ze),de=n(e),D=a(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-k3kirj"&&(D.innerHTML=qe),ce=n(e),c(I.$$.fragment,e),he=n(e),S=a(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-g3jwp9"&&(S.innerHTML=Ne),pe=n(e),c(U.$$.fragment,e),ue=n(e),A=a(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1ln30jf"&&(A.innerHTML=Oe),me=n(e),E=a(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1yq4knn"&&(E.textContent=Fe),ge=n(e),j=a(e,"UL",{"data-svelte-h":!0}),r(j)!=="svelte-6lqpl1"&&(j.innerHTML=We),be=n(e),c(z.$$.fragment,e),ye=n(e),q=a(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-bb7xr2"&&(q.innerHTML=Ge),we=n(e),N=a(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1yq4knn"&&(N.textContent=Re),ve=n(e),O=a(e,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-7fnm7w"&&(O.innerHTML=Be),xe=n(e),c(F.$$.fragment,e),_e=n(e),W=a(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-fs6rzc"&&(W.innerHTML=Ye),Te=n(e),G=a(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1yq4knn"&&(G.textContent=Je),$e=n(e),R=a(e,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-db8tio"&&(R.innerHTML=Ke),ke=n(e),c(B.$$.fragment,e),Me=n(e),J=a(e,"P",{}),Qe(J).forEach(i),this.h()},h(){Ve(f,"name","hf:doc:metadata"),Ve(f,"content",at)},m(e,t){ot(document.head,f),s(e,K,t),s(e,Y,t),s(e,Q,t),h(b,e,t),s(e,V,t),s(e,y,t),s(e,X,t),s(e,w,t),s(e,Z,t),s(e,v,t),s(e,ee,t),h(x,e,t),s(e,te,t),s(e,_,t),s(e,ie,t),h(T,e,t),s(e,se,t),s(e,$,t),s(e,oe,t),s(e,k,t),s(e,ne,t),h(M,e,t),s(e,le,t),s(e,P,t),s(e,ae,t),s(e,L,t),s(e,re,t),s(e,C,t),s(e,fe,t),s(e,H,t),s(e,de,t),s(e,D,t),s(e,ce,t),h(I,e,t),s(e,he,t),s(e,S,t),s(e,pe,t),h(U,e,t),s(e,ue,t),s(e,A,t),s(e,me,t),s(e,E,t),s(e,ge,t),s(e,j,t),s(e,be,t),h(z,e,t),s(e,ye,t),s(e,q,t),s(e,we,t),s(e,N,t),s(e,ve,t),s(e,O,t),s(e,xe,t),h(F,e,t),s(e,_e,t),s(e,W,t),s(e,Te,t),s(e,G,t),s(e,$e,t),s(e,R,t),s(e,ke,t),h(B,e,t),s(e,Me,t),s(e,J,t),Pe=!0},p:Ze,i(e){Pe||(p(b.$$.fragment,e),p(x.$$.fragment,e),p(T.$$.fragment,e),p(M.$$.fragment,e),p(I.$$.fragment,e),p(U.$$.fragment,e),p(z.$$.fragment,e),p(F.$$.fragment,e),p(B.$$.fragment,e),Pe=!0)},o(e){u(b.$$.fragment,e),u(x.$$.fragment,e),u(T.$$.fragment,e),u(M.$$.fragment,e),u(I.$$.fragment,e),u(U.$$.fragment,e),u(z.$$.fragment,e),u(F.$$.fragment,e),u(B.$$.fragment,e),Pe=!1},d(e){e&&(i(K),i(Y),i(Q),i(V),i(y),i(X),i(w),i(Z),i(v),i(ee),i(te),i(_),i(ie),i(se),i($),i(oe),i(k),i(ne),i(le),i(P),i(ae),i(L),i(re),i(C),i(fe),i(H),i(de),i(D),i(ce),i(he),i(S),i(pe),i(ue),i(A),i(me),i(E),i(ge),i(j),i(be),i(ye),i(q),i(we),i(N),i(ve),i(O),i(xe),i(_e),i(W),i(Te),i(G),i($e),i(R),i(ke),i(Me),i(J)),i(f),m(b,e),m(x,e),m(T,e),m(M,e),m(I,e),m(U,e),m(z,e),m(F,e),m(B,e)}}}const at='{"title":"Philosophy","local":"philosophy","sections":[{"title":"Usability over Performance","local":"usability-over-performance","sections":[],"depth":2},{"title":"Simple over easy","local":"simple-over-easy","sections":[],"depth":2},{"title":"Tweakable, contributor-friendly over abstraction","local":"tweakable-contributor-friendly-over-abstraction","sections":[],"depth":2},{"title":"Design Philosophy in Details","local":"design-philosophy-in-details","sections":[{"title":"Pipelines","local":"pipelines","sections":[],"depth":3},{"title":"Models","local":"models","sections":[],"depth":3},{"title":"Schedulers","local":"schedulers","sections":[],"depth":3}],"depth":2}],"depth":1}';function rt(Le){return et(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ht extends tt{constructor(f){super(),it(this,f,rt,lt,Xe,{})}}export{ht as component};
