import{s as Wt,n as Ct,o as Bt}from"../chunks/scheduler.85c25b89.js";import{S as Nt,i as Gt,g as p,s as a,r as i,A as xt,h as m,f as l,c as n,j as $t,u as o,x as d,k as kt,y as Et,a as e,v as c,d as r,t as h,w as M}from"../chunks/index.c9837788.js";import{C as X}from"../chunks/CodeBlock.e573519b.js";import{H as A,E as vt}from"../chunks/index.b36f1b99.js";function Vt(jt){let j,R,Y,F,g,S,J,gt='<strong>FBNet</strong> is a type of convolutional neural architectures discovered through <a href="https://paperswithcode.com/method/dnas" rel="nofollow">DNAS</a> neural architecture search. It utilises a basic type of image model block inspired by <a href="https://paperswithcode.com/method/mobilenetv2" rel="nofollow">MobileNetv2</a> that utilises depthwise convolutions and an inverted residual structure (see components).',H,w,Jt='The principal building block is the <a href="https://paperswithcode.com/method/fbnet-block" rel="nofollow">FBNet Block</a>.',z,y,D,u,wt="To load a pretrained model:",L,T,q,b,yt="To load and preprocess the image:",P,f,K,U,ut="To get the model predictions:",O,I,tt,Z,Tt="To get the top-5 predictions class names:",st,$,lt,k,bt="Replace the model name with the variant you want to use, e.g. <code>fbnetc_100</code>. You can find the IDs in the model summaries at the top of this page.",et,W,ft='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',at,C,nt,B,Ut="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,N,mt,G,It=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,it,x,ot,E,Zt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ct,v,rt,V,ht,Q,Mt,_,dt;return g=new A({props:{title:"FBNet",local:"fbnet",headingTag:"h1"}}),y=new A({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2ZibmV0Y18xMDAnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;fbnetc_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),C=new A({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZmJuZXRjXzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;fbnetc_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new A({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),v=new A({props:{title:"Citation",local:"citation",headingTag:"h2"}}),V=new X({props:{code:"JTQwbWlzYyU3Qnd1MjAxOWZibmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JGQk5ldCUzQSUyMEhhcmR3YXJlLUF3YXJlJTIwRWZmaWNpZW50JTIwQ29udk5ldCUyMERlc2lnbiUyMHZpYSUyMERpZmZlcmVudGlhYmxlJTIwTmV1cmFsJTIwQXJjaGl0ZWN0dXJlJTIwU2VhcmNoJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCQmljaGVuJTIwV3UlMjBhbmQlMjBYaWFvbGlhbmclMjBEYWklMjBhbmQlMjBQZWl6aGFvJTIwWmhhbmclMjBhbmQlMjBZYW5naGFuJTIwV2FuZyUyMGFuZCUyMEZlaSUyMFN1biUyMGFuZCUyMFlpbWluZyUyMFd1JTIwYW5kJTIwWXVhbmRvbmclMjBUaWFuJTIwYW5kJTIwUGV0ZXIlMjBWYWpkYSUyMGFuZCUyMFlhbmdxaW5nJTIwSmlhJTIwYW5kJTIwS3VydCUyMEtldXR6ZXIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE4MTIuMDM0NDMlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{wu<span class="hljs-symbol">2019f</span>bnet,
      title={FBNet: Hardware-Aware Efficient ConvNet Design via <span class="hljs-keyword">Differentiable </span>Neural Architecture Search}, 
      author={<span class="hljs-keyword">Bichen </span>Wu <span class="hljs-keyword">and </span>Xiaoliang Dai <span class="hljs-keyword">and </span>Peizhao Zhang <span class="hljs-keyword">and </span>Yanghan Wang <span class="hljs-keyword">and </span>Fei Sun <span class="hljs-keyword">and </span>Yiming Wu <span class="hljs-keyword">and </span>Yuandong Tian <span class="hljs-keyword">and </span>Peter Vajda <span class="hljs-keyword">and </span>Yangqing <span class="hljs-keyword">Jia </span><span class="hljs-keyword">and </span>Kurt Keutzer},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1812</span>.<span class="hljs-number">03443</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),Q=new vt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/fbnet.mdx"}}),{c(){j=p("meta"),R=a(),Y=p("p"),F=a(),i(g.$$.fragment),S=a(),J=p("p"),J.innerHTML=gt,H=a(),w=p("p"),w.innerHTML=Jt,z=a(),i(y.$$.fragment),D=a(),u=p("p"),u.textContent=wt,L=a(),i(T.$$.fragment),q=a(),b=p("p"),b.textContent=yt,P=a(),i(f.$$.fragment),K=a(),U=p("p"),U.textContent=ut,O=a(),i(I.$$.fragment),tt=a(),Z=p("p"),Z.textContent=Tt,st=a(),i($.$$.fragment),lt=a(),k=p("p"),k.innerHTML=bt,et=a(),W=p("p"),W.innerHTML=ft,at=a(),i(C.$$.fragment),nt=a(),B=p("p"),B.textContent=Ut,pt=a(),i(N.$$.fragment),mt=a(),G=p("p"),G.innerHTML=It,it=a(),i(x.$$.fragment),ot=a(),E=p("p"),E.innerHTML=Zt,ct=a(),i(v.$$.fragment),rt=a(),i(V.$$.fragment),ht=a(),i(Q.$$.fragment),Mt=a(),_=p("p"),this.h()},l(t){const s=xt("svelte-u9bgzb",document.head);j=m(s,"META",{name:!0,content:!0}),s.forEach(l),R=n(t),Y=m(t,"P",{}),$t(Y).forEach(l),F=n(t),o(g.$$.fragment,t),S=n(t),J=m(t,"P",{"data-svelte-h":!0}),d(J)!=="svelte-112qqgm"&&(J.innerHTML=gt),H=n(t),w=m(t,"P",{"data-svelte-h":!0}),d(w)!=="svelte-u55bao"&&(w.innerHTML=Jt),z=n(t),o(y.$$.fragment,t),D=n(t),u=m(t,"P",{"data-svelte-h":!0}),d(u)!=="svelte-18ywhxh"&&(u.textContent=wt),L=n(t),o(T.$$.fragment,t),q=n(t),b=m(t,"P",{"data-svelte-h":!0}),d(b)!=="svelte-1c2ipa8"&&(b.textContent=yt),P=n(t),o(f.$$.fragment,t),K=n(t),U=m(t,"P",{"data-svelte-h":!0}),d(U)!=="svelte-1n9qsq1"&&(U.textContent=ut),O=n(t),o(I.$$.fragment,t),tt=n(t),Z=m(t,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-19cnvx1"&&(Z.textContent=Tt),st=n(t),o($.$$.fragment,t),lt=n(t),k=m(t,"P",{"data-svelte-h":!0}),d(k)!=="svelte-18ctdhs"&&(k.innerHTML=bt),et=n(t),W=m(t,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1wmi3ea"&&(W.innerHTML=ft),at=n(t),o(C.$$.fragment,t),nt=n(t),B=m(t,"P",{"data-svelte-h":!0}),d(B)!=="svelte-9sr7nh"&&(B.textContent=Ut),pt=n(t),o(N.$$.fragment,t),mt=n(t),G=m(t,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1kguc51"&&(G.innerHTML=It),it=n(t),o(x.$$.fragment,t),ot=n(t),E=m(t,"P",{"data-svelte-h":!0}),d(E)!=="svelte-xtxxu6"&&(E.innerHTML=Zt),ct=n(t),o(v.$$.fragment,t),rt=n(t),o(V.$$.fragment,t),ht=n(t),o(Q.$$.fragment,t),Mt=n(t),_=m(t,"P",{}),$t(_).forEach(l),this.h()},h(){kt(j,"name","hf:doc:metadata"),kt(j,"content",Qt)},m(t,s){Et(document.head,j),e(t,R,s),e(t,Y,s),e(t,F,s),c(g,t,s),e(t,S,s),e(t,J,s),e(t,H,s),e(t,w,s),e(t,z,s),c(y,t,s),e(t,D,s),e(t,u,s),e(t,L,s),c(T,t,s),e(t,q,s),e(t,b,s),e(t,P,s),c(f,t,s),e(t,K,s),e(t,U,s),e(t,O,s),c(I,t,s),e(t,tt,s),e(t,Z,s),e(t,st,s),c($,t,s),e(t,lt,s),e(t,k,s),e(t,et,s),e(t,W,s),e(t,at,s),c(C,t,s),e(t,nt,s),e(t,B,s),e(t,pt,s),c(N,t,s),e(t,mt,s),e(t,G,s),e(t,it,s),c(x,t,s),e(t,ot,s),e(t,E,s),e(t,ct,s),c(v,t,s),e(t,rt,s),c(V,t,s),e(t,ht,s),c(Q,t,s),e(t,Mt,s),e(t,_,s),dt=!0},p:Ct,i(t){dt||(r(g.$$.fragment,t),r(y.$$.fragment,t),r(T.$$.fragment,t),r(f.$$.fragment,t),r(I.$$.fragment,t),r($.$$.fragment,t),r(C.$$.fragment,t),r(N.$$.fragment,t),r(x.$$.fragment,t),r(v.$$.fragment,t),r(V.$$.fragment,t),r(Q.$$.fragment,t),dt=!0)},o(t){h(g.$$.fragment,t),h(y.$$.fragment,t),h(T.$$.fragment,t),h(f.$$.fragment,t),h(I.$$.fragment,t),h($.$$.fragment,t),h(C.$$.fragment,t),h(N.$$.fragment,t),h(x.$$.fragment,t),h(v.$$.fragment,t),h(V.$$.fragment,t),h(Q.$$.fragment,t),dt=!1},d(t){t&&(l(R),l(Y),l(F),l(S),l(J),l(H),l(w),l(z),l(D),l(u),l(L),l(q),l(b),l(P),l(K),l(U),l(O),l(tt),l(Z),l(st),l(lt),l(k),l(et),l(W),l(at),l(nt),l(B),l(pt),l(mt),l(G),l(it),l(ot),l(E),l(ct),l(rt),l(ht),l(Mt),l(_)),l(j),M(g,t),M(y,t),M(T,t),M(f,t),M(I,t),M($,t),M(C,t),M(N,t),M(x,t),M(v,t),M(V,t),M(Q,t)}}}const Qt='{"title":"FBNet","local":"fbnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Xt(jt){return Bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends Nt{constructor(j){super(),Gt(this,j,Xt,Vt,Wt,{})}}export{Ft as component};
