import{s as xt,n as Ct,o as It}from"../chunks/scheduler.85c25b89.js";import{S as Zt,i as Wt,g as p,s as e,r as i,A as vt,h as m,f as l,c as n,j as Ut,u as o,x as g,k as $t,y as Gt,a,v as c,d as r,t as h,w as M}from"../chunks/index.c9837788.js";import{C as _}from"../chunks/CodeBlock.e573519b.js";import{H as X,E as kt}from"../chunks/index.b36f1b99.js";function Bt(Mt){let j,A,V,Y,d,S,w,gt='<strong>MixNet</strong> is a type of convolutional neural network discovered via AutoML that utilises <a href="https://paperswithcode.com/method/mixconv" rel="nofollow">MixConvs</a> instead of regular <a href="https://paperswithcode.com/method/depthwise-convolution" rel="nofollow">depthwise convolutions</a>.',H,y,z,J,jt="To load a pretrained model:",F,u,L,T,dt="To load and preprocess the image:",D,f,q,b,wt="To get the model predictions:",P,U,K,$,yt="To get the top-5 predictions class names:",O,x,tt,C,Jt="Replace the model name with the variant you want to use, e.g. <code>mixnet_l</code>. You can find the IDs in the model summaries at the top of this page.",st,I,ut='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',lt,Z,at,W,Tt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",et,v,nt,G,ft=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,pt,k,mt,B,bt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',it,N,ot,Q,ct,E,rt,R,ht;return d=new X({props:{title:"MixNet",local:"mixnet",headingTag:"h1"}}),y=new X({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new _({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ21peG5ldF9sJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mixnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new _({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),x=new _({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),Z=new X({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),v=new _({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbWl4bmV0X2wnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mixnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),k=new X({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),N=new X({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new _({props:{code:"JTQwbWlzYyU3QnRhbjIwMTltaXhjb252JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JNaXhDb252JTNBJTIwTWl4ZWQlMjBEZXB0aHdpc2UlMjBDb252b2x1dGlvbmFsJTIwS2VybmVscyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3Qk1pbmd4aW5nJTIwVGFuJTIwYW5kJTIwUXVvYyUyMFYuJTIwTGUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE5MDcuMDk1OTUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{tan2019mixconv,
      title={MixConv: Mixed Depthwise Convolutional Kernels}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Mingxing Tan and Quoc V. Le}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1907.09595}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),E=new kt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/mixnet.mdx"}}),{c(){j=p("meta"),A=e(),V=p("p"),Y=e(),i(d.$$.fragment),S=e(),w=p("p"),w.innerHTML=gt,H=e(),i(y.$$.fragment),z=e(),J=p("p"),J.textContent=jt,F=e(),i(u.$$.fragment),L=e(),T=p("p"),T.textContent=dt,D=e(),i(f.$$.fragment),q=e(),b=p("p"),b.textContent=wt,P=e(),i(U.$$.fragment),K=e(),$=p("p"),$.textContent=yt,O=e(),i(x.$$.fragment),tt=e(),C=p("p"),C.innerHTML=Jt,st=e(),I=p("p"),I.innerHTML=ut,lt=e(),i(Z.$$.fragment),at=e(),W=p("p"),W.textContent=Tt,et=e(),i(v.$$.fragment),nt=e(),G=p("p"),G.innerHTML=ft,pt=e(),i(k.$$.fragment),mt=e(),B=p("p"),B.innerHTML=bt,it=e(),i(N.$$.fragment),ot=e(),i(Q.$$.fragment),ct=e(),i(E.$$.fragment),rt=e(),R=p("p"),this.h()},l(t){const s=vt("svelte-u9bgzb",document.head);j=m(s,"META",{name:!0,content:!0}),s.forEach(l),A=n(t),V=m(t,"P",{}),Ut(V).forEach(l),Y=n(t),o(d.$$.fragment,t),S=n(t),w=m(t,"P",{"data-svelte-h":!0}),g(w)!=="svelte-ipcg9j"&&(w.innerHTML=gt),H=n(t),o(y.$$.fragment,t),z=n(t),J=m(t,"P",{"data-svelte-h":!0}),g(J)!=="svelte-18ywhxh"&&(J.textContent=jt),F=n(t),o(u.$$.fragment,t),L=n(t),T=m(t,"P",{"data-svelte-h":!0}),g(T)!=="svelte-1c2ipa8"&&(T.textContent=dt),D=n(t),o(f.$$.fragment,t),q=n(t),b=m(t,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1n9qsq1"&&(b.textContent=wt),P=n(t),o(U.$$.fragment,t),K=n(t),$=m(t,"P",{"data-svelte-h":!0}),g($)!=="svelte-19cnvx1"&&($.textContent=yt),O=n(t),o(x.$$.fragment,t),tt=n(t),C=m(t,"P",{"data-svelte-h":!0}),g(C)!=="svelte-o2qdri"&&(C.innerHTML=Jt),st=n(t),I=m(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-1wmi3ea"&&(I.innerHTML=ut),lt=n(t),o(Z.$$.fragment,t),at=n(t),W=m(t,"P",{"data-svelte-h":!0}),g(W)!=="svelte-9sr7nh"&&(W.textContent=Tt),et=n(t),o(v.$$.fragment,t),nt=n(t),G=m(t,"P",{"data-svelte-h":!0}),g(G)!=="svelte-1kguc51"&&(G.innerHTML=ft),pt=n(t),o(k.$$.fragment,t),mt=n(t),B=m(t,"P",{"data-svelte-h":!0}),g(B)!=="svelte-xtxxu6"&&(B.innerHTML=bt),it=n(t),o(N.$$.fragment,t),ot=n(t),o(Q.$$.fragment,t),ct=n(t),o(E.$$.fragment,t),rt=n(t),R=m(t,"P",{}),Ut(R).forEach(l),this.h()},h(){$t(j,"name","hf:doc:metadata"),$t(j,"content",Nt)},m(t,s){Gt(document.head,j),a(t,A,s),a(t,V,s),a(t,Y,s),c(d,t,s),a(t,S,s),a(t,w,s),a(t,H,s),c(y,t,s),a(t,z,s),a(t,J,s),a(t,F,s),c(u,t,s),a(t,L,s),a(t,T,s),a(t,D,s),c(f,t,s),a(t,q,s),a(t,b,s),a(t,P,s),c(U,t,s),a(t,K,s),a(t,$,s),a(t,O,s),c(x,t,s),a(t,tt,s),a(t,C,s),a(t,st,s),a(t,I,s),a(t,lt,s),c(Z,t,s),a(t,at,s),a(t,W,s),a(t,et,s),c(v,t,s),a(t,nt,s),a(t,G,s),a(t,pt,s),c(k,t,s),a(t,mt,s),a(t,B,s),a(t,it,s),c(N,t,s),a(t,ot,s),c(Q,t,s),a(t,ct,s),c(E,t,s),a(t,rt,s),a(t,R,s),ht=!0},p:Ct,i(t){ht||(r(d.$$.fragment,t),r(y.$$.fragment,t),r(u.$$.fragment,t),r(f.$$.fragment,t),r(U.$$.fragment,t),r(x.$$.fragment,t),r(Z.$$.fragment,t),r(v.$$.fragment,t),r(k.$$.fragment,t),r(N.$$.fragment,t),r(Q.$$.fragment,t),r(E.$$.fragment,t),ht=!0)},o(t){h(d.$$.fragment,t),h(y.$$.fragment,t),h(u.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h(x.$$.fragment,t),h(Z.$$.fragment,t),h(v.$$.fragment,t),h(k.$$.fragment,t),h(N.$$.fragment,t),h(Q.$$.fragment,t),h(E.$$.fragment,t),ht=!1},d(t){t&&(l(A),l(V),l(Y),l(S),l(w),l(H),l(z),l(J),l(F),l(L),l(T),l(D),l(q),l(b),l(P),l(K),l($),l(O),l(tt),l(C),l(st),l(I),l(lt),l(at),l(W),l(et),l(nt),l(G),l(pt),l(mt),l(B),l(it),l(ot),l(ct),l(rt),l(R)),l(j),M(d,t),M(y,t),M(u,t),M(f,t),M(U,t),M(x,t),M(Z,t),M(v,t),M(k,t),M(N,t),M(Q,t),M(E,t)}}}const Nt='{"title":"MixNet","local":"mixnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Qt(Mt){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xt extends Zt{constructor(j){super(),Wt(this,j,Qt,Bt,xt,{})}}export{Xt as component};
