import{s as $s,n as ks,o as Ws}from"../chunks/scheduler.85c25b89.js";import{S as Zs,i as Cs,g as p,s as e,r as i,A as Ns,h as m,f as a,c as n,j as Us,u as o,x as M,k as Is,y as Bs,a as l,v as r,d as c,t as h,w as J}from"../chunks/index.c9837788.js";import{C as X}from"../chunks/CodeBlock.e573519b.js";import{H as _,E as Gs}from"../chunks/index.b36f1b99.js";function xs(Js){let w,V,Q,S,g,z,d,Ms="<strong>Single-Path NAS</strong> is a novel differentiable NAS method for designing hardware-efficient ConvNets in less than 4 hours.",A,y,H,j,ws="To load a pretrained model:",F,T,D,u,gs="To load and preprocess the image:",L,f,P,b,ds="To get the model predictions:",q,U,K,I,ys="To get the top-5 predictions class names:",O,$,ss,k,js="Replace the model name with the variant you want to use, e.g. <code>spnasnet_100</code>. You can find the IDs in the model summaries at the top of this page.",ts,W,Ts='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',as,Z,ls,C,us="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",es,N,ns,B,fs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ps,G,ms,x,bs='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',is,E,os,v,rs,R,cs,Y,hs;return g=new _({props:{title:"SPNASNet",local:"spnasnet",headingTag:"h1"}}),y=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3NwbmFzbmV0XzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;spnasnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),Z=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc3BuYXNuZXRfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;spnasnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),v=new X({props:{code:"JTQwbWlzYyU3QnN0YW1vdWxpczIwMTlzaW5nbGVwYXRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JTaW5nbGUtUGF0aCUyME5BUyUzQSUyMERlc2lnbmluZyUyMEhhcmR3YXJlLUVmZmljaWVudCUyMENvbnZOZXRzJTIwaW4lMjBsZXNzJTIwdGhhbiUyMDQlMjBIb3VycyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QkRpbWl0cmlvcyUyMFN0YW1vdWxpcyUyMGFuZCUyMFJ1aXpob3UlMjBEaW5nJTIwYW5kJTIwRGklMjBXYW5nJTIwYW5kJTIwRGltaXRyaW9zJTIwTHltYmVyb3BvdWxvcyUyMGFuZCUyMEJvZGhpJTIwUHJpeWFudGhhJTIwYW5kJTIwSmllJTIwTGl1JTIwYW5kJTIwRGlhbmElMjBNYXJjdWxlc2N1JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTA0LjAyODc3JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuTEclN0QlMEElN0Q=",highlighted:`@misc{stamoulis2019singlepath,
      title={Single-Path NAS: Designing Hardware-Efficient ConvNets in less than <span class="hljs-number">4</span> Hours}, 
      author={<span class="hljs-keyword">Dimitrios </span>Stamoulis <span class="hljs-keyword">and </span>Ruizhou <span class="hljs-keyword">Ding </span><span class="hljs-keyword">and </span><span class="hljs-keyword">Di </span>Wang <span class="hljs-keyword">and </span><span class="hljs-keyword">Dimitrios </span>Lymberopoulos <span class="hljs-keyword">and </span><span class="hljs-keyword">Bodhi </span>Priyantha <span class="hljs-keyword">and </span><span class="hljs-keyword">Jie </span>Liu <span class="hljs-keyword">and </span><span class="hljs-keyword">Diana </span>Marculescu},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1904</span>.<span class="hljs-number">02877</span>},
      archivePrefix={arXiv},
      primaryClass={cs.LG}
}`,wrap:!1}}),R=new Gs({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/spnasnet.mdx"}}),{c(){w=p("meta"),V=e(),Q=p("p"),S=e(),i(g.$$.fragment),z=e(),d=p("p"),d.innerHTML=Ms,A=e(),i(y.$$.fragment),H=e(),j=p("p"),j.textContent=ws,F=e(),i(T.$$.fragment),D=e(),u=p("p"),u.textContent=gs,L=e(),i(f.$$.fragment),P=e(),b=p("p"),b.textContent=ds,q=e(),i(U.$$.fragment),K=e(),I=p("p"),I.textContent=ys,O=e(),i($.$$.fragment),ss=e(),k=p("p"),k.innerHTML=js,ts=e(),W=p("p"),W.innerHTML=Ts,as=e(),i(Z.$$.fragment),ls=e(),C=p("p"),C.textContent=us,es=e(),i(N.$$.fragment),ns=e(),B=p("p"),B.innerHTML=fs,ps=e(),i(G.$$.fragment),ms=e(),x=p("p"),x.innerHTML=bs,is=e(),i(E.$$.fragment),os=e(),i(v.$$.fragment),rs=e(),i(R.$$.fragment),cs=e(),Y=p("p"),this.h()},l(s){const t=Ns("svelte-u9bgzb",document.head);w=m(t,"META",{name:!0,content:!0}),t.forEach(a),V=n(s),Q=m(s,"P",{}),Us(Q).forEach(a),S=n(s),o(g.$$.fragment,s),z=n(s),d=m(s,"P",{"data-svelte-h":!0}),M(d)!=="svelte-15s7q8i"&&(d.innerHTML=Ms),A=n(s),o(y.$$.fragment,s),H=n(s),j=m(s,"P",{"data-svelte-h":!0}),M(j)!=="svelte-18ywhxh"&&(j.textContent=ws),F=n(s),o(T.$$.fragment,s),D=n(s),u=m(s,"P",{"data-svelte-h":!0}),M(u)!=="svelte-1c2ipa8"&&(u.textContent=gs),L=n(s),o(f.$$.fragment,s),P=n(s),b=m(s,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1n9qsq1"&&(b.textContent=ds),q=n(s),o(U.$$.fragment,s),K=n(s),I=m(s,"P",{"data-svelte-h":!0}),M(I)!=="svelte-19cnvx1"&&(I.textContent=ys),O=n(s),o($.$$.fragment,s),ss=n(s),k=m(s,"P",{"data-svelte-h":!0}),M(k)!=="svelte-d1japu"&&(k.innerHTML=js),ts=n(s),W=m(s,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1wmi3ea"&&(W.innerHTML=Ts),as=n(s),o(Z.$$.fragment,s),ls=n(s),C=m(s,"P",{"data-svelte-h":!0}),M(C)!=="svelte-9sr7nh"&&(C.textContent=us),es=n(s),o(N.$$.fragment,s),ns=n(s),B=m(s,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1kguc51"&&(B.innerHTML=fs),ps=n(s),o(G.$$.fragment,s),ms=n(s),x=m(s,"P",{"data-svelte-h":!0}),M(x)!=="svelte-xtxxu6"&&(x.innerHTML=bs),is=n(s),o(E.$$.fragment,s),os=n(s),o(v.$$.fragment,s),rs=n(s),o(R.$$.fragment,s),cs=n(s),Y=m(s,"P",{}),Us(Y).forEach(a),this.h()},h(){Is(w,"name","hf:doc:metadata"),Is(w,"content",Es)},m(s,t){Bs(document.head,w),l(s,V,t),l(s,Q,t),l(s,S,t),r(g,s,t),l(s,z,t),l(s,d,t),l(s,A,t),r(y,s,t),l(s,H,t),l(s,j,t),l(s,F,t),r(T,s,t),l(s,D,t),l(s,u,t),l(s,L,t),r(f,s,t),l(s,P,t),l(s,b,t),l(s,q,t),r(U,s,t),l(s,K,t),l(s,I,t),l(s,O,t),r($,s,t),l(s,ss,t),l(s,k,t),l(s,ts,t),l(s,W,t),l(s,as,t),r(Z,s,t),l(s,ls,t),l(s,C,t),l(s,es,t),r(N,s,t),l(s,ns,t),l(s,B,t),l(s,ps,t),r(G,s,t),l(s,ms,t),l(s,x,t),l(s,is,t),r(E,s,t),l(s,os,t),r(v,s,t),l(s,rs,t),r(R,s,t),l(s,cs,t),l(s,Y,t),hs=!0},p:ks,i(s){hs||(c(g.$$.fragment,s),c(y.$$.fragment,s),c(T.$$.fragment,s),c(f.$$.fragment,s),c(U.$$.fragment,s),c($.$$.fragment,s),c(Z.$$.fragment,s),c(N.$$.fragment,s),c(G.$$.fragment,s),c(E.$$.fragment,s),c(v.$$.fragment,s),c(R.$$.fragment,s),hs=!0)},o(s){h(g.$$.fragment,s),h(y.$$.fragment,s),h(T.$$.fragment,s),h(f.$$.fragment,s),h(U.$$.fragment,s),h($.$$.fragment,s),h(Z.$$.fragment,s),h(N.$$.fragment,s),h(G.$$.fragment,s),h(E.$$.fragment,s),h(v.$$.fragment,s),h(R.$$.fragment,s),hs=!1},d(s){s&&(a(V),a(Q),a(S),a(z),a(d),a(A),a(H),a(j),a(F),a(D),a(u),a(L),a(P),a(b),a(q),a(K),a(I),a(O),a(ss),a(k),a(ts),a(W),a(as),a(ls),a(C),a(es),a(ns),a(B),a(ps),a(ms),a(x),a(is),a(os),a(rs),a(cs),a(Y)),a(w),J(g,s),J(y,s),J(T,s),J(f,s),J(U,s),J($,s),J(Z,s),J(N,s),J(G,s),J(E,s),J(v,s),J(R,s)}}}const Es='{"title":"SPNASNet","local":"spnasnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function vs(Js){return Ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _s extends Zs{constructor(w){super(),Cs(this,w,vs,xs,$s,{})}}export{_s as component};
