# Deploy with your own container

If the available Inference Engines don't meet your requirements, you can deploy your own custom solution as a Docker container and run
it on Inference Endpoints. You can use public images like `tensorflow/serving:2.7.3` or private images hosted on
[Docker Hub](https://hub.docker.com/), [AWS ECR](https://aws.amazon.com/ecr/?nc1=h_ls),
[Azure ACR](https://azure.microsoft.com/de-de/services/container-registry/), or [Google GCR](https://cloud.google.com/container-registry?hl=de).

![custom container](https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/custom_container/custom-container.png)

The [creation flow](/docs/inference-endpoints/guides/create_endpoint) of your image artifacts from a custom image is the same as the
base image. This means Inference Endpoints will create a unique image artifact derived from your provided image, including all model
artifacts. 

The model artifacts (weights) are stored under `/repository`. For example, if you use `tensorflow/serving` as your custom image,
then you have to set `model_base_path="/repository":

```
tensorflow_model_server \
  --rest_api_port=5000 \
  --model_name=my_model \
  --model_base_path="/repository"
```


<EditOnGithub source="https://github.com/huggingface/hf-endpoints-documentation/blob/main/docs/source/engines/custom_container.md" />