import{s as Bs,o as Rs,n as mn}from"../chunks/scheduler.c57aa7ef.js";import{S as Is,i as Ls,g as i,s as n,r as p,A as Ws,h as o,f as a,c as s,j as Cs,u as d,x as r,k as pn,y as Gs,a as l,v as m,d as f,t as h,w as c}from"../chunks/index.394f8801.js";import{T as dn}from"../chunks/Tip.23dfb1a9.js";import{C as M}from"../chunks/CodeBlock.b5488637.js";import{H as y,E as Vs}from"../chunks/getInferenceSnippets.f8d61fb8.js";function As(T){let u,b='For further instructions on using EVA, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/eva_finetuning" rel="nofollow">documentation</a>.';return{c(){u=i("p"),u.innerHTML=b},l(w){u=o(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-9hfq4t"&&(u.innerHTML=b)},m(w,g){l(w,u,g)},p:mn,d(w){w&&a(u)}}}function Xs(T){let u,b='Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.';return{c(){u=i("p"),u.innerHTML=b},l(w){u=o(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1nbpolx"&&(u.innerHTML=b)},m(w,g){l(w,u,g)},p:mn,d(w){w&&a(u)}}}function xs(T){let u,b='There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.';return{c(){u=i("p"),u.innerHTML=b},l(w){u=o(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-19y7vpj"&&(u.innerHTML=b)},m(w,g){l(w,u,g)},p:mn,d(w){w&&a(u)}}}function Qs(T){let u,b,w,g,v,zt,$,fn='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Ht,k,hn="This guide explores in more detail other options and features for using LoRA.",Ft,U,Et,C,cn='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',Yt,B,un='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',qt,R,Nt,I,Mn="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",St,L,Pt,W,Dt,G,wn='<a href="https://huggingface.co/papers/2404.02948" rel="nofollow">PiSSA</a> initializes the LoRA adapter using the principal singular values and singular vectors. This straightforward modification allows PiSSA to converge more rapidly than LoRA and ultimately attain superior performance. Moreover, PiSSA reduces the quantization error compared to QLoRA, leading to further enhancements.',Kt,V,yn="Configure the initialization method to “pissa”, which may take several minutes to execute SVD on the pre-trained model:",Ot,A,ea,X,bn="Alternatively, execute fast SVD, which takes only a few seconds. The number of iterations determines the trade-off between the error and computation time:",ta,x,aa,Q,gn='For detailed instruction on using PiSSA, please follow <a href="https://github.com/huggingface/peft/tree/main/examples/pissa_finetuning" rel="nofollow">these instructions</a>.',la,z,na,H,Tn=`<a href="https://huggingface.co/papers/2406.05223" rel="nofollow">CorDA</a> builds task-aware LoRA adapters from weight decomposition oriented by the context of downstream task to learn (instruction-previewed mode, IPM) or world knowledge to maintain (knowledge-preserved mode, KPM).
The KPM not only achieves better performance than LoRA on fine-tuning tasks, but also mitigates the catastrophic forgetting of pre-trained world knowledge.
When preserving pre-trained knowledge is not a concern,
the IPM is favored because it can further accelerate convergence and enhance the fine-tuning performance.`,sa,F,Jn="You need to configure the initialization method to “corda”, and specify the mode of IPM or KPM and the dataset to collect covariance matrices.",ia,E,oa,Y,_n='For detailed instruction on using CorDA, please follow <a href="https://github.com/huggingface/peft/tree/main/examples/corda_finetuning" rel="nofollow">these instructions</a>.',ra,q,pa,N,Zn='<a href="https://huggingface.co/papers/2406.01775" rel="nofollow">OLoRA</a> utilizes QR decomposition to initialize the LoRA adapters. OLoRA translates the base weights of the model by a factor of their QR decompositions, i.e., it mutates the weights before performing any training on them. This approach significantly improves stability, accelerates convergence speed, and ultimately achieves superior performance.',da,S,jn="You just need to pass a single additional option to use OLoRA:",ma,P,fa,D,vn='For more advanced usage, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/olora_finetuning" rel="nofollow">documentation</a>.',ha,K,ca,O,$n='<a href="https://huggingface.co/papers/2410.07170" rel="nofollow">EVA</a> performs SVD on the input activations of each layer and uses the right-singular vectors to initialize LoRA weights. It is therefore a data-driven initialization scheme. Furthermore EVA adaptively allocates ranks across layers based on their “explained variance ratio” - a metric derived from the SVD analysis.',ua,ee,kn='You can use EVA by setting <code>init_lora_weights=&quot;eva&quot;</code> and defining <a href="/docs/peft/main/en/package_reference/lora#peft.EvaConfig">EvaConfig</a> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>:',Ma,te,wa,ae,Un="The parameter <code>rho</code> (≥ 1.0) determines how much redistribution is allowed. When <code>rho=1.0</code> and <code>r=16</code>, LoRA adapters are limited to exactly 16 ranks, preventing any redistribution from occurring. A recommended value for EVA with redistribution is 2.0, meaning the maximum rank allowed for a layer is 2r.",ya,le,Cn='It is recommended to perform EVA initialization on a GPU as it is much faster. To optimize the amount of available memory for EVA, you can use the <code>low_cpu_mem_usage</code> flag in <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a>:',ba,ne,ga,se,Bn='Then, call <a href="/docs/peft/main/en/package_reference/lora#peft.initialize_lora_eva_weights">initialize_lora_eva_weights()</a> to initialize the EVA weights (in most cases the dataloader used for eva initialization can be the same as the one used for finetuning):',Ta,ie,Ja,oe,Rn='EVA works out of the box with bitsandbytes. Simply initialize the model with <code>quantization_config</code> and call <a href="/docs/peft/main/en/package_reference/lora#peft.initialize_lora_eva_weights">initialize_lora_eva_weights()</a> as usual.',_a,J,Za,re,ja,pe,va,de,In='When quantizing the base model for QLoRA training, consider using the <a href="https://huggingface.co/papers/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. To use LoftQ, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',$a,me,Ln="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",ka,fe,Ua,he,Wn="An easier but more limited way to apply LoftQ initialization is to use the convenience function <code>replace_lora_weights_loftq</code>. This takes the quantized PEFT model as input and replaces the LoRA weights in-place with their LoftQ-initialized counterparts.",Ca,ce,Ba,ue,Gn='<code>replace_lora_weights_loftq</code> also allows you to pass a <code>callback</code> argument to give you more control over which layers should be modified or not, which empirically can improve the results quite a lot. To see a more elaborate example of this, check out <a href="https://github.com/huggingface/peft/blob/main/examples/loftq_finetuning/LoftQ_weight_replacement.ipynb" rel="nofollow">this notebook</a>.',Ra,Me,Vn="<code>replace_lora_weights_loftq</code> implements only one iteration step of LoftQ. This means that only the LoRA weights are updated, instead of iteratively updating LoRA weights and quantized base model weights. This may lead to lower performance but has the advantage that we can use the original quantized weights derived from the base model, instead of having to keep an extra copy of modified quantized weights. Whether this tradeoff is worthwhile depends on the use case.",Ia,we,An="At the moment, <code>replace_lora_weights_loftq</code> has these additional limitations:",La,ye,Xn="<li>Model files must be stored as a <code>safetensors</code> file.</li> <li>Only bitsandbytes 4bit quantization is supported.</li>",Wa,_,Ga,be,Va,ge,xn='Another way to initialize <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',Aa,Te,Xa,Je,xa,_e,Qn='This technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can improve the performance of LoRA, especially at low ranks. For more information on DoRA, see  <a href="https://huggingface.co/papers/2402.09353" rel="nofollow">https://huggingface.co/papers/2402.09353</a>.',Qa,Ze,za,je,zn="If parts of the model or the DoRA adapter are offloaded to CPU you can get a significant speedup at the cost of some temporary (ephemeral) VRAM overhead by using <code>ephemeral_gpu_offload=True</code> in <code>config.runtime_config</code>.",Ha,ve,Fa,$e,Hn="A <code>PeftModel</code> with a DoRA adapter can also be loaded with <code>ephemeral_gpu_offload=True</code> flag using the <code>from_pretrained</code> method as well as the <code>load_adapter</code> method.",Ea,ke,Ya,Ue,Fn=`DoRA is optimized (computes faster and takes less memory) for models in the evaluation mode, or when dropout is set to 0. We reuse the
base result at those times to get the speedup.
Running <a href="https://github.com/huggingface/peft/blob/main/examples/dora_finetuning/dora_finetuning.py" rel="nofollow">dora finetuning</a>
with <code>CUDA_VISIBLE_DEVICES=0 time python examples/dora_finetuning/dora_finetuning.py --quantize --lora_dropout 0 --batch_size 16 --eval_step 2 --use_dora</code>
on a 4090 with gradient accumulation set to 2 and max step to 20 resulted with the following observations:`,qa,Ce,En='<thead><tr><th align="center"></th> <th align="center">Without Optimization</th> <th align="center">With Optimization</th></tr></thead> <tbody><tr><td align="center">train_runtime</td> <td align="center">359.7298</td> <td align="center"><strong>279.2676</strong></td></tr> <tr><td align="center">train_samples_per_second</td> <td align="center">1.779</td> <td align="center"><strong>2.292</strong></td></tr> <tr><td align="center">train_steps_per_second</td> <td align="center">0.056</td> <td align="center"><strong>0.072</strong></td></tr></tbody>',Na,Be,Sa,Re,Yn='<li>DoRA only supports embedding, linear, and Conv2d layers at the moment.</li> <li>DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for inference, see <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">LoraModel.merge_and_unload()</a>.</li> <li>DoRA should work with weights quantized with bitsandbytes (“QDoRA”). However, issues have been reported when using QDoRA with DeepSpeed Zero2.</li>',Pa,Ie,Da,Le,qn='The default LoRA settings in PEFT add trainable weights to the query and value layers of each attention block. But <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, which adds trainable weights to all the linear layers of a transformer model, can provide performance equal to a fully finetuned model. To apply LoRA to all the linear layers, like in QLoRA, set <code>target_modules=&quot;all-linear&quot;</code> (easier than specifying individual modules by name which can vary depending on the architecture).',Ka,We,Oa,Ge,el,Ve,Nn='An approach used to improve the performance of models is to expand a model by duplicating layers in the model to build a larger model from a pretrained model of a given size. For example increasing a 7B model to a 10B model as described in the <a href="https://huggingface.co/papers/2312.15166" rel="nofollow">SOLAR</a> paper. PEFT LoRA supports this kind of expansion in a memory efficient manner that supports further fine-tuning using LoRA adapters attached to the layers post replication of the layers. The replicated layers do not take additional memory as they share the underlying weights so the only additional memory required is the memory for the adapter weights. To use this feature you would create a config with the <code>layer_replication</code> argument.',tl,Ae,al,Xe,Sn='Assuming the original model had 5 layers <code>[0, 1, 2 ,3, 4]</code>, this would create a model with 7 layers arranged as <code>[0, 1, 2, 3, 2, 3, 4]</code>. This follows the <a href="https://github.com/arcee-ai/mergekit" rel="nofollow">mergekit</a> pass through merge convention where sequences of layers specified as start inclusive and end exclusive tuples are stacked to build the final model. Each layer in the final model gets its own distinct set of LoRA adapters.',ll,xe,Pn=`<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B" rel="nofollow">Fewshot-Metamath-OrcaVicuna-Mistral-10B</a> is an example of a model trained using this method on Mistral-7B expanded to 10B. The
<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B/blob/main/adapter_config.json" rel="nofollow">adapter_config.json</a> shows a sample LoRA adapter config applying this method for fine-tuning.`,nl,Qe,sl,ze,Dn='By default, all layers targeted with LoRA will have the same rank <code>r</code> and the same <code>lora_alpha</code> (which determines the LoRA scaling), depending on what was specified in the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. In some cases, however, you may want to indicate different values for different layers. This is possible by passing the <code>rank_pattern</code> and <code>alpha_pattern</code> arguments to <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. These arguments should be dictionaries with the key being the layer name and the value being the rank/alpha value. The keys can be <a href="https://docs.python.org/3/library/re.html" rel="nofollow">regular expressions</a> (regex). All LoRA layers that are not explicitly mentioned in <code>rank_pattern</code> and <code>alpha_pattern</code> will take the default <code>r</code> and <code>lora_alpha</code> values.',il,He,Kn="To give an example, let’s assume that we have a model with the following structure:",ol,Fe,rl,Ee,On="<li><code>rank_pattern={&quot;foo&quot;: 42}</code> will match all 3 <code>foo</code> layers. Neither <code>foobar</code> nor <code>barfoo</code> are matched.</li> <li><code>rank_pattern={&quot;^foo&quot;: 42}</code> will only match the <code>foo</code> layer of the model, but neither <code>module.foo</code> nor <code>module.module.foo</code>. This is because the <code>^</code> means “start of string” when using regular expressions, and only <code>foo</code> starts with <code>&quot;foo&quot;</code>, the other layer names have prefixes.</li> <li><code>rank_pattern={&quot;^module.foo&quot;: 42}</code> matches only <code>module.foo</code>, but not <code>module.module.foo</code>, for the same reason.</li> <li><code>rank_pattern={&quot;module.foo&quot;: 42}</code> matches both <code>module.foo</code> and <code>module.module.foo</code>, but not <code>foo</code>.</li> <li><code>rank_pattern={&quot;^foo&quot;: 42, &quot;^module.module.foo&quot;: 55}</code> matches <code>foo</code> and <code>module.module.foo</code>, respectively, but not <code>module.foo</code>.</li> <li>There is no need to indicate <code>$</code> to mark the end of the match, as this is added automatically by PEFT.</li>",pl,Ye,es="The same logic applies to <code>alpha_pattern</code>. If you’re in doubt, don’t try to get fancy with regular expressions — just pass the full name for each module with a different rank/alpha, preceded by the <code>^</code> prefix, and you should be good.",dl,qe,ml,Ne,ts="LoRA training can optionally include special purpose optimizers. Currently PEFT supports LoRA-FA and LoRA+.",fl,Se,hl,Pe,as='LoRA training can be more effective and efficient using LoRA-FA, as described in <a href="https://huggingface.co/papers/2308.03303" rel="nofollow">LoRA-FA</a>. LoRA-FA reduces activation memory consumption by fixing the matrix A and only tuning the matrix B. During training, the gradient of B is optimized to approximate the full parameter fine-tuning gradient. Moreover, the memory consumption of LoRA-FA is not sensitive to the rank (since it erases the activation of $A$), therefore it can improve performance by enlarging lora rank without increasing memory consumption.',cl,De,ul,Ke,Ml,Oe,ls='LoRA training can be optimized using <a href="https://huggingface.co/papers/2402.12354" rel="nofollow">LoRA+</a>, which uses different learning rates for the adapter matrices A and B, shown to increase finetuning speed by up to 2x and performance by 1-2%.',wl,et,yl,tt,bl,at,ns='Sometimes it is necessary to not only change some layer’s weights but to add new tokens as well. With larger models this can be a memory-costly endeavour. PEFT LoRA adapters support the <code>trainable_token_indices</code> parameter which allows tuning of other tokens alongside fine-tuning of specific layers with LoRA. This method only trains the tokens you specify and leaves all other tokens untouched. This saves memory and doesn’t throw away learned context of existing token embeddings in contrast to when training the whole embedding matrix. Under the hood this method uses the layer of <a href="/docs/peft/main/en/package_reference/trainable_tokens#peft.TrainableTokensModel">TrainableTokensModel</a>.',gl,lt,Tl,nt,ss="In the snippet below we show how to add new tokens to the model and how to train it alongside the other layers in the model.",Jl,st,_l,it,is=`The token weights are part of your adapter state dict and saved alongside the LoRA weights.
If we would have used full fine-tuning with <code>modules_to_save=[&#39;embed_tokens&#39;]</code> we would have stored the full embedding matrix in the checkpoint, leading to a much bigger file.`,Zl,ot,os="To give a bit of an indication how much VRAM can be saved, a rudimentary comparison of the above example was made between training the embedding matrix fully (<code>modules_to_save=[&quot;embed_tokens&quot;]</code>), using a LoRA for the embedding matrix (<code>target_modules=[..., &quot;embed_tokens&quot;]</code>, rank 32) and trainable tokens (<code>trainable_token_indices=[...]</code>, 6 tokens). Trainable tokens used about as much VRAM (15,562MB vs. 15,581MB) as LoRA while being specific to the tokens and saved ~1GB of VRAM over fully training the embedding matrix.",jl,rt,vl,pt,rs='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',$l,dt,ps="Below is a diagram that explains the intuition of LoRA adapter merging:",kl,Z,ds='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_diagram.png"/>',Ul,mt,ms="We show in the snippets below how to run that using PEFT.",Cl,ft,Bl,ht,fs='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',Rl,ct,Il,ut,hs='The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',Ll,Mt,cs="First load the base model:",Wl,wt,Gl,yt,us="Then we load the first adapter:",Vl,bt,Al,gt,Ms="Then load a different adapter and merge it with the first one:",Xl,Tt,xl,j,Ql,Jt,ws="Now, perform inference:",zl,_t,Hl,Zt,Fl,jt,ys='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.set_adapter">set_adapter()</a> function.',El,vt,Yl,$t,bs='To return the base model, you could use <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',ql,kt,Nl,Ut,Sl,Ct,gs="Normally, each inference batch has to use the same adapter(s) in PEFT. This can sometimes be annoying, because we may have batches that contain samples intended to be used with different LoRA adapters. For example, we could have a base model that works well in English and two more LoRA adapters, one for French and one for German. Usually, we would have to split our batches such that each batch only contains samples of one of the languages, we cannot combine different languages in the same batch.",Pl,Bt,Ts="Thankfully, it is possible to mix different LoRA adapters in the same batch using the <code>adapter_name</code> argument. Below, we show an example of how this works in practice. First, let’s load the base model, English, and the two adapters, French and German, like this:",Dl,Rt,Kl,It,Js="Now, we want to generate text on a sample that contains all three languages: The first three samples are in English, the next three are in French, and the last three are in German. We can use the <code>adapter_names</code> argument to specify which adapter to use for each sample. Since our base model is used for English, we use the special string <code>&quot;__base__&quot;</code> for these samples. For the next three samples, we indicate the adapter name of the French LoRA fine-tune, in this case <code>&quot;adapter_fr&quot;</code>. For the last three samples, we indicate the adapter name of the German LoRA fine-tune, in this case <code>&quot;adapter_de&quot;</code>. This way, we can use the base model and the two adapters in a single batch.",Ol,Lt,en,Wt,_s="Note that the order does not matter here, i.e. the samples in the batch don’t need to be grouped by adapter as in the example above. We just need to ensure that the <code>adapter_names</code> argument is aligned correctly with the samples.",tn,Gt,Zs="Additionally, the same approach also works with the <code>modules_to_save</code> feature, which allows for saving and reusing specific neural network layers, such as custom heads for classification tasks, across different LoRA adapters.",an,Vt,ln,At,js="Using this feature has some drawbacks, namely:",nn,Xt,vs='<li>It only works for inference, not for training.</li> <li>Disabling adapters using the <code>with model.disable_adapter()</code> context takes precedence over <code>adapter_names</code>.</li> <li>You cannot pass <code>adapter_names</code> when some adapter weights were merged with base weight using the <code>merge_adapter</code> method. Please unmerge all adapters first by calling <code>model.unmerge_adapter()</code>.</li> <li>For obvious reasons, this cannot be used after calling <code>merge_and_unload()</code>, since all the LoRA adapters will be merged into the base weights in this case.</li> <li>This feature does not currently work with DoRA, so set <code>use_dora=False</code> in your <code>LoraConfig</code> if you want to use it.</li> <li>The <code>modules_to_save</code> feature is currently only supported for the layers of types <code>Linear</code>, <code>Embedding</code>, <code>Conv2d</code> and <code>Conv1d</code>.</li> <li>There is an expected overhead for inference with <code>adapter_names</code>, especially if the amount of different adapters in the batch is high. This is because the batch size is effectively reduced to the number of samples per adapter. If runtime performance is your top priority, try the following:<ul><li>Increase the batch size.</li> <li>Try to avoid having a large number of different adapters in the same batch, prefer homogeneous batches. This can be achieved by buffering samples with the same adapter and only perform inference with a small handful of different adapters.</li> <li>Take a look at alternative implementations such as <a href="https://github.com/predibase/lorax" rel="nofollow">LoRAX</a>, <a href="https://github.com/punica-ai/punica" rel="nofollow">punica</a>, or <a href="https://github.com/S-LoRA/S-LoRA" rel="nofollow">S-LoRA</a>, which are specialized to work with a large number of different adapters.</li></ul></li>',sn,xt,on,Qt,rn;return v=new y({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),U=new y({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),R=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),L=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),W=new y({props:{title:"PiSSA",local:"pissa",headingTag:"h3"}}),A=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMnBpc3NhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa&quot;</span>, ...)`,wrap:!1}}),x=new M({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKGluaXRfbG9yYV93ZWlnaHRzJTNEJTIycGlzc2Ffbml0ZXJfJTVCbnVtYmVyJTIwb2YlMjBpdGVycyU1RCUyMiUyQyUyMC4uLik=",highlighted:'lora_config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa_niter_[number of iters]&quot;</span>, ...)',wrap:!1}}),z=new y({props:{title:"CorDA",local:"corda",headingTag:"h3"}}),E=new M({props:{code:"JTQwdG9yY2gubm9fZ3JhZCgpJTBBZGVmJTIwcnVuX21vZGVsKCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBBc3N1bWUlMjAlNjBtb2RlbCU2MCUyMGFuZCUyMCU2MGRhdGFzZXQlNjAlMjBpcyUyMGluJTIwY29udGV4dC4uLiUwQSUyMCUyMCUyMCUyMG1vZGVsLmV2YWwoKSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjBkYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwoKipiYXRjaCklMEElMEElMEFjb3JkYV9jb25maWclMjAlM0QlMjBDb3JkYUNvbmZpZyglMEElMjAlMjAlMjAlMjBjb3JkYV9tZXRob2QlM0QlMjJrcG0lMjIlMkMlMEEpJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTNEJTIyY29yZGElMjIlMkMlMEElMjAlMjAlMjAlMjBjb3JkYV9jb25maWclM0Rjb3JkYV9jb25maWclMkMlMEEpJTBBcHJlcHJvY2Vzc19jb3JkYShtb2RlbCUyQyUyMGxvcmFfY29uZmlnJTJDJTIwcnVuX21vZGVsJTNEcnVuX21vZGVsKSUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGxvcmFfY29uZmlnKQ==",highlighted:`<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_model</span>():
    <span class="hljs-comment"># Assume \`model\` and \`dataset\` is in context...</span>
    model.<span class="hljs-built_in">eval</span>()
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataset:
        model(**batch)


corda_config = CordaConfig(
    corda_method=<span class="hljs-string">&quot;kpm&quot;</span>,
)
lora_config = LoraConfig(
    init_lora_weights=<span class="hljs-string">&quot;corda&quot;</span>,
    corda_config=corda_config,
)
preprocess_corda(model, lora_config, run_model=run_model)
peft_model = get_peft_model(model, lora_config)`,wrap:!1}}),q=new y({props:{title:"OLoRA",local:"olora",headingTag:"h3"}}),P=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMm9sb3JhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;olora&quot;</span>, ...)`,wrap:!1}}),K=new y({props:{title:"EVA",local:"eva",headingTag:"h3"}}),te=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwRXZhQ29uZmlnJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTIwJTNEJTIwJTIyZXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXZhX2NvbmZpZyUyMCUzRCUyMEV2YUNvbmZpZyhyaG8lMjAlM0QlMjAyLjApJTJDJTBBJTIwJTIwJTIwJTIwLi4uJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, EvaConfig
peft_config = LoraConfig(
    init_lora_weights = <span class="hljs-string">&quot;eva&quot;</span>,
    eva_config = EvaConfig(rho = <span class="hljs-number">2.0</span>),
    ...
)`,wrap:!1}}),ne=new M({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwcGVmdF9jb25maWclMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUp",highlighted:'peft_model = get_peft_model(model, peft_config, low_cpu_mem_usage=<span class="hljs-literal">True</span>)',wrap:!1}}),ie=new M({props:{code:"aW5pdGlhbGl6ZV9sb3JhX2V2YV93ZWlnaHRzKHBlZnRfbW9kZWwlMkMlMjBkYXRhbG9hZGVyKQ==",highlighted:"initialize_lora_eva_weights(peft_model, dataloader)",wrap:!1}}),J=new dn({props:{$$slots:{default:[As]},$$scope:{ctx:T}}}),re=new y({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),pe=new y({props:{title:"Standard approach",local:"standard-approach",headingTag:"h4"}}),fe=new y({props:{title:"A more convenient way",local:"a-more-convenient-way",headingTag:"h4"}}),ce=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjByZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjAuLi4pJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCguLi4lMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEElMjMlMjBub3RlJTNBJTIwZG9uJ3QlMjBwYXNzJTIwaW5pdF9sb3JhX3dlaWdodHMlM0QlMjJsb2Z0cSUyMiUyMG9yJTIwbG9mdHFfY29uZmlnISUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIpJTBBcGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBsb3JhX2NvbmZpZyklMEFyZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cShwZWZ0X21vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> replace_lora_weights_loftq
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, ...)
base_model = AutoModelForCausalLM.from_pretrained(..., quantization_config=bnb_config)
<span class="hljs-comment"># note: don&#x27;t pass init_lora_weights=&quot;loftq&quot; or loftq_config!</span>
lora_config = LoraConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>)
peft_model = get_peft_model(base_model, lora_config)
replace_lora_weights_loftq(peft_model)`,wrap:!1}}),_=new dn({props:{$$slots:{default:[Xs]},$$scope:{ctx:T}}}),be=new y({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),Te=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),Je=new y({props:{title:"Weight-Decomposed Low-Rank Adaptation (DoRA)",local:"weight-decomposed-low-rank-adaptation-dora",headingTag:"h3"}}),Ze=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfZG9yYSUzRFRydWUlMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),ve=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwTG9yYVJ1bnRpbWVDb25maWclMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKHVzZV9kb3JhJTNEVHJ1ZSUyQyUyMHJ1bnRpbWVfY29uZmlnJTNETG9yYVJ1bnRpbWVDb25maWcoZXBoZW1lcmFsX2dwdV9vZmZsb2FkJTNEVHJ1ZSklMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, LoraRuntimeConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, runtime_config=LoraRuntimeConfig(ephemeral_gpu_offload=<span class="hljs-literal">True</span>), ...)`,wrap:!1}}),ke=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoYmFzZV9tb2RlbCUyQyUyMHBlZnRfbW9kZWxfaWQlMkMlMjBlcGhlbWVyYWxfZ3B1X29mZmxvYWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model = PeftModel.from_pretrained(base_model, peft_model_id, ephemeral_gpu_offload=<span class="hljs-literal">True</span>)`,wrap:!1}}),Be=new y({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),Ie=new y({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),We=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),Ge=new y({props:{title:"Memory efficient Layer Replication with LoRA",local:"memory-efficient-layer-replication-with-lora",headingTag:"h3"}}),Ae=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhsYXllcl9yZXBsaWNhdGlvbiUzRCU1QiU1QjAlMkM0JTVEJTJDJTIwJTVCMiUyQzUlNUQlNUQlMkMlMjAuLi4p",highlighted:'config = LoraConfig(layer_replication=[[<span class="hljs-number">0</span>,<span class="hljs-number">4</span>], [<span class="hljs-number">2</span>,<span class="hljs-number">5</span>]], ...)',wrap:!1}}),Qe=new y({props:{title:"Fine grained control over ranks and alpha (scaling)",local:"fine-grained-control-over-ranks-and-alpha-scaling",headingTag:"h3"}}),Fe=new M({props:{code:"cHJpbnQobW9kZWwp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model)
Outer(
  (foo): Linear(...)
  (module): Middle(
    (foo): Linear(...)
    (foobar): Linear(...)
    (module): Inner(
      (foo): Linear(...)
      (barfoo): Linear(...)
    )
  )
)`,wrap:!1}}),qe=new y({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),Se=new y({props:{title:"LoRA-FA Optimizer",local:"lora-fa-optimizer",headingTag:"h3"}}),De=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEFmcm9tJTIwcGVmdC5vcHRpbWl6ZXJzJTIwaW1wb3J0JTIwY3JlYXRlX2xvcmFmYV9vcHRpbWl6ZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVHJhaW5lciUyQyUyMGdldF9jb3NpbmVfc2NoZWR1bGVfd2l0aF93YXJtdXAlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIpJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4pJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChiYXNlX21vZGVsJTJDJTIwY29uZmlnKSUwQSUwQW9wdGltaXplciUyMCUzRCUyMGNyZWF0ZV9sb3JhZmFfb3B0aW1pemVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjByJTNEMTI4JTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9hbHBoYSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwbHIlM0Q3ZS01JTJDJTBBKSUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMGdldF9jb3NpbmVfc2NoZWR1bGVfd2l0aF93YXJtdXAoJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3dhcm11cF9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRDEwMDAlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwLi4uJTJDJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVycyUzRChvcHRpbWl6ZXIlMkMlMjBzY2hlZHVsZXIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> peft.optimizers <span class="hljs-keyword">import</span> create_lorafa_optimizer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer, get_cosine_schedule_with_warmup

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)

config = LoraConfig(...)
model = get_peft_model(base_model, config)

optimizer = create_lorafa_optimizer(
    model=model,
    r=<span class="hljs-number">128</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lr=<span class="hljs-number">7e-5</span>,
)

scheduler = get_cosine_schedule_with_warmup(
    optimizer,
    num_warmup_steps=<span class="hljs-number">100</span>,
    num_training_steps=<span class="hljs-number">1000</span>,
)

trainer = Trainer(
    ...,
    optimizers=(optimizer, scheduler),
)`,wrap:!1}}),Ke=new y({props:{title:"LoRA+ optimized LoRA",local:"lora-optimized-lora",headingTag:"h3"}}),et=new M({props:{code:"JTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> peft.optimizers <span class="hljs-keyword">import</span> create_loraplus_optimizer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer
<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

base_model = ...
config = LoraConfig(...)
model = get_peft_model(base_model, config)

optimizer = create_loraplus_optimizer(
    model=model,
    optimizer_cls=bnb.optim.Adam8bit,
    lr=<span class="hljs-number">5e-5</span>,
    loraplus_lr_ratio=<span class="hljs-number">16</span>,
)
scheduler = <span class="hljs-literal">None</span>

...
trainer = Trainer(
    ...,
    optimizers=(optimizer, scheduler),
)`,wrap:!1}}),tt=new y({props:{title:"Efficiently train tokens alongside LoRA",local:"efficiently-train-tokens-alongside-lora",headingTag:"h2"}}),lt=new M({props:{code:"JTIzJTIwZm9yJTIwbGF5ZXIlMjAnZW1iZWRfdG9rZW5zJyUwQWNvbmZpZyUyMCUzRCUyMExvcmFDb25maWcodHJhaW5hYmxlX3Rva2VuX2luZGljZXMlM0QlNUJpZHhfMSUyQyUyMGlkeF8yJTJDJTIwLi4uJTVEJTJDJTIwLi4uKSUwQSUwQSUyMyUyMHNwZWNpZmljJTIwZW1iZWRkaW5nJTIwbGF5ZXIlMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKHRyYWluYWJsZV90b2tlbl9pbmRpY2VzJTNEJTdCJ2VtYl90b2tlbnMnJTNBJTIwJTVCaWR4XzElMkMlMjBpZHhfMiUyQyUyMC4uLiU1RCU3RCUyQyUyMC4uLik=",highlighted:`<span class="hljs-comment"># for layer &#x27;embed_tokens&#x27;</span>
config = LoraConfig(trainable_token_indices=[idx_1, idx_2, ...], ...)

<span class="hljs-comment"># specific embedding layer</span>
config = LoraConfig(trainable_token_indices={<span class="hljs-string">&#x27;emb_tokens&#x27;</span>: [idx_1, idx_2, ...]}, ...)`,wrap:!1}}),st=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwZ2V0X3BlZnRfbW9kZWwlMkMlMjBMb3JhQ29uZmlnJTBBJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjElMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQSUyMyUyMHdlJTIwZGVmaW5lJTIwb3VyJTIwbmV3JTIwdG9rZW5zJTIwYW5kJTIwYWRkJTIwdGhlbSUyMHRvJTIwdGhlJTIwdG9rZW5pemVyJTIwYXMlMjBzcGVjaWFsJTIwdG9rZW5zJTBBc3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUInJTNDJTdDc3RhcnRfdGhpbmslN0MlM0UnJTJDJTIwJyUzQyU3Q3N0b3BfdGhpbmslN0MlM0UnJTVEJTBBdG9rZW5pemVyLmFkZF9zcGVjaWFsX3Rva2VucyglN0InYWRkaXRpb25hbF9zcGVjaWFsX3Rva2VucyclM0ElMjBzcGVjaWFsX3Rva2VucyU3RCklMEElMEElMjMlMjBtYWtlJTIwcm9vbSUyMGZvciUyMG5ldyUyMHRva2VucyUyMGluJTIwdGhlJTIwZW1iZWRkaW5nJTIwbWF0cml4JTIwaWYlMjBpdCUyMGlzbid0JTIwYmlnJTIwZW5vdWdoJTIwYWxyZWFkeSUwQWJhc2VfbW9kZWwucmVzaXplX3Rva2VuX2VtYmVkZGluZ3MobWF4KGxlbih0b2tlbml6ZXIpJTJDJTIwYmFzZV9tb2RlbC5tb2RlbC5lbWJlZF90b2tlbnMubnVtX2VtYmVkZGluZ3MpJTBBJTBBJTIzJTIwdHlwaWNhbCUyMExvUkElMjBjb25maWclMjB3aXRoJTIwJTYwdHJhaW5hYmxlX3Rva2VuX2luZGljZXMlNjAlMjB0YXJnZXRpbmclMjBlbWJlZGRpbmclMjBsYXllciUyMCU2MGVtYmVkX3Rva2VucyU2MCUwQSUyMyUyMGFuZCUyMHNwZWNpZmljYWxseSUyMG91ciUyMG5ldyUyMHRva2VucyUyMHdlJTIwanVzdCUyMGFkZGVkJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJ2FsbC1saW5lYXInJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5hYmxlX3Rva2VuX2luZGljZXMlM0QlN0InZW1iZWRfdG9rZW5zJyUzQSUyMHRva2VuaXplci5jb252ZXJ0X3Rva2Vuc190b19pZHMoc3BlY2lhbF90b2tlbnMpJTdEJTJDJTBBKSUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChiYXNlX21vZGVsJTJDJTIwbG9yYV9jb25maWcpJTBBJTBBJTIzJTIwcHJvY2VlZCUyMHRvJTIwdHJhaW4lMjB0aGUlMjBtb2RlbCUyMGxpa2UlMjBub3JtYWwlMEElNUIuLi4lNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model, LoraConfig

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

<span class="hljs-comment"># we define our new tokens and add them to the tokenizer as special tokens</span>
special_tokens = [<span class="hljs-string">&#x27;&lt;|start_think|&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;|stop_think|&gt;&#x27;</span>]
tokenizer.add_special_tokens({<span class="hljs-string">&#x27;additional_special_tokens&#x27;</span>: special_tokens})

<span class="hljs-comment"># make room for new tokens in the embedding matrix if it isn&#x27;t big enough already</span>
base_model.resize_token_embeddings(<span class="hljs-built_in">max</span>(<span class="hljs-built_in">len</span>(tokenizer), base_model.model.embed_tokens.num_embeddings)

<span class="hljs-comment"># typical LoRA config with \`trainable_token_indices\` targeting embedding layer \`embed_tokens\`</span>
<span class="hljs-comment"># and specifically our new tokens we just added</span>
lora_config = LoraConfig(
    target_modules=<span class="hljs-string">&#x27;all-linear&#x27;</span>,
    trainable_token_indices={<span class="hljs-string">&#x27;embed_tokens&#x27;</span>: tokenizer.convert_tokens_to_ids(special_tokens)},
)
peft_model = get_peft_model(base_model, lora_config)

<span class="hljs-comment"># proceed to train the model like normal</span>
[...]`,wrap:!1}}),rt=new y({props:{title:"Merge LoRA weights into the base model",local:"merge-lora-weights-into-the-base-model",headingTag:"h2"}}),ft=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),ct=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),wt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),bt=new M({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),Tt=new M({props:{code:"d2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTIwJTNEJTIwJTIyc2Z0LWRwbyUyMiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJhbGlnbm1lbnQtaGFuZGJvb2slMkZ6ZXBoeXItN2ItZHBvLWxvcmElMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkcG8lMjIpJTBBbW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJzZnQlMjIlMkMlMjAlMjJkcG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEd2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSklMEFtb2RlbC5zZXRfYWRhcHRlcih3ZWlnaHRlZF9hZGFwdGVyX25hbWUp",highlighted:`weighted_adapter_name = <span class="hljs-string">&quot;sft-dpo&quot;</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=weighted_adapter_name,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)
model.set_adapter(weighted_adapter_name)`,wrap:!1}}),j=new dn({props:{$$slots:{default:[xs]},$$scope:{ctx:T}}}),_t=new M({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oJTIyY3VkYSUyMiklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),Zt=new y({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),vt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),kt=new M({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),Ut=new y({props:{title:"Inference with different LoRA adapters in the same batch",local:"inference-with-different-lora-adapters-in-the-same-batch",headingTag:"h2"}}),Rt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMjMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBGcmVuY2glMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMCUzQ3BhdGglM0UlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyX2ZyJTIyKSUwQSUyMyUyMG5leHQlMkMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBHZXJtYW4lMEFwZWZ0X21vZGVsLmxvYWRfYWRhcHRlciglM0NwYXRoJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl9kZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model_id = ...
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-comment"># load the LoRA adapter for French</span>
peft_model = PeftModel.from_pretrained(model, &lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_fr&quot;</span>)
<span class="hljs-comment"># next, load the LoRA adapter for German</span>
peft_model.load_adapter(&lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_de&quot;</span>)`,wrap:!1}}),Lt=new M({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwY2F0JTIwaXMlMjBhd2Vzb21lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySGVsbG8lMkMlMjBteSUyMGZpc2glMjBpcyUyMGdyZWF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBjaGllbiUyMGVzdCUyMG1pZ25vbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlNhbHV0JTJDJTIwbW9uJTIwY2hhdCUyMGVzdCUyMGclQzMlQTluaWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBwb2lzc29uJTIwZXN0JTIwc3VwZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBIdW5kJTIwaXN0JTIwcyVDMyVCQyVDMyU5RiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhhbGxvJTJDJTIwbWVpbmUlMjBLYXR6ZSUyMGlzdCUyMHRvbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBGaXNjaCUyMGlzdCUyMGdybyVDMyU5RmFydGlnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBKSUwQSUwQWFkYXB0ZXJfbmFtZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJfX2Jhc2VfXyUyMiUyQyUyMCUyMl9fYmFzZV9fJTIyJTJDJTIwJTIyX19iYXNlX18lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2ZyJTIyJTJDJTIwJTIyYWRhcHRlcl9mciUyMiUyQyUyMCUyMmFkYXB0ZXJfZnIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2RlJTIyJTJDJTIwJTIyYWRhcHRlcl9kZSUyMiUyQyUyMCUyMmFkYXB0ZXJfZGUlMjIlMkMlMEElNUQlMEFvdXRwdXQlMjAlM0QlMjBwZWZ0X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYWRhcHRlcl9uYW1lcyUzRGFkYXB0ZXJfbmFtZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`inputs = tokenizer(
    [
        <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>,
        <span class="hljs-string">&quot;Hello, my cat is awesome&quot;</span>,
        <span class="hljs-string">&quot;Hello, my fish is great&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chien est mignon&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chat est génial&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon poisson est super&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Hund ist süß&quot;</span>,
        <span class="hljs-string">&quot;Hallo, meine Katze ist toll&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Fisch ist großartig&quot;</span>,
    ],
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    padding=<span class="hljs-literal">True</span>,
)

adapter_names = [
    <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>,
    <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>,
    <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>,
]
output = peft_model.generate(**inputs, adapter_names=adapter_names, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),Vt=new y({props:{title:"Caveats",local:"caveats",headingTag:"h3"}}),xt=new Vs({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/lora.md"}}),{c(){u=i("meta"),b=n(),w=i("p"),g=n(),p(v.$$.fragment),zt=n(),$=i("p"),$.innerHTML=fn,Ht=n(),k=i("p"),k.textContent=hn,Ft=n(),p(U.$$.fragment),Et=n(),C=i("p"),C.innerHTML=cn,Yt=n(),B=i("p"),B.innerHTML=un,qt=n(),p(R.$$.fragment),Nt=n(),I=i("p"),I.innerHTML=Mn,St=n(),p(L.$$.fragment),Pt=n(),p(W.$$.fragment),Dt=n(),G=i("p"),G.innerHTML=wn,Kt=n(),V=i("p"),V.textContent=yn,Ot=n(),p(A.$$.fragment),ea=n(),X=i("p"),X.textContent=bn,ta=n(),p(x.$$.fragment),aa=n(),Q=i("p"),Q.innerHTML=gn,la=n(),p(z.$$.fragment),na=n(),H=i("p"),H.innerHTML=Tn,sa=n(),F=i("p"),F.textContent=Jn,ia=n(),p(E.$$.fragment),oa=n(),Y=i("p"),Y.innerHTML=_n,ra=n(),p(q.$$.fragment),pa=n(),N=i("p"),N.innerHTML=Zn,da=n(),S=i("p"),S.textContent=jn,ma=n(),p(P.$$.fragment),fa=n(),D=i("p"),D.innerHTML=vn,ha=n(),p(K.$$.fragment),ca=n(),O=i("p"),O.innerHTML=$n,ua=n(),ee=i("p"),ee.innerHTML=kn,Ma=n(),p(te.$$.fragment),wa=n(),ae=i("p"),ae.innerHTML=Un,ya=n(),le=i("p"),le.innerHTML=Cn,ba=n(),p(ne.$$.fragment),ga=n(),se=i("p"),se.innerHTML=Bn,Ta=n(),p(ie.$$.fragment),Ja=n(),oe=i("p"),oe.innerHTML=Rn,_a=n(),p(J.$$.fragment),Za=n(),p(re.$$.fragment),ja=n(),p(pe.$$.fragment),va=n(),de=i("p"),de.innerHTML=In,$a=n(),me=i("p"),me.innerHTML=Ln,ka=n(),p(fe.$$.fragment),Ua=n(),he=i("p"),he.innerHTML=Wn,Ca=n(),p(ce.$$.fragment),Ba=n(),ue=i("p"),ue.innerHTML=Gn,Ra=n(),Me=i("p"),Me.innerHTML=Vn,Ia=n(),we=i("p"),we.innerHTML=An,La=n(),ye=i("ul"),ye.innerHTML=Xn,Wa=n(),p(_.$$.fragment),Ga=n(),p(be.$$.fragment),Va=n(),ge=i("p"),ge.innerHTML=xn,Aa=n(),p(Te.$$.fragment),Xa=n(),p(Je.$$.fragment),xa=n(),_e=i("p"),_e.innerHTML=Qn,Qa=n(),p(Ze.$$.fragment),za=n(),je=i("p"),je.innerHTML=zn,Ha=n(),p(ve.$$.fragment),Fa=n(),$e=i("p"),$e.innerHTML=Hn,Ea=n(),p(ke.$$.fragment),Ya=n(),Ue=i("p"),Ue.innerHTML=Fn,qa=n(),Ce=i("table"),Ce.innerHTML=En,Na=n(),p(Be.$$.fragment),Sa=n(),Re=i("ul"),Re.innerHTML=Yn,Pa=n(),p(Ie.$$.fragment),Da=n(),Le=i("p"),Le.innerHTML=qn,Ka=n(),p(We.$$.fragment),Oa=n(),p(Ge.$$.fragment),el=n(),Ve=i("p"),Ve.innerHTML=Nn,tl=n(),p(Ae.$$.fragment),al=n(),Xe=i("p"),Xe.innerHTML=Sn,ll=n(),xe=i("p"),xe.innerHTML=Pn,nl=n(),p(Qe.$$.fragment),sl=n(),ze=i("p"),ze.innerHTML=Dn,il=n(),He=i("p"),He.textContent=Kn,ol=n(),p(Fe.$$.fragment),rl=n(),Ee=i("ul"),Ee.innerHTML=On,pl=n(),Ye=i("p"),Ye.innerHTML=es,dl=n(),p(qe.$$.fragment),ml=n(),Ne=i("p"),Ne.textContent=ts,fl=n(),p(Se.$$.fragment),hl=n(),Pe=i("p"),Pe.innerHTML=as,cl=n(),p(De.$$.fragment),ul=n(),p(Ke.$$.fragment),Ml=n(),Oe=i("p"),Oe.innerHTML=ls,wl=n(),p(et.$$.fragment),yl=n(),p(tt.$$.fragment),bl=n(),at=i("p"),at.innerHTML=ns,gl=n(),p(lt.$$.fragment),Tl=n(),nt=i("p"),nt.textContent=ss,Jl=n(),p(st.$$.fragment),_l=n(),it=i("p"),it.innerHTML=is,Zl=n(),ot=i("p"),ot.innerHTML=os,jl=n(),p(rt.$$.fragment),vl=n(),pt=i("p"),pt.innerHTML=rs,$l=n(),dt=i("p"),dt.textContent=ps,kl=n(),Z=i("div"),Z.innerHTML=ds,Ul=n(),mt=i("p"),mt.textContent=ms,Cl=n(),p(ft.$$.fragment),Bl=n(),ht=i("p"),ht.innerHTML=fs,Rl=n(),p(ct.$$.fragment),Il=n(),ut=i("p"),ut.innerHTML=hs,Ll=n(),Mt=i("p"),Mt.textContent=cs,Wl=n(),p(wt.$$.fragment),Gl=n(),yt=i("p"),yt.textContent=us,Vl=n(),p(bt.$$.fragment),Al=n(),gt=i("p"),gt.textContent=Ms,Xl=n(),p(Tt.$$.fragment),xl=n(),p(j.$$.fragment),Ql=n(),Jt=i("p"),Jt.textContent=ws,zl=n(),p(_t.$$.fragment),Hl=n(),p(Zt.$$.fragment),Fl=n(),jt=i("p"),jt.innerHTML=ys,El=n(),p(vt.$$.fragment),Yl=n(),$t=i("p"),$t.innerHTML=bs,ql=n(),p(kt.$$.fragment),Nl=n(),p(Ut.$$.fragment),Sl=n(),Ct=i("p"),Ct.textContent=gs,Pl=n(),Bt=i("p"),Bt.innerHTML=Ts,Dl=n(),p(Rt.$$.fragment),Kl=n(),It=i("p"),It.innerHTML=Js,Ol=n(),p(Lt.$$.fragment),en=n(),Wt=i("p"),Wt.innerHTML=_s,tn=n(),Gt=i("p"),Gt.innerHTML=Zs,an=n(),p(Vt.$$.fragment),ln=n(),At=i("p"),At.textContent=js,nn=n(),Xt=i("ul"),Xt.innerHTML=vs,sn=n(),p(xt.$$.fragment),on=n(),Qt=i("p"),this.h()},l(e){const t=Ws("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(a),b=s(e),w=o(e,"P",{}),Cs(w).forEach(a),g=s(e),d(v.$$.fragment,e),zt=s(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-38uxl6"&&($.innerHTML=fn),Ht=s(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-ovsn32"&&(k.textContent=hn),Ft=s(e),d(U.$$.fragment,e),Et=s(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-j883mf"&&(C.innerHTML=cn),Yt=s(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1fujb7a"&&(B.innerHTML=un),qt=s(e),d(R.$$.fragment,e),Nt=s(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-mwvui1"&&(I.innerHTML=Mn),St=s(e),d(L.$$.fragment,e),Pt=s(e),d(W.$$.fragment,e),Dt=s(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1dv6v3"&&(G.innerHTML=wn),Kt=s(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1hy0lgx"&&(V.textContent=yn),Ot=s(e),d(A.$$.fragment,e),ea=s(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-auzrbb"&&(X.textContent=bn),ta=s(e),d(x.$$.fragment,e),aa=s(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-16k39wq"&&(Q.innerHTML=gn),la=s(e),d(z.$$.fragment,e),na=s(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-53sj5j"&&(H.innerHTML=Tn),sa=s(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1s3c5rd"&&(F.textContent=Jn),ia=s(e),d(E.$$.fragment,e),oa=s(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-19qemwc"&&(Y.innerHTML=_n),ra=s(e),d(q.$$.fragment,e),pa=s(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1iny7jf"&&(N.innerHTML=Zn),da=s(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1j9g8qn"&&(S.textContent=jn),ma=s(e),d(P.$$.fragment,e),fa=s(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-sulxp4"&&(D.innerHTML=vn),ha=s(e),d(K.$$.fragment,e),ca=s(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-zsbb0y"&&(O.innerHTML=$n),ua=s(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1gqkzq0"&&(ee.innerHTML=kn),Ma=s(e),d(te.$$.fragment,e),wa=s(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-168zxvb"&&(ae.innerHTML=Un),ya=s(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-z4d0cr"&&(le.innerHTML=Cn),ba=s(e),d(ne.$$.fragment,e),ga=s(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-8ll8w8"&&(se.innerHTML=Bn),Ta=s(e),d(ie.$$.fragment,e),Ja=s(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-ryiojp"&&(oe.innerHTML=Rn),_a=s(e),d(J.$$.fragment,e),Za=s(e),d(re.$$.fragment,e),ja=s(e),d(pe.$$.fragment,e),va=s(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-icixot"&&(de.innerHTML=In),$a=s(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-7f0aai"&&(me.innerHTML=Ln),ka=s(e),d(fe.$$.fragment,e),Ua=s(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-14vtcq9"&&(he.innerHTML=Wn),Ca=s(e),d(ce.$$.fragment,e),Ba=s(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1nywyxh"&&(ue.innerHTML=Gn),Ra=s(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1m1yphh"&&(Me.innerHTML=Vn),Ia=s(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-yl8kok"&&(we.innerHTML=An),La=s(e),ye=o(e,"UL",{"data-svelte-h":!0}),r(ye)!=="svelte-12tl4fy"&&(ye.innerHTML=Xn),Wa=s(e),d(_.$$.fragment,e),Ga=s(e),d(be.$$.fragment,e),Va=s(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-omuw13"&&(ge.innerHTML=xn),Aa=s(e),d(Te.$$.fragment,e),Xa=s(e),d(Je.$$.fragment,e),xa=s(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-x8nt61"&&(_e.innerHTML=Qn),Qa=s(e),d(Ze.$$.fragment,e),za=s(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-8wzhde"&&(je.innerHTML=zn),Ha=s(e),d(ve.$$.fragment,e),Fa=s(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-16lyt50"&&($e.innerHTML=Hn),Ea=s(e),d(ke.$$.fragment,e),Ya=s(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-zr3cxq"&&(Ue.innerHTML=Fn),qa=s(e),Ce=o(e,"TABLE",{"data-svelte-h":!0}),r(Ce)!=="svelte-1iyfgt7"&&(Ce.innerHTML=En),Na=s(e),d(Be.$$.fragment,e),Sa=s(e),Re=o(e,"UL",{"data-svelte-h":!0}),r(Re)!=="svelte-1nce7z9"&&(Re.innerHTML=Yn),Pa=s(e),d(Ie.$$.fragment,e),Da=s(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-15vxux2"&&(Le.innerHTML=qn),Ka=s(e),d(We.$$.fragment,e),Oa=s(e),d(Ge.$$.fragment,e),el=s(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-ku1fuj"&&(Ve.innerHTML=Nn),tl=s(e),d(Ae.$$.fragment,e),al=s(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1ttqqw0"&&(Xe.innerHTML=Sn),ll=s(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-foj0wd"&&(xe.innerHTML=Pn),nl=s(e),d(Qe.$$.fragment,e),sl=s(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-ed0v39"&&(ze.innerHTML=Dn),il=s(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-dtt8e"&&(He.textContent=Kn),ol=s(e),d(Fe.$$.fragment,e),rl=s(e),Ee=o(e,"UL",{"data-svelte-h":!0}),r(Ee)!=="svelte-1qf6hnm"&&(Ee.innerHTML=On),pl=s(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-qh5siy"&&(Ye.innerHTML=es),dl=s(e),d(qe.$$.fragment,e),ml=s(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-ws58tf"&&(Ne.textContent=ts),fl=s(e),d(Se.$$.fragment,e),hl=s(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-18tpzlm"&&(Pe.innerHTML=as),cl=s(e),d(De.$$.fragment,e),ul=s(e),d(Ke.$$.fragment,e),Ml=s(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1i0u5p9"&&(Oe.innerHTML=ls),wl=s(e),d(et.$$.fragment,e),yl=s(e),d(tt.$$.fragment,e),bl=s(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-iri31w"&&(at.innerHTML=ns),gl=s(e),d(lt.$$.fragment,e),Tl=s(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-66nz7l"&&(nt.textContent=ss),Jl=s(e),d(st.$$.fragment,e),_l=s(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-32mf1g"&&(it.innerHTML=is),Zl=s(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-sspyjf"&&(ot.innerHTML=os),jl=s(e),d(rt.$$.fragment,e),vl=s(e),pt=o(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-1c3h9aa"&&(pt.innerHTML=rs),$l=s(e),dt=o(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-1wwmf5r"&&(dt.textContent=ps),kl=s(e),Z=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(Z)!=="svelte-1f6iuw5"&&(Z.innerHTML=ds),Ul=s(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-hlzwis"&&(mt.textContent=ms),Cl=s(e),d(ft.$$.fragment,e),Bl=s(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-m3cr6r"&&(ht.innerHTML=fs),Rl=s(e),d(ct.$$.fragment,e),Il=s(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-kbqhpl"&&(ut.innerHTML=hs),Ll=s(e),Mt=o(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1mwdwt1"&&(Mt.textContent=cs),Wl=s(e),d(wt.$$.fragment,e),Gl=s(e),yt=o(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-1lnmg1d"&&(yt.textContent=us),Vl=s(e),d(bt.$$.fragment,e),Al=s(e),gt=o(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1n53hd9"&&(gt.textContent=Ms),Xl=s(e),d(Tt.$$.fragment,e),xl=s(e),d(j.$$.fragment,e),Ql=s(e),Jt=o(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-qwbdkg"&&(Jt.textContent=ws),zl=s(e),d(_t.$$.fragment,e),Hl=s(e),d(Zt.$$.fragment,e),Fl=s(e),jt=o(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-ke62q2"&&(jt.innerHTML=ys),El=s(e),d(vt.$$.fragment,e),Yl=s(e),$t=o(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-cvmoj6"&&($t.innerHTML=bs),ql=s(e),d(kt.$$.fragment,e),Nl=s(e),d(Ut.$$.fragment,e),Sl=s(e),Ct=o(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1fq5tpu"&&(Ct.textContent=gs),Pl=s(e),Bt=o(e,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-lcywla"&&(Bt.innerHTML=Ts),Dl=s(e),d(Rt.$$.fragment,e),Kl=s(e),It=o(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-6wkyom"&&(It.innerHTML=Js),Ol=s(e),d(Lt.$$.fragment,e),en=s(e),Wt=o(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-1o40ch6"&&(Wt.innerHTML=_s),tn=s(e),Gt=o(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-mqf2jo"&&(Gt.innerHTML=Zs),an=s(e),d(Vt.$$.fragment,e),ln=s(e),At=o(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-e0xhf6"&&(At.textContent=js),nn=s(e),Xt=o(e,"UL",{"data-svelte-h":!0}),r(Xt)!=="svelte-brh7gh"&&(Xt.innerHTML=vs),sn=s(e),d(xt.$$.fragment,e),on=s(e),Qt=o(e,"P",{}),Cs(Qt).forEach(a),this.h()},h(){pn(u,"name","hf:doc:metadata"),pn(u,"content",zs),pn(Z,"class","flex justify-center")},m(e,t){Gs(document.head,u),l(e,b,t),l(e,w,t),l(e,g,t),m(v,e,t),l(e,zt,t),l(e,$,t),l(e,Ht,t),l(e,k,t),l(e,Ft,t),m(U,e,t),l(e,Et,t),l(e,C,t),l(e,Yt,t),l(e,B,t),l(e,qt,t),m(R,e,t),l(e,Nt,t),l(e,I,t),l(e,St,t),m(L,e,t),l(e,Pt,t),m(W,e,t),l(e,Dt,t),l(e,G,t),l(e,Kt,t),l(e,V,t),l(e,Ot,t),m(A,e,t),l(e,ea,t),l(e,X,t),l(e,ta,t),m(x,e,t),l(e,aa,t),l(e,Q,t),l(e,la,t),m(z,e,t),l(e,na,t),l(e,H,t),l(e,sa,t),l(e,F,t),l(e,ia,t),m(E,e,t),l(e,oa,t),l(e,Y,t),l(e,ra,t),m(q,e,t),l(e,pa,t),l(e,N,t),l(e,da,t),l(e,S,t),l(e,ma,t),m(P,e,t),l(e,fa,t),l(e,D,t),l(e,ha,t),m(K,e,t),l(e,ca,t),l(e,O,t),l(e,ua,t),l(e,ee,t),l(e,Ma,t),m(te,e,t),l(e,wa,t),l(e,ae,t),l(e,ya,t),l(e,le,t),l(e,ba,t),m(ne,e,t),l(e,ga,t),l(e,se,t),l(e,Ta,t),m(ie,e,t),l(e,Ja,t),l(e,oe,t),l(e,_a,t),m(J,e,t),l(e,Za,t),m(re,e,t),l(e,ja,t),m(pe,e,t),l(e,va,t),l(e,de,t),l(e,$a,t),l(e,me,t),l(e,ka,t),m(fe,e,t),l(e,Ua,t),l(e,he,t),l(e,Ca,t),m(ce,e,t),l(e,Ba,t),l(e,ue,t),l(e,Ra,t),l(e,Me,t),l(e,Ia,t),l(e,we,t),l(e,La,t),l(e,ye,t),l(e,Wa,t),m(_,e,t),l(e,Ga,t),m(be,e,t),l(e,Va,t),l(e,ge,t),l(e,Aa,t),m(Te,e,t),l(e,Xa,t),m(Je,e,t),l(e,xa,t),l(e,_e,t),l(e,Qa,t),m(Ze,e,t),l(e,za,t),l(e,je,t),l(e,Ha,t),m(ve,e,t),l(e,Fa,t),l(e,$e,t),l(e,Ea,t),m(ke,e,t),l(e,Ya,t),l(e,Ue,t),l(e,qa,t),l(e,Ce,t),l(e,Na,t),m(Be,e,t),l(e,Sa,t),l(e,Re,t),l(e,Pa,t),m(Ie,e,t),l(e,Da,t),l(e,Le,t),l(e,Ka,t),m(We,e,t),l(e,Oa,t),m(Ge,e,t),l(e,el,t),l(e,Ve,t),l(e,tl,t),m(Ae,e,t),l(e,al,t),l(e,Xe,t),l(e,ll,t),l(e,xe,t),l(e,nl,t),m(Qe,e,t),l(e,sl,t),l(e,ze,t),l(e,il,t),l(e,He,t),l(e,ol,t),m(Fe,e,t),l(e,rl,t),l(e,Ee,t),l(e,pl,t),l(e,Ye,t),l(e,dl,t),m(qe,e,t),l(e,ml,t),l(e,Ne,t),l(e,fl,t),m(Se,e,t),l(e,hl,t),l(e,Pe,t),l(e,cl,t),m(De,e,t),l(e,ul,t),m(Ke,e,t),l(e,Ml,t),l(e,Oe,t),l(e,wl,t),m(et,e,t),l(e,yl,t),m(tt,e,t),l(e,bl,t),l(e,at,t),l(e,gl,t),m(lt,e,t),l(e,Tl,t),l(e,nt,t),l(e,Jl,t),m(st,e,t),l(e,_l,t),l(e,it,t),l(e,Zl,t),l(e,ot,t),l(e,jl,t),m(rt,e,t),l(e,vl,t),l(e,pt,t),l(e,$l,t),l(e,dt,t),l(e,kl,t),l(e,Z,t),l(e,Ul,t),l(e,mt,t),l(e,Cl,t),m(ft,e,t),l(e,Bl,t),l(e,ht,t),l(e,Rl,t),m(ct,e,t),l(e,Il,t),l(e,ut,t),l(e,Ll,t),l(e,Mt,t),l(e,Wl,t),m(wt,e,t),l(e,Gl,t),l(e,yt,t),l(e,Vl,t),m(bt,e,t),l(e,Al,t),l(e,gt,t),l(e,Xl,t),m(Tt,e,t),l(e,xl,t),m(j,e,t),l(e,Ql,t),l(e,Jt,t),l(e,zl,t),m(_t,e,t),l(e,Hl,t),m(Zt,e,t),l(e,Fl,t),l(e,jt,t),l(e,El,t),m(vt,e,t),l(e,Yl,t),l(e,$t,t),l(e,ql,t),m(kt,e,t),l(e,Nl,t),m(Ut,e,t),l(e,Sl,t),l(e,Ct,t),l(e,Pl,t),l(e,Bt,t),l(e,Dl,t),m(Rt,e,t),l(e,Kl,t),l(e,It,t),l(e,Ol,t),m(Lt,e,t),l(e,en,t),l(e,Wt,t),l(e,tn,t),l(e,Gt,t),l(e,an,t),m(Vt,e,t),l(e,ln,t),l(e,At,t),l(e,nn,t),l(e,Xt,t),l(e,sn,t),m(xt,e,t),l(e,on,t),l(e,Qt,t),rn=!0},p(e,[t]){const $s={};t&2&&($s.$$scope={dirty:t,ctx:e}),J.$set($s);const ks={};t&2&&(ks.$$scope={dirty:t,ctx:e}),_.$set(ks);const Us={};t&2&&(Us.$$scope={dirty:t,ctx:e}),j.$set(Us)},i(e){rn||(f(v.$$.fragment,e),f(U.$$.fragment,e),f(R.$$.fragment,e),f(L.$$.fragment,e),f(W.$$.fragment,e),f(A.$$.fragment,e),f(x.$$.fragment,e),f(z.$$.fragment,e),f(E.$$.fragment,e),f(q.$$.fragment,e),f(P.$$.fragment,e),f(K.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(ie.$$.fragment,e),f(J.$$.fragment,e),f(re.$$.fragment,e),f(pe.$$.fragment,e),f(fe.$$.fragment,e),f(ce.$$.fragment,e),f(_.$$.fragment,e),f(be.$$.fragment,e),f(Te.$$.fragment,e),f(Je.$$.fragment,e),f(Ze.$$.fragment,e),f(ve.$$.fragment,e),f(ke.$$.fragment,e),f(Be.$$.fragment,e),f(Ie.$$.fragment,e),f(We.$$.fragment,e),f(Ge.$$.fragment,e),f(Ae.$$.fragment,e),f(Qe.$$.fragment,e),f(Fe.$$.fragment,e),f(qe.$$.fragment,e),f(Se.$$.fragment,e),f(De.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(lt.$$.fragment,e),f(st.$$.fragment,e),f(rt.$$.fragment,e),f(ft.$$.fragment,e),f(ct.$$.fragment,e),f(wt.$$.fragment,e),f(bt.$$.fragment,e),f(Tt.$$.fragment,e),f(j.$$.fragment,e),f(_t.$$.fragment,e),f(Zt.$$.fragment,e),f(vt.$$.fragment,e),f(kt.$$.fragment,e),f(Ut.$$.fragment,e),f(Rt.$$.fragment,e),f(Lt.$$.fragment,e),f(Vt.$$.fragment,e),f(xt.$$.fragment,e),rn=!0)},o(e){h(v.$$.fragment,e),h(U.$$.fragment,e),h(R.$$.fragment,e),h(L.$$.fragment,e),h(W.$$.fragment,e),h(A.$$.fragment,e),h(x.$$.fragment,e),h(z.$$.fragment,e),h(E.$$.fragment,e),h(q.$$.fragment,e),h(P.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(ie.$$.fragment,e),h(J.$$.fragment,e),h(re.$$.fragment,e),h(pe.$$.fragment,e),h(fe.$$.fragment,e),h(ce.$$.fragment,e),h(_.$$.fragment,e),h(be.$$.fragment,e),h(Te.$$.fragment,e),h(Je.$$.fragment,e),h(Ze.$$.fragment,e),h(ve.$$.fragment,e),h(ke.$$.fragment,e),h(Be.$$.fragment,e),h(Ie.$$.fragment,e),h(We.$$.fragment,e),h(Ge.$$.fragment,e),h(Ae.$$.fragment,e),h(Qe.$$.fragment,e),h(Fe.$$.fragment,e),h(qe.$$.fragment,e),h(Se.$$.fragment,e),h(De.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(tt.$$.fragment,e),h(lt.$$.fragment,e),h(st.$$.fragment,e),h(rt.$$.fragment,e),h(ft.$$.fragment,e),h(ct.$$.fragment,e),h(wt.$$.fragment,e),h(bt.$$.fragment,e),h(Tt.$$.fragment,e),h(j.$$.fragment,e),h(_t.$$.fragment,e),h(Zt.$$.fragment,e),h(vt.$$.fragment,e),h(kt.$$.fragment,e),h(Ut.$$.fragment,e),h(Rt.$$.fragment,e),h(Lt.$$.fragment,e),h(Vt.$$.fragment,e),h(xt.$$.fragment,e),rn=!1},d(e){e&&(a(b),a(w),a(g),a(zt),a($),a(Ht),a(k),a(Ft),a(Et),a(C),a(Yt),a(B),a(qt),a(Nt),a(I),a(St),a(Pt),a(Dt),a(G),a(Kt),a(V),a(Ot),a(ea),a(X),a(ta),a(aa),a(Q),a(la),a(na),a(H),a(sa),a(F),a(ia),a(oa),a(Y),a(ra),a(pa),a(N),a(da),a(S),a(ma),a(fa),a(D),a(ha),a(ca),a(O),a(ua),a(ee),a(Ma),a(wa),a(ae),a(ya),a(le),a(ba),a(ga),a(se),a(Ta),a(Ja),a(oe),a(_a),a(Za),a(ja),a(va),a(de),a($a),a(me),a(ka),a(Ua),a(he),a(Ca),a(Ba),a(ue),a(Ra),a(Me),a(Ia),a(we),a(La),a(ye),a(Wa),a(Ga),a(Va),a(ge),a(Aa),a(Xa),a(xa),a(_e),a(Qa),a(za),a(je),a(Ha),a(Fa),a($e),a(Ea),a(Ya),a(Ue),a(qa),a(Ce),a(Na),a(Sa),a(Re),a(Pa),a(Da),a(Le),a(Ka),a(Oa),a(el),a(Ve),a(tl),a(al),a(Xe),a(ll),a(xe),a(nl),a(sl),a(ze),a(il),a(He),a(ol),a(rl),a(Ee),a(pl),a(Ye),a(dl),a(ml),a(Ne),a(fl),a(hl),a(Pe),a(cl),a(ul),a(Ml),a(Oe),a(wl),a(yl),a(bl),a(at),a(gl),a(Tl),a(nt),a(Jl),a(_l),a(it),a(Zl),a(ot),a(jl),a(vl),a(pt),a($l),a(dt),a(kl),a(Z),a(Ul),a(mt),a(Cl),a(Bl),a(ht),a(Rl),a(Il),a(ut),a(Ll),a(Mt),a(Wl),a(Gl),a(yt),a(Vl),a(Al),a(gt),a(Xl),a(xl),a(Ql),a(Jt),a(zl),a(Hl),a(Fl),a(jt),a(El),a(Yl),a($t),a(ql),a(Nl),a(Sl),a(Ct),a(Pl),a(Bt),a(Dl),a(Kl),a(It),a(Ol),a(en),a(Wt),a(tn),a(Gt),a(an),a(ln),a(At),a(nn),a(Xt),a(sn),a(on),a(Qt)),a(u),c(v,e),c(U,e),c(R,e),c(L,e),c(W,e),c(A,e),c(x,e),c(z,e),c(E,e),c(q,e),c(P,e),c(K,e),c(te,e),c(ne,e),c(ie,e),c(J,e),c(re,e),c(pe,e),c(fe,e),c(ce,e),c(_,e),c(be,e),c(Te,e),c(Je,e),c(Ze,e),c(ve,e),c(ke,e),c(Be,e),c(Ie,e),c(We,e),c(Ge,e),c(Ae,e),c(Qe,e),c(Fe,e),c(qe,e),c(Se,e),c(De,e),c(Ke,e),c(et,e),c(tt,e),c(lt,e),c(st,e),c(rt,e),c(ft,e),c(ct,e),c(wt,e),c(bt,e),c(Tt,e),c(j,e),c(_t,e),c(Zt,e),c(vt,e),c(kt,e),c(Ut,e),c(Rt,e),c(Lt,e),c(Vt,e),c(xt,e)}}}const zs='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"PiSSA","local":"pissa","sections":[],"depth":3},{"title":"CorDA","local":"corda","sections":[],"depth":3},{"title":"OLoRA","local":"olora","sections":[],"depth":3},{"title":"EVA","local":"eva","sections":[],"depth":3},{"title":"LoftQ","local":"loftq","sections":[{"title":"Standard approach","local":"standard-approach","sections":[],"depth":4},{"title":"A more convenient way","local":"a-more-convenient-way","sections":[],"depth":4}],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3},{"title":"Weight-Decomposed Low-Rank Adaptation (DoRA)","local":"weight-decomposed-low-rank-adaptation-dora","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3},{"title":"Memory efficient Layer Replication with LoRA","local":"memory-efficient-layer-replication-with-lora","sections":[],"depth":3},{"title":"Fine grained control over ranks and alpha (scaling)","local":"fine-grained-control-over-ranks-and-alpha-scaling","sections":[],"depth":3}],"depth":2},{"title":"Optimizers","local":"optimizers","sections":[{"title":"LoRA-FA Optimizer","local":"lora-fa-optimizer","sections":[],"depth":3},{"title":"LoRA+ optimized LoRA","local":"lora-optimized-lora","sections":[],"depth":3}],"depth":2},{"title":"Efficiently train tokens alongside LoRA","local":"efficiently-train-tokens-alongside-lora","sections":[],"depth":2},{"title":"Merge LoRA weights into the base model","local":"merge-lora-weights-into-the-base-model","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2},{"title":"Inference with different LoRA adapters in the same batch","local":"inference-with-different-lora-adapters-in-the-same-batch","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":3}],"depth":2}],"depth":1}';function Hs(T){return Rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ss extends Is{constructor(u){super(),Ls(this,u,Hs,Qs,Bs,{})}}export{Ss as component};
