# Sequence-to-Sequence-Modelle

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

<Youtube id="0_4KEb08xrE" />

Encoder-Decoder-Modelle (auch *Sequence-to-Sequence-Modelle* genannt) verwenden beide Teile der Transformer-Architektur. Die Attention-Layer des Encoders können in jedem Schritt auf alle Wörter des Ausgangssatzes zugreifen, während die Attention-Layer des Decoders nur auf die Wörter zugreifen können, die vor einem bestimmten Wort des Inputs stehen.

Das Pretraining dieser Modelle kann wie das Pretraining von rein Encoder- oder Decoder-basierten Modellen erfolgen, ist aber in der Regel etwas komplexer. Beim Pretraining von [T5](https://huggingface.co/t5-base) werden zum Beispiel zufällige Textabschnitte (die mehrere Wörter enthalten können) durch ein einzelnes spezielles Maskierungswort ersetzt, und das Ziel (engl. Pretraining Objective) besteht dann darin, den Text vorherzusagen, der durch dieses Maskierungswort ersetzt bzw. verdeckt wurde.

Sequence-to-Sequence-Modelle eignen sich am besten für Aufgaben, bei denen es darum geht, neue Sätze in Abhängigkeit von einem bestimmten Input zu generieren, z. B. bei der Zusammenfassung, Übersetzung oder generativen Frage-Antwort-Systemen.

Vertreter dieser Modellfamilie sind u. a.:

- [BART](https://huggingface.co/transformers/model_doc/bart)
- [mBART](https://huggingface.co/transformers/model_doc/mbart)
- [Marian](https://huggingface.co/transformers/model_doc/marian)
- [T5](https://huggingface.co/transformers/model_doc/t5)


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/de/chapter1/7.mdx" />