import{s as Ha,o as Na,n as R}from"../chunks/scheduler.cc52f4b9.js";import{S as Fa,i as Ea,e as h,s as n,c as r,h as Qa,a as f,d as l,b as s,f as Aa,g as o,j as y,k as Ya,l as La,m as a,n as p,t as m,o as c,p as d,q as Sa,r as qa}from"../chunks/index.5b747fde.js";import{T as C}from"../chunks/Tip.f0925d57.js";import{C as Pa,H as v,E as Ka}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d38ac5a9.js";import{Y as Va}from"../chunks/Youtube.8bb4154e.js";import{C as T}from"../chunks/CodeBlock.665bfc37.js";import{C as Da}from"../chunks/CourseFloatingBanner.b33fcd79.js";import{Q as ct}from"../chunks/Question.58d62cc7.js";function Oa(j){let i,b='🏗️ <strong>Training from Scratch</strong>: This section builds on the previous content. For comprehensive guidance on PyTorch training loops and best practices, check out the <a href="https://huggingface.co/docs/transformers/main/en/training#train-in-native-pytorch" rel="nofollow">🤗 Transformers training documentation</a> and the <a href="https://huggingface.co/learn/cookbook/en/fine_tuning_code_llm_on_single_gpu#model" rel="nofollow">custom training cookbook</a>.';return{c(){i=h("p"),i.innerHTML=b},l(u){i=f(u,"P",{"data-svelte-h":!0}),y(i)!=="svelte-11sv2tl"&&(i.innerHTML=b)},m(u,M){a(u,i,M)},p:R,d(u){u&&l(i)}}}function en(j){let i,b="💡 <strong>Modern Optimization Tips</strong>: For even better performance, you can try:",u,M,J="<li><strong>AdamW with weight decay</strong>: <code>AdamW(model.parameters(), lr=5e-5, weight_decay=0.01)</code></li> <li><strong>8-bit Adam</strong>: Use <code>bitsandbytes</code> for memory-efficient optimization</li> <li><strong>Different learning rates</strong>: Lower learning rates (1e-5 to 3e-5) often work better for large models</li>",$,g,k='🚀 <strong>Optimization Resources</strong>: Learn more about optimizers and training strategies in the <a href="https://huggingface.co/docs/transformers/main/en/performance#optimizer" rel="nofollow">🤗 Transformers optimization guide</a>.';return{c(){i=h("p"),i.innerHTML=b,u=n(),M=h("ul"),M.innerHTML=J,$=n(),g=h("p"),g.innerHTML=k},l(w){i=f(w,"P",{"data-svelte-h":!0}),y(i)!=="svelte-o5kaes"&&(i.innerHTML=b),u=s(w),M=f(w,"UL",{"data-svelte-h":!0}),y(M)!=="svelte-1qym9yd"&&(M.innerHTML=J),$=s(w),g=f(w,"P",{"data-svelte-h":!0}),y(g)!=="svelte-x7tnyo"&&(g.innerHTML=k)},m(w,U){a(w,i,U),a(w,u,U),a(w,M,U),a(w,$,U),a(w,g,U)},p:R,d(w){w&&(l(i),l(u),l(M),l($),l(g))}}}function tn(j){let i,b="💡 <strong>Modern Training Optimizations</strong>: To make your training loop even more efficient, consider:",u,M,J="<li><strong>Gradient Clipping</strong>: Add <code>torch.nn.utils.clip_grad_norm_(model.parameters(), max_norm=1.0)</code> before <code>optimizer.step()</code></li> <li><strong>Mixed Precision</strong>: Use <code>torch.cuda.amp.autocast()</code> and <code>GradScaler</code> for faster training</li> <li><strong>Gradient Accumulation</strong>: Accumulate gradients over multiple batches to simulate larger batch sizes</li> <li><strong>Checkpointing</strong>: Save model checkpoints periodically to resume training if interrupted</li>",$,g,k='🔧 <strong>Implementation Guide</strong>: For detailed examples of these optimizations, see the <a href="https://huggingface.co/docs/transformers/main/en/perf_train_gpu_one" rel="nofollow">🤗 Transformers efficient training guide</a> and the <a href="https://huggingface.co/docs/transformers/main/en/optimizers" rel="nofollow">range of optimizers</a>.';return{c(){i=h("p"),i.innerHTML=b,u=n(),M=h("ul"),M.innerHTML=J,$=n(),g=h("p"),g.innerHTML=k},l(w){i=f(w,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1dozp7f"&&(i.innerHTML=b),u=s(w),M=f(w,"UL",{"data-svelte-h":!0}),y(M)!=="svelte-ujbxeo"&&(M.innerHTML=J),$=s(w),g=f(w,"P",{"data-svelte-h":!0}),y(g)!=="svelte-elu395"&&(g.innerHTML=k)},m(w,U){a(w,i,U),a(w,u,U),a(w,M,U),a(w,$,U),a(w,g,U)},p:R,d(w){w&&(l(i),l(u),l(M),l($),l(g))}}}function ln(j){let i,b='📊 <strong>Evaluation Best Practices</strong>: For more sophisticated evaluation strategies and metrics, explore the <a href="https://huggingface.co/docs/evaluate/" rel="nofollow">🤗 Evaluate documentation</a> and the <a href="https://github.com/huggingface/evaluation-guidebook" rel="nofollow">comprehensive evaluation cookbook</a>.';return{c(){i=h("p"),i.innerHTML=b},l(u){i=f(u,"P",{"data-svelte-h":!0}),y(i)!=="svelte-n1do1t"&&(i.innerHTML=b)},m(u,M){a(u,i,M)},p:R,d(u){u&&l(i)}}}function an(j){let i,b="✏️ <strong>Try it out!</strong> Modify the previous training loop to fine-tune your model on the SST-2 dataset.";return{c(){i=h("p"),i.innerHTML=b},l(u){i=f(u,"P",{"data-svelte-h":!0}),y(i)!=="svelte-14jbd71"&&(i.innerHTML=b)},m(u,M){a(u,i,M)},p:R,d(u){u&&l(i)}}}function nn(j){let i,b='⚡ <strong>Accelerate Deep Dive</strong>: Learn everything about distributed training, mixed precision, and hardware optimization in the <a href="https://huggingface.co/docs/accelerate/" rel="nofollow">🤗 Accelerate documentation</a> and explore practical examples in the <a href="https://huggingface.co/docs/transformers/main/en/accelerate" rel="nofollow">transformers documentation</a>.';return{c(){i=h("p"),i.innerHTML=b},l(u){i=f(u,"P",{"data-svelte-h":!0}),y(i)!=="svelte-mw1zvv"&&(i.innerHTML=b)},m(u,M){a(u,i,M)},p:R,d(u){u&&l(i)}}}function sn(j){let i;return{c(){i=Sa('⚠️ In order to benefit from the speed-up offered by Cloud TPUs, we recommend padding your samples to a fixed length with the `padding="max_length"` and `max_length` arguments of the tokenizer.')},l(b){i=qa(b,'⚠️ In order to benefit from the speed-up offered by Cloud TPUs, we recommend padding your samples to a fixed length with the `padding="max_length"` and `max_length` arguments of the tokenizer.')},m(b,u){a(b,i,u)},d(b){b&&l(i)}}}function rn(j){let i,b='🌐 <strong>Distributed Training</strong>: For comprehensive coverage of multi-GPU and multi-node training, check out the <a href="https://huggingface.co/docs/transformers/main/en/perf_train_gpu_many" rel="nofollow">🤗 Transformers distributed training guide</a> and the <a href="https://huggingface.co/docs/transformers/main/en/accelerate" rel="nofollow">scaling training cookbook</a>.';return{c(){i=h("p"),i.innerHTML=b},l(u){i=f(u,"P",{"data-svelte-h":!0}),y(i)!=="svelte-lrep30"&&(i.innerHTML=b)},m(u,M){a(u,i,M)},p:R,d(u){u&&l(i)}}}function on(j){let i,b="💡 <strong>Key Takeaways:</strong>",u,M,J="<li>Manual training loops give you complete control but require understanding of the proper sequence: forward → backward → optimizer step → scheduler step → zero gradients</li> <li>AdamW with weight decay is the recommended optimizer for transformer models</li> <li>Always use <code>model.eval()</code> and <code>torch.no_grad()</code> during evaluation for correct behavior and efficiency</li> <li>🤗 Accelerate makes distributed training accessible with minimal code changes</li> <li>Device management (moving tensors to GPU/CPU) is crucial for PyTorch operations</li> <li>Modern techniques like mixed precision, gradient accumulation, and gradient clipping can significantly improve training efficiency</li>";return{c(){i=h("p"),i.innerHTML=b,u=n(),M=h("ul"),M.innerHTML=J},l($){i=f($,"P",{"data-svelte-h":!0}),y(i)!=="svelte-l314m0"&&(i.innerHTML=b),u=s($),M=f($,"UL",{"data-svelte-h":!0}),y(M)!=="svelte-w3ba9j"&&(M.innerHTML=J)},m($,g){a($,i,g),a($,u,g),a($,M,g)},p:R,d($){$&&(l(i),l(u),l(M))}}}function pn(j){let i,b,u,M,J,$,g,k,w,U,A,ut,Y,ql="Now we’ll see how to achieve the same results as we did in the last section without using the <code>Trainer</code> class, implementing a training loop from scratch with modern PyTorch best practices. Again, we assume you have done the data processing in section 2. Here is a short summary covering everything you will need:",ht,_,ft,V,yt,H,Mt,N,Pl="Before actually writing our training loop, we will need to define a few objects. The first ones are the dataloaders we will use to iterate over batches. But before we can define those dataloaders, we need to apply a bit of postprocessing to our <code>tokenized_datasets</code>, to take care of some things that the <code>Trainer</code> did for us automatically. Specifically, we need to:",wt,F,Kl="<li>Remove the columns corresponding to values the model does not expect (like the <code>sentence1</code> and <code>sentence2</code> columns).</li> <li>Rename the column <code>label</code> to <code>labels</code> (because the model expects the argument to be named <code>labels</code>).</li> <li>Set the format of the datasets so they return PyTorch tensors instead of lists.</li>",bt,E,Dl="Our <code>tokenized_datasets</code> has one method for each of those steps:",gt,Q,$t,L,Ol="We can then check that the result only has columns that our model will accept:",Tt,S,jt,q,ea="Now that this is done, we can easily define our dataloaders:",Jt,P,Ut,K,ta="To quickly check there is no mistake in the data processing, we can inspect a batch like this:",vt,D,kt,O,Ct,ee,la="Note that the actual shapes will probably be slightly different for you since we set <code>shuffle=True</code> for the training dataloader and we are padding to the maximum length inside the batch.",_t,te,aa="Now that we’re completely finished with data preprocessing (a satisfying yet elusive goal for any ML practitioner), let’s turn to the model. We instantiate it exactly as we did in the previous section:",Zt,le,Bt,ae,na="To make sure that everything will go smoothly during training, we pass our batch to this model:",xt,ne,Wt,se,It,ie,sa="All 🤗 Transformers models will return the loss when <code>labels</code> are provided, and we also get the logits (two for each input in our batch, so a tensor of size 8 x 2).",Gt,re,ia='We’re almost ready to write our training loop! We’re just missing two things: an optimizer and a learning rate scheduler. Since we are trying to replicate what the <code>Trainer</code> was doing by hand, we will use the same defaults. The optimizer used by the <code>Trainer</code> is <code>AdamW</code>, which is the same as Adam, but with a twist for weight decay regularization (see <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">“Decoupled Weight Decay Regularization”</a> by Ilya Loshchilov and Frank Hutter):',Xt,oe,zt,Z,Rt,pe,ra="Finally, the learning rate scheduler used by default is just a linear decay from the maximum value (5e-5) to 0. To properly define it, we need to know the number of training steps we will take, which is the number of epochs we want to run multiplied by the number of training batches (which is the length of our training dataloader). The <code>Trainer</code> uses three epochs by default, so we will follow that:",At,me,Yt,ce,Vt,de,Ht,ue,oa="One last thing: we will want to use the GPU if we have access to one (on a CPU, training might take several hours instead of a couple of minutes). To do this, we define a <code>device</code> we will put our model and our batches on:",Nt,he,Ft,fe,Et,ye,pa="We are now ready to train! To get some sense of when training will be finished, we add a progress bar over our number of training steps, using the <code>tqdm</code> library:",Qt,Me,Lt,B,St,we,ma="You can see that the core of the training loop looks a lot like the one in the introduction. We didn’t ask for any reporting, so this training loop will not tell us anything about how the model fares. We need to add an evaluation loop for that.",qt,be,Pt,ge,ca="As we did earlier, we will use a metric provided by the 🤗 Evaluate library. We’ve already seen the <code>metric.compute()</code> method, but metrics can actually accumulate batches for us as we go over the prediction loop with the method <code>add_batch()</code>. Once we have accumulated all the batches, we can get the final result with <code>metric.compute()</code>. Here’s how to implement all of this in an evaluation loop:",Kt,x,Dt,$e,Ot,Te,el,je,da="Again, your results will be slightly different because of the randomness in the model head initialization and the data shuffling, but they should be in the same ballpark.",tl,W,ll,Je,al,Ue,nl,ve,ua='The training loop we defined earlier works fine on a single CPU or GPU. But using the <a href="https://github.com/huggingface/accelerate" rel="nofollow">🤗 Accelerate</a> library, with just a few adjustments we can enable distributed training on multiple GPUs or TPUs. 🤗 Accelerate handles the complexity of distributed training, mixed precision, and device placement automatically. Starting from the creation of the training and validation dataloaders, here is what our manual training loop looks like:',sl,I,il,ke,rl,Ce,ha="The first line to add is the import line. The second line instantiates an <code>Accelerator</code> object that will look at the environment and initialize the proper distributed setup. 🤗 Accelerate handles the device placement for you, so you can remove the lines that put the model on the device (or, if you prefer, change them to use <code>accelerator.device</code> instead of <code>device</code>).",ol,_e,fa="Then the main bulk of the work is done in the line that sends the dataloaders, the model, and the optimizer to <code>accelerator.prepare()</code>. This will wrap those objects in the proper container to make sure your distributed training works as intended. The remaining changes to make are removing the line that puts the batch on the <code>device</code> (again, if you want to keep this you can just change it to use <code>accelerator.device</code>) and replacing <code>loss.backward()</code> with <code>accelerator.backward(loss)</code>.",pl,G,ml,Ze,ya="If you’d like to copy and paste it to play around, here’s what the complete training loop looks like with 🤗 Accelerate:",cl,Be,dl,xe,Ma="Putting this in a <code>train.py</code> script will make that script runnable on any kind of distributed setup. To try it out in your distributed setup, run the command:",ul,We,hl,Ie,wa="which will prompt you to answer a few questions and dump your answers in a configuration file used by this command:",fl,Ge,yl,Xe,ba="which will launch the distributed training.",Ml,ze,ga="If you want to try this in a Notebook (for instance, to test it with TPUs on Colab), just paste the code in a <code>training_function()</code> and run a last cell with:",wl,Re,bl,Ae,$a='You can find more examples in the <a href="https://github.com/huggingface/accelerate/tree/main/examples" rel="nofollow">🤗 Accelerate repo</a>.',gl,X,$l,Ye,Tl,Ve,Ta="Now that you’ve learned how to implement training from scratch, here are some additional considerations for production use:",jl,He,ja="<strong>Model Evaluation</strong>: Always evaluate your model on multiple metrics, not just accuracy. Use the 🤗 Evaluate library for comprehensive evaluation.",Jl,Ne,Ja="<strong>Hyperparameter Tuning</strong>: Consider using libraries like Optuna or Ray Tune for systematic hyperparameter optimization.",Ul,Fe,Ua="<strong>Model Monitoring</strong>: Track training metrics, learning curves, and validation performance throughout training.",vl,Ee,va="<strong>Model Sharing</strong>: Once trained, share your model on the Hugging Face Hub to make it available to the community.",kl,Qe,ka="<strong>Efficiency</strong>: For large models, consider techniques like gradient checkpointing, parameter-efficient fine-tuning (LoRA, AdaLoRA), or quantization methods.",Cl,Le,Ca="This concludes our deep dive into fine-tuning with custom training loops. The skills you’ve learned here will serve you well when you need full control over the training process or want to implement custom training logic that goes beyond what the <code>Trainer</code> API offers.",_l,Se,Zl,qe,_a="Test your understanding of custom training loops and advanced training techniques:",Bl,Pe,xl,Ke,Wl,De,Il,Oe,Gl,et,Xl,tt,zl,lt,Rl,at,Al,nt,Yl,st,Vl,it,Hl,rt,Nl,ot,Fl,pt,El,z,Ql,mt,Ll,dt,Sl;return J=new Pa({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new v({props:{title:"A full training loop",local:"a-full-training",headingTag:"h1"}}),w=new Da({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section4.ipynb"}]}}),A=new Va({props:{id:"Dh9CL8fyG80"}}),_=new C({props:{$$slots:{default:[Oa]},$$scope:{ctx:j}}}),V=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),H=new v({props:{title:"Prepare for training",local:"prepare-for-training",headingTag:"h3"}}),Q=new T({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiUyQyUyMCUyMmlkeCUyMiU1RCklMEF0b2tlbml6ZWRfZGF0YXNldHMlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldHMucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMuc2V0X2Zvcm1hdCglMjJ0b3JjaCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXM=",highlighted:`tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;idx&quot;</span>])
tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)
tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].column_names`,wrap:!1}}),S=new T({props:{code:"JTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RA==",highlighted:'[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>]',wrap:!1}}),P=new T({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0Q4JTJDJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMEEpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUwQSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

train_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>], shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)
eval_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>], batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)`,wrap:!1}}),D=new T({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBicmVhayUwQSU3QmslM0ElMjB2LnNoYXBlJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
    <span class="hljs-keyword">break</span>
{k: v.shape <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}`,wrap:!1}}),O=new T({props:{code:"JTdCJ2F0dGVudGlvbl9tYXNrJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSUyQyUwQSUyMCdpbnB1dF9pZHMnJTNBJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwNjUlNUQpJTJDJTBBJTIwJ2xhYmVscyclM0ElMjB0b3JjaC5TaXplKCU1QjglNUQpJTJDJTBBJTIwJ3Rva2VuX3R5cGVfaWRzJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSU3RA==",highlighted:`{<span class="hljs-string">&#x27;attention_mask&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: torch.Size([<span class="hljs-number">8</span>]),
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>])}`,wrap:!1}}),le=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),ne=new T({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBcHJpbnQob3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5sb2dpdHMuc2hhcGUp",highlighted:`outputs = model(**batch)
<span class="hljs-built_in">print</span>(outputs.loss, outputs.logits.shape)`,wrap:!1}}),se=new T({props:{code:"dGVuc29yKDAuNTQ0MSUyQyUyMGdyYWRfZm4lM0QlM0NObGxMb3NzQmFja3dhcmQlM0UpJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwMiU1RCk=",highlighted:'tensor(<span class="hljs-number">0.5441</span>, grad_fn=&lt;NllLossBackward&gt;) torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">2</span>])',wrap:!1}}),oe=new T({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDVlLTUp",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW

optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),Z=new C({props:{$$slots:{default:[en]},$$scope:{ctx:j}}}),me=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMEElMjAlMjAlMjAlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRG51bV90cmFpbmluZ19zdGVwcyUyQyUwQSklMEFwcmludChudW1fdHJhaW5pbmdfc3RlcHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)
<span class="hljs-built_in">print</span>(num_training_steps)`,wrap:!1}}),ce=new T({props:{code:"MTM3Nw==",highlighted:'<span class="hljs-number">1377</span>',wrap:!1}}),de=new v({props:{title:"The training loop",local:"the-training-loop",headingTag:"h3"}}),he=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBZGV2aWNl",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)
device`,wrap:!1}}),fe=new T({props:{code:"ZGV2aWNlKHR5cGUlM0QnY3VkYScp",highlighted:'device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;cuda&#x27;</span>)',wrap:!1}}),Me=new T({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),B=new C({props:{$$slots:{default:[tn]},$$scope:{ctx:j}}}),be=new v({props:{title:"The evaluation loop",local:"the-evaluation-loop",headingTag:"h3"}}),x=new C({props:{$$slots:{default:[ln]},$$scope:{ctx:j}}}),$e=new T({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1vZGVsLmV2YWwoKSUwQWZvciUyMGJhdGNoJTIwaW4lMjBldmFsX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2gocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCklMEElMEFtZXRyaWMuY29tcHV0ZSgp",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
model.<span class="hljs-built_in">eval</span>()
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(**batch)

    logits = outputs.logits
    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

metric.compute()`,wrap:!1}}),Te=new T({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODQzMTM3MjU0OTAxOTYwOCUyQyUyMCdmMSclM0ElMjAwLjg5MDc4NDk4MjkzNTE1MzUlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8431372549019608</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8907849829351535</span>}',wrap:!1}}),W=new C({props:{$$slots:{default:[an]},$$scope:{ctx:j}}}),Je=new v({props:{title:"Supercharge your training loop with 🤗 Accelerate",local:"supercharge-your-training-loop-with-accelerate",headingTag:"h3"}}),Ue=new Va({props:{id:"s7dy8QRgjJ0"}}),I=new C({props:{$$slots:{default:[nn]},$$scope:{ctx:j}}}),ke=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC5vcHRpbSUyMGltcG9ydCUyMEFkYW1XJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),G=new C({props:{$$slots:{default:[sn]},$$scope:{ctx:j}}}),Be=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC5vcHRpbSUyMGltcG9ydCUyMEFkYW1XJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),We=new T({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),Ge=new T({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:'accelerate <span class="hljs-built_in">launch</span> train.py',wrap:!1}}),Re=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

notebook_launcher(training_function)`,wrap:!1}}),X=new C({props:{$$slots:{default:[rn]},$$scope:{ctx:j}}}),Ye=new v({props:{title:"Next Steps and Best Practices",local:"next-steps-and-best-practices",headingTag:"h3"}}),Se=new v({props:{title:"Section Quiz",local:"section-quiz",headingTag:"h2"}}),Pe=new v({props:{title:"1. What is the main difference between Adam and AdamW optimizers?",local:"1-what-is-the-main-difference-between-adam-and-adamw-optimizers",headingTag:"h3"}}),Ke=new ct({props:{choices:[{text:"AdamW uses a different learning rate schedule.",explain:"Learning rate scheduling is separate from the optimizer choice."},{text:"AdamW includes decoupled weight decay regularization.",explain:"Correct! AdamW separates weight decay from the gradient-based parameter updates, leading to better regularization.",correct:!0},{text:"AdamW only works with transformer models.",explain:"AdamW can be used with any model architecture, not just transformers."},{text:"AdamW requires less memory than Adam.",explain:"Both optimizers have similar memory requirements."}]}}),De=new v({props:{title:"2. In a training loop, what is the correct order of operations?",local:"2-in-a-training-loop-what-is-the-correct-order-of-operations",headingTag:"h3"}}),Oe=new ct({props:{choices:[{text:"Forward pass → Backward pass → Optimizer step → Zero gradients",explain:"Close, but you should zero gradients before the next forward pass to avoid accumulating old gradients."},{text:"Forward pass → Backward pass → Optimizer step → Scheduler step → Zero gradients",explain:"Correct! This is the proper order: compute loss, compute gradients, update parameters, update learning rate, then clear gradients.",correct:!0},{text:"Zero gradients → Forward pass → Optimizer step → Backward pass",explain:"The backward pass must come after the forward pass to compute gradients from the loss."},{text:"Forward pass → Zero gradients → Backward pass → Optimizer step",explain:"Zeroing gradients before backward pass would eliminate the gradients you just computed."}]}}),et=new v({props:{title:"3. What does the 🤗 Accelerate library primarily help with?",local:"3-what-does-the--accelerate-library-primarily-help-with",headingTag:"h3"}}),tt=new ct({props:{choices:[{text:"Making your models train faster by optimizing the forward pass.",explain:"Accelerate doesn't optimize the model architecture itself."},{text:"Automatically selecting the best hyperparameters.",explain:"Accelerate doesn't do hyperparameter optimization."},{text:"Enabling distributed training across multiple GPUs/TPUs with minimal code changes.",explain:"Correct! Accelerate handles distributed training complexity, allowing your code to run on single or multiple devices seamlessly.",correct:!0},{text:"Converting models to different frameworks like TensorFlow.",explain:"Accelerate works within PyTorch and doesn't convert between frameworks."}]}}),lt=new v({props:{title:"4. Why do we move batches to the device in a training loop?",local:"4-why-do-we-move-batches-to-the-device-in-a-training-loop",headingTag:"h3"}}),at=new ct({props:{choices:[{text:"To make the training faster.",explain:"While it can affect speed, the main reason is compatibility."},{text:"Because the model and data must be on the same device (CPU/GPU) for computation.",explain:"Correct! PyTorch requires tensors to be on the same device for operations to work.",correct:!0},{text:"To save memory.",explain:"Moving to device doesn't inherently save memory."},{text:"It's required by the DataLoader.",explain:"DataLoader doesn't require specific device placement."}]}}),nt=new v({props:{title:"5. What does model.eval() do before evaluation?",local:"5-what-does-modeleval-do-before-evaluation",headingTag:"h3"}}),st=new ct({props:{choices:[{text:"It freezes the model parameters so they can't be updated.",explain:"model.eval() doesn't freeze parameters - that would be done by setting requires_grad=False."},{text:"It changes the behavior of layers like dropout and batch normalization for inference.",explain:"Correct! eval() mode disables dropout and uses running statistics for batch norm instead of computing them from the current batch.",correct:!0},{text:"It enables gradient computation for evaluation metrics.",explain:"Actually, we typically use torch.no_grad() during evaluation to disable gradient computation."},{text:"It automatically calculates evaluation metrics.",explain:"model.eval() only changes layer behavior - you still need to implement metric calculation separately."}]}}),it=new v({props:{title:"6. What is the purpose of torch.no_grad() during evaluation?",local:"6-what-is-the-purpose-of-torchnograd-during-evaluation",headingTag:"h3"}}),rt=new ct({props:{choices:[{text:"To prevent the model from making predictions.",explain:"torch.no_grad() doesn't prevent predictions, just gradient computation."},{text:"To save memory and speed up computation by disabling gradient tracking.",explain:"Correct! Since we don't need gradients for evaluation, disabling them saves memory and computation.",correct:!0},{text:"To enable evaluation mode for the model.",explain:"Evaluation mode is enabled with model.eval(), not torch.no_grad()."},{text:"To ensure consistent results across runs.",explain:"Reproducibility is handled by setting random seeds, not torch.no_grad()."}]}}),ot=new v({props:{title:"7. What changes when you use 🤗 Accelerate in your training loop?",local:"7-what-changes-when-you-use--accelerate-in-your-training-loop",headingTag:"h3"}}),pt=new ct({props:{choices:[{text:"You must rewrite your entire training loop from scratch.",explain:"Accelerate requires minimal changes to existing PyTorch code."},{text:"You wrap key objects with accelerator.prepare() and use accelerator.backward() instead of loss.backward().",explain:"Correct! These are the main changes - prepare your objects and use accelerator.backward() for proper distributed training.",correct:!0},{text:"You need to specify the number of GPUs in your code.",explain:"Accelerate automatically detects available hardware."},{text:"You must use a different optimizer and scheduler.",explain:"You can use the same optimizers and schedulers with Accelerate."}]}}),z=new C({props:{$$slots:{default:[on]},$$scope:{ctx:j}}}),mt=new Ka({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter3/4.mdx"}}),{c(){i=h("meta"),b=n(),u=h("p"),M=n(),r(J.$$.fragment),$=n(),r(g.$$.fragment),k=n(),r(w.$$.fragment),U=n(),r(A.$$.fragment),ut=n(),Y=h("p"),Y.innerHTML=ql,ht=n(),r(_.$$.fragment),ft=n(),r(V.$$.fragment),yt=n(),r(H.$$.fragment),Mt=n(),N=h("p"),N.innerHTML=Pl,wt=n(),F=h("ul"),F.innerHTML=Kl,bt=n(),E=h("p"),E.innerHTML=Dl,gt=n(),r(Q.$$.fragment),$t=n(),L=h("p"),L.textContent=Ol,Tt=n(),r(S.$$.fragment),jt=n(),q=h("p"),q.textContent=ea,Jt=n(),r(P.$$.fragment),Ut=n(),K=h("p"),K.textContent=ta,vt=n(),r(D.$$.fragment),kt=n(),r(O.$$.fragment),Ct=n(),ee=h("p"),ee.innerHTML=la,_t=n(),te=h("p"),te.textContent=aa,Zt=n(),r(le.$$.fragment),Bt=n(),ae=h("p"),ae.textContent=na,xt=n(),r(ne.$$.fragment),Wt=n(),r(se.$$.fragment),It=n(),ie=h("p"),ie.innerHTML=sa,Gt=n(),re=h("p"),re.innerHTML=ia,Xt=n(),r(oe.$$.fragment),zt=n(),r(Z.$$.fragment),Rt=n(),pe=h("p"),pe.innerHTML=ra,At=n(),r(me.$$.fragment),Yt=n(),r(ce.$$.fragment),Vt=n(),r(de.$$.fragment),Ht=n(),ue=h("p"),ue.innerHTML=oa,Nt=n(),r(he.$$.fragment),Ft=n(),r(fe.$$.fragment),Et=n(),ye=h("p"),ye.innerHTML=pa,Qt=n(),r(Me.$$.fragment),Lt=n(),r(B.$$.fragment),St=n(),we=h("p"),we.textContent=ma,qt=n(),r(be.$$.fragment),Pt=n(),ge=h("p"),ge.innerHTML=ca,Kt=n(),r(x.$$.fragment),Dt=n(),r($e.$$.fragment),Ot=n(),r(Te.$$.fragment),el=n(),je=h("p"),je.textContent=da,tl=n(),r(W.$$.fragment),ll=n(),r(Je.$$.fragment),al=n(),r(Ue.$$.fragment),nl=n(),ve=h("p"),ve.innerHTML=ua,sl=n(),r(I.$$.fragment),il=n(),r(ke.$$.fragment),rl=n(),Ce=h("p"),Ce.innerHTML=ha,ol=n(),_e=h("p"),_e.innerHTML=fa,pl=n(),r(G.$$.fragment),ml=n(),Ze=h("p"),Ze.textContent=ya,cl=n(),r(Be.$$.fragment),dl=n(),xe=h("p"),xe.innerHTML=Ma,ul=n(),r(We.$$.fragment),hl=n(),Ie=h("p"),Ie.textContent=wa,fl=n(),r(Ge.$$.fragment),yl=n(),Xe=h("p"),Xe.textContent=ba,Ml=n(),ze=h("p"),ze.innerHTML=ga,wl=n(),r(Re.$$.fragment),bl=n(),Ae=h("p"),Ae.innerHTML=$a,gl=n(),r(X.$$.fragment),$l=n(),r(Ye.$$.fragment),Tl=n(),Ve=h("p"),Ve.textContent=Ta,jl=n(),He=h("p"),He.innerHTML=ja,Jl=n(),Ne=h("p"),Ne.innerHTML=Ja,Ul=n(),Fe=h("p"),Fe.innerHTML=Ua,vl=n(),Ee=h("p"),Ee.innerHTML=va,kl=n(),Qe=h("p"),Qe.innerHTML=ka,Cl=n(),Le=h("p"),Le.innerHTML=Ca,_l=n(),r(Se.$$.fragment),Zl=n(),qe=h("p"),qe.textContent=_a,Bl=n(),r(Pe.$$.fragment),xl=n(),r(Ke.$$.fragment),Wl=n(),r(De.$$.fragment),Il=n(),r(Oe.$$.fragment),Gl=n(),r(et.$$.fragment),Xl=n(),r(tt.$$.fragment),zl=n(),r(lt.$$.fragment),Rl=n(),r(at.$$.fragment),Al=n(),r(nt.$$.fragment),Yl=n(),r(st.$$.fragment),Vl=n(),r(it.$$.fragment),Hl=n(),r(rt.$$.fragment),Nl=n(),r(ot.$$.fragment),Fl=n(),r(pt.$$.fragment),El=n(),r(z.$$.fragment),Ql=n(),r(mt.$$.fragment),Ll=n(),dt=h("p"),this.h()},l(e){const t=Qa("svelte-u9bgzb",document.head);i=f(t,"META",{name:!0,content:!0}),t.forEach(l),b=s(e),u=f(e,"P",{}),Aa(u).forEach(l),M=s(e),o(J.$$.fragment,e),$=s(e),o(g.$$.fragment,e),k=s(e),o(w.$$.fragment,e),U=s(e),o(A.$$.fragment,e),ut=s(e),Y=f(e,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-57kt9p"&&(Y.innerHTML=ql),ht=s(e),o(_.$$.fragment,e),ft=s(e),o(V.$$.fragment,e),yt=s(e),o(H.$$.fragment,e),Mt=s(e),N=f(e,"P",{"data-svelte-h":!0}),y(N)!=="svelte-ci9pg7"&&(N.innerHTML=Pl),wt=s(e),F=f(e,"UL",{"data-svelte-h":!0}),y(F)!=="svelte-pk4vyx"&&(F.innerHTML=Kl),bt=s(e),E=f(e,"P",{"data-svelte-h":!0}),y(E)!=="svelte-ey27a0"&&(E.innerHTML=Dl),gt=s(e),o(Q.$$.fragment,e),$t=s(e),L=f(e,"P",{"data-svelte-h":!0}),y(L)!=="svelte-trxw7x"&&(L.textContent=Ol),Tt=s(e),o(S.$$.fragment,e),jt=s(e),q=f(e,"P",{"data-svelte-h":!0}),y(q)!=="svelte-11c0vnt"&&(q.textContent=ea),Jt=s(e),o(P.$$.fragment,e),Ut=s(e),K=f(e,"P",{"data-svelte-h":!0}),y(K)!=="svelte-11wtmu1"&&(K.textContent=ta),vt=s(e),o(D.$$.fragment,e),kt=s(e),o(O.$$.fragment,e),Ct=s(e),ee=f(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-q4m5oq"&&(ee.innerHTML=la),_t=s(e),te=f(e,"P",{"data-svelte-h":!0}),y(te)!=="svelte-xq9k1z"&&(te.textContent=aa),Zt=s(e),o(le.$$.fragment,e),Bt=s(e),ae=f(e,"P",{"data-svelte-h":!0}),y(ae)!=="svelte-1cfpt2v"&&(ae.textContent=na),xt=s(e),o(ne.$$.fragment,e),Wt=s(e),o(se.$$.fragment,e),It=s(e),ie=f(e,"P",{"data-svelte-h":!0}),y(ie)!=="svelte-ynwaiq"&&(ie.innerHTML=sa),Gt=s(e),re=f(e,"P",{"data-svelte-h":!0}),y(re)!=="svelte-1my9rg2"&&(re.innerHTML=ia),Xt=s(e),o(oe.$$.fragment,e),zt=s(e),o(Z.$$.fragment,e),Rt=s(e),pe=f(e,"P",{"data-svelte-h":!0}),y(pe)!=="svelte-12ciodg"&&(pe.innerHTML=ra),At=s(e),o(me.$$.fragment,e),Yt=s(e),o(ce.$$.fragment,e),Vt=s(e),o(de.$$.fragment,e),Ht=s(e),ue=f(e,"P",{"data-svelte-h":!0}),y(ue)!=="svelte-1331u4o"&&(ue.innerHTML=oa),Nt=s(e),o(he.$$.fragment,e),Ft=s(e),o(fe.$$.fragment,e),Et=s(e),ye=f(e,"P",{"data-svelte-h":!0}),y(ye)!=="svelte-s26r6i"&&(ye.innerHTML=pa),Qt=s(e),o(Me.$$.fragment,e),Lt=s(e),o(B.$$.fragment,e),St=s(e),we=f(e,"P",{"data-svelte-h":!0}),y(we)!=="svelte-mcninq"&&(we.textContent=ma),qt=s(e),o(be.$$.fragment,e),Pt=s(e),ge=f(e,"P",{"data-svelte-h":!0}),y(ge)!=="svelte-1sbu2u1"&&(ge.innerHTML=ca),Kt=s(e),o(x.$$.fragment,e),Dt=s(e),o($e.$$.fragment,e),Ot=s(e),o(Te.$$.fragment,e),el=s(e),je=f(e,"P",{"data-svelte-h":!0}),y(je)!=="svelte-14qz8qy"&&(je.textContent=da),tl=s(e),o(W.$$.fragment,e),ll=s(e),o(Je.$$.fragment,e),al=s(e),o(Ue.$$.fragment,e),nl=s(e),ve=f(e,"P",{"data-svelte-h":!0}),y(ve)!=="svelte-lpq30y"&&(ve.innerHTML=ua),sl=s(e),o(I.$$.fragment,e),il=s(e),o(ke.$$.fragment,e),rl=s(e),Ce=f(e,"P",{"data-svelte-h":!0}),y(Ce)!=="svelte-1q9wsp0"&&(Ce.innerHTML=ha),ol=s(e),_e=f(e,"P",{"data-svelte-h":!0}),y(_e)!=="svelte-15cl91a"&&(_e.innerHTML=fa),pl=s(e),o(G.$$.fragment,e),ml=s(e),Ze=f(e,"P",{"data-svelte-h":!0}),y(Ze)!=="svelte-1g09gg4"&&(Ze.textContent=ya),cl=s(e),o(Be.$$.fragment,e),dl=s(e),xe=f(e,"P",{"data-svelte-h":!0}),y(xe)!=="svelte-1476nx"&&(xe.innerHTML=Ma),ul=s(e),o(We.$$.fragment,e),hl=s(e),Ie=f(e,"P",{"data-svelte-h":!0}),y(Ie)!=="svelte-qyc3dl"&&(Ie.textContent=wa),fl=s(e),o(Ge.$$.fragment,e),yl=s(e),Xe=f(e,"P",{"data-svelte-h":!0}),y(Xe)!=="svelte-1dc7y78"&&(Xe.textContent=ba),Ml=s(e),ze=f(e,"P",{"data-svelte-h":!0}),y(ze)!=="svelte-529dmx"&&(ze.innerHTML=ga),wl=s(e),o(Re.$$.fragment,e),bl=s(e),Ae=f(e,"P",{"data-svelte-h":!0}),y(Ae)!=="svelte-py198"&&(Ae.innerHTML=$a),gl=s(e),o(X.$$.fragment,e),$l=s(e),o(Ye.$$.fragment,e),Tl=s(e),Ve=f(e,"P",{"data-svelte-h":!0}),y(Ve)!=="svelte-ww0xia"&&(Ve.textContent=Ta),jl=s(e),He=f(e,"P",{"data-svelte-h":!0}),y(He)!=="svelte-91nu4a"&&(He.innerHTML=ja),Jl=s(e),Ne=f(e,"P",{"data-svelte-h":!0}),y(Ne)!=="svelte-ljahbj"&&(Ne.innerHTML=Ja),Ul=s(e),Fe=f(e,"P",{"data-svelte-h":!0}),y(Fe)!=="svelte-j1czxl"&&(Fe.innerHTML=Ua),vl=s(e),Ee=f(e,"P",{"data-svelte-h":!0}),y(Ee)!=="svelte-1vozwss"&&(Ee.innerHTML=va),kl=s(e),Qe=f(e,"P",{"data-svelte-h":!0}),y(Qe)!=="svelte-quu3pr"&&(Qe.innerHTML=ka),Cl=s(e),Le=f(e,"P",{"data-svelte-h":!0}),y(Le)!=="svelte-l3wmo4"&&(Le.innerHTML=Ca),_l=s(e),o(Se.$$.fragment,e),Zl=s(e),qe=f(e,"P",{"data-svelte-h":!0}),y(qe)!=="svelte-ehgujc"&&(qe.textContent=_a),Bl=s(e),o(Pe.$$.fragment,e),xl=s(e),o(Ke.$$.fragment,e),Wl=s(e),o(De.$$.fragment,e),Il=s(e),o(Oe.$$.fragment,e),Gl=s(e),o(et.$$.fragment,e),Xl=s(e),o(tt.$$.fragment,e),zl=s(e),o(lt.$$.fragment,e),Rl=s(e),o(at.$$.fragment,e),Al=s(e),o(nt.$$.fragment,e),Yl=s(e),o(st.$$.fragment,e),Vl=s(e),o(it.$$.fragment,e),Hl=s(e),o(rt.$$.fragment,e),Nl=s(e),o(ot.$$.fragment,e),Fl=s(e),o(pt.$$.fragment,e),El=s(e),o(z.$$.fragment,e),Ql=s(e),o(mt.$$.fragment,e),Ll=s(e),dt=f(e,"P",{}),Aa(dt).forEach(l),this.h()},h(){Ya(i,"name","hf:doc:metadata"),Ya(i,"content",mn)},m(e,t){La(document.head,i),a(e,b,t),a(e,u,t),a(e,M,t),p(J,e,t),a(e,$,t),p(g,e,t),a(e,k,t),p(w,e,t),a(e,U,t),p(A,e,t),a(e,ut,t),a(e,Y,t),a(e,ht,t),p(_,e,t),a(e,ft,t),p(V,e,t),a(e,yt,t),p(H,e,t),a(e,Mt,t),a(e,N,t),a(e,wt,t),a(e,F,t),a(e,bt,t),a(e,E,t),a(e,gt,t),p(Q,e,t),a(e,$t,t),a(e,L,t),a(e,Tt,t),p(S,e,t),a(e,jt,t),a(e,q,t),a(e,Jt,t),p(P,e,t),a(e,Ut,t),a(e,K,t),a(e,vt,t),p(D,e,t),a(e,kt,t),p(O,e,t),a(e,Ct,t),a(e,ee,t),a(e,_t,t),a(e,te,t),a(e,Zt,t),p(le,e,t),a(e,Bt,t),a(e,ae,t),a(e,xt,t),p(ne,e,t),a(e,Wt,t),p(se,e,t),a(e,It,t),a(e,ie,t),a(e,Gt,t),a(e,re,t),a(e,Xt,t),p(oe,e,t),a(e,zt,t),p(Z,e,t),a(e,Rt,t),a(e,pe,t),a(e,At,t),p(me,e,t),a(e,Yt,t),p(ce,e,t),a(e,Vt,t),p(de,e,t),a(e,Ht,t),a(e,ue,t),a(e,Nt,t),p(he,e,t),a(e,Ft,t),p(fe,e,t),a(e,Et,t),a(e,ye,t),a(e,Qt,t),p(Me,e,t),a(e,Lt,t),p(B,e,t),a(e,St,t),a(e,we,t),a(e,qt,t),p(be,e,t),a(e,Pt,t),a(e,ge,t),a(e,Kt,t),p(x,e,t),a(e,Dt,t),p($e,e,t),a(e,Ot,t),p(Te,e,t),a(e,el,t),a(e,je,t),a(e,tl,t),p(W,e,t),a(e,ll,t),p(Je,e,t),a(e,al,t),p(Ue,e,t),a(e,nl,t),a(e,ve,t),a(e,sl,t),p(I,e,t),a(e,il,t),p(ke,e,t),a(e,rl,t),a(e,Ce,t),a(e,ol,t),a(e,_e,t),a(e,pl,t),p(G,e,t),a(e,ml,t),a(e,Ze,t),a(e,cl,t),p(Be,e,t),a(e,dl,t),a(e,xe,t),a(e,ul,t),p(We,e,t),a(e,hl,t),a(e,Ie,t),a(e,fl,t),p(Ge,e,t),a(e,yl,t),a(e,Xe,t),a(e,Ml,t),a(e,ze,t),a(e,wl,t),p(Re,e,t),a(e,bl,t),a(e,Ae,t),a(e,gl,t),p(X,e,t),a(e,$l,t),p(Ye,e,t),a(e,Tl,t),a(e,Ve,t),a(e,jl,t),a(e,He,t),a(e,Jl,t),a(e,Ne,t),a(e,Ul,t),a(e,Fe,t),a(e,vl,t),a(e,Ee,t),a(e,kl,t),a(e,Qe,t),a(e,Cl,t),a(e,Le,t),a(e,_l,t),p(Se,e,t),a(e,Zl,t),a(e,qe,t),a(e,Bl,t),p(Pe,e,t),a(e,xl,t),p(Ke,e,t),a(e,Wl,t),p(De,e,t),a(e,Il,t),p(Oe,e,t),a(e,Gl,t),p(et,e,t),a(e,Xl,t),p(tt,e,t),a(e,zl,t),p(lt,e,t),a(e,Rl,t),p(at,e,t),a(e,Al,t),p(nt,e,t),a(e,Yl,t),p(st,e,t),a(e,Vl,t),p(it,e,t),a(e,Hl,t),p(rt,e,t),a(e,Nl,t),p(ot,e,t),a(e,Fl,t),p(pt,e,t),a(e,El,t),p(z,e,t),a(e,Ql,t),p(mt,e,t),a(e,Ll,t),a(e,dt,t),Sl=!0},p(e,[t]){const Za={};t&2&&(Za.$$scope={dirty:t,ctx:e}),_.$set(Za);const Ba={};t&2&&(Ba.$$scope={dirty:t,ctx:e}),Z.$set(Ba);const xa={};t&2&&(xa.$$scope={dirty:t,ctx:e}),B.$set(xa);const Wa={};t&2&&(Wa.$$scope={dirty:t,ctx:e}),x.$set(Wa);const Ia={};t&2&&(Ia.$$scope={dirty:t,ctx:e}),W.$set(Ia);const Ga={};t&2&&(Ga.$$scope={dirty:t,ctx:e}),I.$set(Ga);const Xa={};t&2&&(Xa.$$scope={dirty:t,ctx:e}),G.$set(Xa);const za={};t&2&&(za.$$scope={dirty:t,ctx:e}),X.$set(za);const Ra={};t&2&&(Ra.$$scope={dirty:t,ctx:e}),z.$set(Ra)},i(e){Sl||(m(J.$$.fragment,e),m(g.$$.fragment,e),m(w.$$.fragment,e),m(A.$$.fragment,e),m(_.$$.fragment,e),m(V.$$.fragment,e),m(H.$$.fragment,e),m(Q.$$.fragment,e),m(S.$$.fragment,e),m(P.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(le.$$.fragment,e),m(ne.$$.fragment,e),m(se.$$.fragment,e),m(oe.$$.fragment,e),m(Z.$$.fragment,e),m(me.$$.fragment,e),m(ce.$$.fragment,e),m(de.$$.fragment,e),m(he.$$.fragment,e),m(fe.$$.fragment,e),m(Me.$$.fragment,e),m(B.$$.fragment,e),m(be.$$.fragment,e),m(x.$$.fragment,e),m($e.$$.fragment,e),m(Te.$$.fragment,e),m(W.$$.fragment,e),m(Je.$$.fragment,e),m(Ue.$$.fragment,e),m(I.$$.fragment,e),m(ke.$$.fragment,e),m(G.$$.fragment,e),m(Be.$$.fragment,e),m(We.$$.fragment,e),m(Ge.$$.fragment,e),m(Re.$$.fragment,e),m(X.$$.fragment,e),m(Ye.$$.fragment,e),m(Se.$$.fragment,e),m(Pe.$$.fragment,e),m(Ke.$$.fragment,e),m(De.$$.fragment,e),m(Oe.$$.fragment,e),m(et.$$.fragment,e),m(tt.$$.fragment,e),m(lt.$$.fragment,e),m(at.$$.fragment,e),m(nt.$$.fragment,e),m(st.$$.fragment,e),m(it.$$.fragment,e),m(rt.$$.fragment,e),m(ot.$$.fragment,e),m(pt.$$.fragment,e),m(z.$$.fragment,e),m(mt.$$.fragment,e),Sl=!0)},o(e){c(J.$$.fragment,e),c(g.$$.fragment,e),c(w.$$.fragment,e),c(A.$$.fragment,e),c(_.$$.fragment,e),c(V.$$.fragment,e),c(H.$$.fragment,e),c(Q.$$.fragment,e),c(S.$$.fragment,e),c(P.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(se.$$.fragment,e),c(oe.$$.fragment,e),c(Z.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(de.$$.fragment,e),c(he.$$.fragment,e),c(fe.$$.fragment,e),c(Me.$$.fragment,e),c(B.$$.fragment,e),c(be.$$.fragment,e),c(x.$$.fragment,e),c($e.$$.fragment,e),c(Te.$$.fragment,e),c(W.$$.fragment,e),c(Je.$$.fragment,e),c(Ue.$$.fragment,e),c(I.$$.fragment,e),c(ke.$$.fragment,e),c(G.$$.fragment,e),c(Be.$$.fragment,e),c(We.$$.fragment,e),c(Ge.$$.fragment,e),c(Re.$$.fragment,e),c(X.$$.fragment,e),c(Ye.$$.fragment,e),c(Se.$$.fragment,e),c(Pe.$$.fragment,e),c(Ke.$$.fragment,e),c(De.$$.fragment,e),c(Oe.$$.fragment,e),c(et.$$.fragment,e),c(tt.$$.fragment,e),c(lt.$$.fragment,e),c(at.$$.fragment,e),c(nt.$$.fragment,e),c(st.$$.fragment,e),c(it.$$.fragment,e),c(rt.$$.fragment,e),c(ot.$$.fragment,e),c(pt.$$.fragment,e),c(z.$$.fragment,e),c(mt.$$.fragment,e),Sl=!1},d(e){e&&(l(b),l(u),l(M),l($),l(k),l(U),l(ut),l(Y),l(ht),l(ft),l(yt),l(Mt),l(N),l(wt),l(F),l(bt),l(E),l(gt),l($t),l(L),l(Tt),l(jt),l(q),l(Jt),l(Ut),l(K),l(vt),l(kt),l(Ct),l(ee),l(_t),l(te),l(Zt),l(Bt),l(ae),l(xt),l(Wt),l(It),l(ie),l(Gt),l(re),l(Xt),l(zt),l(Rt),l(pe),l(At),l(Yt),l(Vt),l(Ht),l(ue),l(Nt),l(Ft),l(Et),l(ye),l(Qt),l(Lt),l(St),l(we),l(qt),l(Pt),l(ge),l(Kt),l(Dt),l(Ot),l(el),l(je),l(tl),l(ll),l(al),l(nl),l(ve),l(sl),l(il),l(rl),l(Ce),l(ol),l(_e),l(pl),l(ml),l(Ze),l(cl),l(dl),l(xe),l(ul),l(hl),l(Ie),l(fl),l(yl),l(Xe),l(Ml),l(ze),l(wl),l(bl),l(Ae),l(gl),l($l),l(Tl),l(Ve),l(jl),l(He),l(Jl),l(Ne),l(Ul),l(Fe),l(vl),l(Ee),l(kl),l(Qe),l(Cl),l(Le),l(_l),l(Zl),l(qe),l(Bl),l(xl),l(Wl),l(Il),l(Gl),l(Xl),l(zl),l(Rl),l(Al),l(Yl),l(Vl),l(Hl),l(Nl),l(Fl),l(El),l(Ql),l(Ll),l(dt)),l(i),d(J,e),d(g,e),d(w,e),d(A,e),d(_,e),d(V,e),d(H,e),d(Q,e),d(S,e),d(P,e),d(D,e),d(O,e),d(le,e),d(ne,e),d(se,e),d(oe,e),d(Z,e),d(me,e),d(ce,e),d(de,e),d(he,e),d(fe,e),d(Me,e),d(B,e),d(be,e),d(x,e),d($e,e),d(Te,e),d(W,e),d(Je,e),d(Ue,e),d(I,e),d(ke,e),d(G,e),d(Be,e),d(We,e),d(Ge,e),d(Re,e),d(X,e),d(Ye,e),d(Se,e),d(Pe,e),d(Ke,e),d(De,e),d(Oe,e),d(et,e),d(tt,e),d(lt,e),d(at,e),d(nt,e),d(st,e),d(it,e),d(rt,e),d(ot,e),d(pt,e),d(z,e),d(mt,e)}}}const mn='{"title":"A full training loop","local":"a-full-training","sections":[{"title":"Prepare for training","local":"prepare-for-training","sections":[],"depth":3},{"title":"The training loop","local":"the-training-loop","sections":[],"depth":3},{"title":"The evaluation loop","local":"the-evaluation-loop","sections":[],"depth":3},{"title":"Supercharge your training loop with 🤗 Accelerate","local":"supercharge-your-training-loop-with-accelerate","sections":[],"depth":3},{"title":"Next Steps and Best Practices","local":"next-steps-and-best-practices","sections":[],"depth":3},{"title":"Section Quiz","local":"section-quiz","sections":[{"title":"1. What is the main difference between Adam and AdamW optimizers?","local":"1-what-is-the-main-difference-between-adam-and-adamw-optimizers","sections":[],"depth":3},{"title":"2. In a training loop, what is the correct order of operations?","local":"2-in-a-training-loop-what-is-the-correct-order-of-operations","sections":[],"depth":3},{"title":"3. What does the 🤗 Accelerate library primarily help with?","local":"3-what-does-the--accelerate-library-primarily-help-with","sections":[],"depth":3},{"title":"4. Why do we move batches to the device in a training loop?","local":"4-why-do-we-move-batches-to-the-device-in-a-training-loop","sections":[],"depth":3},{"title":"5. What does model.eval() do before evaluation?","local":"5-what-does-modeleval-do-before-evaluation","sections":[],"depth":3},{"title":"6. What is the purpose of torch.no_grad() during evaluation?","local":"6-what-is-the-purpose-of-torchnograd-during-evaluation","sections":[],"depth":3},{"title":"7. What changes when you use 🤗 Accelerate in your training loop?","local":"7-what-changes-when-you-use--accelerate-in-your-training-loop","sections":[],"depth":3}],"depth":2}],"depth":1}';function cn(j){return Na(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gn extends Fa{constructor(i){super(),Ea(this,i,cn,pn,Ha,{})}}export{gn as component};
