import{s as Bi,o as _i,n as Qi}from"../chunks/scheduler.cc52f4b9.js";import{S as Ai,i as Ri,e as i,s as n,c as o,h as Ni,a as p,d as s,b as a,f as Wi,g as c,j as r,k as oa,l as Xi,m as l,n as M,t as m,o as y,p as h}from"../chunks/index.5b747fde.js";import{T as Gi}from"../chunks/Tip.f0925d57.js";import{C as qi,H as ys,E as Li}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d38ac5a9.js";import{Y as Hi}from"../chunks/Youtube.8bb4154e.js";import{C as u}from"../chunks/CodeBlock.665bfc37.js";import{C as Di}from"../chunks/CourseFloatingBanner.b33fcd79.js";function Ei(hs){let J,j=`<strong>To go further</strong> If you test the two versions of the previous normalizers on a string containing the unicode character <code>u&quot;\\u0085&quot;</code> you will surely notice that these two normalizers are not exactly equivalent.
To not over-complicate the version with <code>normalizers.Sequence</code> too much , we haven’t included the Regex replacements that the <code>BertNormalizer</code> requires when the <code>clean_text</code> argument is set to <code>True</code> - which is the default behavior. But don’t worry: it is possible to get exactly the same normalization without using the handy <code>BertNormalizer</code> by adding two <code>normalizers.Replace</code>’s to the normalizers sequence.`;return{c(){J=i("p"),J.innerHTML=j},l(d){J=p(d,"P",{"data-svelte-h":!0}),r(J)!=="svelte-fwgfxt"&&(J.innerHTML=j)},m(d,Ms){l(d,J,Ms)},p:Qi,d(d){d&&s(J)}}}function Si(hs){let J,j,d,Ms,k,us,w,Js,b,ds,$,ca="As we’ve seen in the previous sections, tokenization comprises several steps:",fs,g,Ma="<li>Normalization (any cleanup of the text that is deemed necessary, such as removing spaces or accents, Unicode normalization, etc.)</li> <li>Pre-tokenization (splitting the input into words)</li> <li>Running the input through the model (using the pre-tokenized words to produce a sequence of tokens)</li> <li>Post-processing (adding the special tokens of the tokenizer, generating the attention mask and token type IDs)</li>",Ts,U,ma="As a reminder, here’s another look at the overall process:",js,f,ya='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline.svg" alt="The tokenization pipeline."/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline-dark.svg" alt="The tokenization pipeline."/>',ks,x,ha='The 🤗 Tokenizers library has been built to provide several options for each of those steps, which you can mix and match together. In this section we’ll see how we can build a tokenizer from scratch, as opposed to training a new tokenizer from an old one as we did in <a href="/course/chapter6/2">section 2</a>. You’ll then be able to build any kind of tokenizer you can think of!',ws,z,bs,I,ua="More precisely, the library is built around a central <code>Tokenizer</code> class with the building blocks regrouped in submodules:",$s,C,Ja='<li><code>normalizers</code> contains all the possible types of <code>Normalizer</code> you can use (complete list <a href="https://huggingface.co/docs/tokenizers/api/normalizers" rel="nofollow">here</a>).</li> <li><code>pre_tokenizers</code> contains all the possible types of <code>PreTokenizer</code> you can use (complete list <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>).</li> <li><code>models</code> contains the various types of <code>Model</code> you can use, like <code>BPE</code>, <code>WordPiece</code>, and <code>Unigram</code> (complete list <a href="https://huggingface.co/docs/tokenizers/api/models" rel="nofollow">here</a>).</li> <li><code>trainers</code> contains all the different types of <code>Trainer</code> you can use to train your model on a corpus (one per type of model; complete list <a href="https://huggingface.co/docs/tokenizers/api/trainers" rel="nofollow">here</a>).</li> <li><code>post_processors</code> contains the various types of <code>PostProcessor</code> you can use (complete list <a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">here</a>).</li> <li><code>decoders</code> contains the various types of <code>Decoder</code> you can use to decode the outputs of tokenization (complete list <a href="https://huggingface.co/docs/tokenizers/components#decoders" rel="nofollow">here</a>).</li>',gs,v,da='You can find the whole list of building blocks <a href="https://huggingface.co/docs/tokenizers/components" rel="nofollow">here</a>.',Us,Z,xs,V,fa='To train our new tokenizer, we will use a small corpus of text (so the examples run fast). The steps for acquiring the corpus are similar to the ones we took at the <a href="/course/chapter6/2">beginning of this chapter</a>, but this time we’ll use the <a href="https://huggingface.co/datasets/wikitext" rel="nofollow">WikiText-2</a> dataset:',zs,W,Is,B,Ta="The function <code>get_training_corpus()</code> is a generator that will yield batches of 1,000 texts, which we will use to train the tokenizer.",Cs,_,ja="🤗 Tokenizers can also be trained on text files directly. Here’s how we can generate a text file containing all the texts/inputs from WikiText-2 that we can use locally:",vs,Q,Zs,A,ka="Next we’ll show you how to build your own BERT, GPT-2, and XLNet tokenizers, block by block. That will give us an example of each of the three main tokenization algorithms: WordPiece, BPE, and Unigram. Let’s start with BERT!",Vs,R,Ws,N,wa="To build a tokenizer with the 🤗 Tokenizers library, we start by instantiating a <code>Tokenizer</code> object with a <code>model</code>, then set its <code>normalizer</code>, <code>pre_tokenizer</code>, <code>post_processor</code>, and <code>decoder</code> attributes to the values we want.",Bs,X,ba="For this example, we’ll create a <code>Tokenizer</code> with a WordPiece model:",_s,G,Qs,q,$a="We have to specify the <code>unk_token</code> so the model knows what to return when it encounters characters it hasn’t seen before. Other arguments we can set here include the <code>vocab</code> of our model (we’re going to train the model, so we don’t need to set this) and <code>max_input_chars_per_word</code>, which specifies a maximum length for each word (words longer than the value passed will be split).",As,L,ga="The first step of tokenization is normalization, so let’s begin with that. Since BERT is widely used, there is a <code>BertNormalizer</code> with the classic options we can set for BERT: <code>lowercase</code> and <code>strip_accents</code>, which are self-explanatory; <code>clean_text</code> to remove all control characters and replace repeating spaces with a single one; and <code>handle_chinese_chars</code>, which places spaces around Chinese characters. To replicate the <code>bert-base-uncased</code> tokenizer, we can just set this normalizer:",Rs,H,Ns,D,Ua="Generally speaking, however, when building a new tokenizer you won’t have access to such a handy normalizer already implemented in the 🤗 Tokenizers library — so let’s see how to create the BERT normalizer by hand. The library provides a <code>Lowercase</code> normalizer and a <code>StripAccents</code> normalizer, and you can compose several normalizers using a <code>Sequence</code>:",Xs,E,Gs,S,xa="We’re also using an <code>NFD</code> Unicode normalizer, as otherwise the <code>StripAccents</code> normalizer won’t properly recognize the accented characters and thus won’t strip them out.",qs,P,za="As we’ve seen before, we can use the <code>normalize_str()</code> method of the <code>normalizer</code> to check out the effects it has on a given text:",Ls,F,Hs,Y,Ds,T,Es,K,Ia="Next is the pre-tokenization step. Again, there is a prebuilt <code>BertPreTokenizer</code> that we can use:",Ss,O,Ps,ee,Ca="Or we can build it from scratch:",Fs,te,Ys,se,va="Note that the <code>Whitespace</code> pre-tokenizer splits on whitespace and all characters that are not letters, digits, or the underscore character, so it technically splits on whitespace and punctuation:",Ks,le,Os,ne,el,ae,Za="If you only want to split on whitespace, you should use the <code>WhitespaceSplit</code> pre-tokenizer instead:",tl,ie,sl,pe,ll,re,Va="Like with normalizers, you can use a <code>Sequence</code> to compose several pre-tokenizers:",nl,oe,al,ce,il,Me,Wa="The next step in the tokenization pipeline is running the inputs through the model. We already specified our model in the initialization, but we still need to train it, which will require a <code>WordPieceTrainer</code>. The main thing to remember when instantiating a trainer in 🤗 Tokenizers is that you need to pass it all the special tokens you intend to use — otherwise it won’t add them to the vocabulary, since they are not in the training corpus:",pl,me,rl,ye,Ba="As well as specifying the <code>vocab_size</code> and <code>special_tokens</code>, we can set the <code>min_frequency</code> (the number of times a token must appear to be included in the vocabulary) or change the <code>continuing_subword_prefix</code> (if we want to use something different from <code>##</code>).",ol,he,_a="To train our model using the iterator we defined earlier, we just have to execute this command:",cl,ue,Ml,Je,Qa="We can also use text files to train our tokenizer, which would look like this (we reinitialize the model with an empty <code>WordPiece</code> beforehand):",ml,de,yl,fe,Aa="In both cases, we can then test the tokenizer on a text by calling the <code>encode()</code> method:",hl,Te,ul,je,Jl,ke,Ra="The <code>encoding</code> obtained is an <code>Encoding</code>, which contains all the necessary outputs of the tokenizer in its various attributes: <code>ids</code>, <code>type_ids</code>, <code>tokens</code>, <code>offsets</code>, <code>attention_mask</code>, <code>special_tokens_mask</code>, and <code>overflowing</code>.",dl,we,Na="The last step in the tokenization pipeline is post-processing. We need to add the <code>[CLS]</code> token at the beginning and the <code>[SEP]</code> token at the end (or after each sentence, if we have a pair of sentences). We will use a <code>TemplateProcessor</code> for this, but first we need to know the IDs of the <code>[CLS]</code> and <code>[SEP]</code> tokens in the vocabulary:",fl,be,Tl,$e,jl,ge,Xa="To write the template for the <code>TemplateProcessor</code>, we have to specify how to treat a single sentence and a pair of sentences. For both, we write the special tokens we want to use; the first (or single) sentence is represented by <code>$A</code>, while the second sentence (if encoding a pair) is represented by <code>$B</code>. For each of these (special tokens and sentences), we also specify the corresponding token type ID after a colon.",kl,Ue,Ga="The classic BERT template is thus defined as follows:",wl,xe,bl,ze,qa="Note that we need to pass along the IDs of the special tokens, so the tokenizer can properly convert them to their IDs.",$l,Ie,La="Once this is added, going back to our previous example will give:",gl,Ce,Ul,ve,xl,Ze,Ha="And on a pair of sentences, we get the proper result:",zl,Ve,Il,We,Cl,Be,Da="We’ve almost finished building this tokenizer from scratch — the last step is to include a decoder:",vl,_e,Zl,Qe,Ea="Let’s test it on our previous <code>encoding</code>:",Vl,Ae,Wl,Re,Bl,Ne,Sa="Great! We can save our tokenizer in a single JSON file like this:",_l,Xe,Ql,Ge,Pa="We can then reload that file in a <code>Tokenizer</code> object with the <code>from_file()</code> method:",Al,qe,Rl,Le,Fa="To use this tokenizer in 🤗 Transformers, we have to wrap it in a <code>PreTrainedTokenizerFast</code>. We can either use the generic class or, if our tokenizer corresponds to an existing model, use that class (here, <code>BertTokenizerFast</code>). If you apply this lesson to build a brand new tokenizer, you will have to use the first option.",Nl,He,Ya="To wrap the tokenizer in a <code>PreTrainedTokenizerFast</code>, we can either pass the tokenizer we built as a <code>tokenizer_object</code> or pass the tokenizer file we saved as <code>tokenizer_file</code>. The key thing to remember is that we have to manually set all the special tokens, since that class can’t infer from the <code>tokenizer</code> object which token is the mask token, the <code>[CLS]</code> token, etc.:",Xl,De,Gl,Ee,Ka="If you are using a specific tokenizer class (like <code>BertTokenizerFast</code>), you will only need to specify the special tokens that are different from the default ones (here, none):",ql,Se,Ll,Pe,Oa="You can then use this tokenizer like any other 🤗 Transformers tokenizer. You can save it with the <code>save_pretrained()</code> method, or upload it to the Hub with the <code>push_to_hub()</code> method.",Hl,Fe,ei="Now that we’ve seen how to build a WordPiece tokenizer, let’s do the same for a BPE tokenizer. We’ll go a bit faster since you know all the steps, and only highlight the differences.",Dl,Ye,El,Ke,ti="Let’s now build a GPT-2 tokenizer. Like for the BERT tokenizer, we start by initializing a <code>Tokenizer</code> with a BPE model:",Sl,Oe,Pl,et,si="Also like for BERT, we could initialize this model with a vocabulary if we had one (we would need to pass the <code>vocab</code> and <code>merges</code> in this case), but since we will train from scratch, we don’t need to do that. We also don’t need to specify an <code>unk_token</code> because GPT-2 uses byte-level BPE, which doesn’t require it.",Fl,tt,li="GPT-2 does not use a normalizer, so we skip that step and go directly to the pre-tokenization:",Yl,st,Kl,lt,ni="The option we added to <code>ByteLevel</code> here is to not add a space at the beginning of a sentence (which is the default otherwise). We can have a look at the pre-tokenization of an example text like before:",Ol,nt,en,at,tn,it,ai="Next is the model, which needs training. For GPT-2, the only special token is the end-of-text token:",sn,pt,ln,rt,ii="Like with the <code>WordPieceTrainer</code>, as well as the <code>vocab_size</code> and <code>special_tokens</code>, we can specify the <code>min_frequency</code> if we want to, or if we have an end-of-word suffix (like <code>&lt;/w&gt;</code>), we can set it with <code>end_of_word_suffix</code>.",nn,ot,pi="This tokenizer can also be trained on text files:",an,ct,pn,Mt,ri="Let’s have a look at the tokenization of a sample text:",rn,mt,on,yt,cn,ht,oi="We apply the byte-level post-processing for the GPT-2 tokenizer as follows:",Mn,ut,mn,Jt,ci="The <code>trim_offsets = False</code> option indicates to the post-processor that we should leave the offsets of tokens that begin with ‘Ġ’ as they are: this way the start of the offsets will point to the space before the word, not the first character of the word (since the space is technically part of the token). Let’s have a look at the result with the text we just encoded, where <code>&#39;Ġtest&#39;</code> is the token at index 4:",yn,dt,hn,ft,un,Tt,Mi="Finally, we add a byte-level decoder:",Jn,jt,dn,kt,mi="and we can double-check it works properly:",fn,wt,Tn,bt,jn,$t,yi="Great! Now that we’re done, we can save the tokenizer like before, and wrap it in a <code>PreTrainedTokenizerFast</code> or <code>GPT2TokenizerFast</code> if we want to use it in 🤗 Transformers:",kn,gt,wn,Ut,hi="or:",bn,xt,$n,zt,ui="As the last example, we’ll show you how to build a Unigram tokenizer from scratch.",gn,It,Un,Ct,Ji="Let’s now build an XLNet tokenizer. Like for the previous tokenizers, we start by initializing a <code>Tokenizer</code> with a Unigram model:",xn,vt,zn,Zt,di="Again, we could initialize this model with a vocabulary if we had one.",In,Vt,fi="For the normalization, XLNet uses a few replacements (which come from SentencePiece):",Cn,Wt,vn,Bt,Ti="This replaces <code>“</code> and <code>”</code> with <code>”</code> and any sequence of two or more spaces with a single space, as well as removing the accents in the texts to tokenize.",Zn,_t,ji="The pre-tokenizer to use for any SentencePiece tokenizer is <code>Metaspace</code>:",Vn,Qt,Wn,At,ki="We can have a look at the pre-tokenization of an example text like before:",Bn,Rt,_n,Nt,Qn,Xt,wi="Next is the model, which needs training. XLNet has quite a few special tokens:",An,Gt,Rn,qt,bi="A very important argument not to forget for the <code>UnigramTrainer</code> is the <code>unk_token</code>. We can also pass along other arguments specific to the Unigram algorithm, such as the <code>shrinking_factor</code> for each step where we remove tokens (defaults to 0.75) or the <code>max_piece_length</code> to specify the maximum length of a given token (defaults to 16).",Nn,Lt,$i="This tokenizer can also be trained on text files:",Xn,Ht,Gn,Dt,gi="Let’s have a look at the tokenization of a sample text:",qn,Et,Ln,St,Hn,Pt,Ui="A peculiarity of XLNet is that it puts the <code>&lt;cls&gt;</code> token at the end of the sentence, with a type ID of 2 (to distinguish it from the other tokens). It’s padding on the left, as a result. We can deal with all the special tokens and token type IDs with a template, like for BERT, but first we have to get the IDs of the <code>&lt;cls&gt;</code> and <code>&lt;sep&gt;</code> tokens:",Dn,Ft,En,Yt,Sn,Kt,xi="The template looks like this:",Pn,Ot,Fn,es,zi="And we can test it works by encoding a pair of sentences:",Yn,ts,Kn,ss,On,ls,Ii="Finally, we add a <code>Metaspace</code> decoder:",ea,ns,ta,as,Ci="and we’re done with this tokenizer! We can save the tokenizer like before, and wrap it in a <code>PreTrainedTokenizerFast</code> or <code>XLNetTokenizerFast</code> if we want to use it in 🤗 Transformers. One thing to note when using <code>PreTrainedTokenizerFast</code> is that on top of the special tokens, we need to tell the 🤗 Transformers library to pad on the left:",sa,is,la,ps,vi="Or alternatively:",na,rs,aa,os,Zi="Now that you have seen how the various building blocks are used to build existing tokenizers, you should be able to write any tokenizer you want with the 🤗 Tokenizers library and be able to use it in 🤗 Transformers.",ia,cs,pa,ms,ra;return k=new qi({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new ys({props:{title:"Building a tokenizer, block by block",local:"building-a-tokenizer-block-by-block",headingTag:"h1"}}),b=new Di({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"}]}}),z=new Hi({props:{id:"MR8tZm5ViWU"}}),Z=new ys({props:{title:"Acquiring a corpus",local:"acquiring-a-corpus",headingTag:"h2"}}),W=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ3aWtpdGV4dCUyMiUyQyUyMG5hbWUlM0QlMjJ3aWtpdGV4dC0yLXJhdy12MSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBJTBBZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihkYXRhc2V0KSUyQyUyMDEwMDApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBkYXRhc2V0JTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIydGV4dCUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;wikitext&quot;</span>, name=<span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> dataset[i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),Q=new u({props:{code:"d2l0aCUyMG9wZW4oJTIyd2lraXRleHQtMi50eHQlMjIlMkMlMjAlMjJ3JTIyJTJDJTIwZW5jb2RpbmclM0QlMjJ1dGYtOCUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oZGF0YXNldCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShkYXRhc2V0JTVCaSU1RCU1QiUyMnRleHQlMjIlNUQlMjAlMkIlMjAlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)):
        f.write(dataset[i][<span class="hljs-string">&quot;text&quot;</span>] + <span class="hljs-string">&quot;\\n&quot;</span>)`,wrap:!1}}),R=new ys({props:{title:"Building a WordPiece tokenizer from scratch",local:"building-a-wordpiece-tokenizer-from-scratch",headingTag:"h2"}}),G=new u({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwZGVjb2RlcnMlMkMlMEElMjAlMjAlMjAlMjBtb2RlbHMlMkMlMEElMjAlMjAlMjAlMjBub3JtYWxpemVycyUyQyUwQSUyMCUyMCUyMCUyMHByZV90b2tlbml6ZXJzJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29ycyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluZXJzJTJDJTBBJTIwJTIwJTIwJTIwVG9rZW5pemVyJTJDJTBBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMFRva2VuaXplcihtb2RlbHMuV29yZFBpZWNlKHVua190b2tlbiUzRCUyMiU1QlVOSyU1RCUyMikp",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> (
    decoders,
    models,
    normalizers,
    pre_tokenizers,
    processors,
    trainers,
    Tokenizer,
)

tokenizer = Tokenizer(models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>))`,wrap:!1}}),H=new u({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5CZXJ0Tm9ybWFsaXplcihsb3dlcmNhc2UlM0RUcnVlKQ==",highlighted:'tokenizer.normalizer = normalizers.BertNormalizer(lowercase=<span class="hljs-literal">True</span>)',wrap:!1}}),E=new u({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5TZXF1ZW5jZSglMEElMjAlMjAlMjAlMjAlNUJub3JtYWxpemVycy5ORkQoKSUyQyUyMG5vcm1hbGl6ZXJzLkxvd2VyY2FzZSgpJTJDJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklNUQlMEEp",highlighted:`tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [normalizers.NFD(), normalizers.Lowercase(), normalizers.StripAccents()]
)`,wrap:!1}}),F=new u({props:{code:"cHJpbnQodG9rZW5pemVyLm5vcm1hbGl6ZXIubm9ybWFsaXplX3N0ciglMjJIJUMzJUE5bGwlQzMlQjIlMjBoJUMzJUI0dyUyMGFyZSUyMCVDMyVCQyUzRiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(tokenizer.normalizer.normalize_str(<span class="hljs-string">&quot;Héllò hôw are ü?&quot;</span>))',wrap:!1}}),Y=new u({props:{code:"aGVsbG8lMjBob3clMjBhcmUlMjB1JTNG",highlighted:"hello how are u?",wrap:!1}}),T=new Gi({props:{$$slots:{default:[Ei]},$$scope:{ctx:hs}}}),O=new u({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CZXJ0UHJlVG9rZW5pemVyKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.BertPreTokenizer()",wrap:!1}}),te=new u({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5XaGl0ZXNwYWNlKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Whitespace()",wrap:!1}}),le=new u({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBteSUyMHByZS10b2tlbml6ZXIuJTIyKQ==",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)',wrap:!1}}),ne=new u({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),ie=new u({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTBBcHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKCUyMkxldCdzJTIwdGVzdCUyMG15JTIwcHJlLXRva2VuaXplci4lMjIp",highlighted:`pre_tokenizer = pre_tokenizers.WhitespaceSplit()
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),pe=new u({props:{code:"JTVCKCUyMkxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJ3Rlc3QnJTJDJTIwKDYlMkMlMjAxMCkpJTJDJTIwKCdteSclMkMlMjAoMTElMkMlMjAxMykpJTJDJTIwKCdwcmUtdG9rZW5pemVyLiclMkMlMjAoMTQlMkMlMjAyOCkpJTVE",highlighted:'[(<span class="hljs-string">&quot;Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre-tokenizer.&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">28</span>))]',wrap:!1}}),oe=new u({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLlNlcXVlbmNlKCUwQSUyMCUyMCUyMCUyMCU1QnByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTJDJTIwcHJlX3Rva2VuaXplcnMuUHVuY3R1YXRpb24oKSU1RCUwQSklMEFwcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIoJTIyTGV0J3MlMjB0ZXN0JTIwbXklMjBwcmUtdG9rZW5pemVyLiUyMik=",highlighted:`pre_tokenizer = pre_tokenizers.<span class="hljs-type">Sequence</span>(
    [pre_tokenizers.WhitespaceSplit(), pre_tokenizers.Punctuation()]
)
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),ce=new u({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),me=new u({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlNUJVTkslNUQlMjIlMkMlMjAlMjIlNUJQQUQlNUQlMjIlMkMlMjAlMjIlNUJDTFMlNUQlMjIlMkMlMjAlMjIlNUJTRVAlNUQlMjIlMkMlMjAlMjIlNUJNQVNLJTVEJTIyJTVEJTBBdHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLldvcmRQaWVjZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2Vucyk=",highlighted:`special_tokens = [<span class="hljs-string">&quot;[UNK]&quot;</span>, <span class="hljs-string">&quot;[PAD]&quot;</span>, <span class="hljs-string">&quot;[CLS]&quot;</span>, <span class="hljs-string">&quot;[SEP]&quot;</span>, <span class="hljs-string">&quot;[MASK]&quot;</span>]
trainer = trainers.WordPieceTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens)`,wrap:!1}}),ue=new u({props:{code:"dG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:"tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)",wrap:!1}}),de=new u({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLldvcmRQaWVjZSh1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>)
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Te=new u({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),je=new u({props:{code:"JTVCJ2xldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJ3Rlc3QnJTJDJTIwJ3RoaXMnJTJDJTIwJ3RvayclMkMlMjAnJTIzJTIzZW5pJyUyQyUyMCclMjMlMjN6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),be=new u({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiU1QkNMUyU1RCUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTVCU0VQJTVEJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[CLS]&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[SEP]&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),$e=new u({props:{code:"KDIlMkMlMjAzKQ==",highlighted:'(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>)',wrap:!1}}),xe=new u({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWlyJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjAlMjRCJTNBMSUyMCU1QlNFUCU1RCUzQTElMjIlMkMlMEElMjAlMjAlMjAlMjBzcGVjaWFsX3Rva2VucyUzRCU1QiglMjIlNUJDTFMlNUQlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTJDJTIwKCUyMiU1QlNFUCU1RCUyMiUyQyUyMHNlcF90b2tlbl9pZCklNUQlMkMlMEEp",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0&quot;</span>,
    pair=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0 $B:1 [SEP]:1&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;[CLS]&quot;</span>, cls_token_id), (<span class="hljs-string">&quot;[SEP]&quot;</span>, sep_token_id)],
)`,wrap:!1}}),Ce=new u({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),ve=new u({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLiclMkMlMjAnJTVCU0VQJTVEJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]',wrap:!1}}),Ve=new u({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),We=new u({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLi4uJyUyQyUyMCclNUJTRVAlNUQnJTJDJTIwJ29uJyUyQyUyMCdhJyUyQyUyMCdwYWlyJyUyQyUyMCdvZiclMkMlMjAnc2VudGVuY2VzJyUyQyUyMCcuJyUyQyUyMCclNUJTRVAlNUQnJTVEJTBBJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVE",highlighted:`[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;...&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;pair&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;sentences&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]`,wrap:!1}}),_e=new u({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5Xb3JkUGllY2UocHJlZml4JTNEJTIyJTIzJTIzJTIyKQ==",highlighted:'tokenizer.decoder = decoders.WordPiece(prefix=<span class="hljs-string">&quot;##&quot;</span>)',wrap:!1}}),Ae=new u({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),Re=new u({props:{code:"JTIybGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4uLiUyMG9uJTIwYSUyMHBhaXIlMjBvZiUyMHNlbnRlbmNlcy4lMjI=",highlighted:'<span class="hljs-string">&quot;let&#x27;s test this tokenizer... on a pair of sentences.&quot;</span>',wrap:!1}}),Xe=new u({props:{code:"dG9rZW5pemVyLnNhdmUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'tokenizer.save(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),qe=new u({props:{code:"bmV3X3Rva2VuaXplciUyMCUzRCUyMFRva2VuaXplci5mcm9tX2ZpbGUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'new_tokenizer = Tokenizer.from_file(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),De=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwdG9rZW5pemVyX2ZpbGUlM0QlMjJ0b2tlbml6ZXIuanNvbiUyMiUyQyUyMCUyMyUyMFlvdSUyMGNhbiUyMGxvYWQlMjBmcm9tJTIwdGhlJTIwdG9rZW5pemVyJTIwZmlsZSUyQyUyMGFsdGVybmF0aXZlbHklMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlNUJQQUQlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlNUJDTFMlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlNUJTRVAlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTVCTUFTSyU1RCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    <span class="hljs-comment"># tokenizer_file=&quot;tokenizer.json&quot;, # You can load from the tokenizer file, alternatively</span>
    unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>,
    pad_token=<span class="hljs-string">&quot;[PAD]&quot;</span>,
    cls_token=<span class="hljs-string">&quot;[CLS]&quot;</span>,
    sep_token=<span class="hljs-string">&quot;[SEP]&quot;</span>,
    mask_token=<span class="hljs-string">&quot;[MASK]&quot;</span>,
)`,wrap:!1}}),Se=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizerFast

wrapped_tokenizer = BertTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),Ye=new ys({props:{title:"Building a BPE tokenizer from scratch",local:"building-a-bpe-tokenizer-from-scratch",headingTag:"h2"}}),Oe=new u({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5CUEUoKSk=",highlighted:"tokenizer = Tokenizer(models.BPE())",wrap:!1}}),st=new u({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CeXRlTGV2ZWwoYWRkX3ByZWZpeF9zcGFjZSUzREZhbHNlKQ==",highlighted:'tokenizer.pre_tokenizer = pre_tokenizers.ByteLevel(add_prefix_space=<span class="hljs-literal">False</span>)',wrap:!1}}),nt=new u({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBwcmUtdG9rZW5pemF0aW9uISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test pre-tokenization!&quot;</span>)',wrap:!1}}),at=new u({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJ3MlMjIlMkMlMjAoMyUyQyUyMDUpKSUyQyUyMCgnJUM0JUEwdGVzdCclMkMlMjAoNSUyQyUyMDEwKSklMkMlMjAoJyVDNCVBMHByZSclMkMlMjAoMTAlMkMlMjAxNCkpJTJDJTIwKCctJyUyQyUyMCgxNCUyQyUyMDE1KSklMkMlMEElMjAoJ3Rva2VuaXphdGlvbiclMkMlMjAoMTUlMkMlMjAyNykpJTJDJTIwKCchJyUyQyUyMCgyNyUyQyUyMDI4KSklNUQ=",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;s&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;Ġtest&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;Ġpre&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">15</span>)),
 (<span class="hljs-string">&#x27;tokenization&#x27;</span>, (<span class="hljs-number">15</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;!&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),pt=new u({props:{code:"dHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLkJwZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQpJTBBdG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`trainer = trainers.BpeTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=[<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>])
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),ct=new u({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLkJQRSgpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.BPE()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),mt=new u({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),yt=new u({props:{code:"JTVCJ0wnJTJDJTIwJ2V0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAnJUM0JUEwdGVzdCclMkMlMjAnJUM0JUEwdGhpcyclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2tlbiclMkMlMjAnaXplciclMkMlMjAnLiclNUQ=",highlighted:'[<span class="hljs-string">&#x27;L&#x27;</span>, <span class="hljs-string">&#x27;et&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;Ġtest&#x27;</span>, <span class="hljs-string">&#x27;Ġthis&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),ut=new u({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5CeXRlTGV2ZWwodHJpbV9vZmZzZXRzJTNERmFsc2Up",highlighted:'tokenizer.post_processor = processors.ByteLevel(trim_offsets=<span class="hljs-literal">False</span>)',wrap:!1}}),dt=new u({props:{code:"c2VudGVuY2UlMjAlM0QlMjAlMjJMZXQncyUyMHRlc3QlMjB0aGlzJTIwdG9rZW5pemVyLiUyMiUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyLmVuY29kZShzZW50ZW5jZSklMEFzdGFydCUyQyUyMGVuZCUyMCUzRCUyMGVuY29kaW5nLm9mZnNldHMlNUI0JTVEJTBBc2VudGVuY2UlNUJzdGFydCUzQWVuZCU1RA==",highlighted:`sentence = <span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>
encoding = tokenizer.encode(sentence)
start, end = encoding.offsets[<span class="hljs-number">4</span>]
sentence[start:end]`,wrap:!1}}),ft=new u({props:{code:"JyUyMHRlc3Qn",highlighted:'<span class="hljs-string">&#x27; test&#x27;</span>',wrap:!1}}),jt=new u({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5CeXRlTGV2ZWwoKQ==",highlighted:"tokenizer.decoder = decoders.ByteLevel()",wrap:!1}}),wt=new u({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),bt=new u({props:{code:"JTIyTGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4lMjI=",highlighted:'<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>',wrap:!1}}),gt=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwZW9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
)`,wrap:!1}}),xt=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2TokenizerFast

wrapped_tokenizer = GPT2TokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),It=new ys({props:{title:"Building a Unigram tokenizer from scratch",local:"building-a-unigram-tokenizer-from-scratch",headingTag:"h2"}}),vt=new u({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5VbmlncmFtKCkp",highlighted:"tokenizer = Tokenizer(models.Unigram())",wrap:!1}}),Wt=new u({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjBSZWdleCUwQSUwQXRva2VuaXplci5ub3JtYWxpemVyJTIwJTNEJTIwbm9ybWFsaXplcnMuU2VxdWVuY2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuUmVwbGFjZSglMjIlNjAlNjAlMjIlMkMlMjAnJTIyJyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKCUyMicnJTIyJTJDJTIwJyUyMicpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuTkZLRCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKFJlZ2V4KCUyMiUyMCU3QjIlMkMlN0QlMjIpJTJDJTIwJTIyJTIwJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> Regex

tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [
        normalizers.Replace(<span class="hljs-string">&quot;\`\`&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.Replace(<span class="hljs-string">&quot;&#x27;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.NFKD(),
        normalizers.StripAccents(),
        normalizers.Replace(Regex(<span class="hljs-string">&quot; {2,}&quot;</span>), <span class="hljs-string">&quot; &quot;</span>),
    ]
)`,wrap:!1}}),Qt=new u({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Metaspace()",wrap:!1}}),Rt=new u({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjB0aGUlMjBwcmUtdG9rZW5pemVyISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test the pre-tokenizer!&quot;</span>)',wrap:!1}}),Nt=new u({props:{code:"JTVCKCUyMiVFMiU5NiU4MUxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJyVFMiU5NiU4MXRlc3QnJTJDJTIwKDUlMkMlMjAxMCkpJTJDJTIwKCclRTIlOTYlODF0aGUnJTJDJTIwKDEwJTJDJTIwMTQpKSUyQyUyMCgnJUUyJTk2JTgxcHJlLXRva2VuaXplciEnJTJDJTIwKDE0JTJDJTIwMjkpKSU1RA==",highlighted:'[(<span class="hljs-string">&quot;▁Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;▁test&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;▁the&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;▁pre-tokenizer!&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">29</span>))]',wrap:!1}}),Gt=new u({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlM0NjbHMlM0UlMjIlMkMlMjAlMjIlM0NzZXAlM0UlMjIlMkMlMjAlMjIlM0N1bmslM0UlMjIlMkMlMjAlMjIlM0NwYWQlM0UlMjIlMkMlMjAlMjIlM0NtYXNrJTNFJTIyJTJDJTIwJTIyJTNDcyUzRSUyMiUyQyUyMCUyMiUzQyUyRnMlM0UlMjIlNUQlMEF0cmFpbmVyJTIwJTNEJTIwdHJhaW5lcnMuVW5pZ3JhbVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2VucyUyQyUyMHVua190b2tlbiUzRCUyMiUzQ3VuayUzRSUyMiUwQSklMEF0b2tlbml6ZXIudHJhaW5fZnJvbV9pdGVyYXRvcihnZXRfdHJhaW5pbmdfY29ycHVzKCklMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`special_tokens = [<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;s&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>]
trainer = trainers.UnigramTrainer(
    vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens, unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>
)
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),Ht=new u({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLlVuaWdyYW0oKSUwQXRva2VuaXplci50cmFpbiglNUIlMjJ3aWtpdGV4dC0yLnR4dCUyMiU1RCUyQyUyMHRyYWluZXIlM0R0cmFpbmVyKQ==",highlighted:`tokenizer.model = models.Unigram()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Et=new u({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),St=new u({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),Ft=new u({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiUzQ2NscyUzRSUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTNDc2VwJTNFJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),Yt=new u({props:{code:"MCUyMDE=",highlighted:'<span class="hljs-number">0</span> <span class="hljs-number">1</span>',wrap:!1}}),Ot=new u({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEJTIyJTI0QSUzQTAlMjAlM0NzZXAlM0UlM0EwJTIwJTNDY2xzJTNFJTNBMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhaXIlM0QlMjIlMjRBJTNBMCUyMCUzQ3NlcCUzRSUzQTAlMjAlMjRCJTNBMSUyMCUzQ3NlcCUzRSUzQTElMjAlM0NjbHMlM0UlM0EyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIoJTIyJTNDc2VwJTNFJTIyJTJDJTIwc2VwX3Rva2VuX2lkKSUyQyUyMCglMjIlM0NjbHMlM0UlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTVEJTJDJTBBKQ==",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 &lt;cls&gt;:2&quot;</span>,
    pair=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 $B:1 &lt;sep&gt;:1 &lt;cls&gt;:2&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, sep_token_id), (<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, cls_token_id)],
)`,wrap:!1}}),ts=new u({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMhJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences!&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),ss=new u({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdvbiclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdhJyUyQyUyMCclRTIlOTYlODFwYWlyJyUyQyUyMCUwQSUyMCUyMCclRTIlOTYlODFvZiclMkMlMjAnJUUyJTk2JTgxc2VudGVuY2UnJTJDJTIwJ3MnJTJDJTIwJyEnJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJTNDY2xzJTNFJyU1RCUwQSU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAyJTVE",highlighted:`[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;▁pair&#x27;</span>, 
  <span class="hljs-string">&#x27;▁of&#x27;</span>, <span class="hljs-string">&#x27;▁sentence&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;!&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;cls&gt;&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),ns=new u({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.decoder = decoders.Metaspace()",wrap:!1}}),is=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDcyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMGVvc190b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlM0N1bmslM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlM0NwYWQlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlM0NjbHMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlM0NzZXAlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTNDbWFzayUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;s&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>,
    unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>,
    pad_token=<span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>,
    cls_token=<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>,
    sep_token=<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>,
    mask_token=<span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>,
    padding_side=<span class="hljs-string">&quot;left&quot;</span>,
)`,wrap:!1}}),rs=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFhMTmV0VG9rZW5pemVyRmFzdCUwQSUwQXdyYXBwZWRfdG9rZW5pemVyJTIwJTNEJTIwWExOZXRUb2tlbml6ZXJGYXN0KHRva2VuaXplcl9vYmplY3QlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLNetTokenizerFast

wrapped_tokenizer = XLNetTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),cs=new Li({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter6/8.mdx"}}),{c(){J=i("meta"),j=n(),d=i("p"),Ms=n(),o(k.$$.fragment),us=n(),o(w.$$.fragment),Js=n(),o(b.$$.fragment),ds=n(),$=i("p"),$.textContent=ca,fs=n(),g=i("ul"),g.innerHTML=Ma,Ts=n(),U=i("p"),U.textContent=ma,js=n(),f=i("div"),f.innerHTML=ya,ks=n(),x=i("p"),x.innerHTML=ha,ws=n(),o(z.$$.fragment),bs=n(),I=i("p"),I.innerHTML=ua,$s=n(),C=i("ul"),C.innerHTML=Ja,gs=n(),v=i("p"),v.innerHTML=da,Us=n(),o(Z.$$.fragment),xs=n(),V=i("p"),V.innerHTML=fa,zs=n(),o(W.$$.fragment),Is=n(),B=i("p"),B.innerHTML=Ta,Cs=n(),_=i("p"),_.textContent=ja,vs=n(),o(Q.$$.fragment),Zs=n(),A=i("p"),A.textContent=ka,Vs=n(),o(R.$$.fragment),Ws=n(),N=i("p"),N.innerHTML=wa,Bs=n(),X=i("p"),X.innerHTML=ba,_s=n(),o(G.$$.fragment),Qs=n(),q=i("p"),q.innerHTML=$a,As=n(),L=i("p"),L.innerHTML=ga,Rs=n(),o(H.$$.fragment),Ns=n(),D=i("p"),D.innerHTML=Ua,Xs=n(),o(E.$$.fragment),Gs=n(),S=i("p"),S.innerHTML=xa,qs=n(),P=i("p"),P.innerHTML=za,Ls=n(),o(F.$$.fragment),Hs=n(),o(Y.$$.fragment),Ds=n(),o(T.$$.fragment),Es=n(),K=i("p"),K.innerHTML=Ia,Ss=n(),o(O.$$.fragment),Ps=n(),ee=i("p"),ee.textContent=Ca,Fs=n(),o(te.$$.fragment),Ys=n(),se=i("p"),se.innerHTML=va,Ks=n(),o(le.$$.fragment),Os=n(),o(ne.$$.fragment),el=n(),ae=i("p"),ae.innerHTML=Za,tl=n(),o(ie.$$.fragment),sl=n(),o(pe.$$.fragment),ll=n(),re=i("p"),re.innerHTML=Va,nl=n(),o(oe.$$.fragment),al=n(),o(ce.$$.fragment),il=n(),Me=i("p"),Me.innerHTML=Wa,pl=n(),o(me.$$.fragment),rl=n(),ye=i("p"),ye.innerHTML=Ba,ol=n(),he=i("p"),he.textContent=_a,cl=n(),o(ue.$$.fragment),Ml=n(),Je=i("p"),Je.innerHTML=Qa,ml=n(),o(de.$$.fragment),yl=n(),fe=i("p"),fe.innerHTML=Aa,hl=n(),o(Te.$$.fragment),ul=n(),o(je.$$.fragment),Jl=n(),ke=i("p"),ke.innerHTML=Ra,dl=n(),we=i("p"),we.innerHTML=Na,fl=n(),o(be.$$.fragment),Tl=n(),o($e.$$.fragment),jl=n(),ge=i("p"),ge.innerHTML=Xa,kl=n(),Ue=i("p"),Ue.textContent=Ga,wl=n(),o(xe.$$.fragment),bl=n(),ze=i("p"),ze.textContent=qa,$l=n(),Ie=i("p"),Ie.textContent=La,gl=n(),o(Ce.$$.fragment),Ul=n(),o(ve.$$.fragment),xl=n(),Ze=i("p"),Ze.textContent=Ha,zl=n(),o(Ve.$$.fragment),Il=n(),o(We.$$.fragment),Cl=n(),Be=i("p"),Be.textContent=Da,vl=n(),o(_e.$$.fragment),Zl=n(),Qe=i("p"),Qe.innerHTML=Ea,Vl=n(),o(Ae.$$.fragment),Wl=n(),o(Re.$$.fragment),Bl=n(),Ne=i("p"),Ne.textContent=Sa,_l=n(),o(Xe.$$.fragment),Ql=n(),Ge=i("p"),Ge.innerHTML=Pa,Al=n(),o(qe.$$.fragment),Rl=n(),Le=i("p"),Le.innerHTML=Fa,Nl=n(),He=i("p"),He.innerHTML=Ya,Xl=n(),o(De.$$.fragment),Gl=n(),Ee=i("p"),Ee.innerHTML=Ka,ql=n(),o(Se.$$.fragment),Ll=n(),Pe=i("p"),Pe.innerHTML=Oa,Hl=n(),Fe=i("p"),Fe.textContent=ei,Dl=n(),o(Ye.$$.fragment),El=n(),Ke=i("p"),Ke.innerHTML=ti,Sl=n(),o(Oe.$$.fragment),Pl=n(),et=i("p"),et.innerHTML=si,Fl=n(),tt=i("p"),tt.textContent=li,Yl=n(),o(st.$$.fragment),Kl=n(),lt=i("p"),lt.innerHTML=ni,Ol=n(),o(nt.$$.fragment),en=n(),o(at.$$.fragment),tn=n(),it=i("p"),it.textContent=ai,sn=n(),o(pt.$$.fragment),ln=n(),rt=i("p"),rt.innerHTML=ii,nn=n(),ot=i("p"),ot.textContent=pi,an=n(),o(ct.$$.fragment),pn=n(),Mt=i("p"),Mt.textContent=ri,rn=n(),o(mt.$$.fragment),on=n(),o(yt.$$.fragment),cn=n(),ht=i("p"),ht.textContent=oi,Mn=n(),o(ut.$$.fragment),mn=n(),Jt=i("p"),Jt.innerHTML=ci,yn=n(),o(dt.$$.fragment),hn=n(),o(ft.$$.fragment),un=n(),Tt=i("p"),Tt.textContent=Mi,Jn=n(),o(jt.$$.fragment),dn=n(),kt=i("p"),kt.textContent=mi,fn=n(),o(wt.$$.fragment),Tn=n(),o(bt.$$.fragment),jn=n(),$t=i("p"),$t.innerHTML=yi,kn=n(),o(gt.$$.fragment),wn=n(),Ut=i("p"),Ut.textContent=hi,bn=n(),o(xt.$$.fragment),$n=n(),zt=i("p"),zt.textContent=ui,gn=n(),o(It.$$.fragment),Un=n(),Ct=i("p"),Ct.innerHTML=Ji,xn=n(),o(vt.$$.fragment),zn=n(),Zt=i("p"),Zt.textContent=di,In=n(),Vt=i("p"),Vt.textContent=fi,Cn=n(),o(Wt.$$.fragment),vn=n(),Bt=i("p"),Bt.innerHTML=Ti,Zn=n(),_t=i("p"),_t.innerHTML=ji,Vn=n(),o(Qt.$$.fragment),Wn=n(),At=i("p"),At.textContent=ki,Bn=n(),o(Rt.$$.fragment),_n=n(),o(Nt.$$.fragment),Qn=n(),Xt=i("p"),Xt.textContent=wi,An=n(),o(Gt.$$.fragment),Rn=n(),qt=i("p"),qt.innerHTML=bi,Nn=n(),Lt=i("p"),Lt.textContent=$i,Xn=n(),o(Ht.$$.fragment),Gn=n(),Dt=i("p"),Dt.textContent=gi,qn=n(),o(Et.$$.fragment),Ln=n(),o(St.$$.fragment),Hn=n(),Pt=i("p"),Pt.innerHTML=Ui,Dn=n(),o(Ft.$$.fragment),En=n(),o(Yt.$$.fragment),Sn=n(),Kt=i("p"),Kt.textContent=xi,Pn=n(),o(Ot.$$.fragment),Fn=n(),es=i("p"),es.textContent=zi,Yn=n(),o(ts.$$.fragment),Kn=n(),o(ss.$$.fragment),On=n(),ls=i("p"),ls.innerHTML=Ii,ea=n(),o(ns.$$.fragment),ta=n(),as=i("p"),as.innerHTML=Ci,sa=n(),o(is.$$.fragment),la=n(),ps=i("p"),ps.textContent=vi,na=n(),o(rs.$$.fragment),aa=n(),os=i("p"),os.textContent=Zi,ia=n(),o(cs.$$.fragment),pa=n(),ms=i("p"),this.h()},l(e){const t=Ni("svelte-u9bgzb",document.head);J=p(t,"META",{name:!0,content:!0}),t.forEach(s),j=a(e),d=p(e,"P",{}),Wi(d).forEach(s),Ms=a(e),c(k.$$.fragment,e),us=a(e),c(w.$$.fragment,e),Js=a(e),c(b.$$.fragment,e),ds=a(e),$=p(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-3qwu2n"&&($.textContent=ca),fs=a(e),g=p(e,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-12vigqn"&&(g.innerHTML=Ma),Ts=a(e),U=p(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1msje3z"&&(U.textContent=ma),js=a(e),f=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(f)!=="svelte-oxfng3"&&(f.innerHTML=ya),ks=a(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-il604i"&&(x.innerHTML=ha),ws=a(e),c(z.$$.fragment,e),bs=a(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-3r1vi2"&&(I.innerHTML=ua),$s=a(e),C=p(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-fnf8g6"&&(C.innerHTML=Ja),gs=a(e),v=p(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-13r2p99"&&(v.innerHTML=da),Us=a(e),c(Z.$$.fragment,e),xs=a(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1njyr3z"&&(V.innerHTML=fa),zs=a(e),c(W.$$.fragment,e),Is=a(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-cmf9ti"&&(B.innerHTML=Ta),Cs=a(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1b40lyu"&&(_.textContent=ja),vs=a(e),c(Q.$$.fragment,e),Zs=a(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-14xvwqr"&&(A.textContent=ka),Vs=a(e),c(R.$$.fragment,e),Ws=a(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-kr34bb"&&(N.innerHTML=wa),Bs=a(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-ldh8kh"&&(X.innerHTML=ba),_s=a(e),c(G.$$.fragment,e),Qs=a(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-szj6vq"&&(q.innerHTML=$a),As=a(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-ch9g0x"&&(L.innerHTML=ga),Rs=a(e),c(H.$$.fragment,e),Ns=a(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-g661z7"&&(D.innerHTML=Ua),Xs=a(e),c(E.$$.fragment,e),Gs=a(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-sqrbhp"&&(S.innerHTML=xa),qs=a(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1ifl1uh"&&(P.innerHTML=za),Ls=a(e),c(F.$$.fragment,e),Hs=a(e),c(Y.$$.fragment,e),Ds=a(e),c(T.$$.fragment,e),Es=a(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1hzmz8v"&&(K.innerHTML=Ia),Ss=a(e),c(O.$$.fragment,e),Ps=a(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-5f2ppa"&&(ee.textContent=Ca),Fs=a(e),c(te.$$.fragment,e),Ys=a(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-17g5tkh"&&(se.innerHTML=va),Ks=a(e),c(le.$$.fragment,e),Os=a(e),c(ne.$$.fragment,e),el=a(e),ae=p(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1nzvxks"&&(ae.innerHTML=Za),tl=a(e),c(ie.$$.fragment,e),sl=a(e),c(pe.$$.fragment,e),ll=a(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-e8ls79"&&(re.innerHTML=Va),nl=a(e),c(oe.$$.fragment,e),al=a(e),c(ce.$$.fragment,e),il=a(e),Me=p(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1flaqiu"&&(Me.innerHTML=Wa),pl=a(e),c(me.$$.fragment,e),rl=a(e),ye=p(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-zfisnc"&&(ye.innerHTML=Ba),ol=a(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-fxwv2n"&&(he.textContent=_a),cl=a(e),c(ue.$$.fragment,e),Ml=a(e),Je=p(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-wisurr"&&(Je.innerHTML=Qa),ml=a(e),c(de.$$.fragment,e),yl=a(e),fe=p(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-132nejo"&&(fe.innerHTML=Aa),hl=a(e),c(Te.$$.fragment,e),ul=a(e),c(je.$$.fragment,e),Jl=a(e),ke=p(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-gj3rj2"&&(ke.innerHTML=Ra),dl=a(e),we=p(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1oy2o1b"&&(we.innerHTML=Na),fl=a(e),c(be.$$.fragment,e),Tl=a(e),c($e.$$.fragment,e),jl=a(e),ge=p(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-z3selt"&&(ge.innerHTML=Xa),kl=a(e),Ue=p(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-q1nzmh"&&(Ue.textContent=Ga),wl=a(e),c(xe.$$.fragment,e),bl=a(e),ze=p(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-14xkv0z"&&(ze.textContent=qa),$l=a(e),Ie=p(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1i25qf9"&&(Ie.textContent=La),gl=a(e),c(Ce.$$.fragment,e),Ul=a(e),c(ve.$$.fragment,e),xl=a(e),Ze=p(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-th6dsg"&&(Ze.textContent=Ha),zl=a(e),c(Ve.$$.fragment,e),Il=a(e),c(We.$$.fragment,e),Cl=a(e),Be=p(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-xbo1fy"&&(Be.textContent=Da),vl=a(e),c(_e.$$.fragment,e),Zl=a(e),Qe=p(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-10hc9jg"&&(Qe.innerHTML=Ea),Vl=a(e),c(Ae.$$.fragment,e),Wl=a(e),c(Re.$$.fragment,e),Bl=a(e),Ne=p(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-bx3ks1"&&(Ne.textContent=Sa),_l=a(e),c(Xe.$$.fragment,e),Ql=a(e),Ge=p(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1j80g7l"&&(Ge.innerHTML=Pa),Al=a(e),c(qe.$$.fragment,e),Rl=a(e),Le=p(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-138iql"&&(Le.innerHTML=Fa),Nl=a(e),He=p(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-k6u833"&&(He.innerHTML=Ya),Xl=a(e),c(De.$$.fragment,e),Gl=a(e),Ee=p(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1o14t6o"&&(Ee.innerHTML=Ka),ql=a(e),c(Se.$$.fragment,e),Ll=a(e),Pe=p(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1y1ppn4"&&(Pe.innerHTML=Oa),Hl=a(e),Fe=p(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-1w2ckw7"&&(Fe.textContent=ei),Dl=a(e),c(Ye.$$.fragment,e),El=a(e),Ke=p(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-16961ta"&&(Ke.innerHTML=ti),Sl=a(e),c(Oe.$$.fragment,e),Pl=a(e),et=p(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1bovaty"&&(et.innerHTML=si),Fl=a(e),tt=p(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1ezw1yn"&&(tt.textContent=li),Yl=a(e),c(st.$$.fragment,e),Kl=a(e),lt=p(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1bw3nt0"&&(lt.innerHTML=ni),Ol=a(e),c(nt.$$.fragment,e),en=a(e),c(at.$$.fragment,e),tn=a(e),it=p(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-7y4l0y"&&(it.textContent=ai),sn=a(e),c(pt.$$.fragment,e),ln=a(e),rt=p(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-bv31bn"&&(rt.innerHTML=ii),nn=a(e),ot=p(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-11ph16f"&&(ot.textContent=pi),an=a(e),c(ct.$$.fragment,e),pn=a(e),Mt=p(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1hgpn33"&&(Mt.textContent=ri),rn=a(e),c(mt.$$.fragment,e),on=a(e),c(yt.$$.fragment,e),cn=a(e),ht=p(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-n1vz05"&&(ht.textContent=oi),Mn=a(e),c(ut.$$.fragment,e),mn=a(e),Jt=p(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-ghzhch"&&(Jt.innerHTML=ci),yn=a(e),c(dt.$$.fragment,e),hn=a(e),c(ft.$$.fragment,e),un=a(e),Tt=p(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-1h8tvqm"&&(Tt.textContent=Mi),Jn=a(e),c(jt.$$.fragment,e),dn=a(e),kt=p(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-1507zp"&&(kt.textContent=mi),fn=a(e),c(wt.$$.fragment,e),Tn=a(e),c(bt.$$.fragment,e),jn=a(e),$t=p(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-1uknlc4"&&($t.innerHTML=yi),kn=a(e),c(gt.$$.fragment,e),wn=a(e),Ut=p(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-ylttvt"&&(Ut.textContent=hi),bn=a(e),c(xt.$$.fragment,e),$n=a(e),zt=p(e,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-1tk1zdg"&&(zt.textContent=ui),gn=a(e),c(It.$$.fragment,e),Un=a(e),Ct=p(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1lojr4m"&&(Ct.innerHTML=Ji),xn=a(e),c(vt.$$.fragment,e),zn=a(e),Zt=p(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-1g43fmt"&&(Zt.textContent=di),In=a(e),Vt=p(e,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-d9cfcx"&&(Vt.textContent=fi),Cn=a(e),c(Wt.$$.fragment,e),vn=a(e),Bt=p(e,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-qkvtqd"&&(Bt.innerHTML=Ti),Zn=a(e),_t=p(e,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-8x763t"&&(_t.innerHTML=ji),Vn=a(e),c(Qt.$$.fragment,e),Wn=a(e),At=p(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-1ejt7m0"&&(At.textContent=ki),Bn=a(e),c(Rt.$$.fragment,e),_n=a(e),c(Nt.$$.fragment,e),Qn=a(e),Xt=p(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-csrqog"&&(Xt.textContent=wi),An=a(e),c(Gt.$$.fragment,e),Rn=a(e),qt=p(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-11hh239"&&(qt.innerHTML=bi),Nn=a(e),Lt=p(e,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-11ph16f"&&(Lt.textContent=$i),Xn=a(e),c(Ht.$$.fragment,e),Gn=a(e),Dt=p(e,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-1hgpn33"&&(Dt.textContent=gi),qn=a(e),c(Et.$$.fragment,e),Ln=a(e),c(St.$$.fragment,e),Hn=a(e),Pt=p(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-kqa3ra"&&(Pt.innerHTML=Ui),Dn=a(e),c(Ft.$$.fragment,e),En=a(e),c(Yt.$$.fragment,e),Sn=a(e),Kt=p(e,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-1xkp6h4"&&(Kt.textContent=xi),Pn=a(e),c(Ot.$$.fragment,e),Fn=a(e),es=p(e,"P",{"data-svelte-h":!0}),r(es)!=="svelte-11ia5pa"&&(es.textContent=zi),Yn=a(e),c(ts.$$.fragment,e),Kn=a(e),c(ss.$$.fragment,e),On=a(e),ls=p(e,"P",{"data-svelte-h":!0}),r(ls)!=="svelte-16qaug1"&&(ls.innerHTML=Ii),ea=a(e),c(ns.$$.fragment,e),ta=a(e),as=p(e,"P",{"data-svelte-h":!0}),r(as)!=="svelte-1nk2cqv"&&(as.innerHTML=Ci),sa=a(e),c(is.$$.fragment,e),la=a(e),ps=p(e,"P",{"data-svelte-h":!0}),r(ps)!=="svelte-igjp7d"&&(ps.textContent=vi),na=a(e),c(rs.$$.fragment,e),aa=a(e),os=p(e,"P",{"data-svelte-h":!0}),r(os)!=="svelte-l5rkk1"&&(os.textContent=Zi),ia=a(e),c(cs.$$.fragment,e),pa=a(e),ms=p(e,"P",{}),Wi(ms).forEach(s),this.h()},h(){oa(J,"name","hf:doc:metadata"),oa(J,"content",Pi),oa(f,"class","flex justify-center")},m(e,t){Xi(document.head,J),l(e,j,t),l(e,d,t),l(e,Ms,t),M(k,e,t),l(e,us,t),M(w,e,t),l(e,Js,t),M(b,e,t),l(e,ds,t),l(e,$,t),l(e,fs,t),l(e,g,t),l(e,Ts,t),l(e,U,t),l(e,js,t),l(e,f,t),l(e,ks,t),l(e,x,t),l(e,ws,t),M(z,e,t),l(e,bs,t),l(e,I,t),l(e,$s,t),l(e,C,t),l(e,gs,t),l(e,v,t),l(e,Us,t),M(Z,e,t),l(e,xs,t),l(e,V,t),l(e,zs,t),M(W,e,t),l(e,Is,t),l(e,B,t),l(e,Cs,t),l(e,_,t),l(e,vs,t),M(Q,e,t),l(e,Zs,t),l(e,A,t),l(e,Vs,t),M(R,e,t),l(e,Ws,t),l(e,N,t),l(e,Bs,t),l(e,X,t),l(e,_s,t),M(G,e,t),l(e,Qs,t),l(e,q,t),l(e,As,t),l(e,L,t),l(e,Rs,t),M(H,e,t),l(e,Ns,t),l(e,D,t),l(e,Xs,t),M(E,e,t),l(e,Gs,t),l(e,S,t),l(e,qs,t),l(e,P,t),l(e,Ls,t),M(F,e,t),l(e,Hs,t),M(Y,e,t),l(e,Ds,t),M(T,e,t),l(e,Es,t),l(e,K,t),l(e,Ss,t),M(O,e,t),l(e,Ps,t),l(e,ee,t),l(e,Fs,t),M(te,e,t),l(e,Ys,t),l(e,se,t),l(e,Ks,t),M(le,e,t),l(e,Os,t),M(ne,e,t),l(e,el,t),l(e,ae,t),l(e,tl,t),M(ie,e,t),l(e,sl,t),M(pe,e,t),l(e,ll,t),l(e,re,t),l(e,nl,t),M(oe,e,t),l(e,al,t),M(ce,e,t),l(e,il,t),l(e,Me,t),l(e,pl,t),M(me,e,t),l(e,rl,t),l(e,ye,t),l(e,ol,t),l(e,he,t),l(e,cl,t),M(ue,e,t),l(e,Ml,t),l(e,Je,t),l(e,ml,t),M(de,e,t),l(e,yl,t),l(e,fe,t),l(e,hl,t),M(Te,e,t),l(e,ul,t),M(je,e,t),l(e,Jl,t),l(e,ke,t),l(e,dl,t),l(e,we,t),l(e,fl,t),M(be,e,t),l(e,Tl,t),M($e,e,t),l(e,jl,t),l(e,ge,t),l(e,kl,t),l(e,Ue,t),l(e,wl,t),M(xe,e,t),l(e,bl,t),l(e,ze,t),l(e,$l,t),l(e,Ie,t),l(e,gl,t),M(Ce,e,t),l(e,Ul,t),M(ve,e,t),l(e,xl,t),l(e,Ze,t),l(e,zl,t),M(Ve,e,t),l(e,Il,t),M(We,e,t),l(e,Cl,t),l(e,Be,t),l(e,vl,t),M(_e,e,t),l(e,Zl,t),l(e,Qe,t),l(e,Vl,t),M(Ae,e,t),l(e,Wl,t),M(Re,e,t),l(e,Bl,t),l(e,Ne,t),l(e,_l,t),M(Xe,e,t),l(e,Ql,t),l(e,Ge,t),l(e,Al,t),M(qe,e,t),l(e,Rl,t),l(e,Le,t),l(e,Nl,t),l(e,He,t),l(e,Xl,t),M(De,e,t),l(e,Gl,t),l(e,Ee,t),l(e,ql,t),M(Se,e,t),l(e,Ll,t),l(e,Pe,t),l(e,Hl,t),l(e,Fe,t),l(e,Dl,t),M(Ye,e,t),l(e,El,t),l(e,Ke,t),l(e,Sl,t),M(Oe,e,t),l(e,Pl,t),l(e,et,t),l(e,Fl,t),l(e,tt,t),l(e,Yl,t),M(st,e,t),l(e,Kl,t),l(e,lt,t),l(e,Ol,t),M(nt,e,t),l(e,en,t),M(at,e,t),l(e,tn,t),l(e,it,t),l(e,sn,t),M(pt,e,t),l(e,ln,t),l(e,rt,t),l(e,nn,t),l(e,ot,t),l(e,an,t),M(ct,e,t),l(e,pn,t),l(e,Mt,t),l(e,rn,t),M(mt,e,t),l(e,on,t),M(yt,e,t),l(e,cn,t),l(e,ht,t),l(e,Mn,t),M(ut,e,t),l(e,mn,t),l(e,Jt,t),l(e,yn,t),M(dt,e,t),l(e,hn,t),M(ft,e,t),l(e,un,t),l(e,Tt,t),l(e,Jn,t),M(jt,e,t),l(e,dn,t),l(e,kt,t),l(e,fn,t),M(wt,e,t),l(e,Tn,t),M(bt,e,t),l(e,jn,t),l(e,$t,t),l(e,kn,t),M(gt,e,t),l(e,wn,t),l(e,Ut,t),l(e,bn,t),M(xt,e,t),l(e,$n,t),l(e,zt,t),l(e,gn,t),M(It,e,t),l(e,Un,t),l(e,Ct,t),l(e,xn,t),M(vt,e,t),l(e,zn,t),l(e,Zt,t),l(e,In,t),l(e,Vt,t),l(e,Cn,t),M(Wt,e,t),l(e,vn,t),l(e,Bt,t),l(e,Zn,t),l(e,_t,t),l(e,Vn,t),M(Qt,e,t),l(e,Wn,t),l(e,At,t),l(e,Bn,t),M(Rt,e,t),l(e,_n,t),M(Nt,e,t),l(e,Qn,t),l(e,Xt,t),l(e,An,t),M(Gt,e,t),l(e,Rn,t),l(e,qt,t),l(e,Nn,t),l(e,Lt,t),l(e,Xn,t),M(Ht,e,t),l(e,Gn,t),l(e,Dt,t),l(e,qn,t),M(Et,e,t),l(e,Ln,t),M(St,e,t),l(e,Hn,t),l(e,Pt,t),l(e,Dn,t),M(Ft,e,t),l(e,En,t),M(Yt,e,t),l(e,Sn,t),l(e,Kt,t),l(e,Pn,t),M(Ot,e,t),l(e,Fn,t),l(e,es,t),l(e,Yn,t),M(ts,e,t),l(e,Kn,t),M(ss,e,t),l(e,On,t),l(e,ls,t),l(e,ea,t),M(ns,e,t),l(e,ta,t),l(e,as,t),l(e,sa,t),M(is,e,t),l(e,la,t),l(e,ps,t),l(e,na,t),M(rs,e,t),l(e,aa,t),l(e,os,t),l(e,ia,t),M(cs,e,t),l(e,pa,t),l(e,ms,t),ra=!0},p(e,[t]){const Vi={};t&2&&(Vi.$$scope={dirty:t,ctx:e}),T.$set(Vi)},i(e){ra||(m(k.$$.fragment,e),m(w.$$.fragment,e),m(b.$$.fragment,e),m(z.$$.fragment,e),m(Z.$$.fragment,e),m(W.$$.fragment,e),m(Q.$$.fragment,e),m(R.$$.fragment,e),m(G.$$.fragment,e),m(H.$$.fragment,e),m(E.$$.fragment,e),m(F.$$.fragment,e),m(Y.$$.fragment,e),m(T.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),m(oe.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(ue.$$.fragment,e),m(de.$$.fragment,e),m(Te.$$.fragment,e),m(je.$$.fragment,e),m(be.$$.fragment,e),m($e.$$.fragment,e),m(xe.$$.fragment,e),m(Ce.$$.fragment,e),m(ve.$$.fragment,e),m(Ve.$$.fragment,e),m(We.$$.fragment,e),m(_e.$$.fragment,e),m(Ae.$$.fragment,e),m(Re.$$.fragment,e),m(Xe.$$.fragment,e),m(qe.$$.fragment,e),m(De.$$.fragment,e),m(Se.$$.fragment,e),m(Ye.$$.fragment,e),m(Oe.$$.fragment,e),m(st.$$.fragment,e),m(nt.$$.fragment,e),m(at.$$.fragment,e),m(pt.$$.fragment,e),m(ct.$$.fragment,e),m(mt.$$.fragment,e),m(yt.$$.fragment,e),m(ut.$$.fragment,e),m(dt.$$.fragment,e),m(ft.$$.fragment,e),m(jt.$$.fragment,e),m(wt.$$.fragment,e),m(bt.$$.fragment,e),m(gt.$$.fragment,e),m(xt.$$.fragment,e),m(It.$$.fragment,e),m(vt.$$.fragment,e),m(Wt.$$.fragment,e),m(Qt.$$.fragment,e),m(Rt.$$.fragment,e),m(Nt.$$.fragment,e),m(Gt.$$.fragment,e),m(Ht.$$.fragment,e),m(Et.$$.fragment,e),m(St.$$.fragment,e),m(Ft.$$.fragment,e),m(Yt.$$.fragment,e),m(Ot.$$.fragment,e),m(ts.$$.fragment,e),m(ss.$$.fragment,e),m(ns.$$.fragment,e),m(is.$$.fragment,e),m(rs.$$.fragment,e),m(cs.$$.fragment,e),ra=!0)},o(e){y(k.$$.fragment,e),y(w.$$.fragment,e),y(b.$$.fragment,e),y(z.$$.fragment,e),y(Z.$$.fragment,e),y(W.$$.fragment,e),y(Q.$$.fragment,e),y(R.$$.fragment,e),y(G.$$.fragment,e),y(H.$$.fragment,e),y(E.$$.fragment,e),y(F.$$.fragment,e),y(Y.$$.fragment,e),y(T.$$.fragment,e),y(O.$$.fragment,e),y(te.$$.fragment,e),y(le.$$.fragment,e),y(ne.$$.fragment,e),y(ie.$$.fragment,e),y(pe.$$.fragment,e),y(oe.$$.fragment,e),y(ce.$$.fragment,e),y(me.$$.fragment,e),y(ue.$$.fragment,e),y(de.$$.fragment,e),y(Te.$$.fragment,e),y(je.$$.fragment,e),y(be.$$.fragment,e),y($e.$$.fragment,e),y(xe.$$.fragment,e),y(Ce.$$.fragment,e),y(ve.$$.fragment,e),y(Ve.$$.fragment,e),y(We.$$.fragment,e),y(_e.$$.fragment,e),y(Ae.$$.fragment,e),y(Re.$$.fragment,e),y(Xe.$$.fragment,e),y(qe.$$.fragment,e),y(De.$$.fragment,e),y(Se.$$.fragment,e),y(Ye.$$.fragment,e),y(Oe.$$.fragment,e),y(st.$$.fragment,e),y(nt.$$.fragment,e),y(at.$$.fragment,e),y(pt.$$.fragment,e),y(ct.$$.fragment,e),y(mt.$$.fragment,e),y(yt.$$.fragment,e),y(ut.$$.fragment,e),y(dt.$$.fragment,e),y(ft.$$.fragment,e),y(jt.$$.fragment,e),y(wt.$$.fragment,e),y(bt.$$.fragment,e),y(gt.$$.fragment,e),y(xt.$$.fragment,e),y(It.$$.fragment,e),y(vt.$$.fragment,e),y(Wt.$$.fragment,e),y(Qt.$$.fragment,e),y(Rt.$$.fragment,e),y(Nt.$$.fragment,e),y(Gt.$$.fragment,e),y(Ht.$$.fragment,e),y(Et.$$.fragment,e),y(St.$$.fragment,e),y(Ft.$$.fragment,e),y(Yt.$$.fragment,e),y(Ot.$$.fragment,e),y(ts.$$.fragment,e),y(ss.$$.fragment,e),y(ns.$$.fragment,e),y(is.$$.fragment,e),y(rs.$$.fragment,e),y(cs.$$.fragment,e),ra=!1},d(e){e&&(s(j),s(d),s(Ms),s(us),s(Js),s(ds),s($),s(fs),s(g),s(Ts),s(U),s(js),s(f),s(ks),s(x),s(ws),s(bs),s(I),s($s),s(C),s(gs),s(v),s(Us),s(xs),s(V),s(zs),s(Is),s(B),s(Cs),s(_),s(vs),s(Zs),s(A),s(Vs),s(Ws),s(N),s(Bs),s(X),s(_s),s(Qs),s(q),s(As),s(L),s(Rs),s(Ns),s(D),s(Xs),s(Gs),s(S),s(qs),s(P),s(Ls),s(Hs),s(Ds),s(Es),s(K),s(Ss),s(Ps),s(ee),s(Fs),s(Ys),s(se),s(Ks),s(Os),s(el),s(ae),s(tl),s(sl),s(ll),s(re),s(nl),s(al),s(il),s(Me),s(pl),s(rl),s(ye),s(ol),s(he),s(cl),s(Ml),s(Je),s(ml),s(yl),s(fe),s(hl),s(ul),s(Jl),s(ke),s(dl),s(we),s(fl),s(Tl),s(jl),s(ge),s(kl),s(Ue),s(wl),s(bl),s(ze),s($l),s(Ie),s(gl),s(Ul),s(xl),s(Ze),s(zl),s(Il),s(Cl),s(Be),s(vl),s(Zl),s(Qe),s(Vl),s(Wl),s(Bl),s(Ne),s(_l),s(Ql),s(Ge),s(Al),s(Rl),s(Le),s(Nl),s(He),s(Xl),s(Gl),s(Ee),s(ql),s(Ll),s(Pe),s(Hl),s(Fe),s(Dl),s(El),s(Ke),s(Sl),s(Pl),s(et),s(Fl),s(tt),s(Yl),s(Kl),s(lt),s(Ol),s(en),s(tn),s(it),s(sn),s(ln),s(rt),s(nn),s(ot),s(an),s(pn),s(Mt),s(rn),s(on),s(cn),s(ht),s(Mn),s(mn),s(Jt),s(yn),s(hn),s(un),s(Tt),s(Jn),s(dn),s(kt),s(fn),s(Tn),s(jn),s($t),s(kn),s(wn),s(Ut),s(bn),s($n),s(zt),s(gn),s(Un),s(Ct),s(xn),s(zn),s(Zt),s(In),s(Vt),s(Cn),s(vn),s(Bt),s(Zn),s(_t),s(Vn),s(Wn),s(At),s(Bn),s(_n),s(Qn),s(Xt),s(An),s(Rn),s(qt),s(Nn),s(Lt),s(Xn),s(Gn),s(Dt),s(qn),s(Ln),s(Hn),s(Pt),s(Dn),s(En),s(Sn),s(Kt),s(Pn),s(Fn),s(es),s(Yn),s(Kn),s(On),s(ls),s(ea),s(ta),s(as),s(sa),s(la),s(ps),s(na),s(aa),s(os),s(ia),s(pa),s(ms)),s(J),h(k,e),h(w,e),h(b,e),h(z,e),h(Z,e),h(W,e),h(Q,e),h(R,e),h(G,e),h(H,e),h(E,e),h(F,e),h(Y,e),h(T,e),h(O,e),h(te,e),h(le,e),h(ne,e),h(ie,e),h(pe,e),h(oe,e),h(ce,e),h(me,e),h(ue,e),h(de,e),h(Te,e),h(je,e),h(be,e),h($e,e),h(xe,e),h(Ce,e),h(ve,e),h(Ve,e),h(We,e),h(_e,e),h(Ae,e),h(Re,e),h(Xe,e),h(qe,e),h(De,e),h(Se,e),h(Ye,e),h(Oe,e),h(st,e),h(nt,e),h(at,e),h(pt,e),h(ct,e),h(mt,e),h(yt,e),h(ut,e),h(dt,e),h(ft,e),h(jt,e),h(wt,e),h(bt,e),h(gt,e),h(xt,e),h(It,e),h(vt,e),h(Wt,e),h(Qt,e),h(Rt,e),h(Nt,e),h(Gt,e),h(Ht,e),h(Et,e),h(St,e),h(Ft,e),h(Yt,e),h(Ot,e),h(ts,e),h(ss,e),h(ns,e),h(is,e),h(rs,e),h(cs,e)}}}const Pi='{"title":"Building a tokenizer, block by block","local":"building-a-tokenizer-block-by-block","sections":[{"title":"Acquiring a corpus","local":"acquiring-a-corpus","sections":[],"depth":2},{"title":"Building a WordPiece tokenizer from scratch","local":"building-a-wordpiece-tokenizer-from-scratch","sections":[],"depth":2},{"title":"Building a BPE tokenizer from scratch","local":"building-a-bpe-tokenizer-from-scratch","sections":[],"depth":2},{"title":"Building a Unigram tokenizer from scratch","local":"building-a-unigram-tokenizer-from-scratch","sections":[],"depth":2}],"depth":1}';function Fi(hs){return _i(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class np extends Ai{constructor(J){super(),Ri(this,J,Fi,Si,Bi,{})}}export{np as component};
