import{s as or,o as pr,n as Tl}from"../chunks/scheduler.cc52f4b9.js";import{S as hr,i as mr,e as i,s as a,c as p,h as Mr,a as r,d as l,b as n,f as ir,g as h,j as o,k as rr,l as dr,m as s,n as m,t as M,o as d,p as u}from"../chunks/index.5b747fde.js";import{T as jl}from"../chunks/Tip.f0925d57.js";import{C as ur,H as j,E as cr}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d38ac5a9.js";import{Y as yr}from"../chunks/Youtube.8bb4154e.js";import{C as y}from"../chunks/CodeBlock.665bfc37.js";import{C as wr}from"../chunks/CourseFloatingBanner.b33fcd79.js";import{F as Jr}from"../chunks/FrameworkSwitchCourse.b3b657b3.js";function br(f){let c,J="✏️ <strong>Your turn!</strong> Check that everything seems correct with the second element of the training dataset.";return{c(){c=i("p"),c.innerHTML=J},l(w){c=r(w,"P",{"data-svelte-h":!0}),o(c)!=="svelte-f3t9l4"&&(c.innerHTML=J)},m(w,b){s(w,c,b)},p:Tl,d(w){w&&l(c)}}}function fr(f){let c,J="In the next part of the course, we’ll look at more advanced techniques that can help you reduce your memory footprint and let you fine-tune the biggest models.";return{c(){c=i("p"),c.textContent=J},l(w){c=r(w,"P",{"data-svelte-h":!0}),o(c)!=="svelte-9j5678"&&(c.textContent=J)},m(w,b){s(w,c,b)},p:Tl,d(w){w&&l(c)}}}function jr(f){let c,J="💡 You should always make sure you can run <code>trainer.evaluate()</code> before launching <code>trainer.train()</code>, to avoid wasting lots of compute resources before hitting an error.";return{c(){c=i("p"),c.innerHTML=J},l(w){c=r(w,"P",{"data-svelte-h":!0}),o(c)!=="svelte-g6yrru"&&(c.innerHTML=J)},m(w,b){s(w,c,b)},p:Tl,d(w){w&&l(c)}}}function Tr(f){let c,J="💡 If you’re using a manual training loop, the same steps apply to debug your training pipeline, but it’s easier to separate them. Make sure you have not forgotten the <code>model.eval()</code> or <code>model.train()</code> at the right places, or the <code>zero_grad()</code> at each step, however!";return{c(){c=i("p"),c.innerHTML=J},l(w){c=r(w,"P",{"data-svelte-h":!0}),o(c)!=="svelte-nq8rs"&&(c.innerHTML=J)},m(w,b){s(w,c,b)},p:Tl,d(w){w&&l(c)}}}function Ur(f){let c,J="⚠️ If you are doing distributed training, print samples of your dataset in each process and triple-check that you get the same thing. One common bug is to have some source of randomness in the data creation that makes each process have a different version of the dataset.";return{c(){c=i("p"),c.textContent=J},l(w){c=r(w,"P",{"data-svelte-h":!0}),o(c)!=="svelte-19nz6fs"&&(c.textContent=J)},m(w,b){s(w,c,b)},p:Tl,d(w){w&&l(c)}}}function gr(f){let c,J="💡 If your training data is unbalanced, make sure to build a batch of training data containing all the labels.";return{c(){c=i("p"),c.textContent=J},l(w){c=r(w,"P",{"data-svelte-h":!0}),o(c)!=="svelte-ye7yyo"&&(c.textContent=J)},m(w,b){s(w,c,b)},p:Tl,d(w){w&&l(c)}}}function $r(f){let c,J="⚠️ You will have to recreate your model and your <code>Trainer</code> after this test, as the model obtained probably won’t be able to recover and learn something useful on your full dataset.";return{c(){c=i("p"),c.innerHTML=J},l(w){c=r(w,"P",{"data-svelte-h":!0}),o(c)!=="svelte-nhw6g4"&&(c.innerHTML=J)},m(w,b){s(w,c,b)},p:Tl,d(w){w&&l(c)}}}function kr(f){let c,J,w,b,T,gl,v,$l,B,kl,W,Cl,X,$n='You’ve written a beautiful script to train or fine-tune a model on a given task, dutifully following the advice from <a href="/course/chapter7">Chapter 7</a>. But when you launch the command <code>trainer.train()</code>, something horrible happens: you get an error 😱! Or worse, everything seems to be fine and the training runs without error, but the resulting model is crappy. In this section, we will show you what you can do to debug these kinds of issues.',Zl,R,Il,G,vl,x,kn="The problem when you encounter an error in <code>trainer.train()</code> is that it could come from multiple sources, as the <code>Trainer</code> usually puts together lots of things. It converts datasets to dataloaders, so the problem could be something wrong in your dataset, or some issue when trying to batch elements of the datasets together. Then it takes a batch of data and feeds it to the model, so the problem could be in the model code. After that, it computes the gradients and performs the optimization step, so the problem could also be in your optimizer. And even if everything goes well for training, something could still go wrong during the evaluation if there is a problem with your metric.",Bl,V,Cn="The best way to debug an error that arises in <code>trainer.train()</code> is to manually go through this whole pipeline to see where things went awry. The error is then often very easy to solve.",Wl,_,Zn='To demonstrate this, we will use the following script that (tries to) fine-tune a DistilBERT model on the <a href="https://huggingface.co/datasets/glue" rel="nofollow">MNLI dataset</a>:',Xl,Y,Rl,A,In="If you try to execute it, you will be met with a rather cryptic error:",Gl,F,xl,z,Vl,H,vn="This goes without saying, but if your data is corrupted, the <code>Trainer</code> is not going to be able to form batches, let alone train your model. So first things first, you need to have a look at what is inside your training set.",_l,Q,Bn="To avoid countless hours spent trying to fix something that is not the source of the bug, we recommend you use <code>trainer.train_dataset</code> for your checks and nothing else. So let’s do that here:",Yl,N,Al,E,Fl,S,Wn="Do you notice something wrong? This, in conjunction with the error message about <code>input_ids</code> missing, should make you realize those are texts, not numbers the model can make sense of. Here, the original error is very misleading because the <code>Trainer</code> automatically removes the columns that don’t match the model signature (that is, the arguments expected by the model). That means here, everything apart from the labels was discarded. There was thus no issue with creating batches and then sending them to the model, which in turn complained it didn’t receive the proper input.",zl,q,Xn="Why wasn’t the data processed? We did use the <code>Dataset.map()</code> method on the datasets to apply the tokenizer on each sample. But if you look closely at the code, you will see that we made a mistake when passing the training and evaluation sets to the <code>Trainer</code>. Instead of using <code>tokenized_datasets</code> here, we used <code>raw_datasets</code> 🤦. So let’s fix this!",Hl,L,Ql,D,Rn="This new code will now give a different error (progress!):",Nl,P,El,K,Gn="Looking at the traceback, we can see the error happens in the data collation step:",Sl,O,ql,ee,xn="So, we should move to that. Before we do, however, let’s finish inspecting our data, just to be 100% sure it’s correct.",Ll,te,Vn="One thing you should always do when debugging a training session is have a look at the decoded inputs of your model. We can’t make sense of the numbers that we feed it directly, so we should look at what those numbers represent. In computer vision, for example, that means looking at the decoded pictures of the pixels you pass, in speech it means listening to the decoded audio samples, and for our NLP example here it means using our tokenizer to decode the inputs:",Dl,le,Pl,se,Kl,ae,_n="So that seems correct. You should do this for all the keys in the inputs:",Ol,ne,es,ie,ts,re,Yn="Note that the keys that don’t correspond to inputs accepted by the model will be automatically discarded, so here we will only keep <code>input_ids</code>, <code>attention_mask</code>, and <code>label</code> (which will be renamed <code>labels</code>). To double-check the model signature, you can print the class of your model, then go check its documentation:",ls,oe,ss,pe,as,he,An='So in our case, we can check the parameters accepted on <a href="https://huggingface.co/transformers/model_doc/distilbert.html#distilbertforsequenceclassification" rel="nofollow">this page</a>. The <code>Trainer</code> will also log the columns it’s discarding.',ns,me,Fn="We have checked that the input IDs are correct by decoding them. Next is the <code>attention_mask</code>:",is,Me,rs,de,os,ue,zn="Since we didn’t apply padding in our preprocessing, this seems perfectly natural. To be sure there is no issue with that attention mask, let’s check it is the same length as our input IDs:",ps,ce,hs,ye,ms,we,Hn="That’s good! Lastly, let’s check our label:",Ms,Je,ds,be,us,fe,Qn="Like the input IDs, this is a number that doesn’t really make sense on its own. As we saw before, the map between integers and label names is stored inside the <code>names</code> attribute of the corresponding <em>feature</em> of the dataset:",cs,je,ys,Te,ws,Ue,Nn="So <code>1</code> means <code>neutral</code>, which means the two sentences we saw above are not in contradiction, and the first one does not imply the second one. That seems correct!",Js,ge,En="We don’t have token type IDs here, since DistilBERT does not expect them; if you have some in your model, you should also make sure that they properly match where the first and second sentences are in the input.",bs,U,fs,$e,Sn="We are only doing the check on the training set here, but you should of course double-check the validation and test sets the same way.",js,ke,qn="Now that we know our datasets look good, it’s time to check the next step of the training pipeline.",Ts,Ce,Us,Ze,Ln="The next thing that can go wrong in the training pipeline is when the <code>Trainer</code> tries to form batches from the training or validation set. Once you are sure the <code>Trainer</code>’s datasets are correct, you can try to manually form a batch by executing the following (replace <code>train</code> with <code>eval</code> for the validation dataloader):",gs,Ie,$s,ve,Dn="This code creates the training dataloader, then iterates through it, stopping at the first iteration. If the code executes without error, you have the first training batch that you can inspect, and if the code errors out, you know for sure the problem is in the dataloader, as is the case here:",ks,Be,Cs,We,Pn="Inspecting the last frame of the traceback should be enough to give you a clue, but let’s do a bit more digging. Most of the problems during batch creation arise because of the collation of examples into a single batch, so the first thing to check when in doubt is what <code>collate_fn</code> your <code>DataLoader</code> is using:",Zs,Xe,Is,Re,vs,Ge,Kn="So this is the <code>default_data_collator</code>, but that’s not what we want in this case. We want to pad our examples to the longest sentence in the batch, which is done by the <code>DataCollatorWithPadding</code> collator. And this data collator is supposed to be used by default by the <code>Trainer</code>, so why is it not used here?",Bs,xe,On="The answer is because we did not pass the <code>tokenizer</code> to the <code>Trainer</code>, so it couldn’t create the <code>DataCollatorWithPadding</code> we want. In practice, you should never hesitate to explicitly pass along the data collator you want to use, to make sure you avoid these kinds of errors. Let’s adapt our code to do exactly that:",Ws,Ve,Xs,_e,ei="The good news? We don’t get the same error as before, which is definitely progress. The bad news? We get an infamous CUDA error instead:",Rs,Ye,Gs,Ae,ti="This is bad because CUDA errors are extremely hard to debug in general. We will see in a minute how to solve this, but first let’s finish our analysis of batch creation.",xs,Fe,li="If you are sure your data collator is the right one, you should try to apply it on a couple of samples of your dataset:",Vs,ze,_s,He,si="This code will fail because the <code>train_dataset</code> contains string columns, which the <code>Trainer</code> usually removes. You can remove them manually, or if you want to replicate exactly what the <code>Trainer</code> is doing behind the scenes, you can call the private <code>Trainer._remove_unused_columns()</code> method that does that:",Ys,Qe,As,Ne,ai="You should then be able to manually debug what happens inside the data collator if the error persists.",Fs,Ee,ni="Now that we’ve debugged the batch creation process, it’s time to pass one through the model!",zs,Se,Hs,qe,ii="You should be able to get a batch by executing the following command:",Qs,Le,Ns,De,ri="If you’re running this code in a notebook, you may get a CUDA error that’s similar to the one we saw earlier, in which case you need to restart your notebook and reexecute the last snippet without the <code>trainer.train()</code> line. That’s the second most annoying thing about CUDA errors: they irremediably break your kernel. The most annoying thing about them is the fact that they are hard to debug.",Es,Pe,oi="Why is that? It has to do with the way GPUs work. They are extremely efficient at executing a lot of operations in parallel, but the drawback is that when one of those instructions results in an error, you don’t know it instantly. It’s only when the program calls a synchronization of the multiple processes on the GPU that it will realize something went wrong, so the error is actually raised at a place that has nothing to do with what created it. For instance, if we look at our previous traceback, the error was raised during the backward pass, but we will see in a minute that it actually stems from something in the forward pass.",Ss,Ke,pi="So how do we debug those errors? The answer is easy: we don’t. Unless your CUDA error is an out-of-memory error (which means there is not enough memory in your GPU), you should always go back to the CPU to debug it.",qs,Oe,hi="To do this in our case, we just have to put the model back on the CPU and call it on our batch — the batch returned by the <code>DataLoader</code> has not been moved to the GPU yet:",Ls,et,Ds,tt,Ps,lt,mi="So, the picture is getting clearer. Instead of having a CUDA error, we now have an <code>IndexError</code> in the loss computation (so nothing to do with the backward pass, as we said earlier). More precisely, we can see that it’s target 2 that creates the error, so this is a very good moment to check the number of labels of our model:",Ks,st,Os,at,ea,nt,Mi="With two labels, only 0s and 1s are allowed as targets, but according to the error message we got a 2. Getting a 2 is actually normal: if we remember the label names we extracted earlier, there were three, so we have indices 0, 1, and 2 in our dataset. The problem is that we didn’t tell that to our model, which should have been created with three labels. So let’s fix that!",ta,it,la,rt,di="We aren’t including the <code>trainer.train()</code> line yet, to take the time to check that everything looks good. If we request a batch and pass it to our model, it now works without error!",sa,ot,aa,pt,ui="The next step is then to move back to the GPU and check that everything still works:",na,ht,ia,mt,ci="If you still get an error, make sure you restart your notebook and only execute the last version of the script.",ra,Mt,oa,dt,yi="Now that we know that we can build batches that actually go through the model, we are ready for the next step of the training pipeline: computing the gradients and performing an optimization step.",pa,ut,wi="The first part is just a matter of calling the <code>backward()</code> method on the loss:",ha,ct,ma,yt,Ji="It’s pretty rare to get an error at this stage, but if you do get one, make sure to go back to the CPU to get a helpful error message.",Ma,wt,bi="To perform the optimization step, we just need to create the <code>optimizer</code> and call its <code>step()</code> method:",da,Jt,ua,bt,fi="Again, if you’re using the default optimizer in the <code>Trainer</code>, you shouldn’t get an error at this stage, but if you have a custom optimizer, there might be some problems to debug here. Don’t forget to go back to the CPU if you get a weird CUDA error at this stage. Speaking of CUDA errors, earlier we mentioned a special case. Let’s have a look at that now.",ca,ft,ya,jt,ji="Whenever you get an error message that starts with <code>RuntimeError: CUDA out of memory</code>, this indicates that you are out of GPU memory. This is not directly linked to your code, and it can happen with a script that runs perfectly fine. This error means that you tried to put too many things in the internal memory of your GPU, and that resulted in an error. Like with other CUDA errors, you will need to restart your kernel to be in a spot where you can run your training again.",wa,Tt,Ti="To solve this issue, you just need to use less GPU space — something that is often easier said than done. First, make sure you don’t have two models on the GPU at the same time (unless that’s required for your problem, of course). Then, you should probably reduce your batch size, as it directly affects the sizes of all the intermediate outputs of the model and their gradients. If the problem persists, consider using a smaller version of your model.",Ja,g,ba,Ut,fa,gt,Ui="Now that we’ve solved all the issues with our code, everything is perfect and the training should run smoothly, right? Not so fast! If you run the <code>trainer.train()</code> command, everything will look good at first, but after a while you will get the following:",ja,$t,Ta,kt,Ua,Ct,gi="You will realize this error appears during the evaluation phase, so this is the last thing we will need to debug.",ga,Zt,$i="You can run the evaluation loop of the <code>Trainer</code> independently form the training like this:",$a,It,ka,vt,Ca,$,Za,Bt,ki="Before attempting to debug a problem in the evaluation loop, you should first make sure that you’ve had a look at the data, are able to form a batch properly, and can run your model on it. We’ve completed all of those steps, so the following code can be executed without error:",Ia,Wt,va,Xt,Ci="The error comes later, at the end of the evaluation phase, and if we look at the traceback we see this:",Ba,Rt,Wa,Gt,Zi="This tells us that the error originates in the <code>datasets/metric.py</code> module — so this is a problem with our <code>compute_metrics()</code> function. It takes a tuple with the logits and the labels as NumPy arrays, so let’s try to feed it that:",Xa,xt,Ra,Vt,Ga,_t,Ii="We get the same error, so the problem definitely lies with that function. If we look back at its code, we see it’s just forwarding the <code>predictions</code> and the <code>labels</code> to <code>metric.compute()</code>. So is there a problem with that method? Not really. Let’s have a quick look at the shapes:",xa,Yt,Va,At,_a,Ft,vi="Our predictions are still logits, not the actual predictions, which is why the metric is returning this (somewhat obscure) error. The fix is pretty easy; we just have to add an argmax in the <code>compute_metrics()</code> function:",Ya,zt,Aa,Ht,Fa,Qt,Bi="Now our error is fixed! This was the last one, so our script will now train a model properly.",za,Nt,Wi="For reference, here is the completely fixed script:",Ha,Et,Qa,St,Xi="In this instance, there are no more problems, and our script will fine-tune a model that should give reasonable results. But what can we do when the training proceeds without any error, and the model trained does not perform well at all? That’s the hardest part of machine learning, and we’ll show you a few techniques that can help.",Na,k,Ea,qt,Sa,Lt,Ri="What can we do to debug a training that completes without error but doesn’t get good results? We’ll give you some pointers here, but be aware that this kind of debugging is the hardest part of machine learning, and there is no magical answer.",qa,Dt,La,Pt,Gi="Your model will only learn something if it’s actually possible to learn anything from your data. If there is a bug that corrupts the data or the labels are attributed randomly, it’s very likely you won’t get any model training on your dataset. So always start by double-checking your decoded inputs and labels, and ask yourself the following questions:",Da,Kt,xi="<li>Is the decoded data understandable?</li> <li>Do you agree with the labels?</li> <li>Is there one label that’s more common than the others?</li> <li>What should the loss/metric be if the model predicted a random answer/always the same answer?</li>",Pa,C,Ka,Ot,Vi="After looking at your data, go through a few of the model’s predictions and decode them too. If the model is always predicting the same thing, it might be because your dataset is biased toward one category (for classification problems); techniques like oversampling rare classes might help.",Oa,el,_i="If the loss/metric you get on your initial model is very different from the loss/metric you would expect for random predictions, double-check the way your loss or metric is computed, as there is probably a bug there. If you are using several losses that you add at the end, make sure they are of the same scale.",en,tl,Yi="When you are sure your data is perfect, you can see if the model is capable of training on it with one simple test.",tn,ll,ln,sl,Ai="Overfitting is usually something we try to avoid when training, as it means the model is not learning to recognize the general features we want it to but is instead just memorizing the training samples. However, trying to train your model on one batch over and over again is a good test to check if the problem as you framed it can be solved by the model you are attempting to train. It will also help you see if your initial learning rate is too high.",sn,al,Fi="Doing this once you have defined your <code>Trainer</code> is really easy; just grab a batch of training data, then run a small manual training loop only using that batch for something like 20 steps:",an,nl,nn,Z,rn,il,zi="The resulting model should have close-to-perfect results on the same <code>batch</code>. Let’s compute the metric on the resulting predictions:",on,rl,pn,ol,hn,pl,Hi="100% accuracy, now this is a nice example of overfitting (meaning that if you try your model on any other sentence, it will very likely give you a wrong answer)!",mn,hl,Qi="If you don’t manage to have your model obtain perfect results like this, it means there is something wrong with the way you framed the problem or your data, so you should fix that. Only when you manage to pass the overfitting test can you be sure that your model can actually learn something.",Mn,I,dn,ml,un,Ml,Ni="Hyperparameter tuning is always emphasized as being the hardest part of machine learning, but it’s just the last step to help you gain a little bit on the metric. Most of the time, the default hyperparameters of the <code>Trainer</code> will work just fine to give you good results, so don’t launch into a time-consuming and costly hyperparameter search until you have something that beats the baseline you have on your dataset.",cn,dl,Ei="Once you have a good enough model, you can start tweaking a bit. Don’t try launching a thousand runs with different hyperparameters, but compare a couple of runs with different values for one hyperparameter to get an idea of which has the greatest impact.",yn,ul,Si="If you are tweaking the model itself, keep it simple and don’t try anything you can’t reasonably justify. Always make sure you go back to the overfitting test to verify that your change hasn’t had any unintended consequences.",wn,cl,Jn,yl,qi='Hopefully you will have found some advice in this section that helped you solve your issue, but if that’s not the case, remember you can always ask the community on the <a href="https://discuss.huggingface.co/" rel="nofollow">forums</a>.',bn,wl,Li="Here are some additional resources that may prove helpful:",fn,Jl,Di='<li><a href="https://docs.google.com/presentation/d/1yHLPvPhUs2KGI5ZWo0sU-PKU3GimAk3iTsI38Z-B5Gw/edit#slide=id.p" rel="nofollow">“Reproducibility as a vehicle for engineering best practices”</a> by Joel Grus</li> <li><a href="https://towardsdatascience.com/checklist-for-debugging-neural-networks-d8b2a9434f21" rel="nofollow">“Checklist for debugging neural networks”</a> by Cecelia Shao</li> <li><a href="https://medium.com/@keeper6928/how-to-unit-test-machine-learning-code-57cf6fd81765" rel="nofollow">“How to unit test machine learning code”</a> by Chase Roberts</li> <li><a href="http://karpathy.github.io/2019/04/25/recipe/" rel="nofollow">“A Recipe for Training Neural Networks”</a> by Andrej Karpathy</li>',jn,bl,Pi="Of course, not every problem you encounter when training neural nets is your own fault! If you encounter something in the 🤗 Transformers or 🤗 Datasets library that does not seem right, you may have encountered a bug. You should definitely tell us all about it, and in the next section we’ll explain exactly how to do that.",Tn,fl,Un,Ul,gn;return T=new Jr({props:{fw:f[0]}}),v=new ur({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),B=new j({props:{title:"Debugging the training pipeline",local:"debugging-the-training-pipeline",headingTag:"h1"}}),W=new wr({props:{chapter:8,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter8/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter8/section4.ipynb"}]}}),R=new j({props:{title:"Debugging the training pipeline",local:"debugging-the-training-pipeline",headingTag:"h2"}}),G=new yr({props:{id:"L-WSwUWde1U"}}),Y=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


trainer = Trainer(
    model,
    args,
    train_dataset=raw_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=raw_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
)
trainer.train()`,wrap:!1}}),F=new y({props:{code:"J1ZhbHVlRXJyb3IlM0ElMjBZb3UlMjBoYXZlJTIwdG8lMjBzcGVjaWZ5JTIwZWl0aGVyJTIwaW5wdXRfaWRzJTIwb3IlMjBpbnB1dHNfZW1iZWRzJw==",highlighted:'<span class="hljs-string">&#x27;ValueError: You have to specify either input_ids or inputs_embeds&#x27;</span>',wrap:!1}}),z=new j({props:{title:"Check your data",local:"check-your-data",headingTag:"h3"}}),N=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RA==",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>]',wrap:!1}}),E=new y({props:{code:"JTdCJ2h5cG90aGVzaXMnJTNBJTIwJ1Byb2R1Y3QlMjBhbmQlMjBnZW9ncmFwaHklMjBhcmUlMjB3aGF0JTIwbWFrZSUyMGNyZWFtJTIwc2tpbW1pbmclMjB3b3JrLiUyMCclMkMlMEElMjAnaWR4JyUzQSUyMDAlMkMlMEElMjAnbGFiZWwnJTNBJTIwMSUyQyUwQSUyMCdwcmVtaXNlJyUzQSUyMCdDb25jZXB0dWFsbHklMjBjcmVhbSUyMHNraW1taW5nJTIwaGFzJTIwdHdvJTIwYmFzaWMlMjBkaW1lbnNpb25zJTIwLSUyMHByb2R1Y3QlMjBhbmQlMjBnZW9ncmFwaHkuJyU3RA==",highlighted:`{<span class="hljs-string">&#x27;hypothesis&#x27;</span>: <span class="hljs-string">&#x27;Product and geography are what make cream skimming work. &#x27;</span>,
 <span class="hljs-string">&#x27;idx&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
 <span class="hljs-string">&#x27;premise&#x27;</span>: <span class="hljs-string">&#x27;Conceptually cream skimming has two basic dimensions - product and geography.&#x27;</span>}`,wrap:!1}}),L=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
)
trainer.train()`,wrap:!1}}),P=new y({props:{code:"J1ZhbHVlRXJyb3IlM0ElMjBleHBlY3RlZCUyMHNlcXVlbmNlJTIwb2YlMjBsZW5ndGglMjA0MyUyMGF0JTIwZGltJTIwMSUyMChnb3QlMjAzNykn",highlighted:'<span class="hljs-string">&#x27;ValueError: expected sequence of length 43 at dim 1 (got 37)&#x27;</span>',wrap:!1}}),O=new y({props:{code:"fiUyRmdpdCUyRnRyYW5zZm9ybWVycyUyRnNyYyUyRnRyYW5zZm9ybWVycyUyRmRhdGElMkZkYXRhX2NvbGxhdG9yLnB5JTIwaW4lMjB0b3JjaF9kZWZhdWx0X2RhdGFfY29sbGF0b3IoZmVhdHVyZXMpJTBBJTIwJTIwJTIwJTIwMTA1JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glNUJrJTVEJTIwJTNEJTIwdG9yY2guc3RhY2soJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBLS0lM0UlMjAxMDclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QmslNUQlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDglMjAlMEElMjAlMjAlMjAlMjAxMDklMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaA==",highlighted:`~/git/transformers/src/transformers/data/data_collator.py <span class="hljs-keyword">in</span> torch_default_data_collator(features)
    <span class="hljs-number">105</span>                 batch[k] = torch.stack([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">106</span>             <span class="hljs-keyword">else</span>:
--&gt; <span class="hljs-number">107</span>                 batch[k] = torch.tensor([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">108</span> 
    <span class="hljs-number">109</span>     <span class="hljs-keyword">return</span> batch`,wrap:!1}}),le=new y({props:{code:"dG9rZW5pemVyLmRlY29kZSh0cmFpbmVyLnRyYWluX2RhdGFzZXQlNUIwJTVEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKQ==",highlighted:'tokenizer.decode(trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;input_ids&quot;</span>])',wrap:!1}}),se=new y({props:{code:"JyU1QkNMUyU1RCUyMGNvbmNlcHR1YWxseSUyMGNyZWFtJTIwc2tpbW1pbmclMjBoYXMlMjB0d28lMjBiYXNpYyUyMGRpbWVuc2lvbnMlMjAtJTIwcHJvZHVjdCUyMGFuZCUyMGdlb2dyYXBoeS4lMjAlNUJTRVAlNUQlMjBwcm9kdWN0JTIwYW5kJTIwZ2VvZ3JhcGh5JTIwYXJlJTIwd2hhdCUyMG1ha2UlMjBjcmVhbSUyMHNraW1taW5nJTIwd29yay4lMjAlNUJTRVAlNUQn",highlighted:'<span class="hljs-string">&#x27;[CLS] conceptually cream skimming has two basic dimensions - product and geography. [SEP] product and geography are what make cream skimming work. [SEP]&#x27;</span>',wrap:!1}}),ne=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RC5rZXlzKCk=",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>].keys()',wrap:!1}}),ie=new y({props:{code:"ZGljdF9rZXlzKCU1QidhdHRlbnRpb25fbWFzayclMkMlMjAnaHlwb3RoZXNpcyclMkMlMjAnaWR4JyUyQyUyMCdpbnB1dF9pZHMnJTJDJTIwJ2xhYmVsJyUyQyUyMCdwcmVtaXNlJyU1RCk=",highlighted:'dict_keys([<span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;hypothesis&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>, <span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;premise&#x27;</span>])',wrap:!1}}),oe=new y({props:{code:"dHlwZSh0cmFpbmVyLm1vZGVsKQ==",highlighted:'<span class="hljs-built_in">type</span>(trainer.model)',wrap:!1}}),pe=new y({props:{code:"dHJhbnNmb3JtZXJzLm1vZGVscy5kaXN0aWxiZXJ0Lm1vZGVsaW5nX2Rpc3RpbGJlcnQuRGlzdGlsQmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24=",highlighted:"transformers.models.distilbert.modeling_distilbert.DistilBertForSequenceClassification",wrap:!1}}),Me=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVE",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;attention_mask&quot;</span>]',wrap:!1}}),de=new y({props:{code:"JTVCMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSU1RA==",highlighted:'[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]',wrap:!1}}),ce=new y({props:{code:"bGVuKHRyYWluZXIudHJhaW5fZGF0YXNldCU1QjAlNUQlNUIlMjJhdHRlbnRpb25fbWFzayUyMiU1RCklMjAlM0QlM0QlMjBsZW4oJTBBJTIwJTIwJTIwJTIwdHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQSk=",highlighted:`<span class="hljs-built_in">len</span>(trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;attention_mask&quot;</span>]) == <span class="hljs-built_in">len</span>(
    trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;input_ids&quot;</span>]
)`,wrap:!1}}),ye=new y({props:{code:"VHJ1ZQ==",highlighted:'<span class="hljs-literal">True</span>',wrap:!1}}),Je=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0JTVCMCU1RCU1QiUyMmxhYmVsJTIyJTVE",highlighted:'trainer.train_dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;label&quot;</span>]',wrap:!1}}),be=new y({props:{code:"MQ==",highlighted:'<span class="hljs-number">1</span>',wrap:!1}}),je=new y({props:{code:"dHJhaW5lci50cmFpbl9kYXRhc2V0LmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXM=",highlighted:'trainer.train_dataset.features[<span class="hljs-string">&quot;label&quot;</span>].names',wrap:!1}}),Te=new y({props:{code:"JTVCJ2VudGFpbG1lbnQnJTJDJTIwJ25ldXRyYWwnJTJDJTIwJ2NvbnRyYWRpY3Rpb24nJTVE",highlighted:'[<span class="hljs-string">&#x27;entailment&#x27;</span>, <span class="hljs-string">&#x27;neutral&#x27;</span>, <span class="hljs-string">&#x27;contradiction&#x27;</span>]',wrap:!1}}),U=new jl({props:{$$slots:{default:[br]},$$scope:{ctx:f}}}),Ce=new j({props:{title:"From datasets to dataloaders",local:"from-datasets-to-dataloaders",headingTag:"h3"}}),Ie=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>`,wrap:!1}}),Be=new y({props:{code:"fiUyRmdpdCUyRnRyYW5zZm9ybWVycyUyRnNyYyUyRnRyYW5zZm9ybWVycyUyRmRhdGElMkZkYXRhX2NvbGxhdG9yLnB5JTIwaW4lMjB0b3JjaF9kZWZhdWx0X2RhdGFfY29sbGF0b3IoZmVhdHVyZXMpJTBBJTIwJTIwJTIwJTIwMTA1JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glNUJrJTVEJTIwJTNEJTIwdG9yY2guc3RhY2soJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBLS0lM0UlMjAxMDclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QmslNUQlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZiU1QmslNUQlMjBmb3IlMjBmJTIwaW4lMjBmZWF0dXJlcyU1RCklMEElMjAlMjAlMjAlMjAxMDglMjAlMEElMjAlMjAlMjAlMjAxMDklMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaCUwQSUwQVZhbHVlRXJyb3IlM0ElMjBleHBlY3RlZCUyMHNlcXVlbmNlJTIwb2YlMjBsZW5ndGglMjA0NSUyMGF0JTIwZGltJTIwMSUyMChnb3QlMjA3Nik=",highlighted:`~/git/transformers/src/transformers/data/data_collator.py <span class="hljs-keyword">in</span> torch_default_data_collator(features)
    <span class="hljs-number">105</span>                 batch[k] = torch.stack([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">106</span>             <span class="hljs-keyword">else</span>:
--&gt; <span class="hljs-number">107</span>                 batch[k] = torch.tensor([f[k] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> features])
    <span class="hljs-number">108</span> 
    <span class="hljs-number">109</span>     <span class="hljs-keyword">return</span> batch

ValueError: expected sequence of length <span class="hljs-number">45</span> at dim <span class="hljs-number">1</span> (got <span class="hljs-number">76</span>)`,wrap:!1}}),Xe=new y({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBZGF0YV9jb2xsYXRvcg==",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
data_collator`,wrap:!1}}),Re=new y({props:{code:"JTNDZnVuY3Rpb24lMjB0cmFuc2Zvcm1lcnMuZGF0YS5kYXRhX2NvbGxhdG9yLmRlZmF1bHRfZGF0YV9jb2xsYXRvcihmZWF0dXJlcyUzQSUyMExpc3QlNUJJbnB1dERhdGFDbGFzcyU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJ3B0JyklMjAtJTNFJTIwRGljdCU1QnN0ciUyQyUyMEFueSU1RCUzRQ==",highlighted:'&lt;function transformers.data.data_collator.default_data_collator(features: <span class="hljs-type">List</span>[InputDataClass], return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]&gt;',wrap:!1}}),Ve=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),Ye=new y({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ1VEQSUyMGVycm9yJTNBJTIwQ1VCTEFTX1NUQVRVU19BTExPQ19GQUlMRUQlMjB3aGVuJTIwY2FsbGluZyUyMCU2MGN1Ymxhc0NyZWF0ZShoYW5kbGUpJTYw",highlighted:"RuntimeError: CUDA error: CUBLAS_STATUS_ALLOC_FAILED when calling `cublasCreate(handle)`",wrap:!1}}),ze=new y({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBYmF0Y2glMjAlM0QlMjBkYXRhX2NvbGxhdG9yKCU1QnRyYWluZXIudHJhaW5fZGF0YXNldCU1QmklNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSg0KSU1RCk=",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
batch = data_collator([trainer.train_dataset[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>)])`,wrap:!1}}),Qe=new y({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKS5jb2xsYXRlX2ZuJTBBYWN0dWFsX3RyYWluX3NldCUyMCUzRCUyMHRyYWluZXIuX3JlbW92ZV91bnVzZWRfY29sdW1ucyh0cmFpbmVyLnRyYWluX2RhdGFzZXQpJTBBYmF0Y2glMjAlM0QlMjBkYXRhX2NvbGxhdG9yKCU1QmFjdHVhbF90cmFpbl9zZXQlNUJpJTVEJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoNCklNUQp",highlighted:`data_collator = trainer.get_train_dataloader().collate_fn
actual_train_set = trainer._remove_unused_columns(trainer.train_dataset)
batch = data_collator([actual_train_set[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>)])`,wrap:!1}}),Se=new j({props:{title:"Going through the model",local:"going-through-the-model",headingTag:"h3"}}),Le=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>`,wrap:!1}}),et=new y({props:{code:"b3V0cHV0cyUyMCUzRCUyMHRyYWluZXIubW9kZWwuY3B1KCkoKipiYXRjaCk=",highlighted:"outputs = trainer.model.cpu()(**batch)",wrap:!1}}),tt=new y({props:{code:"fiUyRi5weWVudiUyRnZlcnNpb25zJTJGMy43LjklMkZlbnZzJTJGYmFzZSUyRmxpYiUyRnB5dGhvbjMuNyUyRnNpdGUtcGFja2FnZXMlMkZ0b3JjaCUyRm5uJTJGZnVuY3Rpb25hbC5weSUyMGluJTIwbmxsX2xvc3MoaW5wdXQlMkMlMjB0YXJnZXQlMkMlMjB3ZWlnaHQlMkMlMjBzaXplX2F2ZXJhZ2UlMkMlMjBpZ25vcmVfaW5kZXglMkMlMjByZWR1Y2UlMkMlMjByZWR1Y3Rpb24pJTBBJTIwJTIwJTIwMjM4NiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAyMzg3JTIwJTIwJTIwJTIwJTIwaWYlMjBkaW0lMjAlM0QlM0QlMjAyJTNBJTBBLSUzRSUyMDIzODglMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXQlMjAlM0QlMjB0b3JjaC5fQy5fbm4ubmxsX2xvc3MoaW5wdXQlMkMlMjB0YXJnZXQlMkMlMjB3ZWlnaHQlMkMlMjBfUmVkdWN0aW9uLmdldF9lbnVtKHJlZHVjdGlvbiklMkMlMjBpZ25vcmVfaW5kZXgpJTBBJTIwJTIwJTIwMjM4OSUyMCUyMCUyMCUyMCUyMGVsaWYlMjBkaW0lMjAlM0QlM0QlMjA0JTNBJTBBJTIwJTIwJTIwMjM5MCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldCUyMCUzRCUyMHRvcmNoLl9DLl9ubi5ubGxfbG9zczJkKGlucHV0JTJDJTIwdGFyZ2V0JTJDJTIwd2VpZ2h0JTJDJTIwX1JlZHVjdGlvbi5nZXRfZW51bShyZWR1Y3Rpb24pJTJDJTIwaWdub3JlX2luZGV4KSUwQSUwQUluZGV4RXJyb3IlM0ElMjBUYXJnZXQlMjAyJTIwaXMlMjBvdXQlMjBvZiUyMGJvdW5kcy4=",highlighted:`~/.pyenv/versions/<span class="hljs-number">3.7</span><span class="hljs-number">.9</span>/envs/base/lib/python3<span class="hljs-number">.7</span>/site-packages/torch/nn/functional.py <span class="hljs-keyword">in</span> nll_loss(<span class="hljs-built_in">input</span>, target, weight, size_average, ignore_index, reduce, reduction)
   <span class="hljs-number">2386</span>         )
   <span class="hljs-number">2387</span>     <span class="hljs-keyword">if</span> dim == <span class="hljs-number">2</span>:
-&gt; <span class="hljs-number">2388</span>         ret = torch._C._nn.nll_loss(<span class="hljs-built_in">input</span>, target, weight, _Reduction.get_enum(reduction), ignore_index)
   <span class="hljs-number">2389</span>     <span class="hljs-keyword">elif</span> dim == <span class="hljs-number">4</span>:
   <span class="hljs-number">2390</span>         ret = torch._C._nn.nll_loss2d(<span class="hljs-built_in">input</span>, target, weight, _Reduction.get_enum(reduction), ignore_index)

IndexError: Target <span class="hljs-number">2</span> <span class="hljs-keyword">is</span> out of bounds.`,wrap:!1}}),st=new y({props:{code:"dHJhaW5lci5tb2RlbC5jb25maWcubnVtX2xhYmVscw==",highlighted:"trainer.model.config.num_labels",wrap:!1}}),at=new y({props:{code:"Mg==",highlighted:'<span class="hljs-number">2</span>',wrap:!1}}),it=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint, num_labels=<span class="hljs-number">3</span>)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)`,wrap:!1}}),ot=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBb3V0cHV0cyUyMCUzRCUyMHRyYWluZXIubW9kZWwuY3B1KCkoKipiYXRjaCk=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>

outputs = trainer.model.cpu()(**batch)`,wrap:!1}}),ht=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUwQW91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsLnRvKGRldmljZSkoKipiYXRjaCk=",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}

outputs = trainer.model.to(device)(**batch)`,wrap:!1}}),Mt=new j({props:{title:"Performing one optimization step",local:"performing-one-optimization-step",headingTag:"h3"}}),ct=new y({props:{code:"bG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQWxvc3MuYmFja3dhcmQoKQ==",highlighted:`loss = outputs.loss
loss.backward()`,wrap:!1}}),Jt=new y({props:{code:"dHJhaW5lci5jcmVhdGVfb3B0aW1pemVyKCklMEF0cmFpbmVyLm9wdGltaXplci5zdGVwKCk=",highlighted:`trainer.create_optimizer()
trainer.optimizer.step()`,wrap:!1}}),ft=new j({props:{title:"Dealing with CUDA out-of-memory errors",local:"dealing-with-cuda-out-of-memory-errors",headingTag:"h3"}}),g=new jl({props:{$$slots:{default:[fr]},$$scope:{ctx:f}}}),Ut=new j({props:{title:"Evaluating the model",local:"evaluating-the-model",headingTag:"h3"}}),$t=new y({props:{code:"JTIzJTIwVGhpcyUyMHdpbGwlMjB0YWtlJTIwYSUyMGxvbmclMjB0aW1lJTIwYW5kJTIwZXJyb3IlMjBvdXQlMkMlMjBzbyUyMHlvdSUyMHNob3VsZG4ndCUyMHJ1biUyMHRoaXMlMjBjZWxsJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-comment"># This will take a long time and error out, so you shouldn&#x27;t run this cell</span>
trainer.train()`,wrap:!1}}),kt=new y({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),It=new y({props:{code:"dHJhaW5lci5ldmFsdWF0ZSgp",highlighted:"trainer.evaluate()",wrap:!1}}),vt=new y({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),$=new jl({props:{$$slots:{default:[jr]},$$scope:{ctx:f}}}),Wt=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X2V2YWxfZGF0YWxvYWRlcigpJTNBJTBBJTIwJTIwJTIwJTIwYnJlYWslMEElMEFiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwdHJhaW5lci5tb2RlbCgqKmJhdGNoKQ==",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_eval_dataloader():
    <span class="hljs-keyword">break</span>

batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = trainer.model(**batch)`,wrap:!1}}),Rt=new y({props:{code:"fiUyRmdpdCUyRmRhdGFzZXRzJTJGc3JjJTJGZGF0YXNldHMlMkZtZXRyaWMucHklMjBpbiUyMGFkZF9iYXRjaChzZWxmJTJDJTIwcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzKSUwQSUyMCUyMCUyMCUyMDQzMSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMDQzMiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhdGNoJTIwJTNEJTIwJTdCJTIycHJlZGljdGlvbnMlMjIlM0ElMjBwcmVkaWN0aW9ucyUyQyUyMCUyMnJlZmVyZW5jZXMlMjIlM0ElMjByZWZlcmVuY2VzJTdEJTBBLS0lM0UlMjA0MzMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMHNlbGYuaW5mby5mZWF0dXJlcy5lbmNvZGVfYmF0Y2goYmF0Y2gpJTBBJTIwJTIwJTIwJTIwNDM0JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLndyaXRlciUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMDQzNSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuX2luaXRfd3JpdGVyKCk=",highlighted:`~/git/datasets/src/datasets/metric.py <span class="hljs-keyword">in</span> add_batch(self, predictions, references)
    <span class="hljs-number">431</span>         <span class="hljs-string">&quot;&quot;&quot;
    432         batch = {&quot;predictions&quot;: predictions, &quot;references&quot;: references}
--&gt; 433         batch = self.info.features.encode_batch(batch)
    434         if self.writer is None:
    435             self._init_writer()</span>`,wrap:!1}}),xt=new y({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cy5jcHUoKS5udW1weSgpJTBBbGFiZWxzJTIwJTNEJTIwYmF0Y2glNUIlMjJsYWJlbHMlMjIlNUQuY3B1KCkubnVtcHkoKSUwQSUwQWNvbXB1dGVfbWV0cmljcygocHJlZGljdGlvbnMlMkMlMjBsYWJlbHMpKQ==",highlighted:`predictions = outputs.logits.cpu().numpy()
labels = batch[<span class="hljs-string">&quot;labels&quot;</span>].cpu().numpy()

compute_metrics((predictions, labels))`,wrap:!1}}),Vt=new y({props:{code:"VHlwZUVycm9yJTNBJTIwb25seSUyMHNpemUtMSUyMGFycmF5cyUyMGNhbiUyMGJlJTIwY29udmVydGVkJTIwdG8lMjBQeXRob24lMjBzY2FsYXJz",highlighted:'TypeError: only size-<span class="hljs-number">1</span> arrays can be converted to Python scalars',wrap:!1}}),Yt=new y({props:{code:"cHJlZGljdGlvbnMuc2hhcGUlMkMlMjBsYWJlbHMuc2hhcGU=",highlighted:"predictions.shape, labels.shape",wrap:!1}}),At=new y({props:{code:"KCg4JTJDJTIwMyklMkMlMjAoOCUyQykp",highlighted:'((<span class="hljs-number">8</span>, <span class="hljs-number">3</span>), (<span class="hljs-number">8</span>,))',wrap:!1}}),zt=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyQyUyMGxhYmVscyUyMCUzRCUyMGV2YWxfcHJlZCUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwbnAuYXJnbWF4KHByZWRpY3Rpb25zJTJDJTIwYXhpcyUzRDEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RsYWJlbHMpJTBBJTBBJTBBY29tcHV0ZV9tZXRyaWNzKChwcmVkaWN0aW9ucyUyQyUyMGxhYmVscykp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


compute_metrics((predictions, labels))`,wrap:!1}}),Ht=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuNjI1JTdE",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.625</span>}',wrap:!1}}),Et=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    AutoTokenizer,
    AutoModelForSequenceClassification,
    DataCollatorWithPadding,
    TrainingArguments,
    Trainer,
)

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)

model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;premise&quot;</span>], examples[<span class="hljs-string">&quot;hypothesis&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)
model = AutoModelForSequenceClassification.from_pretrained(model_checkpoint, num_labels=<span class="hljs-number">3</span>)

args = TrainingArguments(
    <span class="hljs-string">f&quot;distilbert-finetuned-mnli&quot;</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">2e-5</span>,
    num_train_epochs=<span class="hljs-number">3</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
)

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mnli&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)


data_collator = DataCollatorWithPadding(tokenizer=tokenizer)

trainer = Trainer(
    model,
    args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation_matched&quot;</span>],
    compute_metrics=compute_metrics,
    data_collator=data_collator,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),k=new jl({props:{$$slots:{default:[Tr]},$$scope:{ctx:f}}}),qt=new j({props:{title:"Debugging silent errors during training",local:"debugging-silent-errors-during-training",headingTag:"h2"}}),Dt=new j({props:{title:"Check your data (again!)",local:"check-your-data-again",headingTag:"h3"}}),C=new jl({props:{warning:!0,$$slots:{default:[Ur]},$$scope:{ctx:f}}}),ll=new j({props:{title:"Overfit your model on one batch",local:"overfit-your-model-on-one-batch",headingTag:"h3"}}),nl=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluZXIuZ2V0X3RyYWluX2RhdGFsb2FkZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEF0cmFpbmVyLmNyZWF0ZV9vcHRpbWl6ZXIoKSUwQSUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKDIwKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMGxvc3MuYmFja3dhcmQoKSUwQSUyMCUyMCUyMCUyMHRyYWluZXIub3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMHRyYWluZXIub3B0aW1pemVyLnplcm9fZ3JhZCgp",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> trainer.get_train_dataloader():
    <span class="hljs-keyword">break</span>

batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
trainer.create_optimizer()

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">20</span>):
    outputs = trainer.model(**batch)
    loss = outputs.loss
    loss.backward()
    trainer.optimizer.step()
    trainer.optimizer.zero_grad()`,wrap:!1}}),Z=new jl({props:{$$slots:{default:[gr]},$$scope:{ctx:f}}}),rl=new y({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjB0cmFpbmVyLm1vZGVsKCoqYmF0Y2gpJTBBcHJlZHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxhYmVscyUyMCUzRCUyMGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEJTBBJTBBY29tcHV0ZV9tZXRyaWNzKChwcmVkcy5jcHUoKS5udW1weSgpJTJDJTIwbGFiZWxzLmNwdSgpLm51bXB5KCkpKQ==",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = trainer.model(**batch)
preds = outputs.logits
labels = batch[<span class="hljs-string">&quot;labels&quot;</span>]

compute_metrics((preds.cpu().numpy(), labels.cpu().numpy()))`,wrap:!1}}),ol=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDEuMCU3RA==",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">1.0</span>}',wrap:!1}}),I=new jl({props:{warning:!0,$$slots:{default:[$r]},$$scope:{ctx:f}}}),ml=new j({props:{title:"Don’t tune anything until you have a first baseline",local:"dont-tune-anything-until-you-have-a-first-baseline",headingTag:"h3"}}),cl=new j({props:{title:"Ask for help",local:"ask-for-help",headingTag:"h3"}}),fl=new cr({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter8/4.mdx"}}),{c(){c=i("meta"),J=a(),w=i("p"),b=a(),p(T.$$.fragment),gl=a(),p(v.$$.fragment),$l=a(),p(B.$$.fragment),kl=a(),p(W.$$.fragment),Cl=a(),X=i("p"),X.innerHTML=$n,Zl=a(),p(R.$$.fragment),Il=a(),p(G.$$.fragment),vl=a(),x=i("p"),x.innerHTML=kn,Bl=a(),V=i("p"),V.innerHTML=Cn,Wl=a(),_=i("p"),_.innerHTML=Zn,Xl=a(),p(Y.$$.fragment),Rl=a(),A=i("p"),A.textContent=In,Gl=a(),p(F.$$.fragment),xl=a(),p(z.$$.fragment),Vl=a(),H=i("p"),H.innerHTML=vn,_l=a(),Q=i("p"),Q.innerHTML=Bn,Yl=a(),p(N.$$.fragment),Al=a(),p(E.$$.fragment),Fl=a(),S=i("p"),S.innerHTML=Wn,zl=a(),q=i("p"),q.innerHTML=Xn,Hl=a(),p(L.$$.fragment),Ql=a(),D=i("p"),D.textContent=Rn,Nl=a(),p(P.$$.fragment),El=a(),K=i("p"),K.textContent=Gn,Sl=a(),p(O.$$.fragment),ql=a(),ee=i("p"),ee.textContent=xn,Ll=a(),te=i("p"),te.textContent=Vn,Dl=a(),p(le.$$.fragment),Pl=a(),p(se.$$.fragment),Kl=a(),ae=i("p"),ae.textContent=_n,Ol=a(),p(ne.$$.fragment),es=a(),p(ie.$$.fragment),ts=a(),re=i("p"),re.innerHTML=Yn,ls=a(),p(oe.$$.fragment),ss=a(),p(pe.$$.fragment),as=a(),he=i("p"),he.innerHTML=An,ns=a(),me=i("p"),me.innerHTML=Fn,is=a(),p(Me.$$.fragment),rs=a(),p(de.$$.fragment),os=a(),ue=i("p"),ue.textContent=zn,ps=a(),p(ce.$$.fragment),hs=a(),p(ye.$$.fragment),ms=a(),we=i("p"),we.textContent=Hn,Ms=a(),p(Je.$$.fragment),ds=a(),p(be.$$.fragment),us=a(),fe=i("p"),fe.innerHTML=Qn,cs=a(),p(je.$$.fragment),ys=a(),p(Te.$$.fragment),ws=a(),Ue=i("p"),Ue.innerHTML=Nn,Js=a(),ge=i("p"),ge.textContent=En,bs=a(),p(U.$$.fragment),fs=a(),$e=i("p"),$e.textContent=Sn,js=a(),ke=i("p"),ke.textContent=qn,Ts=a(),p(Ce.$$.fragment),Us=a(),Ze=i("p"),Ze.innerHTML=Ln,gs=a(),p(Ie.$$.fragment),$s=a(),ve=i("p"),ve.textContent=Dn,ks=a(),p(Be.$$.fragment),Cs=a(),We=i("p"),We.innerHTML=Pn,Zs=a(),p(Xe.$$.fragment),Is=a(),p(Re.$$.fragment),vs=a(),Ge=i("p"),Ge.innerHTML=Kn,Bs=a(),xe=i("p"),xe.innerHTML=On,Ws=a(),p(Ve.$$.fragment),Xs=a(),_e=i("p"),_e.textContent=ei,Rs=a(),p(Ye.$$.fragment),Gs=a(),Ae=i("p"),Ae.textContent=ti,xs=a(),Fe=i("p"),Fe.textContent=li,Vs=a(),p(ze.$$.fragment),_s=a(),He=i("p"),He.innerHTML=si,Ys=a(),p(Qe.$$.fragment),As=a(),Ne=i("p"),Ne.textContent=ai,Fs=a(),Ee=i("p"),Ee.textContent=ni,zs=a(),p(Se.$$.fragment),Hs=a(),qe=i("p"),qe.textContent=ii,Qs=a(),p(Le.$$.fragment),Ns=a(),De=i("p"),De.innerHTML=ri,Es=a(),Pe=i("p"),Pe.textContent=oi,Ss=a(),Ke=i("p"),Ke.textContent=pi,qs=a(),Oe=i("p"),Oe.innerHTML=hi,Ls=a(),p(et.$$.fragment),Ds=a(),p(tt.$$.fragment),Ps=a(),lt=i("p"),lt.innerHTML=mi,Ks=a(),p(st.$$.fragment),Os=a(),p(at.$$.fragment),ea=a(),nt=i("p"),nt.textContent=Mi,ta=a(),p(it.$$.fragment),la=a(),rt=i("p"),rt.innerHTML=di,sa=a(),p(ot.$$.fragment),aa=a(),pt=i("p"),pt.textContent=ui,na=a(),p(ht.$$.fragment),ia=a(),mt=i("p"),mt.textContent=ci,ra=a(),p(Mt.$$.fragment),oa=a(),dt=i("p"),dt.textContent=yi,pa=a(),ut=i("p"),ut.innerHTML=wi,ha=a(),p(ct.$$.fragment),ma=a(),yt=i("p"),yt.textContent=Ji,Ma=a(),wt=i("p"),wt.innerHTML=bi,da=a(),p(Jt.$$.fragment),ua=a(),bt=i("p"),bt.innerHTML=fi,ca=a(),p(ft.$$.fragment),ya=a(),jt=i("p"),jt.innerHTML=ji,wa=a(),Tt=i("p"),Tt.textContent=Ti,Ja=a(),p(g.$$.fragment),ba=a(),p(Ut.$$.fragment),fa=a(),gt=i("p"),gt.innerHTML=Ui,ja=a(),p($t.$$.fragment),Ta=a(),p(kt.$$.fragment),Ua=a(),Ct=i("p"),Ct.textContent=gi,ga=a(),Zt=i("p"),Zt.innerHTML=$i,$a=a(),p(It.$$.fragment),ka=a(),p(vt.$$.fragment),Ca=a(),p($.$$.fragment),Za=a(),Bt=i("p"),Bt.textContent=ki,Ia=a(),p(Wt.$$.fragment),va=a(),Xt=i("p"),Xt.textContent=Ci,Ba=a(),p(Rt.$$.fragment),Wa=a(),Gt=i("p"),Gt.innerHTML=Zi,Xa=a(),p(xt.$$.fragment),Ra=a(),p(Vt.$$.fragment),Ga=a(),_t=i("p"),_t.innerHTML=Ii,xa=a(),p(Yt.$$.fragment),Va=a(),p(At.$$.fragment),_a=a(),Ft=i("p"),Ft.innerHTML=vi,Ya=a(),p(zt.$$.fragment),Aa=a(),p(Ht.$$.fragment),Fa=a(),Qt=i("p"),Qt.textContent=Bi,za=a(),Nt=i("p"),Nt.textContent=Wi,Ha=a(),p(Et.$$.fragment),Qa=a(),St=i("p"),St.textContent=Xi,Na=a(),p(k.$$.fragment),Ea=a(),p(qt.$$.fragment),Sa=a(),Lt=i("p"),Lt.textContent=Ri,qa=a(),p(Dt.$$.fragment),La=a(),Pt=i("p"),Pt.textContent=Gi,Da=a(),Kt=i("ul"),Kt.innerHTML=xi,Pa=a(),p(C.$$.fragment),Ka=a(),Ot=i("p"),Ot.textContent=Vi,Oa=a(),el=i("p"),el.textContent=_i,en=a(),tl=i("p"),tl.textContent=Yi,tn=a(),p(ll.$$.fragment),ln=a(),sl=i("p"),sl.textContent=Ai,sn=a(),al=i("p"),al.innerHTML=Fi,an=a(),p(nl.$$.fragment),nn=a(),p(Z.$$.fragment),rn=a(),il=i("p"),il.innerHTML=zi,on=a(),p(rl.$$.fragment),pn=a(),p(ol.$$.fragment),hn=a(),pl=i("p"),pl.textContent=Hi,mn=a(),hl=i("p"),hl.textContent=Qi,Mn=a(),p(I.$$.fragment),dn=a(),p(ml.$$.fragment),un=a(),Ml=i("p"),Ml.innerHTML=Ni,cn=a(),dl=i("p"),dl.textContent=Ei,yn=a(),ul=i("p"),ul.textContent=Si,wn=a(),p(cl.$$.fragment),Jn=a(),yl=i("p"),yl.innerHTML=qi,bn=a(),wl=i("p"),wl.textContent=Li,fn=a(),Jl=i("ul"),Jl.innerHTML=Di,jn=a(),bl=i("p"),bl.textContent=Pi,Tn=a(),p(fl.$$.fragment),Un=a(),Ul=i("p"),this.h()},l(e){const t=Mr("svelte-u9bgzb",document.head);c=r(t,"META",{name:!0,content:!0}),t.forEach(l),J=n(e),w=r(e,"P",{}),ir(w).forEach(l),b=n(e),h(T.$$.fragment,e),gl=n(e),h(v.$$.fragment,e),$l=n(e),h(B.$$.fragment,e),kl=n(e),h(W.$$.fragment,e),Cl=n(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1ytuhj4"&&(X.innerHTML=$n),Zl=n(e),h(R.$$.fragment,e),Il=n(e),h(G.$$.fragment,e),vl=n(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-tnyumb"&&(x.innerHTML=kn),Bl=n(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-hzxl7e"&&(V.innerHTML=Cn),Wl=n(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-q32aak"&&(_.innerHTML=Zn),Xl=n(e),h(Y.$$.fragment,e),Rl=n(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-3pg78t"&&(A.textContent=In),Gl=n(e),h(F.$$.fragment,e),xl=n(e),h(z.$$.fragment,e),Vl=n(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-gzpow8"&&(H.innerHTML=vn),_l=n(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-3sg9xy"&&(Q.innerHTML=Bn),Yl=n(e),h(N.$$.fragment,e),Al=n(e),h(E.$$.fragment,e),Fl=n(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-6jps2k"&&(S.innerHTML=Wn),zl=n(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1wolr01"&&(q.innerHTML=Xn),Hl=n(e),h(L.$$.fragment,e),Ql=n(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1k94mat"&&(D.textContent=Rn),Nl=n(e),h(P.$$.fragment,e),El=n(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1tmbf0v"&&(K.textContent=Gn),Sl=n(e),h(O.$$.fragment,e),ql=n(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-10gbmtc"&&(ee.textContent=xn),Ll=n(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-4qxohk"&&(te.textContent=Vn),Dl=n(e),h(le.$$.fragment,e),Pl=n(e),h(se.$$.fragment,e),Kl=n(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1dgrscj"&&(ae.textContent=_n),Ol=n(e),h(ne.$$.fragment,e),es=n(e),h(ie.$$.fragment,e),ts=n(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1ojy6k7"&&(re.innerHTML=Yn),ls=n(e),h(oe.$$.fragment,e),ss=n(e),h(pe.$$.fragment,e),as=n(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1xoucm3"&&(he.innerHTML=An),ns=n(e),me=r(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-5x641b"&&(me.innerHTML=Fn),is=n(e),h(Me.$$.fragment,e),rs=n(e),h(de.$$.fragment,e),os=n(e),ue=r(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1pojahx"&&(ue.textContent=zn),ps=n(e),h(ce.$$.fragment,e),hs=n(e),h(ye.$$.fragment,e),ms=n(e),we=r(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-9qe8oh"&&(we.textContent=Hn),Ms=n(e),h(Je.$$.fragment,e),ds=n(e),h(be.$$.fragment,e),us=n(e),fe=r(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-z61tvp"&&(fe.innerHTML=Qn),cs=n(e),h(je.$$.fragment,e),ys=n(e),h(Te.$$.fragment,e),ws=n(e),Ue=r(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-tigzcg"&&(Ue.innerHTML=Nn),Js=n(e),ge=r(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1d4x6k6"&&(ge.textContent=En),bs=n(e),h(U.$$.fragment,e),fs=n(e),$e=r(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-1n42cxl"&&($e.textContent=Sn),js=n(e),ke=r(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-j9xc0o"&&(ke.textContent=qn),Ts=n(e),h(Ce.$$.fragment,e),Us=n(e),Ze=r(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-dmtbok"&&(Ze.innerHTML=Ln),gs=n(e),h(Ie.$$.fragment,e),$s=n(e),ve=r(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-78cxp3"&&(ve.textContent=Dn),ks=n(e),h(Be.$$.fragment,e),Cs=n(e),We=r(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-1g50zb3"&&(We.innerHTML=Pn),Zs=n(e),h(Xe.$$.fragment,e),Is=n(e),h(Re.$$.fragment,e),vs=n(e),Ge=r(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-6x08fd"&&(Ge.innerHTML=Kn),Bs=n(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-il2k2h"&&(xe.innerHTML=On),Ws=n(e),h(Ve.$$.fragment,e),Xs=n(e),_e=r(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-ijqm5z"&&(_e.textContent=ei),Rs=n(e),h(Ye.$$.fragment,e),Gs=n(e),Ae=r(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-1a7o2xm"&&(Ae.textContent=ti),xs=n(e),Fe=r(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-11i1sfm"&&(Fe.textContent=li),Vs=n(e),h(ze.$$.fragment,e),_s=n(e),He=r(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-41j77u"&&(He.innerHTML=si),Ys=n(e),h(Qe.$$.fragment,e),As=n(e),Ne=r(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1f68fby"&&(Ne.textContent=ai),Fs=n(e),Ee=r(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-1jk0zgp"&&(Ee.textContent=ni),zs=n(e),h(Se.$$.fragment,e),Hs=n(e),qe=r(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-17wdfhf"&&(qe.textContent=ii),Qs=n(e),h(Le.$$.fragment,e),Ns=n(e),De=r(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-1otof6i"&&(De.innerHTML=ri),Es=n(e),Pe=r(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-zojoe4"&&(Pe.textContent=oi),Ss=n(e),Ke=r(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-3hnmla"&&(Ke.textContent=pi),qs=n(e),Oe=r(e,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-1f20ywv"&&(Oe.innerHTML=hi),Ls=n(e),h(et.$$.fragment,e),Ds=n(e),h(tt.$$.fragment,e),Ps=n(e),lt=r(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-1d72w7m"&&(lt.innerHTML=mi),Ks=n(e),h(st.$$.fragment,e),Os=n(e),h(at.$$.fragment,e),ea=n(e),nt=r(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-1kos5jb"&&(nt.textContent=Mi),ta=n(e),h(it.$$.fragment,e),la=n(e),rt=r(e,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-dvos0i"&&(rt.innerHTML=di),sa=n(e),h(ot.$$.fragment,e),aa=n(e),pt=r(e,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-1mlispf"&&(pt.textContent=ui),na=n(e),h(ht.$$.fragment,e),ia=n(e),mt=r(e,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-1ofmtfm"&&(mt.textContent=ci),ra=n(e),h(Mt.$$.fragment,e),oa=n(e),dt=r(e,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-1jisdcu"&&(dt.textContent=yi),pa=n(e),ut=r(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-tjcz1h"&&(ut.innerHTML=wi),ha=n(e),h(ct.$$.fragment,e),ma=n(e),yt=r(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-1rq3476"&&(yt.textContent=Ji),Ma=n(e),wt=r(e,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-9h4y7g"&&(wt.innerHTML=bi),da=n(e),h(Jt.$$.fragment,e),ua=n(e),bt=r(e,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-1yyc42o"&&(bt.innerHTML=fi),ca=n(e),h(ft.$$.fragment,e),ya=n(e),jt=r(e,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-126rjjn"&&(jt.innerHTML=ji),wa=n(e),Tt=r(e,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-18vu150"&&(Tt.textContent=Ti),Ja=n(e),h(g.$$.fragment,e),ba=n(e),h(Ut.$$.fragment,e),fa=n(e),gt=r(e,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-2gm1u9"&&(gt.innerHTML=Ui),ja=n(e),h($t.$$.fragment,e),Ta=n(e),h(kt.$$.fragment,e),Ua=n(e),Ct=r(e,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-im7b67"&&(Ct.textContent=gi),ga=n(e),Zt=r(e,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-1doyjwq"&&(Zt.innerHTML=$i),$a=n(e),h(It.$$.fragment,e),ka=n(e),h(vt.$$.fragment,e),Ca=n(e),h($.$$.fragment,e),Za=n(e),Bt=r(e,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-1nz2xql"&&(Bt.textContent=ki),Ia=n(e),h(Wt.$$.fragment,e),va=n(e),Xt=r(e,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-ffb80c"&&(Xt.textContent=Ci),Ba=n(e),h(Rt.$$.fragment,e),Wa=n(e),Gt=r(e,"P",{"data-svelte-h":!0}),o(Gt)!=="svelte-1rvvrss"&&(Gt.innerHTML=Zi),Xa=n(e),h(xt.$$.fragment,e),Ra=n(e),h(Vt.$$.fragment,e),Ga=n(e),_t=r(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-12tu8pl"&&(_t.innerHTML=Ii),xa=n(e),h(Yt.$$.fragment,e),Va=n(e),h(At.$$.fragment,e),_a=n(e),Ft=r(e,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-nr86wp"&&(Ft.innerHTML=vi),Ya=n(e),h(zt.$$.fragment,e),Aa=n(e),h(Ht.$$.fragment,e),Fa=n(e),Qt=r(e,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-26f203"&&(Qt.textContent=Bi),za=n(e),Nt=r(e,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-lmu6ng"&&(Nt.textContent=Wi),Ha=n(e),h(Et.$$.fragment,e),Qa=n(e),St=r(e,"P",{"data-svelte-h":!0}),o(St)!=="svelte-14dxkx4"&&(St.textContent=Xi),Na=n(e),h(k.$$.fragment,e),Ea=n(e),h(qt.$$.fragment,e),Sa=n(e),Lt=r(e,"P",{"data-svelte-h":!0}),o(Lt)!=="svelte-ejwpcu"&&(Lt.textContent=Ri),qa=n(e),h(Dt.$$.fragment,e),La=n(e),Pt=r(e,"P",{"data-svelte-h":!0}),o(Pt)!=="svelte-12i4wz3"&&(Pt.textContent=Gi),Da=n(e),Kt=r(e,"UL",{"data-svelte-h":!0}),o(Kt)!=="svelte-1m9el5s"&&(Kt.innerHTML=xi),Pa=n(e),h(C.$$.fragment,e),Ka=n(e),Ot=r(e,"P",{"data-svelte-h":!0}),o(Ot)!=="svelte-1u3f40c"&&(Ot.textContent=Vi),Oa=n(e),el=r(e,"P",{"data-svelte-h":!0}),o(el)!=="svelte-1122ld9"&&(el.textContent=_i),en=n(e),tl=r(e,"P",{"data-svelte-h":!0}),o(tl)!=="svelte-8qgi72"&&(tl.textContent=Yi),tn=n(e),h(ll.$$.fragment,e),ln=n(e),sl=r(e,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-ud8t14"&&(sl.textContent=Ai),sn=n(e),al=r(e,"P",{"data-svelte-h":!0}),o(al)!=="svelte-mho0en"&&(al.innerHTML=Fi),an=n(e),h(nl.$$.fragment,e),nn=n(e),h(Z.$$.fragment,e),rn=n(e),il=r(e,"P",{"data-svelte-h":!0}),o(il)!=="svelte-zb5hop"&&(il.innerHTML=zi),on=n(e),h(rl.$$.fragment,e),pn=n(e),h(ol.$$.fragment,e),hn=n(e),pl=r(e,"P",{"data-svelte-h":!0}),o(pl)!=="svelte-ccee5n"&&(pl.textContent=Hi),mn=n(e),hl=r(e,"P",{"data-svelte-h":!0}),o(hl)!=="svelte-1appsmg"&&(hl.textContent=Qi),Mn=n(e),h(I.$$.fragment,e),dn=n(e),h(ml.$$.fragment,e),un=n(e),Ml=r(e,"P",{"data-svelte-h":!0}),o(Ml)!=="svelte-1inlulo"&&(Ml.innerHTML=Ni),cn=n(e),dl=r(e,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-ngq5bm"&&(dl.textContent=Ei),yn=n(e),ul=r(e,"P",{"data-svelte-h":!0}),o(ul)!=="svelte-17qlrbw"&&(ul.textContent=Si),wn=n(e),h(cl.$$.fragment,e),Jn=n(e),yl=r(e,"P",{"data-svelte-h":!0}),o(yl)!=="svelte-1kejrvw"&&(yl.innerHTML=qi),bn=n(e),wl=r(e,"P",{"data-svelte-h":!0}),o(wl)!=="svelte-1wt0l4q"&&(wl.textContent=Li),fn=n(e),Jl=r(e,"UL",{"data-svelte-h":!0}),o(Jl)!=="svelte-vkgmp2"&&(Jl.innerHTML=Di),jn=n(e),bl=r(e,"P",{"data-svelte-h":!0}),o(bl)!=="svelte-vjjrmr"&&(bl.textContent=Pi),Tn=n(e),h(fl.$$.fragment,e),Un=n(e),Ul=r(e,"P",{}),ir(Ul).forEach(l),this.h()},h(){rr(c,"name","hf:doc:metadata"),rr(c,"content",Cr)},m(e,t){dr(document.head,c),s(e,J,t),s(e,w,t),s(e,b,t),m(T,e,t),s(e,gl,t),m(v,e,t),s(e,$l,t),m(B,e,t),s(e,kl,t),m(W,e,t),s(e,Cl,t),s(e,X,t),s(e,Zl,t),m(R,e,t),s(e,Il,t),m(G,e,t),s(e,vl,t),s(e,x,t),s(e,Bl,t),s(e,V,t),s(e,Wl,t),s(e,_,t),s(e,Xl,t),m(Y,e,t),s(e,Rl,t),s(e,A,t),s(e,Gl,t),m(F,e,t),s(e,xl,t),m(z,e,t),s(e,Vl,t),s(e,H,t),s(e,_l,t),s(e,Q,t),s(e,Yl,t),m(N,e,t),s(e,Al,t),m(E,e,t),s(e,Fl,t),s(e,S,t),s(e,zl,t),s(e,q,t),s(e,Hl,t),m(L,e,t),s(e,Ql,t),s(e,D,t),s(e,Nl,t),m(P,e,t),s(e,El,t),s(e,K,t),s(e,Sl,t),m(O,e,t),s(e,ql,t),s(e,ee,t),s(e,Ll,t),s(e,te,t),s(e,Dl,t),m(le,e,t),s(e,Pl,t),m(se,e,t),s(e,Kl,t),s(e,ae,t),s(e,Ol,t),m(ne,e,t),s(e,es,t),m(ie,e,t),s(e,ts,t),s(e,re,t),s(e,ls,t),m(oe,e,t),s(e,ss,t),m(pe,e,t),s(e,as,t),s(e,he,t),s(e,ns,t),s(e,me,t),s(e,is,t),m(Me,e,t),s(e,rs,t),m(de,e,t),s(e,os,t),s(e,ue,t),s(e,ps,t),m(ce,e,t),s(e,hs,t),m(ye,e,t),s(e,ms,t),s(e,we,t),s(e,Ms,t),m(Je,e,t),s(e,ds,t),m(be,e,t),s(e,us,t),s(e,fe,t),s(e,cs,t),m(je,e,t),s(e,ys,t),m(Te,e,t),s(e,ws,t),s(e,Ue,t),s(e,Js,t),s(e,ge,t),s(e,bs,t),m(U,e,t),s(e,fs,t),s(e,$e,t),s(e,js,t),s(e,ke,t),s(e,Ts,t),m(Ce,e,t),s(e,Us,t),s(e,Ze,t),s(e,gs,t),m(Ie,e,t),s(e,$s,t),s(e,ve,t),s(e,ks,t),m(Be,e,t),s(e,Cs,t),s(e,We,t),s(e,Zs,t),m(Xe,e,t),s(e,Is,t),m(Re,e,t),s(e,vs,t),s(e,Ge,t),s(e,Bs,t),s(e,xe,t),s(e,Ws,t),m(Ve,e,t),s(e,Xs,t),s(e,_e,t),s(e,Rs,t),m(Ye,e,t),s(e,Gs,t),s(e,Ae,t),s(e,xs,t),s(e,Fe,t),s(e,Vs,t),m(ze,e,t),s(e,_s,t),s(e,He,t),s(e,Ys,t),m(Qe,e,t),s(e,As,t),s(e,Ne,t),s(e,Fs,t),s(e,Ee,t),s(e,zs,t),m(Se,e,t),s(e,Hs,t),s(e,qe,t),s(e,Qs,t),m(Le,e,t),s(e,Ns,t),s(e,De,t),s(e,Es,t),s(e,Pe,t),s(e,Ss,t),s(e,Ke,t),s(e,qs,t),s(e,Oe,t),s(e,Ls,t),m(et,e,t),s(e,Ds,t),m(tt,e,t),s(e,Ps,t),s(e,lt,t),s(e,Ks,t),m(st,e,t),s(e,Os,t),m(at,e,t),s(e,ea,t),s(e,nt,t),s(e,ta,t),m(it,e,t),s(e,la,t),s(e,rt,t),s(e,sa,t),m(ot,e,t),s(e,aa,t),s(e,pt,t),s(e,na,t),m(ht,e,t),s(e,ia,t),s(e,mt,t),s(e,ra,t),m(Mt,e,t),s(e,oa,t),s(e,dt,t),s(e,pa,t),s(e,ut,t),s(e,ha,t),m(ct,e,t),s(e,ma,t),s(e,yt,t),s(e,Ma,t),s(e,wt,t),s(e,da,t),m(Jt,e,t),s(e,ua,t),s(e,bt,t),s(e,ca,t),m(ft,e,t),s(e,ya,t),s(e,jt,t),s(e,wa,t),s(e,Tt,t),s(e,Ja,t),m(g,e,t),s(e,ba,t),m(Ut,e,t),s(e,fa,t),s(e,gt,t),s(e,ja,t),m($t,e,t),s(e,Ta,t),m(kt,e,t),s(e,Ua,t),s(e,Ct,t),s(e,ga,t),s(e,Zt,t),s(e,$a,t),m(It,e,t),s(e,ka,t),m(vt,e,t),s(e,Ca,t),m($,e,t),s(e,Za,t),s(e,Bt,t),s(e,Ia,t),m(Wt,e,t),s(e,va,t),s(e,Xt,t),s(e,Ba,t),m(Rt,e,t),s(e,Wa,t),s(e,Gt,t),s(e,Xa,t),m(xt,e,t),s(e,Ra,t),m(Vt,e,t),s(e,Ga,t),s(e,_t,t),s(e,xa,t),m(Yt,e,t),s(e,Va,t),m(At,e,t),s(e,_a,t),s(e,Ft,t),s(e,Ya,t),m(zt,e,t),s(e,Aa,t),m(Ht,e,t),s(e,Fa,t),s(e,Qt,t),s(e,za,t),s(e,Nt,t),s(e,Ha,t),m(Et,e,t),s(e,Qa,t),s(e,St,t),s(e,Na,t),m(k,e,t),s(e,Ea,t),m(qt,e,t),s(e,Sa,t),s(e,Lt,t),s(e,qa,t),m(Dt,e,t),s(e,La,t),s(e,Pt,t),s(e,Da,t),s(e,Kt,t),s(e,Pa,t),m(C,e,t),s(e,Ka,t),s(e,Ot,t),s(e,Oa,t),s(e,el,t),s(e,en,t),s(e,tl,t),s(e,tn,t),m(ll,e,t),s(e,ln,t),s(e,sl,t),s(e,sn,t),s(e,al,t),s(e,an,t),m(nl,e,t),s(e,nn,t),m(Z,e,t),s(e,rn,t),s(e,il,t),s(e,on,t),m(rl,e,t),s(e,pn,t),m(ol,e,t),s(e,hn,t),s(e,pl,t),s(e,mn,t),s(e,hl,t),s(e,Mn,t),m(I,e,t),s(e,dn,t),m(ml,e,t),s(e,un,t),s(e,Ml,t),s(e,cn,t),s(e,dl,t),s(e,yn,t),s(e,ul,t),s(e,wn,t),m(cl,e,t),s(e,Jn,t),s(e,yl,t),s(e,bn,t),s(e,wl,t),s(e,fn,t),s(e,Jl,t),s(e,jn,t),s(e,bl,t),s(e,Tn,t),m(fl,e,t),s(e,Un,t),s(e,Ul,t),gn=!0},p(e,[t]){const Ki={};t&1&&(Ki.fw=e[0]),T.$set(Ki);const Oi={};t&2&&(Oi.$$scope={dirty:t,ctx:e}),U.$set(Oi);const er={};t&2&&(er.$$scope={dirty:t,ctx:e}),g.$set(er);const tr={};t&2&&(tr.$$scope={dirty:t,ctx:e}),$.$set(tr);const lr={};t&2&&(lr.$$scope={dirty:t,ctx:e}),k.$set(lr);const sr={};t&2&&(sr.$$scope={dirty:t,ctx:e}),C.$set(sr);const ar={};t&2&&(ar.$$scope={dirty:t,ctx:e}),Z.$set(ar);const nr={};t&2&&(nr.$$scope={dirty:t,ctx:e}),I.$set(nr)},i(e){gn||(M(T.$$.fragment,e),M(v.$$.fragment,e),M(B.$$.fragment,e),M(W.$$.fragment,e),M(R.$$.fragment,e),M(G.$$.fragment,e),M(Y.$$.fragment,e),M(F.$$.fragment,e),M(z.$$.fragment,e),M(N.$$.fragment,e),M(E.$$.fragment,e),M(L.$$.fragment,e),M(P.$$.fragment,e),M(O.$$.fragment,e),M(le.$$.fragment,e),M(se.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(oe.$$.fragment,e),M(pe.$$.fragment,e),M(Me.$$.fragment,e),M(de.$$.fragment,e),M(ce.$$.fragment,e),M(ye.$$.fragment,e),M(Je.$$.fragment,e),M(be.$$.fragment,e),M(je.$$.fragment,e),M(Te.$$.fragment,e),M(U.$$.fragment,e),M(Ce.$$.fragment,e),M(Ie.$$.fragment,e),M(Be.$$.fragment,e),M(Xe.$$.fragment,e),M(Re.$$.fragment,e),M(Ve.$$.fragment,e),M(Ye.$$.fragment,e),M(ze.$$.fragment,e),M(Qe.$$.fragment,e),M(Se.$$.fragment,e),M(Le.$$.fragment,e),M(et.$$.fragment,e),M(tt.$$.fragment,e),M(st.$$.fragment,e),M(at.$$.fragment,e),M(it.$$.fragment,e),M(ot.$$.fragment,e),M(ht.$$.fragment,e),M(Mt.$$.fragment,e),M(ct.$$.fragment,e),M(Jt.$$.fragment,e),M(ft.$$.fragment,e),M(g.$$.fragment,e),M(Ut.$$.fragment,e),M($t.$$.fragment,e),M(kt.$$.fragment,e),M(It.$$.fragment,e),M(vt.$$.fragment,e),M($.$$.fragment,e),M(Wt.$$.fragment,e),M(Rt.$$.fragment,e),M(xt.$$.fragment,e),M(Vt.$$.fragment,e),M(Yt.$$.fragment,e),M(At.$$.fragment,e),M(zt.$$.fragment,e),M(Ht.$$.fragment,e),M(Et.$$.fragment,e),M(k.$$.fragment,e),M(qt.$$.fragment,e),M(Dt.$$.fragment,e),M(C.$$.fragment,e),M(ll.$$.fragment,e),M(nl.$$.fragment,e),M(Z.$$.fragment,e),M(rl.$$.fragment,e),M(ol.$$.fragment,e),M(I.$$.fragment,e),M(ml.$$.fragment,e),M(cl.$$.fragment,e),M(fl.$$.fragment,e),gn=!0)},o(e){d(T.$$.fragment,e),d(v.$$.fragment,e),d(B.$$.fragment,e),d(W.$$.fragment,e),d(R.$$.fragment,e),d(G.$$.fragment,e),d(Y.$$.fragment,e),d(F.$$.fragment,e),d(z.$$.fragment,e),d(N.$$.fragment,e),d(E.$$.fragment,e),d(L.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),d(Me.$$.fragment,e),d(de.$$.fragment,e),d(ce.$$.fragment,e),d(ye.$$.fragment,e),d(Je.$$.fragment,e),d(be.$$.fragment,e),d(je.$$.fragment,e),d(Te.$$.fragment,e),d(U.$$.fragment,e),d(Ce.$$.fragment,e),d(Ie.$$.fragment,e),d(Be.$$.fragment,e),d(Xe.$$.fragment,e),d(Re.$$.fragment,e),d(Ve.$$.fragment,e),d(Ye.$$.fragment,e),d(ze.$$.fragment,e),d(Qe.$$.fragment,e),d(Se.$$.fragment,e),d(Le.$$.fragment,e),d(et.$$.fragment,e),d(tt.$$.fragment,e),d(st.$$.fragment,e),d(at.$$.fragment,e),d(it.$$.fragment,e),d(ot.$$.fragment,e),d(ht.$$.fragment,e),d(Mt.$$.fragment,e),d(ct.$$.fragment,e),d(Jt.$$.fragment,e),d(ft.$$.fragment,e),d(g.$$.fragment,e),d(Ut.$$.fragment,e),d($t.$$.fragment,e),d(kt.$$.fragment,e),d(It.$$.fragment,e),d(vt.$$.fragment,e),d($.$$.fragment,e),d(Wt.$$.fragment,e),d(Rt.$$.fragment,e),d(xt.$$.fragment,e),d(Vt.$$.fragment,e),d(Yt.$$.fragment,e),d(At.$$.fragment,e),d(zt.$$.fragment,e),d(Ht.$$.fragment,e),d(Et.$$.fragment,e),d(k.$$.fragment,e),d(qt.$$.fragment,e),d(Dt.$$.fragment,e),d(C.$$.fragment,e),d(ll.$$.fragment,e),d(nl.$$.fragment,e),d(Z.$$.fragment,e),d(rl.$$.fragment,e),d(ol.$$.fragment,e),d(I.$$.fragment,e),d(ml.$$.fragment,e),d(cl.$$.fragment,e),d(fl.$$.fragment,e),gn=!1},d(e){e&&(l(J),l(w),l(b),l(gl),l($l),l(kl),l(Cl),l(X),l(Zl),l(Il),l(vl),l(x),l(Bl),l(V),l(Wl),l(_),l(Xl),l(Rl),l(A),l(Gl),l(xl),l(Vl),l(H),l(_l),l(Q),l(Yl),l(Al),l(Fl),l(S),l(zl),l(q),l(Hl),l(Ql),l(D),l(Nl),l(El),l(K),l(Sl),l(ql),l(ee),l(Ll),l(te),l(Dl),l(Pl),l(Kl),l(ae),l(Ol),l(es),l(ts),l(re),l(ls),l(ss),l(as),l(he),l(ns),l(me),l(is),l(rs),l(os),l(ue),l(ps),l(hs),l(ms),l(we),l(Ms),l(ds),l(us),l(fe),l(cs),l(ys),l(ws),l(Ue),l(Js),l(ge),l(bs),l(fs),l($e),l(js),l(ke),l(Ts),l(Us),l(Ze),l(gs),l($s),l(ve),l(ks),l(Cs),l(We),l(Zs),l(Is),l(vs),l(Ge),l(Bs),l(xe),l(Ws),l(Xs),l(_e),l(Rs),l(Gs),l(Ae),l(xs),l(Fe),l(Vs),l(_s),l(He),l(Ys),l(As),l(Ne),l(Fs),l(Ee),l(zs),l(Hs),l(qe),l(Qs),l(Ns),l(De),l(Es),l(Pe),l(Ss),l(Ke),l(qs),l(Oe),l(Ls),l(Ds),l(Ps),l(lt),l(Ks),l(Os),l(ea),l(nt),l(ta),l(la),l(rt),l(sa),l(aa),l(pt),l(na),l(ia),l(mt),l(ra),l(oa),l(dt),l(pa),l(ut),l(ha),l(ma),l(yt),l(Ma),l(wt),l(da),l(ua),l(bt),l(ca),l(ya),l(jt),l(wa),l(Tt),l(Ja),l(ba),l(fa),l(gt),l(ja),l(Ta),l(Ua),l(Ct),l(ga),l(Zt),l($a),l(ka),l(Ca),l(Za),l(Bt),l(Ia),l(va),l(Xt),l(Ba),l(Wa),l(Gt),l(Xa),l(Ra),l(Ga),l(_t),l(xa),l(Va),l(_a),l(Ft),l(Ya),l(Aa),l(Fa),l(Qt),l(za),l(Nt),l(Ha),l(Qa),l(St),l(Na),l(Ea),l(Sa),l(Lt),l(qa),l(La),l(Pt),l(Da),l(Kt),l(Pa),l(Ka),l(Ot),l(Oa),l(el),l(en),l(tl),l(tn),l(ln),l(sl),l(sn),l(al),l(an),l(nn),l(rn),l(il),l(on),l(pn),l(hn),l(pl),l(mn),l(hl),l(Mn),l(dn),l(un),l(Ml),l(cn),l(dl),l(yn),l(ul),l(wn),l(Jn),l(yl),l(bn),l(wl),l(fn),l(Jl),l(jn),l(bl),l(Tn),l(Un),l(Ul)),l(c),u(T,e),u(v,e),u(B,e),u(W,e),u(R,e),u(G,e),u(Y,e),u(F,e),u(z,e),u(N,e),u(E,e),u(L,e),u(P,e),u(O,e),u(le,e),u(se,e),u(ne,e),u(ie,e),u(oe,e),u(pe,e),u(Me,e),u(de,e),u(ce,e),u(ye,e),u(Je,e),u(be,e),u(je,e),u(Te,e),u(U,e),u(Ce,e),u(Ie,e),u(Be,e),u(Xe,e),u(Re,e),u(Ve,e),u(Ye,e),u(ze,e),u(Qe,e),u(Se,e),u(Le,e),u(et,e),u(tt,e),u(st,e),u(at,e),u(it,e),u(ot,e),u(ht,e),u(Mt,e),u(ct,e),u(Jt,e),u(ft,e),u(g,e),u(Ut,e),u($t,e),u(kt,e),u(It,e),u(vt,e),u($,e),u(Wt,e),u(Rt,e),u(xt,e),u(Vt,e),u(Yt,e),u(At,e),u(zt,e),u(Ht,e),u(Et,e),u(k,e),u(qt,e),u(Dt,e),u(C,e),u(ll,e),u(nl,e),u(Z,e),u(rl,e),u(ol,e),u(I,e),u(ml,e),u(cl,e),u(fl,e)}}}const Cr='{"title":"Debugging the training pipeline","local":"debugging-the-training-pipeline","sections":[{"title":"Debugging the training pipeline","local":"debugging-the-training-pipeline","sections":[{"title":"Check your data","local":"check-your-data","sections":[],"depth":3},{"title":"From datasets to dataloaders","local":"from-datasets-to-dataloaders","sections":[],"depth":3},{"title":"Going through the model","local":"going-through-the-model","sections":[],"depth":3},{"title":"Performing one optimization step","local":"performing-one-optimization-step","sections":[],"depth":3},{"title":"Dealing with CUDA out-of-memory errors","local":"dealing-with-cuda-out-of-memory-errors","sections":[],"depth":3},{"title":"Evaluating the model","local":"evaluating-the-model","sections":[],"depth":3}],"depth":2},{"title":"Debugging silent errors during training","local":"debugging-silent-errors-during-training","sections":[{"title":"Check your data (again!)","local":"check-your-data-again","sections":[],"depth":3},{"title":"Overfit your model on one batch","local":"overfit-your-model-on-one-batch","sections":[],"depth":3},{"title":"Don’t tune anything until you have a first baseline","local":"dont-tune-anything-until-you-have-a-first-baseline","sections":[],"depth":3},{"title":"Ask for help","local":"ask-for-help","sections":[],"depth":3}],"depth":2}],"depth":1}';function Zr(f,c,J){let w="pt";return pr(()=>{const b=new URLSearchParams(window.location.search);J(0,w=b.get("fw")||"pt")}),[w]}class Vr extends hr{constructor(c){super(),mr(this,c,Zr,kr,or,{})}}export{Vr as component};
