import{s as Zt,o as zt,n as Gt}from"../chunks/scheduler.cc52f4b9.js";import{S as Rt,i as Ht,e as o,s as l,c as u,h as Wt,a as r,d as n,b as a,f as Ut,g as p,j as M,k as _t,l as Et,m as s,n as c,t as d,o as m,p as f}from"../chunks/index.9480bb2b.js";import{T as Ct}from"../chunks/Tip.f7b80743.js";import{C as xt,H as st,E as Ft}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.04d617be.js";import{Y as It}from"../chunks/Youtube.7b12d9e8.js";import{C as v}from"../chunks/CodeBlock.f4148b32.js";import{C as Xt}from"../chunks/CourseFloatingBanner.cdc38ef1.js";import{F as Vt}from"../chunks/FrameworkSwitchCourse.42d12053.js";function Lt(J){let i,$='💡 Si vous voulez télécharger automatiquement votre modèle sur le <em>Hub</em> pendant l’entraînement, passez <code>push_to_hub=True</code> dans le <code>TrainingArguments</code>. Nous en apprendrons plus à ce sujet au <a href="/course/fr/chapter4/3">chapitre 4</a>.';return{c(){i=o("p"),i.innerHTML=$},l(b){i=r(b,"P",{"data-svelte-h":!0}),M(i)!=="svelte-pjt16k"&&(i.innerHTML=$)},m(b,h){s(b,i,h)},p:Gt,d(b){b&&n(i)}}}function Bt(J){let i,$="✏️ <strong>Essayez !</strong> <em>Finetunez</em> un modèle sur le jeu de données GLUE SST-2, en utilisant le traitement des données que vous avez fait dans la section 2.";return{c(){i=o("p"),i.innerHTML=$},l(b){i=r(b,"P",{"data-svelte-h":!0}),M(i)!=="svelte-8jszuf"&&(i.innerHTML=$)},m(b,h){s(b,i,h)},p:Gt,d(b){b&&n(i)}}}function Yt(J){let i,$,b,h,T,de,g,me,w,fe,q,Me,k,be,U,lt='La bibliothèque 🤗 <em>Transformers</em> fournit une classe <code>Trainer</code> pour vous aider à <em>finetuner</em> n’importe lequel des modèles pré-entraînés qu’elle met à disposition sur votre jeu de données. Une fois que vous avez fait tout le travail de prétraitement des données dans la dernière section, il ne vous reste que quelques étapes pour définir le <code>Trainer</code>. La partie la plus difficile sera probablement de préparer l’environnement pour exécuter <code>Trainer.train()</code>, car elle fonctionnera très lentement sur un CPU. Si vous n’avez pas de GPU, vous pouvez avoir accès à des GPUs ou TPUs gratuits sur <a href="https://colab.research.google.com/" rel="nofollow">Google Colab</a>.',ve,_,at="Les exemples de code ci-dessous supposent que vous avez déjà exécuté les exemples de la section précédente. Voici un bref résumé de ce dont vous avez besoin :",$e,C,he,G,Te,Z,ot="La première étape avant de pouvoir définir notre <code>Trainer</code> est de définir une classe <code>TrainingArguments</code> qui contiendra tous les hyperparamètres que le <code>Trainer</code> utilisera pour l’entraînement et l’évaluation. Le seul argument que vous devez fournir est un répertoire où le modèle entraîné sera sauvegardé, ainsi que les <em>checkpoints</em>. Pour tout le reste, vous pouvez laisser les valeurs par défaut, qui devraient fonctionner assez bien pour un <em>finetuning</em> de base.",je,z,ye,j,Je,R,rt='La deuxième étape consiste à définir notre modèle. Comme dans le <a href="/course/fr/chapter2">chapitre précédent</a>, nous utiliserons la classe <code>AutoModelForSequenceClassification</code>, avec deux labels :',ge,H,we,W,it='Vous remarquerez que contrairement au <a href="/course/fr/chapter2">chapitre 2</a>, vous obtenez un message d’avertissement après l’instanciation de ce modèle pré-entraîné. C’est parce que BERT n’a pas été pré-entraîné à la classification de paires de phrases, donc la tête du modèle pré-entraîné a été supprimée et une nouvelle tête adaptée à la classification de séquences a été ajoutée à la place. Les messages d’avertissement indiquent que certains poids n’ont pas été utilisés (ceux correspondant à la tête de pré-entraînement abandonnée) et que d’autres ont été initialisés de manière aléatoire (ceux pour la nouvelle tête). Il conclut en vous encourageant à entraîner le modèle, ce qui est exactement ce que nous allons faire maintenant.',qe,E,ut="Une fois que nous avons notre modèle, nous pouvons définir un <code>Trainer</code> en lui passant tous les objets construits jusqu’à présent : le <code>model</code>, le <code>training_args</code>, les jeux de données d’entraînement et de validation, notre <code>data_collator</code>, et notre <code>tokenizer</code> :",ke,x,Ue,F,pt="Notez que lorsque vous passez le <code>tokenizer</code> comme nous l’avons fait ici, le <code>data_collator</code> par défaut utilisé par le <code>Trainer</code> sera un <code>DataCollatorWithPadding</code> comme défini précédemment. Ainsi, vous pouvez sauter la ligne <code>data_collator=data_collator</code> dans cet appel. Il était quand même important de vous montrer cette partie du traitement dans la section 2 !",_e,I,ct="Pour <em>finetuner</em> le modèle sur notre jeu de données, il suffit d’appeler la méthode <code>train()</code> de notre <code>Trainer</code> :",Ce,X,Ge,V,dt="Cela lancera le <em>finetuning</em> (qui devrait prendre quelques minutes sur un GPU) et indiquera la perte d’entraînement tous les 500 pas. Cependant, elle ne vous dira pas si votre modèle fonctionne bien (ou mal). Ceci est dû au fait que :",Ze,L,mt="<li>nous n’avons pas dit au <code>Trainer</code> d’évaluer pendant l’entraînement en réglant <code>evaluation_strategy</code> à soit <code>&quot;steps&quot;</code> (évaluer chaque <code>eval_steps</code>) ou <code>&quot;epoch&quot;</code> (évaluer à la fin de chaque <em>epoch</em>).</li> <li>nous n’avons pas fourni au <code>Trainer</code> une fonction <code>compute_metrics()</code> pour calculer une métrique pendant ladite évaluation (sinon l’évaluation aurait juste affiché la perte, qui n’est pas un nombre très intuitif).</li>",ze,B,Re,Y,ft="Voyons comment nous pouvons construire une fonction <code>compute_metrics()</code> utile et l’utiliser la prochaine fois que nous entraînons. La fonction doit prendre un objet <code>EvalPrediction</code> (qui est un <em>tuple</em> nommé avec un champ <code>predictions</code> et un champ <code>label_ids</code>) et retournera un dictionnaire de chaînes de caractères vers des flottants (les chaînes de caractères étant les noms des métriques retournées, et les flottants leurs valeurs). Pour obtenir des prédictions de notre modèle, nous pouvons utiliser la commande <code>Trainer.predict()</code> :",He,N,We,A,Ee,Q,Mt="La sortie de la méthode <code>predict()</code> est un autre <em>tuple</em> nommé avec trois champs : <code>predictions</code>, <code>label_ids</code>, et <code>metrics</code>. Le champ <code>metrics</code> contiendra juste la perte sur le jeu de données passé, ainsi que quelques mesures de temps (combien de temps il a fallu pour prédire, au total et en moyenne). Une fois que nous aurons complété notre fonction <code>compute_metrics()</code> et que nous l’aurons passé au <code>Trainer</code>, ce champ contiendra également les métriques retournées par <code>compute_metrics()</code>.",xe,P,bt='Comme vous pouvez le voir, <code>predictions</code> est un tableau bidimensionnel de forme 408 x 2 (408 étant le nombre d’éléments dans le jeu de données que nous avons utilisé). Ce sont les logits pour chaque élément du jeu de données que nous avons passé à <code>predict()</code> (comme vous l’avez vu dans le <a href="/course/fr/chapter2">chapitre précédent</a>, tous les <em>transformers</em> retournent des logits). Pour les transformer en prédictions que nous pouvons comparer à nos étiquettes, nous devons prendre l’indice avec la valeur maximale sur le second axe :',Fe,S,Ie,K,vt='Nous pouvons maintenant comparer ces <code>preds</code> aux étiquettes. Pour construire notre fonction <code>compute_metric()</code>, nous allons nous appuyer sur les métriques de la bibliothèque 🤗 <a href="https://github.com/huggingface/evaluate/" rel="nofollow"><em>Evaluate</em></a>. Nous pouvons charger les métriques associées au jeu de données MRPC aussi facilement que nous avons chargé le jeu de données, cette fois avec la fonction <code>evaluate.load()</code>. L’objet retourné possède une méthode <code>compute()</code> que nous pouvons utiliser pour effectuer le calcul de la métrique :',Xe,D,Ve,O,Le,ee,$t='Les résultats exacts que vous obtiendrez peuvent varier, car l’initialisation aléatoire de la tête du modèle peut modifier les métriques obtenues. Ici, nous pouvons voir que notre modèle a une précision de 85,78% sur l’ensemble de validation et un score F1 de 89,97. Ce sont les deux métriques utilisées pour évaluer les résultats sur le jeu de données MRPC pour le benchmark GLUE. Le tableau du papier de <a href="https://arxiv.org/pdf/1810.04805.pdf" rel="nofollow">BERT</a> indique un score F1 de 88,9 pour le modèle de base. Il s’agissait du modèle <code>uncased</code> alors que nous utilisons actuellement le modèle <code>cased</code>, ce qui explique le meilleur résultat.',Be,te,ht="En regroupant le tout, nous obtenons notre fonction <code>compute_metrics()</code> :",Ye,ne,Ne,se,Tt="Et pour le voir utilisé en action pour rapporter les métriques à la fin de chaque époque, voici comment nous définissons un nouveau <code>Trainer</code> avec cette fonction <code>compute_metrics()</code> :",Ae,le,Qe,ae,jt="Notez que nous créons un nouveau <code>TrainingArguments</code> avec sa <code>evaluation_strategy</code> définie sur <code>&quot;epoch&quot;</code> et un nouveau modèle. Sinon, nous ne ferions que continuer l’entraînement du modèle que nous avons déjà entraîné. Pour lancer un nouveau cycle d’entraînement, nous exécutons :",Pe,oe,Se,re,yt="Cette fois, il indiquera la perte et les mesures de validation à la fin de chaque époque, en plus de la perte d’entraînement. Encore une fois, le score exact de précision/F1 que vous atteignez peut être un peu différent de ce que nous avons trouvé, en raison de l’initialisation aléatoire de la tête du modèle, mais il devrait être dans la même fourchette.",Ke,ie,Jt="Le <code>Trainer</code> fonctionnera sur plusieurs GPUs ou TPUs et fournit beaucoup d’options, comme l’entraînement en précision mixte (utilisez <code>fp16 = True</code> dans vos arguments d’entraînement). Nous passerons en revue tout ce qu’il supporte dans le chapitre 10.",De,ue,gt='Ceci conclut l’introduction au <em>fine-tuning</em> en utilisant l’API <code>Trainer</code>. Un exemple d’utilisation pour les tâches de NLP les plus communes es donné dans le <a href="/course/fr/chapter7">chapitre 7</a>, mais pour l’instant regardons comment faire la même chose en PyTorch pur.',Oe,y,et,pe,tt,ce,nt;return T=new Vt({props:{fw:J[0]}}),g=new xt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new st({props:{title:"<i> Finetuner </i> un modèle avec l’API Trainer",local:"i-finetuner-i-un-modèle-avec-lapi-trainer",headingTag:"h1"}}),q=new Xt({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"English",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section3.ipynb"},{label:"Français",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fr/chapter3/section3.ipynb"},{label:"English",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section3.ipynb"},{label:"Français",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fr/chapter3/section3.ipynb"}]}}),k=new It({props:{id:"nvBXf7s7vTI"}}),C=new v({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),G=new st({props:{title:"Entraînement",local:"entraînement",headingTag:"h3"}}),z=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>)`,wrap:!1}}),j=new Ct({props:{$$slots:{default:[Lt]},$$scope:{ctx:J}}}),H=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),x=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
)`,wrap:!1}}),X=new v({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),B=new st({props:{title:"Evaluation",local:"evaluation",headingTag:"h3"}}),N=new v({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjB0cmFpbmVyLnByZWRpY3QodG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCklMEFwcmludChwcmVkaWN0aW9ucy5wcmVkaWN0aW9ucy5zaGFwZSUyQyUyMHByZWRpY3Rpb25zLmxhYmVsX2lkcy5zaGFwZSk=",highlighted:`predictions = trainer.predict(tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>])
<span class="hljs-built_in">print</span>(predictions.predictions.shape, predictions.label_ids.shape)`,wrap:!1}}),A=new v({props:{code:"KDQwOCUyQyUyMDIpJTIwKDQwOCUyQyk=",highlighted:'(<span class="hljs-number">408</span>, <span class="hljs-number">2</span>) (<span class="hljs-number">408</span>,)',wrap:!1}}),S=new v({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcHJlZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZGljdGlvbnMucHJlZGljdGlvbnMlMkMlMjBheGlzJTNELTEp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

preds = np.argmax(predictions.predictions, axis=-<span class="hljs-number">1</span>)`,wrap:!1}}),D=new v({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZHMlMkMlMjByZWZlcmVuY2VzJTNEcHJlZGljdGlvbnMubGFiZWxfaWRzKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
metric.compute(predictions=preds, references=predictions.label_ids)`,wrap:!1}}),O=new v({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODU3ODQzMTM3MjU0OTAxOSUyQyUyMCdmMSclM0ElMjAwLjg5OTY1Mzk3OTIzODc1NDIlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8578431372549019</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8996539792387542</span>}',wrap:!1}}),ne=new v({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZHMpJTNBJTBBJTIwJTIwJTIwJTIwbWV0cmljJTIwJTNEJTIwZXZhbHVhdGUubG9hZCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBucC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEbGFiZWxzKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_preds</span>):
    metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
    logits, labels = eval_preds
    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),le=new v({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMiUyQyUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEp",highlighted:`training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>, evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),oe=new v({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'trainer.trai<span class="hljs-meta">n</span>()',wrap:!1}}),y=new Ct({props:{$$slots:{default:[Bt]},$$scope:{ctx:J}}}),pe=new Ft({props:{source:"https://github.com/huggingface/course/blob/main/chapters/fr/chapter3/3.mdx"}}),{c(){i=o("meta"),$=l(),b=o("p"),h=l(),u(T.$$.fragment),de=l(),u(g.$$.fragment),me=l(),u(w.$$.fragment),fe=l(),u(q.$$.fragment),Me=l(),u(k.$$.fragment),be=l(),U=o("p"),U.innerHTML=lt,ve=l(),_=o("p"),_.textContent=at,$e=l(),u(C.$$.fragment),he=l(),u(G.$$.fragment),Te=l(),Z=o("p"),Z.innerHTML=ot,je=l(),u(z.$$.fragment),ye=l(),u(j.$$.fragment),Je=l(),R=o("p"),R.innerHTML=rt,ge=l(),u(H.$$.fragment),we=l(),W=o("p"),W.innerHTML=it,qe=l(),E=o("p"),E.innerHTML=ut,ke=l(),u(x.$$.fragment),Ue=l(),F=o("p"),F.innerHTML=pt,_e=l(),I=o("p"),I.innerHTML=ct,Ce=l(),u(X.$$.fragment),Ge=l(),V=o("p"),V.innerHTML=dt,Ze=l(),L=o("ol"),L.innerHTML=mt,ze=l(),u(B.$$.fragment),Re=l(),Y=o("p"),Y.innerHTML=ft,He=l(),u(N.$$.fragment),We=l(),u(A.$$.fragment),Ee=l(),Q=o("p"),Q.innerHTML=Mt,xe=l(),P=o("p"),P.innerHTML=bt,Fe=l(),u(S.$$.fragment),Ie=l(),K=o("p"),K.innerHTML=vt,Xe=l(),u(D.$$.fragment),Ve=l(),u(O.$$.fragment),Le=l(),ee=o("p"),ee.innerHTML=$t,Be=l(),te=o("p"),te.innerHTML=ht,Ye=l(),u(ne.$$.fragment),Ne=l(),se=o("p"),se.innerHTML=Tt,Ae=l(),u(le.$$.fragment),Qe=l(),ae=o("p"),ae.innerHTML=jt,Pe=l(),u(oe.$$.fragment),Se=l(),re=o("p"),re.textContent=yt,Ke=l(),ie=o("p"),ie.innerHTML=Jt,De=l(),ue=o("p"),ue.innerHTML=gt,Oe=l(),u(y.$$.fragment),et=l(),u(pe.$$.fragment),tt=l(),ce=o("p"),this.h()},l(e){const t=Wt("svelte-u9bgzb",document.head);i=r(t,"META",{name:!0,content:!0}),t.forEach(n),$=a(e),b=r(e,"P",{}),Ut(b).forEach(n),h=a(e),p(T.$$.fragment,e),de=a(e),p(g.$$.fragment,e),me=a(e),p(w.$$.fragment,e),fe=a(e),p(q.$$.fragment,e),Me=a(e),p(k.$$.fragment,e),be=a(e),U=r(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-pje9qd"&&(U.innerHTML=lt),ve=a(e),_=r(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-14eako"&&(_.textContent=at),$e=a(e),p(C.$$.fragment,e),he=a(e),p(G.$$.fragment,e),Te=a(e),Z=r(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-3f38pc"&&(Z.innerHTML=ot),je=a(e),p(z.$$.fragment,e),ye=a(e),p(j.$$.fragment,e),Je=a(e),R=r(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-y5v80"&&(R.innerHTML=rt),ge=a(e),p(H.$$.fragment,e),we=a(e),W=r(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1mjubu3"&&(W.innerHTML=it),qe=a(e),E=r(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1osogjj"&&(E.innerHTML=ut),ke=a(e),p(x.$$.fragment,e),Ue=a(e),F=r(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-auwxcq"&&(F.innerHTML=pt),_e=a(e),I=r(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1rwh0g0"&&(I.innerHTML=ct),Ce=a(e),p(X.$$.fragment,e),Ge=a(e),V=r(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-155zod"&&(V.innerHTML=dt),Ze=a(e),L=r(e,"OL",{"data-svelte-h":!0}),M(L)!=="svelte-13ssqmi"&&(L.innerHTML=mt),ze=a(e),p(B.$$.fragment,e),Re=a(e),Y=r(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-md0pgp"&&(Y.innerHTML=ft),He=a(e),p(N.$$.fragment,e),We=a(e),p(A.$$.fragment,e),Ee=a(e),Q=r(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-16549h0"&&(Q.innerHTML=Mt),xe=a(e),P=r(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-trb3vz"&&(P.innerHTML=bt),Fe=a(e),p(S.$$.fragment,e),Ie=a(e),K=r(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-ijdw5p"&&(K.innerHTML=vt),Xe=a(e),p(D.$$.fragment,e),Ve=a(e),p(O.$$.fragment,e),Le=a(e),ee=r(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-1l4etp7"&&(ee.innerHTML=$t),Be=a(e),te=r(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-ql1ucp"&&(te.innerHTML=ht),Ye=a(e),p(ne.$$.fragment,e),Ne=a(e),se=r(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-9vjx55"&&(se.innerHTML=Tt),Ae=a(e),p(le.$$.fragment,e),Qe=a(e),ae=r(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-5sabrn"&&(ae.innerHTML=jt),Pe=a(e),p(oe.$$.fragment,e),Se=a(e),re=r(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-u2e3sn"&&(re.textContent=yt),Ke=a(e),ie=r(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-139u89k"&&(ie.innerHTML=Jt),De=a(e),ue=r(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-17e3730"&&(ue.innerHTML=gt),Oe=a(e),p(y.$$.fragment,e),et=a(e),p(pe.$$.fragment,e),tt=a(e),ce=r(e,"P",{}),Ut(ce).forEach(n),this.h()},h(){_t(i,"name","hf:doc:metadata"),_t(i,"content",Nt)},m(e,t){Et(document.head,i),s(e,$,t),s(e,b,t),s(e,h,t),c(T,e,t),s(e,de,t),c(g,e,t),s(e,me,t),c(w,e,t),s(e,fe,t),c(q,e,t),s(e,Me,t),c(k,e,t),s(e,be,t),s(e,U,t),s(e,ve,t),s(e,_,t),s(e,$e,t),c(C,e,t),s(e,he,t),c(G,e,t),s(e,Te,t),s(e,Z,t),s(e,je,t),c(z,e,t),s(e,ye,t),c(j,e,t),s(e,Je,t),s(e,R,t),s(e,ge,t),c(H,e,t),s(e,we,t),s(e,W,t),s(e,qe,t),s(e,E,t),s(e,ke,t),c(x,e,t),s(e,Ue,t),s(e,F,t),s(e,_e,t),s(e,I,t),s(e,Ce,t),c(X,e,t),s(e,Ge,t),s(e,V,t),s(e,Ze,t),s(e,L,t),s(e,ze,t),c(B,e,t),s(e,Re,t),s(e,Y,t),s(e,He,t),c(N,e,t),s(e,We,t),c(A,e,t),s(e,Ee,t),s(e,Q,t),s(e,xe,t),s(e,P,t),s(e,Fe,t),c(S,e,t),s(e,Ie,t),s(e,K,t),s(e,Xe,t),c(D,e,t),s(e,Ve,t),c(O,e,t),s(e,Le,t),s(e,ee,t),s(e,Be,t),s(e,te,t),s(e,Ye,t),c(ne,e,t),s(e,Ne,t),s(e,se,t),s(e,Ae,t),c(le,e,t),s(e,Qe,t),s(e,ae,t),s(e,Pe,t),c(oe,e,t),s(e,Se,t),s(e,re,t),s(e,Ke,t),s(e,ie,t),s(e,De,t),s(e,ue,t),s(e,Oe,t),c(y,e,t),s(e,et,t),c(pe,e,t),s(e,tt,t),s(e,ce,t),nt=!0},p(e,[t]){const wt={};t&1&&(wt.fw=e[0]),T.$set(wt);const qt={};t&2&&(qt.$$scope={dirty:t,ctx:e}),j.$set(qt);const kt={};t&2&&(kt.$$scope={dirty:t,ctx:e}),y.$set(kt)},i(e){nt||(d(T.$$.fragment,e),d(g.$$.fragment,e),d(w.$$.fragment,e),d(q.$$.fragment,e),d(k.$$.fragment,e),d(C.$$.fragment,e),d(G.$$.fragment,e),d(z.$$.fragment,e),d(j.$$.fragment,e),d(H.$$.fragment,e),d(x.$$.fragment,e),d(X.$$.fragment,e),d(B.$$.fragment,e),d(N.$$.fragment,e),d(A.$$.fragment,e),d(S.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(ne.$$.fragment,e),d(le.$$.fragment,e),d(oe.$$.fragment,e),d(y.$$.fragment,e),d(pe.$$.fragment,e),nt=!0)},o(e){m(T.$$.fragment,e),m(g.$$.fragment,e),m(w.$$.fragment,e),m(q.$$.fragment,e),m(k.$$.fragment,e),m(C.$$.fragment,e),m(G.$$.fragment,e),m(z.$$.fragment,e),m(j.$$.fragment,e),m(H.$$.fragment,e),m(x.$$.fragment,e),m(X.$$.fragment,e),m(B.$$.fragment,e),m(N.$$.fragment,e),m(A.$$.fragment,e),m(S.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(ne.$$.fragment,e),m(le.$$.fragment,e),m(oe.$$.fragment,e),m(y.$$.fragment,e),m(pe.$$.fragment,e),nt=!1},d(e){e&&(n($),n(b),n(h),n(de),n(me),n(fe),n(Me),n(be),n(U),n(ve),n(_),n($e),n(he),n(Te),n(Z),n(je),n(ye),n(Je),n(R),n(ge),n(we),n(W),n(qe),n(E),n(ke),n(Ue),n(F),n(_e),n(I),n(Ce),n(Ge),n(V),n(Ze),n(L),n(ze),n(Re),n(Y),n(He),n(We),n(Ee),n(Q),n(xe),n(P),n(Fe),n(Ie),n(K),n(Xe),n(Ve),n(Le),n(ee),n(Be),n(te),n(Ye),n(Ne),n(se),n(Ae),n(Qe),n(ae),n(Pe),n(Se),n(re),n(Ke),n(ie),n(De),n(ue),n(Oe),n(et),n(tt),n(ce)),n(i),f(T,e),f(g,e),f(w,e),f(q,e),f(k,e),f(C,e),f(G,e),f(z,e),f(j,e),f(H,e),f(x,e),f(X,e),f(B,e),f(N,e),f(A,e),f(S,e),f(D,e),f(O,e),f(ne,e),f(le,e),f(oe,e),f(y,e),f(pe,e)}}}const Nt='{"title":"<i> Finetuner </i> un modèle avec l’API Trainer","local":"i-finetuner-i-un-modèle-avec-lapi-trainer","sections":[{"title":"Entraînement","local":"entraînement","sections":[],"depth":3},{"title":"Evaluation","local":"evaluation","sections":[],"depth":3}],"depth":1}';function At(J,i,$){let b="pt";return zt(()=>{const h=new URLSearchParams(window.location.search);$(0,b=h.get("fw")||"pt")}),[b]}class nn extends Rt{constructor(i){super(),Ht(this,i,At,Yt,Zt,{})}}export{nn as component};
