import{s as vs,o as Zs,n as Cs}from"../chunks/scheduler.cc52f4b9.js";import{S as Is,i as $s,e as c,s as a,c as r,h as Bs,a as M,d as s,b as n,f as Js,g as i,j as d,k as ws,l as gs,m as t,n as p,t as o,o as m,p as u,q as Us,r as hs}from"../chunks/index.9480bb2b.js";import{T as Ts}from"../chunks/Tip.f7b80743.js";import{C as Gs,H as ke,E as ks}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.04d617be.js";import{Y as fs}from"../chunks/Youtube.7b12d9e8.js";import{C as y}from"../chunks/CodeBlock.f4148b32.js";import{C as Xs}from"../chunks/CourseFloatingBanner.cdc38ef1.js";function Ws(ge){let b,J="✏️ <strong>Essayez</strong> Modifiez la boucle d’entraînement précédente pour <em>finetuner</em> votre modèle sur le jeu de données SST-2.";return{c(){b=c("p"),b.innerHTML=J},l(w){b=M(w,"P",{"data-svelte-h":!0}),d(b)!=="svelte-1dfxuon"&&(b.innerHTML=J)},m(w,U){t(w,b,U)},p:Cs,d(w){w&&s(b)}}}function Rs(ge){let b,J,w="tokenizer",U;return{c(){b=Us('⚠️ Afin de bénéficier de la rapidité offerte par les TPUs du Cloud, nous vous recommandons de rembourrer vos échantillons à une longueur fixe avec les arguments `padding="max_length"` et `max_length` du '),J=c("i"),J.textContent=w,U=Us(".")},l(j){b=hs(j,'⚠️ Afin de bénéficier de la rapidité offerte par les TPUs du Cloud, nous vous recommandons de rembourrer vos échantillons à une longueur fixe avec les arguments `padding="max_length"` et `max_length` du '),J=M(j,"I",{"data-svelte-h":!0}),d(J)!=="svelte-ymquwj"&&(J.textContent=w),U=hs(j,".")},m(j,h){t(j,b,h),t(j,J,h),t(j,U,h)},p:Cs,d(j){j&&(s(b),s(J),s(U))}}}function _s(ge){let b,J,w,U,j,h,C,Xe,v,We,Z,Re,I,El="Maintenant nous allons voir comment obtenir les mêmes résultats que dans la dernière section sans utiliser la classe <code>Trainer</code>. Encore une fois, nous supposons que vous avez fait le traitement des données dans la section 2. Voici un court résumé couvrant tout ce dont vous aurez besoin :",_e,$,Ye,B,Ve,g,xl="Avant d’écrire réellement notre boucle d’entraînement, nous devons définir quelques objets. Les premiers sont les <em>dataloaders</em> que nous utiliserons pour itérer sur les batchs. Mais avant de pouvoir définir ces chargeurs de données, nous devons appliquer un peu de post-traitement à nos <code>tokenized_datasets</code>, pour prendre soin de certaines choses que le <code>Trainer</code> fait pour nous automatiquement. Spécifiquement, nous devons :",Ae,G,Fl="<li>supprimer les colonnes correspondant aux valeurs que le modèle n’attend pas (comme les colonnes <code>sentence1</code> et <code>sentence2</code>),</li> <li>renommer la colonne <code>label</code> en <code>labels</code> (parce que le modèle s’attend à ce que l’argument soit nommé <code>labels</code>),</li> <li>définir le format des jeux de données pour qu’ils retournent des tenseurs PyTorch au lieu de listes.</li>",ze,k,Ql="Notre <code>tokenized_datasets</code> a une méthode pour chacune de ces étapes :",Ne,X,Ee,W,Hl="Nous pouvons alors vérifier que le résultat ne comporte que des colonnes que notre modèle acceptera :",xe,R,Fe,_,ql="Maintenant que cela est fait, nous pouvons facilement définir nos <em>dataloaders</em> :",Qe,Y,He,V,Sl="Pour vérifier rapidement qu’il n’y a pas d’erreur dans le traitement des données, nous pouvons inspecter un batch comme celui-ci :",qe,A,Se,z,Le,N,Ll="Notez que les formes réelles seront probablement légèrement différentes pour vous puisque nous avons défini <code>shuffle=True</code> pour le chargeur de données d’entraînement et que nous <em>paddons</em> à la longueur maximale dans le batch.",Ke,E,Kl="Maintenant que nous en avons terminé avec le prétraitement des données (un objectif satisfaisant mais difficile à atteindre pour tout praticien d’apprentissage automatique), passons au modèle. Nous l’instancions exactement comme nous l’avons fait dans la section précédente :",Pe,x,De,F,Pl="Pour s’assurer que tout se passera bien pendant l’entraînement, nous transmettons notre batch à ce modèle :",Oe,Q,el,H,ll,q,Dl="Tous les modèles 🤗 <em>Transformers</em> renvoient la perte lorsque les <code>labels</code> sont fournis. Nous obtenons également les logits (deux pour chaque entrée de notre batch, donc un tenseur de taille 8 x 2).",sl,S,Ol='Nous sommes presque prêts à écrire notre boucle d’entraînement ! Il nous manque juste deux choses : un optimiseur et un planificateur de taux d’apprentissage. Puisque nous essayons de reproduire à la main ce que fait la fonction <code>Trainer</code>, utilisons les mêmes paramètres par défaut. L’optimiseur utilisé par <code>Trainer</code> est <code>AdamW</code>, qui est le même qu’Adam, mais avec une torsion pour la régularisation par décroissance de poids (voir <a href="https://arxiv.org/abs/1711.05101" rel="nofollow"><em>Decoupled Weight Decay Regularization</em></a> par Ilya Loshchilov et Frank Hutter) :',tl,L,al,K,es="Enfin, le planificateur du taux d’apprentissage utilisé par défaut est juste une décroissance linéaire de la valeur maximale (5e-5) à 0. Pour le définir correctement, nous devons connaître le nombre d’étapes d’entraînement que nous prendrons, qui est le nombre d’époques que nous voulons exécuter multiplié par le nombre de batch d’entraînement (qui est la longueur de notre <em>dataloader</em> d’entraînement). Le <code>Trainer</code> utilise trois époques par défaut, nous allons donc suivre ça :",nl,P,rl,D,il,O,pl,ee,ls="Une dernière chose : nous voulons utiliser le GPU si nous en avons un (sur un CPU, l’entraînement peut prendre plusieurs heures au lieu de quelques minutes). Pour ce faire, nous définissons un <code>device</code> sur lequel nous allons placer notre modèle et nos batchs :",ol,le,ml,se,ul,te,ss="Nous sommes maintenant prêts à entraîner ! Pour avoir une idée du moment où l’entraînement sera terminé, nous ajoutons une barre de progression sur le nombre d’étapes d’entraînement, en utilisant la bibliothèque <code>tqdm</code> :",cl,ae,Ml,ne,ts="Vous pouvez voir que le cœur de la boucle d’entraînement ressemble beaucoup à celui de l’introduction. Nous n’avons pas demandé de rapport, donc cette boucle d’entraînement ne nous dira rien sur les résultats du modèle. Pour cela, nous devons ajouter une boucle d’évaluation.",dl,re,yl,ie,as="Comme nous l’avons fait précédemment, nous allons utiliser une métrique fournie par la bibliothèque 🤗 <em>Evaluate</em>. Nous avons déjà vu la méthode <code>metric.compute()</code>, mais les métriques peuvent en fait accumuler des batchs pour nous au fur et à mesure que nous parcourons la boucle de prédiction avec la méthode <code>add_batch()</code>. Une fois que nous avons accumulé tous les batchs, nous pouvons obtenir le résultat final avec <code>metric.compute()</code>. Voici comment implémenter tout cela dans une boucle d’évaluation :",bl,pe,jl,oe,Jl,me,ns="Une fois encore, vos résultats seront légèrement différents en raison du caractère aléatoire de l’initialisation de la tête du modèle et du mélange des données, mais ils devraient se situer dans la même fourchette.",wl,T,Ul,ue,hl,ce,Tl,Me,rs='La boucle d’entraînement que nous avons définie précédemment fonctionne bien sur un seul CPU ou GPU. Mais en utilisant la bibliothèque <a href="https://github.com/huggingface/accelerate" rel="nofollow">🤗 <em>Accelerate</em></a>, il suffit de quelques ajustements pour permettre un entraînement distribué sur plusieurs GPUs ou TPUs. En partant de la création des <em>dataloaders</em> d’entraînement et de validation, voici à quoi ressemble notre boucle d’entraînement manuel :',fl,de,Cl,ye,is="Et voici les changements :",vl,be,Zl,je,ps="La première ligne à ajouter est la ligne d’importation. La deuxième ligne instancie un objet <code>Accelerator</code> qui va regarder l’environnement et initialiser la bonne configuration distribuée. 🤗 <em>Accelerate</em> gère le placement des périphériques pour vous, donc vous pouvez enlever les lignes qui placent le modèle sur le périphérique (ou, si vous préférez, les changer pour utiliser <code>accelerator.device</code> au lieu de <code>device</code>).",Il,Je,os="Ensuite, le gros du travail est fait dans la ligne qui envoie les <em>dataloaders</em>, le modèle, et l’optimiseur à <code>accelerator.prepare()</code>. Cela va envelopper ces objets dans le conteneur approprié pour s’assurer que votre entraînement distribué fonctionne comme prévu. Les changements restants à faire sont la suppression de la ligne qui met le batch sur le <code>device</code> (encore une fois, si vous voulez le garder, vous pouvez juste le changer pour utiliser <code>accelerator.device</code>) et le remplacement de <code>loss.backward()</code> par <code>accelerator.backward(loss)</code>.",$l,f,Bl,we,ms="Si vous souhaitez faire un copier-coller pour jouer, voici à quoi ressemble la boucle d’entraînement complète avec 🤗 <i>Accelerate</i> :",gl,Ue,Gl,he,us="En plaçant ceci dans un script <code>train.py</code>, cela sera exécutable sur n’importe quel type d’installation distribuée. Pour l’essayer dans votre installation distribuée, exécutez la commande :",kl,Te,Xl,fe,cs="qui vous demandera de répondre à quelques questions et enregistrera vos réponses dans un fichier de configuration utilisé par cette commande :",Wl,Ce,Rl,ve,Ms="qui lancera l’entraînement distribué.",_l,Ze,ds="Si vous voulez essayer ceci dans un <em>notebook</em> (par exemple, pour le tester avec des TPUs sur Colab), collez simplement le code dans une <code>training_function()</code> et lancez une dernière cellule avec :",Yl,Ie,Vl,$e,ys='Vous trouverez d’autres exemples dans le dépôt d’<a href="https://github.com/huggingface/accelerate/tree/main/examples" rel="nofollow">🤗 <em>Accelerate</em></a>.',Al,Be,zl,Ge,Nl;return j=new Gs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new ke({props:{title:"Un entraînement complet",local:"un-entraînement-complet",headingTag:"h1"}}),v=new Xs({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"English",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section4.ipynb"},{label:"Français",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fr/chapter3/section4.ipynb"},{label:"English",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section4.ipynb"},{label:"Français",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fr/chapter3/section4.ipynb"}]}}),Z=new fs({props:{id:"Dh9CL8fyG80"}}),$=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),B=new ke({props:{title:"Préparer l’entraînement",local:"préparer-lentraînement",headingTag:"h3"}}),X=new y({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiUyQyUyMCUyMmlkeCUyMiU1RCklMEF0b2tlbml6ZWRfZGF0YXNldHMlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldHMucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMuc2V0X2Zvcm1hdCglMjJ0b3JjaCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXM=",highlighted:`tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;idx&quot;</span>])
tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)
tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].column_names`,wrap:!1}}),R=new y({props:{code:"JTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RA==",highlighted:'[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>]',wrap:!1}}),Y=new y({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0Q4JTJDJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMEEpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUwQSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

train_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>], shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)
eval_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>], batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)`,wrap:!1}}),A=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBicmVhayUwQSU3QmslM0ElMjB2LnNoYXBlJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
    <span class="hljs-keyword">break</span>
{k: v.shape <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}`,wrap:!1}}),z=new y({props:{code:"JTdCJ2F0dGVudGlvbl9tYXNrJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSUyQyUwQSUyMCdpbnB1dF9pZHMnJTNBJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwNjUlNUQpJTJDJTBBJTIwJ2xhYmVscyclM0ElMjB0b3JjaC5TaXplKCU1QjglNUQpJTJDJTBBJTIwJ3Rva2VuX3R5cGVfaWRzJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSU3RA==",highlighted:`{<span class="hljs-string">&#x27;attention_mask&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: torch.Size([<span class="hljs-number">8</span>]),
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>])}`,wrap:!1}}),x=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),Q=new y({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBcHJpbnQob3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5sb2dpdHMuc2hhcGUp",highlighted:`outputs = model(**batch)
<span class="hljs-built_in">print</span>(outputs.loss, outputs.logits.shape)`,wrap:!1}}),H=new y({props:{code:"dGVuc29yKDAuNTQ0MSUyQyUyMGdyYWRfZm4lM0QlM0NObGxMb3NzQmFja3dhcmQlM0UpJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwMiU1RCk=",highlighted:'tensor(<span class="hljs-number">0.5441</span>, grad_fn=&lt;NllLossBackward&gt;) torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">2</span>])',wrap:!1}}),L=new y({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDVlLTUp",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW

optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),P=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMEElMjAlMjAlMjAlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRG51bV90cmFpbmluZ19zdGVwcyUyQyUwQSklMEFwcmludChudW1fdHJhaW5pbmdfc3RlcHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)
<span class="hljs-built_in">print</span>(num_training_steps)`,wrap:!1}}),D=new y({props:{code:"MTM3Nw==",highlighted:'<span class="hljs-number">1377</span>',wrap:!1}}),O=new ke({props:{title:"La boucle d’entraînement",local:"la-boucle-dentraînement",headingTag:"h3"}}),le=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBZGV2aWNl",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)
device`,wrap:!1}}),se=new y({props:{code:"ZGV2aWNlKHR5cGUlM0QnY3VkYScp",highlighted:'device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;cuda&#x27;</span>)',wrap:!1}}),ae=new y({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),re=new ke({props:{title:"La boucle d’évaluation",local:"la-boucle-dévaluation",headingTag:"h3"}}),pe=new y({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1vZGVsLmV2YWwoKSUwQWZvciUyMGJhdGNoJTIwaW4lMjBldmFsX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2gocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCklMEElMEFtZXRyaWMuY29tcHV0ZSgp",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
model.<span class="hljs-built_in">eval</span>()
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(**batch)

    logits = outputs.logits
    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

metric.compute()`,wrap:!1}}),oe=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODQzMTM3MjU0OTAxOTYwOCUyQyUyMCdmMSclM0ElMjAwLjg5MDc4NDk4MjkzNTE1MzUlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8431372549019608</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8907849829351535</span>}',wrap:!1}}),T=new Ts({props:{$$slots:{default:[Ws]},$$scope:{ctx:ge}}}),ue=new ke({props:{title:"Optimisez votre boucle d’entraînement avec 🤗 <i> Accelerate </i>",local:"optimisez-votre-boucle-dentraînement-avec--i-accelerate-i",headingTag:"h3"}}),ce=new fs({props:{id:"s7dy8QRgjJ0"}}),de=new y({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMGdldF9zY2hlZHVsZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDNlLTUpJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIpJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMHRvcmNoLmRldmljZSglMjJjcHUlMjIpJTBBbW9kZWwudG8oZGV2aWNlKSUwQSUwQW51bV9lcG9jaHMlMjAlM0QlMjAzJTBBbnVtX3RyYWluaW5nX3N0ZXBzJTIwJTNEJTIwbnVtX2Vwb2NocyUyMColMjBsZW4odHJhaW5fZGF0YWxvYWRlciklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),be=new y({props:{code:"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",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from torch.optim import AdamW
  from transformers import AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`,wrap:!1}}),f=new Ts({props:{$$slots:{default:[Rs]},$$scope:{ctx:ge}}}),Ue=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC5vcHRpbSUyMGltcG9ydCUyMEFkYW1XJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),Te=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),Ce=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:'accelerate <span class="hljs-built_in">launch</span> train.py',wrap:!1}}),Ie=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

notebook_launcher(training_function)`,wrap:!1}}),Be=new ks({props:{source:"https://github.com/huggingface/course/blob/main/chapters/fr/chapter3/4.mdx"}}),{c(){b=c("meta"),J=a(),w=c("p"),U=a(),r(j.$$.fragment),h=a(),r(C.$$.fragment),Xe=a(),r(v.$$.fragment),We=a(),r(Z.$$.fragment),Re=a(),I=c("p"),I.innerHTML=El,_e=a(),r($.$$.fragment),Ye=a(),r(B.$$.fragment),Ve=a(),g=c("p"),g.innerHTML=xl,Ae=a(),G=c("ul"),G.innerHTML=Fl,ze=a(),k=c("p"),k.innerHTML=Ql,Ne=a(),r(X.$$.fragment),Ee=a(),W=c("p"),W.textContent=Hl,xe=a(),r(R.$$.fragment),Fe=a(),_=c("p"),_.innerHTML=ql,Qe=a(),r(Y.$$.fragment),He=a(),V=c("p"),V.textContent=Sl,qe=a(),r(A.$$.fragment),Se=a(),r(z.$$.fragment),Le=a(),N=c("p"),N.innerHTML=Ll,Ke=a(),E=c("p"),E.textContent=Kl,Pe=a(),r(x.$$.fragment),De=a(),F=c("p"),F.textContent=Pl,Oe=a(),r(Q.$$.fragment),el=a(),r(H.$$.fragment),ll=a(),q=c("p"),q.innerHTML=Dl,sl=a(),S=c("p"),S.innerHTML=Ol,tl=a(),r(L.$$.fragment),al=a(),K=c("p"),K.innerHTML=es,nl=a(),r(P.$$.fragment),rl=a(),r(D.$$.fragment),il=a(),r(O.$$.fragment),pl=a(),ee=c("p"),ee.innerHTML=ls,ol=a(),r(le.$$.fragment),ml=a(),r(se.$$.fragment),ul=a(),te=c("p"),te.innerHTML=ss,cl=a(),r(ae.$$.fragment),Ml=a(),ne=c("p"),ne.textContent=ts,dl=a(),r(re.$$.fragment),yl=a(),ie=c("p"),ie.innerHTML=as,bl=a(),r(pe.$$.fragment),jl=a(),r(oe.$$.fragment),Jl=a(),me=c("p"),me.textContent=ns,wl=a(),r(T.$$.fragment),Ul=a(),r(ue.$$.fragment),hl=a(),r(ce.$$.fragment),Tl=a(),Me=c("p"),Me.innerHTML=rs,fl=a(),r(de.$$.fragment),Cl=a(),ye=c("p"),ye.textContent=is,vl=a(),r(be.$$.fragment),Zl=a(),je=c("p"),je.innerHTML=ps,Il=a(),Je=c("p"),Je.innerHTML=os,$l=a(),r(f.$$.fragment),Bl=a(),we=c("p"),we.innerHTML=ms,gl=a(),r(Ue.$$.fragment),Gl=a(),he=c("p"),he.innerHTML=us,kl=a(),r(Te.$$.fragment),Xl=a(),fe=c("p"),fe.textContent=cs,Wl=a(),r(Ce.$$.fragment),Rl=a(),ve=c("p"),ve.textContent=Ms,_l=a(),Ze=c("p"),Ze.innerHTML=ds,Yl=a(),r(Ie.$$.fragment),Vl=a(),$e=c("p"),$e.innerHTML=ys,Al=a(),r(Be.$$.fragment),zl=a(),Ge=c("p"),this.h()},l(e){const l=Bs("svelte-u9bgzb",document.head);b=M(l,"META",{name:!0,content:!0}),l.forEach(s),J=n(e),w=M(e,"P",{}),Js(w).forEach(s),U=n(e),i(j.$$.fragment,e),h=n(e),i(C.$$.fragment,e),Xe=n(e),i(v.$$.fragment,e),We=n(e),i(Z.$$.fragment,e),Re=n(e),I=M(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-1g0xmca"&&(I.innerHTML=El),_e=n(e),i($.$$.fragment,e),Ye=n(e),i(B.$$.fragment,e),Ve=n(e),g=M(e,"P",{"data-svelte-h":!0}),d(g)!=="svelte-17hvgx4"&&(g.innerHTML=xl),Ae=n(e),G=M(e,"UL",{"data-svelte-h":!0}),d(G)!=="svelte-s8mdl4"&&(G.innerHTML=Fl),ze=n(e),k=M(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1vhf3m8"&&(k.innerHTML=Ql),Ne=n(e),i(X.$$.fragment,e),Ee=n(e),W=M(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1jligxe"&&(W.textContent=Hl),xe=n(e),i(R.$$.fragment,e),Fe=n(e),_=M(e,"P",{"data-svelte-h":!0}),d(_)!=="svelte-15ft7dc"&&(_.innerHTML=ql),Qe=n(e),i(Y.$$.fragment,e),He=n(e),V=M(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1rk3y8n"&&(V.textContent=Sl),qe=n(e),i(A.$$.fragment,e),Se=n(e),i(z.$$.fragment,e),Le=n(e),N=M(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-hfva83"&&(N.innerHTML=Ll),Ke=n(e),E=M(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-hgf9jd"&&(E.textContent=Kl),Pe=n(e),i(x.$$.fragment,e),De=n(e),F=M(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-mg010b"&&(F.textContent=Pl),Oe=n(e),i(Q.$$.fragment,e),el=n(e),i(H.$$.fragment,e),ll=n(e),q=M(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-iwaa2x"&&(q.innerHTML=Dl),sl=n(e),S=M(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-ahwb4"&&(S.innerHTML=Ol),tl=n(e),i(L.$$.fragment,e),al=n(e),K=M(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-wgcpmp"&&(K.innerHTML=es),nl=n(e),i(P.$$.fragment,e),rl=n(e),i(D.$$.fragment,e),il=n(e),i(O.$$.fragment,e),pl=n(e),ee=M(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-rbvecl"&&(ee.innerHTML=ls),ol=n(e),i(le.$$.fragment,e),ml=n(e),i(se.$$.fragment,e),ul=n(e),te=M(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-unj8ze"&&(te.innerHTML=ss),cl=n(e),i(ae.$$.fragment,e),Ml=n(e),ne=M(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-w5chrh"&&(ne.textContent=ts),dl=n(e),i(re.$$.fragment,e),yl=n(e),ie=M(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-as7rjs"&&(ie.innerHTML=as),bl=n(e),i(pe.$$.fragment,e),jl=n(e),i(oe.$$.fragment,e),Jl=n(e),me=M(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-h5j4wt"&&(me.textContent=ns),wl=n(e),i(T.$$.fragment,e),Ul=n(e),i(ue.$$.fragment,e),hl=n(e),i(ce.$$.fragment,e),Tl=n(e),Me=M(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-159rzx0"&&(Me.innerHTML=rs),fl=n(e),i(de.$$.fragment,e),Cl=n(e),ye=M(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-3jm87s"&&(ye.textContent=is),vl=n(e),i(be.$$.fragment,e),Zl=n(e),je=M(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-1uypok9"&&(je.innerHTML=ps),Il=n(e),Je=M(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-13ypbak"&&(Je.innerHTML=os),$l=n(e),i(f.$$.fragment,e),Bl=n(e),we=M(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1t4du1b"&&(we.innerHTML=ms),gl=n(e),i(Ue.$$.fragment,e),Gl=n(e),he=M(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-dkpmec"&&(he.innerHTML=us),kl=n(e),i(Te.$$.fragment,e),Xl=n(e),fe=M(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-1qilg93"&&(fe.textContent=cs),Wl=n(e),i(Ce.$$.fragment,e),Rl=n(e),ve=M(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-16tpdes"&&(ve.textContent=Ms),_l=n(e),Ze=M(e,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-1whbz23"&&(Ze.innerHTML=ds),Yl=n(e),i(Ie.$$.fragment,e),Vl=n(e),$e=M(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-1qnllaj"&&($e.innerHTML=ys),Al=n(e),i(Be.$$.fragment,e),zl=n(e),Ge=M(e,"P",{}),Js(Ge).forEach(s),this.h()},h(){ws(b,"name","hf:doc:metadata"),ws(b,"content",Ys)},m(e,l){gs(document.head,b),t(e,J,l),t(e,w,l),t(e,U,l),p(j,e,l),t(e,h,l),p(C,e,l),t(e,Xe,l),p(v,e,l),t(e,We,l),p(Z,e,l),t(e,Re,l),t(e,I,l),t(e,_e,l),p($,e,l),t(e,Ye,l),p(B,e,l),t(e,Ve,l),t(e,g,l),t(e,Ae,l),t(e,G,l),t(e,ze,l),t(e,k,l),t(e,Ne,l),p(X,e,l),t(e,Ee,l),t(e,W,l),t(e,xe,l),p(R,e,l),t(e,Fe,l),t(e,_,l),t(e,Qe,l),p(Y,e,l),t(e,He,l),t(e,V,l),t(e,qe,l),p(A,e,l),t(e,Se,l),p(z,e,l),t(e,Le,l),t(e,N,l),t(e,Ke,l),t(e,E,l),t(e,Pe,l),p(x,e,l),t(e,De,l),t(e,F,l),t(e,Oe,l),p(Q,e,l),t(e,el,l),p(H,e,l),t(e,ll,l),t(e,q,l),t(e,sl,l),t(e,S,l),t(e,tl,l),p(L,e,l),t(e,al,l),t(e,K,l),t(e,nl,l),p(P,e,l),t(e,rl,l),p(D,e,l),t(e,il,l),p(O,e,l),t(e,pl,l),t(e,ee,l),t(e,ol,l),p(le,e,l),t(e,ml,l),p(se,e,l),t(e,ul,l),t(e,te,l),t(e,cl,l),p(ae,e,l),t(e,Ml,l),t(e,ne,l),t(e,dl,l),p(re,e,l),t(e,yl,l),t(e,ie,l),t(e,bl,l),p(pe,e,l),t(e,jl,l),p(oe,e,l),t(e,Jl,l),t(e,me,l),t(e,wl,l),p(T,e,l),t(e,Ul,l),p(ue,e,l),t(e,hl,l),p(ce,e,l),t(e,Tl,l),t(e,Me,l),t(e,fl,l),p(de,e,l),t(e,Cl,l),t(e,ye,l),t(e,vl,l),p(be,e,l),t(e,Zl,l),t(e,je,l),t(e,Il,l),t(e,Je,l),t(e,$l,l),p(f,e,l),t(e,Bl,l),t(e,we,l),t(e,gl,l),p(Ue,e,l),t(e,Gl,l),t(e,he,l),t(e,kl,l),p(Te,e,l),t(e,Xl,l),t(e,fe,l),t(e,Wl,l),p(Ce,e,l),t(e,Rl,l),t(e,ve,l),t(e,_l,l),t(e,Ze,l),t(e,Yl,l),p(Ie,e,l),t(e,Vl,l),t(e,$e,l),t(e,Al,l),p(Be,e,l),t(e,zl,l),t(e,Ge,l),Nl=!0},p(e,[l]){const bs={};l&2&&(bs.$$scope={dirty:l,ctx:e}),T.$set(bs);const js={};l&2&&(js.$$scope={dirty:l,ctx:e}),f.$set(js)},i(e){Nl||(o(j.$$.fragment,e),o(C.$$.fragment,e),o(v.$$.fragment,e),o(Z.$$.fragment,e),o($.$$.fragment,e),o(B.$$.fragment,e),o(X.$$.fragment,e),o(R.$$.fragment,e),o(Y.$$.fragment,e),o(A.$$.fragment,e),o(z.$$.fragment,e),o(x.$$.fragment,e),o(Q.$$.fragment,e),o(H.$$.fragment,e),o(L.$$.fragment,e),o(P.$$.fragment,e),o(D.$$.fragment,e),o(O.$$.fragment,e),o(le.$$.fragment,e),o(se.$$.fragment,e),o(ae.$$.fragment,e),o(re.$$.fragment,e),o(pe.$$.fragment,e),o(oe.$$.fragment,e),o(T.$$.fragment,e),o(ue.$$.fragment,e),o(ce.$$.fragment,e),o(de.$$.fragment,e),o(be.$$.fragment,e),o(f.$$.fragment,e),o(Ue.$$.fragment,e),o(Te.$$.fragment,e),o(Ce.$$.fragment,e),o(Ie.$$.fragment,e),o(Be.$$.fragment,e),Nl=!0)},o(e){m(j.$$.fragment,e),m(C.$$.fragment,e),m(v.$$.fragment,e),m(Z.$$.fragment,e),m($.$$.fragment,e),m(B.$$.fragment,e),m(X.$$.fragment,e),m(R.$$.fragment,e),m(Y.$$.fragment,e),m(A.$$.fragment,e),m(z.$$.fragment,e),m(x.$$.fragment,e),m(Q.$$.fragment,e),m(H.$$.fragment,e),m(L.$$.fragment,e),m(P.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(re.$$.fragment,e),m(pe.$$.fragment,e),m(oe.$$.fragment,e),m(T.$$.fragment,e),m(ue.$$.fragment,e),m(ce.$$.fragment,e),m(de.$$.fragment,e),m(be.$$.fragment,e),m(f.$$.fragment,e),m(Ue.$$.fragment,e),m(Te.$$.fragment,e),m(Ce.$$.fragment,e),m(Ie.$$.fragment,e),m(Be.$$.fragment,e),Nl=!1},d(e){e&&(s(J),s(w),s(U),s(h),s(Xe),s(We),s(Re),s(I),s(_e),s(Ye),s(Ve),s(g),s(Ae),s(G),s(ze),s(k),s(Ne),s(Ee),s(W),s(xe),s(Fe),s(_),s(Qe),s(He),s(V),s(qe),s(Se),s(Le),s(N),s(Ke),s(E),s(Pe),s(De),s(F),s(Oe),s(el),s(ll),s(q),s(sl),s(S),s(tl),s(al),s(K),s(nl),s(rl),s(il),s(pl),s(ee),s(ol),s(ml),s(ul),s(te),s(cl),s(Ml),s(ne),s(dl),s(yl),s(ie),s(bl),s(jl),s(Jl),s(me),s(wl),s(Ul),s(hl),s(Tl),s(Me),s(fl),s(Cl),s(ye),s(vl),s(Zl),s(je),s(Il),s(Je),s($l),s(Bl),s(we),s(gl),s(Gl),s(he),s(kl),s(Xl),s(fe),s(Wl),s(Rl),s(ve),s(_l),s(Ze),s(Yl),s(Vl),s($e),s(Al),s(zl),s(Ge)),s(b),u(j,e),u(C,e),u(v,e),u(Z,e),u($,e),u(B,e),u(X,e),u(R,e),u(Y,e),u(A,e),u(z,e),u(x,e),u(Q,e),u(H,e),u(L,e),u(P,e),u(D,e),u(O,e),u(le,e),u(se,e),u(ae,e),u(re,e),u(pe,e),u(oe,e),u(T,e),u(ue,e),u(ce,e),u(de,e),u(be,e),u(f,e),u(Ue,e),u(Te,e),u(Ce,e),u(Ie,e),u(Be,e)}}}const Ys='{"title":"Un entraînement complet","local":"un-entraînement-complet","sections":[{"title":"Préparer l’entraînement","local":"préparer-lentraînement","sections":[],"depth":3},{"title":"La boucle d’entraînement","local":"la-boucle-dentraînement","sections":[],"depth":3},{"title":"La boucle d’évaluation","local":"la-boucle-dévaluation","sections":[],"depth":3},{"title":"Optimisez votre boucle d’entraînement avec 🤗 <i> Accelerate </i>","local":"optimisez-votre-boucle-dentraînement-avec--i-accelerate-i","sections":[],"depth":3}],"depth":1}';function Vs(ge){return Zs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends Is{constructor(b){super(),$s(this,b,Vs,_s,vs,{})}}export{Hs as component};
