# Quiz de fin de chapitre

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

Testons ce que vous avez appris dans ce chapitre !
  
### 1. A quoi sont limités les modèles du *Hub* ?

<Question
	choices={[
		{
			text: "Aux modèles de la bibliothèque 🤗 <i>Transformers</i>.",
			explain: "Si les modèles de la bibliothèque 🤗 <i>Transformers</i> sont pris en charge sur le <i>Hub</i>, ils ne sont pas les seuls !"
		},
		{
			text: "Tous les modèles avec une interface similaire à 🤗 <i>Transformers</i>.",
			explain: "Aucune exigence d'interface n'est fixée lors du téléchargement de modèles vers le <i>Hub</i>."
		},
		{
			text: "Il n'y a pas de limites.",
			explain: "Il n'y a pas de limites au téléchargement de modèles sur le <i>Hub</i>.",
            correct: true
		},
        {
			text: "Des modèles qui sont d'une certaine manière liés au NLP.",
			explain: "Aucune exigence n'est fixée concernant le domaine d'application !"
		}
	]}
/>

### 2. Comment pouvez-vous gérer les modèles sur le *Hub* ?

<Question
	choices={[
		{
			text: "Par le biais d'un compte GCP.",
			explain: " "
		},
		{
			text: "Grâce à la distribution pair à pair.",
			explain: " "
		},
		{
			text: "Par le biais de git et git-lfs.",
			explain: "Les modèles sur le <i>Hub</i> sont de simples dépôts Git exploitant <code>git-lfs</code> pour les fichiers volumineux.",
            correct: true
		}
	]}
/>

### 3. Que pouvez-vous faire en utilisant l'interface web du *Hub* ? 

<Question
	choices={[
		{
			text: "« <i>Forker</i> » un dépôt existant.",
			explain: "« <i>Forker</i> » un dépôt n'est pas possible sur le <i>Hub</i>."
		},
		{
			text: "Créer un nouveau dépôt de modèles.",
			explain: "Ce n'est pas tout ce que vous pouvez faire, cependant.",
            correct: true
		},
		{
			text: "Gérer et modifier des fichiers.",
			explain: "Ce n'est pas la seule bonne réponse, cependant.",
            correct: true
		},
        {
			text: "Télécharger des fichiers.",
			explain: "Mais ce n'est pas tout.",
            correct: true
		},
        {
			text: "Voir les différences entre les versions.",
			explain: "Ce n'est pas tout ce que vous pouvez faire.",
            correct: true
		}
	]}
/>

### 4. Qu'est-ce qu'une carte de modèle ?

<Question
	choices={[
		{
			text: "Une description approximative du modèle, donc moins importante que les fichiers du modèle et du <i>tokenizer</i>.",
			explain: "Il s'agit bien d'une description du modèle, mais c'est un élément important : s'il est incomplet ou absent, l'utilité du modèle est considérablement réduite."
		},
		{
			text: "Un moyen d'assurer la reproductibilité, la réutilisation et l'équité..",
			explain: "Le fait de partager les bonnes informations dans la fiche du modèle aidera les utilisateurs à tirer parti de votre modèle et à être conscients de ses limites et de ses biais.",
            correct: true
		},
		{
			text: "Un fichier Python qui peut être exécuté pour récupérer des informations sur le modèle.",
			explain: "Les cartes de modèle sont de simples fichiers Markdown."
		}
	]}
/>

### 5. Lesquels de ces objets de la bibliothèque 🤗 *Transformers* peuvent être directement partagés sur le Hub avec `push_to_hub()` ?

{#if fw === 'pt'}
<Question
	choices={[
		{
			text: "Un <i>tokenizer</i>",
			explain: "Tous les <i>tokenizers</i> ont la méthode <code>push_to_hub</code> et l'utiliser poussera tous les fichiers du <i>tokenizer</i> (vocabulaire, architecture du <i>tokenizer</i>, etc.) vers un dépôt donné. Ce n'est pas la seule bonne réponse, cependant !",
            correct: true
		},
		{
			text: "Une configuration de modèle",
			explain: "Toutes les configurations de modèles ont la méthode <code>push_to_hub</code> et son utilisation les poussera vers un dépôt donné. Que pouvez-vous partager d'autre ?",
            correct: true
		},
		{
			text: "Un <i>modèle</i>",
			explain: "Tous les modèles ont la méthode <code>push_to_hub</code> qui le <i>pushra</i> ainsi que leurs fichiers de configuration, vers un dépôt donné. Ce n'est pas tout ce que vous pouvez partager, cependant.",
            correct: true
		},
        {
			text: "<i>Trainer</i>",
			explain: "Le <code>Trainer</code> implémente aussi la méthode <code>push_to_hub</code>. L'utiliser téléchargera le modèle, sa configuration, le <i>tokenizer</i> et une ébauche de carte de modèle vers un dépôt donné. Essayez une autre réponse !",
            correct: true
		}
	]}
/>
{:else}
<Question
	choices={[
		{
			text: "Un <i>tokenizer</i>",
			explain: "Toutes les configurations de modèles ont la méthode <code>push_to_hub</code> et son utilisation les poussera vers un dépôt donné. Que pouvez-vous partager d'autre ?",
            correct: true
		},
		{
			text: "Une configuration de modèle",
			explain: "Toutes les configurations de modèles ont la méthode <code>push_to_hub</code> et son utilisation les poussera vers un dépôt donné. Que pouvez-vous partager d'autre ?",
            correct: true
		},
		{
			text: "Un <i>modèle</i>",
			explain: "Tous les modèles ont la méthode <code>push_to_hub</code> qui le <i>pushra</i> ainsi que leurs fichiers de configuration, vers un dépôt donné. Ce n'est pas tout ce que vous pouvez partager, cependant.",
            correct: true
		},
		{
			text: "Tout ce qui précède avec un <i>callback</i> dédié",
			explain: "Le <code>PushToHubCallback</code> enverra régulièrement tous ces objets à un dépôt pendant l'entraînement.",
            correct: true
		}
	]}
/>
{/if}

### 6. Quelle est la première étape lorsqu'on utilise la méthode `push_to_hub()` ou les outils CLI ?

<Question
	choices={[
		{
			text: "Se connecter sur le site web.",
			explain: "Cela ne vous aidera pas sur votre machine locale."
		},
		{
			text: "Exécuter 'huggingface-cli login' dans un terminal.",
			explain: "Cela va télécharger et mettre en cache votre jeton personnel.",
            correct: true
		},
		{
			text: "Exécuter 'notebook_login()' dans un <i>notebook</i>.",
			explain: "Cela affichera un <i>widget</i> pour vous permettre de vous authentifier.",
            correct: true
		},
	]}
/>

### 7. Vous utilisez un modèle et un *tokenizer*, comment pouvez-vous les télécharger sur le *Hub* ?

<Question
	choices={[
		{
			text: "En appelant la méthode push_to_hub directement sur le modèle et le <i>tokenizer</i>.",
			explain: " ",
            correct: true
		},
		{
			text: "Au sein du moteur d'exécution Python, en les enveloppant dans une balise <code>huggingface_hub</code>.",
			explain: "Les modèles et les <i>tokenizers</i> bénéficient déjà de <code>huggingface_hub</code> : pas besoin d'emballage supplémentaire !"
		},
		{
			text: "En les sauvegardant sur le disque et en appelant <code>transformers-cli upload-model</code>.",
			explain: "La commande <code>upload-model</code> n'existe pas."
		}
	]}
/>

### 8. Quelles opérations git pouvez-vous faire avec la classe `Repository` ?

<Question
	choices={[
		{
			text: "Un <i>commit</i>.",
			explain: "La méthode <code>git_commit()</code> est là pour ça.",
            correct: true
		},
		{
			text: "Un <i>pull</i>.",
			explain: "C'est le but de la méthode <code>git_pull()</code>.",
            correct: true
		},
		{
			text: "Un <i>push</i>.",
			explain: "La méthode <code>git_push()</code> fait ça.",
            correct: true
		},
		{
			text: "Un <i>merge</i>.",
			explain: "Cette opération ne sera jamais possible avec cette API."
		}
	]}
/>

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/fr/chapter4/6.mdx" />