# מבוא

ברוכים הבאים לקורס של Hugging Face! מבוא זה ידריך אתכם בהתקנת סביבת העבודה. אם אתם רק מתחילים את הקורס, אנחנו ממליצים שקודם תעברו על [פרק 1](https://huggingface.co/course/chapter1/1), ואז תחזרו לכאן כדי להתקין את סביבת העבודה שלכם ותתנסו בכתיבת קוד בעצמכם.

כל הספריות בהן נשתמש בקורס זה זמינות כספריות Python, לכן כאן נראה לכם איך להקים סביבת עבודה של Python ואיך להתקין את הספריות הספציפיות שאותן תצטרכו.

נכסה שתי דרכים להקים את סביבת העבודה, שימוש במחברת Colab או בסביבת עבודה וירטואלית של Python. תרגישו חופשיים לבחור את השיטה שמתאימה לכם ביותר. עבור מתחילים, אנחנו ממליצים בחום שתתחילו בשימוש במחברת Colab.

שימו לב שלא נכסה שימוש במערת הפעלה Windows. אם אתם מריצים על Windows, אנחנו ממליצים להשתמש במחברות Colab. אם אתם משתמשים ב Linux או ב macOS, תוכלו לבחור באחת מהשיטות המוצעות כאן.

רוב הקורס מתבסס על כך שיש לכם חשבון Hugging Face. תוכלו ליצור אחד כאן: [יצירת משתמש](https://huggingface.co/join).

## שימוש במחברת Google Colab

שימוש במחברת Colab היא הדרך הפשוטה ביותר להתקנה; פתחו מחברת Colab בדפדפן שלכם ותתחילו לכתוב קוד! 

אם אתם לא מכירים את Colab, אנחנו ממליצים שתתחילו לעבור על ה[מבוא](https://colab.research.google.com/notebooks/intro.ipynb). Colab מאפשר לעבוד על חומרה כמו GPUs או TPUs, והשירות ניתן בחינם לפרויקטים קטנים.

כשאתם מרגישים בנוח לנווט ב Colab, פתחו מחברת חדשה והתחילו בהקמת הסביבה:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/new_colab.png" alt="מחברת Colab ריקה" width="80%"/>
</div>

הצעד הבא הוא התקנת כל הספריות שנצטרך בקורס. נשתמש ב `pip` להתקנה, שהוא מנהל החבילות ב Python. במחברות, אפשר להריץ פקודות מערכת ע"י כתיבה של `!` לפניהן, לכן אפשר להתקין את ספריית ה 🤗 Transformers בצורה הבאה:

<div dir="ltr" align="left">

```
!pip install transformers
```

</div>

תוכלו לוודא שחבילה הותקנה בצהלחה על ידי ביצוע import שלה לסביבת הריצה שלכם:

<div dir="ltr" align="left">

```
import transformers
```
</div>

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/install.gif" alt="A gif showing the result of the two commands above: installation and import" width="80%"/>
</div>

פקודה זו מתקינה גרסה קלה מאוד של 🤗 Transformers. בפרט, לא מותקנות frameworks כגון PyTorch או TensorFlow. מכיוון שנשתמש בהרבה פיצ'רים של הספריה, אנחנו ממליצים להתקין את גרסת הפיתוח, שמגיעה עם כל ה dependencies הדרושים כמעט לכל תרחיש אפשרי:

<div dir="ltr" align="left">

```
!pip install transformers[sentencepiece]
```
</div>

ההתקנה תמשך זמן מה, אבל לאחר מכן תהיו מוכנים לשאר הקורס.

## שימוש בסביבה וירטואלית של Python

אם אתם מעדיפים להשתמש בסביבה וירטואלית של Python, הצעד הראשון יהיה להתקין Python במערכת שלכם. אנחנו ממליצים על [המדריך הזה](https://realpython.com/installing-python/) כדי להתחיל.

לאחר ש Python מותקן, אתם אמורים להצליח להריץ פקודות Python מהטרמינל. תוכלו להתחיל על ידי הרצה של הפקודה הבאה כדי לוודא שההתקנה הצליחה לפני שתעברו לשלבים הבאים: `python --version` . זה אמור להציג את גרסת ה Python שזמינה במערכת שלכם כרגע.

בהרצת פקודת Python בטרמינל, כמו `python --version`, מומלץ לחשוב על התוכנה שמריצה את הפקודות כ "Python" המרכזי במערכת שלכם. אנחנו ממליצים לשמור על ההתקנה המרכזית הזו נקייה מחבילות, ולהשתמש בה כדי ליצור סביבות נפרדות לכל יישום שתעבדו עליו - כך, לכל יישום יהיו החבילות וה dependencies שלה ולא תצטרכו לדאוג מבעיות תאימות עם יישומים אחרים.

ב Python זה מבוצע בעזרת [*סביבות וירטואליות*](https://docs.python.org/3/tutorial/venv.html), שהן עצי תיקיות עצמאיים וכל אחת מהן מכילה התקנת Python נפרדת עם כל החבילות שיישום צריך. יצירת סביבה וירטואלית יכולה להעשות בעזרת מגוון כלים, אנחנו נשתמש בחבילת ה Python הרשמית, שנקראת [`venv`](https://docs.python.org/3/library/venv.html#module-venv).

תחילה, צרו את התיקייה בה תרצו שהיישום שלכם יחיה — לדוגמה, אולי תרצו ליצור תיקייה חדשה בשם *transformers-course* בשורש תיקייה הבית שלכם:

<div dir="ltr" align="left">

```
mkdir ~/transformers-course
cd ~/transformers-course
```
</div>

מתוך תיקייה זו, צרו סביבה וירטואלית על ידי שימוש במודול `venv`:

<div dir="ltr" align="left">

```
python -m venv .env
```
</div>

עכשיו אמורה להיות לכם תיקייה בשם *env.* בתיקייה שהייתה ריקה מקודם:
<div dir="ltr" align="left">

```
ls -a
```

```out
.      ..    .env
```
</div>

תוכלו להכנס ולצאת מהסביבה הוירטואלית שלכם בעזרת הפקודות `activate` ו `deactivate` :

<div dir="ltr" align="left">

```
# Activate the virtual environment
source .env/bin/activate

# Deactivate the virtual environment
deactivate
```
</div>

תוכלו לוודא שהסביבה הוירטואלית שלכם פעילה על ידי הרצת הפקודה `which python` : אם היא מצביעה על הסביבה הוירטואלית, אז הפעלתם אותה בהצלחה!

<div dir="ltr" align="left">

```
which python
```

```out
/home/<user>/transformers-course/.env/bin/python
```
</div>

### התקנת dependencies

 בדומה לחלק על שימוש ב Google Colab, תצטרכו להתקין את החבילות הנדרשות להמשך. שוב, תוכלו להתקין את גרסת הפיתוח של 🤗 Transformers בעזרת מנהל החבילות `pip`:

<div dir="ltr" align="left">

```
pip install "transformers[sentencepiece]"
```
</div>

עכשיו אתם מוכנים להמשך הקורס!
</span>

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/he/chapter0/1.mdx" />