# Pendahuluan

Selamat datang di kursus Hugging Face! Pada Bab ini, anda akan dibimbing untuk mempersiapkan _working environment_. Jika anda memulai kursus ini untuk pertama kali, anda sangat direkomendasikan untuk menyelesaikan [Bab 1](/course/chapter1) terlebih dahulu. Setelah menyelesaikan [Bab 1](/course/chapter1) anda bisa kembali ke page ini untuk mencoba eksplorasi kodenya secara independen.

Semua modul yang digunakan dalam kursus ini tersedia dalam modul Python. Di kursus ini, anda juga akan dibimbing untuk mempersiapkan Python _environment_ dan menginstal modul-modul yang dibutuhkan.

Ada 2 cara untuk jenis _working environment_ yang bisa anda gunakan, Colab notebook dan _virtual environment_ Python. Anda bebas memilih _working envrionment_, tapi untuk pemula, kami menyarankan untuk menggunakan Colab notebook.

Sebagai catatan, kursus ini tidak mencakup instalasi untuk pengguna Windows. Jika anda menggunakan Windows, mohon menggunakan Colab notebook. Jika anda adalah pengguna Linux atau macOS, anda bebas memilih _working environment_ yang akan dijelaskan dibawah.

Sebagian besar dari kursus ini akan mewajibkan anda untuk memiliki akun Hugging Face. Jika anda belum memiliki akun, silahkan mendaftar terlebih dahulu di tautan berikut [https://huggingface.co/join](https://huggingface.co/join).

## Menggunakan Google Colab notebook

Menggunakan Colab notebook sangatlah sederhana, cukup dengan membuat notebook baru anda sudah bisa mulai koding!

Jika anda belum terbiasa menggunakan Colab, silahkan mengikuti [tutorial pengenalan Colab dari Google](https://colab.research.google.com/notebooks/intro.ipynb) (hanya tersedia dalam Bahasa Inggris). Saat menggunakan Colab, anda dapat mengakses hardware seperti GPU dan TPU yang dapat mengakselerasi proses pengolahan data. Hardware ini dapat anda gunakan secara gratis untuk proyek skala kecil.

Setelah terbiasa dengan Colab, buatlah notebook baru dengan setup sebagai berikut:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/new_colab.png" alt="An empty colab notebook" width="80%"/>
</div>

Langkah berikutnya adalah menginstal modul-modul yang akan digunakan dalam kursus ini menggunakan `pip`. `pip` adalah modul manager untuk bahasa pemrograman Python. Di dalam notebook, anda dapat mengakses komando sistem dengan menambahkan tanda seru (`!`) sebelum kode instruksi anda. Contoh instalasi modul 🤗 adalah sebagai berikut:

```
!pip install transformers
```

Untuk memastikan bahwa modul telah terinstalasi dengan benar, anda perlu mencoba untuk meng-_import_ modul tersebut di _runtime_ Python anda:

```
import transformers
```

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/install.gif" alt="A gif showing the result of the two commands above: installation and import" width="80%"/>
</div>

Kode instruksi diatas menginstall versi ringan dari 🤗 Transformers. Versi ringan ini tidak mengistall modul _machine learning_ (seperti PyTorch atau TensorFlow). Sangat direkomendasikan untuk mengistal versi _development_ dari modul ini karena nanti anda akan menggunakan berbagai macam fitur yang tersedia didalam modul ini dan versi ini juga akan mencakup berbagai macam modul untuk segala macam kasus yang akan dihadapi dalam kursus ini. Untuk mengistal versi _development_, silahkan eksekusi kode dibawah:

```
!pip install transformers[sentencepiece]
```

Proses instalasi akan berlangsung cukup lama. Tapi saat instalasi selesai, anda sudah siap untuk menyelesaikan kursus ini!

## Menggunakan Python _virtual environment_

Jika anda ingin menggunakan Python _virtual environment_, tentu saja langkah pertama yang harus anda lewati adalah menginstal Python. Untuk menginstal Python, bisa mengikuti referensi di tautan [ini](https://realpython.com/installing-python/).

Setelah Python berhasil terinstalasi, anda bisa menjalankan kode Python di terminal anda. Anda bisa memulai dengan mengeksekusi instruksi berikut untuk memastikan bahwa Python terinstalasi dengan benar: `python --version`. Instruksi ini akan menampilkan versi Python yang terinstalasi di komputer anda.

Python yang saat ini terinstalasi di sistem anda adalah versi Python *"utama"* untuk sistem anda. Sangat direkomendasikan untuk tidak mengotak-ngatik Python "utama" di sistem anda, dan untuk setiap aplikasi yang akan dikembangkan menggunakan Python akan lebih baik jika menggunakan versi Python berbeda. Pada umumnya, versi Python yang digunakan untuk pengembangan aplikasi bukanlah versi "utama". Ini dilakukan karena setiap aplikasi menggunakan modul yang berbeda-beda dan setiap modul memiliki ketergantugan satu sama lain. Dengan menggunakan versi berbeda, kekhawatiran terjadinya konflik antar modul dapat dihindari.

Penggunaan versi berbeda dari Python dilakukan dengan menggunakan [*virtual environments*](https://docs.python.org/3/tutorial/venv.html). _Virtual environment_ adalah instalasi Python terpisah yang digunakan untuk keperluan tertentu aplikasi. Di dalam virtual environment, versi Python maupun modul-modul yang terinstal akan terisolasi dari versi Python "utama". Terdapata banyak cara untuk membuat _virtual environment_, tapi di kursus ini kita akan mengikuti arahan khusus dari dokumentasi resmi Python yang dinamai [`venv`](https://docs.python.org/3/library/venv.html#module-venv).

Pertama, buatlah folder baru untuk menyimpan aplikasi yang akan dibuat. Sebagai contoh, anda mungkin akan membuat folder baru bernama *transformers-course* di root folder dari home directory komputer anda:

```
mkdir ~/transformers-course
cd ~/transformers-course
```

Setelah masuk ke folder baru tersebut, buatlah _virtual environment_ menggunakan modul `venv` Python:

```
python -m venv .env
```

Setelah menggunakan modul `venv`, anda akan memiliki folder baru bernama *.env*:

```
ls -a
```

```out
.      ..    .env
```

Instruksi dibawah adalah instruksi untuk mengaktifkan dan menonaktifkan _virtual environment_ yang baru saja dibuat:

```
# Mengaktifkan virtual environment
source .env/bin/activate

# Menonaktifkan virtual environment
deactivate
```

Anda bisa memastikan bahwa anda menggunakan Python versi _virtual environment_ dengan mengeksekusi `which python` di terminal: jika balasan terminal adalah Python di dalam folder *.env*, maka _virtual environment_ anda sudah aktif!

```
which python
```

```out
/home/<user>/transformers-course/.env/bin/python
```

### Instalasi modul

Sama seperti di Google Colab, anda perlu menginstal modul-modul yang diperlukan. Kali ini, instalasi versi _development_ 🤗 Transformers dapat dilakukan menggunakan _package manager_ `pip`:

```
pip install "transformers[sentencepiece]"
```

Sekarang anda siap untuk mulai belajar!

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/id/chapter0/1.mdx" />