import{s as Ut,o as ft,n as Ct}from"../chunks/scheduler.cc52f4b9.js";import{S as It,i as Zt,e as m,s,c as i,h as Bt,a as M,d as t,b as n,f as wt,g as o,j as u,k as jt,l as gt,m as a,n as r,t as p,o as c,p as d,q as $t,r as Gt}from"../chunks/index.d2856393.js";import{T as Tt}from"../chunks/Tip.a5bdccc4.js";import{C as vt,H as ve,E as kt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8ffb7edb.js";import{Y as ht}from"../chunks/Youtube.00df107c.js";import{C as y}from"../chunks/CodeBlock.5f8dc025.js";import{D as zt}from"../chunks/DocNotebookDropdown.2340b131.js";function Xt(ge){let b,J="✏️ <strong>Prova tu!</strong> Modifica il ciclo di addestramento precedente per affinare il modello sul dataset SST-2.";return{c(){b=m("p"),b.innerHTML=J},l(w){b=M(w,"P",{"data-svelte-h":!0}),u(b)!=="svelte-1tob4ng"&&(b.innerHTML=J)},m(w,$e){a(w,b,$e)},p:Ct,d(w){w&&t(b)}}}function Wt(ge){let b;return{c(){b=$t('⚠️ Per poter beneficiare dell\'accelerazione offerta da Cloud TPUs, è raccomandabile applicare padding ad una lunghezza fissa tramite gli argomenti `padding="max_length"` e `max_length` del tokenizer.')},l(J){b=Gt(J,'⚠️ Per poter beneficiare dell\'accelerazione offerta da Cloud TPUs, è raccomandabile applicare padding ad una lunghezza fissa tramite gli argomenti `padding="max_length"` e `max_length` del tokenizer.')},m(J,w){a(J,b,w)},d(J){J&&t(b)}}}function Rt(ge){let b,J,w,$e,h,ke,U,ze,f,Xe,C,We,I,El="Ora vedremo come ottenere gli stessi risultati della sezione precedente senza utilizzare la classe <code>Trainer</code>. Ancora una volta, aver compiuto il processing dei dati spiegato nella sezione 2 è un prerequisito. Ecco un riassunto di tutto ciò di cui avrete bisogno:",Re,Z,_e,B,Ye,g,Fl="Prima di cominciare a scrivere il nostro ciclo di addestramento, dobbiamo definire alcuni oggetti. Per prima cosa, i dataloaders (caricatori di dati) che useremo per iterare sulle batch. Ma prima di poter definire i dataloaders, dobbiamo applicare un po’ di postprocessing ai nostri <code>tokenized_datasets</code>, per compiere alcune operazione che <code>Trainer</code> gestiva in automatico per noi. Nello specifico dobbiamo:",Ve,$,Hl="<li>Rimuovere le colonne corrispondente a valori che il modello non si aspetta (come ad esempio le colonne <code>sentence1</code> e <code>sentence2 </code>).</li> <li>Rinominare la colonna <code>label</code> a <code>labels</code> (perché il modello si aspetta questo nome).</li> <li>Fissare il formato dei datasets in modo che restituiscano tensori Pytorch invece di liste.</li>",Ne,G,Ql="L’oggetto <code>tokenized_datasets</code> ha un metodo per ciascuno di questi punti:",Ae,v,Ee,k,xl="Possiamo poi controllare che il risultato ha solo solo colonne che saranno accettate dal nostro modello:",Fe,z,He,X,Sl="Ora che questo è fatto, possiamo finalmente definire i dataloaders in maniera semplice:",Qe,W,xe,R,ql="Per controllare velocemente che non ci sono errori nel processing dei dati, possiamo ispezionare una batch in questo modo:",Se,_,qe,Y,Le,V,Ll="È importante sottolineare che i valori di shape (forma) potrebbero essere leggermente diversi per voi, poiché abbiamo fissato <code>shuffle=True</code> (rimescolamento attivo) per i dataloader di apprendimento, e stiamo applicando padding alla lunghezza massima all’interno della batch.",Ke,N,Kl="Ora che il preprocessing dei dati è completato (uno scopo soddisfacente ma elusivo per qualunque praticante di ML), focalizziamoci sul modello. Lo istanziamo esattamente come avevamo fatto nella sezione precedente:",Pe,A,De,E,Pl="Per assicurarci che tutto andrà bene durante l’addestramento, passiamo la batch al modello:",Oe,F,el,H,ll,Q,Dl="Tutti i modelli 🤗 Transformers restituiscono il valore obiettivo quando vengono fornite loro le <code>labels</code>, e anche i logits (due per ciascun input della batch, quindi un tensore di dimensioni 8 x 2).",tl,x,Ol='Siamo quasi pronti a scrivere il ciclo di addestramento! Mancano solo due cose: un ottimizzatore e un learning rate scheduler. Poiché stiamo tentando di replicare a mano ciò che viene fatto dal <code>Trainer</code>, utilizzeremo gli stessi valori di default. L’ottimizzatore utilizzato dal <code>Trainer</code> è <code>AdamW</code>, che è lo stesso di Adam ma con una variazione per quanto riguarda la regolarizzazione del decadimento dei pesi (rif. <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">“Decoupled Weight Decay Regularization”</a> di Ilya Loshchilov e Frank Hutter):',al,S,sl,q,et="Infine, il learning rate scheduler usato di default è solo un decadimento lineare dal valore massimo (5e-5) fino a 0. Per definirlo correttamente, dobbiamo sapere il numero di iterazioni per l’addestramento, che è dato dal numero di epoche che vogliamo eseguire moltiplicato per il numero di batch per l’addestramento (ovverosia la lunghezza del dataloader). Il <code>Trainer</code> usa 3 epoche di default, quindi:",nl,L,il,K,ol,P,rl,D,lt="Un’ultima cosa: se si ha accesso ad una GPU è consigliato usarla (su una CPU, l’addestramento potrebbe richiedere svariate ore invece di un paio di minuti). Per usare la GPU, definiamo un <code>device</code> su cui spostare il modello e le batch:",pl,O,cl,ee,dl,le,tt="Siamo pronti per l’addestramento! Per avere un’intuizione di quando sarà finito, aggiungiamo una barra di progresso sul numero di iterazioni di addestramento, usando la libreria <code>tqdm</code>:",ml,te,Ml,ae,at="Potete vedere che il nocciolo del ciclo di addestramento è molto simile a quello nell’introduzione. Non abbiamo chiesto nessun report, quindi il ciclo non ci informerà su come si sta comportando il modello. Dobbiamo aggiungere un ciclo di valutazione per quello.",ul,se,yl,ne,st="Come fatto in precedenza, utilizzeremo una metrica fornita dalla libreria 🤗 Datasets. Abbiamo già visto il metodo <code>metric.compute()</code>, ma le metriche possono automaticamente accumulare le batch nel ciclo di predizione col metodo <code>add_batch()</code>. Una volta accumulate tutte le batch, possiamo ottenere il risultato finale con <code>metric.compute()</code>. Ecco come implementare tutto ciò in un ciclo di valutazione:",bl,ie,Jl,oe,wl,re,nt="Ancora una volta, i vostri risultati potrebbero essere leggermente diversi a causa della casualità nell’inizializzazione della testa del modello e del ricombinamento dei dati, ma dovrebbero essere nello stesso ordine di grandezza.",jl,j,Tl,pe,hl,ce,Ul,de,it='Il ciclo di addestramento che abbiamo definito prima funziona bene per una sola CPU o GPU. Ma grazie alla libreria <a href="https://github.com/huggingface/accelerate" rel="nofollow">🤗 Accelerate</a>, con alcuni aggiustamenti possiamo attivare l’addestramento distribuito su svariate GPU o TPU. Partendo dalla creazione dei dataloaders di addestramento e validazione, ecco l’aspetto del nostro ciclo di addestramento manuale:',fl,me,Cl,Me,ot="Ecco i cambiamenti necessari:",Il,ue,Zl,ye,rt="Prima di tutto bisogna inserire la linea di importazione. La seconda linea istanzia un oggetto di tipo <code>Accelerator</code> che controllerà e inizializzerà il corretto ambiente distribuito. 🤗 Accelerate gestice il posizionamento sui dispositivi per voi, quindi potete togliere le linee che spostavano il modello sul dispositivo (o, se preferite, cambiare in modo da usare <code>acceleratore.device</code> invece di <code>device</code>).",Bl,be,pt="Dopodiché la maggior parte del lavoro è fatta dalla linea che invia i dataloaders, il modello e gli ottimizzatori a <code>accelerator.prepare()</code>. Ciò serve a incapsulare queli oggetti nei contenitori appropriati per far sì che l’addestramento distribuito funzioni correttamente. I cambiamenti rimanenti sono la rimozione della linea che sposta la batch sul <code>device</code> (dispositivo) (di nuovo, se volete tenerlo potete semplicemente cambiarlo con <code>accelerator.device</code>) e lo scambio di <code>loss.backward()</code> con <code>accelerator.backward(loss)</code>.",gl,T,$l,Je,ct="Se volete copiare e incollare il codice per giocarci, ecco un ciclo di addestramento completo che usa 🤗 Accelerate:",Gl,we,vl,je,dt="Mettere questo codice in uno script <code>train.py</code> lo renderà eseguibile su qualsiasi ambiente distribuito. Per provarlo nel vostro ambiente distribuito, eseguite:",kl,Te,zl,he,mt="che vi chiederà di rispondere ad alcune domande e inserirà le vostre risposte in un documento di configurazione usato dal comando:",Xl,Ue,Wl,fe,Mt="che eseguirà l’addestramento distribuito.",Rl,Ce,ut="Se volete provarlo in un Notebook (ad esempio, per testarlo con le TPUs su Colab), incollate il codice in una <code>training_function()</code> ed eseguite l’ultima cella con:",_l,Ie,Yl,Ze,yt='Potete trovare altri esempi nella <a href="https://github.com/huggingface/accelerate/tree/main/examples" rel="nofollow">🤗 Accelerate repo</a>.',Vl,Be,Nl,Ge,Al;return h=new vt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new ve({props:{title:"Un addestramento completo",local:"un-addestramento-completo",headingTag:"h1"}}),f=new zt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/it/chapter3/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/it/chapter3/section4.ipynb"}]}}),C=new ht({props:{id:"Dh9CL8fyG80"}}),Z=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),B=new ve({props:{title:"Preparazione all’addestramento",local:"preparazione-alladdestramento",headingTag:"h3"}}),v=new y({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiUyQyUyMCUyMmlkeCUyMiU1RCklMEF0b2tlbml6ZWRfZGF0YXNldHMlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldHMucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMuc2V0X2Zvcm1hdCglMjJ0b3JjaCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXM=",highlighted:`tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;idx&quot;</span>])
tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)
tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].column_names`,wrap:!1}}),z=new y({props:{code:"JTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RA==",highlighted:'[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>]',wrap:!1}}),W=new y({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0Q4JTJDJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMEEpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUwQSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

train_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>], shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)
eval_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>], batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)`,wrap:!1}}),_=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBicmVhayUwQSU3QmslM0ElMjB2LnNoYXBlJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
    <span class="hljs-keyword">break</span>
{k: v.shape <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}`,wrap:!1}}),Y=new y({props:{code:"JTdCJ2F0dGVudGlvbl9tYXNrJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSUyQyUwQSUyMCdpbnB1dF9pZHMnJTNBJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwNjUlNUQpJTJDJTBBJTIwJ2xhYmVscyclM0ElMjB0b3JjaC5TaXplKCU1QjglNUQpJTJDJTBBJTIwJ3Rva2VuX3R5cGVfaWRzJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSU3RA==",highlighted:`{<span class="hljs-string">&#x27;attention_mask&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: torch.Size([<span class="hljs-number">8</span>]),
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>])}`,wrap:!1}}),A=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),F=new y({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBcHJpbnQob3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5sb2dpdHMuc2hhcGUp",highlighted:`outputs = model(**batch)
<span class="hljs-built_in">print</span>(outputs.loss, outputs.logits.shape)`,wrap:!1}}),H=new y({props:{code:"dGVuc29yKDAuNTQ0MSUyQyUyMGdyYWRfZm4lM0QlM0NObGxMb3NzQmFja3dhcmQlM0UpJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwMiU1RCk=",highlighted:'tensor(<span class="hljs-number">0.5441</span>, grad_fn=&lt;NllLossBackward&gt;) torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">2</span>])',wrap:!1}}),S=new y({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDVlLTUp",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW

optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),L=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMEElMjAlMjAlMjAlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRG51bV90cmFpbmluZ19zdGVwcyUyQyUwQSklMEFwcmludChudW1fdHJhaW5pbmdfc3RlcHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)
<span class="hljs-built_in">print</span>(num_training_steps)`,wrap:!1}}),K=new y({props:{code:"MTM3Nw==",highlighted:'<span class="hljs-number">1377</span>',wrap:!1}}),P=new ve({props:{title:"Il ciclo di addestramento",local:"il-ciclo-di-addestramento",headingTag:"h3"}}),O=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBZGV2aWNl",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)
device`,wrap:!1}}),ee=new y({props:{code:"ZGV2aWNlKHR5cGUlM0QnY3VkYScp",highlighted:'device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;cuda&#x27;</span>)',wrap:!1}}),te=new y({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),se=new ve({props:{title:"Il ciclo di valutazione",local:"il-ciclo-di-valutazione",headingTag:"h3"}}),ie=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9tZXRyaWMlMEElMEFtZXRyaWMlMjAlM0QlMjBsb2FkX21ldHJpYyglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFtb2RlbC5ldmFsKCklMEFmb3IlMjBiYXRjaCUyMGluJTIwZXZhbF9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QtMSklMEElMjAlMjAlMjAlMjBtZXRyaWMuYWRkX2JhdGNoKHByZWRpY3Rpb25zJTNEcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEYmF0Y2glNUIlMjJsYWJlbHMlMjIlNUQpJTBBJTBBbWV0cmljLmNvbXB1dGUoKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_metric

metric = load_metric(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
model.<span class="hljs-built_in">eval</span>()
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(**batch)

    logits = outputs.logits
    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

metric.compute()`,wrap:!1}}),oe=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODQzMTM3MjU0OTAxOTYwOCUyQyUyMCdmMSclM0ElMjAwLjg5MDc4NDk4MjkzNTE1MzUlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8431372549019608</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8907849829351535</span>}',wrap:!1}}),j=new Tt({props:{$$slots:{default:[Xt]},$$scope:{ctx:ge}}}),pe=new ve({props:{title:"Potenzia il tuo ciclo di addestramento con 🤗 Accelerate",local:"potenzia-il-tuo-ciclo-di-addestramento-con--accelerate",headingTag:"h3"}}),ce=new ht({props:{id:"s7dy8QRgjJ0"}}),me=new y({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMGdldF9zY2hlZHVsZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDNlLTUpJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIpJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMHRvcmNoLmRldmljZSglMjJjcHUlMjIpJTBBbW9kZWwudG8oZGV2aWNlKSUwQSUwQW51bV9lcG9jaHMlMjAlM0QlMjAzJTBBbnVtX3RyYWluaW5nX3N0ZXBzJTIwJTNEJTIwbnVtX2Vwb2NocyUyMColMjBsZW4odHJhaW5fZGF0YWxvYWRlciklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),ue=new y({props:{code:"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",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from torch.optim import AdamW
  from transformers import AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`,wrap:!1}}),T=new Tt({props:{$$slots:{default:[Wt]},$$scope:{ctx:ge}}}),we=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC5vcHRpbSUyMGltcG9ydCUyMEFkYW1XJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),Te=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),Ue=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:'accelerate <span class="hljs-built_in">launch</span> train.py',wrap:!1}}),Ie=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

notebook_launcher(training_function)`,wrap:!1}}),Be=new kt({props:{source:"https://github.com/huggingface/course/blob/main/chapters/it/chapter3/4.mdx"}}),{c(){b=m("meta"),J=s(),w=m("p"),$e=s(),i(h.$$.fragment),ke=s(),i(U.$$.fragment),ze=s(),i(f.$$.fragment),Xe=s(),i(C.$$.fragment),We=s(),I=m("p"),I.innerHTML=El,Re=s(),i(Z.$$.fragment),_e=s(),i(B.$$.fragment),Ye=s(),g=m("p"),g.innerHTML=Fl,Ve=s(),$=m("ul"),$.innerHTML=Hl,Ne=s(),G=m("p"),G.innerHTML=Ql,Ae=s(),i(v.$$.fragment),Ee=s(),k=m("p"),k.textContent=xl,Fe=s(),i(z.$$.fragment),He=s(),X=m("p"),X.textContent=Sl,Qe=s(),i(W.$$.fragment),xe=s(),R=m("p"),R.textContent=ql,Se=s(),i(_.$$.fragment),qe=s(),i(Y.$$.fragment),Le=s(),V=m("p"),V.innerHTML=Ll,Ke=s(),N=m("p"),N.textContent=Kl,Pe=s(),i(A.$$.fragment),De=s(),E=m("p"),E.textContent=Pl,Oe=s(),i(F.$$.fragment),el=s(),i(H.$$.fragment),ll=s(),Q=m("p"),Q.innerHTML=Dl,tl=s(),x=m("p"),x.innerHTML=Ol,al=s(),i(S.$$.fragment),sl=s(),q=m("p"),q.innerHTML=et,nl=s(),i(L.$$.fragment),il=s(),i(K.$$.fragment),ol=s(),i(P.$$.fragment),rl=s(),D=m("p"),D.innerHTML=lt,pl=s(),i(O.$$.fragment),cl=s(),i(ee.$$.fragment),dl=s(),le=m("p"),le.innerHTML=tt,ml=s(),i(te.$$.fragment),Ml=s(),ae=m("p"),ae.textContent=at,ul=s(),i(se.$$.fragment),yl=s(),ne=m("p"),ne.innerHTML=st,bl=s(),i(ie.$$.fragment),Jl=s(),i(oe.$$.fragment),wl=s(),re=m("p"),re.textContent=nt,jl=s(),i(j.$$.fragment),Tl=s(),i(pe.$$.fragment),hl=s(),i(ce.$$.fragment),Ul=s(),de=m("p"),de.innerHTML=it,fl=s(),i(me.$$.fragment),Cl=s(),Me=m("p"),Me.textContent=ot,Il=s(),i(ue.$$.fragment),Zl=s(),ye=m("p"),ye.innerHTML=rt,Bl=s(),be=m("p"),be.innerHTML=pt,gl=s(),i(T.$$.fragment),$l=s(),Je=m("p"),Je.textContent=ct,Gl=s(),i(we.$$.fragment),vl=s(),je=m("p"),je.innerHTML=dt,kl=s(),i(Te.$$.fragment),zl=s(),he=m("p"),he.textContent=mt,Xl=s(),i(Ue.$$.fragment),Wl=s(),fe=m("p"),fe.textContent=Mt,Rl=s(),Ce=m("p"),Ce.innerHTML=ut,_l=s(),i(Ie.$$.fragment),Yl=s(),Ze=m("p"),Ze.innerHTML=yt,Vl=s(),i(Be.$$.fragment),Nl=s(),Ge=m("p"),this.h()},l(e){const l=Bt("svelte-u9bgzb",document.head);b=M(l,"META",{name:!0,content:!0}),l.forEach(t),J=n(e),w=M(e,"P",{}),wt(w).forEach(t),$e=n(e),o(h.$$.fragment,e),ke=n(e),o(U.$$.fragment,e),ze=n(e),o(f.$$.fragment,e),Xe=n(e),o(C.$$.fragment,e),We=n(e),I=M(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-1us6pmo"&&(I.innerHTML=El),Re=n(e),o(Z.$$.fragment,e),_e=n(e),o(B.$$.fragment,e),Ye=n(e),g=M(e,"P",{"data-svelte-h":!0}),u(g)!=="svelte-1r5rhw5"&&(g.innerHTML=Fl),Ve=n(e),$=M(e,"UL",{"data-svelte-h":!0}),u($)!=="svelte-1soygtz"&&($.innerHTML=Hl),Ne=n(e),G=M(e,"P",{"data-svelte-h":!0}),u(G)!=="svelte-109i7es"&&(G.innerHTML=Ql),Ae=n(e),o(v.$$.fragment,e),Ee=n(e),k=M(e,"P",{"data-svelte-h":!0}),u(k)!=="svelte-ouxzs3"&&(k.textContent=xl),Fe=n(e),o(z.$$.fragment,e),He=n(e),X=M(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-9dsd8e"&&(X.textContent=Sl),Qe=n(e),o(W.$$.fragment,e),xe=n(e),R=M(e,"P",{"data-svelte-h":!0}),u(R)!=="svelte-10x8m39"&&(R.textContent=ql),Se=n(e),o(_.$$.fragment,e),qe=n(e),o(Y.$$.fragment,e),Le=n(e),V=M(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-1vy1r30"&&(V.innerHTML=Ll),Ke=n(e),N=M(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-tvclea"&&(N.textContent=Kl),Pe=n(e),o(A.$$.fragment,e),De=n(e),E=M(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-17r0l89"&&(E.textContent=Pl),Oe=n(e),o(F.$$.fragment,e),el=n(e),o(H.$$.fragment,e),ll=n(e),Q=M(e,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-14z3wqu"&&(Q.innerHTML=Dl),tl=n(e),x=M(e,"P",{"data-svelte-h":!0}),u(x)!=="svelte-1tiesbf"&&(x.innerHTML=Ol),al=n(e),o(S.$$.fragment,e),sl=n(e),q=M(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-agqccw"&&(q.innerHTML=et),nl=n(e),o(L.$$.fragment,e),il=n(e),o(K.$$.fragment,e),ol=n(e),o(P.$$.fragment,e),rl=n(e),D=M(e,"P",{"data-svelte-h":!0}),u(D)!=="svelte-1wb397t"&&(D.innerHTML=lt),pl=n(e),o(O.$$.fragment,e),cl=n(e),o(ee.$$.fragment,e),dl=n(e),le=M(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-1xyrr8b"&&(le.innerHTML=tt),ml=n(e),o(te.$$.fragment,e),Ml=n(e),ae=M(e,"P",{"data-svelte-h":!0}),u(ae)!=="svelte-k27sq5"&&(ae.textContent=at),ul=n(e),o(se.$$.fragment,e),yl=n(e),ne=M(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-vqhpoz"&&(ne.innerHTML=st),bl=n(e),o(ie.$$.fragment,e),Jl=n(e),o(oe.$$.fragment,e),wl=n(e),re=M(e,"P",{"data-svelte-h":!0}),u(re)!=="svelte-rz5cet"&&(re.textContent=nt),jl=n(e),o(j.$$.fragment,e),Tl=n(e),o(pe.$$.fragment,e),hl=n(e),o(ce.$$.fragment,e),Ul=n(e),de=M(e,"P",{"data-svelte-h":!0}),u(de)!=="svelte-mgnuhl"&&(de.innerHTML=it),fl=n(e),o(me.$$.fragment,e),Cl=n(e),Me=M(e,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-hyicis"&&(Me.textContent=ot),Il=n(e),o(ue.$$.fragment,e),Zl=n(e),ye=M(e,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-c6nglj"&&(ye.innerHTML=rt),Bl=n(e),be=M(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-curkr2"&&(be.innerHTML=pt),gl=n(e),o(T.$$.fragment,e),$l=n(e),Je=M(e,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-81d5ez"&&(Je.textContent=ct),Gl=n(e),o(we.$$.fragment,e),vl=n(e),je=M(e,"P",{"data-svelte-h":!0}),u(je)!=="svelte-1s4avns"&&(je.innerHTML=dt),kl=n(e),o(Te.$$.fragment,e),zl=n(e),he=M(e,"P",{"data-svelte-h":!0}),u(he)!=="svelte-5f8y46"&&(he.textContent=mt),Xl=n(e),o(Ue.$$.fragment,e),Wl=n(e),fe=M(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-h9xzji"&&(fe.textContent=Mt),Rl=n(e),Ce=M(e,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-142b7g5"&&(Ce.innerHTML=ut),_l=n(e),o(Ie.$$.fragment,e),Yl=n(e),Ze=M(e,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-zmmr5l"&&(Ze.innerHTML=yt),Vl=n(e),o(Be.$$.fragment,e),Nl=n(e),Ge=M(e,"P",{}),wt(Ge).forEach(t),this.h()},h(){jt(b,"name","hf:doc:metadata"),jt(b,"content",_t)},m(e,l){gt(document.head,b),a(e,J,l),a(e,w,l),a(e,$e,l),r(h,e,l),a(e,ke,l),r(U,e,l),a(e,ze,l),r(f,e,l),a(e,Xe,l),r(C,e,l),a(e,We,l),a(e,I,l),a(e,Re,l),r(Z,e,l),a(e,_e,l),r(B,e,l),a(e,Ye,l),a(e,g,l),a(e,Ve,l),a(e,$,l),a(e,Ne,l),a(e,G,l),a(e,Ae,l),r(v,e,l),a(e,Ee,l),a(e,k,l),a(e,Fe,l),r(z,e,l),a(e,He,l),a(e,X,l),a(e,Qe,l),r(W,e,l),a(e,xe,l),a(e,R,l),a(e,Se,l),r(_,e,l),a(e,qe,l),r(Y,e,l),a(e,Le,l),a(e,V,l),a(e,Ke,l),a(e,N,l),a(e,Pe,l),r(A,e,l),a(e,De,l),a(e,E,l),a(e,Oe,l),r(F,e,l),a(e,el,l),r(H,e,l),a(e,ll,l),a(e,Q,l),a(e,tl,l),a(e,x,l),a(e,al,l),r(S,e,l),a(e,sl,l),a(e,q,l),a(e,nl,l),r(L,e,l),a(e,il,l),r(K,e,l),a(e,ol,l),r(P,e,l),a(e,rl,l),a(e,D,l),a(e,pl,l),r(O,e,l),a(e,cl,l),r(ee,e,l),a(e,dl,l),a(e,le,l),a(e,ml,l),r(te,e,l),a(e,Ml,l),a(e,ae,l),a(e,ul,l),r(se,e,l),a(e,yl,l),a(e,ne,l),a(e,bl,l),r(ie,e,l),a(e,Jl,l),r(oe,e,l),a(e,wl,l),a(e,re,l),a(e,jl,l),r(j,e,l),a(e,Tl,l),r(pe,e,l),a(e,hl,l),r(ce,e,l),a(e,Ul,l),a(e,de,l),a(e,fl,l),r(me,e,l),a(e,Cl,l),a(e,Me,l),a(e,Il,l),r(ue,e,l),a(e,Zl,l),a(e,ye,l),a(e,Bl,l),a(e,be,l),a(e,gl,l),r(T,e,l),a(e,$l,l),a(e,Je,l),a(e,Gl,l),r(we,e,l),a(e,vl,l),a(e,je,l),a(e,kl,l),r(Te,e,l),a(e,zl,l),a(e,he,l),a(e,Xl,l),r(Ue,e,l),a(e,Wl,l),a(e,fe,l),a(e,Rl,l),a(e,Ce,l),a(e,_l,l),r(Ie,e,l),a(e,Yl,l),a(e,Ze,l),a(e,Vl,l),r(Be,e,l),a(e,Nl,l),a(e,Ge,l),Al=!0},p(e,[l]){const bt={};l&2&&(bt.$$scope={dirty:l,ctx:e}),j.$set(bt);const Jt={};l&2&&(Jt.$$scope={dirty:l,ctx:e}),T.$set(Jt)},i(e){Al||(p(h.$$.fragment,e),p(U.$$.fragment,e),p(f.$$.fragment,e),p(C.$$.fragment,e),p(Z.$$.fragment,e),p(B.$$.fragment,e),p(v.$$.fragment,e),p(z.$$.fragment,e),p(W.$$.fragment,e),p(_.$$.fragment,e),p(Y.$$.fragment,e),p(A.$$.fragment,e),p(F.$$.fragment,e),p(H.$$.fragment,e),p(S.$$.fragment,e),p(L.$$.fragment,e),p(K.$$.fragment,e),p(P.$$.fragment,e),p(O.$$.fragment,e),p(ee.$$.fragment,e),p(te.$$.fragment,e),p(se.$$.fragment,e),p(ie.$$.fragment,e),p(oe.$$.fragment,e),p(j.$$.fragment,e),p(pe.$$.fragment,e),p(ce.$$.fragment,e),p(me.$$.fragment,e),p(ue.$$.fragment,e),p(T.$$.fragment,e),p(we.$$.fragment,e),p(Te.$$.fragment,e),p(Ue.$$.fragment,e),p(Ie.$$.fragment,e),p(Be.$$.fragment,e),Al=!0)},o(e){c(h.$$.fragment,e),c(U.$$.fragment,e),c(f.$$.fragment,e),c(C.$$.fragment,e),c(Z.$$.fragment,e),c(B.$$.fragment,e),c(v.$$.fragment,e),c(z.$$.fragment,e),c(W.$$.fragment,e),c(_.$$.fragment,e),c(Y.$$.fragment,e),c(A.$$.fragment,e),c(F.$$.fragment,e),c(H.$$.fragment,e),c(S.$$.fragment,e),c(L.$$.fragment,e),c(K.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(se.$$.fragment,e),c(ie.$$.fragment,e),c(oe.$$.fragment,e),c(j.$$.fragment,e),c(pe.$$.fragment,e),c(ce.$$.fragment,e),c(me.$$.fragment,e),c(ue.$$.fragment,e),c(T.$$.fragment,e),c(we.$$.fragment,e),c(Te.$$.fragment,e),c(Ue.$$.fragment,e),c(Ie.$$.fragment,e),c(Be.$$.fragment,e),Al=!1},d(e){e&&(t(J),t(w),t($e),t(ke),t(ze),t(Xe),t(We),t(I),t(Re),t(_e),t(Ye),t(g),t(Ve),t($),t(Ne),t(G),t(Ae),t(Ee),t(k),t(Fe),t(He),t(X),t(Qe),t(xe),t(R),t(Se),t(qe),t(Le),t(V),t(Ke),t(N),t(Pe),t(De),t(E),t(Oe),t(el),t(ll),t(Q),t(tl),t(x),t(al),t(sl),t(q),t(nl),t(il),t(ol),t(rl),t(D),t(pl),t(cl),t(dl),t(le),t(ml),t(Ml),t(ae),t(ul),t(yl),t(ne),t(bl),t(Jl),t(wl),t(re),t(jl),t(Tl),t(hl),t(Ul),t(de),t(fl),t(Cl),t(Me),t(Il),t(Zl),t(ye),t(Bl),t(be),t(gl),t($l),t(Je),t(Gl),t(vl),t(je),t(kl),t(zl),t(he),t(Xl),t(Wl),t(fe),t(Rl),t(Ce),t(_l),t(Yl),t(Ze),t(Vl),t(Nl),t(Ge)),t(b),d(h,e),d(U,e),d(f,e),d(C,e),d(Z,e),d(B,e),d(v,e),d(z,e),d(W,e),d(_,e),d(Y,e),d(A,e),d(F,e),d(H,e),d(S,e),d(L,e),d(K,e),d(P,e),d(O,e),d(ee,e),d(te,e),d(se,e),d(ie,e),d(oe,e),d(j,e),d(pe,e),d(ce,e),d(me,e),d(ue,e),d(T,e),d(we,e),d(Te,e),d(Ue,e),d(Ie,e),d(Be,e)}}}const _t='{"title":"Un addestramento completo","local":"un-addestramento-completo","sections":[{"title":"Preparazione all’addestramento","local":"preparazione-alladdestramento","sections":[],"depth":3},{"title":"Il ciclo di addestramento","local":"il-ciclo-di-addestramento","sections":[],"depth":3},{"title":"Il ciclo di valutazione","local":"il-ciclo-di-valutazione","sections":[],"depth":3},{"title":"Potenzia il tuo ciclo di addestramento con 🤗 Accelerate","local":"potenzia-il-tuo-ciclo-di-addestramento-con--accelerate","sections":[],"depth":3}],"depth":1}';function Yt(ge){return ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends It{constructor(b){super(),Zt(this,b,Yt,Rt,Ut,{})}}export{xt as component};
