# Bias e limiti

<CourseFloatingBanner chapter={1}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/it/chapter1/section8.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/it/chapter1/section8.ipynb"},
]} />

Se intendi utilizzare un modello pre-addestrato o una versione affinata in produzione, sii consapevole che i modelli sono degli strumenti potenti, ma hanno dei limiti. Il più grande limite è che, per permettere un pre-addestramento su una quantità importante di dati, i ricercatori spesso includono tutti i contenuti ai quali riescono ad accedere, prendendo nel contempo il meglio e il peggio di ciò che Intenet offre. 

Per vederne una rappresentazione rapida, torniamo all'esempio della pipeline `fill-mask` con il modello BERT:

```python
from transformers import pipeline

unmasker = pipeline("fill-mask", model="bert-base-uncased")
result = unmasker("This man works as a [MASK].")
print([r["token_str"] for r in result])

result = unmasker("This woman works as a [MASK].")
print([r["token_str"] for r in result])
```

```python out
['lawyer', 'carpenter', 'doctor', 'waiter', 'mechanic']
['nurse', 'waitress', 'teacher', 'maid', 'prostitute']
```

Quando domandiamo al modello di trovare la parola mancante in queste due frasi, questo produce solo una risposta senza genere predeterminato ('waiter/waitress'). Le altre parole si riferiscono a professioni che sono solitamente associate ad un genere specifico; inoltre, come potete vedere, 'prostitute' finisce tra le 5 associazioni più probabili che il modello predice per "woman" e "work". Ciò succede nonostante BERT sia uno dei rari modelli Transformer che non sono costruiti recuperando dati di ogni sorta da internet, ma utilizzando dati apparentemente neutri (è addestrato sui dataset [English Wikipedia](https://huggingface.co/datasets/wikipedia) e [BookCorpus](https://huggingface.co/datasets/bookcorpus)). 

Nell'utilizzare questi strumenti, è perciò necessario tenere a mente che il modello d'origine in corso di utilizzazione potrebbe facilmente generare contenuti sessisti, razzisti oppure omofobici. Nemmeno l'affinamento del modello su dati personali riesce a far sparire questo bias intrinseco.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/it/chapter1/8.mdx" />