# Quiz di fine capitolo

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

Mettiamo alla prova quello che avete imparato in questo capitolo!
  
### 1. Quali modelli si possono caricare sull'Hub?

<Question
	choices={[
		{
			text: "Modelli dalla libreria 🤗 Transformers.",
			explain: "I modelli della libreria 🤗 Transformers sono supportati dall'Hub di Hugging Face, ma non sono gli unici!"
		},
		{
			text: "Tutti i modelli con una interfaccia simile ai 🤗 Transformers.",
			explain: "Non ci sono requisiti relativi all'interfaccia quando si carica un modello sull'Hub di Hugging Face. "
		},
		{
			text: "Non ci sono limiti.",
			explain: "Esatto! Non ci sono limiti quando si carica un modello sull'Hub.",
            correct: true
		},
        {
			text: "Modelli che sono in qualche modo relativi all'NLP.",
			explain: "Non ci sono requisiti relativi al campo di applicazione!"
		}
	]}
/>

### 2. Come si gestisce un modello sull'Hub?

<Question
	choices={[
		{
			text: "Attraverso un account GCP.",
			explain: "Sbagliato!"
		},
		{
			text: "Attraverso un sistema di distribuzione peer-to-peer.",
			explain: "Sbagliato!"
		},
		{
			text: "Attraverso git e git-lfs.",
			explain: "Corretto! I modelli sull'Hub sono semplici repository Git, che usano <code>git-lfs</code> per i file di grandi dimensioni.",
            correct: true
		}
	]}
/>

### 3. Cosa si può fare attraverso l'interfacca web di Hugging Face Hub? 

<Question
	choices={[
		{
			text: "Effettuare un fork di un repository esistente.",
			explain: "Non è possibile effettuare fork di repository sull'Hugging Face Hub."
		},
		{
			text: "Creare un nuvo repository di un modello.",
			explain: "Corretto! Però si può fare anche altro.",
            correct: true
		},
		{
			text: "Gestire ed editare file.",
			explain: "Corretto! Ma non è l'unica risposta giusta.",
            correct: true
		},
        {
			text: "Caricare file.",
			explain: "Giusto! Ma non è tutto.",
            correct: true
		},
        {
			text: "Visualizzare le differenze tra le versioni.",
			explain: "Corretto! Però si può fare anche altro.",
            correct: true
		}
	]}
/>

### 4. Cos'è il cartellino del modello?

<Question
	choices={[
		{
			text: "Una descrizione approssimativa del modello, e pertanto meno importante dei file del modello e del tokenizer.",
			explain: "È effettivamente una descrizione del modello, ma è molto importante: se incompleto o mancante, l'utilità del modello è ridotta drasticamente."
		},
		{
			text: "Un modo per assicurare riproducibilità, riutilizzo, e correttezza.",
			explain: "Corretto! Condividere le informazioni giuste sul cartellino aiuterà gli utenti a utilizzare il vostro modello ed essere a conoscenza dei suoi limiti e bias.",
            correct: true
		},
		{
			text: "Un file Python che può essere eseguito per ottenere informazioni sul modello.",
			explain: "I cartellini sono semplici file Markdown."
		}
	]}
/>

### 5. QUali di questi oggetti della libreria 🤗 Transformers può essere direttamente condiviso sull'Hub con `push_to_hub()`?

{#if fw === 'pt'}
<Question
	choices={[
		{
			text: "Un tokenizer",
			explain: "Corretto! Tutti i tokenizers hanno il metodo <code>push_to_hub</code>, che carica tutti i file del tokenizer (vocabolario, architettura del tokenizer, ecc.) su un repository specificatoo. Questa non è l'unica risposta giusta però!",
            correct: true
		},
		{
			text: "La configurazione di un modello",
			explain: "Vero! Gli oggetti di contennti la configurazione di tutti i modelli hanno il metodo <code>push_to_hub</code>, che li carica su un repository specificato. Cosa altro si può condividere?",
            correct: true
		},
		{
			text: "Un modello",
			explain: "Corretto! Tutti i modelli hanno il metodo <code>push_to_hub</code>, e utilizzandolo si possono caricare, insieme ai loro file di configurazione, su un repository specificato. Si possono condividere anche altre cose.",
            correct: true
		},
        {
			text: "Un Trainer",
			explain: "Giusto — l'oggetto <code>Trainer</code> implementa il metodo <code>push_to_hub</code>, e utilizzandolo, si possono caricare modello, configurazione, tokenizer, e cartellino su un repository specificato. Prova un'altra risposta!",
            correct: true
		}
	]}
/>
{:else}
<Question
	choices={[
		{
			text: "Un tokenizer",
			explain: "Corretto! Tutti i tokenizers hanno il metodo <code>push_to_hub</code>, che carica tutti i file del tokenizer (vocabolario, architettura del tokenizer, ecc.) su un repository specificatoo. Questa non è l'unica risposta giusta però!",
            correct: true
		},
		{
			text: "La configurazione di un modello",
			explain: "Vero! Gli oggetti di contennti la configurazione di tutti i modelli hanno il metodo <code>push_to_hub</code>, che li carica su un repository specificato. Cosa altro si può condividere?",
            correct: true
		},
		{
			text: "Un modello",
			explain: "Corretto! Tutti i modelli hanno il metodo <code>push_to_hub</code>, e utilizzandolo si possono caricare, insieme ai loro file di configurazione, su un repository specificato. Si possono condividere anche altre cose.",
            correct: true
		},
		{
			text: "Tutti i precedenti, usando una callback dedicata",
			explain: "Giusto — la callback <code>PushToHubCallback</code> caricherà tutti questi oggetti su un repository regolarmente durante l'addestramento.",
            correct: true
		}
	]}
/>
{/if}

### 6. Qual è il primo passo da fare quando si usano il metodo `push_to_hub()` o gli strumenti da riga di comando (CLI)?

<Question
	choices={[
		{
			text: "Log in sul sito web.",
			explain: "Questo non vi sarà utile mentre lavorate sulla vostra macchina locale."
		},
		{
			text: "Eseguire 'huggingface-cli login' in un terminale.",
			explain: "Corretto — questo scaricherà e salverà in una cartella di cache il vostro token di autenticazione personale.",
            correct: true
		},
		{
			text: "Eseguire 'notebook_login()' in un notebook.",
			explain: "Corretto — questo mostrerà un widget che permette di autenticarsi.",
            correct: true
		},
	]}
/>

### 7. Se state usando un modello e un tokenizer — come li caricate sull'Hub?

<Question
	choices={[
		{
			text: "Usando direttamente il metodo push_to_hub su modello e tokenizer.",
			explain: "Corretto!",
            correct: true
		},
		{
			text: "All'interno di un runtime di Python, facendo wrapping di entrambi con l'utility <code>huggingface_hub</code>.",
			explain: "Modelli e tokenizer beneficiano già delle utilities di <code>huggingface_hub</code>: non c'è bisogno di wrapping addizionale!"
		},
		{
			text: "Salvandoli su disco e invocando il comando <code>transformers-cli upload-model</code>",
			explain: "Il commando <code>upload-model</code> non esiste."
		}
	]}
/>

### 8. Quali operazioni di git si possono fare con la classe `Repository`?

<Question
	choices={[
		{
			text: "git commit.",
			explain: "Corretto, il metodo <code>git_commit()</code> è li per questo.",
            correct: true
		},
		{
			text: "git pull",
			explain: "Questa è la funzione del metodo <code>git_pull()</code>.",
            correct: true
		},
		{
			text: "git push",
			explain: "Il metodo <code>git_push()</code> fa esattamente questo.",
            correct: true
		},
		{
			text: "git merge",
			explain: "No, questa operazione non è possibile con questa API."
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/it/chapter4/6.mdx" />