# Creare la tua prima demo

<CourseFloatingBanner chapter={9}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter9/section2.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter9/section2.ipynb"},
]} />

Iniziamo installando Gradio! Essendo una libreria di Python, è sufficiente eseguire:

`$ pip install gradio `

Puoi usare Gradio ovunque, dalla tua IDE Python preferita, ai Jupyter notebook o anche in Google Colab 🤯!
Quindi, installa Gradio in qualsiasi posto in cui usi Python!

Iniziamo con un semplice esempio "Hello World" per prendere familiarità con la sintassi di Gradio:

```py
import gradio as gr


def greet(name):
    return "Hello " + name


demo = gr.Interface(fn=greet, inputs="text", outputs="text")

demo.launch()
```

Analizziamo il codice qui sopra:

- Per prima cosa, definiamo una funzione chiamata `greet()`. In questo caso, si tratta di una semplice funzione che aggiunge "Hello" prima di un nome (_name_), ma questa può essere in generale *qualsiasi* funzione in Python. Ad esempio, nelle applicazioni di machine learning, questa funzione *chiamerebbe un modello per fare una previsione* su un input e restituirebbe l'output.
- Creaiamo puoi una `Interface` (_Interfaccia_) di Gradio con tre argomenti, `fn`, `inputs`, e `outputs`. Questi argomenti definiscono la funzione di predizione e il _tipo_ di componenti di ingresso e di uscita che desideriamo. Nel nostro caso, entrambi i componenti sono semplici caselle di testo.
- Chiamiamo poi il metodo `launch()` sul `Interface` creata.

Se si esegue questo codice, l'interfaccia qui sotto apparirà automaticamente all'interno di un Jupyter/Colab notebook, o comparirà in un browser  **[http://localhost:7860](http://localhost:7860/)** se lanciato in uno script.

<iframe src="https://course-demos-hello-world.hf.space" frameBorder="0" height="250" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Prova subito a utilizzare questa GUI con il tuo nome o con un altro input!

Si noterà che in questa GUI, Gradio ha riconosciuto automaticamente il nome del parametro di input (`name`)
e lo applica come etichetta in cima alla casella di testo. E se si volesse cambiarlo?
O se si volesse personalizzare la casella di testo in qualche altro modo? In questo caso, si può
istanziare una classe che rappresenti il componente in input.

Si osservi l'esempio seguente:

```py
import gradio as gr


def greet(name):
    return "Hello " + name


# We instantiate the Textbox class
textbox = gr.Textbox(label="Type your name here:", placeholder="John Doe", lines=2)

gr.Interface(fn=greet, inputs=textbox, outputs="text").launch()
```

<iframe src="https://course-demos-hello-world-custom.hf.space" frameBorder="0" height="300" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Qui abbiamo creato una casella di testo di input con un'etichetta (`label`), un segnaposto (`placeholder`) e un numero di righe stabilito (`lines`).
Si potrebbe fare lo stesso per la casella di testo in output, ma per ora ci fermiamo qui.

Abbiamo visto che con poche righe di codice, Gradio consente di creare una semplice interfaccia intorno a qualsiasi funzione
con qualsiasi tipo di input o output. In questa sezione abbiamo iniziato con una 
semplice casella di testo, ma nelle prossime sezioni tratteremo altri tipi di input e output. Vediamo ora di inserire un po' di NLP in un'applicazione Gradio.


## 🤖 Includere le predizioni del modello

Costruiamo ora una semplice interfaccia che consenta di dimostrare come funziona un modello di **generazione del testo** come GPT-2.

Caricheremo il nostro modello usando la funzione `pipeline()` di 🤗 Transformers.
Se hai bisogno di un rapido ripasso, puoi tornare a [quella sezione nel Capitolo 1](/course/chapter1/3#text-generation).

Per prima cosa, definiamo una funzione di predizione che riceve un prompt di testo e restituisce il testo completato:

```py
from transformers import pipeline

model = pipeline("text-generation")


def predict(prompt):
    completion = model(prompt)[0]["generated_text"]
    return completion
```

Questa funzione completa le richieste fornite dall'utente e puoi eseguirla con qualche tuo input per vedere come funziona. Ecco un esempio (potresti ottenere un risultato diverso):

```
predict("My favorite programming language is")
```

```
>> My favorite programming language is Haskell. I really enjoyed the Haskell language, but it doesn't have all the features that can be applied to any other language. For example, all it does is compile to a byte array.
```

Ora che abbiamo una funzione per generare previsioni, possiamo creare e lanciare una `Interface` nello stesso modo in cui abbiamo fatto prima:

```py
import gradio as gr

gr.Interface(fn=predict, inputs="text", outputs="text").launch()
```


Ecco fatto! Ora è possibile utilizzare questa interfaccia per generare testo utilizzando il modello GPT-2 come mostrato qui sotto 🤯.

<iframe src="https://course-demos-gpt-2.hf.space" frameBorder="0" height="300" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Continua a leggere per scoprire come costruire altri tipi di demo con Gradio!

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/it/chapter9/2.mdx" />