# Sequence-to-sequence モデル

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

<Youtube id="0_4KEb08xrE" />

Encoder-decoderモデル（*sequence-to-sequence models*とも呼ばれる）はTransformerアーキテクチャのエンコーダーとデコーダーの両方を使用します。
それぞれのステージにおいて、エンコーダーのアテンション層は入力文のすべての単語にアクセスできるのに対して、デコーダーのアテンション層は入力中のある単語の前に位置する単語にのみアクセスできます。

これらのモデルの事前学習は、エンコーダー、またはデコーダーの学習と同じように行われますが、通常はより複雑な方法を含みます。
例えば、[T5](https://huggingface.co/t5-base) は、特殊な単語で文中のスパン（複数の単語を含むことができる）をランダムにマスクしたときに、そのマスクされた文を予測する事を目的として事前学習されています。

Sequence-to-sequenceモデルは、要約、翻訳、質問応答生成などのように、与えられた入力文に対して新しい文を生成するタスクにとても適しています。

これらの系統のモデルの代表は次のとおりです:

- [BART](https://huggingface.co/transformers/model_doc/bart.html)
- [mBART](https://huggingface.co/transformers/model_doc/mbart.html)
- [Marian](https://huggingface.co/transformers/model_doc/marian.html)
- [T5](https://huggingface.co/transformers/model_doc/t5.html)


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ja/chapter1/7.mdx" />