# Introdução

Bem-vindo(a) ao curso da Hugging Face! Essa introdução te guiará para a configuração do ambiente de trabalho. Se você está começando agora o curso, nós recomendamos que você primeiramente dê uma olhada no [Capítulo 1](/course/chapter1), para só então voltar aqui, configurar o ambiente e começar a por a mão no código.

Todas as bibliotecas que usaremos nesse curso estão disponíveis como pacotes do Python, então aqui iremos te mostrar como configurar o ambiente no Python e instalar as bibliotecas específicas que você precisará.

Abordaremos 2 modos de configurar o ambiente, usando um Colab notebook ou um ambiente virtual Python. Fique à vontade para escolher o que mais fizer sentido para você.  Para os iniciantes, recomendamos fortemente que vocês iniciem pelo Colab notebook.

Note que nós não iremos cobrir o básico sobre o Windows. Se você estiver usando o Windows, recomendamos seguir as instruções pelo Colab notebook. Se estiver usando Linux ou macOS, você pode escolher qualquer uma das abordagens descritas aqui.

A maior parte do curso depende de você ter uma conta na Hugging Face. Recomendamos criar uma agora [criar uma conta](https://huggingface.co/join).

## Usando um notebook Google Colab
Usar um notebook Colab é a maneira mais simples possível de configuração, coloque um notebook no seu navegador e se prepare para a codificação!

Se você não está familiarizado com o Colab, recomendamos seguir essa [introdução]
(https://colab.research.google.com/notebooks/intro.ipynb). O Colab permitirá você usar algumas acelerações de hardware, como GPUs ou TPUs, e é gratuito para ambientes de trabalho pequenos.

Uma vez que você estiver confortável com o ambiente do Colab, crie um novo notebook e comece com essa configuração:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/new_colab.png" alt="An empty colab notebook" width="80%"/>
</div>

O próximo passo é instalar as bibliotecas que serão usadas nesse curso. Usaremos `pip` para a instalação, que é o gerenciador de pacotes do Python. Nos notebooks, você pode rodar os comandos do sistema precedendo do caractere `!`, então você poderá instalar a biblioteca 🤗 Transformers da seguinte forma:

```
!pip install transformers
```

Você pode assegurar que o pacote foi instalado corretamente por meio de sua importação dentro do ambiente de execução do Python:

```
import transformers
```

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter0/install.gif" alt="A gif showing the result of the two commands above: installation and import" width="80%"/>
</div>

Isso instalará uma versão bem leve da 🤗 Transformers. Em particular, nenhum framework de aprendizagem de máquina (como PyTorch ou TensorFlow) estão instalados. Desde que iremos usar bastante de suas features na biblioteca, recomendamos instalar a versão de desenvolvimento, que vem com todas as dependências requisitadas para cada caso de uso imaginável:

```
!pip install transformers[sentencepiece]
```

Isso levará um pouco de tempo, mas quando acabar você estará pronto/a para seguir o resto do curso!


## Usando um ambiente virtual Python

Se você perferir usar o ambiente virtual Python, o primeiro passo é instalar o Python no seu sistema. Nós recomendamos [esse guia](https://realpython.com/installing-python/) para começar.

Uma vez instalado o Python, você será capaz de rodar os comandos do Python em seu terminal. Você pode iniciar por rodar o seguinte comando para ter certeza que está instalado corretamente antes de iniciar os seguintes passos: `python --version`. Isso irá imprimir na tela a versão do Python disponível no seu sistema.

Quando você rodar um comando Python no seu terminal, como o `python --version`, você deve imaginar como um programa rodando seu comando como o "main" Python no seu sistema. Recomendamos manter essa instalação livre de qualquer pacote, e usando a para criar ambientes separados para cada aplicação que você for trabalhar - desse modo, cada aplicação pode ter suas próprias dependências e pacotes, e você não precisará se preocupar sobre potenciais problemas de compatibilidades com outras aplicações.

No Python isso é feito com [*ambientes virtuais*](https://docs.python.org/3/tutorial/venv.html), que é uma árvore de diretórios que contém a instalação do Python com uma versão particular do mesmo juntamente com todos os pacotes que a aplicação precisa. Criar um ambiente virtual como esse pode ser feito com inúmeras ferramentas, mas usaremos o pacote oficial do Python para esse propósito, que se chama [`venv`](https://docs.python.org/3/library/venv.html#module-venv).

Primeiro, crie o diretório que você gostaria que sua aplicação existisse - por exemplo, você pode querer criar um novo diretório chamado *curso-transformers* na raíz de seu diretório home:

```
mkdir ~/transformers-course
cd ~/transformers-course
```

Dentro desse diretório, crie um ambiente virtual usando o módulo Python `venv`:

```
python -m venv .env
```

Agora você deve ter dentro um diretório chamado *.env* em sua pasta vazia:

```
ls -a
```

```out
.      ..    .env
```

Você pode acessar e sair do seu ambiente virtual com os scripts `activate` e `deactivate`:

```
# Activate the virtual environment
source .env/bin/activate

# Deactivate the virtual environment
deactivate
```

Você pode ter certeza que seu ambiente virtual está ativado rodando o comando `which python`: se ele apontar para o ambiente virtual, então você conseguiu ativa-lo com sucesso!

```
which python
```

```out
/home/<user>/transformers-course/.env/bin/python
```

### Instalando dependências

Como na seção passada usando as instâncias do Google Colab, você precisará instalar os pacotes necessários para continuar. Novamente, você pode instalar a versão de desenvolvimento da 🤗 Transformers usando o gerenciador de pacotes `pip`:

```
pip install "transformers[sentencepiece]"
```

Você agora configurou tudo e está pronto para seguir!


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/pt/chapter0/1.mdx" />