# Introducere în Învățarea prin Întărire și rolul acesteia în LLM-uri

Bun venit la prima pagină!

Vom începe călătoria noastră în lumea captivantă a Învățării prin Întărire (RL) și vom descoperi cum aceasta revoluționează modul în care antrenăm Modelele de Limbaj precum cele pe care le-ai putea folosi în fiecare zi.

<Tip>

În acest capitol, ne concentrăm pe învățarea prin întărire pentru modelele de limbaj. Cu toate acestea, învățarea prin întărire este un domeniu larg cu multe aplicații dincolo de modelele de limbaj. Dacă ești interesat să înveți mai multe despre învățarea prin întărire, ar trebui să consulți [Cursul de Învățare prin Întărire Profundă](https://huggingface.co/courses/deep-rl-course/en/unit1/introduction).

</Tip>

Această pagină îți va oferi o introducere prietenoasă și clară în RL, chiar dacă nu ai întâlnit-o niciodată înainte. Vom descompune ideile principale și vom vedea de ce RL devine atât de important în domeniul Modelelor Mari de Limbaj (LLM-uri).

## Ce este Învățarea prin Întărire (RL)?

Imaginează-ți că antrenezi un câine. Vrei să-l înveți să stea. Ai putea spune "Stai!" și apoi, dacă câinele stă, îi dai o recompensă și îl lauzi. Dacă nu stă, ai putea să-l ghidezi blând sau doar să încerci din nou. De-a lungul timpului, câinele învață să asocieze statul cu recompensa pozitivă (recompensa și lauda) și este mai probabil să stea când spui "Stai!" din nou. În învățarea prin întărire, ne referim la acest feedback ca **recompensă**.

Aceasta, pe scurt, este ideea de bază din spatele Învățării prin Întărire! În loc de un câine, avem un **model de limbaj** (în învățarea prin întărire, îl numim **agent**), și în loc de tine, avem **mediul** care oferă feedback.

![RL terms Process](https://huggingface.co/reasoning-course/images/resolve/main/grpo/3.jpg)

Să descompunem elementele cheie ale RL:

### Agent

Acesta este cel care învață. În exemplul cu câinele, câinele este agentul. În contextul LLM-urilor, LLM-ul însuși devine agentul pe care vrem să-l antrenăm. Agentul este cel care ia decizii și învață din mediu și din recompensele sale.

### Mediu

Acesta este lumea în care trăiește și interacționează agentul. Pentru câine, mediul este casa ta și tu. Pentru un LLM, mediul este puțin mai abstract – ar putea fi utilizatorii cu care interacționează, sau un scenariu simulat pe care îl configurăm pentru el. Mediul oferă feedback agentului.

### Acțiune

Acestea sunt alegerile pe care agentul le poate face în mediu. Acțiunile câinelui sunt lucruri precum "stai", "ridică-te", "latră", etc. Pentru un LLM, acțiunile ar putea fi generarea de cuvinte într-o propoziție, alegerea ce răspuns să dea la o întrebare, sau deciderea cum să răspundă într-o conversație.

### Recompensă

Acesta este feedback-ul pe care mediul îl oferă agentului după ce acesta întreprinde o acțiune. Recompensele sunt de obicei numere.

**Recompensele pozitive** sunt ca recompensele și laudele – îi spun agentului "bună treabă, ai făcut ceva corect!".

**Recompensele negative** (sau penalitățile) sunt ca un "nu" blând – îi spun agentului "nu a fost tocmai corect, încearcă altceva". Pentru câine, recompensa este răsplata.

Pentru un LLM, recompensele sunt concepute să reflecte cât de bine se descurcă LLM-ul la o sarcină specifică – poate fi cât de util, adevărat sau inofensiv este răspunsul său.

### Politică

Aceasta este strategia agentului pentru alegerea acțiunilor. Este ca înțelegerea câinelui despre ce ar trebui să facă când spui "Stai!". În RL, politica este ceea ce încercăm cu adevărat să învățăm și să îmbunătățim. Este un set de reguli sau o funcție care îi spune agentului ce acțiune să întreprindă în diferite situații. Inițial, politica ar putea fi aleatorie, dar pe măsură ce agentul învață, politica devine mai bună la alegerea acțiunilor care duc la recompense mai mari.

## Procesul RL: Încercări și Erori

![RL Process](https://huggingface.co/reasoning-course/images/resolve/main/grpo/1.jpg)

Învățarea prin Întărire se întâmplă printr-un proces de încercări și erori:

| Pas | Proces | Descriere |
|------|---------|-------------|
| 1. Observație | Agentul observă mediul | Agentul preia informații despre starea sa actuală și împrejurimile |
| 2. Acțiune | Agentul întreprinde o acțiune bazată pe politica sa actuală | Folosind strategia sa învățată (politica), agentul decide ce să facă în continuare |
| 3. Feedback | Mediul îi oferă agentului o recompensă | Agentul primește feedback despre cât de bună sau rea a fost acțiunea sa |
| 4. Învățare | Agentul își actualizează politica bazată pe recompensă | Agentul își ajustează strategia - întărind acțiunile care au dus la recompense mari și evitând pe cele care au dus la recompense mici |
| 5. Iterație | Repetă procesul | Acest ciclu continuă, permițând agentului să-și îmbunătățească continuu luarea deciziilor |

Gândește-te la învățarea mersului pe bicicletă. Ai putea să te legeni și să cazi la început (recompensă negativă!). Dar când reușești să te echilibrezi și să pedalezi lin, te simți bine (recompensă pozitivă!). Îți ajustezi acțiunile bazat pe acest feedback – înclinându-te puțin, pedalând mai repede, etc. – până când înveți să mergi bine. RL este similar – se referă la învățarea prin interacțiune și feedback.

## Rolul RL în Modelele Mari de Limbaj (LLM-uri)

Acum, de ce este RL atât de important pentru Modelele Mari de Limbaj?

Ei bine, antrenarea LLM-urilor cu adevărat bune este complicată. Le putem antrena pe cantități masive de text de pe internet, și devin foarte bune la prezicerea următorului cuvânt într-o propoziție. Astfel învață să genereze text fluent și corect din punct de vedere gramatical, după cum am învățat în [capitolul 2](/course/chapter2/1).

Cu toate acestea, a fi doar fluent nu este suficient. Vrem ca LLM-urile noastre să fie mai mult decât bune la înșiruirea cuvintelor. Vrem ca ele să fie:

* **Utile:** Să ofere informații utile și relevante.  
* **Inofensive:** Să evite generarea de conținut toxic, părtinitor sau dăunător.  
* **Aliniate cu Preferințele Umane:** Să răspundă în moduri pe care oamenii le găsesc naturale, utile și captivante.

Metodele de pre-antrenare LLM, care se bazează în principal pe prezicerea următorului cuvânt din datele text, uneori nu reușesc în aceste aspecte.

În timp ce antrenamentul supervizat este excelent la producerea de rezultate structurate, poate fi mai puțin eficient la producerea de răspunsuri utile, inofensive și aliniate. Explorăm antrenamentul supervizat în [capitolul 11](/course/chapter11/1).

Modelele ajustate fin ar putea genera text fluent și structurat care este încă factual incorect, părtinitor, sau nu răspunde cu adevărat la întrebarea utilizatorului într-un mod util.

**Intră Învățarea prin Întărire!** RL ne oferă o modalitate de a ajusta fin aceste LLM-uri pre-antrenate pentru a atinge mai bine aceste calități dorite. Este ca să-i dai câinelui nostru LLM antrenament suplimentar pentru a deveni un companion bine comportat și util, nu doar un câine care știe să latre fluent!

## Învățarea prin Întărire din Feedback Uman (RLHF)

O tehnică foarte populară pentru alinierea modelelor de limbaj este **Învățarea prin Întărire din Feedback Uman (RLHF)**. În RLHF, folosim feedback-ul uman ca proxy pentru semnalul de "recompensă" în RL. Iată cum funcționează:

1. **Obține Preferințe Umane:** Am putea cere oamenilor să compare diferite răspunsuri generate de LLM pentru aceeași intrare și să ne spună ce răspuns preferă. De exemplu, am putea arăta unui om două răspunsuri diferite la întrebarea "Care este capitala Franței?" și să îl întrebăm "Care răspuns este mai bun?".

2. **Antrenează un Model de Recompensă:** Folosim aceste date de preferință umană pentru a antrena un model separat numit **model de recompensă**. Acest model de recompensă învață să prezică ce fel de răspunsuri vor prefera oamenii. Învață să evalueze răspunsurile bazat pe utilitate, inofensivitate și alinierea cu preferințele umane.

3. **Ajustează fin LLM-ul cu RL:** Acum folosim modelul de recompensă ca mediu pentru agentul nostru LLM. LLM-ul generează răspunsuri (acțiuni), și modelul de recompensă evaluează aceste răspunsuri (oferă recompense). În esență, antrenăm LLM-ul să producă text pe care modelul nostru de recompensă (care a învățat din preferințele umane) îl consideră bun.

![RL Basic Concept](https://huggingface.co/reasoning-course/images/resolve/main/grpo/2.jpg)  

Dintr-o perspectivă generală, să privim beneficiile folosirii RL în LLM-uri:

| Beneficiu | Descriere |
|---------|-------------|
| Control Îmbunătățit | RL ne permite să avem mai mult control asupra tipului de text pe care îl generează LLM-urile. Le putem ghida să producă text care este mai aliniat cu obiective specifice, cum ar fi a fi util, creativ sau concis. |
| Alinierea Îmbunătățită cu Valorile Umane | RLHF, în particular, ne ajută să aliniată LLM-urile cu preferințele umane complexe și adesea subiective. Este greu să scrii reguli pentru "ce face un răspuns bun," dar oamenii pot judeca și compara ușor răspunsurile. RLHF permite modelului să învețe din aceste judecăți umane. |
| Reducerea Comportamentelor Nedorite | RL poate fi folosit pentru a reduce comportamentele negative în LLM-uri, cum ar fi generarea de limbaj toxic, răspândirea dezinformării sau exhibarea prejudecăților. Prin conceperea recompenselor care penalizează aceste comportamente, putem îndemna modelul să le evite. |

Învățarea prin Întărire din Feedback Uman a fost folosită pentru a antrena multe dintre cele mai populare LLM-uri de astăzi, cum ar fi GPT-4 de la OpenAI, Gemini de la Google și R1 de la DeepSeek. Există o gamă largă de tehnici pentru RLHF, cu grade variate de complexitate și sofisticare. În acest capitol, ne vom concentra pe Optimizarea Relativă a Politicii de Grup (GRPO), care este o tehnică pentru RLHF care s-a dovedit eficientă la antrenarea LLM-urilor care sunt utile, inofensive și aliniate cu preferințele umane.

## De ce ar trebui să ne pese de GRPO (Optimizarea Relativă a Politicii de Grup)?

Există multe tehnici pentru RLHF, dar acest curs se concentrează pe GRPO pentru că reprezintă un progres semnificativ în învățarea prin întărire pentru modelele de limbaj.

Să considerăm pe scurt două dintre celelalte tehnici populare pentru RLHF:

- Optimizarea Politicii Proximale (PPO)
- Optimizarea Directă a Preferinței (DPO)

Optimizarea Politicii Proximale (PPO) a fost una dintre primele tehnici foarte eficiente pentru RLHF. Folosește o metodă de gradient de politică pentru a actualiza politica bazată pe recompensa de la un model de recompensă separat.

Optimizarea Directă a Preferinței (DPO) a fost dezvoltată mai târziu ca o tehnică mai simplă care elimină nevoia unui model de recompensă separat folosind datele de preferință direct. În esență, încadrează problema ca o sarcină de clasificare între răspunsurile alese și respinse.

<Tip>

DPO și PPO sunt algoritmi complecși de învățare prin întărire în sine, pe care nu îi vom acoperi în acest curs. Dacă ești interesat să înveți mai multe despre ei, poți consulta următoarele resurse:

- [Optimizarea Politicii Proximale](https://huggingface.co/docs/trl/main/en/ppo_trainer)
- [Optimizarea Directă a Preferinței](https://huggingface.co/docs/trl/main/en/dpo_trainer)

</Tip>

Spre deosebire de DPO și PPO, GRPO grupează eșantioane similare împreună și le compară ca grup. Abordarea bazată pe grup oferă gradienți mai stabili și proprietăți de convergență mai bune comparativ cu alte metode.

GRPO nu folosește date de preferință cum face DPO, ci în schimb compară grupuri de eșantioane similare folosind un semnal de recompensă de la un model sau funcție.

GRPO este flexibil în modul în care obține semnalele de recompensă - poate funcționa cu un model de recompensă (cum face PPO) dar nu necesită în mod strict unul. Aceasta pentru că GRPO poate încorpora semnale de recompensă de la orice funcție sau model care poate evalua calitatea răspunsurilor.

De exemplu, am putea folosi o funcție de lungime pentru a recompensa răspunsuri mai scurte, un rezolvitor matematic pentru a verifica corectitudinea soluției, sau o funcție de corectitudine factuală pentru a recompensa răspunsurile care sunt mai precise din punct de vedere factual. Această flexibilitate face GRPO deosebit de versatil pentru diferite tipuri de sarcini de aliniere.

---

Felicitări pentru completarea Modulului 1! Acum ai o introducere solidă în Învățarea prin Întărire și rolul său crucial în modelarea viitorului Modelelor Mari de Limbaj. Înțelegi conceptele de bază ale RL, de ce este folosit pentru LLM-uri, și ai fost introdus la GRPO, un algoritm cheie în acest domeniu.

În următorul modul, ne vom murdări mâinile și ne vom scufunda în lucrarea DeepSeek R1 pentru a vedea aceste concepte în acțiune!

## Quiz

### 1. Care sunt componentele cheie ale Învățării prin Întărire?

<Question
    choices={[
        {
            text: "Agent, Mediu, Acțiune, Recompensă și Politică",
            explain: "Corect! Acestea sunt componentele fundamentale care alcătuiesc un sistem de învățare prin întărire.",
            correct: true
        },
        {
            text: "Model, Date, Funcție de Pierdere și Optimizator",
            explain: "Acestea sunt componente mai des asociate cu învățarea supervizată."
        },
        {
            text: "Intrare, Ieșire și Straturi Ascunse",
            explain: "Acestea sunt componente ale arhitecturii rețelelor neuronale, nu specific componente RL."
        }
    ]}
/>

### 2. Care este principalul avantaj al RLHF pentru antrenarea modelelor de limbaj?

<Question
    choices={[
        {
            text: "Ajută la alinierea modelelor cu preferințele și valorile umane",
            explain: "Corect! RLHF folosește feedback-ul uman pentru a ghida modelele către un comportament mai util, inofensiv și aliniat.",
            correct: true
        },
        {
            text: "Face modelele să genereze text mai rapid",
            explain: "RLHF nu se concentrează în principal pe îmbunătățirea vitezei de generare."
        },
        {
            text: "Reduce utilizarea memoriei modelului",
            explain: "RLHF nu se concentrează pe eficiența modelului sau optimizarea memoriei."
        }
    ]}
/>

### 3. În contextul RL pentru LLM-uri, ce reprezintă o "acțiune"?

<Question
    choices={[
        {
            text: "Generarea de cuvinte sau alegerea răspunsurilor într-o conversație",
            explain: "Corect! Pentru LLM-uri, acțiunile implică de obicei decizii de generare a textului.",
            correct: true
        },
        {
            text: "Actualizarea greutăților modelului",
            explain: "Aceasta este parte din procesul de antrenare, nu o acțiune în contextul RL."
        },
        {
            text: "Procesarea token-urilor de intrare",
            explain: "Aceasta este parte din operațiunea modelului, nu o acțiune în contextul RL."
        }
    ]}
/>

### 4. Care este rolul recompenselor în antrenamentul RL al modelelor de limbaj?

<Question
    choices={[
        {
            text: "Să ofere feedback despre cât de bine se aliniază răspunsurile modelului cu comportamentul dorit",
            explain: "Corect! Recompensele ghidează modelul către generarea de răspunsuri mai utile, adevărate și apropiate.",
            correct: true
        },
        {
            text: "Să măsoare dimensiunea vocabularului modelului",
            explain: "Recompensele nu sunt folosite pentru a evalua cunoștințele vocabularului."
        },
        {
            text: "Să determine viteza de antrenare a modelului",
            explain: "Recompensele oferă feedback asupra calității răspunsului, nu asupra eficienței antrenamentului."
        }
    ]}
/>

### 5. Ce este o recompensă în contextul RL pentru LLM-uri?

<Question
    choices={[
        {
            text: "Un scor numeric care măsoară calitatea unui răspuns",
            explain: "Corect! Recompensele oferă feedback asupra calității răspunsului, ghidând modelul către comportamentul dorit.",
            correct: true
        },
        {
            text: "O funcție care generează răspunsuri",
            explain: "Recompensele sunt feedback asupra calității răspunsului, nu procesul de generare în sine."
        },
        {
            text: "Un model care evaluează calitatea răspunsurilor",
            explain: "Recompensele sunt feedback asupra calității răspunsului, nu un model de evaluare."
        }
    ]}
/> 

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter12/2.mdx" />