# Cum să ceri ajutor pe forumuri[[cum-sa-ceri-ajutor-pe-forumuri]]

<CourseFloatingBanner chapter={8}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter8/section3.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter8/section3.ipynb"},
]} />

<Youtube id="S2EEG3JIt2A"/>

[Forumurile Hugging Face](https://discuss.huggingface.co) sunt un loc excelent pentru a obține ajutor de la echipa open source și comunitatea mai largă Hugging Face. Iată cum arată pagina principală într-o zi obișnuită:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forums.png" alt="Forumurile Hugging Face." width="100%"/>
</div>

În partea stângă puteți vedea toate categoriile în care sunt grupate diversele subiecte, în timp ce partea dreaptă arată subiectele cele mai recente. Un subiect este o postare care conține un titlu, o categorie și o descriere; este destul de similar cu formatul GitHub issues pe care l-am văzut când am creat propriul nostru set de date în [Capitolul 5](/course/chapter5). Așa cum sugerează numele, categoria [Beginners](https://discuss.huggingface.co/c/beginners/5) este destinată în principal persoanelor care abia încep cu bibliotecile și ecosistemul Hugging Face. Orice întrebare despre oricare dintre biblioteci este binevenită acolo, fie pentru a depana cod sau pentru a cere ajutor despre cum să faci ceva. (Totuși, dacă întrebarea ta se referă la o bibliotecă în particular, probabil ar trebui să mergi la categoria corespunzătoare a bibliotecii pe forum.)

În mod similar, categoriile [Intermediate](https://discuss.huggingface.co/c/intermediate/6) și [Research](https://discuss.huggingface.co/c/research/7) sunt pentru întrebări mai avansate, de exemplu despre biblioteci sau despre cercetări NLP noi și interesante pe care ați dori să le discutați.

Și, în mod natural, ar trebui să menționăm și categoria [Course](https://discuss.huggingface.co/c/course/20), unde puteți pune orice întrebări aveți care sunt legate de cursul Hugging Face!

Odată ce ați selectat o categorie, veți fi gata să scrieți primul vostru subiect. Puteți găsi câteva [ghiduri](https://discuss.huggingface.co/t/how-to-request-support/3128) pe forum despre cum să faceți acest lucru, și în această secțiune vom arunca o privire asupra unor caracteristici care alcătuiesc un subiect bun.

## Scrierea unei postări bune pe forum[[scrierea-unei-postari-bune-pe-forum]]

Ca exemplu în curs de desfășurare, să presupunem că încercăm să generăm embeddings din articole Wikipedia pentru a crea un motor de căutare personalizat. Ca de obicei, încărcăm tokenizer-ul și modelul după cum urmează:

```python
from transformers import AutoTokenizer, AutoModel

model_checkpoint = "distilbert-base-uncased"
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)
model = AutoModel.from_pretrained(model_checkpoint)
```

Acum să presupunem că încercăm să încorporăm o întreagă secțiune din [articolul Wikipedia](https://en.wikipedia.org/wiki/Transformers) despre Transformers (franciza, nu biblioteca!):

```python
text = """
Generation One is a retroactive term for the Transformers characters that
appeared between 1984 and 1993. The Transformers began with the 1980s Japanese
toy lines Micro Change and Diaclone. They presented robots able to transform
into everyday vehicles, electronic items or weapons. Hasbro bought the Micro
Change and Diaclone toys, and partnered with Takara. Marvel Comics was hired by
Hasbro to create the backstory; editor-in-chief Jim Shooter wrote an overall
story, and gave the task of creating the characthers to writer Dennis O'Neil.
Unhappy with O'Neil's work (although O'Neil created the name "Optimus Prime"),
Shooter chose Bob Budiansky to create the characters.

The Transformers mecha were largely designed by Shōji Kawamori, the creator of
the Japanese mecha anime franchise Macross (which was adapted into the Robotech
franchise in North America). Kawamori came up with the idea of transforming
mechs while working on the Diaclone and Macross franchises in the early 1980s
(such as the VF-1 Valkyrie in Macross and Robotech), with his Diaclone mechs
later providing the basis for Transformers.

The primary concept of Generation One is that the heroic Optimus Prime, the
villainous Megatron, and their finest soldiers crash land on pre-historic Earth
in the Ark and the Nemesis before awakening in 1985, Cybertron hurtling through
the Neutral zone as an effect of the war. The Marvel comic was originally part
of the main Marvel Universe, with appearances from Spider-Man and Nick Fury,
plus some cameos, as well as a visit to the Savage Land.

The Transformers TV series began around the same time. Produced by Sunbow
Productions and Marvel Productions, later Hasbro Productions, from the start it
contradicted Budiansky's backstories. The TV series shows the Autobots looking
for new energy sources, and crash landing as the Decepticons attack. Marvel
interpreted the Autobots as destroying a rogue asteroid approaching Cybertron.
Shockwave is loyal to Megatron in the TV series, keeping Cybertron in a
stalemate during his absence, but in the comic book he attempts to take command
of the Decepticons. The TV series would also differ wildly from the origins
Budiansky had created for the Dinobots, the Decepticon turned Autobot Jetfire
(known as Skyfire on TV), the Constructicons (who combine to form
Devastator),[19][20] and Omega Supreme. The Marvel comic establishes early on
that Prime wields the Creation Matrix, which gives life to machines. In the
second season, the two-part episode The Key to Vector Sigma introduced the
ancient Vector Sigma computer, which served the same original purpose as the
Creation Matrix (giving life to Transformers), and its guardian Alpha Trion.
"""

inputs = tokenizer(text, return_tensors="pt")
logits = model(**inputs).logits
```

```python output
IndexError: index out of range in self
```

Uh-oh, am întâmpinat o problemă -- și mesajul de eroare este mult mai criptic decât cele pe care le-am văzut în [secțiunea 2](/course/chapter8/section2)! Nu putem înțelege nimic din traceback-ul complet, așa că decidem să ne îndreptăm către forumurile Hugging Face pentru ajutor. Cum am putea să formulăm subiectul?

Pentru a începe, trebuie să facem clic pe butonul "New Topic" din colțul din dreapta sus (rețineți că pentru a crea un subiect, va trebui să fim conectați):

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forums-new-topic.png" alt="Crearea unui nou subiect pe forum." width="100%"/>
</div>

Aceasta deschide o interfață de scriere unde putem introduce titlul subiectului nostru, să selectăm o categorie și să redactăm conținutul:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic01.png" alt="Interfața pentru crearea unui subiect pe forum." width="100%"/>
</div>

Deoarece eroarea pare să fie exclusiv despre 🤗 Transformers, vom selecta aceasta pentru categorie. Prima noastră încercare de a explica problema ar putea arăta cam așa:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic02.png" alt="Redactarea conținutului pentru un nou subiect pe forum." width="100%"/>
</div>

Deși acest subiect conține mesajul de eroare cu care avem nevoie de ajutor, există câteva probleme cu modul în care este scris:

1. Titlul nu este foarte descriptiv, așa că oricine navighează pe forum nu va putea să spună despre ce este subiectul fără să citească și conținutul.
2. Corpul nu oferă suficiente informații despre _de unde_ vine eroarea și _cum_ să o reproduci.
3. Subiectul etichetează câteva persoane direct cu un ton oarecum exigent.

Subiecte ca acesta probabil nu vor primi un răspuns rapid (dacă primesc unul deloc), așa că să vedem cum îl putem îmbunătăți. Vom începe cu prima problemă de a alege un titlu bun.

### Alegerea unui titlu descriptiv[[alegerea-unui-titlu-descriptiv]]

Dacă încercați să obțineți ajutor cu o eroare în codul vostru, o regulă bună este să includeți suficiente informații în titlu astfel încât alții să poată determina rapid dacă cred că pot răspunde la întrebarea voastră sau nu. În exemplul nostru în curs de desfășurare, știm numele excepției care este ridicată și avem câteva indicii că este declanșată în forward pass-ul modelului, unde apelăm `model(**inputs)`. Pentru a comunica aceasta, un titlu posibil ar putea fi:

> Sursa IndexError în forward pass-ul AutoModel?

Acest titlu îi spune cititorului _de unde_ credeți că vine eroarea, și dacă au întâlnit un `IndexError` înainte, există o șansă bună că vor ști cum să îl depaneze. Desigur, titlul poate fi orice doriți, și alte variații precum:

> De ce modelul meu produce un IndexError?

ar putea fi de asemenea bune. Acum că avem un titlu descriptiv, să ne uităm la îmbunătățirea corpului.

### Formatarea fragmentelor de cod[[formatarea-fragmentelor-de-cod]]

Citirea codului sursă este destul de grea într-un IDE, dar este și mai grea când codul este copiat și lipit ca text simplu! Din fericire, forumurile Hugging Face suportă utilizarea Markdown, așa că ar trebui să înconjurați întotdeauna blocurile de cod cu trei backtick-uri (```) astfel încât să fie mai ușor de citit. Să facem aceasta pentru a înfrumuseța mesajul de eroare -- și în timp ce suntem la asta, să facem corpul puțin mai politicos decât versiunea noastră originală:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic03.png" alt="Subiectul nostru revizuit pe forum, cu formatarea corectă a codului." width="100%"/>
</div>

Așa cum puteți vedea în captură, înconjurarea blocurilor de cod în backtick-uri transformă textul brut în cod formatat, complet cu stilizare color! De asemenea, rețineți că backtick-urile simple pot fi folosite pentru a formata variabile inline, așa cum am făcut pentru `distilbert-base-uncased`. Acest subiect arată mult mai bine, și cu puțin noroc am putea găsi pe cineva în comunitate care poate ghici despre ce este eroarea. Cu toate acestea, în loc să ne bazăm pe noroc, să facem viața mai ușoară prin includerea traceback-ului în toată splendoarea sa!

### Includerea traceback-ului complet[[includerea-traceback-ului-complet]]

Deoarece ultima linie a traceback-ului este adesea suficientă pentru a vă depana propriul cod, poate fi tentant să furnizați doar aceea în subiectul vostru pentru a "economisi spațiu". Deși este bine intenționat, aceasta de fapt face _mai greu_ pentru alții să depaneze problema deoarece informațiile care sunt mai sus în traceback pot fi de asemenea foarte utile. Deci, o practică bună este să copiați și să lipiți _întregul_ traceback, asigurându-vă că este frumos formatat. Deoarece aceste traceback-uri pot deveni destul de lungi, unii oameni preferă să le arate după ce au explicat codul sursă. Să facem aceasta. Acum, subiectul nostru pe forum arată astfel:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic04.png" alt="Exemplul nostru de subiect pe forum, cu traceback-ul complet." width="100%"/>
</div>

Aceasta este mult mai informativă, și un cititor atent ar putea fi capabil să indice că problema pare să se datoreze trecerii unei intrări lungi din cauza acestei linii în traceback:

> Token indices sequence length is longer than the specified maximum sequence length for this model (583 > 512).

Cu toate acestea, putem face lucrurile și mai ușoare pentru ei prin furnizarea codului real care a declanșat eroarea. Să facem asta acum.

### Furnizarea unui exemplu reproductibil[[furnizarea-unui-exemplu-reproductibil]]

Dacă ați încercat vreodată să depanați codul altcuiva, probabil că ați încercat mai întâi să recreați problema pe care au raportat-o astfel încât să puteți începe să vă faceți drumul prin traceback pentru a identifica eroarea. Nu este diferit când vine vorba de a obține (sau a da) asistență pe forumuri, așa că ajută cu adevărat dacă puteți furniza un exemplu mic care reproduce eroarea. Jumătate din timp, simpla parcurgere a acestui exercițiu vă va ajuta să vă dați seama ce merge prost. În orice caz, piesa lipsă din exemplul nostru este să arătăm _intrările_ pe care le-am furnizat modelului. Făcând aceasta ne dă ceva ca următorul exemplu completat:

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic05.png" alt="Versiunea finală a subiectului nostru pe forum." width="100%"/>
</div>

Acest subiect conține acum destul de multe informații și este scris într-un mod care este mult mai probabil să atragă atenția comunității și să primească un răspuns util. Cu aceste ghiduri de bază, puteți acum crea subiecte grozave pentru a găsi răspunsurile la întrebările voastre 🤗 Transformers! 

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter8/3.mdx" />