# Integrări cu Hugging Face Hub[[integrations-with-the-hugging-face-hub]]

<CourseFloatingBanner chapter={9}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section5.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section5.ipynb"},
]} />

Pentru a vă face viața și mai ușoară, Gradio se integrează direct cu Hugging Face Hub și Hugging Face Spaces.
Puteți încărca demo-uri din Hub și Spaces cu o singură *linie de cod*.

### Încărcarea modelelor din Hugging Face Hub[[loading-models-from-the-hugging-face-hub]]
Pentru a începe, alegeți unul dintre miile de modele pe care Hugging Face le oferă prin Hub, așa cum este descris în [Capitolul 4](/course/chapter4/2).

Folosind metoda specială `Interface.load()`, transmiteți `"model/"` (sau, echivalent, `"huggingface/"`) 
urmată de numele modelului. 
De exemplu, iată codul pentru a construi un demo pentru [GPT-J](https://huggingface.co/EleutherAI/gpt-j-6B), un model de limbaj mare, cu adăugarea a câtorva exemple de intrări:

```py
import gradio as gr

title = "GPT-J-6B"
description = "Gradio Demo for GPT-J 6B, a transformer model trained using Ben Wang's Mesh Transformer JAX. 'GPT-J' refers to the class of model, while '6B' represents the number of trainable parameters. To use it, simply add your text, or click one of the examples to load them. Read more at the links below."
article = "<p style='text-align: center'><a href='https://github.com/kingoflolz/mesh-transformer-jax' target='_blank'>GPT-J-6B: A 6 Billion Parameter Autoregressive Language Model</a></p>"

gr.Interface.load(
    "huggingface/EleutherAI/gpt-j-6B",
    inputs=gr.Textbox(lines=5, label="Input Text"),
    title=title,
    description=description,
    article=article,
).launch()
```
    
Codul de mai sus va produce interfața de mai jos:

<iframe src="https://course-demos-gpt-j-6B.hf.space" frameBorder="0" height="750" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Încărcarea unui model în acest mod folosește [API-ul de Inferență](https://huggingface.co/inference-api) de la Hugging Face,
în loc să încarce modelul în memorie. Acest lucru este ideal pentru modele uriașe precum GPT-J sau T0pp care
 necesită multă RAM.

### Încărcarea din Hugging Face Spaces[[loading-from-hugging-face-spaces]]
Pentru a încărca orice Space din Hugging Face Hub și a-l recrea local, puteți transmite `spaces/` la `Interface`, urmată de numele Space-ului.

Vă amintiți demo-ul din secțiunea 1 care elimina fundalul unei imagini? Să-l încărcăm din Hugging Face Spaces:

```py
gr.Interface.load("spaces/abidlabs/remove-bg").launch()
```

<iframe src="https://course-demos-remove-bg-original.hf.space" frameBorder="0" height="650" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Unul dintre lucrurile cool la încărcarea demo-urilor din Hub sau Spaces este că le puteți personaliza 
prin suprascrierea oricăruia dintre 
parametri. Aici, adăugăm un titlu și facem să funcționeze cu o webcam în schimb:

```py
gr.Interface.load(
    "spaces/abidlabs/remove-bg", inputs="webcam", title="Remove your webcam background!"
).launch()
```

<iframe src="https://course-demos-Remove-bg.hf.space" frameBorder="0" height="550" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Acum că am explorat câteva moduri de a integra Gradio cu Hugging Face Hub, să aruncăm o privire la câteva caracteristici avansate ale clasei `Interface`. Aceasta este tema următoarei secțiuni! 

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter9/5.mdx" />