# Quiz de final de capitol[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={9}
    classNames="absolute z-10 right-0 top-0"
/>

Să testăm ce ați învățat în acest capitol!

### 1. Pentru ce puteți folosi Gradio?

<Question
	choices={[
        {
			text: "Să creați un demo pentru modelul vostru de machine learning",
			explain: "Cu câteva linii de cod Python puteți genera un demo pentru modelul vostru ML folosind biblioteca noastră de componente pre-construite.",
			correct: true
		},
		{
			text: "Să partajați modelul vostru de machine learning cu alții",
			explain: "Folosind parametrul <code>share=True</code> în metoda launch, puteți genera un link de partajare pe care să îl trimiteți oricui.",
            correct: true
		},
		{
			text: "Să depanați modelul vostru",
			explain: "Un avantaj al unui demo gradio este să puteți testa modelul cu date reale pe care le puteți schimba și să observați predicțiile modelului schimbându-se în timp real, ajutându-vă să depanați modelul.",
			correct: true
		},
		{
			text: "Să antrenați modelul vostru",
			explain: "Gradio este conceput să fie folosit pentru inferența modelului, DUPĂ ce modelul este antrenat.",
		}
	]}
/>

### 2. Gradio funcționează DOAR cu modele PyTorch

<Question
	choices={[
        {
			text: "Adevărat",
			explain: "Gradio funcționează cu modele PyTorch, dar funcționează și pentru orice tip de model de machine learning!"
        },
        {
			text: "Fals",
			explain: "Gradio este agnostic față de model, ceea ce înseamnă că puteți crea un demo pentru orice tip de model de machine learning.",
			correct: true
        }
	]}
/>

### 3. De unde puteți lansa un demo Gradio?

<Question
	choices={[
        {
			text: "IDE-uri Python standard",
			explain: "Gradio funcționează excelent cu IDE-ul vostru preferat.",
            correct: true
        },
        {
			text: "Notebook-uri Google Colab",
			explain: "Puteți crea și lansa un demo în notebook-ul vostru Google Colab.",
			correct: true
        },
        {
			text: "Notebook-uri Jupyter",
			explain: "Alegere bună - Puteți crea și lansa un demo în notebook-ul vostru Jupyter.",
			correct: true
        }
	]}
/>

### 4. Gradio este construit în primul rând pentru modele NLP

<Question
	choices={[
        {
			text: "Adevărat",
			explain: "Gradio funcționează cu aproape orice tip de date, nu doar NLP."
        },
        {
			text: "Fals",
			explain: "Gradio oferă dezvoltatorilor o bibliotecă de componente pre-construite pentru aproape toate tipurile de date.",
            correct: true
        }
	]}
/>

### 5. Care dintre următoarele caracteristici sunt suportate de Gradio?

<Question
	choices={[
        {
			text: "Intrări și ieșiri multiple",
			explain: "Intrări și ieșiri multiple sunt posibile cu gradio. Tot ce trebuie să faceți este să transmiteți o listă de intrări și ieșiri la parametrii corespunzători",
            correct: true
        },
        {
			text: "Stare pentru persistența datelor",
			explain: "Gradio este capabil să adauge stare la interfața voastră.",
			correct: true
        },
        {
			text: "Autentificare cu nume de utilizator și parole",
			explain: "Transmiteți o listă de tuple nume de utilizator/parolă la metoda `launch` pentru a adăuga autentificare.",
			correct: true
        },
        {
			text: "Analize automate pentru cine folosește demo-ul vostru gradio",
			explain: "Încercați din nou - Gradio nu oferă dezvoltatorilor analize despre cine folosește demo-urile lor."
        },
        {
			text: "Încărcarea unui model din hub-ul de modele Hugging Face sau Hugging Face Spaces",
			explain: "Absolut - încărcați orice model Hugging Face folosind metoda <code>gr.Interface.load()</code>",
			correct: true
        }
	]}
/>

### 6. Care dintre următoarele sunt moduri valide de a încărca un model Hugging Face din Hub sau Spaces?

<Question
	choices={[
        {
			text: "gr.Interface.load('huggingface/{user}/{model_name}')",
			explain: "Aceasta este o metodă validă de a încărca un model Hugging Face din Hub",
            correct: true
        },
        {
			text: "gr.Interface.load('model/{user}/{model_name}')",
			explain: "Aceasta este o metodă validă de a încărca un model Hugging Face din Hub",
			correct: true
        },
        {
			text: "gr.Interface.load('demos/{user}/{model_name}')",
			explain: "Încercați din nou -- nu puteți încărca un model folosind prefixul 'demos'."
        },
        {
			text: "gr.Interface.load('spaces/{user}/{model_name}')",
			explain: "Aceasta este o metodă validă de a încărca un model Hugging Face din Spaces",
			correct: true
        }
	]}
/>

### 7. Selectați toți pașii necesari pentru adăugarea stării la interfața voastră Gradio

<Question
	choices={[
        {
			text: "Transmiteți un parametru suplimentar în funcția voastră de predicție, care reprezintă starea interfeței.",
			explain: "Un parametru suplimentar care stochează istoricul sau starea interfeței voastre este necesar.",
            correct: true
        },
        {
			text: "La sfârșitul funcției de predicție, returnați valoarea actualizată a stării ca o valoare de returnare suplimentară.",
			explain: "Această valoare de istoric sau stare trebuie să fie returnată de funcția voastră.",
            correct: true
        },
        {
			text: "Adăugați componentele de intrare și ieșire de stare când creați Interface-ul vostru",
			explain: "Gradio oferă o componentă de intrare și ieșire de stare pentru a persista datele.",
            correct: true
        }
	]}
/>

### 8. Care dintre următoarele sunt componente incluse în biblioteca Gradio?

<Question
	choices={[
        {
			text: "Textbox.",
			explain: "Da, puteți crea cutii de text cu componenta Textbox.",
            correct: true
        },
        {
			text: "Graph.",
			explain: "În prezent nu există o componentă Graph.",
        },
        {
			text: "Image.",
			explain: "Da, puteți crea un widget de încărcare imagini cu componenta Image.",
            correct: true
        },
        {
			text: "Audio.",
			explain: "Da, puteți crea un widget de încărcare audio cu componenta Audio.",
            correct: true
        },
	]}
/>

### 9. Ce vă permite să faceți Gradio `Blocks`?

<Question
	choices={[
        {
			text: "Să combinați mai multe demo-uri într-o aplicație web",
			explain: "Puteți folosi `with gradio.Tabs():` pentru a adăuga file pentru mai multe demo-uri",
			correct: true
        },
        {
			text: "Să atribuiți declanșatori de evenimente precum clicked/changed/etc la componentele `Blocks`",
			explain: "Când atribuiți un eveniment, transmiteți trei parametri: fn: funcția care ar trebui apelată, inputs: (lista) componentei(lor) de intrare, și outputs: (lista) componentelor de ieșire care ar trebui apelate.",
			correct: true
        },
        {
			text: "Să determinați automat care componentă `Blocks` ar trebui să fie interactivă vs. statică",
			explain: "Pe baza declanșatorilor de evenimente pe care îi definiți, `Blocks` determină automat dacă o componentă ar trebui să accepte intrări de la utilizator sau nu.",
			correct: true
        },
		 {
			text: "Să creați demo-uri cu mai mulți pași; adică să vă permită să reutilizați ieșirea unei componente ca intrare la următoarea",
			explain: "Puteți folosi o componentă pentru intrarea unui declanșator de eveniment, dar ieșirea altuia.",
            correct: true
        },
	]}
/>

### 10. Puteți partaja un link public la un demo `Blocks` și puteți găzdui un demo `Blocks` pe Hugging Face spaces.

<Question
	choices={[
        {
			text: "Adevărat",
			explain: "La fel ca `Interface`, toate capacitățile de partajare și găzduire sunt aceleași pentru demo-urile `Blocks`!",
			correct: true
        },
        {
			text: "Fals",
			explain: "La fel ca `Interface`, toate capacitățile de partajare și găzduire sunt aceleași pentru demo-urile `Blocks`!",
			correct: false
        }
	]}
/> 

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ro/chapter9/9.mdx" />