import{s as Qa,o as Ba,n as Wa}from"../chunks/scheduler.cc52f4b9.js";import{S as Ra,i as Na,e as a,s as n,c as r,h as Xa,a as i,d as l,b as p,f as _a,g as c,j as M,k as rp,l as Aa,m as t,n as y,t as J,o as m,p as o}from"../chunks/index.9480bb2b.js";import{T as Ea}from"../chunks/Tip.f7b80743.js";import{C as Ga,H as ml,E as qa}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.e0b4ce23.js";import{Y as La}from"../chunks/Youtube.7b12d9e8.js";import{C as j}from"../chunks/CodeBlock.d991436c.js";import{C as Ha}from"../chunks/CourseFloatingBanner.0ea490da.js";function Sa(ol){let T,$=`<strong>Далее</strong> если вы протестируете две версии предыдущих нормализаторов на строке, содержащей символ Unicode <code>u&quot;\\u0085&quot;</code>, то наверняка заметите, что эти два нормализатора не совсем эквивалентны.<br/>
Чтобы не усложнять версию с <code>normalizers.Sequence</code>, мы не включили в нее Regex-замены, которые требует <code>BertNormalizer</code>, когда аргумент <code>clean_text</code> установлен в <code>True</code>, что является поведением по умолчанию. Но не волнуйтесь: можно получить точно такую же нормализацию без использования удобного <code>BertNormalizer</code>, добавив два <code>normalizers.Replace</code> в последовательность нормализаторов.`;return{c(){T=a("p"),T.innerHTML=$},l(u){T=i(u,"P",{"data-svelte-h":!0}),M(T)!=="svelte-kju4cm"&&(T.innerHTML=$)},m(u,yl){t(u,T,yl)},p:Wa,d(u){u&&l(T)}}}function Da(ol){let T,$,u,yl,k,jl,d,Tl,b,ul,w,cp="Как мы уже видели в предыдущих разделах, токенизация состоит из нескольких этапов:",fl,C,yp="<li>Нормализация (любая необходимая очистка текста, например, удаление пробелов или подчеркиваний, нормализация Unicode и т. д.)</li> <li>Предварительная токенизация (разделение входного текста на слова).</li> <li>Прогон входных данных через модель (использование предварительно токенизированных слов для создания последовательности токенов)</li> <li>Постобработка (добавление специальных токенов токенизатора, генерация маски внимания и идентификаторов типов токенов)</li>",Ul,g,Jp="В качестве напоминания вот еще один взгляд на общий процесс:",$l,f,mp='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline.svg" alt="The tokenization pipeline."/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline-dark.svg" alt="The tokenization pipeline."/>',kl,x,op='Библиотека 🤗 Tokenizers была создана для того, чтобы предоставить несколько вариантов каждого из этих шагов, которые вы можете смешивать и сочетать между собой. В этом разделе мы рассмотрим, как можно создать токенизатор с нуля, а не обучать новый токенизатор на основе старого, как мы делали в <a href="../chapter6/2">разделе 2</a>. После этого вы сможете создать любой токенизатор, который только сможете придумать!',dl,h,bl,I,jp="Точнее, библиотека построена вокруг центрального класса <code>Tokenizer</code>, а строительные блоки сгруппированы в подмодули:",wl,V,Tp='<li><code>normalizers</code> содержит все возможные типы нормализаторов текста <code>Normalizer</code>, которые вы можете использовать (полный список <a href="https://huggingface.co/docs/tokenizers/api/normalizers" rel="nofollow">здесь</a>).</li> <li><code>pre_tokenizers</code> содержит все возможные типы предварительных токенизаторов <code>PreTokenizer</code>, которые вы можете использовать (полный список <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">здесь</a>).</li> <li><code>models</code> содержит различные типы моделей <code>Model</code>, которые вы можете использовать, такие как <code>BPE</code>, <code>WordPiece</code> и <code>Unigram</code> (полный список <a href="https://huggingface.co/docs/tokenizers/api/models" rel="nofollow">здесь</a>).</li> <li><code>trainers</code> содержит все различные типы <code>Trainer</code>, которые вы можете использовать для обучения модели на корпусе (по одному на каждый тип модели; полный список <a href="https://huggingface.co/docs/tokenizers/api/trainers" rel="nofollow">здесь</a>).</li> <li><code>post_processors</code> содержит различные типы постпроцессоров <code>PostProcessor</code>, которые вы можете использовать (полный список <a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">здесь</a>).</li> <li><code>decoders</code> содержит различные типы декодеров <code>Decoder</code>, которые вы можете использовать для декодирования результатов токенизации (полный список <a href="https://huggingface.co/docs/tokenizers/components#decoders" rel="nofollow">здесь</a>).</li>',Cl,z,up='Весь список блоков вы можете найти <a href="https://huggingface.co/docs/tokenizers/components" rel="nofollow">здесь</a>.',gl,Z,xl,v,fp='Для обучения нашего нового токенизатора мы будем использовать небольшой корпус текстов (чтобы примеры выполнялись быстро). Шаги по сбору корпуса аналогичны тем, что мы делали в <a href="../chapter6/2">начале этой главы</a>, но на этот раз мы будем использовать набор данных <a href="https://huggingface.co/datasets/wikitext" rel="nofollow">WikiText-2</a>:',hl,_,Il,Q,Up="Функция <code>get_training_corpus()</code> - это генератор, который выдает батч из 1000 текстов, которые мы будем использовать для обучения токенизатора.",Vl,B,$p="🤗 Токенизаторы также можно обучать непосредственно на текстовых файлах. Вот как мы можем сгенерировать текстовый файл, содержащий все тексты/входы из WikiText-2, который мы можем использовать локально:",zl,W,Zl,R,kp="Далее мы покажем вам, как блок за блоком построить собственные токенизаторы BERT, GPT-2 и XLNet. Это даст нам пример каждого из трех основных алгоритмов токенизации: WordPiece, BPE и Unigram. Начнем с BERT!",vl,N,_l,X,dp="Чтобы создать токенизатор с помощью библиотеки 🤗 Tokenizers, мы начнем с инстанцирования объектов <code>Tokenizer</code> и <code>model</code>, затем установим для их атрибутов <code>normalizer</code>, <code>pre_tokenizer</code>, <code>post_processor</code> и <code>decoder</code> нужные нам значения.",Ql,A,bp="Для этого примера мы создадим <code>Tokenizer</code> с моделью WordPiece:",Bl,E,Wl,G,wp="Мы должны указать <code>unk_token</code>, чтобы модель знала, что возвращать, когда она встречает символы, которых раньше не видела. Другие аргументы, которые мы можем задать здесь, включают <code>vocab</code> нашей модели (мы собираемся обучать модель, поэтому нам не нужно его задавать) и <code>max_input_chars_per_word</code>, который определяет максимальную длину для каждого слова (слова длиннее переданного значения будут разбиты на части).",Rl,q,Cp="Первым шагом токенизации является нормализация, поэтому начнем с нее. Поскольку BERT широко используется, существует <code>BertNormalizer</code> с классическими параметрами, которые мы можем установить для BERT: <code>lowercase</code> и <code>strip_accents</code>, которые не требуют пояснений; <code>clean_text</code> для удаления всех управляющих символов и замены повторяющихся пробелов на один; и <code>handle_chinese_chars</code>, который расставляет пробелы вокруг китайских символов. Чтобы повторить токенизатор <code>bert-base-uncased</code>, мы можем просто установить этот нормализатор:",Nl,L,Xl,H,gp="Однако, как правило, при создании нового токенизатора у вас не будет доступа к такому удобному нормализатору, уже реализованному в библиотеке 🤗 Tokenizers, поэтому давайте посмотрим, как создать нормализатор BERT вручную. Библиотека предоставляет нормализатор <code>Lowercase</code> и нормализатор <code>StripAccents</code>, и вы можете комбинировать несколько нормализаторов с помощью <code>Sequence</code>:",Al,S,El,D,xp="Мы также используем нормализатор Unicode <code>NFD</code>, поскольку в противном случае нормализатор <code>StripAccents</code> не сможет правильно распознать акцентированные символы и, следовательно, не удалит их.",Gl,P,hp="Как мы уже видели ранее, мы можем использовать метод <code>normalize_str()</code> нормализатора, чтобы проверить, как он влияет на данный текст:",ql,Y,Ll,F,Hl,U,Sl,K,Ip="Далее следует этап предварительной токенизации. Опять же, есть готовый <code>BertPreTokenizer</code>, который мы можем использовать:",Dl,O,Pl,ee,Vp="Или мы можем создать его с нуля:",Yl,se,Fl,le,zp="Обратите внимание, что токенизатор <code>Whitespace</code> разделяет пробельные символы и все символы, которые не являются буквами, цифрами или символом подчеркивания, поэтому технически он разделяет пробельные символы и знаки пунктуации:",Kl,te,Ol,ne,et,pe,Zp="Если вы хотите выполнять разделение только по пробельным символам, то вместо этого следует использовать предварительный токенизатор <code>WhitespaceSplit</code>:",st,ae,lt,ie,tt,Me,vp="Как и в случае с нормализаторами, вы можете использовать <code>Sequence</code> для комбинирования нескольких предварительных токенизаторов:",nt,re,pt,ce,at,ye,_p="Следующий шаг в конвейере токенизации - обработка входных данных с помощью модели. Мы уже указали нашу модель в инициализации, но нам все еще нужно обучить ее, для чего потребуется <code>WordPieceTrainer</code>. Главное, что нужно помнить при инстанцировании тренера в 🤗 Tokenizers, это то, что вам нужно передать ему все специальные токены, которые вы собираетесь использовать - иначе он не добавит их в словарь, поскольку их нет в обучающем корпусе:",it,Je,Mt,me,Qp="Помимо указания <code>vocab_size</code> и <code>special_tokens</code>, мы можем задать <code>min_frequency</code> (количество раз, которое должен встретиться токен, чтобы быть включенным в словарь) или изменить <code>continuing_subword_prefix</code> (если мы хотим использовать что-то отличное от <code>##</code>).",rt,oe,Bp="Чтобы обучить нашу модель с помощью итератора, который мы определили ранее, достаточно выполнить эту команду:",ct,je,yt,Te,Wp="Мы также можем использовать текстовые файлы для обучения нашего токенизатора, что будет выглядеть следующим образом (предварительно мы повторно инициализируем модель с пустым <code>WordPiece</code>):",Jt,ue,mt,fe,Rp="В обоих случаях мы можем проверить работу токенизатора на тексте, вызвав метод <code>encode()</code>:",ot,Ue,jt,$e,Tt,ke,Np="Полученное <code>encoding</code> представляет собой <code>Encoding</code>, которое содержит все необходимые результаты работы токенизатора в разных атрибутах: <code>ids</code>, <code>type_ids</code>, <code>tokens</code>, <code>offsets</code>, <code>attention_mask</code>, <code>special_tokens_mask</code> и <code>overflowing</code>.",ut,de,Xp="Последний шаг в конвейере токенизации - постобработка. Нам нужно добавить токен <code>[CLS]</code> в начале и токен <code>[SEP]</code> в конце (или после каждого предложения, если у нас есть пара предложений). Для этого мы будем использовать <code>TemplateProcessor</code>, но сначала нам нужно узнать идентификаторы токенов <code>[CLS]</code> и <code>[SEP]</code> в словаре:",ft,be,Ut,we,$t,Ce,Ap="Чтобы написать шаблон для <code>TemplateProcessor</code>, мы должны указать, как обрабатывать одно предложение и пару предложений. Для обоих случаев мы указываем специальные токены, которые мы хотим использовать; первое (или одиночное) предложение представлено <code>$A</code>, а второе предложение (если кодируется пара) представлено <code>$B</code>. Для каждого из них (специальных токенов и предложений) мы также указываем соответствующий идентификатор типа токена (token type ID) после двоеточия.",kt,ge,Ep="Таким образом, классический шаблон BERT определяется следующим образом:",dt,xe,bt,he,Gp="Обратите внимание, что нам нужно передать идентификаторы специальных токенов, чтобы токенизатор мог правильно преобразовать их в их идентификаторы.",wt,Ie,qp="Как только это будет добавлено, вернемся к нашему предыдущему примеру:",Ct,Ve,gt,ze,xt,Ze,Lp="И на паре предложений мы получаем правильный результат:",ht,ve,It,_e,Vt,Qe,Hp="Мы почти закончили создание этого токенизатора с нуля - остался последний шаг - добавить декодер:",zt,Be,Zt,We,Sp="Давайте проверим его на нашем предыдущем <code>encoding</code>:",vt,Re,_t,Ne,Qt,Xe,Dp="Отлично! Мы можем сохранить наш токенизатор в единственном JSON-файле следующим образом:",Bt,Ae,Wt,Ee,Pp="Затем мы можем загрузить этот файл в объект <code>Tokenizer</code> с помощью метода <code>from_file()</code>:",Rt,Ge,Nt,qe,Yp="Чтобы использовать этот токенизатор в 🤗 Transformers, мы должны обернуть его в <code>PreTrainedTokenizerFast</code>. Мы можем использовать либо общий класс, либо, если наш токенизатор соответствует существующей модели, использовать этот класс (здесь <code>BertTokenizerFast</code>). Если вы используете этот урок для создания нового токенизатора, вам придется использовать первый вариант.",Xt,Le,Fp="Чтобы обернуть токенизатор в <code>PreTrainedTokenizerFast</code>, мы можем либо передать собранный нами токенизатор как <code>tokenizer_object</code>, либо передать сохраненный файл токенизатора как <code>tokenizer_file</code>. Главное помнить, что нам придется вручную задавать все специальные токены, поскольку класс не может определить из объекта <code>tokenizer</code>, какой токен является токеном маски, токеном <code>[CLS]</code> и т. д.:",At,He,Et,Se,Kp="Если вы используете определенный класс токенизатора (например, <code>BertTokenizerFast</code>), вам нужно будет указать только специальные токены, которые отличаются от токенов по умолчанию (здесь их нет):",Gt,De,qt,Pe,Op="Затем вы можете использовать этот токенизатор, как и любой другой токенизатор 🤗 Transformers. Вы можете сохранить его с помощью метода <code>save_pretrained()</code> или загрузить на хаб с помощью метода <code>push_to_hub()</code>.",Lt,Ye,ea="Теперь, когда мы рассмотрели, как создать токенизатор WordPiece, давайте сделаем то же самое для токенизатора BPE. Мы будем двигаться немного быстрее, поскольку вы знаете все шаги, и подчеркнем только различия.",Ht,Fe,St,Ke,sa="Теперь давайте создадим токенизатор GPT-2. Как и в случае с токенизатором BERT, мы начнем с инициализации <code>Tokenizer</code> с моделью BPE:",Dt,Oe,Pt,es,la="Также, как и в случае с BERT, мы могли бы инициализировать эту модель словарем, если бы он у нас был (в этом случае нам нужно было бы передать <code>vocab</code> и <code>merges</code>), но поскольку мы будем обучать с нуля, нам не нужно этого делать. Нам также не нужно указывать <code>unk_token</code>, потому что GPT-2 использует byte-level BPE, который не требует этого.",Yt,ss,ta="GPT-2 не использует нормализатор, поэтому мы пропускаем этот шаг и переходим непосредственно к предварительной токенизации:",Ft,ls,Kt,ts,na="Опция, которую мы добавили к <code>ByteLevel</code>, заключается в том, чтобы не добавлять пробел в начале предложения (в противном случае это происходит по умолчанию). Мы можем посмотреть на предварительную токенизацию примера текста, как было показано ранее:",Ot,ns,en,ps,sn,as,pa="Далее следует модель, которую нужно обучить. Для GPT-2 единственным специальным токеном является токен конца текста:",ln,is,tn,Ms,aa="Как и в случае с <code>WordPieceTrainer</code>, а также <code>vocab_size</code> и <code>special_tokens</code>, мы можем указать <code>min_frequency</code>, если хотим, или если у нас есть суффикс конца слова (например, <code>&lt;/w&gt;</code>), мы можем задать его с помощью <code>end_of_word_suffix</code>.",nn,rs,ia="Этот токенизатор также может быть обучен на текстовых файлах:",pn,cs,an,ys,Ma="Давайте посмотрим на пример токенизации текста:",Mn,Js,rn,ms,cn,os,ra="Мы применяем постобработку на уровне байтов для токенизатора GPT-2 следующим образом:",yn,js,Jn,Ts,ca="Опция <code>trim_offsets = False</code> указывает постпроцессору, что мы должны оставить смещения токенов, начинающихся с ‘Ġ’, как есть: таким образом, начало смещения будет указывать на пробел перед словом, а не на первый символ слова (поскольку пробел технически является частью токена). Давайте посмотрим на результат с текстом, который мы только что закодировали, где <code>&#39;Ġtest&#39;</code> - это токен с индексом 4:",mn,us,on,fs,jn,Us,ya="Наконец, мы добавляем декодер на уровне байтов:",Tn,$s,un,ks,Ja="и мы сможем перепроверить, правильно ли он работает:",fn,ds,Un,bs,$n,ws,ma="Отлично! Теперь, когда мы закончили, мы можем сохранить токенизатор, как раньше, и обернуть его в <code>PreTrainedTokenizerFast</code> или <code>GPT2TokenizerFast</code>, если мы хотим использовать его в 🤗 Transformers:",kn,Cs,dn,gs,oa="или:",bn,xs,wn,hs,ja="В качестве последнего примера мы покажем вам, как создать токенизатор Unigram с нуля.",Cn,Is,gn,Vs,Ta="Теперь давайте построим токенизатор XLNet. Как и в предыдущих токенизаторах, мы начнем с инициализации <code>Tokenizer</code> с моделью Unigram:",xn,zs,hn,Zs,ua="Опять же, мы могли бы инициализировать эту модель словарем, если бы он у нас был.",In,vs,fa="Для нормализации XLNet использует несколько замен (которые пришли из SentencePiece):",Vn,_s,zn,Qs,Ua="Он заменяет <code>“</code> и <code>”</code> with <code>”</code> и любую последовательность из двух или более пробелов на один пробел, а также удаляет ударения в токенезируемых текстах.",Zn,Bs,$a="Предварительный токенизатор, который должен использоваться для любого токенизатора SentencePiece, - это <code>Metaspace</code>:",vn,Ws,_n,Rs,ka="Мы можем посмотреть на предварительную токенизацию примера текста, как было показано ранее:",Qn,Ns,Bn,Xs,Wn,As,da="Далее следует модель, которую нужно обучить. В XLNet довольно много специальных токенов:",Rn,Es,Nn,Gs,ba="Очень важный аргумент, который не стоит забывать для <code>UnigramTrainer</code> - это <code>unk_token</code>. Мы также можем передавать другие аргументы, специфичные для алгоритма Unigram, такие как <code>shrinking_factor</code> для каждого шага удаления токенов (по умолчанию 0.75) или <code>max_piece_length</code> для указания максимальной длины данного токена (по умолчанию 16).",Xn,qs,wa="Этот токенизатор также может быть обучен на текстовых файлах:",An,Ls,En,Hs,Ca="Давайте посмотрим на токенизацию примера текста:",Gn,Ss,qn,Ds,Ln,Ps,ga="Особенностью XLNet является то, что он помещает токен <code>&lt;cls&gt;</code> в конец предложения с идентификатором типа 2 (чтобы отличить его от других токенов). В результате он помещается слева. Мы можем разобраться со всеми специальными токенами и идентификаторами типов токенов с помощью шаблона, как в BERT, но сначала нам нужно получить идентификаторы токенов <code>&lt;cls&gt;</code> и <code>&lt;sep&gt;</code>:",Hn,Ys,Sn,Fs,Dn,Ks,xa="Шаблон выглядит следующим образом:",Pn,Os,Yn,el,ha="И мы можем проверить, как это работает, закодировав пару предложений:",Fn,sl,Kn,ll,On,tl,Ia="Наконец, мы добавляем декодер <code>Metaspace</code>:",ep,nl,sp,pl,Va="и мы закончили работу с этим токенизатором! Мы можем сохранить токенизатор, как и раньше, и обернуть его в <code>PreTrainedTokenizerFast</code> или <code>XLNetTokenizerFast</code>, если мы хотим использовать его в 🤗 Transformers. При использовании <code>PreTrainedTokenizerFast</code> следует обратить внимание на то, что помимо специальных токенов, нам нужно указать библиотеке 🤗 Transformers на то, чтобы они располагались слева:",lp,al,tp,il,za="Или альтернативно:",np,Ml,pp,rl,Za="Теперь, когда вы увидели, как различные блоки используются для создания существующих токенизаторов, вы должны быть в состоянии написать любой токенизатор, который вы хотите, с помощью библиотеки 🤗 Tokenizers и использовать его в 🤗 Transformers.",ap,cl,ip,Jl,Mp;return k=new Ga({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),d=new ml({props:{title:"Создание токенизатора, блок за блоком",local:"building-a-tokenizer-block-by-block",headingTag:"h1"}}),b=new Ha({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"}]}}),h=new La({props:{id:"MR8tZm5ViWU"}}),Z=new ml({props:{title:"Получение корпуса текста",local:"acquiring-a-corpus",headingTag:"h2"}}),_=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ3aWtpdGV4dCUyMiUyQyUyMG5hbWUlM0QlMjJ3aWtpdGV4dC0yLXJhdy12MSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBJTBBZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihkYXRhc2V0KSUyQyUyMDEwMDApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBkYXRhc2V0JTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIydGV4dCUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;wikitext&quot;</span>, name=<span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> dataset[i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),W=new j({props:{code:"d2l0aCUyMG9wZW4oJTIyd2lraXRleHQtMi50eHQlMjIlMkMlMjAlMjJ3JTIyJTJDJTIwZW5jb2RpbmclM0QlMjJ1dGYtOCUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oZGF0YXNldCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShkYXRhc2V0JTVCaSU1RCU1QiUyMnRleHQlMjIlNUQlMjAlMkIlMjAlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)):
        f.write(dataset[i][<span class="hljs-string">&quot;text&quot;</span>] + <span class="hljs-string">&quot;\\n&quot;</span>)`,wrap:!1}}),N=new ml({props:{title:"Создание токенизатора WordPiece с нуля",local:"building-a-wordpiece-tokenizer-from-scratch",headingTag:"h2"}}),E=new j({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwZGVjb2RlcnMlMkMlMEElMjAlMjAlMjAlMjBtb2RlbHMlMkMlMEElMjAlMjAlMjAlMjBub3JtYWxpemVycyUyQyUwQSUyMCUyMCUyMCUyMHByZV90b2tlbml6ZXJzJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29ycyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluZXJzJTJDJTBBJTIwJTIwJTIwJTIwVG9rZW5pemVyJTJDJTBBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMFRva2VuaXplcihtb2RlbHMuV29yZFBpZWNlKHVua190b2tlbiUzRCUyMiU1QlVOSyU1RCUyMikp",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> (
    decoders,
    models,
    normalizers,
    pre_tokenizers,
    processors,
    trainers,
    Tokenizer,
)

tokenizer = Tokenizer(models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>))`,wrap:!1}}),L=new j({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5CZXJ0Tm9ybWFsaXplcihsb3dlcmNhc2UlM0RUcnVlKQ==",highlighted:'tokenizer.normalizer = normalizers.BertNormalizer(lowercase=<span class="hljs-literal">True</span>)',wrap:!1}}),S=new j({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5TZXF1ZW5jZSglMEElMjAlMjAlMjAlMjAlNUJub3JtYWxpemVycy5ORkQoKSUyQyUyMG5vcm1hbGl6ZXJzLkxvd2VyY2FzZSgpJTJDJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklNUQlMEEp",highlighted:`tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [normalizers.NFD(), normalizers.Lowercase(), normalizers.StripAccents()]
)`,wrap:!1}}),Y=new j({props:{code:"cHJpbnQodG9rZW5pemVyLm5vcm1hbGl6ZXIubm9ybWFsaXplX3N0ciglMjJIJUMzJUE5bGwlQzMlQjIlMjBoJUMzJUI0dyUyMGFyZSUyMCVDMyVCQyUzRiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(tokenizer.normalizer.normalize_str(<span class="hljs-string">&quot;Héllò hôw are ü?&quot;</span>))',wrap:!1}}),F=new j({props:{code:"aGVsbG8lMjBob3clMjBhcmUlMjB1JTNG",highlighted:"hello how are u?",wrap:!1}}),U=new Ea({props:{$$slots:{default:[Sa]},$$scope:{ctx:ol}}}),O=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CZXJ0UHJlVG9rZW5pemVyKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.BertPreTokenizer()",wrap:!1}}),se=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5XaGl0ZXNwYWNlKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Whitespace()",wrap:!1}}),te=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBteSUyMHByZS10b2tlbml6ZXIuJTIyKQ==",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)',wrap:!1}}),ne=new j({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),ae=new j({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTBBcHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKCUyMkxldCdzJTIwdGVzdCUyMG15JTIwcHJlLXRva2VuaXplci4lMjIp",highlighted:`pre_tokenizer = pre_tokenizers.WhitespaceSplit()
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),ie=new j({props:{code:"JTVCKCUyMkxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJ3Rlc3QnJTJDJTIwKDYlMkMlMjAxMCkpJTJDJTIwKCdteSclMkMlMjAoMTElMkMlMjAxMykpJTJDJTIwKCdwcmUtdG9rZW5pemVyLiclMkMlMjAoMTQlMkMlMjAyOCkpJTVE",highlighted:'[(<span class="hljs-string">&quot;Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre-tokenizer.&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">28</span>))]',wrap:!1}}),re=new j({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLlNlcXVlbmNlKCUwQSUyMCUyMCUyMCUyMCU1QnByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTJDJTIwcHJlX3Rva2VuaXplcnMuUHVuY3R1YXRpb24oKSU1RCUwQSklMEFwcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIoJTIyTGV0J3MlMjB0ZXN0JTIwbXklMjBwcmUtdG9rZW5pemVyLiUyMik=",highlighted:`pre_tokenizer = pre_tokenizers.<span class="hljs-type">Sequence</span>(
    [pre_tokenizers.WhitespaceSplit(), pre_tokenizers.Punctuation()]
)
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),ce=new j({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),Je=new j({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlNUJVTkslNUQlMjIlMkMlMjAlMjIlNUJQQUQlNUQlMjIlMkMlMjAlMjIlNUJDTFMlNUQlMjIlMkMlMjAlMjIlNUJTRVAlNUQlMjIlMkMlMjAlMjIlNUJNQVNLJTVEJTIyJTVEJTBBdHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLldvcmRQaWVjZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2Vucyk=",highlighted:`special_tokens = [<span class="hljs-string">&quot;[UNK]&quot;</span>, <span class="hljs-string">&quot;[PAD]&quot;</span>, <span class="hljs-string">&quot;[CLS]&quot;</span>, <span class="hljs-string">&quot;[SEP]&quot;</span>, <span class="hljs-string">&quot;[MASK]&quot;</span>]
trainer = trainers.WordPieceTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens)`,wrap:!1}}),je=new j({props:{code:"dG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:"tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)",wrap:!1}}),ue=new j({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLldvcmRQaWVjZSh1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>)
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Ue=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),$e=new j({props:{code:"JTVCJ2xldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJ3Rlc3QnJTJDJTIwJ3RoaXMnJTJDJTIwJ3RvayclMkMlMjAnJTIzJTIzZW5pJyUyQyUyMCclMjMlMjN6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),be=new j({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiU1QkNMUyU1RCUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTVCU0VQJTVEJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[CLS]&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[SEP]&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),we=new j({props:{code:"KDIlMkMlMjAzKQ==",highlighted:'(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>)',wrap:!1}}),xe=new j({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWlyJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjAlMjRCJTNBMSUyMCU1QlNFUCU1RCUzQTElMjIlMkMlMEElMjAlMjAlMjAlMjBzcGVjaWFsX3Rva2VucyUzRCU1QiglMjIlNUJDTFMlNUQlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTJDJTIwKCUyMiU1QlNFUCU1RCUyMiUyQyUyMHNlcF90b2tlbl9pZCklNUQlMkMlMEEp",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0&quot;</span>,
    pair=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0 $B:1 [SEP]:1&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;[CLS]&quot;</span>, cls_token_id), (<span class="hljs-string">&quot;[SEP]&quot;</span>, sep_token_id)],
)`,wrap:!1}}),Ve=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),ze=new j({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLiclMkMlMjAnJTVCU0VQJTVEJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]',wrap:!1}}),ve=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),_e=new j({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLi4uJyUyQyUyMCclNUJTRVAlNUQnJTJDJTIwJ29uJyUyQyUyMCdhJyUyQyUyMCdwYWlyJyUyQyUyMCdvZiclMkMlMjAnc2VudGVuY2VzJyUyQyUyMCcuJyUyQyUyMCclNUJTRVAlNUQnJTVEJTBBJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVE",highlighted:`[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;...&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;pair&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;sentences&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]`,wrap:!1}}),Be=new j({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5Xb3JkUGllY2UocHJlZml4JTNEJTIyJTIzJTIzJTIyKQ==",highlighted:'tokenizer.decoder = decoders.WordPiece(prefix=<span class="hljs-string">&quot;##&quot;</span>)',wrap:!1}}),Re=new j({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),Ne=new j({props:{code:"JTIybGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4uLiUyMG9uJTIwYSUyMHBhaXIlMjBvZiUyMHNlbnRlbmNlcy4lMjI=",highlighted:'<span class="hljs-string">&quot;let&#x27;s test this tokenizer... on a pair of sentences.&quot;</span>',wrap:!1}}),Ae=new j({props:{code:"dG9rZW5pemVyLnNhdmUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'tokenizer.save(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),Ge=new j({props:{code:"bmV3X3Rva2VuaXplciUyMCUzRCUyMFRva2VuaXplci5mcm9tX2ZpbGUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'new_tokenizer = Tokenizer.from_file(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),He=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwdG9rZW5pemVyX2ZpbGUlM0QlMjJ0b2tlbml6ZXIuanNvbiUyMiUyQyUyMCUyMyUyMCVEMCU5MiUyMCVEMCVCQSVEMCVCMCVEMSU4NyVEMCVCNSVEMSU4MSVEMSU4MiVEMCVCMiVEMCVCNSUyMCVEMCVCMCVEMCVCQiVEMSU4QyVEMSU4MiVEMCVCNSVEMSU4MCVEMCVCRCVEMCVCMCVEMSU4MiVEMCVCOCVEMCVCMiVEMSU4QiUyMCVEMCVCQyVEMCVCRSVEMCVCNiVEMCVCRCVEMCVCRSUyMCVEMCVCNyVEMCVCMCVEMCVCMyVEMSU4MCVEMSU4MyVEMCVCNyVEMCVCOCVEMSU4MiVEMSU4QyUyMCVEMCVCOCVEMCVCNyUyMCVEMSU4NCVEMCVCMCVEMCVCOSVEMCVCQiVEMCVCMCUyMCVEMSU4MiVEMCVCRSVEMCVCQSVEMCVCNSVEMCVCRCVEMCVCOCVEMCVCNyVEMCVCMCVEMSU4MiVEMCVCRSVEMSU4MCVEMCVCMC4lMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlNUJQQUQlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlNUJDTFMlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlNUJTRVAlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTVCTUFTSyU1RCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    <span class="hljs-comment"># tokenizer_file=&quot;tokenizer.json&quot;, # В качестве альтернативы можно загрузить из файла токенизатора.</span>
    unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>,
    pad_token=<span class="hljs-string">&quot;[PAD]&quot;</span>,
    cls_token=<span class="hljs-string">&quot;[CLS]&quot;</span>,
    sep_token=<span class="hljs-string">&quot;[SEP]&quot;</span>,
    mask_token=<span class="hljs-string">&quot;[MASK]&quot;</span>,
)`,wrap:!1}}),De=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizerFast

wrapped_tokenizer = BertTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),Fe=new ml({props:{title:"Создание токенизатора BPE с нуля",local:"building-a-bpe-tokenizer-from-scratch",headingTag:"h2"}}),Oe=new j({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5CUEUoKSk=",highlighted:"tokenizer = Tokenizer(models.BPE())",wrap:!1}}),ls=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CeXRlTGV2ZWwoYWRkX3ByZWZpeF9zcGFjZSUzREZhbHNlKQ==",highlighted:'tokenizer.pre_tokenizer = pre_tokenizers.ByteLevel(add_prefix_space=<span class="hljs-literal">False</span>)',wrap:!1}}),ns=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBwcmUtdG9rZW5pemF0aW9uISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test pre-tokenization!&quot;</span>)',wrap:!1}}),ps=new j({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJ3MlMjIlMkMlMjAoMyUyQyUyMDUpKSUyQyUyMCgnJUM0JUEwdGVzdCclMkMlMjAoNSUyQyUyMDEwKSklMkMlMjAoJyVDNCVBMHByZSclMkMlMjAoMTAlMkMlMjAxNCkpJTJDJTIwKCctJyUyQyUyMCgxNCUyQyUyMDE1KSklMkMlMEElMjAoJ3Rva2VuaXphdGlvbiclMkMlMjAoMTUlMkMlMjAyNykpJTJDJTIwKCchJyUyQyUyMCgyNyUyQyUyMDI4KSklNUQ=",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;s&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;Ġtest&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;Ġpre&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">15</span>)),
 (<span class="hljs-string">&#x27;tokenization&#x27;</span>, (<span class="hljs-number">15</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;!&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),is=new j({props:{code:"dHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLkJwZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQpJTBBdG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`trainer = trainers.BpeTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=[<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>])
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),cs=new j({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLkJQRSgpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.BPE()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Js=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),ms=new j({props:{code:"JTVCJ0wnJTJDJTIwJ2V0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAnJUM0JUEwdGVzdCclMkMlMjAnJUM0JUEwdGhpcyclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2tlbiclMkMlMjAnaXplciclMkMlMjAnLiclNUQ=",highlighted:'[<span class="hljs-string">&#x27;L&#x27;</span>, <span class="hljs-string">&#x27;et&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;Ġtest&#x27;</span>, <span class="hljs-string">&#x27;Ġthis&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),js=new j({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5CeXRlTGV2ZWwodHJpbV9vZmZzZXRzJTNERmFsc2Up",highlighted:'tokenizer.post_processor = processors.ByteLevel(trim_offsets=<span class="hljs-literal">False</span>)',wrap:!1}}),us=new j({props:{code:"c2VudGVuY2UlMjAlM0QlMjAlMjJMZXQncyUyMHRlc3QlMjB0aGlzJTIwdG9rZW5pemVyLiUyMiUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyLmVuY29kZShzZW50ZW5jZSklMEFzdGFydCUyQyUyMGVuZCUyMCUzRCUyMGVuY29kaW5nLm9mZnNldHMlNUI0JTVEJTBBc2VudGVuY2UlNUJzdGFydCUzQWVuZCU1RA==",highlighted:`sentence = <span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>
encoding = tokenizer.encode(sentence)
start, end = encoding.offsets[<span class="hljs-number">4</span>]
sentence[start:end]`,wrap:!1}}),fs=new j({props:{code:"JyUyMHRlc3Qn",highlighted:'<span class="hljs-string">&#x27; test&#x27;</span>',wrap:!1}}),$s=new j({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5CeXRlTGV2ZWwoKQ==",highlighted:"tokenizer.decoder = decoders.ByteLevel()",wrap:!1}}),ds=new j({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),bs=new j({props:{code:"JTIyTGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4lMjI=",highlighted:'<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>',wrap:!1}}),Cs=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwZW9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
)`,wrap:!1}}),xs=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2TokenizerFast

wrapped_tokenizer = GPT2TokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),Is=new ml({props:{title:"Создание токенизатора Unigram с нуля",local:"building-a-unigram-tokenizer-from-scratch",headingTag:"h2"}}),zs=new j({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5VbmlncmFtKCkp",highlighted:"tokenizer = Tokenizer(models.Unigram())",wrap:!1}}),_s=new j({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjBSZWdleCUwQSUwQXRva2VuaXplci5ub3JtYWxpemVyJTIwJTNEJTIwbm9ybWFsaXplcnMuU2VxdWVuY2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuUmVwbGFjZSglMjIlNjAlNjAlMjIlMkMlMjAnJTIyJyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKCUyMicnJTIyJTJDJTIwJyUyMicpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuTkZLRCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKFJlZ2V4KCUyMiUyMCU3QjIlMkMlN0QlMjIpJTJDJTIwJTIyJTIwJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> Regex

tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [
        normalizers.Replace(<span class="hljs-string">&quot;\`\`&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.Replace(<span class="hljs-string">&quot;&#x27;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.NFKD(),
        normalizers.StripAccents(),
        normalizers.Replace(Regex(<span class="hljs-string">&quot; {2,}&quot;</span>), <span class="hljs-string">&quot; &quot;</span>),
    ]
)`,wrap:!1}}),Ws=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Metaspace()",wrap:!1}}),Ns=new j({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjB0aGUlMjBwcmUtdG9rZW5pemVyISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test the pre-tokenizer!&quot;</span>)',wrap:!1}}),Xs=new j({props:{code:"JTVCKCUyMiVFMiU5NiU4MUxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJyVFMiU5NiU4MXRlc3QnJTJDJTIwKDUlMkMlMjAxMCkpJTJDJTIwKCclRTIlOTYlODF0aGUnJTJDJTIwKDEwJTJDJTIwMTQpKSUyQyUyMCgnJUUyJTk2JTgxcHJlLXRva2VuaXplciEnJTJDJTIwKDE0JTJDJTIwMjkpKSU1RA==",highlighted:'[(<span class="hljs-string">&quot;▁Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;▁test&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;▁the&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;▁pre-tokenizer!&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">29</span>))]',wrap:!1}}),Es=new j({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlM0NjbHMlM0UlMjIlMkMlMjAlMjIlM0NzZXAlM0UlMjIlMkMlMjAlMjIlM0N1bmslM0UlMjIlMkMlMjAlMjIlM0NwYWQlM0UlMjIlMkMlMjAlMjIlM0NtYXNrJTNFJTIyJTJDJTIwJTIyJTNDcyUzRSUyMiUyQyUyMCUyMiUzQyUyRnMlM0UlMjIlNUQlMEF0cmFpbmVyJTIwJTNEJTIwdHJhaW5lcnMuVW5pZ3JhbVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2VucyUyQyUyMHVua190b2tlbiUzRCUyMiUzQ3VuayUzRSUyMiUwQSklMEF0b2tlbml6ZXIudHJhaW5fZnJvbV9pdGVyYXRvcihnZXRfdHJhaW5pbmdfY29ycHVzKCklMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`special_tokens = [<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;s&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>]
trainer = trainers.UnigramTrainer(
    vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens, unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>
)
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),Ls=new j({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLlVuaWdyYW0oKSUwQXRva2VuaXplci50cmFpbiglNUIlMjJ3aWtpdGV4dC0yLnR4dCUyMiU1RCUyQyUyMHRyYWluZXIlM0R0cmFpbmVyKQ==",highlighted:`tokenizer.model = models.Unigram()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Ss=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Ds=new j({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),Ys=new j({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiUzQ2NscyUzRSUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTNDc2VwJTNFJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),Fs=new j({props:{code:"MCUyMDE=",highlighted:'<span class="hljs-number">0</span> <span class="hljs-number">1</span>',wrap:!1}}),Os=new j({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEJTIyJTI0QSUzQTAlMjAlM0NzZXAlM0UlM0EwJTIwJTNDY2xzJTNFJTNBMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhaXIlM0QlMjIlMjRBJTNBMCUyMCUzQ3NlcCUzRSUzQTAlMjAlMjRCJTNBMSUyMCUzQ3NlcCUzRSUzQTElMjAlM0NjbHMlM0UlM0EyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIoJTIyJTNDc2VwJTNFJTIyJTJDJTIwc2VwX3Rva2VuX2lkKSUyQyUyMCglMjIlM0NjbHMlM0UlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTVEJTJDJTBBKQ==",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 &lt;cls&gt;:2&quot;</span>,
    pair=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 $B:1 &lt;sep&gt;:1 &lt;cls&gt;:2&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, sep_token_id), (<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, cls_token_id)],
)`,wrap:!1}}),sl=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMhJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences!&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),ll=new j({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdvbiclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdhJyUyQyUyMCclRTIlOTYlODFwYWlyJyUyQyUyMCUwQSUyMCUyMCclRTIlOTYlODFvZiclMkMlMjAnJUUyJTk2JTgxc2VudGVuY2UnJTJDJTIwJ3MnJTJDJTIwJyEnJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJTNDY2xzJTNFJyU1RCUwQSU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAyJTVE",highlighted:`[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;▁pair&#x27;</span>, 
  <span class="hljs-string">&#x27;▁of&#x27;</span>, <span class="hljs-string">&#x27;▁sentence&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;!&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;cls&gt;&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),nl=new j({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.decoder = decoders.Metaspace()",wrap:!1}}),al=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDcyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMGVvc190b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlM0N1bmslM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlM0NwYWQlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlM0NjbHMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlM0NzZXAlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTNDbWFzayUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;s&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>,
    unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>,
    pad_token=<span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>,
    cls_token=<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>,
    sep_token=<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>,
    mask_token=<span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>,
    padding_side=<span class="hljs-string">&quot;left&quot;</span>,
)`,wrap:!1}}),Ml=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFhMTmV0VG9rZW5pemVyRmFzdCUwQSUwQXdyYXBwZWRfdG9rZW5pemVyJTIwJTNEJTIwWExOZXRUb2tlbml6ZXJGYXN0KHRva2VuaXplcl9vYmplY3QlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLNetTokenizerFast

wrapped_tokenizer = XLNetTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),cl=new qa({props:{source:"https://github.com/huggingface/course/blob/main/chapters/ru/chapter6/8.mdx"}}),{c(){T=a("meta"),$=n(),u=a("p"),yl=n(),r(k.$$.fragment),jl=n(),r(d.$$.fragment),Tl=n(),r(b.$$.fragment),ul=n(),w=a("p"),w.textContent=cp,fl=n(),C=a("ul"),C.innerHTML=yp,Ul=n(),g=a("p"),g.textContent=Jp,$l=n(),f=a("div"),f.innerHTML=mp,kl=n(),x=a("p"),x.innerHTML=op,dl=n(),r(h.$$.fragment),bl=n(),I=a("p"),I.innerHTML=jp,wl=n(),V=a("ul"),V.innerHTML=Tp,Cl=n(),z=a("p"),z.innerHTML=up,gl=n(),r(Z.$$.fragment),xl=n(),v=a("p"),v.innerHTML=fp,hl=n(),r(_.$$.fragment),Il=n(),Q=a("p"),Q.innerHTML=Up,Vl=n(),B=a("p"),B.textContent=$p,zl=n(),r(W.$$.fragment),Zl=n(),R=a("p"),R.textContent=kp,vl=n(),r(N.$$.fragment),_l=n(),X=a("p"),X.innerHTML=dp,Ql=n(),A=a("p"),A.innerHTML=bp,Bl=n(),r(E.$$.fragment),Wl=n(),G=a("p"),G.innerHTML=wp,Rl=n(),q=a("p"),q.innerHTML=Cp,Nl=n(),r(L.$$.fragment),Xl=n(),H=a("p"),H.innerHTML=gp,Al=n(),r(S.$$.fragment),El=n(),D=a("p"),D.innerHTML=xp,Gl=n(),P=a("p"),P.innerHTML=hp,ql=n(),r(Y.$$.fragment),Ll=n(),r(F.$$.fragment),Hl=n(),r(U.$$.fragment),Sl=n(),K=a("p"),K.innerHTML=Ip,Dl=n(),r(O.$$.fragment),Pl=n(),ee=a("p"),ee.textContent=Vp,Yl=n(),r(se.$$.fragment),Fl=n(),le=a("p"),le.innerHTML=zp,Kl=n(),r(te.$$.fragment),Ol=n(),r(ne.$$.fragment),et=n(),pe=a("p"),pe.innerHTML=Zp,st=n(),r(ae.$$.fragment),lt=n(),r(ie.$$.fragment),tt=n(),Me=a("p"),Me.innerHTML=vp,nt=n(),r(re.$$.fragment),pt=n(),r(ce.$$.fragment),at=n(),ye=a("p"),ye.innerHTML=_p,it=n(),r(Je.$$.fragment),Mt=n(),me=a("p"),me.innerHTML=Qp,rt=n(),oe=a("p"),oe.textContent=Bp,ct=n(),r(je.$$.fragment),yt=n(),Te=a("p"),Te.innerHTML=Wp,Jt=n(),r(ue.$$.fragment),mt=n(),fe=a("p"),fe.innerHTML=Rp,ot=n(),r(Ue.$$.fragment),jt=n(),r($e.$$.fragment),Tt=n(),ke=a("p"),ke.innerHTML=Np,ut=n(),de=a("p"),de.innerHTML=Xp,ft=n(),r(be.$$.fragment),Ut=n(),r(we.$$.fragment),$t=n(),Ce=a("p"),Ce.innerHTML=Ap,kt=n(),ge=a("p"),ge.textContent=Ep,dt=n(),r(xe.$$.fragment),bt=n(),he=a("p"),he.textContent=Gp,wt=n(),Ie=a("p"),Ie.textContent=qp,Ct=n(),r(Ve.$$.fragment),gt=n(),r(ze.$$.fragment),xt=n(),Ze=a("p"),Ze.textContent=Lp,ht=n(),r(ve.$$.fragment),It=n(),r(_e.$$.fragment),Vt=n(),Qe=a("p"),Qe.textContent=Hp,zt=n(),r(Be.$$.fragment),Zt=n(),We=a("p"),We.innerHTML=Sp,vt=n(),r(Re.$$.fragment),_t=n(),r(Ne.$$.fragment),Qt=n(),Xe=a("p"),Xe.textContent=Dp,Bt=n(),r(Ae.$$.fragment),Wt=n(),Ee=a("p"),Ee.innerHTML=Pp,Rt=n(),r(Ge.$$.fragment),Nt=n(),qe=a("p"),qe.innerHTML=Yp,Xt=n(),Le=a("p"),Le.innerHTML=Fp,At=n(),r(He.$$.fragment),Et=n(),Se=a("p"),Se.innerHTML=Kp,Gt=n(),r(De.$$.fragment),qt=n(),Pe=a("p"),Pe.innerHTML=Op,Lt=n(),Ye=a("p"),Ye.textContent=ea,Ht=n(),r(Fe.$$.fragment),St=n(),Ke=a("p"),Ke.innerHTML=sa,Dt=n(),r(Oe.$$.fragment),Pt=n(),es=a("p"),es.innerHTML=la,Yt=n(),ss=a("p"),ss.textContent=ta,Ft=n(),r(ls.$$.fragment),Kt=n(),ts=a("p"),ts.innerHTML=na,Ot=n(),r(ns.$$.fragment),en=n(),r(ps.$$.fragment),sn=n(),as=a("p"),as.textContent=pa,ln=n(),r(is.$$.fragment),tn=n(),Ms=a("p"),Ms.innerHTML=aa,nn=n(),rs=a("p"),rs.textContent=ia,pn=n(),r(cs.$$.fragment),an=n(),ys=a("p"),ys.textContent=Ma,Mn=n(),r(Js.$$.fragment),rn=n(),r(ms.$$.fragment),cn=n(),os=a("p"),os.textContent=ra,yn=n(),r(js.$$.fragment),Jn=n(),Ts=a("p"),Ts.innerHTML=ca,mn=n(),r(us.$$.fragment),on=n(),r(fs.$$.fragment),jn=n(),Us=a("p"),Us.textContent=ya,Tn=n(),r($s.$$.fragment),un=n(),ks=a("p"),ks.textContent=Ja,fn=n(),r(ds.$$.fragment),Un=n(),r(bs.$$.fragment),$n=n(),ws=a("p"),ws.innerHTML=ma,kn=n(),r(Cs.$$.fragment),dn=n(),gs=a("p"),gs.textContent=oa,bn=n(),r(xs.$$.fragment),wn=n(),hs=a("p"),hs.textContent=ja,Cn=n(),r(Is.$$.fragment),gn=n(),Vs=a("p"),Vs.innerHTML=Ta,xn=n(),r(zs.$$.fragment),hn=n(),Zs=a("p"),Zs.textContent=ua,In=n(),vs=a("p"),vs.textContent=fa,Vn=n(),r(_s.$$.fragment),zn=n(),Qs=a("p"),Qs.innerHTML=Ua,Zn=n(),Bs=a("p"),Bs.innerHTML=$a,vn=n(),r(Ws.$$.fragment),_n=n(),Rs=a("p"),Rs.textContent=ka,Qn=n(),r(Ns.$$.fragment),Bn=n(),r(Xs.$$.fragment),Wn=n(),As=a("p"),As.textContent=da,Rn=n(),r(Es.$$.fragment),Nn=n(),Gs=a("p"),Gs.innerHTML=ba,Xn=n(),qs=a("p"),qs.textContent=wa,An=n(),r(Ls.$$.fragment),En=n(),Hs=a("p"),Hs.textContent=Ca,Gn=n(),r(Ss.$$.fragment),qn=n(),r(Ds.$$.fragment),Ln=n(),Ps=a("p"),Ps.innerHTML=ga,Hn=n(),r(Ys.$$.fragment),Sn=n(),r(Fs.$$.fragment),Dn=n(),Ks=a("p"),Ks.textContent=xa,Pn=n(),r(Os.$$.fragment),Yn=n(),el=a("p"),el.textContent=ha,Fn=n(),r(sl.$$.fragment),Kn=n(),r(ll.$$.fragment),On=n(),tl=a("p"),tl.innerHTML=Ia,ep=n(),r(nl.$$.fragment),sp=n(),pl=a("p"),pl.innerHTML=Va,lp=n(),r(al.$$.fragment),tp=n(),il=a("p"),il.textContent=za,np=n(),r(Ml.$$.fragment),pp=n(),rl=a("p"),rl.textContent=Za,ap=n(),r(cl.$$.fragment),ip=n(),Jl=a("p"),this.h()},l(e){const s=Xa("svelte-u9bgzb",document.head);T=i(s,"META",{name:!0,content:!0}),s.forEach(l),$=p(e),u=i(e,"P",{}),_a(u).forEach(l),yl=p(e),c(k.$$.fragment,e),jl=p(e),c(d.$$.fragment,e),Tl=p(e),c(b.$$.fragment,e),ul=p(e),w=i(e,"P",{"data-svelte-h":!0}),M(w)!=="svelte-b5kklz"&&(w.textContent=cp),fl=p(e),C=i(e,"UL",{"data-svelte-h":!0}),M(C)!=="svelte-1sajjkb"&&(C.innerHTML=yp),Ul=p(e),g=i(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-31tofb"&&(g.textContent=Jp),$l=p(e),f=i(e,"DIV",{class:!0,"data-svelte-h":!0}),M(f)!=="svelte-oxfng3"&&(f.innerHTML=mp),kl=p(e),x=i(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-3ncb60"&&(x.innerHTML=op),dl=p(e),c(h.$$.fragment,e),bl=p(e),I=i(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1jjcw0i"&&(I.innerHTML=jp),wl=p(e),V=i(e,"UL",{"data-svelte-h":!0}),M(V)!=="svelte-400a5j"&&(V.innerHTML=Tp),Cl=p(e),z=i(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-1dqwrlj"&&(z.innerHTML=up),gl=p(e),c(Z.$$.fragment,e),xl=p(e),v=i(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-7jvs84"&&(v.innerHTML=fp),hl=p(e),c(_.$$.fragment,e),Il=p(e),Q=i(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1gsy8ta"&&(Q.innerHTML=Up),Vl=p(e),B=i(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1wtem0y"&&(B.textContent=$p),zl=p(e),c(W.$$.fragment,e),Zl=p(e),R=i(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-gnegz7"&&(R.textContent=kp),vl=p(e),c(N.$$.fragment,e),_l=p(e),X=i(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-rdvi8a"&&(X.innerHTML=dp),Ql=p(e),A=i(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-17zu5lc"&&(A.innerHTML=bp),Bl=p(e),c(E.$$.fragment,e),Wl=p(e),G=i(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1uc1t5u"&&(G.innerHTML=wp),Rl=p(e),q=i(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-14au9ct"&&(q.innerHTML=Cp),Nl=p(e),c(L.$$.fragment,e),Xl=p(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-13vk9t1"&&(H.innerHTML=gp),Al=p(e),c(S.$$.fragment,e),El=p(e),D=i(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-eabqpa"&&(D.innerHTML=xp),Gl=p(e),P=i(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-1cmtqtp"&&(P.innerHTML=hp),ql=p(e),c(Y.$$.fragment,e),Ll=p(e),c(F.$$.fragment,e),Hl=p(e),c(U.$$.fragment,e),Sl=p(e),K=i(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-1x52eyd"&&(K.innerHTML=Ip),Dl=p(e),c(O.$$.fragment,e),Pl=p(e),ee=i(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-gv0viq"&&(ee.textContent=Vp),Yl=p(e),c(se.$$.fragment,e),Fl=p(e),le=i(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-iy2ywz"&&(le.innerHTML=zp),Kl=p(e),c(te.$$.fragment,e),Ol=p(e),c(ne.$$.fragment,e),et=p(e),pe=i(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-1hk0h2e"&&(pe.innerHTML=Zp),st=p(e),c(ae.$$.fragment,e),lt=p(e),c(ie.$$.fragment,e),tt=p(e),Me=i(e,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-1be6pgh"&&(Me.innerHTML=vp),nt=p(e),c(re.$$.fragment,e),pt=p(e),c(ce.$$.fragment,e),at=p(e),ye=i(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-ornxe5"&&(ye.innerHTML=_p),it=p(e),c(Je.$$.fragment,e),Mt=p(e),me=i(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-14vfm6y"&&(me.innerHTML=Qp),rt=p(e),oe=i(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-93abaw"&&(oe.textContent=Bp),ct=p(e),c(je.$$.fragment,e),yt=p(e),Te=i(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-y1gxvq"&&(Te.innerHTML=Wp),Jt=p(e),c(ue.$$.fragment,e),mt=p(e),fe=i(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-19sql22"&&(fe.innerHTML=Rp),ot=p(e),c(Ue.$$.fragment,e),jt=p(e),c($e.$$.fragment,e),Tt=p(e),ke=i(e,"P",{"data-svelte-h":!0}),M(ke)!=="svelte-kyltif"&&(ke.innerHTML=Np),ut=p(e),de=i(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-1e0xtn8"&&(de.innerHTML=Xp),ft=p(e),c(be.$$.fragment,e),Ut=p(e),c(we.$$.fragment,e),$t=p(e),Ce=i(e,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-1nd2ny2"&&(Ce.innerHTML=Ap),kt=p(e),ge=i(e,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-na8mx0"&&(ge.textContent=Ep),dt=p(e),c(xe.$$.fragment,e),bt=p(e),he=i(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-rveu42"&&(he.textContent=Gp),wt=p(e),Ie=i(e,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-8cfq99"&&(Ie.textContent=qp),Ct=p(e),c(Ve.$$.fragment,e),gt=p(e),c(ze.$$.fragment,e),xt=p(e),Ze=i(e,"P",{"data-svelte-h":!0}),M(Ze)!=="svelte-utpzay"&&(Ze.textContent=Lp),ht=p(e),c(ve.$$.fragment,e),It=p(e),c(_e.$$.fragment,e),Vt=p(e),Qe=i(e,"P",{"data-svelte-h":!0}),M(Qe)!=="svelte-7ww78z"&&(Qe.textContent=Hp),zt=p(e),c(Be.$$.fragment,e),Zt=p(e),We=i(e,"P",{"data-svelte-h":!0}),M(We)!=="svelte-106lhsb"&&(We.innerHTML=Sp),vt=p(e),c(Re.$$.fragment,e),_t=p(e),c(Ne.$$.fragment,e),Qt=p(e),Xe=i(e,"P",{"data-svelte-h":!0}),M(Xe)!=="svelte-189m9gi"&&(Xe.textContent=Dp),Bt=p(e),c(Ae.$$.fragment,e),Wt=p(e),Ee=i(e,"P",{"data-svelte-h":!0}),M(Ee)!=="svelte-pm7hiy"&&(Ee.innerHTML=Pp),Rt=p(e),c(Ge.$$.fragment,e),Nt=p(e),qe=i(e,"P",{"data-svelte-h":!0}),M(qe)!=="svelte-1cpidft"&&(qe.innerHTML=Yp),Xt=p(e),Le=i(e,"P",{"data-svelte-h":!0}),M(Le)!=="svelte-1dxzktr"&&(Le.innerHTML=Fp),At=p(e),c(He.$$.fragment,e),Et=p(e),Se=i(e,"P",{"data-svelte-h":!0}),M(Se)!=="svelte-ttz8i2"&&(Se.innerHTML=Kp),Gt=p(e),c(De.$$.fragment,e),qt=p(e),Pe=i(e,"P",{"data-svelte-h":!0}),M(Pe)!=="svelte-1ij2bkd"&&(Pe.innerHTML=Op),Lt=p(e),Ye=i(e,"P",{"data-svelte-h":!0}),M(Ye)!=="svelte-1x7u3bt"&&(Ye.textContent=ea),Ht=p(e),c(Fe.$$.fragment,e),St=p(e),Ke=i(e,"P",{"data-svelte-h":!0}),M(Ke)!=="svelte-ms4jk9"&&(Ke.innerHTML=sa),Dt=p(e),c(Oe.$$.fragment,e),Pt=p(e),es=i(e,"P",{"data-svelte-h":!0}),M(es)!=="svelte-1efr97x"&&(es.innerHTML=la),Yt=p(e),ss=i(e,"P",{"data-svelte-h":!0}),M(ss)!=="svelte-zmu7y2"&&(ss.textContent=ta),Ft=p(e),c(ls.$$.fragment,e),Kt=p(e),ts=i(e,"P",{"data-svelte-h":!0}),M(ts)!=="svelte-1cizskw"&&(ts.innerHTML=na),Ot=p(e),c(ns.$$.fragment,e),en=p(e),c(ps.$$.fragment,e),sn=p(e),as=i(e,"P",{"data-svelte-h":!0}),M(as)!=="svelte-1a0orcp"&&(as.textContent=pa),ln=p(e),c(is.$$.fragment,e),tn=p(e),Ms=i(e,"P",{"data-svelte-h":!0}),M(Ms)!=="svelte-1p9vr1i"&&(Ms.innerHTML=aa),nn=p(e),rs=i(e,"P",{"data-svelte-h":!0}),M(rs)!=="svelte-u4s8kx"&&(rs.textContent=ia),pn=p(e),c(cs.$$.fragment,e),an=p(e),ys=i(e,"P",{"data-svelte-h":!0}),M(ys)!=="svelte-cmzjwq"&&(ys.textContent=Ma),Mn=p(e),c(Js.$$.fragment,e),rn=p(e),c(ms.$$.fragment,e),cn=p(e),os=i(e,"P",{"data-svelte-h":!0}),M(os)!=="svelte-1gd6jqz"&&(os.textContent=ra),yn=p(e),c(js.$$.fragment,e),Jn=p(e),Ts=i(e,"P",{"data-svelte-h":!0}),M(Ts)!=="svelte-1g95bkh"&&(Ts.innerHTML=ca),mn=p(e),c(us.$$.fragment,e),on=p(e),c(fs.$$.fragment,e),jn=p(e),Us=i(e,"P",{"data-svelte-h":!0}),M(Us)!=="svelte-eerktk"&&(Us.textContent=ya),Tn=p(e),c($s.$$.fragment,e),un=p(e),ks=i(e,"P",{"data-svelte-h":!0}),M(ks)!=="svelte-yra0gn"&&(ks.textContent=Ja),fn=p(e),c(ds.$$.fragment,e),Un=p(e),c(bs.$$.fragment,e),$n=p(e),ws=i(e,"P",{"data-svelte-h":!0}),M(ws)!=="svelte-ka6eer"&&(ws.innerHTML=ma),kn=p(e),c(Cs.$$.fragment,e),dn=p(e),gs=i(e,"P",{"data-svelte-h":!0}),M(gs)!=="svelte-1cmlt11"&&(gs.textContent=oa),bn=p(e),c(xs.$$.fragment,e),wn=p(e),hs=i(e,"P",{"data-svelte-h":!0}),M(hs)!=="svelte-upbbw9"&&(hs.textContent=ja),Cn=p(e),c(Is.$$.fragment,e),gn=p(e),Vs=i(e,"P",{"data-svelte-h":!0}),M(Vs)!=="svelte-gprlmq"&&(Vs.innerHTML=Ta),xn=p(e),c(zs.$$.fragment,e),hn=p(e),Zs=i(e,"P",{"data-svelte-h":!0}),M(Zs)!=="svelte-1yy918s"&&(Zs.textContent=ua),In=p(e),vs=i(e,"P",{"data-svelte-h":!0}),M(vs)!=="svelte-1n71160"&&(vs.textContent=fa),Vn=p(e),c(_s.$$.fragment,e),zn=p(e),Qs=i(e,"P",{"data-svelte-h":!0}),M(Qs)!=="svelte-197ybm4"&&(Qs.innerHTML=Ua),Zn=p(e),Bs=i(e,"P",{"data-svelte-h":!0}),M(Bs)!=="svelte-f4i3wg"&&(Bs.innerHTML=$a),vn=p(e),c(Ws.$$.fragment,e),_n=p(e),Rs=i(e,"P",{"data-svelte-h":!0}),M(Rs)!=="svelte-xj6oo"&&(Rs.textContent=ka),Qn=p(e),c(Ns.$$.fragment,e),Bn=p(e),c(Xs.$$.fragment,e),Wn=p(e),As=i(e,"P",{"data-svelte-h":!0}),M(As)!=="svelte-1tjrbj7"&&(As.textContent=da),Rn=p(e),c(Es.$$.fragment,e),Nn=p(e),Gs=i(e,"P",{"data-svelte-h":!0}),M(Gs)!=="svelte-z62fgj"&&(Gs.innerHTML=ba),Xn=p(e),qs=i(e,"P",{"data-svelte-h":!0}),M(qs)!=="svelte-u4s8kx"&&(qs.textContent=wa),An=p(e),c(Ls.$$.fragment,e),En=p(e),Hs=i(e,"P",{"data-svelte-h":!0}),M(Hs)!=="svelte-1gxe1cq"&&(Hs.textContent=Ca),Gn=p(e),c(Ss.$$.fragment,e),qn=p(e),c(Ds.$$.fragment,e),Ln=p(e),Ps=i(e,"P",{"data-svelte-h":!0}),M(Ps)!=="svelte-hd4plk"&&(Ps.innerHTML=ga),Hn=p(e),c(Ys.$$.fragment,e),Sn=p(e),c(Fs.$$.fragment,e),Dn=p(e),Ks=i(e,"P",{"data-svelte-h":!0}),M(Ks)!=="svelte-1b1rase"&&(Ks.textContent=xa),Pn=p(e),c(Os.$$.fragment,e),Yn=p(e),el=i(e,"P",{"data-svelte-h":!0}),M(el)!=="svelte-45g554"&&(el.textContent=ha),Fn=p(e),c(sl.$$.fragment,e),Kn=p(e),c(ll.$$.fragment,e),On=p(e),tl=i(e,"P",{"data-svelte-h":!0}),M(tl)!=="svelte-1b0rt28"&&(tl.innerHTML=Ia),ep=p(e),c(nl.$$.fragment,e),sp=p(e),pl=i(e,"P",{"data-svelte-h":!0}),M(pl)!=="svelte-tmcl78"&&(pl.innerHTML=Va),lp=p(e),c(al.$$.fragment,e),tp=p(e),il=i(e,"P",{"data-svelte-h":!0}),M(il)!=="svelte-b94jpj"&&(il.textContent=za),np=p(e),c(Ml.$$.fragment,e),pp=p(e),rl=i(e,"P",{"data-svelte-h":!0}),M(rl)!=="svelte-15vwsr5"&&(rl.textContent=Za),ap=p(e),c(cl.$$.fragment,e),ip=p(e),Jl=i(e,"P",{}),_a(Jl).forEach(l),this.h()},h(){rp(T,"name","hf:doc:metadata"),rp(T,"content",Pa),rp(f,"class","flex justify-center")},m(e,s){Aa(document.head,T),t(e,$,s),t(e,u,s),t(e,yl,s),y(k,e,s),t(e,jl,s),y(d,e,s),t(e,Tl,s),y(b,e,s),t(e,ul,s),t(e,w,s),t(e,fl,s),t(e,C,s),t(e,Ul,s),t(e,g,s),t(e,$l,s),t(e,f,s),t(e,kl,s),t(e,x,s),t(e,dl,s),y(h,e,s),t(e,bl,s),t(e,I,s),t(e,wl,s),t(e,V,s),t(e,Cl,s),t(e,z,s),t(e,gl,s),y(Z,e,s),t(e,xl,s),t(e,v,s),t(e,hl,s),y(_,e,s),t(e,Il,s),t(e,Q,s),t(e,Vl,s),t(e,B,s),t(e,zl,s),y(W,e,s),t(e,Zl,s),t(e,R,s),t(e,vl,s),y(N,e,s),t(e,_l,s),t(e,X,s),t(e,Ql,s),t(e,A,s),t(e,Bl,s),y(E,e,s),t(e,Wl,s),t(e,G,s),t(e,Rl,s),t(e,q,s),t(e,Nl,s),y(L,e,s),t(e,Xl,s),t(e,H,s),t(e,Al,s),y(S,e,s),t(e,El,s),t(e,D,s),t(e,Gl,s),t(e,P,s),t(e,ql,s),y(Y,e,s),t(e,Ll,s),y(F,e,s),t(e,Hl,s),y(U,e,s),t(e,Sl,s),t(e,K,s),t(e,Dl,s),y(O,e,s),t(e,Pl,s),t(e,ee,s),t(e,Yl,s),y(se,e,s),t(e,Fl,s),t(e,le,s),t(e,Kl,s),y(te,e,s),t(e,Ol,s),y(ne,e,s),t(e,et,s),t(e,pe,s),t(e,st,s),y(ae,e,s),t(e,lt,s),y(ie,e,s),t(e,tt,s),t(e,Me,s),t(e,nt,s),y(re,e,s),t(e,pt,s),y(ce,e,s),t(e,at,s),t(e,ye,s),t(e,it,s),y(Je,e,s),t(e,Mt,s),t(e,me,s),t(e,rt,s),t(e,oe,s),t(e,ct,s),y(je,e,s),t(e,yt,s),t(e,Te,s),t(e,Jt,s),y(ue,e,s),t(e,mt,s),t(e,fe,s),t(e,ot,s),y(Ue,e,s),t(e,jt,s),y($e,e,s),t(e,Tt,s),t(e,ke,s),t(e,ut,s),t(e,de,s),t(e,ft,s),y(be,e,s),t(e,Ut,s),y(we,e,s),t(e,$t,s),t(e,Ce,s),t(e,kt,s),t(e,ge,s),t(e,dt,s),y(xe,e,s),t(e,bt,s),t(e,he,s),t(e,wt,s),t(e,Ie,s),t(e,Ct,s),y(Ve,e,s),t(e,gt,s),y(ze,e,s),t(e,xt,s),t(e,Ze,s),t(e,ht,s),y(ve,e,s),t(e,It,s),y(_e,e,s),t(e,Vt,s),t(e,Qe,s),t(e,zt,s),y(Be,e,s),t(e,Zt,s),t(e,We,s),t(e,vt,s),y(Re,e,s),t(e,_t,s),y(Ne,e,s),t(e,Qt,s),t(e,Xe,s),t(e,Bt,s),y(Ae,e,s),t(e,Wt,s),t(e,Ee,s),t(e,Rt,s),y(Ge,e,s),t(e,Nt,s),t(e,qe,s),t(e,Xt,s),t(e,Le,s),t(e,At,s),y(He,e,s),t(e,Et,s),t(e,Se,s),t(e,Gt,s),y(De,e,s),t(e,qt,s),t(e,Pe,s),t(e,Lt,s),t(e,Ye,s),t(e,Ht,s),y(Fe,e,s),t(e,St,s),t(e,Ke,s),t(e,Dt,s),y(Oe,e,s),t(e,Pt,s),t(e,es,s),t(e,Yt,s),t(e,ss,s),t(e,Ft,s),y(ls,e,s),t(e,Kt,s),t(e,ts,s),t(e,Ot,s),y(ns,e,s),t(e,en,s),y(ps,e,s),t(e,sn,s),t(e,as,s),t(e,ln,s),y(is,e,s),t(e,tn,s),t(e,Ms,s),t(e,nn,s),t(e,rs,s),t(e,pn,s),y(cs,e,s),t(e,an,s),t(e,ys,s),t(e,Mn,s),y(Js,e,s),t(e,rn,s),y(ms,e,s),t(e,cn,s),t(e,os,s),t(e,yn,s),y(js,e,s),t(e,Jn,s),t(e,Ts,s),t(e,mn,s),y(us,e,s),t(e,on,s),y(fs,e,s),t(e,jn,s),t(e,Us,s),t(e,Tn,s),y($s,e,s),t(e,un,s),t(e,ks,s),t(e,fn,s),y(ds,e,s),t(e,Un,s),y(bs,e,s),t(e,$n,s),t(e,ws,s),t(e,kn,s),y(Cs,e,s),t(e,dn,s),t(e,gs,s),t(e,bn,s),y(xs,e,s),t(e,wn,s),t(e,hs,s),t(e,Cn,s),y(Is,e,s),t(e,gn,s),t(e,Vs,s),t(e,xn,s),y(zs,e,s),t(e,hn,s),t(e,Zs,s),t(e,In,s),t(e,vs,s),t(e,Vn,s),y(_s,e,s),t(e,zn,s),t(e,Qs,s),t(e,Zn,s),t(e,Bs,s),t(e,vn,s),y(Ws,e,s),t(e,_n,s),t(e,Rs,s),t(e,Qn,s),y(Ns,e,s),t(e,Bn,s),y(Xs,e,s),t(e,Wn,s),t(e,As,s),t(e,Rn,s),y(Es,e,s),t(e,Nn,s),t(e,Gs,s),t(e,Xn,s),t(e,qs,s),t(e,An,s),y(Ls,e,s),t(e,En,s),t(e,Hs,s),t(e,Gn,s),y(Ss,e,s),t(e,qn,s),y(Ds,e,s),t(e,Ln,s),t(e,Ps,s),t(e,Hn,s),y(Ys,e,s),t(e,Sn,s),y(Fs,e,s),t(e,Dn,s),t(e,Ks,s),t(e,Pn,s),y(Os,e,s),t(e,Yn,s),t(e,el,s),t(e,Fn,s),y(sl,e,s),t(e,Kn,s),y(ll,e,s),t(e,On,s),t(e,tl,s),t(e,ep,s),y(nl,e,s),t(e,sp,s),t(e,pl,s),t(e,lp,s),y(al,e,s),t(e,tp,s),t(e,il,s),t(e,np,s),y(Ml,e,s),t(e,pp,s),t(e,rl,s),t(e,ap,s),y(cl,e,s),t(e,ip,s),t(e,Jl,s),Mp=!0},p(e,[s]){const va={};s&2&&(va.$$scope={dirty:s,ctx:e}),U.$set(va)},i(e){Mp||(J(k.$$.fragment,e),J(d.$$.fragment,e),J(b.$$.fragment,e),J(h.$$.fragment,e),J(Z.$$.fragment,e),J(_.$$.fragment,e),J(W.$$.fragment,e),J(N.$$.fragment,e),J(E.$$.fragment,e),J(L.$$.fragment,e),J(S.$$.fragment,e),J(Y.$$.fragment,e),J(F.$$.fragment,e),J(U.$$.fragment,e),J(O.$$.fragment,e),J(se.$$.fragment,e),J(te.$$.fragment,e),J(ne.$$.fragment,e),J(ae.$$.fragment,e),J(ie.$$.fragment,e),J(re.$$.fragment,e),J(ce.$$.fragment,e),J(Je.$$.fragment,e),J(je.$$.fragment,e),J(ue.$$.fragment,e),J(Ue.$$.fragment,e),J($e.$$.fragment,e),J(be.$$.fragment,e),J(we.$$.fragment,e),J(xe.$$.fragment,e),J(Ve.$$.fragment,e),J(ze.$$.fragment,e),J(ve.$$.fragment,e),J(_e.$$.fragment,e),J(Be.$$.fragment,e),J(Re.$$.fragment,e),J(Ne.$$.fragment,e),J(Ae.$$.fragment,e),J(Ge.$$.fragment,e),J(He.$$.fragment,e),J(De.$$.fragment,e),J(Fe.$$.fragment,e),J(Oe.$$.fragment,e),J(ls.$$.fragment,e),J(ns.$$.fragment,e),J(ps.$$.fragment,e),J(is.$$.fragment,e),J(cs.$$.fragment,e),J(Js.$$.fragment,e),J(ms.$$.fragment,e),J(js.$$.fragment,e),J(us.$$.fragment,e),J(fs.$$.fragment,e),J($s.$$.fragment,e),J(ds.$$.fragment,e),J(bs.$$.fragment,e),J(Cs.$$.fragment,e),J(xs.$$.fragment,e),J(Is.$$.fragment,e),J(zs.$$.fragment,e),J(_s.$$.fragment,e),J(Ws.$$.fragment,e),J(Ns.$$.fragment,e),J(Xs.$$.fragment,e),J(Es.$$.fragment,e),J(Ls.$$.fragment,e),J(Ss.$$.fragment,e),J(Ds.$$.fragment,e),J(Ys.$$.fragment,e),J(Fs.$$.fragment,e),J(Os.$$.fragment,e),J(sl.$$.fragment,e),J(ll.$$.fragment,e),J(nl.$$.fragment,e),J(al.$$.fragment,e),J(Ml.$$.fragment,e),J(cl.$$.fragment,e),Mp=!0)},o(e){m(k.$$.fragment,e),m(d.$$.fragment,e),m(b.$$.fragment,e),m(h.$$.fragment,e),m(Z.$$.fragment,e),m(_.$$.fragment,e),m(W.$$.fragment,e),m(N.$$.fragment,e),m(E.$$.fragment,e),m(L.$$.fragment,e),m(S.$$.fragment,e),m(Y.$$.fragment,e),m(F.$$.fragment,e),m(U.$$.fragment,e),m(O.$$.fragment,e),m(se.$$.fragment,e),m(te.$$.fragment,e),m(ne.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(ce.$$.fragment,e),m(Je.$$.fragment,e),m(je.$$.fragment,e),m(ue.$$.fragment,e),m(Ue.$$.fragment,e),m($e.$$.fragment,e),m(be.$$.fragment,e),m(we.$$.fragment,e),m(xe.$$.fragment,e),m(Ve.$$.fragment,e),m(ze.$$.fragment,e),m(ve.$$.fragment,e),m(_e.$$.fragment,e),m(Be.$$.fragment,e),m(Re.$$.fragment,e),m(Ne.$$.fragment,e),m(Ae.$$.fragment,e),m(Ge.$$.fragment,e),m(He.$$.fragment,e),m(De.$$.fragment,e),m(Fe.$$.fragment,e),m(Oe.$$.fragment,e),m(ls.$$.fragment,e),m(ns.$$.fragment,e),m(ps.$$.fragment,e),m(is.$$.fragment,e),m(cs.$$.fragment,e),m(Js.$$.fragment,e),m(ms.$$.fragment,e),m(js.$$.fragment,e),m(us.$$.fragment,e),m(fs.$$.fragment,e),m($s.$$.fragment,e),m(ds.$$.fragment,e),m(bs.$$.fragment,e),m(Cs.$$.fragment,e),m(xs.$$.fragment,e),m(Is.$$.fragment,e),m(zs.$$.fragment,e),m(_s.$$.fragment,e),m(Ws.$$.fragment,e),m(Ns.$$.fragment,e),m(Xs.$$.fragment,e),m(Es.$$.fragment,e),m(Ls.$$.fragment,e),m(Ss.$$.fragment,e),m(Ds.$$.fragment,e),m(Ys.$$.fragment,e),m(Fs.$$.fragment,e),m(Os.$$.fragment,e),m(sl.$$.fragment,e),m(ll.$$.fragment,e),m(nl.$$.fragment,e),m(al.$$.fragment,e),m(Ml.$$.fragment,e),m(cl.$$.fragment,e),Mp=!1},d(e){e&&(l($),l(u),l(yl),l(jl),l(Tl),l(ul),l(w),l(fl),l(C),l(Ul),l(g),l($l),l(f),l(kl),l(x),l(dl),l(bl),l(I),l(wl),l(V),l(Cl),l(z),l(gl),l(xl),l(v),l(hl),l(Il),l(Q),l(Vl),l(B),l(zl),l(Zl),l(R),l(vl),l(_l),l(X),l(Ql),l(A),l(Bl),l(Wl),l(G),l(Rl),l(q),l(Nl),l(Xl),l(H),l(Al),l(El),l(D),l(Gl),l(P),l(ql),l(Ll),l(Hl),l(Sl),l(K),l(Dl),l(Pl),l(ee),l(Yl),l(Fl),l(le),l(Kl),l(Ol),l(et),l(pe),l(st),l(lt),l(tt),l(Me),l(nt),l(pt),l(at),l(ye),l(it),l(Mt),l(me),l(rt),l(oe),l(ct),l(yt),l(Te),l(Jt),l(mt),l(fe),l(ot),l(jt),l(Tt),l(ke),l(ut),l(de),l(ft),l(Ut),l($t),l(Ce),l(kt),l(ge),l(dt),l(bt),l(he),l(wt),l(Ie),l(Ct),l(gt),l(xt),l(Ze),l(ht),l(It),l(Vt),l(Qe),l(zt),l(Zt),l(We),l(vt),l(_t),l(Qt),l(Xe),l(Bt),l(Wt),l(Ee),l(Rt),l(Nt),l(qe),l(Xt),l(Le),l(At),l(Et),l(Se),l(Gt),l(qt),l(Pe),l(Lt),l(Ye),l(Ht),l(St),l(Ke),l(Dt),l(Pt),l(es),l(Yt),l(ss),l(Ft),l(Kt),l(ts),l(Ot),l(en),l(sn),l(as),l(ln),l(tn),l(Ms),l(nn),l(rs),l(pn),l(an),l(ys),l(Mn),l(rn),l(cn),l(os),l(yn),l(Jn),l(Ts),l(mn),l(on),l(jn),l(Us),l(Tn),l(un),l(ks),l(fn),l(Un),l($n),l(ws),l(kn),l(dn),l(gs),l(bn),l(wn),l(hs),l(Cn),l(gn),l(Vs),l(xn),l(hn),l(Zs),l(In),l(vs),l(Vn),l(zn),l(Qs),l(Zn),l(Bs),l(vn),l(_n),l(Rs),l(Qn),l(Bn),l(Wn),l(As),l(Rn),l(Nn),l(Gs),l(Xn),l(qs),l(An),l(En),l(Hs),l(Gn),l(qn),l(Ln),l(Ps),l(Hn),l(Sn),l(Dn),l(Ks),l(Pn),l(Yn),l(el),l(Fn),l(Kn),l(On),l(tl),l(ep),l(sp),l(pl),l(lp),l(tp),l(il),l(np),l(pp),l(rl),l(ap),l(ip),l(Jl)),l(T),o(k,e),o(d,e),o(b,e),o(h,e),o(Z,e),o(_,e),o(W,e),o(N,e),o(E,e),o(L,e),o(S,e),o(Y,e),o(F,e),o(U,e),o(O,e),o(se,e),o(te,e),o(ne,e),o(ae,e),o(ie,e),o(re,e),o(ce,e),o(Je,e),o(je,e),o(ue,e),o(Ue,e),o($e,e),o(be,e),o(we,e),o(xe,e),o(Ve,e),o(ze,e),o(ve,e),o(_e,e),o(Be,e),o(Re,e),o(Ne,e),o(Ae,e),o(Ge,e),o(He,e),o(De,e),o(Fe,e),o(Oe,e),o(ls,e),o(ns,e),o(ps,e),o(is,e),o(cs,e),o(Js,e),o(ms,e),o(js,e),o(us,e),o(fs,e),o($s,e),o(ds,e),o(bs,e),o(Cs,e),o(xs,e),o(Is,e),o(zs,e),o(_s,e),o(Ws,e),o(Ns,e),o(Xs,e),o(Es,e),o(Ls,e),o(Ss,e),o(Ds,e),o(Ys,e),o(Fs,e),o(Os,e),o(sl,e),o(ll,e),o(nl,e),o(al,e),o(Ml,e),o(cl,e)}}}const Pa='{"title":"Создание токенизатора, блок за блоком","local":"building-a-tokenizer-block-by-block","sections":[{"title":"Получение корпуса текста","local":"acquiring-a-corpus","sections":[],"depth":2},{"title":"Создание токенизатора WordPiece с нуля","local":"building-a-wordpiece-tokenizer-from-scratch","sections":[],"depth":2},{"title":"Создание токенизатора BPE с нуля","local":"building-a-bpe-tokenizer-from-scratch","sections":[],"depth":2},{"title":"Создание токенизатора Unigram с нуля","local":"building-a-unigram-tokenizer-from-scratch","sections":[],"depth":2}],"depth":1}';function Ya(ol){return Ba(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ni extends Ra{constructor(T){super(),Na(this,T,Ya,Da,Qa,{})}}export{ni as component};
