import{s as Qt,a as it,n as St,o as Vt}from"../chunks/scheduler.cc52f4b9.js";import{S as Xt,i as Nt,e as i,s as a,c as y,h as Yt,a as p,d as l,b as n,f as Me,g as m,j as o,k as r,l as Pt,m as s,n as d,t as w,o as T,p as j}from"../chunks/index.9480bb2b.js";import{C as zt,H as oe,E as Ft}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.e0b4ce23.js";import{C as pt}from"../chunks/CodeBlock.d991436c.js";import{C as Dt}from"../chunks/CourseFloatingBanner.0ea490da.js";function Kt(ot){let J,ce,re,ye,f,me,h,de,U,we,b,rt=`В этом разделе мы подробно рассмотрим класс <code>Interface</code> и разберем
основные параметры, используемые для его создания.`,Te,I,je,C,ut="Вы заметите, что класс <code>Interface</code> имеет 3 обязательных параметра:",Je,v,Mt="<code>Interface(fn, inputs, outputs, ...)</code>",fe,g,ct="Это параметры:",he,k,yt="<li><code>fn</code>: функция прогнозирования, обернутая интерфейсом Gradio. Эта функция может принимать один или несколько параметров и возвращать одно или несколько значений</li> <li><code>inputs</code>: тип(ы) компонента(ов) ввода. Gradio предоставляет множество готовых компонентов, таких как <code>&quot;image&quot;</code> или <code>&quot;mic&quot;</code>.</li> <li><code>outputs</code>: тип(ы) компонента(ов) вывода. Опять же, Gradio предоставляет множество предварительно созданных компонентов, например, <code>&quot; image&quot;</code> или <code>&quot;label&quot;</code>.</li>",Ue,$,mt='Полный список компонентов <a href="https://gradio.app/docs" rel="nofollow">смотрите в документации Gradio</a>. Каждый предварительно созданный компонент можно настроить, инстанцировав соответствующий ему класс.',be,A,dt=`Например, как мы видели в <a href="../chapter9/2">предыдущем разделе</a>,
вместо передачи <code>&quot;textbox&quot;</code> в параметр <code>inputs</code>, вы можете передать компонент <code>Textbox(lines=7, label=&quot;Prompt&quot;)</code> для создания текстового поля с 7 строками и меткой.`,Ie,x,wt="Давайте рассмотрим еще один пример, на этот раз с компонентом <code>Audio</code>.",Ce,G,ve,q,Tt=`Как уже говорилось, Gradio предоставляет множество различных входов и выходов.
Поэтому давайте создадим <code>Interface</code>, работающий с аудио.`,ge,B,jt=`В этом примере мы создадим функцию audio-to-audio, которая принимает
аудиофайл и просто переворачивает его.`,ke,_,Jt=`Для ввода мы будем использовать компонент <code>Audio</code>. При использовании компонента <code>Audio</code>,
вы можете указать, будет ли источником звука файл, который загружает пользователь
или микрофон, с помощью которого пользователь записывает свой голос. В данном случае давайте
зададим <code>&quot;microphone&quot;</code>. Просто ради интереса добавим к <code>Audio</code> метку, которая будет гласить
“Speak here…“.`,$e,Z,ft=`Кроме того, мы хотели бы получать аудио в виде массива numpy, чтобы можно было легко
“перевернуть” его. Поэтому мы зададим <code>&quot;type&quot;</code> в значение <code>&quot;numpy&quot;</code>, которое передаст входные
данные в виде кортежа (<code>sample_rate</code>, <code>data</code>) в нашу функцию.`,Ae,H,ht=`Мы также будем использовать компонент вывода <code>Audio</code>, который может автоматически
рендерить кортеж с частотой дискретизации и массивом данных numpy в воспроизводимый аудиофайл.
В этом случае нам не нужно делать никаких настроек, поэтому мы будем использовать строку
ярлык <code>&quot;audio&quot;</code>.`,xe,E,Ge,L,Ut=`Код, приведенный выше, создаст интерфейс, подобный приведенному ниже (если ваш браузер не
не запрашивает разрешения на использование микрофона, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">откройте демо в отдельной вкладке</a>.)`,qe,u,bt,Be,W,It="Теперь вы сможете записать свой голос и услышать, как вы говорите в обратную сторону - жутковато 👻!",_e,R,Ze,Q,Ct=`Допустим, у нас есть более сложная функция, с несколькими входами и выходами.
В примере ниже у нас есть функция, которая принимает индекс выпадающего списка, значение слайдера и число,
и возвращает пример музыкального тона.`,He,S,vt=`Посмотрите, как мы передаем список входных и выходных компонентов,
и посмотрите, сможете ли вы проследить за тем, что происходит.`,Ee,V,gt="Ключевым моментом здесь является то, что когда вы передаете:",Le,X,kt="<li>список входных компонентов, каждый компонент соответствует параметру по порядку.</li> <li>список выходных компонентов, каждый компонент соответствует возвращаемому значению.</li>",We,N,$t="В приведенном ниже фрагменте кода показано, как три компонента ввода соответствуют трем аргументам функции <code>generate_tone()</code>:",Re,Y,Qe,M,At,Se,P,Ve,z,xt=`До сих пор мы использовали метод <code>launch()</code> для запуска интерфейса, но мы
не обсуждали, что он делает.`,Xe,F,Gt=`По умолчанию метод <code>launch()</code> запускает демо на веб-сервере, который
работает локально. Если вы выполняете свой код в блокноте Jupyter или Colab, то
Gradio встроит демо GUI в блокнот, чтобы вы могли легко им пользоваться.`,Ne,D,qt="Вы можете настроить поведение <code>launch()</code> с помощью различных параметров:",Ye,K,Bt="<li><code>inline</code> - отображать ли интерфейс в виде строки в блокнотах Python.</li> <li><code>inbrowser</code> - автоматически ли запускать интерфейс в новой вкладке браузера по умолчанию.</li> <li><code>share</code> - создавать ли для интерфейса общедоступную ссылку с вашего компьютера. Что-то вроде ссылки на Google Drive!</li>",Pe,O,_t="Мы рассмотрим параметр <code>share</code> более подробно в следующем разделе!",ze,ee,Fe,te,Zt=`Давайте создадим интерфейс, который позволит вам продемонстрировать демо модели <strong>распознавания речи</strong>.
Чтобы было интереснее, мы будем принимать <em>либо</em> микрофонный вход, либо загруженный файл.`,De,le,Ht=`Как обычно, мы загрузим нашу модель распознавания речи с помощью функции <code>pipeline()</code> из 🤗 Transformers.
Если вам нужно быстро вспомнить, вы можете вернуться к <a href="../chapter1/3">этому разделу в Главе 1</a>. Далее мы реализуем функцию <code>transcribe_audio()</code>, которая обрабатывает аудио и возвращает транскрипцию. Наконец, мы обернем эту функцию в <code>Interface</code> с компонентами <code>Audio</code> на входе и просто текстом на выходе. В целом, код этого приложения выглядит следующим образом:`,Ke,se,Oe,ae,Et='Если ваш браузер не запрашивает разрешения на использование микрофона, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">откройте демо в отдельной вкладке</a>.',et,c,Lt,tt,ne,Wt=`Вот и все! Теперь вы можете использовать этот интерфейс для транскрибирования аудио. Обратите внимание, что
передавая параметр <code>optional</code> как <code>True</code>, мы позволяем пользователю предоставить
либо микрофон, либо аудиофайл (либо ни то, ни другое, но в этом случае будет выдано сообщение об ошибке).`,lt,ie,Rt="Продолжайте, чтобы узнать, как поделиться своим интерфейсом с другими!",st,pe,at,ue,nt;return f=new zt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),h=new oe({props:{title:"Понимание класса Interface",local:"understanding-the-interface-class",headingTag:"h1"}}),U=new Dt({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section3.ipynb"}]}}),I=new oe({props:{title:"Как создать Interface",local:"how-to-create-an-interface",headingTag:"h2"}}),G=new oe({props:{title:"Простой пример со звуком",local:"a-simple-example-with-audio",headingTag:"h2"}}),E=new pt({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMHJldmVyc2VfYXVkaW8oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMkMlMjBkYXRhJTIwJTNEJTIwYXVkaW8lMEElMjAlMjAlMjAlMjByZXZlcnNlZF9hdWRpbyUyMCUzRCUyMChzciUyQyUyMG5wLmZsaXB1ZChkYXRhKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXZlcnNlZF9hdWRpbyUwQSUwQSUwQW1pYyUyMCUzRCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMm1pY3JvcGhvbmUlMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIlMkMlMjBsYWJlbCUzRCUyMlNwZWFrJTIwaGVyZS4uLiUyMiklMEFnci5JbnRlcmZhY2UocmV2ZXJzZV9hdWRpbyUyQyUyMG1pYyUyQyUyMCUyMmF1ZGlvJTIyKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse_audio</span>(<span class="hljs-params">audio</span>):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    <span class="hljs-keyword">return</span> reversed_audio


mic = gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>, label=<span class="hljs-string">&quot;Speak here...&quot;</span>)
gr.Interface(reverse_audio, mic, <span class="hljs-string">&quot;audio&quot;</span>).launch()`,wrap:!1}}),R=new oe({props:{title:"Обработка нескольких входов и выходов",local:"handling-multiple-inputs-and-outputs",headingTag:"h2"}}),Y=new pt({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW5vdGVzJTIwJTNEJTIwJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjMlMjIlMkMlMjAlMjJEJTIyJTJDJTIwJTIyRCUyMyUyMiUyQyUyMCUyMkUlMjIlMkMlMjAlMjJGJTIyJTJDJTIwJTIyRiUyMyUyMiUyQyUyMCUyMkclMjIlMkMlMjAlMjJHJTIzJTIyJTJDJTIwJTIyQSUyMiUyQyUyMCUyMkElMjMlMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGVfdG9uZShub3RlJTJDJTIwb2N0YXZlJTJDJTIwZHVyYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMjAlM0QlMjA0ODAwMCUwQSUyMCUyMCUyMCUyMGE0X2ZyZXElMkMlMjB0b25lc19mcm9tX2E0JTIwJTNEJTIwNDQwJTJDJTIwMTIlMjAqJTIwKG9jdGF2ZSUyMC0lMjA0KSUyMCUyQiUyMChub3RlJTIwLSUyMDkpJTBBJTIwJTIwJTIwJTIwZnJlcXVlbmN5JTIwJTNEJTIwYTRfZnJlcSUyMColMjAyJTIwKiolMjAodG9uZXNfZnJvbV9hNCUyMCUyRiUyMDEyKSUwQSUyMCUyMCUyMCUyMGR1cmF0aW9uJTIwJTNEJTIwaW50KGR1cmF0aW9uKSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbnAubGluc3BhY2UoMCUyQyUyMGR1cmF0aW9uJTJDJTIwZHVyYXRpb24lMjAqJTIwc3IpJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjAoMjAwMDAlMjAqJTIwbnAuc2luKGF1ZGlvJTIwKiUyMCgyJTIwKiUyMG5wLnBpJTIwKiUyMGZyZXF1ZW5jeSkpKS5hc3R5cGUobnAuaW50MTYpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKHNyJTJDJTIwYXVkaW8pJTBBJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX3RvbmUlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5Ecm9wZG93bihub3RlcyUyQyUyMHR5cGUlM0QlMjJpbmRleCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIobWluaW11bSUzRDQlMkMlMjBtYXhpbXVtJTNENiUyQyUyMHN0ZXAlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3godHlwZSUzRCUyMm51bWJlciUyMiUyQyUyMHZhbHVlJTNEMSUyQyUyMGxhYmVsJTNEJTIyRHVyYXRpb24lMjBpbiUyMHNlY29uZHMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW8lMjIlMkMlMEEpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

notes = [<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C#&quot;</span>, <span class="hljs-string">&quot;D&quot;</span>, <span class="hljs-string">&quot;D#&quot;</span>, <span class="hljs-string">&quot;E&quot;</span>, <span class="hljs-string">&quot;F&quot;</span>, <span class="hljs-string">&quot;F#&quot;</span>, <span class="hljs-string">&quot;G&quot;</span>, <span class="hljs-string">&quot;G#&quot;</span>, <span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;A#&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tone</span>(<span class="hljs-params">note, octave, duration</span>):
    sr = <span class="hljs-number">48000</span>
    a4_freq, tones_from_a4 = <span class="hljs-number">440</span>, <span class="hljs-number">12</span> * (octave - <span class="hljs-number">4</span>) + (note - <span class="hljs-number">9</span>)
    frequency = a4_freq * <span class="hljs-number">2</span> ** (tones_from_a4 / <span class="hljs-number">12</span>)
    duration = <span class="hljs-built_in">int</span>(duration)
    audio = np.linspace(<span class="hljs-number">0</span>, duration, duration * sr)
    audio = (<span class="hljs-number">20000</span> * np.sin(audio * (<span class="hljs-number">2</span> * np.pi * frequency))).astype(np.int16)
    <span class="hljs-keyword">return</span> (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;index&quot;</span>),
        gr.Slider(minimum=<span class="hljs-number">4</span>, maximum=<span class="hljs-number">6</span>, step=<span class="hljs-number">1</span>),
        gr.Textbox(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;number&quot;</span>, value=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Duration in seconds&quot;</span>),
    ],
    <span class="hljs-string">&quot;audio&quot;</span>,
).launch()`,wrap:!1}}),P=new oe({props:{title:"Метод launch()",local:"the-launch-method",headingTag:"h3"}}),ee=new oe({props:{title:"✏️ Давайте применим это!",local:"lets-apply-it",headingTag:"h2"}}),se=new pt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW1vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKG1pYyUzRE5vbmUlMkMlMjBmaWxlJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMG1pYyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbWljJTBBJTIwJTIwJTIwJTIwZWxpZiUyMGZpbGUlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpbyUyMCUzRCUyMGZpbGUlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyWW91JTIwbXVzdCUyMGVpdGhlciUyMHByb3ZpZGUlMjBhJTIwbWljJTIwcmVjb3JkaW5nJTIwb3IlMjBhJTIwZmlsZSUyMiUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHRpb24lMjAlM0QlMjBtb2RlbChhdWRpbyklNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdGlvbiUwQSUwQSUwQWdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHRyYW5zY3JpYmVfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5BdWRpbyhzb3VyY2UlM0QlMjJtaWNyb3Bob25lJTIyJTJDJTIwdHlwZSUzRCUyMmZpbGVwYXRoJTIyJTJDJTIwb3B0aW9uYWwlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMnVwbG9hZCUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiUyQyUyMG9wdGlvbmFsJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEJTIydGV4dCUyMiUyQyUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

model = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">mic=<span class="hljs-literal">None</span>, file=<span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">if</span> mic <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = mic
    <span class="hljs-keyword">elif</span> file <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = file
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;You must either provide a mic recording or a file&quot;</span>
    transcription = model(audio)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=[
        gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
        gr.Audio(source=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
    ],
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
).launch()`,wrap:!1}}),pe=new Ft({props:{source:"https://github.com/huggingface/course/blob/main/chapters/ru/chapter9/3.mdx"}}),{c(){J=i("meta"),ce=a(),re=i("p"),ye=a(),y(f.$$.fragment),me=a(),y(h.$$.fragment),de=a(),y(U.$$.fragment),we=a(),b=i("p"),b.innerHTML=rt,Te=a(),y(I.$$.fragment),je=a(),C=i("p"),C.innerHTML=ut,Je=a(),v=i("p"),v.innerHTML=Mt,fe=a(),g=i("p"),g.textContent=ct,he=a(),k=i("ul"),k.innerHTML=yt,Ue=a(),$=i("p"),$.innerHTML=mt,be=a(),A=i("p"),A.innerHTML=dt,Ie=a(),x=i("p"),x.innerHTML=wt,Ce=a(),y(G.$$.fragment),ve=a(),q=i("p"),q.innerHTML=Tt,ge=a(),B=i("p"),B.textContent=jt,ke=a(),_=i("p"),_.innerHTML=Jt,$e=a(),Z=i("p"),Z.innerHTML=ft,Ae=a(),H=i("p"),H.innerHTML=ht,xe=a(),y(E.$$.fragment),Ge=a(),L=i("p"),L.innerHTML=Ut,qe=a(),u=i("iframe"),Be=a(),W=i("p"),W.textContent=It,_e=a(),y(R.$$.fragment),Ze=a(),Q=i("p"),Q.textContent=Ct,He=a(),S=i("p"),S.textContent=vt,Ee=a(),V=i("p"),V.textContent=gt,Le=a(),X=i("ul"),X.innerHTML=kt,We=a(),N=i("p"),N.innerHTML=$t,Re=a(),y(Y.$$.fragment),Qe=a(),M=i("iframe"),Se=a(),y(P.$$.fragment),Ve=a(),z=i("p"),z.innerHTML=xt,Xe=a(),F=i("p"),F.innerHTML=Gt,Ne=a(),D=i("p"),D.innerHTML=qt,Ye=a(),K=i("ul"),K.innerHTML=Bt,Pe=a(),O=i("p"),O.innerHTML=_t,ze=a(),y(ee.$$.fragment),Fe=a(),te=i("p"),te.innerHTML=Zt,De=a(),le=i("p"),le.innerHTML=Ht,Ke=a(),y(se.$$.fragment),Oe=a(),ae=i("p"),ae.innerHTML=Et,et=a(),c=i("iframe"),tt=a(),ne=i("p"),ne.innerHTML=Wt,lt=a(),ie=i("p"),ie.textContent=Rt,st=a(),y(pe.$$.fragment),at=a(),ue=i("p"),this.h()},l(e){const t=Yt("svelte-u9bgzb",document.head);J=p(t,"META",{name:!0,content:!0}),t.forEach(l),ce=n(e),re=p(e,"P",{}),Me(re).forEach(l),ye=n(e),m(f.$$.fragment,e),me=n(e),m(h.$$.fragment,e),de=n(e),m(U.$$.fragment,e),we=n(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-enud80"&&(b.innerHTML=rt),Te=n(e),m(I.$$.fragment,e),je=n(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-o67r3h"&&(C.innerHTML=ut),Je=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-5xxju6"&&(v.innerHTML=Mt),fe=n(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-8iucyy"&&(g.textContent=ct),he=n(e),k=p(e,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-1akaxuo"&&(k.innerHTML=yt),Ue=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-mxtpfm"&&($.innerHTML=mt),be=n(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1gornw1"&&(A.innerHTML=dt),Ie=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-4nkf1r"&&(x.innerHTML=wt),Ce=n(e),m(G.$$.fragment,e),ve=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-rfepod"&&(q.innerHTML=Tt),ge=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-n97h54"&&(B.textContent=jt),ke=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-ar1v2m"&&(_.innerHTML=Jt),$e=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1uvsg1h"&&(Z.innerHTML=ft),Ae=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-c9vyv"&&(H.innerHTML=ht),xe=n(e),m(E.$$.fragment,e),Ge=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1af1p3z"&&(L.innerHTML=Ut),qe=n(e),u=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),Me(u).forEach(l),Be=n(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-jmjdad"&&(W.textContent=It),_e=n(e),m(R.$$.fragment,e),Ze=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-s5r27g"&&(Q.textContent=Ct),He=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1hey8tu"&&(S.textContent=vt),Ee=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1lht4t5"&&(V.textContent=gt),Le=n(e),X=p(e,"UL",{"data-svelte-h":!0}),o(X)!=="svelte-1p7h9vd"&&(X.innerHTML=kt),We=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-17e54rp"&&(N.innerHTML=$t),Re=n(e),m(Y.$$.fragment,e),Qe=n(e),M=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),Me(M).forEach(l),Se=n(e),m(P.$$.fragment,e),Ve=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-14rvhw3"&&(z.innerHTML=xt),Xe=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1ssmino"&&(F.innerHTML=Gt),Ne=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1gc9s6c"&&(D.innerHTML=qt),Ye=n(e),K=p(e,"UL",{"data-svelte-h":!0}),o(K)!=="svelte-8vsj85"&&(K.innerHTML=Bt),Pe=n(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-15hrsz7"&&(O.innerHTML=_t),ze=n(e),m(ee.$$.fragment,e),Fe=n(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-kv7bmf"&&(te.innerHTML=Zt),De=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-ifycgo"&&(le.innerHTML=Ht),Ke=n(e),m(se.$$.fragment,e),Oe=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1riv6tk"&&(ae.innerHTML=Et),et=n(e),c=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),Me(c).forEach(l),tt=n(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1gkr56k"&&(ne.innerHTML=Wt),lt=n(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-o596jh"&&(ie.textContent=Rt),st=n(e),m(pe.$$.fragment,e),at=n(e),ue=p(e,"P",{}),Me(ue).forEach(l),this.h()},h(){r(J,"name","hf:doc:metadata"),r(J,"content",Ot),it(u.src,bt="https://course-demos-audio-reverse.hf.space")||r(u,"src",bt),r(u,"frameborder","0"),r(u,"height","250"),r(u,"title","Gradio app"),r(u,"class","container p-0 flex-grow space-iframe"),r(u,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(u,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),it(M.src,At="https://course-demos-generate-tone.hf.space")||r(M,"src",At),r(M,"frameborder","0"),r(M,"height","450"),r(M,"title","Gradio app"),r(M,"class","container p-0 flex-grow space-iframe"),r(M,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(M,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),it(c.src,Lt="https://course-demos-asr.hf.space")||r(c,"src",Lt),r(c,"frameborder","0"),r(c,"height","550"),r(c,"title","Gradio app"),r(c,"class","container p-0 flex-grow space-iframe"),r(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){Pt(document.head,J),s(e,ce,t),s(e,re,t),s(e,ye,t),d(f,e,t),s(e,me,t),d(h,e,t),s(e,de,t),d(U,e,t),s(e,we,t),s(e,b,t),s(e,Te,t),d(I,e,t),s(e,je,t),s(e,C,t),s(e,Je,t),s(e,v,t),s(e,fe,t),s(e,g,t),s(e,he,t),s(e,k,t),s(e,Ue,t),s(e,$,t),s(e,be,t),s(e,A,t),s(e,Ie,t),s(e,x,t),s(e,Ce,t),d(G,e,t),s(e,ve,t),s(e,q,t),s(e,ge,t),s(e,B,t),s(e,ke,t),s(e,_,t),s(e,$e,t),s(e,Z,t),s(e,Ae,t),s(e,H,t),s(e,xe,t),d(E,e,t),s(e,Ge,t),s(e,L,t),s(e,qe,t),s(e,u,t),s(e,Be,t),s(e,W,t),s(e,_e,t),d(R,e,t),s(e,Ze,t),s(e,Q,t),s(e,He,t),s(e,S,t),s(e,Ee,t),s(e,V,t),s(e,Le,t),s(e,X,t),s(e,We,t),s(e,N,t),s(e,Re,t),d(Y,e,t),s(e,Qe,t),s(e,M,t),s(e,Se,t),d(P,e,t),s(e,Ve,t),s(e,z,t),s(e,Xe,t),s(e,F,t),s(e,Ne,t),s(e,D,t),s(e,Ye,t),s(e,K,t),s(e,Pe,t),s(e,O,t),s(e,ze,t),d(ee,e,t),s(e,Fe,t),s(e,te,t),s(e,De,t),s(e,le,t),s(e,Ke,t),d(se,e,t),s(e,Oe,t),s(e,ae,t),s(e,et,t),s(e,c,t),s(e,tt,t),s(e,ne,t),s(e,lt,t),s(e,ie,t),s(e,st,t),d(pe,e,t),s(e,at,t),s(e,ue,t),nt=!0},p:St,i(e){nt||(w(f.$$.fragment,e),w(h.$$.fragment,e),w(U.$$.fragment,e),w(I.$$.fragment,e),w(G.$$.fragment,e),w(E.$$.fragment,e),w(R.$$.fragment,e),w(Y.$$.fragment,e),w(P.$$.fragment,e),w(ee.$$.fragment,e),w(se.$$.fragment,e),w(pe.$$.fragment,e),nt=!0)},o(e){T(f.$$.fragment,e),T(h.$$.fragment,e),T(U.$$.fragment,e),T(I.$$.fragment,e),T(G.$$.fragment,e),T(E.$$.fragment,e),T(R.$$.fragment,e),T(Y.$$.fragment,e),T(P.$$.fragment,e),T(ee.$$.fragment,e),T(se.$$.fragment,e),T(pe.$$.fragment,e),nt=!1},d(e){e&&(l(ce),l(re),l(ye),l(me),l(de),l(we),l(b),l(Te),l(je),l(C),l(Je),l(v),l(fe),l(g),l(he),l(k),l(Ue),l($),l(be),l(A),l(Ie),l(x),l(Ce),l(ve),l(q),l(ge),l(B),l(ke),l(_),l($e),l(Z),l(Ae),l(H),l(xe),l(Ge),l(L),l(qe),l(u),l(Be),l(W),l(_e),l(Ze),l(Q),l(He),l(S),l(Ee),l(V),l(Le),l(X),l(We),l(N),l(Re),l(Qe),l(M),l(Se),l(Ve),l(z),l(Xe),l(F),l(Ne),l(D),l(Ye),l(K),l(Pe),l(O),l(ze),l(Fe),l(te),l(De),l(le),l(Ke),l(Oe),l(ae),l(et),l(c),l(tt),l(ne),l(lt),l(ie),l(st),l(at),l(ue)),l(J),j(f,e),j(h,e),j(U,e),j(I,e),j(G,e),j(E,e),j(R,e),j(Y,e),j(P,e),j(ee,e),j(se,e),j(pe,e)}}}const Ot='{"title":"Понимание класса Interface","local":"understanding-the-interface-class","sections":[{"title":"Как создать Interface","local":"how-to-create-an-interface","sections":[],"depth":2},{"title":"Простой пример со звуком","local":"a-simple-example-with-audio","sections":[],"depth":2},{"title":"Обработка нескольких входов и выходов","local":"handling-multiple-inputs-and-outputs","sections":[{"title":"Метод launch()","local":"the-launch-method","sections":[],"depth":3}],"depth":2},{"title":"✏️ Давайте применим это!","local":"lets-apply-it","sections":[],"depth":2}],"depth":1}';function el(ot){return Vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class il extends Xt{constructor(J){super(),Nt(this,J,el,Kt,Qt,{})}}export{il as component};
