# Тест в конце главы[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={3}
    classNames="absolute z-10 right-0 top-0"
/>

Тест по результатам изучения главы 3. 

### Датасет `emotion` содержит сообщения из Твиттера, каждое сообщение помечено какой-либо эмоцией. Найдите его на [Hub](https://huggingface.co/datasets) и изучить карточку датасета. Какая из этих эмоцией не является базовой?

<Question
	choices={[
		{
			text: "Joy",
			explain: "Попробуйте еще раз, этот класс присутствует в датасете!"
		},
		{
			text: "Love",
			explain: "Попробуйте еще раз, этот класс присутствует в датасете!"
		},
		{
			text: "Confusion",
			explain: "Правильно! Замешательство не является одним из 6 базовых классов датасета.",
            correct: true
		},
        {
			text: "Surprise",
			explain: "Сюрприз! Попробуйте другой вариант!"
		}
	]}
/>

### 2. Найдите датасет `ar_sarcasm` в [Hub](https://huggingface.co/datasets). Какую задачу можно решить с использованием этого датасета?

<Question
	choices={[
		{
			text: "Sentiment classification / Классификация тональности",
			explain: "Правильно! Поблагодарите за это тэги. ",
            correct: true
		},
		{
			text: "Machine translation / Машинный перевод",
			explain: "Нет, изучите еще раз <a href='https://huggingface.co/datasets/ar_sarcasm'>карточку</a> датасета!"
		},
		{
			text: "Named entity recognition / Распознавание именованных сущностей",
			explain: "Нет, изучите еще раз <a href='https://huggingface.co/datasets/ar_sarcasm'>карточку</a> датасета!"
		},
        {
			text: "Question answering / Ответы на вопросы",
			explain: "Увы! Неправильный ответ. "
		}
	]}
/>

### 3. В каком формате модель BERT ожидает на вход пару предложений?

<Question
	choices={[
		{
			text: "Токены_предложения_1 [SEP] Токены_предложения_2",
			explain: "Токен <code>[SEP]</code> – специальный токен для разделения двух предложений, однако этого недостаточно."
		},
		{
			text: "[CLS] Токены_предложения_1 Токены_предложения_2",
			explain: "Токен <code>[CLS]</code> – специальный токен, обозначающий начало последовательнсти, однако этого недостаточно."
		},
		{
			text: "[CLS] Токены_предложения_1 [SEP] Токены_предложения_2 [SEP]",
			explain: "Правильно!",
            correct: true
		},
        {
			text: "[CLS] Токены_предложения_1 [SEP] Токены_предложения_2",
			explain: "Токен <code>[CLS]</code> – специальный токен, обозначающий начало последовательнсти,  Токен <code>[SEP]</code> – специальный токен для разделения двух предложений. Но это не всё!"
		}
	]}
/>

{#if fw === 'pt'}
### 4. Какие преимущества есть у метода `Dataset.map()?`

<Question
	choices={[
		{
			text: "Результаты функции кэшируются, поэтому повторное выполнение кода не займет много времени.",
			explain: "Это действительно одно из преимуществ этого метода! Впрочем, не единственное...",
            correct: true
		},
		{
			text: "Можно применить мультипроцессорную обработку – это быстрее, чем применять функцию к каждому элементу выборки.",
			explain: "Это преимущество данного метода, но не единственное.",
            correct: true
		},
		{
			text: "Он не загружает весь набор данных в память, сохраняя результаты сразу после обработки одного элемента.",
			explain: "Это одно из преимуществ этого метода. Хотя есть и другие!",
            correct: true
		},
	]}
/>

### 5. Что такое dynamic padding?

<Question
	choices={[
		{
			text: "Дополнение нулями каждой входной последовательности до максимальной длины, содержащейся в датасете.",
			explain: "Подразумевает дополнение при создании батча, но не до максимальной длины во всем датасете."
		},
		{
			text: "Дополнение нулями при создании батча до максимальной длины предложения, содержашегося в батче.",
			explain: "Правильно! \"Динамическим\" пэддинг становится в момент анализа каждого элемента батча. Все батчи могут иметь разную длину элементов.",
            correct: true
		},
		{
			text: "Такое дополнение, при котором длина каждого предложения равна длине предыдущего предложения.",
			explain: "Неправильно. Хотя бы потому, что мы перемешиваем датасет во время обучения."
		},
	]}
/>

### 6. Какова цель функции сопоставления (collate function)?

<Question
	choices={[
		{
			text: "Она проверяет, что все предложения в датасете одинаковой длины.",
			explain: "Функция сопоставления используется для обработки отдельных батчей, а не всего датасета. Кроме того, мы говорим об общих collate-функциях, а не конкретно о <code>DataCollatorWithPadding</code>."
		},
		{
			text: "Она соединяет вместе все элементы батча.",
			explain: "Верно! Вы можете передать функцию сопоставления в качестве аргумента для <code>DataLoader</code>. Мы использовали функцию <code>DataCollatorWithPadding</code>, которая дополняет все элементы в батче до одинаковой длины.",
            correct: true
		},
		{
			text: "Она обрабатывает весь датасет. ",
			explain: "Тогда она называлась быть функцией препроцессинга, а не функцией сопоставления."
		},
        {
			text: "Она обрезает предложения в датасете.",
			explain: "Collate-функция используется для одного батча, а не всего датасета. Если вам необходимо обрезать датасет, вы можете использовать аргумент <code>truncate</code> в <code>tokenizer</code>."
		}
	]}
/>

### 7. Что происходит, когда вы создаете экземпляр одного из классов `AutoModelForXxx` с предварительно обученной языковой моделью (например, `bert-base-uncased`), которая соответствует задаче, отличной от той, для которой она была обучена? 

<Question
	choices={[
		{
			text: "Ничего, но будет выведено предупреждение.",
			explain: "Предупреждение действительно появится, но это не всё!"
		},
		{
			text: "Последний слой модели будет заменён на слой, подходящий для текущей задачи.",
			explain: "Правильно. Например, когда мы используем <code>AutoModelForSequenceClassification</code> с <code>bert-base-uncased</code> чекпоинтом, распечатывается предупреждение при инициализации модели. Предобученная «голова» модели не используется для классификации предложений, так что она заменяется другим слоем со случайно инициализированными весами.",
            correct: true
		},
		{
			text: "Последний слой модели игнорируется.",
			explain: "Должно произойти что-то еще! Попробуй еще раз!"
		},
        {
			text: "Ничего, модель по-прежнему можно будет настроить на решение другой задачи.",
			explain: "Последний слой модели был обучен решать другую задачу, значит с ним должно что-то произойти!"
		}
	]}
/>

### 8. Зачем нужен `TrainingArguments`?

<Question
	choices={[
		{
			text: "Он содержит все гиперпараметры, используемые для обучения и оценки с помощью <code>Trainer</code>",
			explain: "Верно!",
            correct: true
		},
		{
			text: "Задает размер модели.",
			explain: "Размер модели определяется ее структурой, а не классом <code>TrainingArguments</code>."
		},
		{
			text: "Содержит гиперпараметры для этапа валидации модели.",
			explain: "В примере мы задавали, где будут сохраняться модель и её веса. Попробуй еще раз!"
		},
        {
			text: "Он содержит гиперпараметры этапа обучения.",
			explain: "В примере мы использовали <code>evaluation_strategy</code>, что также влияет на валидацию. Попробуй еще раз!"
		}
	]}
/>

### 9. Зачем нужна библиотека 🤗 Accelerate?

<Question
	choices={[
		{
			text: "Предоставляет доступ к более быстрым моделям.",
			explain: "Нет, 🤗 Accelerate не предоставляет доступа к каким-либо ни было моделям."
		},
		{
			text: "Предоставляет высокоуровневый API и появляется возможность не реализовывать собственный цикл обучения.",
			explain: "Это мы делаем с помощью <code>Trainer</code>, а не 🤗 Accelerate. Попробуй еще раз!"
		},
		{
			text: "Позволяет исполнить наш цикл обучения на распределенных системах.",
			explain: "Праивльно! С помощью 🤗 Accelerate обучающий цикл будет исполняться на нескольких GPU или TPU.",
            correct: true
		},
        {
			text: "Предоставляет больше оптимизационных функций.",
			explain: "Нет, 🤗 Accelerate не предоставляет оптимизационных функций."
		}
	]}
/>

{:else}
### 4. Что происходит, когда вы создаете экземпляр одного из классов `TFAutoModelForXxx` с предварительно обученной языковой моделью (например, `bert-base-uncased`), которая соответствует задаче, отличной от той, для которой она была обучена? 

<Question
	choices={[
		{
			text: "Ничего, но будет выведено предупреждение.",
			explain: "Предупреждение действительно появится, но это не всё!"
		},
		{
			text: "Последний слой модели будет заменён на слой, подходящий для текущей задачи.",
			explain: "Правильно. Например, когда мы используем <code>AutoModelForSequenceClassification</code> с <code>bert-base-uncased</code> чекпоинтом, распечатывается предупреждение при инициализации модели. Предобученная «голова» модели не используется для классификации предложений, так что она заменяется другим слоем со случайно инициализированными весами.",
            correct: true
		},
		{
			text: "Последний слой модели игнорируется.",
			explain: "Должно произойти что-то еще! Попробуй еще раз!"
		},
        {
			text: "Ничего, модель по-прежнему можно будет настроить на решение другой задачи.",
			explain: "Последний слой модели был обучен решать другую задачу, значит с ним должно что-то произойти!"
		}
	]}
/>

### 5. TensorFlow-модели из `transformers` уже можно рассматривать как Keras-модели. Какие преимущества это дает?

<Question
	choices={[
		{
			text: "Модели будут работать на TPU «из коробки».",
			explain: "Почти! Необходимо внести ряд дополнительных изменений, например: следует запустить все с помощью <code>TPUStrategy</code> (включая инициализацию модели)."
		},
		{
			text: "Вы сможете испольовать существующие методы, такие как <code>compile()</code>, <code>fit()</code> и <code>predict()</code>.",
			explain: "Верно! Данные у вас уже есть, дело осталось за малым – обучить модель. ",
            correct: true
		},
		{
			text: "Вы сможете изучить и Keras, и transformers.",
			explain: "Верно! Но ответ все же немного другой :)",
			correct: true
		},
        {
			text: "Вы можете просто вычислить метрики, связанные с датасетом.",
			explain: "Keras помогает в обучении и валидации модели, а не с вычислением метрик."
		}
	]}
/>

### 6. Как мы можем задать собственную метрику?

<Question
	choices={[
		{
			text: "Наследуя <code>tf.keras.metrics.Metric</code>.",
			explain: "Великолепно!",
			correct: true
		},
		{
			text: "С использованием функционального API Keras.",
			explain: "Try again!"
		},
		{
			text: "С использованием вызываемого модуля <code>metric_fn(y_true, y_pred)</code>.",
			explain: "Верно!",
			correct: true
		},
        {
			text: "Загуглив её!",
			explain: "Это не тот ответ, который мы ожидаем, однако это должно помочь вам!",
			correct: true
		}
	]}
/>

{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ru/chapter3/6.mdx" />