# పక్షపాతం మరియు పరిమితులు[[bias-and-limitations]]

<CourseFloatingBanner
  chapter={1}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {
      label: "Google Colab",
      value:
        "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter1/section8.ipynb",
    },
    {
      label: "Aws Studio",
      value:
        "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter1/section8.ipynb",
    },
  ]}
/>

మీ ఉద్దేశ్యం ఒక ప్రీట్రైన్డ్ మోడల్ లేదా ఫైన్-ట్యూన్డ్ వెర్షన్‌ను ఉత్పత్తిలో ఉపయోగించాలనుకుంటే, దయచేసి ఈ మోడల్స్ శక్తివంతమైన సాధనాలు అయినప్పటికీ, వాటికి పరిమితులు ఉన్నాయని గుర్తుంచుకోండి. వీటిలో అతిపెద్దది ఏమిటంటే, పెద్ద మొత్తంలో డేటాపై ప్రీట్రైనింగ్‌ను ప్రారంభించడానికి, పరిశోధకులు తరచుగా వారు కనుగొనగలిగిన అన్ని కంటెంట్‌ను స్క్రాప్ చేస్తారు, ఇంటర్నెట్‌లో అందుబాటులో ఉన్న వాటిలో ఉత్తమమైనవి మరియు చెత్తైనవి రెండింటినీ తీసుకుంటారు.

త్వరగా వివరించడానికి, BERT మోడల్‌తో `fill-mask` పైప్‌లైన్ ఉదాహరణకు తిరిగి వెళ్దాం:

```python
from transformers import pipeline

unmasker = pipeline("fill-mask", model="bert-base-uncased")
result = unmasker("This man works as a [MASK].")
print([r["token_str"] for r in result])

result = unmasker("This woman works as a [MASK].")
print([r["token_str"] for r in result])
```

```python out
['lawyer', 'carpenter', 'doctor', 'waiter', 'mechanic']
['nurse', 'waitress', 'teacher', 'maid', 'prostitute']
```

ఈ రెండు వాక్యాలలో తప్పిపోయిన పదాన్ని పూరించమని అడిగినప్పుడు, మోడల్ ఒకే ఒక లింగ-రహిత సమాధానం (waiter/waitress) మాత్రమే ఇస్తుంది. మిగిలినవి సాధారణంగా ఒక నిర్దిష్ట లింగంతో ముడిపడి ఉన్న వృత్తులు -- మరియు అవును, "స్త్రీ" మరియు "పని"తో మోడల్ అనుబంధించే టాప్ 5 అవకాశాలలో prostitute చేరింది. BERT ఇంటర్నెట్ నుండి డేటాను స్క్రాప్ చేయడం ద్వారా నిర్మించబడని అరుదైన Transformer మోడల్స్‌లో ఒకటి అయినప్పటికీ ఇది జరుగుతుంది, బదులుగా తటస్థ డేటాను ఉపయోగించి (ఇది [English Wikipedia](https://huggingface.co/datasets/wikipedia) మరియు [BookCorpus](https://huggingface.co/datasets/bookcorpus) డేటాసెట్‌లపై శిక్షణ పొందింది).

మీరు ఈ సాధనాలను ఉపయోగించినప్పుడు, మీరు ఉపయోగిస్తున్న అసలు మోడల్ చాలా సులభంగా సెక్సిస్ట్, జాతి వివక్షతో కూడిన లేదా హోమోఫోబిక్ కంటెంట్‌ను రూపొందించగలదని మీరు గుర్తుంచుకోవాలి. మీ డేటాపై మోడల్‌ను ఫైన్-ట్యూన్ చేయడం ఈ అంతర్గత పక్షపాతాన్ని తొలగించదు.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/te/chapter1/9.mdx" />