# Giriş

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

## 🤗 Kursuna Hoşgeldiniz!

<Youtube id="00GKzGyWFEs" />

Bu kurs size [Hugging Face](https://huggingface.co/) ekosistemindeki kütüphaneleri — [🤗 Transformers](https://github.com/huggingface/transformers), [🤗 Datasets](https://github.com/huggingface/datasets), [🤗 Tokenizers](https://github.com/huggingface/tokenizers), ve [🤗 Accelerate](https://github.com/huggingface/accelerate) — ayrıca tabiki de [Hugging Face Hub](https://huggingface.co/models) kullanarak Doğal Dil İşleme'yi (NLP) öğretecektir. Kurs tamamen ücretsiz ve reklam bulunmuyor.

## Beklentiniz ne olmalı?

Burada kursa genel bakış bulunmaktadır: 

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary.svg" alt="Brief overview of the chapters of the course.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary-dark.svg" alt="Brief overview of the chapters of the course.">
</div>

- 1'den 4'üncü bölüme kadar olan kısımda 🤗 Transformers kütüphanesinin ana konseptlerine giriş yapacağız. Kursun bu bölümünün sonunda, Transformer modellerinin nasıl çalıştığını öğrenecek, ve [Hugging Face Hub](https://huggingface.co/models) üzerinden bir modeli nasil kullanabileceğinizi, verisetine ince ayar (fine-tune) yapmayı, ve sonuçlarınızı Hub üzerinde nasıl paylaşacağınızı bileceksiniz!
- Bölüm 5 ila 8, klasik NLP görevlerine dalmadan önce 🤗 Datasets ve 🤗 Tokenizers'in temellerini öğretiyor. Bu bölümün sonunda, en yaygın NLP problemlerini kendiniz çözebileceksiniz.
- 9'dan 12'ye kadar olan bölümler NLP'nin ötesine geçer ve Transformer modellerinin konuşma işleme ve bilgisayarlı görü alanlarındaki problemleri nasıl çözeceğini ele alır. Süreç boyunca, model demolarınızı nasıl oluşturup paylaşacağınızı ve bunları üretim ortamlarında nasıl optimize edeceğinizi öğreneceksiniz. Bu bölümün sonunda, 🤗 Transformers'i (neredeyse) herhangi bir makine öğrenmesi problemine uygulamaya hazır olacaksınız!

Bu kurs:

* Python hakkında iyi düzeyde bilgi gerektirir.
* Giriş düzeyinde derin öğrenme derslerinden sonra alınırsa daha iyi olur. Örneğin: [fast.ai](https://www.fast.ai/) [Practical Deep Learning for Coders kursu](https://course.fast.ai/) veya [DeepLearning.AI](https://www.deeplearning.ai/) tarafından verilen herhangi program.
* [PyTorch](https://pytorch.org/) veya [TensorFlow](https://www.tensorflow.org/) ile herhangi bir ön bilgi beklenmiyor, buna rağmen bunlardan birisine aşinalik yardımcı olur.

Kursu bitirdikten sonra, DeepLearning.AI [Doğal Dil İşleme Uzmanlık](https://www.coursera.org/specializations/natural-language-processing?utm_source=deeplearning-ai&utm_medium=institutions&utm_campaign=20211011-nlp-2-hugging_face-page-nlp-refresh) naive Bayes ve LSTM gibi bilmeye değer geleneksel NLP modellerinin bulunduğu seriyi izlemenizi tavsiye ediyoruz. 


## Biz Kimiz?

Eğitmenler hakkında:

**Matthew Carrigan** Hugging Face'de Makine Öğrenmesi Mühendisi. Dublin, İrlanda'da yaşıyor ve daha önce Parse.ly'de ML Engineer olarak çalıştı ve onunda öncesinde Doktora sonrası Araştırmacı olarak Trinity College Dublin'de idi. Mevcut AI mimarilerini ölçeklendirerek AGI'a ulaşacağımıza inanmıyor, ancak ne olursa olsun robot ölümsüzlüğü için büyük umutları var. 

**Lysandre Debut** Hugging Face'de Makine Öğrenmesi Mühendisi  ve 🤗 Transformers kütüphanesi üzerine erken gelişim aşamasından beri çalışıyor. Hedefi çok basit bir API geliştirerek NLP'yi herkes için ulaşılabilir kılmak.

**Sylvain Guggeat** Hugging Face'de Araştırma Mühendisi ve 🤗 Transformers kütüphanesinin proje yürütücülerinden biri. Öncesinde Araştırma Bilimci olarak fast.ai'da çalıştı, ve _[Deep Learning for Coders with fastai and PyTorch](https://learning.oreilly.com/library/view/deep-learning-for/9781492045519/)_ kitabını Jeremy Howard ile birlikte yazdı. Sylvain'in araştırmalarının ana odağı modellerin sınırlı kaynaklarda daha hızlı eğitilmesine izin veren teknikleri tasarlayıp geliştirerek derin öğrenmeyi herkes için ulaşılabilir kılmak.

**Merve Noyan** Hugging Face'de Developer Advocate, araçlar geliştirerek ve bu araçlar etrafında içerik üreterek makine öğrenmesini herkes için demokratikleştirme üzerine çalışıyor.

**Lucile Saulnier** Hugging Face'de Makine Öğrenmesi Mühendisi, açık kaynak araçlarının geliştirilmesi ve desteklenmesi üzerine uğraşıyor. Ayrıca Doğal Dil İşleme içinde Collaborative Training ve BigScience gibi birçok araştırma projesine dahil.

**Lewis Tunstall** Hugging Face'de Makine Öğrenmesi Mühendisi, açık kaynak araçları geliştirmeye ve bunlari daha geniş bir topluluk için ulaşılabilir hale getirmeye odaklanmış. Ayrıca yakında gelecek olan [Transformers üzerine O’Reilly kitabının](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/) yazarlarından biri.

**Leandro von Werra**  Hugging Face'de Açık-Kaynak takımında Makine Öğrenmesi Mühendisi ve ayrica yakında gelecek olan [Transformers üzerine olan O’Reilly kitabinin](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/) yazarlarından biri. Tüm Makine Öğrenmesi stack'inde çalişarak NLP projelerini üretime getiren birkaç yıllık endüstri deneyimine sahiptir.


Başlamaya hazır mısın? Bu bölümde, şunları öğreneceksin:
* Metin oluşturma ve sınıflandırma gibi NLP görevlerini çözmek için `pipeline ()` fonksiyonu nasıl kullanılacağı?
* Transformer mimarisi
* Encoder, Decoder, ve Encoder-Decoder mimarilerini nasil ayırt edileceği ve kullanım alanlari


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/tr/chapter1/1.mdx" />