# Xây dựng các thẻ mô hình

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

Thẻ mô hình là một tệp được cho là quan trọng như mô hình và tệp tokenizer trong kho lưu trữ mô hình. Đây là định nghĩa chủ đạo của mô hình, đảm bảo khả năng tái sử dụng của các thành viên trong cộng đồng và khả năng tái tạo kết quả, đồng thời cung cấp một nền tảng mà các thành viên khác có thể xây dựng các tác phẩm của họ.

Việc ghi lại quá trình huấn luyện và đánh giá giúp những người khác hiểu những gì mong đợi ở một mô hình - và cung cấp đầy đủ thông tin liên quan đến dữ liệu đã được sử dụng và quá trình tiền xử lý và hậu xử lý đã được thực hiện đảm bảo rằng các hạn chế, thành kiến ​​và bối cảnh trong đó mô hình đang và không hữu ích có thể được xác định và hiểu.

Vì vậy, tạo một thẻ mô hình xác định rõ ràng mô hình của bạn là một bước rất quan trọng. Ở đây, chúng tôi cung cấp một số mẹo sẽ giúp bạn điều này. Việc tạo thẻ mô hình được thực hiện thông qua tệp _README.md_ mà bạn đã thấy trước đó, đây là một tệp Markdown.

Khái niệm "thẻ mô hình" bắt nguồn từ một hướng nghiên cứu của Google, lần đầu tiên được chia sẻ trong bài báo ["Model Cards for Model Reporting"](https://arxiv.org/abs/1810.03993) của Margaret Mitchell và cộng sự. Nhiều thông tin ở đây dựa trên bài báo đó và chúng tôi khuyên bạn nên xem qua để hiểu tại sao thẻ mô hình lại quan trọng như vậy trong một thế giới coi trọng khả năng tái tạo, khả năng tái sử dụng và tính công bằng.

Thẻ mô hình thường bắt đầu với tổng quan rất ngắn gọn, cấp cao về mục đích của mô hình, tiếp theo là các chi tiết bổ sung trong các phần sau:

- Mô tả về mô hình
- Mục đích sử dụng & giới hạn
- Cách sử dụng
- Hạn chế và sai lệch
- Dữ liệu huấn luyện
- Quy trình huấn luyện
- Những kết quả đánh giá

Chúng ta hãy xem mỗi phần này nên chứa những gì.

### Mô tả về mô hình

Mô tả về mô hình cung cấp các chi tiết cơ bản về mô hình. Điều này bao gồm kiến ​​trúc, phiên bản, nếu nó được giới thiệu trong một bài báo, nếu có sẵn bản triển khai gốc, tác giả và thông tin chung về mô hình. Bất kỳ bản quyền nào cũng nên được ghi nhận ở đây. Thông tin chung về quy trình huấn luyện, các thông số và tuyên bố từ chối trách nhiệm quan trọng cũng có thể được đề cập trong phần này.

### Mục đích sử dụng & giới hạn

Ở đây, bạn mô tả các trường hợp sử dụng mà mô hình, bao gồm các ngôn ngữ, trường và mảng chuyên môn mà nó có thể được áp dụng. Phần này của thẻ mô hình cũng có thể ghi lại các khu vực được biết là nằm ngoài phạm vi của mô hình hoặc nơi nó có khả năng hoạt động dưới mức tối ưu.

### Cách sử dụng

Phần này nên bao gồm một số ví dụ về cách sử dụng mô hình. Điều này có thể giới thiệu cách sử dụng hàm  `pipeline()`, cách sử dụng mô hình và tokenizer, và bất kỳ đoạn mã nào khác mà bạn nghĩ có thể hữu ích.

### Dữ liệu huấn luyện

Phần này phải chỉ ra (các) tập dữ liệu nào mà mô hình đã được huấn luyện. Một mô tả ngắn gọn về (các) tập dữ liệu cũng được hoan nghênh.

### Quy trình huấn luyện

Trong phần này, bạn nên mô tả tất cả các khía cạnh liên quan của việc huấn luyện mà hữu ích từ góc độ khả năng tái tạo. Điều này bao gồm bất kỳ quá trình tiền xử lý và hậu xử lý nào đã được thực hiện trên dữ liệu, cũng như các chi tiết như số epoch mà mô hình được huấn luyện, kích thước lô, tốc độ học, v.v.

### Biến và chỉ số thước đo

Ở đây, bạn nên mô tả các số liệu bạn sử dụng để đánh giá, và các yếu tố khác nhau mà bạn đang đo lường. Đề cập đến (các) chỉ số nào đã được sử dụng, tập dữ liệu nào được sử dụng và tập dữ liệu được phân chia như thế nào, giúp dễ dàng so sánh hiệu suất của mô hình của bạn so với hiệu suất của các mô hình khác. Những điều này phải được thông báo bởi các phần trước, chẳng hạn như đối tượng người dùng và các trường hợp sử dụng.

### Những kết quả đánh giá

Cuối cùng, cung cấp chỉ báo về mức độ hoạt động của mô hình trên tập dữ liệu đánh giá. Nếu mô hình sử dụng ngưỡng quyết định, hãy cung cấp ngưỡng quyết định được sử dụng trong đánh giá hoặc cung cấp thông tin chi tiết về đánh giá ở các ngưỡng khác nhau phục vụ cho các mục đích sử dụng.

## Ví dụ

Hãy xem phần sau để biết một vài ví dụ về thẻ mô hình được chế tạo tốt:

- [`bert-base-cased`](https://huggingface.co/bert-base-cased)
- [`gpt2`](https://huggingface.co/gpt2)
- [`distilbert`](https://huggingface.co/distilbert-base-uncased)

Tham khảo thêm các ví dụ từ các tổ chức và công ty khác nhau [tại đây](https://github.com/huggingface/model_card/blob/master/examples.md).

## Lưu ý

Thẻ mô hình không phải là ràng buộc khi xuất bản mô hình và bạn không cần phải bao gồm tất cả các phần được mô tả ở trên khi tạo thẻ mô hình. Tuy nhiên, tài liệu rõ ràng về mô hình có thể mang lại lợi ích cho người dùng trong tương lai, vì vậy chúng tôi khuyên bạn nên điền vào nhiều phần nhất có thể theo khả năng và kiến ​​thức của mình.

## Siêu dữ liệu thẻ mô hình

Nếu bạn đã khám phá một chút về Hugging Face Hub, bạn sẽ thấy rằng một số kiểu mô hình thuộc một số nhóm nhất định: bạn có thể lọc chúng theo tác vụ, ngôn ngữ, thư viện, v.v. Các nhóm mà một mô hình thuộc về được xác định theo siêu dữ liệu bạn thêm vào tiêu đề thẻ mô hình.

Ví dụ: nếu bạn xem [thẻ mô hình camembert-base`](https://huggingface.co/camembert-base/blob/main/README.md), bạn sẽ thấy các dòng sau trong tiêu đề thẻ mô hình:

```
---
language: fr
license: mit
datasets:
- oscar
---
```

Siêu dữ liệu này được phân tích bởi Hugging Face Hub, sau đó xác định mô hình này là cho tiếng Pháp, có giấy phép MIT, được huấn luyện trên tập dữ liệu Oscar.

[Thông số kỹ thuật thẻ mô hình bản đầy đủ](https://github.com/huggingface/hub-docs/blame/main/modelcard.md) cho phép chỉ định ngôn ngữ, giấy phép, thẻ, bộ dữ liệu, số liệu cũng như kết quả đánh giá mô hình thu được khi huấn luyện.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/vi/chapter4/4.mdx" />