# Xây dựng bản demo đầu tiên của bạn

<DocNotebookDropdown
  classNames="absolute z-10 right-0 top-0"
  options={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/vi/chapter9/section2.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/vi/chapter9/section2.ipynb"},
]} />

Hãy bắt đầu bằng cách cài đặt Gradio! Vì nó là một gói Python, chỉ cần chạy:

`$ pip install gradio `

Bạn có thể chạy Gradio ở bất cứ đâu, từ IDE Python yêu thích của bạn, đến notebook Jupyter hoặc thậm chí trong Google Colab 🤯!
Vì vậy, hãy cài đặt Gradio ở bất cứ đâu bạn chạy Python!

Hãy bắt đầu với một ví dụ “Hello World” đơn giản để làm quen với cú pháp Gradio:

```py
import gradio as gr


def greet(name):
    return "Hello " + name


demo = gr.Interface(fn=greet, inputs="text", outputs="text")

demo.launch()
```

Hãy xem qua đoạn mã trên:

- Đầu tiên, chúng ta định nghĩa một hàm có tên là `welcome()`. Trong trường hợp này, nó là một hàm đơn giản có thêm "Hello" trước tên của bạn, nhưng nó có thể là *bất kỳ* hàm Python nào nói chung. Ví dụ: trong các ứng dụng học máy, hàm này sẽ *gọi một mô hình để đưa ra dự đoán* trên một đầu vào và trả lại đầu ra.
- Sau đó, chúng ta tạo một Giao diện Gradio với ba tham số `fn`, `inputs`, và `outputs`. Các tham số này xác định hàm dự đoán, cũng như _kiểu_ của các thành phần đầu vào và đầu ra mà ta muốn. Trong trường hợp của mình, cả hai thành phần đều là các hộp văn bản đơn giản.
- Sau đó, chúng ta gọi phương thức `launch()` trên `Interface` đã tạo.

Nếu bạn chạy đoạn mã này, giao diện bên dưới sẽ tự động xuất hiện trong notebook Jupyter/Colab hoặc bật trong trình duyệt trên **[http://localhost:7860](http://localhost:7860/)** nếu đang chạy từ một tập lệnh.

<iframe src="https://course-demos-hello-world.hf.space" frameBorder="0" height="250" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Hãy thử sử dụng GUI này ngay bây giờ với tên của chính bạn hoặc một số đầu vào khác!

Bạn sẽ nhận thấy rằng trong GUI này, Gradio tự động suy ra tên của tham số đầu vào (`name`) và lấy nó làm nhãn trên đầu hộp văn bản. Điều gì xảy ra nếu bạn muốn thay đổi điều đó? Hoặc nếu bạn muốn tùy chỉnh hộp văn bản theo một số cách khác? Trong trường hợp đó, bạn có thể khởi tạo một đối tượng lớp đại diện cho thành phần đầu vào.

```py
import gradio as gr


def greet(name):
    return "Hello " + name


# Chúng tôi khởi tạo lớp Textbox
textbox = gr.Textbox(label="Type your name here:", placeholder="John Doe", lines=2)

gr.Interface(fn=greet, inputs=textbox, outputs="text").launch()
```

<iframe src="https://course-demos-hello-world-custom.hf.space" frameBorder="0" height="300" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Ở đây, chúng ta đã tạo một hộp văn bản đầu vào với nhãn, trình giữ chỗ và một số dòng. Bạn có thể làm tương tự đối với hộp văn bản đầu ra, nhưng chúng ta sẽ để lại điều đó ngay bây giờ.

Chúng ta thấy rằng chỉ với một vài dòng mã, Gradio cho phép bạn tạo một giao diện đơn giản xung quanh bất kỳ chức năng nào
với bất kỳ loại đầu vào hoặc đầu ra nào. Trong phần này, chúng ta đã bắt đầu với hộp văn bản đơn giản, nhưng trong các phần tiếp theo, chúng ta sẽ đề cập đến các loại đầu vào và đầu ra khác. Bây giờ chúng ta hãy xem bao gồm một số NLP trong một ứng dụng Gradio thì sao.

## 🤖 Bao gồm các dự đoán mô hình

Bây giờ chúng ta hãy xây dựng một giao diện đơn giản cho phép bạn demo mô hình **tạo văn bản** như GPT-2.

Chúng ta sẽ tải mô hình của mình bằng cách sử dụng hàm `pipeline()` từ 🤗 Transformers.
Nếu bạn cần cập nhật nhanh, bạn có thể quay lại [phần đó trong Chương 1](/course/chapter1/3#text-generation)

Đầu tiên, chúng ta định nghĩa một hàm dự đoán nhận lời nhắc văn bản và trả về văn bản đã hoàn thiện:

```py
from transformers import pipeline

model = pipeline("text-generation")


def predict(prompt):
    completion = model(prompt)[0]["generated_text"]
    return completion
```

Hàm này hoàn thành các lời nhắc mà bạn cung cấp và bạn có thể chạy nó với lời nhắc đầu vào của riêng mình để xem nó hoạt động như thế nào. Đây là một ví dụ (bạn có thể nhận được một kết quả khác):

```
predict("My favorite programming language is")
```

```
>> My favorite programming language is Haskell. I really enjoyed the Haskell language, but it doesn't have all the features that can be applied to any other language. For example, all it does is compile to a byte array.
```

Bây giờ chúng ta có một hàm để tạo các dự đoán, chúng ta có thể tạo và khởi chạy một `Interface` theo cách giống như cách chúng ta đã làm trước đó:

```py
import gradio as gr

gr.Interface(fn=predict, inputs="text", outputs="text").launch()
```

Nó đó! Bây giờ bạn có thể sử dụng giao diện này để tạo văn bản bằng mô hình GPT-2 như hình bên dưới 🤯.

<iframe src="https://course-demos-gpt-2.hf.space" frameBorder="0" height="300" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Hãy tiếp tục đọc để biết cách tạo các loại demo khác với Gradio!


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/vi/chapter9/2.mdx" />