# Tích hợp với Hugging Face Hub

<DocNotebookDropdown
  classNames="absolute z-10 right-0 top-0"
  options={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/vi/chapter9/section5.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/vi/chapter9/section5.ipynb"},
]} />

Để làm cho cuộc sống của bạn trở nên dễ dàng hơn, Gradio tích hợp trực tiếp với Hugging Face Hub và Hugging Face Spaces. Bạn có thể tải các bản demo từ Hub và Spaces chỉ với *một dòng mã*.

### Tải mô hình từ Hugging Face Hub

Để bắt đầu, hãy chọn một trong số hàng nghìn mô hình Hugging Face được cung cấp thông qua Hub, như được mô tả trong [Chương 4](/course/chapter4/2).

Sử dụng phương thức `Interface.load()` đặc biệt, bạn truyền `"model/"` (hoặc, tương đương, `"huggingface/"`) theo sau là tên mô hình. Ví dụ: đây là mã để tạo bản demo cho [GPT-J](https://huggingface.co/EleutherAI/gpt-j-6B), một mô hình ngôn ngữ lớn, hãy thêm một số đầu vào mẫu:

```py
import gradio as gr

title = "GPT-J-6B"
description = "Gradio Demo for GPT-J 6B, a transformer model trained using Ben Wang's Mesh Transformer JAX. 'GPT-J' refers to the class of model, while '6B' represents the number of trainable parameters. To use it, simply add your text, or click one of the examples to load them. Read more at the links below."
article = "<p style='text-align: center'><a href='https://github.com/kingoflolz/mesh-transformer-jax' target='_blank'>GPT-J-6B: A 6 Billion Parameter Autoregressive Language Model</a></p>"
examples = [
    ["The tower is 324 metres (1,063 ft) tall,"],
    ["The Moon's orbit around Earth has"],
    ["The smooth Borealis basin in the Northern Hemisphere covers 40%"],
]
gr.Interface.load(
    "huggingface/EleutherAI/gpt-j-6B",
    inputs=gr.Textbox(lines=5, label="Input Text"),
    title=title,
    description=description,
    article=article,
    examples=examples,
    enable_queue=True,
).launch()
```

Đoạn mã trên sẽ tạo ra giao diện bên dưới:

<iframe src="https://course-demos-gpt-j-6B.hf.space" frameBorder="0" height="750" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Tải mô hình theo cách này sử dụng [API luận suy](https://huggingface.co/inference-api) của Hugging Face, thay vì tải mô hình trong bộ nhớ. Điều này lý tưởng cho các mô hình lớn như GPT-J hoặc T0pp, những mô hình yêu cầu nhiều RAM.

### Tải từ Hugging Face Spaces

Để tải bất kỳ Space nào từ Hugging Face Hub và tạo lại nó cục bộ, bạn có thể truyền  `spaces/` vào `Interface`, theo sau là tên của Space.

Bạn có nhớ bản demo từ phần 1 xóa nền của hình ảnh không? Hãy tải nó từ Hugging Face Spaces:

```py
gr.Interface.load("spaces/abidlabs/remove-bg").launch()
```

<iframe src="https://course-demos-remove-bg-original.hf.space" frameBorder="0" height="650" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Một trong những điều thú vị khi tải các bản demo từ Hub hoặc Spaces là bạn tùy chỉnh chúng bằng cách ghi đè bất kỳ thông số nào. Ở đây, chúng ta thêm tiêu đề và làm cho tiêu đề đó hoạt động với webcam:

```py
gr.Interface.load(
    "spaces/abidlabs/remove-bg", inputs="webcam", title="Remove your webcam background!"
).launch()
```

<iframe src="https://course-demos-Remove-bg.hf.space" frameBorder="0" height="550" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Bây giờ chúng ta đã khám phá một số cách để tích hợp Gradio với Hugging Face Hub, hãy cùng xem xét một số tính năng nâng cao của lớp `Interface`. Đó là chủ đề của phần tiếp theo!


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/vi/chapter9/5.mdx" />