import{s as ot,o as Tt,n as Ps}from"../chunks/scheduler.cc52f4b9.js";import{S as ht,i as wt,e as U,s as a,c as M,h as xt,a as r,d as n,b as p,f as rt,g as y,j as o,k as ut,l as Ct,m as t,n as j,t as J,o as i,p as c}from"../chunks/index.9480bb2b.js";import{T as Ys}from"../chunks/Tip.f7b80743.js";import{C as gt,H as $n,E as mt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.009dc98d.js";import{Y as It}from"../chunks/Youtube.7b12d9e8.js";import{C as T}from"../chunks/CodeBlock.184aadb6.js";import{C as ft}from"../chunks/CourseFloatingBanner.6488bde3.js";function $t(x){let e,h="💡 本节深入介绍了 BPE，甚至展示了一个完整的实现。如果你只想大致了解 tokenization 算法，可以跳到最后。";return{c(){e=U("p"),e.textContent=h},l(u){e=r(u,"P",{"data-svelte-h":!0}),o(e)!=="svelte-1waktky"&&(e.textContent=h)},m(u,w){t(u,e,w)},p:Ps,d(u){u&&n(e)}}}function dt(x){let e,h="GPT-2 和 RoBERTa （这两者非常相似）的 tokenizer 有一个巧妙的方法来处理这个问题：他们不把单词看成是用 Unicode 字符编写的，而是用字节编写的。这样，基本词汇表的大小很小（256），但是能包含几乎所有你能想象的字符，而不会最终转换为未知 tokens 这个技巧被称为 <code>字节级（byte-level） BPE</code> 。";return{c(){e=U("p"),e.innerHTML=h},l(u){e=r(u,"P",{"data-svelte-h":!0}),o(e)!=="svelte-ec0vh8"&&(e.innerHTML=h)},m(u,w){t(u,e,w)},p:Ps,d(u){u&&n(e)}}}function kt(x){let e,h="✏️ <strong>现在轮到你了！</strong> 你认为下一个合并规则是什么？";return{c(){e=U("p"),e.innerHTML=h},l(u){e=r(u,"P",{"data-svelte-h":!0}),o(e)!=="svelte-1abbvo6"&&(e.innerHTML=h)},m(u,w){t(u,e,w)},p:Ps,d(u){u&&n(e)}}}function qt(x){let e,h="✏️ <strong>现在轮到你了！</strong> 你认为这个词 <code>&quot;unhug&quot;</code> 将如何被 tokenization？";return{c(){e=U("p"),e.innerHTML=h},l(u){e=r(u,"P",{"data-svelte-h":!0}),o(e)!=="svelte-18fkeee"&&(e.innerHTML=h)},m(u,w){t(u,e,w)},p:Ps,d(u){u&&n(e)}}}function Qt(x){let e,h="💡 在同一语料库上使用 <code>train_new_from_iterator()</code> 可能不会产生完全相同的词汇表。这是因为当有多个出现频率最高的对时，我们选择遇到的第一个，而 🤗 Tokenizers 库根据内部 ID 选择第一个。";return{c(){e=U("p"),e.innerHTML=h},l(u){e=r(u,"P",{"data-svelte-h":!0}),o(e)!=="svelte-x4k8ma"&&(e.innerHTML=h)},m(u,w){t(u,e,w)},p:Ps,d(u){u&&n(e)}}}function bt(x){let e,h="⚠️ 如果存在未知字符，我们的实现将抛出错误，因为我们没有做任何处理它们。GPT-2 实际上没有未知 tokens （使用字节级 BPE 时不可能得到未知字符），但这里的代码可能会出现这个错误，因为我们并未在初始词汇中包含所有可能的字节。BPE 的这一部分已超出了本节的范围，因此我们省略了一些细节。";return{c(){e=U("p"),e.textContent=h},l(u){e=r(u,"P",{"data-svelte-h":!0}),o(e)!=="svelte-ezw7bq"&&(e.textContent=h)},m(u,w){t(u,e,w)},p:Ps,d(u){u&&n(e)}}}function At(x){let e,h,u,w,d,Fs,k,Ls,q,Os,Q,dn="字节对编码（BPE）最初被开发为一种压缩文本的算法，然后在预训练 GPT 模型时被 OpenAI 用于 tokenization。许多 Transformer 模型都使用它，包括 GPT、GPT-2、RoBERTa、BART 和 DeBERTa。",sl,b,ll,C,nl,A,tl,B,kn="BPE 训练首先计算语料库中使用的唯一单词集合（在完成标准化和预分词步骤之后），然后取出用来编写这些词的所有符号来构建词汇表。举一个非常简单的例子，假设我们的语料库使用了这五个词：",al,E,pl,z,qn="基础单词集合将是 <code>[&quot;b&quot;, &quot;g&quot;, &quot;h&quot;, &quot;n&quot;, &quot;p&quot;, &quot;s&quot;, &quot;u&quot;]</code> 。在实际应用中，基本词汇表将至少包含所有 ASCII 字符，可能还包含一些 Unicode 字符。如果你正在 tokenization 不在训练语料库中的字符，则该字符将转换为未知 tokens，这就是为什么许多 NLP 模型在分析带有表情符号的内容的结果非常糟糕的原因之一。",el,g,Ml,V,Qn="获得这个基础单词集合后，我们通过学习 <code>合并（merges）</code> 来添加新的 tokens 直到达到期望的词汇表大小。合并是将现有词汇表中的两个元素合并为一个新元素的规则。所以，一开始会创建出含有两个字符的 tokens 然后，随着训练的进展，会产生更长的子词。",yl,Z,bn="在分词器训练期间的任何一步，BPE 算法都会搜索最常见的现有 tokens 对 （在这里，“对”是指一个词中的两个连续 tokens ）。最常见的这一对会被合并，然后我们重复这个过程。",jl,G,An="回到我们之前的例子，让我们假设单词具有以下频率：",Jl,S,il,_,Bn="意思是 <code>&quot;hug&quot;</code> 在语料库中出现了 10 次， <code>&quot;pug&quot;</code> 出现了 5 次， <code>&quot;pun&quot;</code> 出现了 12 次， <code>&quot;bun&quot;</code> 出现了 4 次， <code>&quot;hugs&quot;</code> 出现了 5 次。我们通过将每个单词拆分为字符（形成我们初始词汇表的字符）来开始训练，这样我们就可以将每个单词视为一个 tokens 列表：",cl,N,Ul,v,En="然后我们看看相邻的字符对。 <code>(&quot;h&quot;, &quot;u&quot;)</code> 在词 <code>&quot;hug&quot;</code> 和 <code>&quot;hugs&quot;</code> 中出现，所以在语料库中总共出现了 15 次。然而，最常见的对属于 <code>(&quot;u&quot;, &quot;g&quot;)</code> ，它在 <code>&quot;hug&quot;</code> 、 <code>&quot;pug&quot;</code> 和 <code>&quot;hugs&quot;</code> 中出现，总共在词汇表中出现了 20 次。",rl,D,zn="因此，tokenizer 学习的第一个合并规则是 <code>(&quot;u&quot;, &quot;g&quot;) -&gt; &quot;ug&quot;</code> ，意思就是 <code>&quot;ug&quot;</code> 将被添加到词汇表中，且应在语料库的所有词中合并这一对。在这个阶段结束时，词汇表和语料库看起来像这样：",ul,H,ol,X,Vn="现在我们有一些对，继续合并的话会产生一个比两个字符长的 tokens 例如 <code>(&quot;h&quot;, &quot;ug&quot;)</code> ，在语料库中出现 15 次。然而，这个阶段出现频率最高的对是 <code>(&quot;u&quot;, &quot;n&quot;)</code> ，在语料库中出现 16 次，所以学到的第二个合并规则是 <code>(&quot;u&quot;, &quot;n&quot;) -&gt; &quot;un&quot;</code> 。将其添加到词汇表并合并所有现有的这个对，将出现：",Tl,W,hl,R,Zn="现在最频繁的一对是 <code>(&quot;h&quot;, &quot;ug&quot;)</code> ，所以我们学习了合并规则 <code>(&quot;h&quot;, &quot;ug&quot;) -&gt; &quot;hug&quot;</code> ，这形成了我们第一个三个字母的 tokens 合并后，语料库如下所示：",wl,Y,xl,P,Gn="我们继续这样合并，直到达到我们所需的词汇量。",Cl,m,gl,K,ml,F,Sn="完成训练之后就可以对新的输入 tokenization 了，从某种意义上说，新的输入会依照以下步骤对新输入进行 tokenization：",Il,L,_n="<li>标准化</li> <li>预分词</li> <li>将单词拆分为单个字符</li> <li>根据学习的合并规则，按顺序合并拆分的字符</li>",fl,O,Nn="让我们以我们在训练期间使用的示例为例，Tokenizer 学习到了三个合并规则：",$l,ss,dl,ls,vn="在这种情况下，单词 <code>&quot;bug&quot;</code> 将被转化为 <code>[&quot;b&quot;, &quot;ug&quot;]</code> 。然而 <code>&quot;mug&quot;</code> ，将被转换为 <code>[&quot;[UNK]&quot;, &quot;ug&quot;]</code> ，因为字母 <code>&quot;m&quot;</code> 不再基本词汇表中。同样，单词 <code>&quot;thug&quot;</code> 会被转换为 <code>[&quot;[UNK]&quot;, &quot;hug&quot;]</code> ：字母 <code>&quot;t&quot;</code> 不在基本词汇表中，使用合并规则首先会将 <code>&quot;u&quot;</code> 和 <code>&quot;g&quot;</code> 合并，然后将 <code>&quot;h&quot;</code> 和 <code>&quot;ug&quot;</code> 合并。",kl,I,ql,ns,Ql,ts,Dn="现在，让我们看一下 BPE 算法的实现。这并不是在大型语料库上实际使用的经过优化的版本；我们只是想向你展示代码，以便你可以更好地理解算法",bl,as,Hn="首先，我们需要一个语料库，让我们创建一个含有几句话的简单语料库：",Al,ps,Bl,es,Xn="接下来，我们需要将该语料库预分词为单词。由于我们正在复现一个 BPE  tokenizer （例如 GPT-2），我们将使用 <code>gpt2</code> 分词器进行预分词：",El,Ms,zl,ys,Wn="然后，我们在进行预分词的同时计算语料库中每个单词的频率：",Vl,js,Zl,Js,Gl,is,Rn="下一步是计算基础词汇表，这由语料库中使用的所有字符组成：",Sl,cs,_l,Us,Nl,rs,Yn="我们还在该词汇表的开头添加了模型使用的特殊 tokens 对于 GPT-2，唯一的特殊 tokens 是 <code>&quot;&lt;|endoftext|&gt;&quot;</code> ：",vl,us,Dl,os,Pn="我们现在需要将每个单词拆分为单独的字符，以便能够开始训练：",Hl,Ts,Xl,hs,Kn="现在我们已准备好进行训练，让我们编写一个函数来计算每对字符的频率。我们需要在训练的每个步骤中使用它：",Wl,ws,Rl,xs,Fn="让我们来看看这个字典在初始合并后的一些结果：",Yl,Cs,Pl,gs,Kl,ms,Ln="现在，只需要一个简单的循环就可以找到出现频率最高的对：",Fl,Is,Ll,fs,Ol,$s,On="所以第一个要学习的合并规则是 <code>(&#39;Ġ&#39;, &#39;t&#39;) -&gt; &#39;Ġt&#39;</code> ，我们将 <code>&#39;Ġt&#39;</code> 添加到词汇表：",sn,ds,ln,ks,st="接下来，我们需要在我们的 <code>splits</code> 字典中进行这个合并。让我们为此编写另一个函数：",nn,qs,tn,Qs,lt="我们可以观察一下第一次合并的结果：",an,bs,pn,As,en,Bs,nt="现在我们有了我们需要的所有代码，可以循环直到我们学习到我们想要的所有合并。让我们把目标词汇表的大小设定为 50：",Mn,Es,yn,zs,tt="最终，我们学习了 19 条合并规则（初始词汇量为 31 —— 字母表中的 30 个字符，加上特殊 token ）：",jn,Vs,Jn,Zs,cn,Gs,at="词汇表由特殊 token 初始字母和所有合并结果组成：",Un,Ss,rn,_s,un,f,on,Ns,pt="为了对新文本进行分词，我们对其进行预分词、拆分，然后使用学到的所有合并规则：",Tn,vs,hn,Ds,et="我们可以尝试在任何由字母表中的字符组成的文本上进行此操作：",wn,Hs,xn,Xs,Cn,$,gn,Ws,Mt="至此，BPE 算法的介绍就到此结束！接下来，我们将研究 WordPiece 算法。",mn,Rs,In,Ks,fn;return d=new gt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),k=new $n({props:{title:"BPE tokenization 算法",local:"BPE tokenization算法",headingTag:"h1"}}),q=new ft({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section5.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section5.ipynb"}]}}),b=new It({props:{id:"HEikzVL-lZU"}}),C=new Ys({props:{$$slots:{default:[$t]},$$scope:{ctx:x}}}),A=new $n({props:{title:"BPE 训练",local:"BPE 训练",headingTag:"h2"}}),E=new T({props:{code:"JTIyaHVnJTIyJTJDJTIwJTIycHVnJTIyJTJDJTIwJTIycHVuJTIyJTJDJTIwJTIyYnVuJTIyJTJDJTIwJTIyaHVncyUyMg==",highlighted:'<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-string">&quot;pug&quot;</span>, <span class="hljs-string">&quot;pun&quot;</span>, <span class="hljs-string">&quot;bun&quot;</span>, <span class="hljs-string">&quot;hugs&quot;</span>',wrap:!1}}),g=new Ys({props:{$$slots:{default:[dt]},$$scope:{ctx:x}}}),S=new T({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),N=new T({props:{code:"KCUyMmglMjIlMjAlMjJ1JTIyJTIwJTIyZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMmclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnUlMjIlMjAlMjJnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),H=new T({props:{code:"JUU4JUFGJThEJUU2JUIxJTg3JUU4JUExJUE4JTNBJTIwJTVCJTIyYiUyMiUyQyUyMCUyMmclMjIlMkMlMjAlMjJoJTIyJTJDJTIwJTIybiUyMiUyQyUyMCUyMnAlMjIlMkMlMjAlMjJzJTIyJTJDJTIwJTIydSUyMiUyQyUyMCUyMnVnJTIyJTVEJTBBJUU4JUFGJUFEJUU2JTk2JTk5JUU1JUJBJTkzJTNBJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`词汇表: <span class="hljs-selector-attr">[<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>]</span>
语料库: (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),W=new T({props:{code:"JUU4JUFGJThEJUU2JUIxJTg3JUU4JUExJUE4JTNBJTIwJTVCJTIyYiUyMiUyQyUyMCUyMmclMjIlMkMlMjAlMjJoJTIyJTJDJTIwJTIybiUyMiUyQyUyMCUyMnAlMjIlMkMlMjAlMjJzJTIyJTJDJTIwJTIydSUyMiUyQyUyMCUyMnVnJTIyJTJDJTIwJTIydW4lMjIlNUQlMEElRTglQUYlQUQlRTYlOTYlOTklRTUlQkElOTMlM0ElMjAoJTIyaCUyMiUyMCUyMnVnJTIyJTJDJTIwMTApJTJDJTIwKCUyMnAlMjIlMjAlMjJ1ZyUyMiUyQyUyMDUpJTJDJTIwKCUyMnAlMjIlMjAlMjJ1biUyMiUyQyUyMDEyKSUyQyUyMCglMjJiJTIyJTIwJTIydW4lMjIlMkMlMjA0KSUyQyUyMCglMjJoJTIyJTIwJTIydWclMjIlMjAlMjJzJTIyJTJDJTIwNSk=",highlighted:`词汇表: <span class="hljs-selector-attr">[<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>]</span>
语料库: (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),Y=new T({props:{code:"JUU4JUFGJThEJUU2JUIxJTg3JUU4JUExJUE4JTNBJTIwJTVCJTIyYiUyMiUyQyUyMCUyMmclMjIlMkMlMjAlMjJoJTIyJTJDJTIwJTIybiUyMiUyQyUyMCUyMnAlMjIlMkMlMjAlMjJzJTIyJTJDJTIwJTIydSUyMiUyQyUyMCUyMnVnJTIyJTJDJTIwJTIydW4lMjIlMkMlMjAlMjJodWclMjIlNUQlMEElRTglQUYlQUQlRTYlOTYlOTklRTUlQkElOTMlM0ElMjAoJTIyaHVnJTIyJTJDJTIwMTApJTJDJTIwKCUyMnAlMjIlMjAlMjJ1ZyUyMiUyQyUyMDUpJTJDJTIwKCUyMnAlMjIlMjAlMjJ1biUyMiUyQyUyMDEyKSUyQyUyMCglMjJiJTIyJTIwJTIydW4lMjIlMkMlMjA0KSUyQyUyMCglMjJodWclMjIlMjAlMjJzJTIyJTJDJTIwNSk=",highlighted:`词汇表: <span class="hljs-selector-attr">[<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>]</span>
语料库: (<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;hug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),m=new Ys({props:{$$slots:{default:[kt]},$$scope:{ctx:x}}}),K=new $n({props:{title:"tokenization",local:"tokenization",headingTag:"h2"}}),ss=new T({props:{code:"KCUyMnUlMjIlMkMlMjAlMjJnJTIyKSUyMC0lM0UlMjAlMjJ1ZyUyMiUwQSglMjJ1JTIyJTJDJTIwJTIybiUyMiklMjAtJTNFJTIwJTIydW4lMjIlMEEoJTIyaCUyMiUyQyUyMCUyMnVnJTIyKSUyMC0lM0UlMjAlMjJodWclMjI=",highlighted:`<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;ug&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;un&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;hug&quot;</span>`,wrap:!1}}),I=new Ys({props:{$$slots:{default:[qt]},$$scope:{ctx:x}}}),ns=new $n({props:{title:"实现 BPE 算法",local:"实现 BPE 算法",headingTag:"h2"}}),ps=new T({props:{code:"Y29ycHVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBDb3Vyc2UuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGNoYXB0ZXIlMjBpcyUyMGFib3V0JTIwdG9rZW5pemF0aW9uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBzZWN0aW9uJTIwc2hvd3MlMjBzZXZlcmFsJTIwdG9rZW5pemVyJTIwYWxnb3JpdGhtcy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIb3BlZnVsbHklMkMlMjB5b3UlMjB3aWxsJTIwYmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwaG93JTIwdGhleSUyMGFyZSUyMHRyYWluZWQlMjBhbmQlMjBnZW5lcmF0ZSUyMHRva2Vucy4lMjIlMkMlMEElNUQ=",highlighted:`corpus = [
    <span class="hljs-string">&quot;This is the Hugging Face Course.&quot;</span>,
    <span class="hljs-string">&quot;This chapter is about tokenization.&quot;</span>,
    <span class="hljs-string">&quot;This section shows several tokenizer algorithms.&quot;</span>,
    <span class="hljs-string">&quot;Hopefully, you will be able to understand how they are trained and generate tokens.&quot;</span>,
]`,wrap:!1}}),Ms=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)`,wrap:!1}}),js=new T({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEF3b3JkX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUwQWZvciUyMHRleHQlMjBpbiUyMGNvcnB1cyUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBuZXdfd29yZHMlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwbmV3X3dvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZF9mcmVxcyU1QndvcmQlNUQlMjAlMkIlM0QlMjAxJTBBJTBBcHJpbnQod29yZF9mcmVxcyk=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

word_freqs = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> corpus:
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    new_words = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> new_words:
        word_freqs[word] += <span class="hljs-number">1</span>

<span class="hljs-built_in">print</span>(word_freqs)`,wrap:!1}}),Js=new T({props:{code:"ZGVmYXVsdGRpY3QoaW50JTJDJTIwJTdCJ1RoaXMnJTNBJTIwMyUyQyUyMCclQzQlQTBpcyclM0ElMjAyJTJDJTIwJyVDNCVBMHRoZSclM0ElMjAxJTJDJTIwJyVDNCVBMEh1Z2dpbmcnJTNBJTIwMSUyQyUyMCclQzQlQTBGYWNlJyUzQSUyMDElMkMlMjAnJUM0JUEwQ291cnNlJyUzQSUyMDElMkMlMjAnLiclM0ElMjA0JTJDJTIwJyVDNCVBMGNoYXB0ZXInJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCclQzQlQTBhYm91dCclM0ElMjAxJTJDJTIwJyVDNCVBMHRva2VuaXphdGlvbiclM0ElMjAxJTJDJTIwJyVDNCVBMHNlY3Rpb24nJTNBJTIwMSUyQyUyMCclQzQlQTBzaG93cyclM0ElMjAxJTJDJTIwJyVDNCVBMHNldmVyYWwnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbml6ZXInJTNBJTIwMSUyQyUyMCclQzQlQTBhbGdvcml0aG1zJyUzQSUyMDElMkMlMEElMjAlMjAlMjAlMjAnSG9wZWZ1bGx5JyUzQSUyMDElMkMlMjAnJTJDJyUzQSUyMDElMkMlMjAnJUM0JUEweW91JyUzQSUyMDElMkMlMjAnJUM0JUEwd2lsbCclM0ElMjAxJTJDJTIwJyVDNCVBMGJlJyUzQSUyMDElMkMlMjAnJUM0JUEwYWJsZSclM0ElMjAxJTJDJTIwJyVDNCVBMHRvJyUzQSUyMDElMkMlMjAnJUM0JUEwdW5kZXJzdGFuZCclM0ElMjAxJTJDJTIwJyVDNCVBMGhvdyclM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJyVDNCVBMHRoZXknJTNBJTIwMSUyQyUyMCclQzQlQTBhcmUnJTNBJTIwMSUyQyUyMCclQzQlQTB0cmFpbmVkJyUzQSUyMDElMkMlMjAnJUM0JUEwYW5kJyUzQSUyMDElMkMlMjAnJUM0JUEwZ2VuZXJhdGUnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbnMnJTNBJTIwMSU3RCk=",highlighted:`defaultdict(<span class="hljs-built_in">int</span>, {<span class="hljs-string">&#x27;This&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠHugging&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠFace&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠCourse&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;.&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;Ġchapter&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġabout&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenization&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġsection&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġshows&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġseveral&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenizer&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġalgorithms&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Hopefully&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;,&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġyou&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġwill&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġbe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġable&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġunderstand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġhow&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġthey&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġare&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtrained&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġgenerate&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokens&#x27;</span>: <span class="hljs-number">1</span>})`,wrap:!1}}),cs=new T({props:{code:"YWxwaGFiZXQlMjAlM0QlMjAlNUIlNUQlMEElMEFmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzLmtleXMoKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGxldHRlciUyMGluJTIwd29yZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGV0dGVyJTIwbm90JTIwaW4lMjBhbHBoYWJldCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFscGhhYmV0LmFwcGVuZChsZXR0ZXIpJTBBYWxwaGFiZXQuc29ydCgpJTBBJTBBcHJpbnQoYWxwaGFiZXQp",highlighted:`alphabet = []

<span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys():
    <span class="hljs-keyword">for</span> letter <span class="hljs-keyword">in</span> word:
        <span class="hljs-keyword">if</span> letter <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> alphabet:
            alphabet.append(letter)
alphabet.sort()

<span class="hljs-built_in">print</span>(alphabet)`,wrap:!1}}),Us=new T({props:{code:"JTVCJTIwJyUyQyclMkMlMjAnLiclMkMlMjAnQyclMkMlMjAnRiclMkMlMjAnSCclMkMlMjAnVCclMkMlMjAnYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZCclMkMlMjAnZSclMkMlMjAnZiclMkMlMjAnZyclMkMlMjAnaCclMkMlMjAnaSclMkMlMjAnayclMkMlMjAnbCclMkMlMjAnbSclMkMlMjAnbiclMkMlMjAnbyclMkMlMjAncCclMkMlMjAnciclMkMlMjAncyclMkMlMEElMjAlMjAndCclMkMlMjAndSclMkMlMjAndiclMkMlMjAndyclMkMlMjAneSclMkMlMjAneiclMkMlMjAnJUM0JUEwJyU1RA==",highlighted:`[ <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>,
  <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>]`,wrap:!1}}),us=new T({props:{code:"dm9jYWIlMjAlM0QlMjAlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQlMjAlMkIlMjBhbHBoYWJldC5jb3B5KCk=",highlighted:'vocab = [<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>] + alphabet.copy()',wrap:!1}}),Ts=new T({props:{code:"c3BsaXRzJTIwJTNEJTIwJTdCd29yZCUzQSUyMCU1QmMlMjBmb3IlMjBjJTIwaW4lMjB3b3JkJTVEJTIwZm9yJTIwd29yZCUyMGluJTIwd29yZF9mcmVxcy5rZXlzKCklN0Q=",highlighted:'splits = {word: [c <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys()}',wrap:!1}}),ws=new T({props:{code:"ZGVmJTIwY29tcHV0ZV9wYWlyX2ZyZXFzKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBwYWlyX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUyMCUyMCUyMCUyMGZvciUyMHdvcmQlMkMlMjBmcmVxJTIwaW4lMjB3b3JkX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0cyU1QndvcmQlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGxlbihzcGxpdCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udGludWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oc3BsaXQpJTIwLSUyMDEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFpciUyMCUzRCUyMChzcGxpdCU1QmklNUQlMkMlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlNUJwYWlyJTVEJTIwJTJCJTNEJTIwZnJlcSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHBhaXJfZnJlcXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_pair_freqs</span>(<span class="hljs-params">splits</span>):
    pair_freqs = defaultdict(<span class="hljs-built_in">int</span>)
    <span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>):
            pair = (split[i], split[i + <span class="hljs-number">1</span>])
            pair_freqs[pair] += freq
    <span class="hljs-keyword">return</span> pair_freqs`,wrap:!1}}),Cs=new T({props:{code:"cGFpcl9mcmVxcyUyMCUzRCUyMGNvbXB1dGVfcGFpcl9mcmVxcyhzcGxpdHMpJTBBJTBBZm9yJTIwaSUyQyUyMGtleSUyMGluJTIwZW51bWVyYXRlKHBhaXJfZnJlcXMua2V5cygpKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JrZXklN0QlM0ElMjAlN0JwYWlyX2ZyZXFzJTVCa2V5JTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMGlmJTIwaSUyMCUzRSUzRCUyMDUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhaw==",highlighted:`pair_freqs = compute_pair_freqs(splits)

<span class="hljs-keyword">for</span> i, key <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(pair_freqs.keys()):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{key}</span>: <span class="hljs-subst">{pair_freqs[key]}</span>&quot;</span>)
    <span class="hljs-keyword">if</span> i &gt;= <span class="hljs-number">5</span>:
        <span class="hljs-keyword">break</span>`,wrap:!1}}),gs=new T({props:{code:"KCdUJyUyQyUyMCdoJyklM0ElMjAzJTBBKCdoJyUyQyUyMCdpJyklM0ElMjAzJTBBKCdpJyUyQyUyMCdzJyklM0ElMjA1JTBBKCclQzQlQTAnJTJDJTIwJ2knKSUzQSUyMDIlMEEoJyVDNCVBMCclMkMlMjAndCcpJTNBJTIwNyUwQSgndCclMkMlMjAnaCcpJTNBJTIwMw==",highlighted:`(<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-number">5</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">2</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-number">7</span>
(<span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>`,wrap:!1}}),Is=new T({props:{code:"YmVzdF9wYWlyJTIwJTNEJTIwJTIyJTIyJTBBbWF4X2ZyZXElMjAlM0QlMjBOb25lJTBBJTBBZm9yJTIwcGFpciUyQyUyMGZyZXElMjBpbiUyMHBhaXJfZnJlcXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWF4X2ZyZXElMjBpcyUyME5vbmUlMjBvciUyMG1heF9mcmVxJTIwJTNDJTIwZnJlcSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMHBhaXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfZnJlcSUyMCUzRCUyMGZyZXElMEElMEFwcmludChiZXN0X3BhaXIlMkMlMjBtYXhfZnJlcSk=",highlighted:`best_pair = <span class="hljs-string">&quot;&quot;</span>
max_freq = <span class="hljs-literal">None</span>

<span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
    <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
        best_pair = pair
        max_freq = freq

<span class="hljs-built_in">print</span>(best_pair, max_freq)`,wrap:!1}}),fs=new T({props:{code:"KCclQzQlQTAnJTJDJTIwJ3QnKSUyMDc=",highlighted:'(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>) <span class="hljs-number">7</span>',wrap:!1}}),ds=new T({props:{code:"bWVyZ2VzJTIwJTNEJTIwJTdCKCUyMiVDNCVBMCUyMiUyQyUyMCUyMnQlMjIpJTNBJTIwJTIyJUM0JUEwdCUyMiU3RCUwQXZvY2FiLmFwcGVuZCglMjIlQzQlQTB0JTIyKQ==",highlighted:`merges = {(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>): <span class="hljs-string">&quot;Ġt&quot;</span>}
vocab.append(<span class="hljs-string">&quot;Ġt&quot;</span>)`,wrap:!1}}),qs=new T({props:{code:"ZGVmJTIwbWVyZ2VfcGFpcihhJTJDJTIwYiUyQyUyMHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXQlMjAlM0QlMjBzcGxpdHMlNUJ3b3JkJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc3BsaXQpJTIwJTNEJTNEJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnRpbnVlJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaSUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGlsZSUyMGklMjAlM0MlMjBsZW4oc3BsaXQpJTIwLSUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNwbGl0JTVCaSU1RCUyMCUzRCUzRCUyMGElMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwYiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0JTIwJTNEJTIwc3BsaXQlNUIlM0FpJTVEJTIwJTJCJTIwJTVCYSUyMCUyQiUyMGIlNUQlMjAlMkIlMjBzcGxpdCU1QmklMjAlMkIlMjAyJTIwJTNBJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGklMjAlMkIlM0QlMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXRzJTVCd29yZCU1RCUyMCUzRCUyMHNwbGl0JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3BsaXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">merge_pair</span>(<span class="hljs-params">a, b, splits</span>):
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs:
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>

        i = <span class="hljs-number">0</span>
        <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
            <span class="hljs-keyword">if</span> split[i] == a <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == b:
                split = split[:i] + [a + b] + split[i + <span class="hljs-number">2</span> :]
            <span class="hljs-keyword">else</span>:
                i += <span class="hljs-number">1</span>
        splits[word] = split
    <span class="hljs-keyword">return</span> splits`,wrap:!1}}),bs=new T({props:{code:"c3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpciglMjIlQzQlQTAlMjIlMkMlMjAlMjJ0JTIyJTJDJTIwc3BsaXRzKSUwQXByaW50KHNwbGl0cyU1QiUyMiVDNCVBMHRyYWluZWQlMjIlNUQp",highlighted:`splits = merge_pair(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>, splits)
<span class="hljs-built_in">print</span>(splits[<span class="hljs-string">&quot;Ġtrained&quot;</span>])`,wrap:!1}}),As=new T({props:{code:"JTVCJyVDNCVBMHQnJTJDJTIwJ3InJTJDJTIwJ2EnJTJDJTIwJ2knJTJDJTIwJ24nJTJDJTIwJ2UnJTJDJTIwJ2QnJTVE",highlighted:'[<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>]',wrap:!1}}),Es=new T({props:{code:"dm9jYWJfc2l6ZSUyMCUzRCUyMDUwJTBBJTBBd2hpbGUlMjBsZW4odm9jYWIpJTIwJTNDJTIwdm9jYWJfc2l6ZSUzQSUwQSUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlMjAlM0QlMjBjb21wdXRlX3BhaXJfZnJlcXMoc3BsaXRzKSUwQSUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMG1heF9mcmVxJTIwJTNEJTIwTm9uZSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBmcmVxJTIwaW4lMjBwYWlyX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMG1heF9mcmVxJTIwaXMlMjBOb25lJTIwb3IlMjBtYXhfZnJlcSUyMCUzQyUyMGZyZXElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiZXN0X3BhaXIlMjAlM0QlMjBwYWlyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2ZyZXElMjAlM0QlMjBmcmVxJTBBJTIwJTIwJTIwJTIwc3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpcigqYmVzdF9wYWlyJTJDJTIwc3BsaXRzKSUwQSUyMCUyMCUyMCUyMG1lcmdlcyU1QmJlc3RfcGFpciU1RCUyMCUzRCUyMGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEJTBBJTIwJTIwJTIwJTIwdm9jYWIuYXBwZW5kKGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEKQ==",highlighted:`vocab_size = <span class="hljs-number">50</span>

<span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(vocab) &lt; vocab_size:
    pair_freqs = compute_pair_freqs(splits)
    best_pair = <span class="hljs-string">&quot;&quot;</span>
    max_freq = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
        <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
            best_pair = pair
            max_freq = freq
    splits = merge_pair(*best_pair, splits)
    merges[best_pair] = best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>]
    vocab.append(best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>])`,wrap:!1}}),Vs=new T({props:{code:"cHJpbnQobWVyZ2VzKQ==",highlighted:'<span class="hljs-built_in">print</span>(merges)',wrap:!1}}),Zs=new T({props:{code:"JTdCKCclQzQlQTAnJTJDJTIwJ3QnKSUzQSUyMCclQzQlQTB0JyUyQyUyMCgnaSclMkMlMjAncycpJTNBJTIwJ2lzJyUyQyUyMCgnZSclMkMlMjAncicpJTNBJTIwJ2VyJyUyQyUyMCgnJUM0JUEwJyUyQyUyMCdhJyklM0ElMjAnJUM0JUEwYSclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ28nKSUzQSUyMCclQzQlQTB0byclMkMlMjAoJ2UnJTJDJTIwJ24nKSUzQSUyMCdlbiclMkMlMEElMjAoJ1QnJTJDJTIwJ2gnKSUzQSUyMCdUaCclMkMlMjAoJ1RoJyUyQyUyMCdpcycpJTNBJTIwJ1RoaXMnJTJDJTIwKCdvJyUyQyUyMCd1JyklM0ElMjAnb3UnJTJDJTIwKCdzJyUyQyUyMCdlJyklM0ElMjAnc2UnJTJDJTIwKCclQzQlQTB0byclMkMlMjAnaycpJTNBJTIwJyVDNCVBMHRvayclMkMlMEElMjAoJyVDNCVBMHRvayclMkMlMjAnZW4nKSUzQSUyMCclQzQlQTB0b2tlbiclMkMlMjAoJ24nJTJDJTIwJ2QnKSUzQSUyMCduZCclMkMlMjAoJyVDNCVBMCclMkMlMjAnaXMnKSUzQSUyMCclQzQlQTBpcyclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ2gnKSUzQSUyMCclQzQlQTB0aCclMkMlMjAoJyVDNCVBMHRoJyUyQyUyMCdlJyklM0ElMjAnJUM0JUEwdGhlJyUyQyUwQSUyMCgnaSclMkMlMjAnbicpJTNBJTIwJ2luJyUyQyUyMCgnJUM0JUEwYSclMkMlMjAnYicpJTNBJTIwJyVDNCVBMGFiJyUyQyUyMCgnJUM0JUEwdG9rZW4nJTJDJTIwJ2knKSUzQSUyMCclQzQlQTB0b2tlbmknJTdE",highlighted:`{(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-string">&#x27;Ġt&#x27;</span>, (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-string">&#x27;is&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>): <span class="hljs-string">&#x27;er&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>): <span class="hljs-string">&#x27;Ġa&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>): <span class="hljs-string">&#x27;Ġto&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;en&#x27;</span>,
 (<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Th&#x27;</span>, (<span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;This&#x27;</span>, (<span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>): <span class="hljs-string">&#x27;ou&#x27;</span>, (<span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;se&#x27;</span>, (<span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>): <span class="hljs-string">&#x27;Ġtok&#x27;</span>,
 (<span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>): <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, (<span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>): <span class="hljs-string">&#x27;nd&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;Ġis&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Ġth&#x27;</span>, (<span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;Ġthe&#x27;</span>,
 (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;in&#x27;</span>, (<span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>): <span class="hljs-string">&#x27;Ġab&#x27;</span>, (<span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>}`,wrap:!1}}),Ss=new T({props:{code:"cHJpbnQodm9jYWIp",highlighted:'<span class="hljs-built_in">print</span>(vocab)',wrap:!1}}),_s=new T({props:{code:"JTVCJyUzQyU3Q2VuZG9mdGV4dCU3QyUzRSclMkMlMjAnJTJDJyUyQyUyMCcuJyUyQyUyMCdDJyUyQyUyMCdGJyUyQyUyMCdIJyUyQyUyMCdUJyUyQyUyMCdhJyUyQyUyMCdiJyUyQyUyMCdjJyUyQyUyMCdkJyUyQyUyMCdlJyUyQyUyMCdmJyUyQyUyMCdnJyUyQyUyMCdoJyUyQyUyMCdpJyUyQyUyMCdrJyUyQyUyMCdsJyUyQyUyMCdtJyUyQyUyMCduJyUyQyUyMCdvJyUyQyUwQSUyMCdwJyUyQyUyMCdyJyUyQyUyMCdzJyUyQyUyMCd0JyUyQyUyMCd1JyUyQyUyMCd2JyUyQyUyMCd3JyUyQyUyMCd5JyUyQyUyMCd6JyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMHQnJTJDJTIwJ2lzJyUyQyUyMCdlciclMkMlMjAnJUM0JUEwYSclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2VuJyUyQyUyMCdUaCclMkMlMjAnVGhpcyclMkMlMjAnb3UnJTJDJTIwJ3NlJyUyQyUwQSUyMCclQzQlQTB0b2snJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCduZCclMkMlMjAnJUM0JUEwaXMnJTJDJTIwJyVDNCVBMHRoJyUyQyUyMCclQzQlQTB0aGUnJTJDJTIwJ2luJyUyQyUyMCclQzQlQTBhYiclMkMlMjAnJUM0JUEwdG9rZW5pJyU1RA==",highlighted:`[<span class="hljs-string">&#x27;&lt;|endoftext|&gt;&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>,
 <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;er&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;ou&#x27;</span>, <span class="hljs-string">&#x27;se&#x27;</span>,
 <span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;nd&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;Ġab&#x27;</span>, <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>]`,wrap:!1}}),f=new Ys({props:{$$slots:{default:[Qt]},$$scope:{ctx:x}}}),vs=new T({props:{code:"ZGVmJTIwdG9rZW5pemUodGV4dCklM0ElMEElMjAlMjAlMjAlMjBwcmVfdG9rZW5pemVfcmVzdWx0JTIwJTNEJTIwdG9rZW5pemVyLl90b2tlbml6ZXIucHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKHRleHQpJTBBJTIwJTIwJTIwJTIwcHJlX3Rva2VuaXplZF90ZXh0JTIwJTNEJTIwJTVCd29yZCUyMGZvciUyMHdvcmQlMkMlMjBvZmZzZXQlMjBpbiUyMHByZV90b2tlbml6ZV9yZXN1bHQlNUQlMEElMjAlMjAlMjAlMjBzcGxpdHMlMjAlM0QlMjAlNUIlNUJsJTIwZm9yJTIwbCUyMGluJTIwd29yZCU1RCUyMGZvciUyMHdvcmQlMjBpbiUyMHByZV90b2tlbml6ZWRfdGV4dCU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBtZXJnZSUyMGluJTIwbWVyZ2VzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpZHglMkMlMjBzcGxpdCUyMGluJTIwZW51bWVyYXRlKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTNEJTIwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdoaWxlJTIwaSUyMCUzQyUyMGxlbihzcGxpdCklMjAtJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc3BsaXQlNUJpJTVEJTIwJTNEJTNEJTIwcGFpciU1QjAlNUQlMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwcGFpciU1QjElNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0JTVCJTNBaSU1RCUyMCUyQiUyMCU1Qm1lcmdlJTVEJTIwJTJCJTIwc3BsaXQlNUJpJTIwJTJCJTIwMiUyMCUzQSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTJCJTNEJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0cyU1QmlkeCU1RCUyMCUzRCUyMHNwbGl0JTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3VtKHNwbGl0cyUyQyUyMCU1QiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">text</span>):
    pre_tokenize_result = tokenizer._tokenizer.pre_tokenizer.pre_tokenize_str(text)
    pre_tokenized_text = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> pre_tokenize_result]
    splits = [[l <span class="hljs-keyword">for</span> l <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> pre_tokenized_text]
    <span class="hljs-keyword">for</span> pair, merge <span class="hljs-keyword">in</span> merges.items():
        <span class="hljs-keyword">for</span> idx, split <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(splits):
            i = <span class="hljs-number">0</span>
            <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
                <span class="hljs-keyword">if</span> split[i] == pair[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == pair[<span class="hljs-number">1</span>]:
                    split = split[:i] + [merge] + split[i + <span class="hljs-number">2</span> :]
                <span class="hljs-keyword">else</span>:
                    i += <span class="hljs-number">1</span>
            splits[idx] = split

    <span class="hljs-keyword">return</span> <span class="hljs-built_in">sum</span>(splits, [])`,wrap:!1}}),Hs=new T({props:{code:"dG9rZW5pemUoJTIyVGhpcyUyMGlzJTIwbm90JTIwYSUyMHRva2VuLiUyMik=",highlighted:'tokenize(<span class="hljs-string">&quot;This is not a token.&quot;</span>)',wrap:!1}}),Xs=new T({props:{code:"JTVCJ1RoaXMnJTJDJTIwJyVDNCVBMGlzJyUyQyUyMCclQzQlQTAnJTJDJTIwJ24nJTJDJTIwJ28nJTJDJTIwJ3QnJTJDJTIwJyVDNCVBMGEnJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCcuJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),$=new Ys({props:{warning:!0,$$slots:{default:[bt]},$$scope:{ctx:x}}}),Rs=new mt({props:{source:"https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter6/5.mdx"}}),{c(){e=U("meta"),h=a(),u=U("p"),w=a(),M(d.$$.fragment),Fs=a(),M(k.$$.fragment),Ls=a(),M(q.$$.fragment),Os=a(),Q=U("p"),Q.textContent=dn,sl=a(),M(b.$$.fragment),ll=a(),M(C.$$.fragment),nl=a(),M(A.$$.fragment),tl=a(),B=U("p"),B.textContent=kn,al=a(),M(E.$$.fragment),pl=a(),z=U("p"),z.innerHTML=qn,el=a(),M(g.$$.fragment),Ml=a(),V=U("p"),V.innerHTML=Qn,yl=a(),Z=U("p"),Z.textContent=bn,jl=a(),G=U("p"),G.textContent=An,Jl=a(),M(S.$$.fragment),il=a(),_=U("p"),_.innerHTML=Bn,cl=a(),M(N.$$.fragment),Ul=a(),v=U("p"),v.innerHTML=En,rl=a(),D=U("p"),D.innerHTML=zn,ul=a(),M(H.$$.fragment),ol=a(),X=U("p"),X.innerHTML=Vn,Tl=a(),M(W.$$.fragment),hl=a(),R=U("p"),R.innerHTML=Zn,wl=a(),M(Y.$$.fragment),xl=a(),P=U("p"),P.textContent=Gn,Cl=a(),M(m.$$.fragment),gl=a(),M(K.$$.fragment),ml=a(),F=U("p"),F.textContent=Sn,Il=a(),L=U("ol"),L.innerHTML=_n,fl=a(),O=U("p"),O.textContent=Nn,$l=a(),M(ss.$$.fragment),dl=a(),ls=U("p"),ls.innerHTML=vn,kl=a(),M(I.$$.fragment),ql=a(),M(ns.$$.fragment),Ql=a(),ts=U("p"),ts.textContent=Dn,bl=a(),as=U("p"),as.textContent=Hn,Al=a(),M(ps.$$.fragment),Bl=a(),es=U("p"),es.innerHTML=Xn,El=a(),M(Ms.$$.fragment),zl=a(),ys=U("p"),ys.textContent=Wn,Vl=a(),M(js.$$.fragment),Zl=a(),M(Js.$$.fragment),Gl=a(),is=U("p"),is.textContent=Rn,Sl=a(),M(cs.$$.fragment),_l=a(),M(Us.$$.fragment),Nl=a(),rs=U("p"),rs.innerHTML=Yn,vl=a(),M(us.$$.fragment),Dl=a(),os=U("p"),os.textContent=Pn,Hl=a(),M(Ts.$$.fragment),Xl=a(),hs=U("p"),hs.textContent=Kn,Wl=a(),M(ws.$$.fragment),Rl=a(),xs=U("p"),xs.textContent=Fn,Yl=a(),M(Cs.$$.fragment),Pl=a(),M(gs.$$.fragment),Kl=a(),ms=U("p"),ms.textContent=Ln,Fl=a(),M(Is.$$.fragment),Ll=a(),M(fs.$$.fragment),Ol=a(),$s=U("p"),$s.innerHTML=On,sn=a(),M(ds.$$.fragment),ln=a(),ks=U("p"),ks.innerHTML=st,nn=a(),M(qs.$$.fragment),tn=a(),Qs=U("p"),Qs.textContent=lt,an=a(),M(bs.$$.fragment),pn=a(),M(As.$$.fragment),en=a(),Bs=U("p"),Bs.textContent=nt,Mn=a(),M(Es.$$.fragment),yn=a(),zs=U("p"),zs.textContent=tt,jn=a(),M(Vs.$$.fragment),Jn=a(),M(Zs.$$.fragment),cn=a(),Gs=U("p"),Gs.textContent=at,Un=a(),M(Ss.$$.fragment),rn=a(),M(_s.$$.fragment),un=a(),M(f.$$.fragment),on=a(),Ns=U("p"),Ns.textContent=pt,Tn=a(),M(vs.$$.fragment),hn=a(),Ds=U("p"),Ds.textContent=et,wn=a(),M(Hs.$$.fragment),xn=a(),M(Xs.$$.fragment),Cn=a(),M($.$$.fragment),gn=a(),Ws=U("p"),Ws.textContent=Mt,mn=a(),M(Rs.$$.fragment),In=a(),Ks=U("p"),this.h()},l(s){const l=xt("svelte-u9bgzb",document.head);e=r(l,"META",{name:!0,content:!0}),l.forEach(n),h=p(s),u=r(s,"P",{}),rt(u).forEach(n),w=p(s),y(d.$$.fragment,s),Fs=p(s),y(k.$$.fragment,s),Ls=p(s),y(q.$$.fragment,s),Os=p(s),Q=r(s,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-cafj1v"&&(Q.textContent=dn),sl=p(s),y(b.$$.fragment,s),ll=p(s),y(C.$$.fragment,s),nl=p(s),y(A.$$.fragment,s),tl=p(s),B=r(s,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1xtlx6q"&&(B.textContent=kn),al=p(s),y(E.$$.fragment,s),pl=p(s),z=r(s,"P",{"data-svelte-h":!0}),o(z)!=="svelte-qrzm6i"&&(z.innerHTML=qn),el=p(s),y(g.$$.fragment,s),Ml=p(s),V=r(s,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1pf74eh"&&(V.innerHTML=Qn),yl=p(s),Z=r(s,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-fgjr6p"&&(Z.textContent=bn),jl=p(s),G=r(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1kuwrk5"&&(G.textContent=An),Jl=p(s),y(S.$$.fragment,s),il=p(s),_=r(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1jexcr3"&&(_.innerHTML=Bn),cl=p(s),y(N.$$.fragment,s),Ul=p(s),v=r(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-cu00o7"&&(v.innerHTML=En),rl=p(s),D=r(s,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1pkk3x3"&&(D.innerHTML=zn),ul=p(s),y(H.$$.fragment,s),ol=p(s),X=r(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-19iv4fv"&&(X.innerHTML=Vn),Tl=p(s),y(W.$$.fragment,s),hl=p(s),R=r(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-scrtmz"&&(R.innerHTML=Zn),wl=p(s),y(Y.$$.fragment,s),xl=p(s),P=r(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-4ek1mp"&&(P.textContent=Gn),Cl=p(s),y(m.$$.fragment,s),gl=p(s),y(K.$$.fragment,s),ml=p(s),F=r(s,"P",{"data-svelte-h":!0}),o(F)!=="svelte-vwd30d"&&(F.textContent=Sn),Il=p(s),L=r(s,"OL",{"data-svelte-h":!0}),o(L)!=="svelte-m3fmz7"&&(L.innerHTML=_n),fl=p(s),O=r(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1gfifff"&&(O.textContent=Nn),$l=p(s),y(ss.$$.fragment,s),dl=p(s),ls=r(s,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-19k5wls"&&(ls.innerHTML=vn),kl=p(s),y(I.$$.fragment,s),ql=p(s),y(ns.$$.fragment,s),Ql=p(s),ts=r(s,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-92kbvp"&&(ts.textContent=Dn),bl=p(s),as=r(s,"P",{"data-svelte-h":!0}),o(as)!=="svelte-19oi16y"&&(as.textContent=Hn),Al=p(s),y(ps.$$.fragment,s),Bl=p(s),es=r(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-193w4gh"&&(es.innerHTML=Xn),El=p(s),y(Ms.$$.fragment,s),zl=p(s),ys=r(s,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-vwpm4m"&&(ys.textContent=Wn),Vl=p(s),y(js.$$.fragment,s),Zl=p(s),y(Js.$$.fragment,s),Gl=p(s),is=r(s,"P",{"data-svelte-h":!0}),o(is)!=="svelte-1fa8ke2"&&(is.textContent=Rn),Sl=p(s),y(cs.$$.fragment,s),_l=p(s),y(Us.$$.fragment,s),Nl=p(s),rs=r(s,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-1tg2x2o"&&(rs.innerHTML=Yn),vl=p(s),y(us.$$.fragment,s),Dl=p(s),os=r(s,"P",{"data-svelte-h":!0}),o(os)!=="svelte-1m50py"&&(os.textContent=Pn),Hl=p(s),y(Ts.$$.fragment,s),Xl=p(s),hs=r(s,"P",{"data-svelte-h":!0}),o(hs)!=="svelte-1kbibkn"&&(hs.textContent=Kn),Wl=p(s),y(ws.$$.fragment,s),Rl=p(s),xs=r(s,"P",{"data-svelte-h":!0}),o(xs)!=="svelte-1ec489l"&&(xs.textContent=Fn),Yl=p(s),y(Cs.$$.fragment,s),Pl=p(s),y(gs.$$.fragment,s),Kl=p(s),ms=r(s,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-11ofgxl"&&(ms.textContent=Ln),Fl=p(s),y(Is.$$.fragment,s),Ll=p(s),y(fs.$$.fragment,s),Ol=p(s),$s=r(s,"P",{"data-svelte-h":!0}),o($s)!=="svelte-2ohqia"&&($s.innerHTML=On),sn=p(s),y(ds.$$.fragment,s),ln=p(s),ks=r(s,"P",{"data-svelte-h":!0}),o(ks)!=="svelte-8v6wgo"&&(ks.innerHTML=st),nn=p(s),y(qs.$$.fragment,s),tn=p(s),Qs=r(s,"P",{"data-svelte-h":!0}),o(Qs)!=="svelte-1atajuj"&&(Qs.textContent=lt),an=p(s),y(bs.$$.fragment,s),pn=p(s),y(As.$$.fragment,s),en=p(s),Bs=r(s,"P",{"data-svelte-h":!0}),o(Bs)!=="svelte-wrfq07"&&(Bs.textContent=nt),Mn=p(s),y(Es.$$.fragment,s),yn=p(s),zs=r(s,"P",{"data-svelte-h":!0}),o(zs)!=="svelte-12dmu1y"&&(zs.textContent=tt),jn=p(s),y(Vs.$$.fragment,s),Jn=p(s),y(Zs.$$.fragment,s),cn=p(s),Gs=r(s,"P",{"data-svelte-h":!0}),o(Gs)!=="svelte-1spn0nn"&&(Gs.textContent=at),Un=p(s),y(Ss.$$.fragment,s),rn=p(s),y(_s.$$.fragment,s),un=p(s),y(f.$$.fragment,s),on=p(s),Ns=r(s,"P",{"data-svelte-h":!0}),o(Ns)!=="svelte-1r7uxle"&&(Ns.textContent=pt),Tn=p(s),y(vs.$$.fragment,s),hn=p(s),Ds=r(s,"P",{"data-svelte-h":!0}),o(Ds)!=="svelte-18srrkp"&&(Ds.textContent=et),wn=p(s),y(Hs.$$.fragment,s),xn=p(s),y(Xs.$$.fragment,s),Cn=p(s),y($.$$.fragment,s),gn=p(s),Ws=r(s,"P",{"data-svelte-h":!0}),o(Ws)!=="svelte-1isqaa6"&&(Ws.textContent=Mt),mn=p(s),y(Rs.$$.fragment,s),In=p(s),Ks=r(s,"P",{}),rt(Ks).forEach(n),this.h()},h(){ut(e,"name","hf:doc:metadata"),ut(e,"content",Bt)},m(s,l){Ct(document.head,e),t(s,h,l),t(s,u,l),t(s,w,l),j(d,s,l),t(s,Fs,l),j(k,s,l),t(s,Ls,l),j(q,s,l),t(s,Os,l),t(s,Q,l),t(s,sl,l),j(b,s,l),t(s,ll,l),j(C,s,l),t(s,nl,l),j(A,s,l),t(s,tl,l),t(s,B,l),t(s,al,l),j(E,s,l),t(s,pl,l),t(s,z,l),t(s,el,l),j(g,s,l),t(s,Ml,l),t(s,V,l),t(s,yl,l),t(s,Z,l),t(s,jl,l),t(s,G,l),t(s,Jl,l),j(S,s,l),t(s,il,l),t(s,_,l),t(s,cl,l),j(N,s,l),t(s,Ul,l),t(s,v,l),t(s,rl,l),t(s,D,l),t(s,ul,l),j(H,s,l),t(s,ol,l),t(s,X,l),t(s,Tl,l),j(W,s,l),t(s,hl,l),t(s,R,l),t(s,wl,l),j(Y,s,l),t(s,xl,l),t(s,P,l),t(s,Cl,l),j(m,s,l),t(s,gl,l),j(K,s,l),t(s,ml,l),t(s,F,l),t(s,Il,l),t(s,L,l),t(s,fl,l),t(s,O,l),t(s,$l,l),j(ss,s,l),t(s,dl,l),t(s,ls,l),t(s,kl,l),j(I,s,l),t(s,ql,l),j(ns,s,l),t(s,Ql,l),t(s,ts,l),t(s,bl,l),t(s,as,l),t(s,Al,l),j(ps,s,l),t(s,Bl,l),t(s,es,l),t(s,El,l),j(Ms,s,l),t(s,zl,l),t(s,ys,l),t(s,Vl,l),j(js,s,l),t(s,Zl,l),j(Js,s,l),t(s,Gl,l),t(s,is,l),t(s,Sl,l),j(cs,s,l),t(s,_l,l),j(Us,s,l),t(s,Nl,l),t(s,rs,l),t(s,vl,l),j(us,s,l),t(s,Dl,l),t(s,os,l),t(s,Hl,l),j(Ts,s,l),t(s,Xl,l),t(s,hs,l),t(s,Wl,l),j(ws,s,l),t(s,Rl,l),t(s,xs,l),t(s,Yl,l),j(Cs,s,l),t(s,Pl,l),j(gs,s,l),t(s,Kl,l),t(s,ms,l),t(s,Fl,l),j(Is,s,l),t(s,Ll,l),j(fs,s,l),t(s,Ol,l),t(s,$s,l),t(s,sn,l),j(ds,s,l),t(s,ln,l),t(s,ks,l),t(s,nn,l),j(qs,s,l),t(s,tn,l),t(s,Qs,l),t(s,an,l),j(bs,s,l),t(s,pn,l),j(As,s,l),t(s,en,l),t(s,Bs,l),t(s,Mn,l),j(Es,s,l),t(s,yn,l),t(s,zs,l),t(s,jn,l),j(Vs,s,l),t(s,Jn,l),j(Zs,s,l),t(s,cn,l),t(s,Gs,l),t(s,Un,l),j(Ss,s,l),t(s,rn,l),j(_s,s,l),t(s,un,l),j(f,s,l),t(s,on,l),t(s,Ns,l),t(s,Tn,l),j(vs,s,l),t(s,hn,l),t(s,Ds,l),t(s,wn,l),j(Hs,s,l),t(s,xn,l),j(Xs,s,l),t(s,Cn,l),j($,s,l),t(s,gn,l),t(s,Ws,l),t(s,mn,l),j(Rs,s,l),t(s,In,l),t(s,Ks,l),fn=!0},p(s,[l]){const yt={};l&2&&(yt.$$scope={dirty:l,ctx:s}),C.$set(yt);const jt={};l&2&&(jt.$$scope={dirty:l,ctx:s}),g.$set(jt);const Jt={};l&2&&(Jt.$$scope={dirty:l,ctx:s}),m.$set(Jt);const it={};l&2&&(it.$$scope={dirty:l,ctx:s}),I.$set(it);const ct={};l&2&&(ct.$$scope={dirty:l,ctx:s}),f.$set(ct);const Ut={};l&2&&(Ut.$$scope={dirty:l,ctx:s}),$.$set(Ut)},i(s){fn||(J(d.$$.fragment,s),J(k.$$.fragment,s),J(q.$$.fragment,s),J(b.$$.fragment,s),J(C.$$.fragment,s),J(A.$$.fragment,s),J(E.$$.fragment,s),J(g.$$.fragment,s),J(S.$$.fragment,s),J(N.$$.fragment,s),J(H.$$.fragment,s),J(W.$$.fragment,s),J(Y.$$.fragment,s),J(m.$$.fragment,s),J(K.$$.fragment,s),J(ss.$$.fragment,s),J(I.$$.fragment,s),J(ns.$$.fragment,s),J(ps.$$.fragment,s),J(Ms.$$.fragment,s),J(js.$$.fragment,s),J(Js.$$.fragment,s),J(cs.$$.fragment,s),J(Us.$$.fragment,s),J(us.$$.fragment,s),J(Ts.$$.fragment,s),J(ws.$$.fragment,s),J(Cs.$$.fragment,s),J(gs.$$.fragment,s),J(Is.$$.fragment,s),J(fs.$$.fragment,s),J(ds.$$.fragment,s),J(qs.$$.fragment,s),J(bs.$$.fragment,s),J(As.$$.fragment,s),J(Es.$$.fragment,s),J(Vs.$$.fragment,s),J(Zs.$$.fragment,s),J(Ss.$$.fragment,s),J(_s.$$.fragment,s),J(f.$$.fragment,s),J(vs.$$.fragment,s),J(Hs.$$.fragment,s),J(Xs.$$.fragment,s),J($.$$.fragment,s),J(Rs.$$.fragment,s),fn=!0)},o(s){i(d.$$.fragment,s),i(k.$$.fragment,s),i(q.$$.fragment,s),i(b.$$.fragment,s),i(C.$$.fragment,s),i(A.$$.fragment,s),i(E.$$.fragment,s),i(g.$$.fragment,s),i(S.$$.fragment,s),i(N.$$.fragment,s),i(H.$$.fragment,s),i(W.$$.fragment,s),i(Y.$$.fragment,s),i(m.$$.fragment,s),i(K.$$.fragment,s),i(ss.$$.fragment,s),i(I.$$.fragment,s),i(ns.$$.fragment,s),i(ps.$$.fragment,s),i(Ms.$$.fragment,s),i(js.$$.fragment,s),i(Js.$$.fragment,s),i(cs.$$.fragment,s),i(Us.$$.fragment,s),i(us.$$.fragment,s),i(Ts.$$.fragment,s),i(ws.$$.fragment,s),i(Cs.$$.fragment,s),i(gs.$$.fragment,s),i(Is.$$.fragment,s),i(fs.$$.fragment,s),i(ds.$$.fragment,s),i(qs.$$.fragment,s),i(bs.$$.fragment,s),i(As.$$.fragment,s),i(Es.$$.fragment,s),i(Vs.$$.fragment,s),i(Zs.$$.fragment,s),i(Ss.$$.fragment,s),i(_s.$$.fragment,s),i(f.$$.fragment,s),i(vs.$$.fragment,s),i(Hs.$$.fragment,s),i(Xs.$$.fragment,s),i($.$$.fragment,s),i(Rs.$$.fragment,s),fn=!1},d(s){s&&(n(h),n(u),n(w),n(Fs),n(Ls),n(Os),n(Q),n(sl),n(ll),n(nl),n(tl),n(B),n(al),n(pl),n(z),n(el),n(Ml),n(V),n(yl),n(Z),n(jl),n(G),n(Jl),n(il),n(_),n(cl),n(Ul),n(v),n(rl),n(D),n(ul),n(ol),n(X),n(Tl),n(hl),n(R),n(wl),n(xl),n(P),n(Cl),n(gl),n(ml),n(F),n(Il),n(L),n(fl),n(O),n($l),n(dl),n(ls),n(kl),n(ql),n(Ql),n(ts),n(bl),n(as),n(Al),n(Bl),n(es),n(El),n(zl),n(ys),n(Vl),n(Zl),n(Gl),n(is),n(Sl),n(_l),n(Nl),n(rs),n(vl),n(Dl),n(os),n(Hl),n(Xl),n(hs),n(Wl),n(Rl),n(xs),n(Yl),n(Pl),n(Kl),n(ms),n(Fl),n(Ll),n(Ol),n($s),n(sn),n(ln),n(ks),n(nn),n(tn),n(Qs),n(an),n(pn),n(en),n(Bs),n(Mn),n(yn),n(zs),n(jn),n(Jn),n(cn),n(Gs),n(Un),n(rn),n(un),n(on),n(Ns),n(Tn),n(hn),n(Ds),n(wn),n(xn),n(Cn),n(gn),n(Ws),n(mn),n(In),n(Ks)),n(e),c(d,s),c(k,s),c(q,s),c(b,s),c(C,s),c(A,s),c(E,s),c(g,s),c(S,s),c(N,s),c(H,s),c(W,s),c(Y,s),c(m,s),c(K,s),c(ss,s),c(I,s),c(ns,s),c(ps,s),c(Ms,s),c(js,s),c(Js,s),c(cs,s),c(Us,s),c(us,s),c(Ts,s),c(ws,s),c(Cs,s),c(gs,s),c(Is,s),c(fs,s),c(ds,s),c(qs,s),c(bs,s),c(As,s),c(Es,s),c(Vs,s),c(Zs,s),c(Ss,s),c(_s,s),c(f,s),c(vs,s),c(Hs,s),c(Xs,s),c($,s),c(Rs,s)}}}const Bt='{"title":"BPE tokenization 算法","local":"BPE tokenization算法","sections":[{"title":"BPE 训练","local":"BPE 训练","sections":[],"depth":2},{"title":"tokenization","local":"tokenization","sections":[],"depth":2},{"title":"实现 BPE 算法","local":"实现 BPE 算法","sections":[],"depth":2}],"depth":1}';function Et(x){return Tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vt extends ht{constructor(e){super(),wt(this,e,Et,At,ot,{})}}export{vt as component};
