# 本章简介 [[本章简介]]

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

## 欢迎来到🤗 Hugging Face 课程 [[欢迎来到🤗 Hugging Face 课程]]

<Youtube id="00GKzGyWFEs" />

本课程将教你如何使用 Hugging Face 生态系统的库进行自然语言处理（NLP）。这些库包括 🤗 Transformers、🤗 Datasets、🤗 Tokenizers 和 🤗 Accelerate，以及 Hugging Face Hub。本课程完全免费且无广告。

## 有什么是值得期待的？[[有什么是值得期待的？]]

以下是课程的简要概述：

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary.svg" alt="Brief overview of the chapters of the course."/>
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary-dark.svg" alt="Brief overview of the chapters of the course."/>
</div>

- 第 1 章到第 4 章介绍了 🤗 Transformers 库的主要概念。在本课程的这一部分结束时，你将了解 Transformer 模型的工作原理，并将了解如何使用 [Hugging Face Hub](https://huggingface.co/models) 中的模型，在数据集上对其进行微调，并在 Hub 上分享你的结果。
- 第 5 章到第 8 章在深入研究经典 NLP 任务之前，教授 🤗 Datasets 和 🤗 Tokenizers 的基础知识。在本部分结束时，你将能够自己解决最常见的 NLP 问题。
- 第 9 章到第 12 章将超越 NLP，探讨如何使用 Transformer 模型解决语音处理和计算机视觉任务。在此过程中，你将学习如何构建和分享模型的演示，并将它们优化为生产环境。完成这部分课程后，你将准备好将 🤗 Transformers 应用于（几乎）任何机器学习问题！

这个课程：

* 需要良好的 Python 知识 
* 在完成入门深度学习课程后效果更佳，例如 [DeepLearning.AI](https://www.deeplearning.ai/) 提供的 [fast.ai实用深度学习教程](https://course.fast.ai/) 
* 不需要事先具备 [PyTorch](https://pytorch.org/) 或 [TensorFlow](https://www.tensorflow.org/) 知识，虽然熟悉其中任何一个都会对学习有所帮助

完成本课程后，我们建议你查看 [DeepLearning.AI的自然语言处理系列课程](https://www.coursera.org/specializations/natural-language-processing?utm_source=deeplearning-ai&utm_medium=institutions&utm_campaign=20211011-nlp-2-hugging_face-page-nlp-refresh) ，该课程涵盖了诸如朴素贝叶斯和 LSTM 等传统 NLP 模型的广泛内容，非常值得了解！

## 我们是谁？[[我们是谁？]]

关于作者：

 [**Abubakar Abid**](https://huggingface.co/abidlabs) 在斯坦福大学获得应用机器学习博士学位。在攻读博士学位期间，他创立了 [Gradio](https://github.com/gradio-app/gradio) ，这是一个开源 Python 库，已用于构建超过 600,000 个机器学习演示。Gradio 被 Hugging Face 收购，Abubakar 现在在 Hugging Face 担任机器学习团队负责人。

 [**Matthew Carrigan**](https://huggingface.co/Rocketknight1) 是 Hugging Face 的机器学习工程师。他住在爱尔兰都柏林，之前在 Parse.ly 担任机器学习工程师，在此之前，他在 Trinity College Dublin 担任博士后研究员。他不相信我们会通过扩展现有架构来实现 AGI，但仍然对机器人永生抱有很高的期望。

 [**Lysandre Debut**](https://huggingface.co/lysandre) 是 Hugging Face 的机器学习工程师，从早期的开发阶段就一直致力于 🤗 Transformers 库。他的目标是通过使用非常简单的 API 开发工具，让 NLP 对每个人都变得易用。

 [**Sylvain Gugger**](https://huggingface.co/sgugger) 是 Hugging Face 的一名研究工程师，也是 🤗Transformers 库的核心维护者之一。此前，他是 fast.ai 的一名研究科学家，他与 Jeremy Howard 共同编写了 [Deep Learning for Coders with fastai and Py Torch](https://learning.oreilly.com/library/view/deep-learning-for/9781492045519/) 。他的研究重点是通过设计和改进技术，使模型在有限资源上进行快速训练，使深度学习更容易普及。

 [**Dawood Khan**](https://huggingface.co/dawoodkhan82) 是 Hugging Face 的机器学习工程师。他来自纽约，毕业于纽约大学计算机科学专业。在担任 iOS 工程师几年后，Dawood 辞职并与其他联合创始人一起创办了 Gradio。Gradio 最终被 Hugging Face 收购。

 [**Merve Noyan**](https://huggingface.co/sgugger) 是 Hugging Face 的开发者倡导者，致力于开发工具并围绕它们构建内容，以使每个人都可以使用机器学习。

 [**Lucile Saulnier**](https://huggingface.co/SaulLu) 是 Hugging Face 的机器学习工程师，负责开发和支持开源工具的使用。她还积极参与了自然语言处理领域的许多研究项目，例如协作训练和 BigScience。

 [**Lewis Tunstall**](https://huggingface.co/lewtun) 是 Hugging Face 的机器学习工程师，专注于开发开源工具并使更广泛的社区可以使用它们。他也是即将出版的一本书 [O’Reilly book on Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/) 的作者之一。

 [**Leandro von Werra**](https://huggingface.co/lvwerra) 是 Hugging Face 开源团队的机器学习工程师，也是即将出版的一本书 [O’Reilly book on Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/) 的作者之一。他拥有多年的行业经验，并在整个机器学习技术栈上进行了工作。

## FAQ[[faq]]

这里有一些经常被提到的问题：

- **参加本课程是否会获得认证？**
目前我们还没有为这门课程提供认证。然而，我们正在为 Hugging Face 生态系统制定认证计划——敬请期待！

- **我应该在这门课程上花多少时间？**
本课程的每一章都设计为在 1 周内完成，每周大约需要 6-8 小时的学习时间。但是，但你可以根据自己的需要随意安排学习时间。

- **如果我有问题，我可以在哪里提问？**
如果你对课程的任何部分有疑问，只需单击页面顶部的“*提问*”横幅，系统就会自动跳转到 [Hugging Face 论坛](https:// discuss.huggingface.co/) ：

<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/forum-button.png" alt="Hugging Face论坛链接" width=" 75%">

请注意，如果你想在完成课程后进行更多练习，论坛上还提供了 [项目灵感](https://discuss.huggingface.co/c/course/course-event/25) 列表，如果你希望在完成课程后进行更多实践，可以参考这些想法。

- **我在哪里可以获得课程的代码？**
对于每个部分，单击页面顶部的横幅可以在 Google Colab 或 Amazon SageMaker Studio Lab 中运行代码：

<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/notebook-buttons.png" alt="Hugging Face课程Notebook 链接" width= "75%">

包含课程所有代码的 Jupyter Notebook 托管在 [`huggingface/notebooks`](https://github.com/huggingface/notebooks) 仓库中。如果你希望在本地生成它们，请查看 GitHub 上 [`course`](https://github.com/huggingface/course#-jupyter-notebooks) 仓库中的说明。


- **我如何为课程做出贡献？**
有很多方法可以为课程做出贡献！如果你发现拼写错误或错误，请在 [`course`](https://github.com/huggingface/course) 仓库中提出问题。如果你想帮助将课程翻译成你的母语，请在 [此处](https://github.com/huggingface/course#translating-the-course-into-your-language) 查看说明。

- **翻译的时候有没有术语表**
每个翻译都有一个词汇表和“TRANSLATING.txt”文件，其中详细说明了为机器学习术语等所做的选择。你可以在 [此处](https://github.com/huggingface/course/blob/main/chapters/de/TRANSLATING.txt) 找到德语的示例。


- **我可以使用这门课程再次进行创作吗？**
当然！该课程是根据宽松的 [Apache 2 许可证](https://www.apache.org/licenses/LICENSE-2.0.html) 发布的。这意味着你必须按照诚信的原则，提供许可证的链接，并指出是否进行了更改。你可以以任何合理的方式这样做，但不能以任何表明许可方认可你或你的使用的方式。如果你想引用该课程，请使用以下 BibTeX：

```
@misc{huggingfacecourse,
  author = {Hugging Face},
  title = {The Hugging Face Course, 2022},
  howpublished = "\url{https://huggingface.co/course}",
  year = {2022},
  note = "[Online; accessed <today>]"
}
```

## 让我们开始吧！[[让我们开始吧！]]

你准备好了吗？在本章中，你将学习：
* 如何使用 `pipeline()` 函数解决文本生成、分类等 NLP 任务
* 关于 Transformer 架构
* 如何区分编码器、解码器和编码器-解码器架构和用例 


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter1/1.mdx" />