# 在论坛上寻求帮助 [[在论坛上寻求帮助]]

<DocNotebookDropdown
  classNames="absolute z-10 right-0 top-0"
  options={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter8/section3.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter8/section3.ipynb"},
]} />

<Youtube id="S2EEG3JIt2A"/>

[Hugging Face 论坛](https://discuss.huggingface.co) 是从开源团队和更广泛的 Hugging Face 社区获得帮助的好地方。以下是论坛某一天的主页面：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forums.png" alt="The Hugging Face forums." width="100%"/>
</div>

在左侧，你可以看到各种主题分组的所有类别，而右侧显示了最新的主题。一个主题包含标题、类别和描述；它与我们在 [第五章](/course/chapter5) 中创建自己的数据集时看到的 GitHub issue 格式非常相似 顾名思义， [Beginners（初学者）](https://discuss.huggingface.co/c/beginners/5) 类别主要面向刚开始使用 Hugging Face 库和生态系统的人。在这里，欢迎你对任何库提出任何问题，无论是调试一些代码还是寻求有关如何做某事的帮助。（话虽如此，如果你的问题特属于某个库，你更应该前往论坛上对应库所在的类别。）

同样， [Intermediate（中级）](https://discuss.huggingface.co/c/intermediate/6) 和 [Research（研究）](https://discuss.huggingface.co/c/research/7) 类别用于更高级的问题，例如关于库或一些有趣的自然语言处理前沿研究的讨论。

当然，我们也应该提到 [Course](https://discuss.huggingface.co/c/course/20) 类别，你可以在里面提出与 Hugging Face Course 相关的任何问题！

选择类别后，就可以编写第一个主题了。你可以阅读一下 [指南](https://discuss.huggingface.co/t/how-to-request-support/3128) ，里面会教你如何撰写主题。在本节中，我们将一起学习如何撰写一个好的主题。

## 写一篇高质量的论坛帖子 [[写一篇高质量的论坛帖子]]

举个例子，假如我们要将 Wikipedia 文章转化为向量嵌入用来创建自定义搜索引擎。通常情况下，我们会用如下的方法加载 Tokenizer 和模型：

```python
from transformers import AutoTokenizer, AutoModel

model_checkpoint = "distilbert-base-uncased"
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)
model = AutoModel.from_pretrained(model_checkpoint)
```

现在假设我们尝试将维基百科文章中关于 [变形金刚](https://en.wikipedia.org/wiki/Transformers) （指的是变形金刚系列作品，而不是 Transformers 库！热知识：Transformers 作为一个 🤗 Python 库被越来越多人熟知，它和变形金刚的英文名字一模一样）的整个部分转化为嵌入的向量表示：

```python
text = """
Generation One is a retroactive term for the Transformers characters that
appeared between 1984 and 1993. The Transformers began with the 1980s Japanese
toy lines Micro Change and Diaclone. They presented robots able to transform
into everyday vehicles, electronic items or weapons. Hasbro bought the Micro
Change and Diaclone toys, and partnered with Takara. Marvel Comics was hired by
Hasbro to create the backstory; editor-in-chief Jim Shooter wrote an overall
story, and gave the task of creating the characthers to writer Dennis O'Neil.
Unhappy with O'Neil's work (although O'Neil created the name "Optimus Prime"),
Shooter chose Bob Budiansky to create the characters.

The Transformers mecha were largely designed by Shōji Kawamori, the creator of
the Japanese mecha anime franchise Macross (which was adapted into the Robotech
franchise in North America). Kawamori came up with the idea of transforming
mechs while working on the Diaclone and Macross franchises in the early 1980s
(such as the VF-1 Valkyrie in Macross and Robotech), with his Diaclone mechs
later providing the basis for Transformers.

The primary concept of Generation One is that the heroic Optimus Prime, the
villainous Megatron, and their finest soldiers crash land on pre-historic Earth
in the Ark and the Nemesis before awakening in 1985, Cybertron hurtling through
the Neutral zone as an effect of the war. The Marvel comic was originally part
of the main Marvel Universe, with appearances from Spider-Man and Nick Fury,
plus some cameos, as well as a visit to the Savage Land.

The Transformers TV series began around the same time. Produced by Sunbow
Productions and Marvel Productions, later Hasbro Productions, from the start it
contradicted Budiansky's backstories. The TV series shows the Autobots looking
for new energy sources, and crash landing as the Decepticons attack. Marvel
interpreted the Autobots as destroying a rogue asteroid approaching Cybertron.
Shockwave is loyal to Megatron in the TV series, keeping Cybertron in a
stalemate during his absence, but in the comic book he attempts to take command
of the Decepticons. The TV series would also differ wildly from the origins
Budiansky had created for the Dinobots, the Decepticon turned Autobot Jetfire
(known as Skyfire on TV), the Constructicons (who combine to form
Devastator),[19][20] and Omega Supreme. The Marvel comic establishes early on
that Prime wields the Creation Matrix, which gives life to machines. In the
second season, the two-part episode The Key to Vector Sigma introduced the
ancient Vector Sigma computer, which served the same original purpose as the
Creation Matrix (giving life to Transformers), and its guardian Alpha Trion.
"""

inputs = tokenizer(text, return_tensors="pt")
logits = model(**inputs).logits
```

```python output
IndexError: index out of range in self
```

糟糕，我们遇到了一个问题——而且错误消息比我们在 [第2节](/course/chapter8/section2) 中看到的要难懂得多！我们无法理解完整的 traceback 信息，因此我们决定向 Hugging Face 论坛寻求帮助。我们该如何撰写主题呢？

首先，我们需要点击右上角的“New Topic”按钮（请注意，要创建主题，需要先登录账号）：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forums-new-topic.png" alt="Creating a new forum topic." width="100%"/>
</div>

这里会出现一个写作界面，我们可以在其中输入 Topic 的标题，选择一个类别，并起草内容：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic01.png" alt="The interface for creating a forum topic." width="100%"/>
</div>

由于错误似乎仅与 🤗 Transformers 有关，因此我们将错误类别选择为该类别。第一次尝试解释这个问题可能看起来像这样：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic02.png" alt="Drafting the content for a new forum topic." width="100%"/>
</div>

尽这个主题包含这个错误消息，但撰写方式存在一些问题：

1. 标题描述性不是很强，这会导致浏览论坛的人在没有阅读正文的情况下无法知道主题是关于什么的。

2. 正文没有提供足够的信息说明错误的来源以及如何重现错误。

3. 正文中以某种要求的语气直接 ＠ 了几个人。

像这样的主题不太可能很快得到答案（如果有答复的话），需要对其进行改进。我们将从解决第一个问题，选择一个好的标题开始。

### 选择描述性标题 [[选择描述性标题]]

如果你想就代码中的错误寻求帮助，一个好的经验法则是在标题中包含足够的信息，以便其他人可以快速确定他们是否可以回答你的问题。在我们的运行示例中，我们知道正在引发的异常名称，并有一些错误提示表示它是在模型的前向传递中触发的，即我们调用 `model(**inputs)` 的位置。为了传达这一信息，一个可能的标题可能是：

> AutoModel 前向传递中的 IndexError 来源？

这个标题告诉读者你认为的错误可能的来源，如果他们遇到了 `IndexError` 他们很可能知道如何回答你。当然，标题可以是其他的任何形式，其他可选的变体如下：

> 为什么我的模型会产生 IndexError？

这种标题也是可以的。现在我们有了一个描述性的标题，让我们来看看如何改善正文。

### 设置代码段的格式 [[设置代码段的格式]]

现在我们有了一个描述性的标题，让我们来看看如何改善代码段的格式。在 IDE 中阅读源代码已经够难的了，但是当将代码复制粘贴为纯文本时就更难了！不过 Hugging Face 论坛支持使用 Markdown 将原始代码高亮，标准格式是用三个反引号 （```） 将代码块包裹起来。这样可以让正文比上面的原始版本看起来更加美观：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic03.png" alt="Our revised forum topic, with proper code formatting." width="100%"/>
</div>

正如你在屏幕截图中看到的，将代码块包裹在反引号中会将原始文本转换为带有颜色样式的格式化代码！另外，单个反引号可用于格式化内联变量，比如 `distilbert-base-uncased` 这样。这个主题看起来好多了，再加上一点运气，我们可能会在社区中遇到一些可以猜出错误的原因的人。然而，与其依靠运气，不如撰写完整而详细的回溯信息使定位问题更容易！

### 包括完整的回溯信息 [[包括完整的回溯信息]]

通常情况下 `traceback ` 的最后一行足以调试自己的代码，但是只提供这一行虽然“节省空间”单可能会使他人定位问题变得更加困难，因为 `traceback` 中更上面的信息也可能非常有用。因此，一个好的做法是复制并粘贴整个的 `traceback` ，同时确保它的格式不被破坏。但是这些 `traceback` 可能会很长，所以可以在对源代码进行解释之后再展示它们。按照这个思路现在来对我们的问题帖子进行修改，修改之后的帖子如下所示：

<div class="flex justify-center">
<img src="https:/huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic04.png" alt="Our example forum topic, with the complete traceback." width="100%"/>
</div>

这提供了更多信息，细心的读者可能会发现：问题似乎是由于 `traceback` 中的这行代码导致输入过长：

> Token 索引序列的长度大于此模型指定的最大序列长度 （583 > 512）。

然而，我们可以通过提供触发错误的原始代码进一步改善问题描述。现在，我们就来做这件事。

### 提供可复现的示例 [[提供可复现的示例]]

如果你曾经尝试过调试其他人的代码，那么你可能首先尝试的复现他们报告的问题，这样你就可以逐步查找错误。在论坛上获取（或提供）帮助也不例外，如果你能提供一个复现错误的小例子真的很有帮助。这里有个示例帖子：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic05.png" alt="The final version of our forum topic." width="100%"/>
</div>

该帖子目前包含相当多的信息，并且它的撰写格式更可能吸引社区其他用户的注意，从而跟可能获得有用的答案。有了这些基本指南，你现在可以创建很棒的帖子来找到所遇到的 🤗 Transformers 问题的答案！



<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter8/3.mdx" />