# 章末小测验 [[章末小测验]]

<CourseFloatingBanner
    chapter={7}
    classNames="absolute z-10 right-0 top-0"
/>

让我们测试一下你在本章中学到了什么！

### 1. 你能使用Gradio做什么？
<Question
	choices={[
        {
			text: "为自己的机器学习模型创建一个demo",
			explain: "通过几行 Python 代码，你可以使用我们的预构建组件库为 ML 模型生成一个演示demo。",
			correct: true
		},
		{
			text: "与他人分享你的机器学习模型",
			explain: "在启动方法中添加 <code> share = True </code> 参数，可以生成一个共享链接发送给任何人。",
            correct: true
		},
		{
			text: "测试模型的效果",
			explain: "Gradio的一个优点是能够用真实数据测试模型，可以实时更改输入并观察模型的预测变化，从而帮助你测试模型。",
			correct: true
		},
		{
			text: "训练你的模型",
			explain: "在你的模型被训练之后，Gradio 用来进行模型推理。",
		}
	]}
/>

### 2. Gradio只能在 PyTorch 模型上工作
<Question
	choices={[
        {
			text: "正确",
			explain: "Gradio 可以处理 PyTorch 模型，除此之外也可以处理任何类型的机器学习模型！"
        },
        {
			text: "不正确",
			explain: "Gradio 是不依赖模型的，这意味着你可以为任何类型的机器学习模型创建演示。",
			correct: true
        }
	]}
/>

### 3. 可以在哪里运行一个 Gradio 演示？
<Question
	choices={[
        {
			text: "标准的 python IDEs",
			explain: "Gradio可以在你最喜欢的 IDE 上运行得很好。",
            correct: true
        },
        {
			text: "Google Colab notebooks",
			explain: "你可以在你的 Google colab notebook 上创建并启动一个 demo。",
			correct: true
        },
        {
			text: "Jupyter notebooks",
			explain: "很好的选择 —— 你可以在你的 Jupyter notebook 创建并启动一个 demo。",
			correct: true
        }
	]}
/>

### 4. Gradio 主要是为 NLP 模型设计的
<Question
	choices={[
        {
			text: "正确",
			explain: "Gradio 几乎可以处理包括 NLP 在内的所有的数据类型。"
        },
        {
			text: "错误",
			explain: "Gradio 为开发人员提供了一个库，其中包含几乎所有数据类型的预构建组件。",
            correct: true
        }
	]}
/>

### 5. 下列哪些特性是由 Gradio 支持的？
<Question
	choices={[
        {
			text: "多输入多输出",
			explain: "Gradio 支持多输入多输出。你所需要做的就是将输入和输出的列表传递给它们相应的参数",
            correct: true
        },
        {
			text: "数据持久性，状态保存",
			explain: "可以在 Interface 中添加状态。",
			correct: true
        },
        {
			text: "用户名和密码身份验证",
			explain: "将用户名/密码元组的列表传递给 `launch()` 方法，可以添加身份验证。",
			correct: true
        },
        {
			text: "自动分析谁在使用你的 Gradio 演示",
			explain: "再试一次 —— Gradio 不提供给开发人员关于谁使用他们的演示的分析。"
        },
        {
			text: "从 HuggingFace 的模型中心或 HuggingFace Space 加载模型",
			explain: "正确 —— 使用 <code>gr.Interface.load ()</code> 方法可以加载任何 Hugging Face 模型",
			correct: true
        }
	]}
/>

### 6. 下列哪一种是从 Hub 或 Spaces 加载 Huggging Face 模型的有效方法？
<Question
	choices={[
        {
			text: "gr.Interface.load('huggingface/{user}/{model_name}')",
			explain: "这是从 Hub 加载 Hugging Face 模型的有效方法",
            correct: true
        },
        {
			text: "gr.Interface.load('model/{user}/{model_name}')",
			explain: "这是从 Hub 加载 Hugging Face 模型的有效方法",
			correct: true
        },
        {
			text: "gr.Interface.load('demos/{user}/{model_name}')",
			explain: "再试一次——你不能使用'demos'前缀来加载模型。"
        },
        {
			text: "gr.Interface.load('spaces/{user}/{model_name}')",
			explain: "这是从 Space 加载 Hugging Face 模型的有效方法",
			correct: true
        }
	]}
/>

### 7. 创建你的 Gradio Interface时，必须添加以下步骤：
<Question
	choices={[
        {
			text: "向预测函数中传入一个额外的参数，该参数表示 Interface 的状态。",
			explain: "需要一个额外的参数来存储 Interface 的历史记录或状态。",
            correct: true
        },
        {
			text: "在预测函数的末尾，将状态的更新值作为额外的返回值返回。",
			explain: "历史记录或状态值需要由函数返回。",
            correct: true
        },
        {
			text: "在创建 Interface 时添加状态输入和状态输出组件",
			explain: "Gradio 提供了一个状态输入和输出组件来持久存储数据。",
            correct: true
        }
	]}
/>

### 8. Gradio 库包括以下哪些组件？
<Question
	choices={[
        {
			text: "文本框。",
			explain: "是的，可以使用 Textbox 组件创建文本框。",
            correct: true
        },
        {
			text: "图表。",
			explain: "目前没有图表组件。",
        },
        {
			text: "图像。",
			explain: "是的，你可以使用 Image 组件创建一个图像上传小部件。",
            correct: true
        },
        {
			text: "音频。",
			explain: "是的，你可以使用 Audio 组件创建一个音频上传小部件。",
            correct: true
        },
	]}
/>

### 9. 你可以使用 Gradio 做些什么？
<Question
	choices={[
        {
			text: "将多个演示合并到一个 Web 应用程序中",
			explain: "你可以使用`with gradio.Tabs ():`来为多个演示添加选项卡",
			correct: true
        },
        {
			text: "将单击/更改/等事件触发器分配给`Blocks`组件",
			explain: "在分配事件时，传入三个参数: fn: 应该调用的函数、inputs: 组件的输入(list)和outputs: 应该调用组件的输出(list)。",
			correct: true
        },
        {
			text: "自动确定哪些`Blocks`组件应该是交互的还是静态的",
			explain: "根据你定义的事件触发器，`Blocks`自动计算出组件是否应该接受用户输入。",
			correct: true
        },
		 {
			text: "创建多步演示; 这意味着你可以重用一个组件的输出作为下一个组件的输入",
			explain: "你可以使用组件作为一个事件触发器的输入，但作为另一个事件触发器的输出。",
            correct: true
        },
	]}
/>

### 10. 你可以共享一个`Blocks`演示的公共链接，并在HuggingFace space创建一个`Blocks`的演示。
<Question
	choices={[
        {
			text: "正确",
			explain: "就像`Interface`一样，所有的共享和托管功能对于`Blocks`演示都是一样的！",
			correct: true
        },
        {
			text: "不正确",
			explain: "就像`Interface`一样，所有的共享和托管功能对于`Blocks`演示都是一样的！",
			correct: false
        }
	]}
/>

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter9/9.mdx" />