# 章末小測試

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

讓我們測試一下你在本章所學的知識！
  
### 1. Hub 上的模型有什麼限制？
<Question
	choices={[
		{
			text: "模型來自🤗 Transformers 庫。",
			explain: "雖然 Hugging Face Hub 支持 🤗 Transformers 庫中的模型，但它們並不是唯一的模型！"
		},
		{
			text: "所有型號都有類似於🤗 Transformers 的接口。",
			explain: "將模型上傳到 Hugging Face Hub 時，沒有設置接口要求。"
		},
		{
			text: "沒有限制。",
			explain: "對! 在將模型上傳到Hub時沒有限制。",
            correct: true
		},
        {
			text: "在某種程度上與 NLP 相關的模型。",
			explain: "對應用領域沒有要求！"
		}
	]}
/>

### 2.如何管理Hub上的模型？
<Question
	choices={[
		{
			text: "通過 GCP 帳戶。",
			explain: "不對！"
		},
		{
			text: "通過點對點分佈。",
			explain: "不對！"
		},
		{
			text: "通過 git 和 git-lfs。",
			explain: "正確！ Hub上的模型是簡單的Git存儲庫，利用Git lfs處理大型文件。",
            correct: true
		}
	]}
/>

### 3.你能使用Hugging Face Hub網頁接口做什麼？
<Question
	choices={[
		{
			text: "分叉現有的存儲庫。",
			explain: "在Hugging Face Hub上無法分叉存儲庫。"
		},
		{
			text: "創建一個新的模型庫。",
			explain: "沒錯! 不過，這並不是你能做的全部。",
            correct: true
		},
		{
			text: "管理和編輯文件。",
			explain: "正確！ 不過，這並不是你能做的全部",
            correct: true
		},
        {
			text: "上傳文件。",
			explain: "對! 但這還不是全部。",
            correct: true
		},
        {
			text: "看看不同版本的差異。",
			explain: "沒錯! 不過，這並不是你能做的全部。",
            correct: true
		}
	]}
/>

### 4.模型卡是什麼?
<Question
	choices={[
		{
			text: "模型的粗略描述，因此不如模型和標記器文件重要。",
			explain: "這確實是對模型的描述，但它是一個重要的部分: 如果它不完整或缺乏模型的實用性大幅減少。"
		},
		{
			text: "一種確保再現性、可重用性和公平性的方法。",
			explain: "正確！在模型卡片中共享正確的信息將幫助用戶利用您的模型，並瞭解其侷限性和偏見。",
            correct: true
		},
		{
			text: "一個 Python 文件，可以運行它來檢索有關模型的信息。",
			explain: "模型卡片是簡單的 Markdown 文件。"
		}
	]}
/>

### 5.哪些🤗 Transformers 庫的對象可以直接在 Hub 上通過push _ to _ Hub ()共享？
{#if fw === 'pt'}
<Question
	choices={[
		{
			text: "一個標記器",
			explain: "正確！ 所有標記器都有push_to_hub方法，使用該方法將把所有標記器文件（詞彙表、標記器的架構等）推送到給定的存儲庫。不過，這不是唯一正確的答案！",
            correct: true
		},
		{
			text: "模型配置",
			explain: "對！所有模型配置都有 push _ to _ hub 方法，使用這個方法可以將它們推送到給定的存儲庫。你還有其他能共享的嗎？",
            correct: true
		},
		{
			text: "一個模型",
			explain: "正確！ 所有模型都有 push_to_hub 方法，使用它會將它們及其配置文件推送到給定的存儲庫。不過，這並不是您可以共享的全部內容。",
            correct: true
		},
        {
			text: "Trainer",
			explain: "沒錯————Trainer也實現了push _ to _ hub方法，並且使用它將模型、配置、標記器和模型卡草稿上傳到給定的存儲器。試試其他答案！",
            correct: true
		}
	]}
/>
{:else}
<Question
	choices={[
		{
			text: "一個標記器",
			explain: "正確！ 所有標記器都有push_to_hub方法，使用該方法將把所有標記器文件（詞彙表、標記器的架構等）推送到給定的存儲庫。不過，這不是唯一正確的答案！",
            correct: true
		},
		{
			text: "模型配置",
			explain: "對！所有模型配置都有 push _ to _ hub 方法，使用這個方法可以將它們推送到給定的存儲庫。你還有其他能共享的嗎？",
            correct: true
		},
		{
			text: "一個模型",
			explain: "正確！ 所有模型都有 push_to_hub 方法，使用它會將它們及其配置文件推送到給定的存儲庫。不過，這並不是您可以共享的全部內容。",
            correct: true
		},
		{
			text: "以上都有專用的回調函數",
			explain: "正確————在訓練期間，PushToHubCallback會定期將所有這些對象發送到存儲器。",
            correct: true
		}
	]}
/>
{/if}

### 6.當使用push _ to _ hub ()方法或 CLI 工具時，第一步是什麼？
<Question
	choices={[
		{
			text: "登錄網站。",
			explain: "這對你的本地機器沒有幫助。"
		},
		{
			text: "在終端中運行'huggingface-cli login'。",
			explain: "正確————這將下載並緩存您的個人標記。",
            correct: true
		},
		{
			text: "在筆記本中運行'notebook _ login ()'。",
			explain: "正確————這將顯示一個小部件，讓您進行身份驗證。",
            correct: true
		},
	]}
/>

### 7.您正在使用一個模型和一個標記器————如何將它們上傳到 Hub？
<Question
	choices={[
		{
			text: "通過直接在模型和標記器上調用 push _ to _ hub 方法。",
			explain: "正確！",
            correct: true
		},
		{
			text: "在 Python 運行時中，將它們包裝在huggingface _ hub實用程序中。",
			explain: "模型和標記器已經受益於 < code > huggingface _ hub </code > 實用程序: 不需要額外的包裝！"
		},
		{
			text: "將它們保存到磁盤並調用 < code > transformers-cli upload-model </code >",
			explain: "命令 < code > upload-model </code > 不存在。"
		}
	]}
/>

### 8.您可以使用'Repository'類執行哪些 git 操作？
<Question
	choices={[
		{
			text: "提交。",
			explain: "正確，< code >git _ commit () </ > 方法就是為此而存在的。",
            correct: true
		},
		{
			text: "拉一下",
			explain: "這就是 < code > git _ pull () </code > 方法的目的。",
            correct: true
		},
		{
			text: "推一下",
			explain: "方法 < code > git _ push () </code > 可以做到這一點。",
            correct: true
		},
		{
			text: "合併",
			explain: "不，這個操作在這個 API 中是不可能的。"
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter4/6.mdx" />