# 如何寫一個好問題

<DocNotebookDropdown
  classNames="absolute z-10 right-0 top-0"
  options={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter8/section5.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter8/section5.ipynb"},
]} />

當您遇到 Hugging Face 庫中的一個看起來不正確的東西時，您一定要告訴我們，以便我們可以修復它（就此而言，任何開源庫也是如此）。如果您不能完全確定錯誤是在您自己的代碼中還是在我們的某個庫中，那麼首先要檢查的是[forums](https://discuss.huggingface.co/).社區會幫助你解決這個問題，Hugging Face 團隊也會密切關注那裡的討論。

<Youtube id="_PAli-V4wj0"/>

當您確定手頭有錯誤時，第一步是構建一個最小的可重現示例。
## 創建一個最小的可重現示例

隔離產生錯誤的代碼段非常重要，因為 Hugging Face 團隊中沒有人是魔術師（目前），他們無法修復他們看不到的東西。顧名思義，最小的可重現示例應該是可重現的。這意味著它不應依賴於您可能擁有的任何外部文件或數據。嘗試用一些看起來像真實值的虛擬值替換您正在使用的數據，但仍然會產生相同的錯誤。

<Tip>

🚨🤗 Transformers 存儲庫中的許多問題都沒有解決，因為用於複製它們的數據不可訪問。

</Tip>

一旦你有一些自包含的東西，你可以嘗試將它減少到更少的代碼行，構建我們所謂的最小的可重複示例.雖然這需要你做更多的工作，但如果你提供一個漂亮的、簡短的錯誤重現器，你幾乎可以保證得到幫助和修復。

如果您覺得足夠舒服，請檢查發生錯誤的源代碼。您可能會找到問題的解決方案（在這種情況下，您甚至可以提出拉取請求來修復它），但更一般地說，這可以幫助維護人員在閱讀您的報告時更好地理解來源。

## 填寫問題模板

當您提交問題時，您會注意到有一個模板需要填寫。我們將按照[🤗 Transformers issues](https://github.com/huggingface/transformers/issues/new/choose)在這裡，但是如果您在另一個存儲庫中報告問題，則需要相同類型的信息。不要將模板留空：花時間填寫它可以最大限度地提高您獲得答案和解決問題的機會。

通常，在提交問題時，請始終保持禮貌。這是一個開源項目，因此您使用的是免費軟件，沒有人有任何義務幫助您。您可能會在您的問題中包含您認為合理的批評，但是維護人員很可能會認為它很糟糕並且不會急於幫助您。確保你閱讀了[code of conduct](https://github.com/huggingface/transformers/blob/master/CODE_OF_CONDUCT.md)項目的。

### 包括您的環境信息

🤗 Transformers 提供了一個實用程序來獲取我們需要的關於您的環境的所有信息。只需在終端中輸入以下內容：

```
transformers-cli env
```

你應該得到這樣的東西：

```out
Copy-and-paste the text below in your GitHub issue and FILL OUT the two last points.

- `transformers` version: 4.12.0.dev0
- Platform: Linux-5.10.61-1-MANJARO-x86_64-with-arch-Manjaro-Linux
- Python version: 3.7.9
- PyTorch version (GPU?): 1.8.1+cu111 (True)
- Tensorflow version (GPU?): 2.5.0 (True)
- Flax version (CPU?/GPU?/TPU?): 0.3.4 (cpu)
- Jax version: 0.2.13
- JaxLib version: 0.1.65
- Using GPU in script?: <fill in>
- Using distributed or parallel set-up in script?: <fill in>
```

您還可以添加一個 **!** 在開始的時候 **transformers-cli env** 命令從筆記本單元執行它，然後在問題的開頭複製並粘貼結果。

### 標記人員

通過輸入標記人員 **@** 其次是他們的 GitHub 句柄將向他們發送通知，以便他們會看到您的問題並可能會更快地回覆。適度使用它，因為如果您標記的人沒有直接鏈接，他們可能不喜歡收到通知。如果您查看了與您的錯誤相關的源文件，您應該在您認為對您的問題負責的行中標記最後一個進行更改的人（您可以通過查看 GitHub 上的所述行找到此信息，選擇它，然後單擊“查看 git blame”）。

否則，模板會提供要標記的人的建議。一般來說，不要標記超過三個人！

### 包含一格可重複的示例

如果您已經設法創建了一個產生錯誤的獨立示例，那麼現在是包含它的時候了！鍵入一行包含三個反引號，後跟 **python** ， 像這樣：

```
```python
```

然後粘貼您的最小可重現示例並鍵入一個帶有三個反引號的新行。這將確保您的代碼格式正確。如果您沒有設法創建可重現的示例，請以清晰的步驟解釋您是如何解決問題的。如果可以，請包含指向錯誤所在的 Google Colab 筆記本的鏈接。你分享的信息越多，維護者就越有能力回覆你。在所有情況下，您都應該複製並粘貼您收到的整個錯誤消息。如果您在 Colab 中工作，請記住，堆棧跟蹤中的某些幀可能會自動摺疊，因此請確保在複製之前展開它們。與代碼示例一樣，將該錯誤消息放在兩行之間，並帶有三個反引號，因此格式正確。

### 描述預期行為

用幾行解釋你期望得到什麼，以便維護人員完全掌握問題。這部分通常很明顯，所以應該用一句話來形容，但在某些情況下，您可能有很多話要說。

## 然後什麼？

提交您的問題後，請確保快速檢查一切是否正常。如果您犯了錯誤，您可以編輯問題，或者如果您發現問題與您最初的想法不同，甚至可以更改其標題。如果你沒有得到答案，就沒有必要對人進行 ping 操作。如果幾天內沒有人幫助您，很可能沒有人能理解您的問題。不要猶豫，回到可重現的例子。你能不能讓它更短更切題？如果您在一週內沒有得到答覆，您可以留言溫和地尋求幫助，特別是如果您已編輯問題以包含有關該問題的更多信息。



<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter8/5.mdx" />