import{s as Bs,n as ks,o as Ws}from"../chunks/scheduler.0b596ca5.js";import{S as Cs,i as Gs,e as p,s as l,c as i,h as xs,a as m,d as e,b as n,f as $s,g as o,j as g,k as Zs,l as Ns,m as a,n as r,t as c,o as h,p as M}from"../chunks/index.d9d53bd3.js";import{C as Vs,H as z,E as Es}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as _}from"../chunks/CodeBlock.9f18e41e.js";function vs(Js){let J,H,Q,R,d,F,j,A,w,ds="<strong>Big Transfer (BiT)</strong> is a type of pretraining recipe that pre-trains  on a large supervised source dataset, and fine-tunes the weights on the target task. Models are trained on the JFT-300M dataset. The finetuned models contained in this collection are finetuned on ImageNet.",S,T,L,y,js="To load a pretrained model:",D,u,P,f,ws="To load and preprocess the image:",q,b,K,I,Ts="To get the model predictions:",O,U,ss,$,ys="To get the top-5 predictions class names:",ts,Z,es,B,us="Replace the model name with the variant you want to use, e.g. <code>resnetv2_101x1_bitm</code>. You can find the IDs in the model summaries at the top of this page.",as,k,fs='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ls,W,ns,C,bs="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ps,G,is,x,Is=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ms,N,os,V,Us='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rs,E,cs,v,hs,X,Ms,Y,gs;return d=new Vs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new z({props:{title:"Big Transfer (BiT)",local:"big-transfer-bit",headingTag:"h1"}}),T=new z({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new _({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25ldHYyXzEwMXgxX2JpdG0nJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnetv2_101x1_bitm&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new _({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new _({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new z({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),G=new _({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzbmV0djJfMTAxeDFfYml0bSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnetv2_101x1_bitm&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),N=new z({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new z({props:{title:"Citation",local:"citation",headingTag:"h2"}}),v=new _({props:{code:"JTQwbWlzYyU3QmtvbGVzbmlrb3YyMDIwYmlnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JCaWclMjBUcmFuc2ZlciUyMChCaVQpJTNBJTIwR2VuZXJhbCUyMFZpc3VhbCUyMFJlcHJlc2VudGF0aW9uJTIwTGVhcm5pbmclN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JBbGV4YW5kZXIlMjBLb2xlc25pa292JTIwYW5kJTIwTHVjYXMlMjBCZXllciUyMGFuZCUyMFhpYW9odWElMjBaaGFpJTIwYW5kJTIwSm9hbiUyMFB1aWdjZXJ2ZXIlMjBhbmQlMjBKZXNzaWNhJTIwWXVuZyUyMGFuZCUyMFN5bHZhaW4lMjBHZWxseSUyMGFuZCUyME5laWwlMjBIb3Vsc2J5JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTEyLjExMzcwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{kolesnikov<span class="hljs-symbol">2020b</span>ig,
      title={<span class="hljs-keyword">Big </span>Transfer (<span class="hljs-keyword">BiT): </span>General Visual Representation Learning}, 
      author={Alexander Kolesnikov <span class="hljs-keyword">and </span>Lucas <span class="hljs-keyword">Beyer </span><span class="hljs-keyword">and </span>Xiaohua Zhai <span class="hljs-keyword">and </span><span class="hljs-keyword">Joan </span>Puigcerver <span class="hljs-keyword">and </span><span class="hljs-keyword">Jessica </span>Yung <span class="hljs-keyword">and </span>Sylvain Gelly <span class="hljs-keyword">and </span>Neil Houlsby},
      year={<span class="hljs-number">2020</span>},
      eprint={<span class="hljs-number">1912</span>.<span class="hljs-number">11370</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),X=new Es({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/big-transfer.mdx"}}),{c(){J=p("meta"),H=l(),Q=p("p"),R=l(),i(d.$$.fragment),F=l(),i(j.$$.fragment),A=l(),w=p("p"),w.innerHTML=ds,S=l(),i(T.$$.fragment),L=l(),y=p("p"),y.textContent=js,D=l(),i(u.$$.fragment),P=l(),f=p("p"),f.textContent=ws,q=l(),i(b.$$.fragment),K=l(),I=p("p"),I.textContent=Ts,O=l(),i(U.$$.fragment),ss=l(),$=p("p"),$.textContent=ys,ts=l(),i(Z.$$.fragment),es=l(),B=p("p"),B.innerHTML=us,as=l(),k=p("p"),k.innerHTML=fs,ls=l(),i(W.$$.fragment),ns=l(),C=p("p"),C.textContent=bs,ps=l(),i(G.$$.fragment),is=l(),x=p("p"),x.innerHTML=Is,ms=l(),i(N.$$.fragment),os=l(),V=p("p"),V.innerHTML=Us,rs=l(),i(E.$$.fragment),cs=l(),i(v.$$.fragment),hs=l(),i(X.$$.fragment),Ms=l(),Y=p("p"),this.h()},l(s){const t=xs("svelte-u9bgzb",document.head);J=m(t,"META",{name:!0,content:!0}),t.forEach(e),H=n(s),Q=m(s,"P",{}),$s(Q).forEach(e),R=n(s),o(d.$$.fragment,s),F=n(s),o(j.$$.fragment,s),A=n(s),w=m(s,"P",{"data-svelte-h":!0}),g(w)!=="svelte-1la1ia4"&&(w.innerHTML=ds),S=n(s),o(T.$$.fragment,s),L=n(s),y=m(s,"P",{"data-svelte-h":!0}),g(y)!=="svelte-18ywhxh"&&(y.textContent=js),D=n(s),o(u.$$.fragment,s),P=n(s),f=m(s,"P",{"data-svelte-h":!0}),g(f)!=="svelte-1c2ipa8"&&(f.textContent=ws),q=n(s),o(b.$$.fragment,s),K=n(s),I=m(s,"P",{"data-svelte-h":!0}),g(I)!=="svelte-1n9qsq1"&&(I.textContent=Ts),O=n(s),o(U.$$.fragment,s),ss=n(s),$=m(s,"P",{"data-svelte-h":!0}),g($)!=="svelte-19cnvx1"&&($.textContent=ys),ts=n(s),o(Z.$$.fragment,s),es=n(s),B=m(s,"P",{"data-svelte-h":!0}),g(B)!=="svelte-xm05fa"&&(B.innerHTML=us),as=n(s),k=m(s,"P",{"data-svelte-h":!0}),g(k)!=="svelte-1wmi3ea"&&(k.innerHTML=fs),ls=n(s),o(W.$$.fragment,s),ns=n(s),C=m(s,"P",{"data-svelte-h":!0}),g(C)!=="svelte-9sr7nh"&&(C.textContent=bs),ps=n(s),o(G.$$.fragment,s),is=n(s),x=m(s,"P",{"data-svelte-h":!0}),g(x)!=="svelte-1kguc51"&&(x.innerHTML=Is),ms=n(s),o(N.$$.fragment,s),os=n(s),V=m(s,"P",{"data-svelte-h":!0}),g(V)!=="svelte-xtxxu6"&&(V.innerHTML=Us),rs=n(s),o(E.$$.fragment,s),cs=n(s),o(v.$$.fragment,s),hs=n(s),o(X.$$.fragment,s),Ms=n(s),Y=m(s,"P",{}),$s(Y).forEach(e),this.h()},h(){Zs(J,"name","hf:doc:metadata"),Zs(J,"content",Xs)},m(s,t){Ns(document.head,J),a(s,H,t),a(s,Q,t),a(s,R,t),r(d,s,t),a(s,F,t),r(j,s,t),a(s,A,t),a(s,w,t),a(s,S,t),r(T,s,t),a(s,L,t),a(s,y,t),a(s,D,t),r(u,s,t),a(s,P,t),a(s,f,t),a(s,q,t),r(b,s,t),a(s,K,t),a(s,I,t),a(s,O,t),r(U,s,t),a(s,ss,t),a(s,$,t),a(s,ts,t),r(Z,s,t),a(s,es,t),a(s,B,t),a(s,as,t),a(s,k,t),a(s,ls,t),r(W,s,t),a(s,ns,t),a(s,C,t),a(s,ps,t),r(G,s,t),a(s,is,t),a(s,x,t),a(s,ms,t),r(N,s,t),a(s,os,t),a(s,V,t),a(s,rs,t),r(E,s,t),a(s,cs,t),r(v,s,t),a(s,hs,t),r(X,s,t),a(s,Ms,t),a(s,Y,t),gs=!0},p:ks,i(s){gs||(c(d.$$.fragment,s),c(j.$$.fragment,s),c(T.$$.fragment,s),c(u.$$.fragment,s),c(b.$$.fragment,s),c(U.$$.fragment,s),c(Z.$$.fragment,s),c(W.$$.fragment,s),c(G.$$.fragment,s),c(N.$$.fragment,s),c(E.$$.fragment,s),c(v.$$.fragment,s),c(X.$$.fragment,s),gs=!0)},o(s){h(d.$$.fragment,s),h(j.$$.fragment,s),h(T.$$.fragment,s),h(u.$$.fragment,s),h(b.$$.fragment,s),h(U.$$.fragment,s),h(Z.$$.fragment,s),h(W.$$.fragment,s),h(G.$$.fragment,s),h(N.$$.fragment,s),h(E.$$.fragment,s),h(v.$$.fragment,s),h(X.$$.fragment,s),gs=!1},d(s){s&&(e(H),e(Q),e(R),e(F),e(A),e(w),e(S),e(L),e(y),e(D),e(P),e(f),e(q),e(K),e(I),e(O),e(ss),e($),e(ts),e(es),e(B),e(as),e(k),e(ls),e(ns),e(C),e(ps),e(is),e(x),e(ms),e(os),e(V),e(rs),e(cs),e(hs),e(Ms),e(Y)),e(J),M(d,s),M(j,s),M(T,s),M(u,s),M(b,s),M(U,s),M(Z,s),M(W,s),M(G,s),M(N,s),M(E,s),M(v,s),M(X,s)}}}const Xs='{"title":"Big Transfer (BiT)","local":"big-transfer-bit","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function _s(Js){return Ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rs extends Cs{constructor(J){super(),Gs(this,J,_s,vs,Bs,{})}}export{Rs as component};
