import{s as Wt,n as vt,o as Nt}from"../chunks/scheduler.0b596ca5.js";import{S as Gt,i as Bt,e as p,s as l,c as i,h as Et,a as m,d as e,b as n,f as Zt,g as o,j as M,k as xt,l as Qt,m as a,n as r,t as c,o as h,p as g}from"../chunks/index.d9d53bd3.js";import{C as Yt,H as z,E as Vt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as _}from"../chunks/CodeBlock.9f18e41e.js";function _t(Jt){let y,S,R,H,d,F,J,A,w,wt='<strong>CSPDarknet53</strong> is a convolutional neural network and backbone for object detection that uses <a href="https://paperswithcode.com/method/darknet-53" rel="nofollow">DarkNet-53</a>. It employs a CSPNet strategy to partition the feature map of the base layer into two parts and then merges them through a cross-stage hierarchy. The use of a split and merge strategy allows for more gradient flow through the network.',L,j,jt='This CNN is used as the backbone for <a href="https://paperswithcode.com/method/yolov4" rel="nofollow">YOLOv4</a>.',D,u,P,T,ut="To load a pretrained model:",q,f,K,b,Tt="To load and preprocess the image:",O,U,tt,$,ft="To get the model predictions:",st,C,et,I,bt="To get the top-5 predictions class names:",at,k,lt,Z,Ut="Replace the model name with the variant you want to use, e.g. <code>cspdarknet53</code>. You can find the IDs in the model summaries at the top of this page.",nt,x,$t='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',pt,W,mt,v,Ct="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",it,N,ot,G,It=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,rt,B,ct,E,kt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ht,Q,gt,Y,Mt,V,yt,X,dt;return d=new Yt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new z({props:{title:"CSP-DarkNet",local:"csp-darknet",headingTag:"h1"}}),u=new z({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new _({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2NzcGRhcmtuZXQ1MyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;cspdarknet53&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),U=new _({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),C=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),k=new _({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new z({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new _({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnY3NwZGFya25ldDUzJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;cspdarknet53&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new z({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new z({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Y=new _({props:{code:"JTQwbWlzYyU3QmJvY2hrb3Zza2l5MjAyMHlvbG92NCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCWU9MT3Y0JTNBJTIwT3B0aW1hbCUyMFNwZWVkJTIwYW5kJTIwQWNjdXJhY3klMjBvZiUyME9iamVjdCUyMERldGVjdGlvbiU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QkFsZXhleSUyMEJvY2hrb3Zza2l5JTIwYW5kJTIwQ2hpZW4tWWFvJTIwV2FuZyUyMGFuZCUyMEhvbmctWXVhbiUyME1hcmslMjBMaWFvJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IyMDA0LjEwOTM0JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{bochkovskiy2020yolov4,
      title={YOLOv4: Optimal Speed and Accuracy of Object Detection}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Alexey Bochkovskiy and Chien-Yao Wang and Hong-Yuan Mark Liao}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{2004.10934}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),V=new Vt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/csp-darknet.mdx"}}),{c(){y=p("meta"),S=l(),R=p("p"),H=l(),i(d.$$.fragment),F=l(),i(J.$$.fragment),A=l(),w=p("p"),w.innerHTML=wt,L=l(),j=p("p"),j.innerHTML=jt,D=l(),i(u.$$.fragment),P=l(),T=p("p"),T.textContent=ut,q=l(),i(f.$$.fragment),K=l(),b=p("p"),b.textContent=Tt,O=l(),i(U.$$.fragment),tt=l(),$=p("p"),$.textContent=ft,st=l(),i(C.$$.fragment),et=l(),I=p("p"),I.textContent=bt,at=l(),i(k.$$.fragment),lt=l(),Z=p("p"),Z.innerHTML=Ut,nt=l(),x=p("p"),x.innerHTML=$t,pt=l(),i(W.$$.fragment),mt=l(),v=p("p"),v.textContent=Ct,it=l(),i(N.$$.fragment),ot=l(),G=p("p"),G.innerHTML=It,rt=l(),i(B.$$.fragment),ct=l(),E=p("p"),E.innerHTML=kt,ht=l(),i(Q.$$.fragment),gt=l(),i(Y.$$.fragment),Mt=l(),i(V.$$.fragment),yt=l(),X=p("p"),this.h()},l(t){const s=Et("svelte-u9bgzb",document.head);y=m(s,"META",{name:!0,content:!0}),s.forEach(e),S=n(t),R=m(t,"P",{}),Zt(R).forEach(e),H=n(t),o(d.$$.fragment,t),F=n(t),o(J.$$.fragment,t),A=n(t),w=m(t,"P",{"data-svelte-h":!0}),M(w)!=="svelte-1qc4wgd"&&(w.innerHTML=wt),L=n(t),j=m(t,"P",{"data-svelte-h":!0}),M(j)!=="svelte-1czs39f"&&(j.innerHTML=jt),D=n(t),o(u.$$.fragment,t),P=n(t),T=m(t,"P",{"data-svelte-h":!0}),M(T)!=="svelte-18ywhxh"&&(T.textContent=ut),q=n(t),o(f.$$.fragment,t),K=n(t),b=m(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1c2ipa8"&&(b.textContent=Tt),O=n(t),o(U.$$.fragment,t),tt=n(t),$=m(t,"P",{"data-svelte-h":!0}),M($)!=="svelte-1n9qsq1"&&($.textContent=ft),st=n(t),o(C.$$.fragment,t),et=n(t),I=m(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-19cnvx1"&&(I.textContent=bt),at=n(t),o(k.$$.fragment,t),lt=n(t),Z=m(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1xzvjrb"&&(Z.innerHTML=Ut),nt=n(t),x=m(t,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1wmi3ea"&&(x.innerHTML=$t),pt=n(t),o(W.$$.fragment,t),mt=n(t),v=m(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-9sr7nh"&&(v.textContent=Ct),it=n(t),o(N.$$.fragment,t),ot=n(t),G=m(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1kguc51"&&(G.innerHTML=It),rt=n(t),o(B.$$.fragment,t),ct=n(t),E=m(t,"P",{"data-svelte-h":!0}),M(E)!=="svelte-xtxxu6"&&(E.innerHTML=kt),ht=n(t),o(Q.$$.fragment,t),gt=n(t),o(Y.$$.fragment,t),Mt=n(t),o(V.$$.fragment,t),yt=n(t),X=m(t,"P",{}),Zt(X).forEach(e),this.h()},h(){xt(y,"name","hf:doc:metadata"),xt(y,"content",Rt)},m(t,s){Qt(document.head,y),a(t,S,s),a(t,R,s),a(t,H,s),r(d,t,s),a(t,F,s),r(J,t,s),a(t,A,s),a(t,w,s),a(t,L,s),a(t,j,s),a(t,D,s),r(u,t,s),a(t,P,s),a(t,T,s),a(t,q,s),r(f,t,s),a(t,K,s),a(t,b,s),a(t,O,s),r(U,t,s),a(t,tt,s),a(t,$,s),a(t,st,s),r(C,t,s),a(t,et,s),a(t,I,s),a(t,at,s),r(k,t,s),a(t,lt,s),a(t,Z,s),a(t,nt,s),a(t,x,s),a(t,pt,s),r(W,t,s),a(t,mt,s),a(t,v,s),a(t,it,s),r(N,t,s),a(t,ot,s),a(t,G,s),a(t,rt,s),r(B,t,s),a(t,ct,s),a(t,E,s),a(t,ht,s),r(Q,t,s),a(t,gt,s),r(Y,t,s),a(t,Mt,s),r(V,t,s),a(t,yt,s),a(t,X,s),dt=!0},p:vt,i(t){dt||(c(d.$$.fragment,t),c(J.$$.fragment,t),c(u.$$.fragment,t),c(f.$$.fragment,t),c(U.$$.fragment,t),c(C.$$.fragment,t),c(k.$$.fragment,t),c(W.$$.fragment,t),c(N.$$.fragment,t),c(B.$$.fragment,t),c(Q.$$.fragment,t),c(Y.$$.fragment,t),c(V.$$.fragment,t),dt=!0)},o(t){h(d.$$.fragment,t),h(J.$$.fragment,t),h(u.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h(C.$$.fragment,t),h(k.$$.fragment,t),h(W.$$.fragment,t),h(N.$$.fragment,t),h(B.$$.fragment,t),h(Q.$$.fragment,t),h(Y.$$.fragment,t),h(V.$$.fragment,t),dt=!1},d(t){t&&(e(S),e(R),e(H),e(F),e(A),e(w),e(L),e(j),e(D),e(P),e(T),e(q),e(K),e(b),e(O),e(tt),e($),e(st),e(et),e(I),e(at),e(lt),e(Z),e(nt),e(x),e(pt),e(mt),e(v),e(it),e(ot),e(G),e(rt),e(ct),e(E),e(ht),e(gt),e(Mt),e(yt),e(X)),e(y),g(d,t),g(J,t),g(u,t),g(f,t),g(U,t),g(C,t),g(k,t),g(W,t),g(N,t),g(B,t),g(Q,t),g(Y,t),g(V,t)}}}const Rt='{"title":"CSP-DarkNet","local":"csp-darknet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Xt(Jt){return Nt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends Gt{constructor(y){super(),Bt(this,y,Xt,_t,Wt,{})}}export{At as component};
