import{s as Wt,n as Zt,o as kt}from"../chunks/scheduler.0b596ca5.js";import{S as Gt,i as Bt,e as p,s as l,c as m,h as Nt,a as i,d as e,b as n,f as $t,g as o,j as y,k as Ct,l as xt,m as a,n as r,t as h,o as c,p as g}from"../chunks/index.d9d53bd3.js";import{C as Qt,H as _,E as Yt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as S}from"../chunks/CodeBlock.9f18e41e.js";function Et(Mt){let M,X,V,z,w,H,J,F,d,wt='<strong>CSPResNet</strong> is a convolutional neural network where we apply the Cross Stage Partial Network (CSPNet) approach to <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a>. The CSPNet partitions the feature map of the base layer into two parts and then merges them through a cross-stage hierarchy. The use of a split and merge strategy allows for more gradient flow through the network.',A,T,L,u,Jt="To load a pretrained model:",P,j,D,f,dt="To load and preprocess the image:",q,b,K,U,Tt="To get the model predictions:",O,I,tt,$,ut="To get the top-5 predictions class names:",st,C,et,W,jt="Replace the model name with the variant you want to use, e.g. <code>cspresnet50</code>. You can find the IDs in the model summaries at the top of this page.",at,Z,ft='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',lt,k,nt,G,bt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,B,mt,N,Ut=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,it,x,ot,Q,It='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rt,Y,ht,E,ct,v,gt,R,yt;return w=new Qt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new _({props:{title:"CSP-ResNet",local:"csp-resnet",headingTag:"h1"}}),T=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),j=new S({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2NzcHJlc25ldDUwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;cspresnet50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new S({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new S({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new S({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new S({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnY3NwcmVzbmV0NTAnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;cspresnet50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Y=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new S({props:{code:"JTQwbWlzYyU3QndhbmcyMDE5Y3NwbmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JDU1BOZXQlM0ElMjBBJTIwTmV3JTIwQmFja2JvbmUlMjB0aGF0JTIwY2FuJTIwRW5oYW5jZSUyMExlYXJuaW5nJTIwQ2FwYWJpbGl0eSUyMG9mJTIwQ05OJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCQ2hpZW4tWWFvJTIwV2FuZyUyMGFuZCUyMEhvbmctWXVhbiUyME1hcmslMjBMaWFvJTIwYW5kJTIwSS1IYXUlMjBZZWglMjBhbmQlMjBZdWVoLUh1YSUyMFd1JTIwYW5kJTIwUGluZy1ZYW5nJTIwQ2hlbiUyMGFuZCUyMEp1bi1XZWklMjBIc2llaCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE5JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTkxMS4xMTkyOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`@misc{wang2019cspnet,
      title={CSPNet: A New <span class="hljs-keyword">Backbone </span>that can Enhance Learning Capability of CNN}, 
      author={Chien-Yao Wang <span class="hljs-keyword">and </span>Hong-Yuan Mark Liao <span class="hljs-keyword">and </span>I-Hau Yeh <span class="hljs-keyword">and </span>Yueh-Hua Wu <span class="hljs-keyword">and </span>Ping-Yang Chen <span class="hljs-keyword">and </span><span class="hljs-keyword">Jun-Wei </span>Hsieh},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1911</span>.<span class="hljs-number">11929</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),v=new Yt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/csp-resnet.mdx"}}),{c(){M=p("meta"),X=l(),V=p("p"),z=l(),m(w.$$.fragment),H=l(),m(J.$$.fragment),F=l(),d=p("p"),d.innerHTML=wt,A=l(),m(T.$$.fragment),L=l(),u=p("p"),u.textContent=Jt,P=l(),m(j.$$.fragment),D=l(),f=p("p"),f.textContent=dt,q=l(),m(b.$$.fragment),K=l(),U=p("p"),U.textContent=Tt,O=l(),m(I.$$.fragment),tt=l(),$=p("p"),$.textContent=ut,st=l(),m(C.$$.fragment),et=l(),W=p("p"),W.innerHTML=jt,at=l(),Z=p("p"),Z.innerHTML=ft,lt=l(),m(k.$$.fragment),nt=l(),G=p("p"),G.textContent=bt,pt=l(),m(B.$$.fragment),mt=l(),N=p("p"),N.innerHTML=Ut,it=l(),m(x.$$.fragment),ot=l(),Q=p("p"),Q.innerHTML=It,rt=l(),m(Y.$$.fragment),ht=l(),m(E.$$.fragment),ct=l(),m(v.$$.fragment),gt=l(),R=p("p"),this.h()},l(t){const s=Nt("svelte-u9bgzb",document.head);M=i(s,"META",{name:!0,content:!0}),s.forEach(e),X=n(t),V=i(t,"P",{}),$t(V).forEach(e),z=n(t),o(w.$$.fragment,t),H=n(t),o(J.$$.fragment,t),F=n(t),d=i(t,"P",{"data-svelte-h":!0}),y(d)!=="svelte-n2j5o6"&&(d.innerHTML=wt),A=n(t),o(T.$$.fragment,t),L=n(t),u=i(t,"P",{"data-svelte-h":!0}),y(u)!=="svelte-18ywhxh"&&(u.textContent=Jt),P=n(t),o(j.$$.fragment,t),D=n(t),f=i(t,"P",{"data-svelte-h":!0}),y(f)!=="svelte-1c2ipa8"&&(f.textContent=dt),q=n(t),o(b.$$.fragment,t),K=n(t),U=i(t,"P",{"data-svelte-h":!0}),y(U)!=="svelte-1n9qsq1"&&(U.textContent=Tt),O=n(t),o(I.$$.fragment,t),tt=n(t),$=i(t,"P",{"data-svelte-h":!0}),y($)!=="svelte-19cnvx1"&&($.textContent=ut),st=n(t),o(C.$$.fragment,t),et=n(t),W=i(t,"P",{"data-svelte-h":!0}),y(W)!=="svelte-1dfb3g"&&(W.innerHTML=jt),at=n(t),Z=i(t,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=ft),lt=n(t),o(k.$$.fragment,t),nt=n(t),G=i(t,"P",{"data-svelte-h":!0}),y(G)!=="svelte-9sr7nh"&&(G.textContent=bt),pt=n(t),o(B.$$.fragment,t),mt=n(t),N=i(t,"P",{"data-svelte-h":!0}),y(N)!=="svelte-1kguc51"&&(N.innerHTML=Ut),it=n(t),o(x.$$.fragment,t),ot=n(t),Q=i(t,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-xtxxu6"&&(Q.innerHTML=It),rt=n(t),o(Y.$$.fragment,t),ht=n(t),o(E.$$.fragment,t),ct=n(t),o(v.$$.fragment,t),gt=n(t),R=i(t,"P",{}),$t(R).forEach(e),this.h()},h(){Ct(M,"name","hf:doc:metadata"),Ct(M,"content",vt)},m(t,s){xt(document.head,M),a(t,X,s),a(t,V,s),a(t,z,s),r(w,t,s),a(t,H,s),r(J,t,s),a(t,F,s),a(t,d,s),a(t,A,s),r(T,t,s),a(t,L,s),a(t,u,s),a(t,P,s),r(j,t,s),a(t,D,s),a(t,f,s),a(t,q,s),r(b,t,s),a(t,K,s),a(t,U,s),a(t,O,s),r(I,t,s),a(t,tt,s),a(t,$,s),a(t,st,s),r(C,t,s),a(t,et,s),a(t,W,s),a(t,at,s),a(t,Z,s),a(t,lt,s),r(k,t,s),a(t,nt,s),a(t,G,s),a(t,pt,s),r(B,t,s),a(t,mt,s),a(t,N,s),a(t,it,s),r(x,t,s),a(t,ot,s),a(t,Q,s),a(t,rt,s),r(Y,t,s),a(t,ht,s),r(E,t,s),a(t,ct,s),r(v,t,s),a(t,gt,s),a(t,R,s),yt=!0},p:Zt,i(t){yt||(h(w.$$.fragment,t),h(J.$$.fragment,t),h(T.$$.fragment,t),h(j.$$.fragment,t),h(b.$$.fragment,t),h(I.$$.fragment,t),h(C.$$.fragment,t),h(k.$$.fragment,t),h(B.$$.fragment,t),h(x.$$.fragment,t),h(Y.$$.fragment,t),h(E.$$.fragment,t),h(v.$$.fragment,t),yt=!0)},o(t){c(w.$$.fragment,t),c(J.$$.fragment,t),c(T.$$.fragment,t),c(j.$$.fragment,t),c(b.$$.fragment,t),c(I.$$.fragment,t),c(C.$$.fragment,t),c(k.$$.fragment,t),c(B.$$.fragment,t),c(x.$$.fragment,t),c(Y.$$.fragment,t),c(E.$$.fragment,t),c(v.$$.fragment,t),yt=!1},d(t){t&&(e(X),e(V),e(z),e(H),e(F),e(d),e(A),e(L),e(u),e(P),e(D),e(f),e(q),e(K),e(U),e(O),e(tt),e($),e(st),e(et),e(W),e(at),e(Z),e(lt),e(nt),e(G),e(pt),e(mt),e(N),e(it),e(ot),e(Q),e(rt),e(ht),e(ct),e(gt),e(R)),e(M),g(w,t),g(J,t),g(T,t),g(j,t),g(b,t),g(I,t),g(C,t),g(k,t),g(B,t),g(x,t),g(Y,t),g(E,t),g(v,t)}}}const vt='{"title":"CSP-ResNet","local":"csp-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function St(Mt){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends Gt{constructor(M){super(),Bt(this,M,St,Et,Wt,{})}}export{zt as component};
