import{s as Al,n as Ql,o as Bl}from"../chunks/scheduler.0b596ca5.js";import{S as Rl,i as El,e as p,s as a,c as m,h as Gl,a as i,d as t,b as n,f as Wl,g as M,j,k as Nl,l as vl,m as e,n as o,t as r,o as c,p as h}from"../chunks/index.d9d53bd3.js";import{C as Vl,H as X,E as Hl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as H}from"../chunks/CodeBlock.9f18e41e.js";function Yl(dl){let y,S,Y,_,g,F,J,D,w,ul='<strong>DenseNet</strong> is a type of convolutional neural network that utilises dense connections between layers, through <a href="http://www.paperswithcode.com/method/dense-block" rel="nofollow">Dense Blocks</a>, where we connect <em>all layers</em> (with matching feature-map sizes) directly with each other. To preserve the feed-forward nature, each layer obtains additional inputs from all preceding layers and passes on its own feature-maps to all subsequent layers.',L,d,Tl='The <strong>DenseNet Blur</strong> variant in this collection by Ross Wightman employs <a href="http://www.paperswithcode.com/method/blur-pooling" rel="nofollow">Blur Pooling</a>',P,u,q,T,bl="To load a pretrained model:",K,b,O,U,Ul="To load and preprocess the image:",ll,f,sl,C,fl="To get the model predictions:",tl,I,el,$,Cl="To get the top-5 predictions class names:",al,Z,nl,x,Il="Replace the model name with the variant you want to use, e.g. <code>densenet121</code>. You can find the IDs in the model summaries at the top of this page.",pl,k,$l='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ml,W,il,N,Zl="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Ml,A,ol,Q,xl=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,rl,B,cl,R,kl='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',hl,E,jl,G,yl,v,gl,V,Jl,z,wl;return g=new Vl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new X({props:{title:"DenseNet",local:"densenet",headingTag:"h1"}}),u=new X({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),b=new H({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2RlbnNlbmV0MTIxJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;densenet121&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new H({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new H({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new H({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new X({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),A=new H({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZGVuc2VuZXQxMjEnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;densenet121&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new X({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new X({props:{title:"Citation",local:"citation",headingTag:"h2"}}),G=new H({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZIdWFuZ0xXMTZhJTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCR2FvJTIwSHVhbmclMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBaaHVhbmclMjBMaXUlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBLaWxpYW4lMjBRLiUyMFdlaW5iZXJnZXIlN0QlMkMlMEElMjAlMjB0aXRsZSUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QkRlbnNlbHklMjBDb25uZWN0ZWQlMjBDb252b2x1dGlvbmFsJTIwTmV0d29ya3MlN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCQ29SUiU3RCUyQyUwQSUyMCUyMHZvbHVtZSUyMCUyMCUyMCUyMCUzRCUyMCU3QmFicyUyRjE2MDguMDY5OTMlN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAxNiU3RCUyQyUwQSUyMCUyMHVybCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHAlM0ElMkYlMkZhcnhpdi5vcmclMkZhYnMlMkYxNjA4LjA2OTkzJTdEJTJDJTBBJTIwJTIwYXJjaGl2ZVByZWZpeCUyMCUzRCUyMCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwZXByaW50JTIwJTIwJTIwJTIwJTNEJTIwJTdCMTYwOC4wNjk5MyU3RCUyQyUwQSUyMCUyMHRpbWVzdGFtcCUyMCUzRCUyMCU3Qk1vbiUyQyUyMDEwJTIwU2VwJTIwMjAxOCUyMDE1JTNBNDklM0EzMiUyMCUyQjAyMDAlN0QlMkMlMEElMjAlMjBiaWJ1cmwlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwcyUzQSUyRiUyRmRibHAub3JnJTJGcmVjJTJGam91cm5hbHMlMkZjb3JyJTJGSHVhbmdMVzE2YS5iaWIlN0QlMkMlMEElMjAlMjBiaWJzb3VyY2UlMjAlM0QlMjAlN0JkYmxwJTIwY29tcHV0ZXIlMjBzY2llbmNlJTIwYmlibGlvZ3JhcGh5JTJDJTIwaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyU3RCUwQSU3RA==",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>HuangLW16a,
  author    = {Gao Huang and
               Zhuang Liu and
               Kilian Q. Weinberger},
  title     = {Densely Connected Convolutional Networks},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1608.06993</span>},
  year      = {<span class="hljs-number">2016</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1608.06993</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1608.06993</span>},
  timestamp = {Mon, <span class="hljs-number">10</span> Sep <span class="hljs-number">2018</span> <span class="hljs-number">15</span>:<span class="hljs-number">49</span>:<span class="hljs-number">32</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>HuangLW16a.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),v=new H({props:{code:"JTQwbWlzYyU3QnJ3MjAxOXRpbW0lMkMlMEElMjAlMjBhdXRob3IlMjAlM0QlMjAlN0JSb3NzJTIwV2lnaHRtYW4lN0QlMkMlMEElMjAlMjB0aXRsZSUyMCUzRCUyMCU3QlB5VG9yY2glMjBJbWFnZSUyME1vZGVscyU3RCUyQyUwQSUyMCUyMHllYXIlMjAlM0QlMjAlN0IyMDE5JTdEJTJDJTBBJTIwJTIwcHVibGlzaGVyJTIwJTNEJTIwJTdCR2l0SHViJTdEJTJDJTBBJTIwJTIwam91cm5hbCUyMCUzRCUyMCU3QkdpdEh1YiUyMHJlcG9zaXRvcnklN0QlMkMlMEElMjAlMjBkb2klMjAlM0QlMjAlN0IxMC41MjgxJTJGemVub2RvLjQ0MTQ4NjElN0QlMkMlMEElMjAlMjBob3dwdWJsaXNoZWQlMjAlM0QlMjAlN0IlNUN1cmwlN0JodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZyd2lnaHRtYW4lMkZweXRvcmNoLWltYWdlLW1vZGVscyU3RCU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{rw2019timm,
  author = {Ross Wightman}</span><span class="language-xml">,
  title = </span><span class="hljs-template-variable">{PyTorch Image Models}</span><span class="language-xml">,
  year = </span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
  publisher = </span><span class="hljs-template-variable">{GitHub}</span><span class="language-xml">,
  journal = </span><span class="hljs-template-variable">{GitHub repository}</span><span class="language-xml">,
  doi = </span><span class="hljs-template-variable">{10.5281/zenodo.4414861}</span><span class="language-xml">,
  howpublished = </span><span class="hljs-template-variable">{\\url{https://github.com/rwightman/pytorch-image-models}</span><span class="language-xml">}
}</span>`,wrap:!1}}),V=new Hl({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/densenet.mdx"}}),{c(){y=p("meta"),S=a(),Y=p("p"),_=a(),m(g.$$.fragment),F=a(),m(J.$$.fragment),D=a(),w=p("p"),w.innerHTML=ul,L=a(),d=p("p"),d.innerHTML=Tl,P=a(),m(u.$$.fragment),q=a(),T=p("p"),T.textContent=bl,K=a(),m(b.$$.fragment),O=a(),U=p("p"),U.textContent=Ul,ll=a(),m(f.$$.fragment),sl=a(),C=p("p"),C.textContent=fl,tl=a(),m(I.$$.fragment),el=a(),$=p("p"),$.textContent=Cl,al=a(),m(Z.$$.fragment),nl=a(),x=p("p"),x.innerHTML=Il,pl=a(),k=p("p"),k.innerHTML=$l,ml=a(),m(W.$$.fragment),il=a(),N=p("p"),N.textContent=Zl,Ml=a(),m(A.$$.fragment),ol=a(),Q=p("p"),Q.innerHTML=xl,rl=a(),m(B.$$.fragment),cl=a(),R=p("p"),R.innerHTML=kl,hl=a(),m(E.$$.fragment),jl=a(),m(G.$$.fragment),yl=a(),m(v.$$.fragment),gl=a(),m(V.$$.fragment),Jl=a(),z=p("p"),this.h()},l(l){const s=Gl("svelte-u9bgzb",document.head);y=i(s,"META",{name:!0,content:!0}),s.forEach(t),S=n(l),Y=i(l,"P",{}),Wl(Y).forEach(t),_=n(l),M(g.$$.fragment,l),F=n(l),M(J.$$.fragment,l),D=n(l),w=i(l,"P",{"data-svelte-h":!0}),j(w)!=="svelte-49zh7b"&&(w.innerHTML=ul),L=n(l),d=i(l,"P",{"data-svelte-h":!0}),j(d)!=="svelte-5gcm94"&&(d.innerHTML=Tl),P=n(l),M(u.$$.fragment,l),q=n(l),T=i(l,"P",{"data-svelte-h":!0}),j(T)!=="svelte-18ywhxh"&&(T.textContent=bl),K=n(l),M(b.$$.fragment,l),O=n(l),U=i(l,"P",{"data-svelte-h":!0}),j(U)!=="svelte-1c2ipa8"&&(U.textContent=Ul),ll=n(l),M(f.$$.fragment,l),sl=n(l),C=i(l,"P",{"data-svelte-h":!0}),j(C)!=="svelte-1n9qsq1"&&(C.textContent=fl),tl=n(l),M(I.$$.fragment,l),el=n(l),$=i(l,"P",{"data-svelte-h":!0}),j($)!=="svelte-19cnvx1"&&($.textContent=Cl),al=n(l),M(Z.$$.fragment,l),nl=n(l),x=i(l,"P",{"data-svelte-h":!0}),j(x)!=="svelte-1bbpuw6"&&(x.innerHTML=Il),pl=n(l),k=i(l,"P",{"data-svelte-h":!0}),j(k)!=="svelte-1wmi3ea"&&(k.innerHTML=$l),ml=n(l),M(W.$$.fragment,l),il=n(l),N=i(l,"P",{"data-svelte-h":!0}),j(N)!=="svelte-9sr7nh"&&(N.textContent=Zl),Ml=n(l),M(A.$$.fragment,l),ol=n(l),Q=i(l,"P",{"data-svelte-h":!0}),j(Q)!=="svelte-1kguc51"&&(Q.innerHTML=xl),rl=n(l),M(B.$$.fragment,l),cl=n(l),R=i(l,"P",{"data-svelte-h":!0}),j(R)!=="svelte-xtxxu6"&&(R.innerHTML=kl),hl=n(l),M(E.$$.fragment,l),jl=n(l),M(G.$$.fragment,l),yl=n(l),M(v.$$.fragment,l),gl=n(l),M(V.$$.fragment,l),Jl=n(l),z=i(l,"P",{}),Wl(z).forEach(t),this.h()},h(){Nl(y,"name","hf:doc:metadata"),Nl(y,"content",zl)},m(l,s){vl(document.head,y),e(l,S,s),e(l,Y,s),e(l,_,s),o(g,l,s),e(l,F,s),o(J,l,s),e(l,D,s),e(l,w,s),e(l,L,s),e(l,d,s),e(l,P,s),o(u,l,s),e(l,q,s),e(l,T,s),e(l,K,s),o(b,l,s),e(l,O,s),e(l,U,s),e(l,ll,s),o(f,l,s),e(l,sl,s),e(l,C,s),e(l,tl,s),o(I,l,s),e(l,el,s),e(l,$,s),e(l,al,s),o(Z,l,s),e(l,nl,s),e(l,x,s),e(l,pl,s),e(l,k,s),e(l,ml,s),o(W,l,s),e(l,il,s),e(l,N,s),e(l,Ml,s),o(A,l,s),e(l,ol,s),e(l,Q,s),e(l,rl,s),o(B,l,s),e(l,cl,s),e(l,R,s),e(l,hl,s),o(E,l,s),e(l,jl,s),o(G,l,s),e(l,yl,s),o(v,l,s),e(l,gl,s),o(V,l,s),e(l,Jl,s),e(l,z,s),wl=!0},p:Ql,i(l){wl||(r(g.$$.fragment,l),r(J.$$.fragment,l),r(u.$$.fragment,l),r(b.$$.fragment,l),r(f.$$.fragment,l),r(I.$$.fragment,l),r(Z.$$.fragment,l),r(W.$$.fragment,l),r(A.$$.fragment,l),r(B.$$.fragment,l),r(E.$$.fragment,l),r(G.$$.fragment,l),r(v.$$.fragment,l),r(V.$$.fragment,l),wl=!0)},o(l){c(g.$$.fragment,l),c(J.$$.fragment,l),c(u.$$.fragment,l),c(b.$$.fragment,l),c(f.$$.fragment,l),c(I.$$.fragment,l),c(Z.$$.fragment,l),c(W.$$.fragment,l),c(A.$$.fragment,l),c(B.$$.fragment,l),c(E.$$.fragment,l),c(G.$$.fragment,l),c(v.$$.fragment,l),c(V.$$.fragment,l),wl=!1},d(l){l&&(t(S),t(Y),t(_),t(F),t(D),t(w),t(L),t(d),t(P),t(q),t(T),t(K),t(O),t(U),t(ll),t(sl),t(C),t(tl),t(el),t($),t(al),t(nl),t(x),t(pl),t(k),t(ml),t(il),t(N),t(Ml),t(ol),t(Q),t(rl),t(cl),t(R),t(hl),t(jl),t(yl),t(gl),t(Jl),t(z)),t(y),h(g,l),h(J,l),h(u,l),h(b,l),h(f,l),h(I,l),h(Z,l),h(W,l),h(A,l),h(B,l),h(E,l),h(G,l),h(v,l),h(V,l)}}}const zl='{"title":"DenseNet","local":"densenet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Xl(dl){return Bl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ll extends Rl{constructor(y){super(),El(this,y,Xl,Yl,Al,{})}}export{Ll as component};
