import{s as Wt,n as Gt,o as At}from"../chunks/scheduler.0b596ca5.js";import{S as Bt,i as Et,e as p,s as l,c as m,h as vt,a as i,d as e,b as n,f as It,g as o,j as M,k as kt,l as Nt,m as a,n as r,t as c,o as g,p as h}from"../chunks/index.d9d53bd3.js";import{C as Xt,H as V,E as Rt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as Q}from"../chunks/CodeBlock.9f18e41e.js";function Qt(yt){let d,z,Y,S,j,H,y,F,u,ut="Extending  “shallow” skip connections, <strong>Dense Layer Aggregation (DLA)</strong> incorporates more depth and sharing. The authors introduce two structures for deep layer aggregation (DLA): iterative deep aggregation (IDA) and hierarchical deep aggregation (HDA). These structures are expressed through an architectural framework, independent of the choice of backbone, for compatibility with current and future networks.",D,f,ft="IDA focuses on fusing resolutions and scales while HDA focuses on merging features from all modules and channels. IDA follows the base hierarchy to refine resolution and aggregate scale stage-bystage. HDA assembles its own hierarchy of tree-structured connections that cross and merge stages to aggregate different levels of representation.",L,J,q,w,Jt="To load a pretrained model:",P,T,K,b,wt="To load and preprocess the image:",O,U,tt,$,Tt="To get the model predictions:",st,x,et,Z,bt="To get the top-5 predictions class names:",at,C,lt,I,Ut="Replace the model name with the variant you want to use, e.g. <code>dla102</code>. You can find the IDs in the model summaries at the top of this page.",nt,k,$t='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',pt,W,it,G,xt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",mt,A,ot,B,Zt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,rt,E,ct,v,Ct='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',gt,N,ht,X,Mt,R,dt,_,jt;return j=new Xt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new V({props:{title:"Deep Layer Aggregation",local:"deep-layer-aggregation",headingTag:"h1"}}),J=new V({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2RsYTEwMiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;dla102&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),U=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),x=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new V({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),A=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZGxhMTAyJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;dla102&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),E=new V({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),N=new V({props:{title:"Citation",local:"citation",headingTag:"h2"}}),X=new Q({props:{code:"JTQwbWlzYyU3Qnl1MjAxOWRlZXAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkRlZXAlMjBMYXllciUyMEFnZ3JlZ2F0aW9uJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCRmlzaGVyJTIwWXUlMjBhbmQlMjBEZXF1YW4lMjBXYW5nJTIwYW5kJTIwRXZhbiUyMFNoZWxoYW1lciUyMGFuZCUyMFRyZXZvciUyMERhcnJlbGwlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE3MDcuMDY0ODQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{yu2019deep,
      title={Deep Layer Aggregation}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Fisher Yu and Dequan Wang and Evan Shelhamer and Trevor Darrell}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1707.06484}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),R=new Rt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/dla.mdx"}}),{c(){d=p("meta"),z=l(),Y=p("p"),S=l(),m(j.$$.fragment),H=l(),m(y.$$.fragment),F=l(),u=p("p"),u.innerHTML=ut,D=l(),f=p("p"),f.textContent=ft,L=l(),m(J.$$.fragment),q=l(),w=p("p"),w.textContent=Jt,P=l(),m(T.$$.fragment),K=l(),b=p("p"),b.textContent=wt,O=l(),m(U.$$.fragment),tt=l(),$=p("p"),$.textContent=Tt,st=l(),m(x.$$.fragment),et=l(),Z=p("p"),Z.textContent=bt,at=l(),m(C.$$.fragment),lt=l(),I=p("p"),I.innerHTML=Ut,nt=l(),k=p("p"),k.innerHTML=$t,pt=l(),m(W.$$.fragment),it=l(),G=p("p"),G.textContent=xt,mt=l(),m(A.$$.fragment),ot=l(),B=p("p"),B.innerHTML=Zt,rt=l(),m(E.$$.fragment),ct=l(),v=p("p"),v.innerHTML=Ct,gt=l(),m(N.$$.fragment),ht=l(),m(X.$$.fragment),Mt=l(),m(R.$$.fragment),dt=l(),_=p("p"),this.h()},l(t){const s=vt("svelte-u9bgzb",document.head);d=i(s,"META",{name:!0,content:!0}),s.forEach(e),z=n(t),Y=i(t,"P",{}),It(Y).forEach(e),S=n(t),o(j.$$.fragment,t),H=n(t),o(y.$$.fragment,t),F=n(t),u=i(t,"P",{"data-svelte-h":!0}),M(u)!=="svelte-ztimnn"&&(u.innerHTML=ut),D=n(t),f=i(t,"P",{"data-svelte-h":!0}),M(f)!=="svelte-148crxx"&&(f.textContent=ft),L=n(t),o(J.$$.fragment,t),q=n(t),w=i(t,"P",{"data-svelte-h":!0}),M(w)!=="svelte-18ywhxh"&&(w.textContent=Jt),P=n(t),o(T.$$.fragment,t),K=n(t),b=i(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1c2ipa8"&&(b.textContent=wt),O=n(t),o(U.$$.fragment,t),tt=n(t),$=i(t,"P",{"data-svelte-h":!0}),M($)!=="svelte-1n9qsq1"&&($.textContent=Tt),st=n(t),o(x.$$.fragment,t),et=n(t),Z=i(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-19cnvx1"&&(Z.textContent=bt),at=n(t),o(C.$$.fragment,t),lt=n(t),I=i(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-16eylps"&&(I.innerHTML=Ut),nt=n(t),k=i(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1wmi3ea"&&(k.innerHTML=$t),pt=n(t),o(W.$$.fragment,t),it=n(t),G=i(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-9sr7nh"&&(G.textContent=xt),mt=n(t),o(A.$$.fragment,t),ot=n(t),B=i(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1kguc51"&&(B.innerHTML=Zt),rt=n(t),o(E.$$.fragment,t),ct=n(t),v=i(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-xtxxu6"&&(v.innerHTML=Ct),gt=n(t),o(N.$$.fragment,t),ht=n(t),o(X.$$.fragment,t),Mt=n(t),o(R.$$.fragment,t),dt=n(t),_=i(t,"P",{}),It(_).forEach(e),this.h()},h(){kt(d,"name","hf:doc:metadata"),kt(d,"content",Yt)},m(t,s){Nt(document.head,d),a(t,z,s),a(t,Y,s),a(t,S,s),r(j,t,s),a(t,H,s),r(y,t,s),a(t,F,s),a(t,u,s),a(t,D,s),a(t,f,s),a(t,L,s),r(J,t,s),a(t,q,s),a(t,w,s),a(t,P,s),r(T,t,s),a(t,K,s),a(t,b,s),a(t,O,s),r(U,t,s),a(t,tt,s),a(t,$,s),a(t,st,s),r(x,t,s),a(t,et,s),a(t,Z,s),a(t,at,s),r(C,t,s),a(t,lt,s),a(t,I,s),a(t,nt,s),a(t,k,s),a(t,pt,s),r(W,t,s),a(t,it,s),a(t,G,s),a(t,mt,s),r(A,t,s),a(t,ot,s),a(t,B,s),a(t,rt,s),r(E,t,s),a(t,ct,s),a(t,v,s),a(t,gt,s),r(N,t,s),a(t,ht,s),r(X,t,s),a(t,Mt,s),r(R,t,s),a(t,dt,s),a(t,_,s),jt=!0},p:Gt,i(t){jt||(c(j.$$.fragment,t),c(y.$$.fragment,t),c(J.$$.fragment,t),c(T.$$.fragment,t),c(U.$$.fragment,t),c(x.$$.fragment,t),c(C.$$.fragment,t),c(W.$$.fragment,t),c(A.$$.fragment,t),c(E.$$.fragment,t),c(N.$$.fragment,t),c(X.$$.fragment,t),c(R.$$.fragment,t),jt=!0)},o(t){g(j.$$.fragment,t),g(y.$$.fragment,t),g(J.$$.fragment,t),g(T.$$.fragment,t),g(U.$$.fragment,t),g(x.$$.fragment,t),g(C.$$.fragment,t),g(W.$$.fragment,t),g(A.$$.fragment,t),g(E.$$.fragment,t),g(N.$$.fragment,t),g(X.$$.fragment,t),g(R.$$.fragment,t),jt=!1},d(t){t&&(e(z),e(Y),e(S),e(H),e(F),e(u),e(D),e(f),e(L),e(q),e(w),e(P),e(K),e(b),e(O),e(tt),e($),e(st),e(et),e(Z),e(at),e(lt),e(I),e(nt),e(k),e(pt),e(it),e(G),e(mt),e(ot),e(B),e(rt),e(ct),e(v),e(gt),e(ht),e(Mt),e(dt),e(_)),e(d),h(j,t),h(y,t),h(J,t),h(T,t),h(U,t),h(x,t),h(C,t),h(W,t),h(A,t),h(E,t),h(N,t),h(X,t),h(R,t)}}}const Yt='{"title":"Deep Layer Aggregation","local":"deep-layer-aggregation","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function _t(yt){return At(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends Bt{constructor(d){super(),Et(this,d,_t,Qt,Wt,{})}}export{Ft as component};
