import{s as Gt,n as It,o as Wt}from"../chunks/scheduler.0b596ca5.js";import{S as Bt,i as Et,e as p,s as a,c as m,h as Qt,a as i,d as e,b as n,f as Nt,g as o,j as y,k as xt,l as vt,m as l,n as r,t as h,o as c,p as M}from"../chunks/index.d9d53bd3.js";import{C as Rt,H as A,E as Xt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as _}from"../chunks/CodeBlock.9f18e41e.js";function _t(jt){let g,S,V,H,d,z,j,F,u,ut='A <strong>Dual Path Network (DPN)</strong> is a convolutional neural network which presents a new topology of connection paths internally. The intuition is that <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNets</a> enables feature re-usage while DenseNet enables new feature exploration, and both are important for learning good representations. To enjoy the benefits from both path topologies, Dual Path Networks share common features while maintaining the flexibility to explore new features through dual path architectures.',D,w,wt='The principal building block is an <a href="https://paperswithcode.com/method/dpn-block" rel="nofollow">DPN Block</a>.',P,f,L,J,ft="To load a pretrained model:",q,b,K,T,Jt="To load and preprocess the image:",O,U,tt,$,bt="To get the model predictions:",st,C,et,k,Tt="To get the top-5 predictions class names:",lt,Z,at,N,Ut="Replace the model name with the variant you want to use, e.g. <code>dpn107</code>. You can find the IDs in the model summaries at the top of this page.",nt,x,$t='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',pt,G,it,I,Ct="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",mt,W,ot,B,kt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,rt,E,ht,Q,Zt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ct,v,Mt,R,yt,X,gt,Y,dt;return d=new Rt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new A({props:{title:"Dual Path Network (DPN)",local:"dual-path-network-dpn",headingTag:"h1"}}),f=new A({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),b=new _({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2RwbjEwNyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;dpn107&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),U=new _({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),C=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new _({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),G=new A({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),W=new _({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZHBuMTA3JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;dpn107&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),E=new A({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),v=new A({props:{title:"Citation",local:"citation",headingTag:"h2"}}),R=new _({props:{code:"JTQwbWlzYyU3QmNoZW4yMDE3ZHVhbCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCRHVhbCUyMFBhdGglMjBOZXR3b3JrcyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3Qll1bnBlbmclMjBDaGVuJTIwYW5kJTIwSmlhbmFuJTIwTGklMjBhbmQlMjBIdWF4aW4lMjBYaWFvJTIwYW5kJTIwWGlhb2ppZSUyMEppbiUyMGFuZCUyMFNodWljaGVuZyUyMFlhbiUyMGFuZCUyMEppYXNoaSUyMEZlbmclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE3MDcuMDE2MjklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{chen2017dual,
      title={Dual Path Networks}, 
      author={Yunpeng Chen <span class="hljs-keyword">and </span><span class="hljs-keyword">Jianan </span>Li <span class="hljs-keyword">and </span>Huaxin Xiao <span class="hljs-keyword">and </span>Xiaojie <span class="hljs-keyword">Jin </span><span class="hljs-keyword">and </span><span class="hljs-keyword">Shuicheng </span>Yan <span class="hljs-keyword">and </span><span class="hljs-keyword">Jiashi </span>Feng},
      year={<span class="hljs-number">2017</span>},
      eprint={<span class="hljs-number">1707</span>.<span class="hljs-number">01629</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),X=new Xt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/dpn.mdx"}}),{c(){g=p("meta"),S=a(),V=p("p"),H=a(),m(d.$$.fragment),z=a(),m(j.$$.fragment),F=a(),u=p("p"),u.innerHTML=ut,D=a(),w=p("p"),w.innerHTML=wt,P=a(),m(f.$$.fragment),L=a(),J=p("p"),J.textContent=ft,q=a(),m(b.$$.fragment),K=a(),T=p("p"),T.textContent=Jt,O=a(),m(U.$$.fragment),tt=a(),$=p("p"),$.textContent=bt,st=a(),m(C.$$.fragment),et=a(),k=p("p"),k.textContent=Tt,lt=a(),m(Z.$$.fragment),at=a(),N=p("p"),N.innerHTML=Ut,nt=a(),x=p("p"),x.innerHTML=$t,pt=a(),m(G.$$.fragment),it=a(),I=p("p"),I.textContent=Ct,mt=a(),m(W.$$.fragment),ot=a(),B=p("p"),B.innerHTML=kt,rt=a(),m(E.$$.fragment),ht=a(),Q=p("p"),Q.innerHTML=Zt,ct=a(),m(v.$$.fragment),Mt=a(),m(R.$$.fragment),yt=a(),m(X.$$.fragment),gt=a(),Y=p("p"),this.h()},l(t){const s=Qt("svelte-u9bgzb",document.head);g=i(s,"META",{name:!0,content:!0}),s.forEach(e),S=n(t),V=i(t,"P",{}),Nt(V).forEach(e),H=n(t),o(d.$$.fragment,t),z=n(t),o(j.$$.fragment,t),F=n(t),u=i(t,"P",{"data-svelte-h":!0}),y(u)!=="svelte-1vp7kec"&&(u.innerHTML=ut),D=n(t),w=i(t,"P",{"data-svelte-h":!0}),y(w)!=="svelte-34uoom"&&(w.innerHTML=wt),P=n(t),o(f.$$.fragment,t),L=n(t),J=i(t,"P",{"data-svelte-h":!0}),y(J)!=="svelte-18ywhxh"&&(J.textContent=ft),q=n(t),o(b.$$.fragment,t),K=n(t),T=i(t,"P",{"data-svelte-h":!0}),y(T)!=="svelte-1c2ipa8"&&(T.textContent=Jt),O=n(t),o(U.$$.fragment,t),tt=n(t),$=i(t,"P",{"data-svelte-h":!0}),y($)!=="svelte-1n9qsq1"&&($.textContent=bt),st=n(t),o(C.$$.fragment,t),et=n(t),k=i(t,"P",{"data-svelte-h":!0}),y(k)!=="svelte-19cnvx1"&&(k.textContent=Tt),lt=n(t),o(Z.$$.fragment,t),at=n(t),N=i(t,"P",{"data-svelte-h":!0}),y(N)!=="svelte-1lx1824"&&(N.innerHTML=Ut),nt=n(t),x=i(t,"P",{"data-svelte-h":!0}),y(x)!=="svelte-1wmi3ea"&&(x.innerHTML=$t),pt=n(t),o(G.$$.fragment,t),it=n(t),I=i(t,"P",{"data-svelte-h":!0}),y(I)!=="svelte-9sr7nh"&&(I.textContent=Ct),mt=n(t),o(W.$$.fragment,t),ot=n(t),B=i(t,"P",{"data-svelte-h":!0}),y(B)!=="svelte-1kguc51"&&(B.innerHTML=kt),rt=n(t),o(E.$$.fragment,t),ht=n(t),Q=i(t,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-xtxxu6"&&(Q.innerHTML=Zt),ct=n(t),o(v.$$.fragment,t),Mt=n(t),o(R.$$.fragment,t),yt=n(t),o(X.$$.fragment,t),gt=n(t),Y=i(t,"P",{}),Nt(Y).forEach(e),this.h()},h(){xt(g,"name","hf:doc:metadata"),xt(g,"content",Vt)},m(t,s){vt(document.head,g),l(t,S,s),l(t,V,s),l(t,H,s),r(d,t,s),l(t,z,s),r(j,t,s),l(t,F,s),l(t,u,s),l(t,D,s),l(t,w,s),l(t,P,s),r(f,t,s),l(t,L,s),l(t,J,s),l(t,q,s),r(b,t,s),l(t,K,s),l(t,T,s),l(t,O,s),r(U,t,s),l(t,tt,s),l(t,$,s),l(t,st,s),r(C,t,s),l(t,et,s),l(t,k,s),l(t,lt,s),r(Z,t,s),l(t,at,s),l(t,N,s),l(t,nt,s),l(t,x,s),l(t,pt,s),r(G,t,s),l(t,it,s),l(t,I,s),l(t,mt,s),r(W,t,s),l(t,ot,s),l(t,B,s),l(t,rt,s),r(E,t,s),l(t,ht,s),l(t,Q,s),l(t,ct,s),r(v,t,s),l(t,Mt,s),r(R,t,s),l(t,yt,s),r(X,t,s),l(t,gt,s),l(t,Y,s),dt=!0},p:It,i(t){dt||(h(d.$$.fragment,t),h(j.$$.fragment,t),h(f.$$.fragment,t),h(b.$$.fragment,t),h(U.$$.fragment,t),h(C.$$.fragment,t),h(Z.$$.fragment,t),h(G.$$.fragment,t),h(W.$$.fragment,t),h(E.$$.fragment,t),h(v.$$.fragment,t),h(R.$$.fragment,t),h(X.$$.fragment,t),dt=!0)},o(t){c(d.$$.fragment,t),c(j.$$.fragment,t),c(f.$$.fragment,t),c(b.$$.fragment,t),c(U.$$.fragment,t),c(C.$$.fragment,t),c(Z.$$.fragment,t),c(G.$$.fragment,t),c(W.$$.fragment,t),c(E.$$.fragment,t),c(v.$$.fragment,t),c(R.$$.fragment,t),c(X.$$.fragment,t),dt=!1},d(t){t&&(e(S),e(V),e(H),e(z),e(F),e(u),e(D),e(w),e(P),e(L),e(J),e(q),e(K),e(T),e(O),e(tt),e($),e(st),e(et),e(k),e(lt),e(at),e(N),e(nt),e(x),e(pt),e(it),e(I),e(mt),e(ot),e(B),e(rt),e(ht),e(Q),e(ct),e(Mt),e(yt),e(gt),e(Y)),e(g),M(d,t),M(j,t),M(f,t),M(b,t),M(U,t),M(C,t),M(Z,t),M(G,t),M(W,t),M(E,t),M(v,t),M(R,t),M(X,t)}}}const Vt='{"title":"Dual Path Network (DPN)","local":"dual-path-network-dpn","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Yt(jt){return Wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends Bt{constructor(g){super(),Et(this,g,Yt,_t,Gt,{})}}export{Ft as component};
