import{s as Zt,n as Wt,o as xt}from"../chunks/scheduler.0b596ca5.js";import{S as Gt,i as Nt,e as p,s as l,c as m,h as Bt,a as i,d as e,b as n,f as Ct,g as o,j as g,k as It,l as kt,m as a,n as c,t as r,o as h,p as M}from"../chunks/index.d9d53bd3.js";import{C as Et,H as z,E as Qt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as R}from"../chunks/CodeBlock.9f18e41e.js";function vt(dt){let d,Y,X,A,y,S,J,H,w,yt='An <strong>ECA ResNet</strong> is a variant on a <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> that utilises an <a href="https://paperswithcode.com/method/efficient-channel-attention" rel="nofollow">Efficient Channel Attention module</a>. Efficient Channel Attention is an architectural unit based on <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a> that reduces model complexity without dimensionality reduction.',F,u,L,j,Jt="To load a pretrained model:",D,T,q,f,wt="To load and preprocess the image:",P,b,K,U,ut="To get the model predictions:",O,$,tt,C,jt="To get the top-5 predictions class names:",st,I,et,Z,Tt="Replace the model name with the variant you want to use, e.g. <code>ecaresnet101d</code>. You can find the IDs in the model summaries at the top of this page.",at,W,ft='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',lt,x,nt,G,bt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,N,mt,B,Ut=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,it,k,ot,E,$t='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ct,Q,rt,v,ht,V,Mt,_,gt;return y=new Et({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new z({props:{title:"ECA-ResNet",local:"eca-resnet",headingTag:"h1"}}),u=new z({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2VjYXJlc25ldDEwMWQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ecaresnet101d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),I=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),x=new z({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZWNhcmVzbmV0MTAxZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ecaresnet101d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),k=new z({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new z({props:{title:"Citation",local:"citation",headingTag:"h2"}}),v=new R({props:{code:"JTQwbWlzYyU3QndhbmcyMDIwZWNhbmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JFQ0EtTmV0JTNBJTIwRWZmaWNpZW50JTIwQ2hhbm5lbCUyMEF0dGVudGlvbiUyMGZvciUyMERlZXAlMjBDb252b2x1dGlvbmFsJTIwTmV1cmFsJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JRaWxvbmclMjBXYW5nJTIwYW5kJTIwQmFuZ2d1JTIwV3UlMjBhbmQlMjBQZW5nZmVpJTIwWmh1JTIwYW5kJTIwUGVpaHVhJTIwTGklMjBhbmQlMjBXYW5nbWVuZyUyMFp1byUyMGFuZCUyMFFpbmdodWElMjBIdSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTkxMC4wMzE1MSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{wang2020ecanet,
      title={ECA-Net: Efficient Channel Attention for Deep Convolutional Neural Networks}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Qilong Wang and Banggu Wu and Pengfei Zhu and Peihua Li and Wangmeng Zuo and Qinghua Hu}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1910.03151}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),V=new Qt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/ecaresnet.mdx"}}),{c(){d=p("meta"),Y=l(),X=p("p"),A=l(),m(y.$$.fragment),S=l(),m(J.$$.fragment),H=l(),w=p("p"),w.innerHTML=yt,F=l(),m(u.$$.fragment),L=l(),j=p("p"),j.textContent=Jt,D=l(),m(T.$$.fragment),q=l(),f=p("p"),f.textContent=wt,P=l(),m(b.$$.fragment),K=l(),U=p("p"),U.textContent=ut,O=l(),m($.$$.fragment),tt=l(),C=p("p"),C.textContent=jt,st=l(),m(I.$$.fragment),et=l(),Z=p("p"),Z.innerHTML=Tt,at=l(),W=p("p"),W.innerHTML=ft,lt=l(),m(x.$$.fragment),nt=l(),G=p("p"),G.textContent=bt,pt=l(),m(N.$$.fragment),mt=l(),B=p("p"),B.innerHTML=Ut,it=l(),m(k.$$.fragment),ot=l(),E=p("p"),E.innerHTML=$t,ct=l(),m(Q.$$.fragment),rt=l(),m(v.$$.fragment),ht=l(),m(V.$$.fragment),Mt=l(),_=p("p"),this.h()},l(t){const s=Bt("svelte-u9bgzb",document.head);d=i(s,"META",{name:!0,content:!0}),s.forEach(e),Y=n(t),X=i(t,"P",{}),Ct(X).forEach(e),A=n(t),o(y.$$.fragment,t),S=n(t),o(J.$$.fragment,t),H=n(t),w=i(t,"P",{"data-svelte-h":!0}),g(w)!=="svelte-1ly2dl5"&&(w.innerHTML=yt),F=n(t),o(u.$$.fragment,t),L=n(t),j=i(t,"P",{"data-svelte-h":!0}),g(j)!=="svelte-18ywhxh"&&(j.textContent=Jt),D=n(t),o(T.$$.fragment,t),q=n(t),f=i(t,"P",{"data-svelte-h":!0}),g(f)!=="svelte-1c2ipa8"&&(f.textContent=wt),P=n(t),o(b.$$.fragment,t),K=n(t),U=i(t,"P",{"data-svelte-h":!0}),g(U)!=="svelte-1n9qsq1"&&(U.textContent=ut),O=n(t),o($.$$.fragment,t),tt=n(t),C=i(t,"P",{"data-svelte-h":!0}),g(C)!=="svelte-19cnvx1"&&(C.textContent=jt),st=n(t),o(I.$$.fragment,t),et=n(t),Z=i(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-r0xl90"&&(Z.innerHTML=Tt),at=n(t),W=i(t,"P",{"data-svelte-h":!0}),g(W)!=="svelte-1wmi3ea"&&(W.innerHTML=ft),lt=n(t),o(x.$$.fragment,t),nt=n(t),G=i(t,"P",{"data-svelte-h":!0}),g(G)!=="svelte-9sr7nh"&&(G.textContent=bt),pt=n(t),o(N.$$.fragment,t),mt=n(t),B=i(t,"P",{"data-svelte-h":!0}),g(B)!=="svelte-1kguc51"&&(B.innerHTML=Ut),it=n(t),o(k.$$.fragment,t),ot=n(t),E=i(t,"P",{"data-svelte-h":!0}),g(E)!=="svelte-xtxxu6"&&(E.innerHTML=$t),ct=n(t),o(Q.$$.fragment,t),rt=n(t),o(v.$$.fragment,t),ht=n(t),o(V.$$.fragment,t),Mt=n(t),_=i(t,"P",{}),Ct(_).forEach(e),this.h()},h(){It(d,"name","hf:doc:metadata"),It(d,"content",Vt)},m(t,s){kt(document.head,d),a(t,Y,s),a(t,X,s),a(t,A,s),c(y,t,s),a(t,S,s),c(J,t,s),a(t,H,s),a(t,w,s),a(t,F,s),c(u,t,s),a(t,L,s),a(t,j,s),a(t,D,s),c(T,t,s),a(t,q,s),a(t,f,s),a(t,P,s),c(b,t,s),a(t,K,s),a(t,U,s),a(t,O,s),c($,t,s),a(t,tt,s),a(t,C,s),a(t,st,s),c(I,t,s),a(t,et,s),a(t,Z,s),a(t,at,s),a(t,W,s),a(t,lt,s),c(x,t,s),a(t,nt,s),a(t,G,s),a(t,pt,s),c(N,t,s),a(t,mt,s),a(t,B,s),a(t,it,s),c(k,t,s),a(t,ot,s),a(t,E,s),a(t,ct,s),c(Q,t,s),a(t,rt,s),c(v,t,s),a(t,ht,s),c(V,t,s),a(t,Mt,s),a(t,_,s),gt=!0},p:Wt,i(t){gt||(r(y.$$.fragment,t),r(J.$$.fragment,t),r(u.$$.fragment,t),r(T.$$.fragment,t),r(b.$$.fragment,t),r($.$$.fragment,t),r(I.$$.fragment,t),r(x.$$.fragment,t),r(N.$$.fragment,t),r(k.$$.fragment,t),r(Q.$$.fragment,t),r(v.$$.fragment,t),r(V.$$.fragment,t),gt=!0)},o(t){h(y.$$.fragment,t),h(J.$$.fragment,t),h(u.$$.fragment,t),h(T.$$.fragment,t),h(b.$$.fragment,t),h($.$$.fragment,t),h(I.$$.fragment,t),h(x.$$.fragment,t),h(N.$$.fragment,t),h(k.$$.fragment,t),h(Q.$$.fragment,t),h(v.$$.fragment,t),h(V.$$.fragment,t),gt=!1},d(t){t&&(e(Y),e(X),e(A),e(S),e(H),e(w),e(F),e(L),e(j),e(D),e(q),e(f),e(P),e(K),e(U),e(O),e(tt),e(C),e(st),e(et),e(Z),e(at),e(W),e(lt),e(nt),e(G),e(pt),e(mt),e(B),e(it),e(ot),e(E),e(ct),e(rt),e(ht),e(Mt),e(_)),e(d),M(y,t),M(J,t),M(u,t),M(T,t),M(b,t),M($,t),M(I,t),M(x,t),M(N,t),M(k,t),M(Q,t),M(v,t),M(V,t)}}}const Vt='{"title":"ECA-ResNet","local":"eca-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Rt(dt){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends Gt{constructor(d){super(),Nt(this,d,Rt,vt,Zt,{})}}export{At as component};
