import{s as xl,n as vl,o as El}from"../chunks/scheduler.0b596ca5.js";import{S as Ql,i as Yl,e as M,s as e,c as J,h as Nl,a as p,d as a,b as n,f as $l,g as i,j,k as Gl,l as Rl,m as t,n as m,t as w,o as T,p as o}from"../chunks/index.d9d53bd3.js";import{C as Xl,H as S,E as _l}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as X}from"../chunks/CodeBlock.9f18e41e.js";function Vl(Il){let r,F,_,H,y,z,c,L,h,dl='<strong>Inception-ResNet-v2</strong> is a convolutional neural architecture that builds on the Inception family of architectures but incorporates <a href="https://paperswithcode.com/method/residual-connection" rel="nofollow">residual connections</a> (replacing the filter concatenation stage of the Inception architecture).',D,I,Ul="This particular model was trained for study of adversarial examples (adversarial training).",P,d,ul='The weights from this model were ported from <a href="https://github.com/tensorflow/models" rel="nofollow">Tensorflow/Models</a>.',q,U,K,u,gl="To load a pretrained model:",O,g,ll,b,bl="To load and preprocess the image:",sl,A,al,C,Al="To get the model predictions:",tl,f,el,k,Cl="To get the top-5 predictions class names:",nl,B,Ml,W,fl="Replace the model name with the variant you want to use, e.g. <code>ens_adv_inception_resnet_v2</code>. You can find the IDs in the model summaries at the top of this page.",pl,Z,kl='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',Jl,$,il,G,Bl="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ml,x,wl,v,Wl=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Tl,E,ol,Q,Zl='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',jl,Y,rl,N,yl,R,cl,V,hl;return y=new Xl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),c=new S({props:{title:"# Ensemble Adversarial Inception ResNet v2",local:"-ensemble-adversarial-inception-resnet-v2",headingTag:"h1"}}),U=new S({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),g=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2Vuc19hZHZfaW5jZXB0aW9uX3Jlc25ldF92MiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ens_adv_inception_resnet_v2&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),A=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),f=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),B=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),$=new S({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),x=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZW5zX2Fkdl9pbmNlcHRpb25fcmVzbmV0X3YyJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ens_adv_inception_resnet_v2&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),E=new S({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Y=new S({props:{title:"Citation",local:"citation",headingTag:"h2"}}),N=new X({props:{code:"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",highlighted:`<span class="hljs-comment">@article{DBLP:journals/corr/abs-1804-00097,</span>
  author    = {Alexey Kurakin <span class="hljs-keyword">and</span>
               Ian J. Goodfellow <span class="hljs-keyword">and</span>
               Samy Bengio <span class="hljs-keyword">and</span>
               Yinpeng Dong <span class="hljs-keyword">and</span>
               Fangzhou Liao <span class="hljs-keyword">and</span>
               Ming Liang <span class="hljs-keyword">and</span>
               Tianyu Pang <span class="hljs-keyword">and</span>
               Jun Zhu <span class="hljs-keyword">and</span>
               Xiaolin Hu <span class="hljs-keyword">and</span>
               Cihang Xie <span class="hljs-keyword">and</span>
               Jianyu Wang <span class="hljs-keyword">and</span>
               Zhishuai Zhang <span class="hljs-keyword">and</span>
               Zhou Ren <span class="hljs-keyword">and</span>
               Alan L. Yuille <span class="hljs-keyword">and</span>
               Sangxia Huang <span class="hljs-keyword">and</span>
               Yao Zhao <span class="hljs-keyword">and</span>
               Yuzhe Zhao <span class="hljs-keyword">and</span>
               Zhonglin Han <span class="hljs-keyword">and</span>
               Junjiajia Long <span class="hljs-keyword">and</span>
               Yerkebulan Berdibekov <span class="hljs-keyword">and</span>
               Takuya Akiba <span class="hljs-keyword">and</span>
               Seiya Tokui <span class="hljs-keyword">and</span>
               Motoki Abe},
  title     = {Adversarial Attacks <span class="hljs-keyword">and</span> Defences Competition},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1804</span>.<span class="hljs-number">00097</span>},
  year      = {<span class="hljs-number">2018</span>},
  url       = {http:<span class="hljs-comment">//arxiv.org/abs/1804.00097},</span>
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1804</span>.<span class="hljs-number">00097</span>},
  timestamp = {Thu, <span class="hljs-number">31</span> Oct <span class="hljs-number">2019</span> <span class="hljs-number">16</span>:<span class="hljs-number">31</span>:<span class="hljs-number">22</span> +<span class="hljs-number">0100</span>},
  biburl    = {https:<span class="hljs-comment">//dblp.org/rec/journals/corr/abs-1804-00097.bib},</span>
  bibsource = {dblp computer science bibliography, https:<span class="hljs-comment">//dblp.org}</span>
}`,wrap:!1}}),R=new _l({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/ensemble-adversarial.mdx"}}),{c(){r=M("meta"),F=e(),_=M("p"),H=e(),J(y.$$.fragment),z=e(),J(c.$$.fragment),L=e(),h=M("p"),h.innerHTML=dl,D=e(),I=M("p"),I.textContent=Ul,P=e(),d=M("p"),d.innerHTML=ul,q=e(),J(U.$$.fragment),K=e(),u=M("p"),u.textContent=gl,O=e(),J(g.$$.fragment),ll=e(),b=M("p"),b.textContent=bl,sl=e(),J(A.$$.fragment),al=e(),C=M("p"),C.textContent=Al,tl=e(),J(f.$$.fragment),el=e(),k=M("p"),k.textContent=Cl,nl=e(),J(B.$$.fragment),Ml=e(),W=M("p"),W.innerHTML=fl,pl=e(),Z=M("p"),Z.innerHTML=kl,Jl=e(),J($.$$.fragment),il=e(),G=M("p"),G.textContent=Bl,ml=e(),J(x.$$.fragment),wl=e(),v=M("p"),v.innerHTML=Wl,Tl=e(),J(E.$$.fragment),ol=e(),Q=M("p"),Q.innerHTML=Zl,jl=e(),J(Y.$$.fragment),rl=e(),J(N.$$.fragment),yl=e(),J(R.$$.fragment),cl=e(),V=M("p"),this.h()},l(l){const s=Nl("svelte-u9bgzb",document.head);r=p(s,"META",{name:!0,content:!0}),s.forEach(a),F=n(l),_=p(l,"P",{}),$l(_).forEach(a),H=n(l),i(y.$$.fragment,l),z=n(l),i(c.$$.fragment,l),L=n(l),h=p(l,"P",{"data-svelte-h":!0}),j(h)!=="svelte-gd1at0"&&(h.innerHTML=dl),D=n(l),I=p(l,"P",{"data-svelte-h":!0}),j(I)!=="svelte-1fjxi1n"&&(I.textContent=Ul),P=n(l),d=p(l,"P",{"data-svelte-h":!0}),j(d)!=="svelte-1nh6o5x"&&(d.innerHTML=ul),q=n(l),i(U.$$.fragment,l),K=n(l),u=p(l,"P",{"data-svelte-h":!0}),j(u)!=="svelte-18ywhxh"&&(u.textContent=gl),O=n(l),i(g.$$.fragment,l),ll=n(l),b=p(l,"P",{"data-svelte-h":!0}),j(b)!=="svelte-1c2ipa8"&&(b.textContent=bl),sl=n(l),i(A.$$.fragment,l),al=n(l),C=p(l,"P",{"data-svelte-h":!0}),j(C)!=="svelte-1n9qsq1"&&(C.textContent=Al),tl=n(l),i(f.$$.fragment,l),el=n(l),k=p(l,"P",{"data-svelte-h":!0}),j(k)!=="svelte-19cnvx1"&&(k.textContent=Cl),nl=n(l),i(B.$$.fragment,l),Ml=n(l),W=p(l,"P",{"data-svelte-h":!0}),j(W)!=="svelte-mhe8ax"&&(W.innerHTML=fl),pl=n(l),Z=p(l,"P",{"data-svelte-h":!0}),j(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=kl),Jl=n(l),i($.$$.fragment,l),il=n(l),G=p(l,"P",{"data-svelte-h":!0}),j(G)!=="svelte-9sr7nh"&&(G.textContent=Bl),ml=n(l),i(x.$$.fragment,l),wl=n(l),v=p(l,"P",{"data-svelte-h":!0}),j(v)!=="svelte-1kguc51"&&(v.innerHTML=Wl),Tl=n(l),i(E.$$.fragment,l),ol=n(l),Q=p(l,"P",{"data-svelte-h":!0}),j(Q)!=="svelte-xtxxu6"&&(Q.innerHTML=Zl),jl=n(l),i(Y.$$.fragment,l),rl=n(l),i(N.$$.fragment,l),yl=n(l),i(R.$$.fragment,l),cl=n(l),V=p(l,"P",{}),$l(V).forEach(a),this.h()},h(){Gl(r,"name","hf:doc:metadata"),Gl(r,"content",Sl)},m(l,s){Rl(document.head,r),t(l,F,s),t(l,_,s),t(l,H,s),m(y,l,s),t(l,z,s),m(c,l,s),t(l,L,s),t(l,h,s),t(l,D,s),t(l,I,s),t(l,P,s),t(l,d,s),t(l,q,s),m(U,l,s),t(l,K,s),t(l,u,s),t(l,O,s),m(g,l,s),t(l,ll,s),t(l,b,s),t(l,sl,s),m(A,l,s),t(l,al,s),t(l,C,s),t(l,tl,s),m(f,l,s),t(l,el,s),t(l,k,s),t(l,nl,s),m(B,l,s),t(l,Ml,s),t(l,W,s),t(l,pl,s),t(l,Z,s),t(l,Jl,s),m($,l,s),t(l,il,s),t(l,G,s),t(l,ml,s),m(x,l,s),t(l,wl,s),t(l,v,s),t(l,Tl,s),m(E,l,s),t(l,ol,s),t(l,Q,s),t(l,jl,s),m(Y,l,s),t(l,rl,s),m(N,l,s),t(l,yl,s),m(R,l,s),t(l,cl,s),t(l,V,s),hl=!0},p:vl,i(l){hl||(w(y.$$.fragment,l),w(c.$$.fragment,l),w(U.$$.fragment,l),w(g.$$.fragment,l),w(A.$$.fragment,l),w(f.$$.fragment,l),w(B.$$.fragment,l),w($.$$.fragment,l),w(x.$$.fragment,l),w(E.$$.fragment,l),w(Y.$$.fragment,l),w(N.$$.fragment,l),w(R.$$.fragment,l),hl=!0)},o(l){T(y.$$.fragment,l),T(c.$$.fragment,l),T(U.$$.fragment,l),T(g.$$.fragment,l),T(A.$$.fragment,l),T(f.$$.fragment,l),T(B.$$.fragment,l),T($.$$.fragment,l),T(x.$$.fragment,l),T(E.$$.fragment,l),T(Y.$$.fragment,l),T(N.$$.fragment,l),T(R.$$.fragment,l),hl=!1},d(l){l&&(a(F),a(_),a(H),a(z),a(L),a(h),a(D),a(I),a(P),a(d),a(q),a(K),a(u),a(O),a(ll),a(b),a(sl),a(al),a(C),a(tl),a(el),a(k),a(nl),a(Ml),a(W),a(pl),a(Z),a(Jl),a(il),a(G),a(ml),a(wl),a(v),a(Tl),a(ol),a(Q),a(jl),a(rl),a(yl),a(cl),a(V)),a(r),o(y,l),o(c,l),o(U,l),o(g,l),o(A,l),o(f,l),o(B,l),o($,l),o(x,l),o(E,l),o(Y,l),o(N,l),o(R,l)}}}const Sl='{"title":"# Ensemble Adversarial Inception ResNet v2","local":"-ensemble-adversarial-inception-resnet-v2","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Fl(Il){return El(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pl extends Ql{constructor(r){super(),Yl(this,r,Fl,Vl,xl,{})}}export{Pl as component};
