import{s as Bt,n as Nt,o as xt}from"../chunks/scheduler.0b596ca5.js";import{S as Gt,i as vt,e as p,s as a,c as i,h as Et,a as m,d as e,b as n,f as It,g as o,j as g,k as Wt,l as Vt,m as l,n as r,t as c,o as h,p as M}from"../chunks/index.d9d53bd3.js";import{C as Qt,H as Y,E as _t}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.b5656fd4.js";import{C as X}from"../chunks/CodeBlock.9f18e41e.js";function Xt(wt){let j,z,R,S,d,H,w,F,y,yt='<strong>VoVNet</strong> is a convolutional neural network that seeks to make <a href="https://paperswithcode.com/method/densenet" rel="nofollow">DenseNet</a> more efficient by concatenating all features only once in the last feature map, which makes input size constant and enables enlarging new output channel.',L,J,Jt='Read about <a href="https://paperswithcode.com/method/one-shot-aggregation" rel="nofollow">one-shot aggregation here</a>.',D,u,P,f,ut="To load a pretrained model:",q,T,K,b,ft="To load and preprocess the image:",O,U,tt,$,Tt="To get the model predictions:",st,Z,et,k,bt="To get the top-5 predictions class names:",lt,C,at,I,Ut="Replace the model name with the variant you want to use, e.g. <code>ese_vovnet19b_dw</code>. You can find the IDs in the model summaries at the top of this page.",nt,W,$t='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',pt,B,mt,N,Zt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",it,x,ot,G,kt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,rt,v,ct,E,Ct='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ht,V,Mt,Q,gt,_,jt,A,dt;return d=new Qt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new Y({props:{title:"ESE-VoVNet",local:"ese-vovnet",headingTag:"h1"}}),u=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2VzZV92b3ZuZXQxOWJfZHcnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ese_vovnet19b_dw&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),U=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),Z=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),B=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),x=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZXNlX3Zvdm5ldDE5Yl9kdyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ese_vovnet19b_dw&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),v=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),V=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new X({props:{code:"JTQwbWlzYyU3QmxlZTIwMTllbmVyZ3klMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkFuJTIwRW5lcmd5JTIwYW5kJTIwR1BVLUNvbXB1dGF0aW9uJTIwRWZmaWNpZW50JTIwQmFja2JvbmUlMjBOZXR3b3JrJTIwZm9yJTIwUmVhbC1UaW1lJTIwT2JqZWN0JTIwRGV0ZWN0aW9uJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCWW91bmd3YW4lMjBMZWUlMjBhbmQlMjBKb29uZy13b24lMjBId2FuZyUyMGFuZCUyMFNhbmdyb2slMjBMZWUlMjBhbmQlMjBZdXNlb2slMjBCYWUlMjBhbmQlMjBKb25neW91bCUyMFBhcmslN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE5MDQuMDk3MzAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{lee2019energy,
      title={An Energy <span class="hljs-keyword">and </span>GPU-Computation Efficient <span class="hljs-keyword">Backbone </span>Network for Real-Time Object Detection}, 
      author={Youngwan Lee <span class="hljs-keyword">and </span><span class="hljs-keyword">Joong-won </span>Hwang <span class="hljs-keyword">and </span>Sangrok Lee <span class="hljs-keyword">and </span>Yuseok <span class="hljs-keyword">Bae </span><span class="hljs-keyword">and </span><span class="hljs-keyword">Jongyoul </span>Park},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1904</span>.<span class="hljs-number">09730</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),_=new _t({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/ese-vovnet.mdx"}}),{c(){j=p("meta"),z=a(),R=p("p"),S=a(),i(d.$$.fragment),H=a(),i(w.$$.fragment),F=a(),y=p("p"),y.innerHTML=yt,L=a(),J=p("p"),J.innerHTML=Jt,D=a(),i(u.$$.fragment),P=a(),f=p("p"),f.textContent=ut,q=a(),i(T.$$.fragment),K=a(),b=p("p"),b.textContent=ft,O=a(),i(U.$$.fragment),tt=a(),$=p("p"),$.textContent=Tt,st=a(),i(Z.$$.fragment),et=a(),k=p("p"),k.textContent=bt,lt=a(),i(C.$$.fragment),at=a(),I=p("p"),I.innerHTML=Ut,nt=a(),W=p("p"),W.innerHTML=$t,pt=a(),i(B.$$.fragment),mt=a(),N=p("p"),N.textContent=Zt,it=a(),i(x.$$.fragment),ot=a(),G=p("p"),G.innerHTML=kt,rt=a(),i(v.$$.fragment),ct=a(),E=p("p"),E.innerHTML=Ct,ht=a(),i(V.$$.fragment),Mt=a(),i(Q.$$.fragment),gt=a(),i(_.$$.fragment),jt=a(),A=p("p"),this.h()},l(t){const s=Et("svelte-u9bgzb",document.head);j=m(s,"META",{name:!0,content:!0}),s.forEach(e),z=n(t),R=m(t,"P",{}),It(R).forEach(e),S=n(t),o(d.$$.fragment,t),H=n(t),o(w.$$.fragment,t),F=n(t),y=m(t,"P",{"data-svelte-h":!0}),g(y)!=="svelte-13oc2jm"&&(y.innerHTML=yt),L=n(t),J=m(t,"P",{"data-svelte-h":!0}),g(J)!=="svelte-1ajn3h8"&&(J.innerHTML=Jt),D=n(t),o(u.$$.fragment,t),P=n(t),f=m(t,"P",{"data-svelte-h":!0}),g(f)!=="svelte-18ywhxh"&&(f.textContent=ut),q=n(t),o(T.$$.fragment,t),K=n(t),b=m(t,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1c2ipa8"&&(b.textContent=ft),O=n(t),o(U.$$.fragment,t),tt=n(t),$=m(t,"P",{"data-svelte-h":!0}),g($)!=="svelte-1n9qsq1"&&($.textContent=Tt),st=n(t),o(Z.$$.fragment,t),et=n(t),k=m(t,"P",{"data-svelte-h":!0}),g(k)!=="svelte-19cnvx1"&&(k.textContent=bt),lt=n(t),o(C.$$.fragment,t),at=n(t),I=m(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-yryjra"&&(I.innerHTML=Ut),nt=n(t),W=m(t,"P",{"data-svelte-h":!0}),g(W)!=="svelte-1wmi3ea"&&(W.innerHTML=$t),pt=n(t),o(B.$$.fragment,t),mt=n(t),N=m(t,"P",{"data-svelte-h":!0}),g(N)!=="svelte-9sr7nh"&&(N.textContent=Zt),it=n(t),o(x.$$.fragment,t),ot=n(t),G=m(t,"P",{"data-svelte-h":!0}),g(G)!=="svelte-1kguc51"&&(G.innerHTML=kt),rt=n(t),o(v.$$.fragment,t),ct=n(t),E=m(t,"P",{"data-svelte-h":!0}),g(E)!=="svelte-xtxxu6"&&(E.innerHTML=Ct),ht=n(t),o(V.$$.fragment,t),Mt=n(t),o(Q.$$.fragment,t),gt=n(t),o(_.$$.fragment,t),jt=n(t),A=m(t,"P",{}),It(A).forEach(e),this.h()},h(){Wt(j,"name","hf:doc:metadata"),Wt(j,"content",Rt)},m(t,s){Vt(document.head,j),l(t,z,s),l(t,R,s),l(t,S,s),r(d,t,s),l(t,H,s),r(w,t,s),l(t,F,s),l(t,y,s),l(t,L,s),l(t,J,s),l(t,D,s),r(u,t,s),l(t,P,s),l(t,f,s),l(t,q,s),r(T,t,s),l(t,K,s),l(t,b,s),l(t,O,s),r(U,t,s),l(t,tt,s),l(t,$,s),l(t,st,s),r(Z,t,s),l(t,et,s),l(t,k,s),l(t,lt,s),r(C,t,s),l(t,at,s),l(t,I,s),l(t,nt,s),l(t,W,s),l(t,pt,s),r(B,t,s),l(t,mt,s),l(t,N,s),l(t,it,s),r(x,t,s),l(t,ot,s),l(t,G,s),l(t,rt,s),r(v,t,s),l(t,ct,s),l(t,E,s),l(t,ht,s),r(V,t,s),l(t,Mt,s),r(Q,t,s),l(t,gt,s),r(_,t,s),l(t,jt,s),l(t,A,s),dt=!0},p:Nt,i(t){dt||(c(d.$$.fragment,t),c(w.$$.fragment,t),c(u.$$.fragment,t),c(T.$$.fragment,t),c(U.$$.fragment,t),c(Z.$$.fragment,t),c(C.$$.fragment,t),c(B.$$.fragment,t),c(x.$$.fragment,t),c(v.$$.fragment,t),c(V.$$.fragment,t),c(Q.$$.fragment,t),c(_.$$.fragment,t),dt=!0)},o(t){h(d.$$.fragment,t),h(w.$$.fragment,t),h(u.$$.fragment,t),h(T.$$.fragment,t),h(U.$$.fragment,t),h(Z.$$.fragment,t),h(C.$$.fragment,t),h(B.$$.fragment,t),h(x.$$.fragment,t),h(v.$$.fragment,t),h(V.$$.fragment,t),h(Q.$$.fragment,t),h(_.$$.fragment,t),dt=!1},d(t){t&&(e(z),e(R),e(S),e(H),e(F),e(y),e(L),e(J),e(D),e(P),e(f),e(q),e(K),e(b),e(O),e(tt),e($),e(st),e(et),e(k),e(lt),e(at),e(I),e(nt),e(W),e(pt),e(mt),e(N),e(it),e(ot),e(G),e(rt),e(ct),e(E),e(ht),e(Mt),e(gt),e(jt),e(A)),e(j),M(d,t),M(w,t),M(u,t),M(T,t),M(U,t),M(Z,t),M(C,t),M(B,t),M(x,t),M(v,t),M(V,t),M(Q,t),M(_,t)}}}const Rt='{"title":"ESE-VoVNet","local":"ese-vovnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function At(wt){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends Gt{constructor(j){super(),vt(this,j,At,Xt,Bt,{})}}export{Ft as component};
